#declare tire = difference
{
        cylinder
        {
                <0, 0, -1 ><0, 0, 1 >, 1
        }
        cylinder
        {
                <0, 0, -1 ><0, 0, 1 >, 1
                scale< 0.9, 0.9, 2 >
        }
}

#declare thick_tire = difference
{
        cylinder
        {
                <0, 0, -1 ><0, 0, 1 >, 1
        }
        cylinder
        {
                <0, 0, -1 ><0, 0, 1 >, 1
                scale< 0.75, 0.75, 2 >
        }
}

#declare wheel = union
{
        object
        {
                thick_tire
                scale< 0.7, 0.7, 1 >
                texture{ redwood_tex }
        }                   
        object
        {
                tire
                scale< 5, 5, 0.5 >        
                texture{ redwood_tex }
        }
        object
        {
                tire
                scale< 5.5, 5.5, 0.4 >        
                texture{ steel_tex }
        }                   
        object
        {
                thick_tire      
                scale< 6.1, 6.1, 0.15 >
                translate< 0, 0, 0.4 >
                texture{ steel_tex }
        } 
#declare rot = 0;
#while( rot < 356 )
        cylinder
        {
                <0, 0, 0 ><0, 1, 0 >, 1
                scale< 0.25, 4, 0.5 > 
                translate< 0, 0.5, 0 >
                texture{ redwood_tex }
                rotate< 0, 0, rot >
#declare rot = rot + 45;
        }
#end
}

#declare axis/*of evil*/ = union
{
        object
        {
                wheel
                translate< 0, 0, -10 >
        }
        object
        {
                wheel
                rotate< 0, 180, 0 >
                translate< 0, 0, 10 >
        }            
        cylinder
        {
                <0, 0, -1 >< 0, 0, 1 >,1
                scale< 0.5, 0.5, 11.5 >
                texture{ iron_tex }
        }
}

#declare train_socket = union
{
        difference
        {
                cylinder
                {
                        <0, 0, -1 ><0, 0, 1 >, 1
                }
                box
                {
                        <-1, -1, -1 >< 1, 0, 1 >
                        scale< 1.1, 1.1, 1.1 >
                }
                scale< 7, 7, 12 > 
        }
#declare rot2 = 5;
#while( rot2 < 180 )
        union
        {
                sphere
                {
                        <0, 0, 0 >, 1                  
                        scale< 0.2, 0.2, 0.2 >
                        translate< 0, 0, 11.9 >
                }
                sphere
                {
                        <0, 0, 0 >, 1         
                        scale< 0.2, 0.2, 0.2 >
                        translate< 0, 0, -11.9 >          
                }       
                translate< 6.5, 0, 0 >
                rotate< 0, 0, rot2 >
        }
#declare rot2 = rot2+10;
#end              
        box
        {
                < -1, 0, -1 >< 1, 1, 1 >
                scale< 7, 8, 10 >
        }
#declare mov1 = -6.5;
#while( mov1 <= 6.5 ) 
        union
        {
                sphere
                {
                        <0, 0, 0 >, 1                  
                        scale< 0.2, 0.2, 0.2 >
                        translate< 0, 0, 9.9 >
                }
                sphere
                {
                        <0, 0, 0 >, 1         
                        scale< 0.2, 0.2, 0.2 >
                        translate< 0, 0, -9.9 >          
                }       
                translate< mov1, 7.5, 0 >
#declare mov1 = mov1 + 1;
        }          
#end
}

#declare train_tank = union
{
        cylinder
        {
                <-1, 0, 0 ><1, 0, 0 >,1
                scale< 7, 10, 10 >
        }
#declare rot3 = 0;
#while( rot3 < 365 )
        union
        {
                sphere
                {
                        <0, 0, 0 >, 1                  
                        scale< 0.2, 0.2, 0.2 >
                        translate< 6.5, 0, -9.9 >
                }
                sphere
                {
                        <0, 0, 0 >, 1         
                        scale< 0.2, 0.2, 0.2 >
                        translate< -6.5, 0, -9.9 >
                }       
                rotate< rot3, 0, 0 >
#declare rot3 = rot3 + 10;
        }          
#end
}

#declare train_segment = union
{       
        object
        {
                train_socket
        }
        object
        {
                axis
        }
        object            
        {
                train_tank
                translate< 0, 15, 0 >
        }
}

#declare chimney = union
{
        cylinder
        {
                <0, 0, 0 >< 0, 1, 0 >,1
                scale< 3, 15, 3 >
        }
        cone
        {
                <0, 0, 0 >,1 <0, 1, 0 >,2
                scale< 3, 5, 3 >
                translate< 0, 15, 0 >
        }
        cylinder
        {
                <0, 0, 0 > <0, 1, 0 >,2
                scale< 3, 5, 3 >
                translate< 0, 20, 0 >
                texture{ redpaint_tex }
        }
        sphere
        {
                <0, 0, 0 >, 1
                material{ smoke }    
                scale< 5, 15, 5 >
                translate< 0, 30, 0 >
                hollow
        }
}

#declare bell = union
{       
        sphere
        {
                <0, 0, 0 >,1
        }
        cone
        {
                <0, 0, 0 >,1,<0,-1, 0 >,2
                scale< 1, 2, 1 >
        }
        cone
        {
                <0, 0, 0 >,1,<0,-1,0 >,1.5
                translate< 0, -2, 0 >
                scale< 2, 1, 2 >
        }
        texture{ gold_tex }
}

#declare lamp = union
{       
        union
        {        
                sphere
                {
                        <0, 0, 0 >, 1
                        texture{ lamp_tex }
                }
                light_source
                {
                        <0, 0, 0 >
                        color rgb< 1, 1, 1 >
                } 
                translate< 0.2, 0, 0 >
        }
        union
        {       
                box
                {
                        < -1, -1, -1 >, <1, 1, 1 >
                }
                torus
                {
                        0.7, 0.1   
                        rotate< 0, 0, 90 >
                        translate< 1, 0, 0 >
                }
                mesh
                {
                        triangle{ <1, 1, 1>, < 0, 2, 0 >, <-1, 1, 1 > }
                        triangle{ <-1, 1, 1>, < 0, 2, 0 >, <-1, 1, -1 > }
                        triangle{ <-1, 1, -1>, < 0, 2, 0 >, <1, 1, -1 > }
                        triangle{ <1, 1, -1>, < 0, 2, 0 >, <1, 1, 1 > }
                }
                texture { gold_tex }
        }
}

#declare train_front = union
{       
        object
        {
                train_segment 
                texture{ iron_tex }
        }
        object
        {
                chimney
                translate< 0, 20, 0 > 
                texture{ iron_tex }
        }
        union
        {
                object
                {
                        thick_tire             
                }
                text
                {
                        ttf "c:\winnt\fonts\arial.ttf", "TH. HAHN", 1, 0
                        translate< -2.4, 0, -2.5 >
                        scale< 0.25, 0.3, 0.3 >
                        texture{ redpaint_tex }
                }
                rotate< 0, -90, 0 > 
                translate< 0.1, 1.7, 0 >    
                scale< 9, 9, 9 >
                texture{ redpaint_tex }
        }
        object
        {
                lamp
                scale < 2, 2, 2 >
                translate< 9, 25, 0 >
        }
        /*
        mesh
        {   
                triangle{<0, 0, 1>, <1, 0, 0 >,<0, 1, 0 > }
                triangle{<0, 0, -1>, <1, 0, 0 >,<0, 1, 0 > }
                scale< 15, 12, 15 >
                translate< 9, -5, 0 >
                texture{ redwood_tex }
        }*/
}

#declare train_box = union
{
        union
        {
                difference
                {
                        difference
                        {
                                difference
                                {
                                        box
                                        {
                                                <-1, -1, -1 ><1, 1, 1 >
                                                scale< 6.5, 15, 10 >
                                        }
                                        union
                                        {
                                                cylinder
                                                {
                                                        <-1, 0, 0 ><1, 0, 0 >,1
                                                        translate< 0, 0, 3 >
                                                }
                                                cylinder
                                                {
                                                        <-1, 0, 0 ><1, 0, 0 >,1
                                                        translate< 0, 0, -3 >
                                                }
                                                scale< 10, 2, 2 >
                                                translate< 0, 10, 0 >
                                        }
                                }
                                box
                                {
                                        <-1, -1, -1 ><1, 1, 1 >
                                        scale< 4, 5, 20 >
                                        translate< 0, 5, 0 >
                                }
                        }
                        box
                        {
                                <-1, -1, -1 ><1, 1, 1 >
                                scale< 6.5, 14.9, 9.9 >
                                translate< -0.9, 0, 0 >
                        }
                        texture{ iron_tex }
                }
                difference
                {
                        difference
                        {
                                cylinder
                                {
                                        <-1, 0, 0 >,< 1, 0, 0 >,1
                                }
                                box
                                {
                                        <-2, -1, -2 >,< 2, 0, 2>
                                }
                        }
                        cylinder
                        {
                                <-2, 0, 0 >,< 2, 0, 0 >,0.9
                        }
                        scale< 7, 5, 15 >
                        translate< 1, 11.5, 0 >
                        texture{ redwood_tex }
                }
                scale< 2, 1, 1 >
                translate< -7, 20, 0 >
        }
#declare mov2 = 0;
#while( mov2 < 30 )
        union
        {
                sphere
                {
                        <0, 0, 0 >, 1                  
                        scale< 0.2, 0.2, 0.2 >
                        translate< 5.5, 5.5+mov2, -10 >
                }
                sphere
                {
                        <0, 0, 0 >, 1                  
                        scale< 0.2, 0.2, 0.2 >
                        translate< 5.5, 5.5+mov2, 10 >
                }
                sphere
                {
                        <0, 0, 0 >, 1                  
                        scale< 0.2, 0.2, 0.2 >
                        translate< -19.5, 5.5+mov2, -10 >
                }
                sphere
                {
                        <0, 0, 0 >, 1                  
                        scale< 0.2, 0.2, 0.2 >
                        translate< -19.5, 5.5+mov2, 10 >
                }
                texture{ iron_tex }
#declare mov2 = mov2 + 1;
        }
#end
}

#declare train_cockpit = union
{
       union
       {
                object
                {                          
                        train_socket          
                        texture{ iron_tex }
                }
                object
                {
                        axis
                }
        }
        union
        {
                object
                {                          
                        train_socket          
                        texture{ iron_tex }
                }
                object
                {
                        axis
                }
                translate< -13, 0, 0 >
        }
        object
        {
                train_box
        }
}

#declare train = union
{       
        object
        {
                train_segment
                texture{ iron_tex }
        }
        object
        {        
                train_cockpit
                translate< -13, 0, 0 >
        }
        object
        {
                train_segment
                translate< 13, 0, 0 >
                texture{ iron_tex }
        }
        object
        {
                train_front
                translate< 26, 0, 0 >
        }
        union
        {
                object
                {
                        bell       
                }
                object
                {
                        thick_tire
                        scale< 5, 4, 1 >
                        translate< 0, -2, 0 >
                        texture{ redpaint_tex }
                }
                rotate< 0, 90, 0 >
                translate< 0, 29, 0 >
        }
}