#include "colors.inc" 
#include "woods.inc"
#include "metals.inc"
#include "varnish.inc"

// Speaker texture
#declare T_Speaker = 
  texture {
    pigment { 
      image_map {
        png "grille_num42_s2.png"
      }
      scale 2
      rotate z*90
    }
    normal { bumps 0.5 }
  }


 
// Lighter texture
#declare T_RadWood1A = 
 texture {
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0.5]
      }
      scale <0.02,0.04,0.04>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0.5,0.5,0.5,1>]
      }
      scale <1,3,3>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.18,0.04,0,1>]
        [0.3 rgbf <0.15,0.02,0.0,1>]
        [1.0 rgbf <0.1 0.014,0,1>]
      }
      scale <0.15,4,4>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }


#declare T_RadWood1 = 
  texture {
    T_RadWood1A
    scale 3
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
// Darker texture
#declare T_RadWood2A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.01,0.02,0.02>
      rotate z*94
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [0.5 rgbf 0]
        [1.0 rgbf 0.3]
      }
      scale <1,3,3>
      rotate z*94
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.06,0.003,0.0,1>]
        [0.4 rgbf <0.08,0.013,0,1>]
        [0.6 rgbf <0.05,0.005,0.0,1>]
        [1.0 rgbf <0.05 0.004,0,1>]
      }
      scale <0.15,4,4>
      rotate z*94
      warp { turbulence 0.3 }
      warp {repeat 6*x flip <1,0,0> }
    }
  }

#declare T_RadWood2 = 
  texture {
    T_RadWood2A
    scale 6
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
// Top Side texture
#declare T_RadWood3A = 
 texture {
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*45
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0.3,0.3,0.3,1>]
      }
      scale <1,3,3>
      rotate z*45
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.15,0.03,0,1>]
        [0.3 rgbf <0.13,0.02,0.0,1>]
        [0.5 rgbf <0.16,0.03,0.0,1>]
        [1.0 rgbf <0.04 0.008,0,1>]
      }
      scale <0.15,4,4>
      rotate z*45
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }

#declare T_RadWood3 = 
  texture {
    T_RadWood3A
    scale 3
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
#declare T_Cracks =
  texture {
    T_RadWood3A
    scale 3
    finish { diffuse 0.0 specular 0.1 roughness 0.01 reflection 0.002 }
  }
  
#declare T_RadWood1Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood1]
      [1 T_RadWood1]
    }
  }
  
#declare T_RadWood3Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood3]
      [1 T_RadWood3]
    }
  }
  
#declare Screw =
  object {
    // CSG difference, subtract intersections of shapes 2...N from Shape1
    difference {
      sphere {0, 1 }
      box { <-0.5,-0.1,-0.8>,<0.5,0.1,-1.2> }
      box { <-0.5,-0.1,-0.801>,<0.5,0.1,-1.2> rotate z*90 }
    }
    scale 0.09
    texture { 
      pigment { White*0.05 }
      finish {diffuse 0.6 specular 0.8 roughness 0.01} 
    }
  }

#declare T_Dial =
  texture {
    pigment { rgb<0.9,0.3,0.03>*0.005 }
    finish {diffuse 0.7 specular 0.7 roughness 0.05 metallic 0.5 reflection 0.003} 
  }
  texture {
    pigment { 
      agate
      color_map {
        [0 rgbf <0.02, 0.005,0,1>]
        [1 rgbf <0.00,0.01,0.0,1>]
      }
      scale 0.3
    }
    finish {diffuse 0.7 specular 0.7 roughness 0.05 metallic 0.5 reflection 0.003}  
  }
  
  
#declare Knob = 
  lathe {
    cubic_spline // linear_spline | quadratic_spline | cubic_spline
    10, // number of points
    <0, 0>, <3, 0>, <3, 1>, <2.5,1.5>, <2.5,3>, <2.2,3>, <2,2>, <1.5,2.8>, <0,2.9>, <0,3> // the list of <u,v> points
    scale 1/5
    rotate x*-90
    texture {
      pigment {rgb <1,0,0>/255} //almost black
      finish { F_Varnish }
    }
  }


#declare bh=9.15;  // box height
#declare bw=11.5;  // box width
#declare bd=5;   // box depth
#declare cs=1.3;     // y scale of the cylinder
#declare hfs=18; // height field scale

#declare AtKent82 = 
union {
  union {
    difference {
      union {
        object {
          difference {
            cylinder { <0, 0, 0.10>, <0, 0, bd>, bw/2  }
            plane { y, 0 }
          }
          scale <1,cs,1>
          translate y*bh
        }
        box { <-bw/2,0,0.10>, <bw/2,bh,bd> }
        texture { T_RadWood1 rotate y*90 }  
      } // union
      // Cut out a hole for the speaker
      cylinder { <0, 0, 0>, <0, 0, 1>, bw/2*0.95  
        scale <1,cs,1>
        translate y*bh
      }
    } // difference
    height_field {
      sys "AtKent82FaceLightHF.bmp"
      smooth
      water_level 0.05
      scale <hfs, 0.10, hfs>
      rotate x*-90
      translate <-hfs/2,-0.5,0.10>
      texture { T_RadWood1Face translate z*0.02}
    }
    height_field {
      sys "AtKent82FaceDarkHF.bmp"
      smooth
      water_level 0.05
      scale <hfs, 0.25, hfs>
      rotate x*-90
      translate <-hfs/2,-5,0>
      texture { T_RadWood2 }
    }
    height_field {
      sys "AtKent82FaceTopSideHF.bmp"
      smooth
      water_level 0.05
      scale <hfs*1.01, 0.25, hfs>
      rotate x*-90
      translate <-hfs*1.01/2,-0.5,0>
      texture { T_RadWood3Face translate z*-0.2 }
    }
    height_field {
      sys "AtKent82FaceBottomSideHF.bmp"
      smooth
      water_level 0.05
      scale <hfs, 0.5, hfs>
      rotate x*-90
      translate <-hfs/2,-0.5,0.12>
      texture { T_RadWood2 }
    }
    height_field {
      sys "AtKent82DialHF.bmp"
      smooth
      water_level 0.05
      scale <4, 0.13, 4>
      rotate x*-90
      translate <-2,3.7,-0.35>
      texture { T_Dial }
    }
    height_field {
      sys "AtKent82InnerDialHF.bmp"
      smooth
      water_level 0.05
      scale <4, 0.13, 4>
      rotate x*-90
      translate <-2,3.7,-0.22>
      texture { pigment {rgb <1,0.6,0.3>*0.8 } }
      texture { 
        pigment {
          image_map {
            png "AtKent82InnerDialIM.png"
          }
          translate <0.6,0.55,0>
          scale 2
        }
      }
      finish { diffuse 0.5 specular 0.99 roughness 0.0001 reflection 0.05 }
    }
    // the speaker
    cylinder { <0, 0, 0.11>, <0, 0, 1>, bw/2*0.95  
      scale <1,cs,1>
      translate y*bh
      texture { T_Speaker }
    }
    // middle-side trim
    box { <-(bw/2+0.15),7.75,-0.5>, <-(bw/2+0.15)+1.3,8,bd> 
      texture { T_RadWood2 rotate z*90 scale 0.5 translate x*20 }
    }
    box { <bw/2+0.15-1.3,7.75,-0.5>, <bw/2+0.15,8,bd> 
      texture { T_RadWood2 rotate z*90 scale 0.5 translate x*20 }
    }
  }
  
  // bottom trim
  box { <-(bw/2+0.25),0,-0.5>, <bw/2+0.25,0.5,bd> 
    texture { T_RadWood2 rotate z*90 scale 0.5 translate x*20 }
  }

  // knobs  
  object {Knob translate <-3,2.3,-0.3>}
  object {Knob translate <3,2.3,-0.3>}
  object {Knob scale 1.3 translate <0,4,-0.35>}
  
  // screws
  object {Screw translate <-2.82,14.23,0.06> }
  object {Screw translate <2.82,14.23,0.06> }
  object {Screw translate <0,7.93,0.06> }
}
