// ======================================
// Modified from "Example of use of the Makegrass macro by Gilles Tran - March 1999"
// Modified by Jeremy Praay
// --------------------------------------
#include "colors.inc"
#include "mgrass.inc"

/*#declare Green1=rgb<220,190,100>/255;
#declare Green2=rgb<100,170,50>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*0.9]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.3]
        [1   color Green1*0.3]
    }
}
#declare pigGreen=pigment{Green2*1}
//#declare pigSpotted=pigment{Red}
//#declare pigEarth=pigment{Blue}
#declare txtGrass=texture {                  

                pigment {
                        gradient y
                        turbulence 0.2
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.2 pigSpotted]
                                    [0.6 pigGreen]
                                }
                        }

        finish{diffuse 0.7 specular 0.3 roughness 0.15}
        scale <0.001,1,0.001>
 
}
*/ 
//
//--------------------------------------------------------------------------------
//
#declare Green1=rgb<0.65,0.7,0.3>*0.8;
#declare Green2=rgb<1.4,1.60,0.8>*0.25;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.6]
        [0.2, 0.3   color Tan*0.2 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.15]
        [0.6 color Tan*0.15]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
#declare txtGrass=texture {                  
  pigment {
    gradient y
    turbulence 0.2
      pigment_map {                                
        [0.0 pigEarth]
        [0.1 pigSpotted]
        [0.4 pigGreen]
        [1.00 pigGreen]
      }
    }
  finish{diffuse 0.7 specular 0.3 roughness 0.03}
  scale <0.001,1,0.001>
} 
// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=1;               // size of patch
#declare nBlade=2;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 10;            // number of blade segments
#declare lBlade = 35;             // length of blade
#declare wBlade = 1;              // width of blade at start
#declare wBladeEnd = 0.2;         // width of blade at the end
#declare doSmooth=true;          // true makes smooth triangles
#declare startBend = <0,1,0.1>;   // bending of blade at start (<0,1,0>=no bending)
#declare pwBend = 3;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale;
#declare stdBend = 2;            // standard deviation of blade bending;
#declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass3.inc"     // name of the mesh file to create

// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=1;             // number of patches for the first line
#declare addPatches=1;            // number of patches to add at each line
#declare nzPrairie=1;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
/*#if (dofile=true) // if the patch is already created, turn off the next line
        MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        


object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
texture{txtGrass scale 40}
}  
*/
#declare stdscale=0;              // stddev of scale
#declare stdrotate=0;             // stddev of rotation
#declare stdposBlade = 0;         // standard deviation of blade position 0..1
#declare stdrotBlade = 0;       // standard deviation of rotation
#declare stdBlade = 0;           // standard deviation of blade scale;
#declare stdBend = 0.5;            // standard deviation of blade bending;


#declare startBend = <0,1,0.1>;   // bending of blade at start (<0,1,0>=no bending)
#declare lBlade = 30;             // length of blade
#declare posCorn=<0,0,0>;
#declare rotBlade=45;
#declare s1=seed(rd);
#declare scBlade=1;
//#declare lBladetmp=lBlade*scBlade;     
#declare xBladeStart=wBlade*scBlade;
#declare xBladeEnd=wBladeEnd*scBlade;
#declare zBladeStart=xBladeStart*1;
#declare fname = "fgrass3.inc"     // name of the mesh file to create
#declare dofile=false;
#declare Corn =
  union {
    object {
      cone { posCorn, 1, <0,35,0>, 0.5
        open
      }
      texture { txtGrass scale 40}
    }
    mesh {
      #declare vBend = <0,-10,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,0,0>,0,segBlade,lBlade*0.5,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-10,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,4,0>,180,segBlade,lBlade*0.7,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-9,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,8,0>,0,segBlade,lBlade*0.8,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-9,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,10,0>,180,segBlade,lBlade*0.8,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-8,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,14,0>,0,segBlade,lBlade*0.9,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-8,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,18,0>,180,segBlade,lBlade,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-7,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,22,0>,0,segBlade,lBlade,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-6,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,26,0>,180,segBlade,lBlade,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-5,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,29,0>,0,segBlade,lBlade*0.9,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-4,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,32,0>,180,segBlade,lBlade*0.8,xBladeStart*0.9,xBladeEnd*0.9,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-3,4>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,33,0>,0,segBlade,lBlade*0.7,xBladeStart*0.8,xBladeEnd*0.8,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-2,2>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,34,0>,180,segBlade,lBlade*0.6,xBladeStart*0.7,xBladeEnd*0.7,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare vBend = <0,-1,1>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,34.3,0>,0,segBlade,lBlade*0.5,xBladeStart*0.5,xBladeEnd*0.5,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare startBend = <0,1,0.05>;   // bending of blade at start (<0,1,0>=no bending)
      #declare vBend = <0,1,1>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,34.3,0>,180,segBlade,lBlade*0.4,xBladeStart*0.5,xBladeEnd*0.5,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      #declare startBend = <0,1,0.02>;   // bending of blade at start (<0,1,0>=no bending)
      #declare vBend = <0,1,1>;         // force bending the blade (<0,1,1> = 45)
      MakeBlade(doSmooth,<0,34.3,0>,0,segBlade,lBlade*0.3,xBladeStart*0.5,xBladeEnd*0.5,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
      texture { txtGrass scale 45}
    }
  }

#macro MakeCornField(rows, rowplants )
  union {
    #local fieldwidth=20*rows;
    #local rowlen=10*rowplants;
    #local j=0;
    #local rowspacing=fieldwidth/rows;
    #while (j < rows)
      #local i=0;
      #local plantspacing=rowlen/rowplants;
      #while (i < rowplants)
        #local stdrotate = 360*rand(s1);
        #local stdspacing = plantspacing*rand(s1);
        object { Corn 
          scale 0.9+(0.2*rand(s1))
          rotate y*stdrotate
          translate <(i*plantspacing-1)+stdspacing,0,j*rowspacing>
        }
        #local i = i + 1;
      #end
      #local j=j+1;
    #end
    translate <-rowlen/2,0,-fieldwidth/2>
    scale 1/40 // shrink down to about 1 unit tall
  }
#end

