#include "colors.inc" 
#include "woods.inc"
#include "metals.inc"
#include "varnish.inc"

// Speaker texture
#declare T_Speaker = texture {
  pigment { 
    image_map {
      png "grille_num51_s.png"
    }
    scale 2
    rotate z*90
  }
  //normal { bumps 0.2 }
}


 
// Lighter texture
#declare T_RadWood1A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*30
      warp {repeat 3*x flip <1,0,0> }
      translate x*3
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf 0]
      }
      scale <1,3,3>
      rotate z*30
      warp {repeat 3*x flip <1,0,0> }
      translate x*3
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.15,0.025,0,1>]
        [0.4 rgbf <0.1,0.015,0.0,1>]
        [1.0 rgbf <0.03 0.01,0,1>]
      }
      scale <0.15,4,4>
      rotate z*30
      warp {repeat 3*x flip <1,0,0> }
      translate x*3
    }
  }

#declare T_RadWood1 = 
  texture {
    T_RadWood1A
    scale 8
    scale <1,0.6,1>
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
// Darker texture
#declare T_RadWood2A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.01,0.02,0.02>
      rotate z*94
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [0.5 rgbf 0]
        [1.0 rgbf 0.3]
      }
      scale <1,3,3>
      rotate z*94
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.15,0.04,0,1>]
        [0.4 rgbf <0.07,0.01,0.0,1>]
        [1.0 rgbf <0.01 0.0,0,1>]
      }
      scale <0.15,4,4>
      rotate z*94
      warp { turbulence 0.1 }
      warp {repeat 6*x flip <1,0,0> }
    }
  }


#declare T_RadWood2 = 
  texture {
    T_RadWood2A
    scale 8
    //scale <1,0.2,1>
    finish { F_Varnish }
    normal { N_Varnish }
  }
  

// Box texture
#declare T_RadWood3A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.01,0.02,0.01>
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [0.5 rgbf 0]
        [1.0 rgbf 0.3]
      }
      scale <1,3,1>
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.15,0.04,0,1>]
        [0.4 rgbf <0.07,0.01,0.0,1>]
        [1.0 rgbf <0.01 0.0,0,1>]
      }
      scale <0.15,4,0.15>
    }
  }


#declare T_RadWood3 = 
  texture {
    T_RadWood3A
    scale 8
    //scale <1,0.2,1>
    finish { F_Varnish }
    normal { N_Varnish }
  }
  

#declare T_Dial =
  texture {
    T_Brass_5B
  }

#declare Knob = 
  difference {
    sphere { 0, 1 }
    plane {-z,0}
  
    #declare i=0;
    #while (i < 12)
      plane {x,-0.5 rotate <0,0,i*45> }
      plane {x,-0.5 rotate <0,-60,i*45> }
      #declare i=i+1;
    #end
    pigment {White}
    scale 1.5
    texture {
      pigment {rgb <1,1,1>/255} //almost black
      finish { diffuse 0.6 specular 0.9 roughness 0.01 reflection 0.08 }
    }
  }   

#declare Screw =
  union {
    difference {
      sphere {0, 1 }
      box { <-0.5,-0.1,-0.8>,<0.5,0.1,-1.2> }
      box { <-0.5,-0.1,-0.801>,<0.5,0.1,-1.2> rotate z*90 }
    }
    cylinder { 0, <0,0,-0.05>, 1.3 }
    scale 0.12
    texture { 
      pigment { White*0.05 }
      finish {diffuse 0.6 specular 0.8 roughness 0.01} 
    }
  }


#declare bh=30; // box height
#declare bw=14; // box width
#declare bd=10;  // box depth
#declare hfs=39.7; // height field scale

#declare Crosley7H3 =
union {
  difference {
    union {
      box { <-bw/2,0,0>,<bw/2,bh,bd> 
      }
      box { <-bw/2,0,0>,<-bw/2-6,bh,bd>
      } 
      box { <bw/2,0,0>,<bw/2+6,bh,bd>
      } 
    }
    cylinder {
      <-bw/2-10,bh+3,-1>, <-bw/2-10,bh+3,bd+1>, 10
    }
    cylinder {
      <bw/2+10,bh+3,-1>, <bw/2+10,bh+3,bd+1>, 10
    }
    box { <-bw/2,13,-1>, <bw/2,bh-1,1> // cut out the speaker
      texture {T_Speaker}
    } 
    texture {T_RadWood3}
  }
  box { <-bw/2,13,0>, <bw/2,bh-1,1> // the speaker
    texture {T_Speaker}
  } 
  height_field {
    sys "Crosley7H3FaceDarkHF.bmp"
    smooth
    water_level 0.05
    scale <hfs, 0.5, hfs>
    rotate x*-90
    translate <-hfs/2,-3.9,0>
    texture { T_RadWood2 }
  }
  height_field {
    sys "Crosley7H3FaceLightHF.bmp"
    smooth
    water_level 0.05
    scale <hfs, 0.125, hfs>
    rotate x*-90
    translate <-hfs/2,-3.9,0>
    texture { T_RadWood1 }
  }
  height_field {
    sys "Crosley7H3DialHF.bmp"
    smooth
    water_level 0.5
    scale <12, 0.05, 12>
    rotate x*-90
    translate <-5.9,4.9,-0.12>
    texture { T_Dial }
  }
  difference { // make the dial
    sphere { <0,10.7,20>, 20.43 }
    plane { -z, 0 }
    texture {
      pigment { 
        image_map {
          png "Crosley7H3DialImg.png"
        }
        scale 7
        translate <3.5,0.2,0>
      }
      finish { diffuse 0.5 specular 0.99 roughness 0.0001 reflection 0.05 }
    }
    texture {
      pigment {
        agate // just add a little difference
        color_map {
          [0.0 rgbf <0.85,0.75,0.45,1>]
          [1.0 rgbf <0.95,0.7,0.4,1>]
        }
      }
    }
  } 
  // side panels
  // left
  box {
    <-bw/2-6-0.25,1.5,0.5>,<-bw/2-6,bh*0.6,bd-0.5>
    texture {T_RadWood3 translate 5}
  }
  cylinder {
    <-bw/2-5,1.75,2>,<-bw/2-5,bh*0.6-0.25,2>,1.5
    texture {T_RadWood3 translate 5}
  }
  cylinder {
    <-bw/2-5,1.75,bd-2>,<-bw/2-5,bh*0.6-0.25,bd-2>,1.5
    texture {T_RadWood3 translate 15}
  }
  cylinder {
    <-bw/2-5.5,1.75,3.7>,<-bw/2-5.5,bh*0.6-0.25,3.7>,1
    texture {T_RadWood3 translate 25}
  }
  cylinder {
    <-bw/2-5.5,1.75,bd-3.7>,<-bw/2-5.5,bh*0.6-0.25,bd-3.7>,1
    texture {T_RadWood3 translate 35}
  }
  // right
  box {
    < bw/26+6+0.25,1.5,0.5>,< bw/2+6,bh*0.6,bd-0.5>
    texture {T_RadWood3 translate 5}
  }
  cylinder {
    < bw/2+5,1.75,2>,< bw/2+5,bh*0.6-0.25,2>,1.5
    texture {T_RadWood3 translate 5}
  }
  cylinder {
    < bw/2+5,1.75,bd-2>,< bw/2+5,bh*0.6-0.25,bd-2>,1.5
    texture {T_RadWood3 translate 15}
  }
  cylinder {
    < bw/2+5.5,1.75,3.7>,< bw/2+5.5,bh*0.6-0.25,3.7>,1
    texture {T_RadWood3 translate 25}
  }
  cylinder {
    < bw/2+5.5,1.75,bd-3.7>,< bw/2+5.5,bh*0.6-0.25,bd-3.7>,1
    texture {T_RadWood3 translate 35}
  }
  
  // knobs  
  object {Knob translate <-5,4,-0.25>}
  object {Knob translate <0,4,-0.25>}
  object {Knob translate <5,4,-0.25>}
  
  
  scale 0.7 // I guess I made it too big
}
