#include "colors.inc" 
#include "woods.inc"
#include "varnish.inc"

// Speaker texture
#declare T_Speaker = texture {
  pigment { 
    image_map {
      //png "grille_num51_sa.png"
      png "grille_num27_s.png"
    }
    scale 0.4
    rotate z*90
  }
  //normal { bumps 0.2 }
}


// Lighter texture
#declare T_RadWood1A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*5
      warp {repeat 4*x flip <1,0,0> }
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0.3,0.3,0.3,1>]
      }
      scale <1,3,3>
      rotate z*5
      warp {repeat 4*x flip <1,0,0> }
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.3,0.07,0,1>]
        [0.3 rgbf <0.2,0.04,0.0,1>]
        [1.0 rgbf <0.1 0.03,0,1>]
      }
      scale <0.15,4,4>
      rotate z*5
      warp {repeat 4*x flip <1,0,0> }
    }
  }

#declare T_RadWood1 = 
  texture {
    T_RadWood1A
    scale 3
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
  
// Darker texture
#declare T_RadWood2A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*2
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf 0]
      }
      scale <1,3,3>
      rotate z*2
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.15,0.03,0,1>]
        [0.3 rgbf <0.1,0.02,0.0,1>]
        [1.0 rgbf <0.03 0.01,0,1>]
      }
      scale <0.15,4,4>
      rotate z*2
      warp {repeat 6*x flip <1,0,0> }
    }
  }

#declare T_RadWood2 = 
  texture {
    T_RadWood2A
    scale 6
    finish { F_Varnish }
    normal { N_Varnish }
  }
  

#declare T_Cracks =
  texture {
    pigment {
      Black
    }
    finish { F_Varnish }  
  }
  
#declare T_RadWood1Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood1]
      [1 T_RadWood1]
    }
  }
  
#declare T_Dial =
  texture {
    pigment { rgb<0.9,0.3,0.03>*0.005 }
    finish {diffuse 0.7 specular 0.7 roughness 0.05 metallic 0.5 reflection 0.003} 
  }
  texture {
    pigment { 
      agate
      color_map {
        [0 rgbf <0.02, 0.005,0,1>]
        [1 rgbf <0.00,0.01,0.0,1>]
      }
      scale 0.3
    }
    finish {diffuse 0.7 specular 0.7 roughness 0.05 metallic 0.5 reflection 0.003}  
  }

#declare Knob = 
  lathe {
    cubic_spline // linear_spline | quadratic_spline | cubic_spline
    10, // number of points
    <0, 0>, <3, 0>, <3, 1>, <2.5,1.5>, <2.5,3>, <2.2,3>, <2,2>, <1.5,2.8>, <0,2.9>, <0,3> // the list of <u,v> points
    scale 1/5
    rotate x*-90
    texture {
      pigment {rgb <1,0,0>/255} //almost black
      finish { F_Varnish }
    }
  }

#declare Screw =
  union {
    difference {
      sphere {0, 1 }
      box { <-0.5,-0.1,-0.8>,<0.5,0.1,-1.2> }
      box { <-0.5,-0.1,-0.801>,<0.5,0.1,-1.2> rotate z*90 }
    }
    cylinder { 0, <0,0,-0.05>, 1.3 }
    scale 0.12
    texture { 
      pigment { White*0.05 }
      finish {diffuse 0.6 specular 0.8 roughness 0.01} 
    }
  }


#declare bh=30; // box height
#declare bw=16; // box width
#declare bd=10;  // box depth
#declare hfs=39.7; // height field scale

#declare Philco116 =
union {
  difference {
    union {
      box { <-bw/2,0,0.0001>,<bw/2,bh,bd> }
      prism {
        linear_spline
        0,bd,13,
        <0,-bw/2-3>,
        <0,-bw/2-3>,
        <bh*3/4,-bw/2-3>,
        <bh*3/4+1,-bw/2-2>,
        <bh,-bw/2-1>,
        <bh+1,-bw/2>,
    
        <bh+1,bw/2>,
        <bh,bw/2+1>,
        <bh*3/4+1,bw/2+2>,
        <bh*3/4,bw/2+3>,
        <0,bw/2+3>,
    
        <0,-bw/2-3>,
        <0,-bw/2-3>
        
        rotate <90,0,90>
      }
      texture {T_RadWood2}
    }
    box { <-bw/2+2,10,-1>, <bw/2-2,bh-2,1> } // cut out for speaker
  }
  box { <-bw/2+2,10,0>, <bw/2-2,bh-2,1> // the speaker
    texture {T_Speaker}
  } 
  height_field {
    sys "Philco116FaceDarkHF.bmp"
    smooth
    water_level 0.05
    scale <hfs, 0.5, hfs>
    rotate x*-90
    translate <-hfs/2,-3.9,0>
    texture { T_RadWood2 }
  }
  height_field {
    sys "Philco116FaceLightHF.bmp"
    smooth
    water_level 0.05
    scale <hfs, 0.125, hfs>
    rotate x*-90
    translate <-hfs/2,-3.9,0>
    texture { T_RadWood1Face translate z*-0.1}
  }
  height_field {
    sys "Philco116DialHF.bmp"
    smooth
    water_level 0.05
    scale <5, 0.13, 5>
    rotate x*-90
    translate <-2.5,8,-0.25>
    texture { T_Dial }
  }
  difference { // make the dial
    sphere { <0,0,10>, 10.2 scale <1,1.8,1> translate <0,10.45,0> }
    plane { -z, -0.126 }
    texture {
      pigment { 
        image_map {
          png "Philco116DialImg.png"
        }
        scale 5
        translate <-2.5,3,0>
      }
      finish { diffuse 0.5 specular 0.99 roughness 0.0001 reflection 0.05 }
    }
  }
  
  // knobs  
  object {Knob translate <-3,3.5,-0.25>}
  object {Knob translate <0,3.5,-0.25>}
  object {Knob translate <3,3.5,-0.25>}
  object {Knob scale 1.3 translate <0,6.5,-0.25>}
  
  
  
  
  scale 0.75 // I guess I made it too big
}

