// PoVRay 3.5 Scene File "IRTC.pov"
//
// Revolution
//
// created by   RS  
// Date:   1/2/2003
//--------------------------------------------------------------------------
//#version 3.5;

#version unofficial mlpov 0.82;

global_settings {  assumed_gamma 1
ambient_light 1
#if(0)
 radiosity{
    pretrace_start 32/image_width //0.08           // start pretrace at this size
    pretrace_end   2/image_width //0.01           // end pretrace at this size
    count 500                      // higher -> higher quality (1..1600) [35]
    nearest_count 5              // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 1             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.001           // reuse of old radiosity samples [0.015]
    brightness .5                  // brightness of radiosity effects (0..1) [1]
    max_sample 5
    adc_bailout 0.01/30
    normal off
    media on                     // take surface normals into account [off]
   }
#end
}

//--------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "functions.inc"
//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
#declare Camera_0 = camera {angle 75          // front view
                            //rotate y*180  
                            location  <0 , 3 ,-9.0>
                            right     x*image_width/image_height
                            look_at   <6.0 , .8 , -4.0>}
#declare Camera_1 = camera {angle 75       
                            location  <-25.0 , 5.5 ,-25.0>
                            right     x*image_width/image_height
                            look_at   <0.0 , 1.0 , 0.0>}
#declare Camera_2 = camera {ultra_wide_angle angle 90     // right side view
                            location  <3.0 , 1.0 , 0.0>
                            right     x*image_width/image_height
                            look_at   <0.0 , 1.0 , 0.0>}
#declare Camera_3 = camera {ultra_wide_angle angle 90            // top view
                            location  <0.0 , 3.0 ,-0.001>
                            right     x*image_width/image_height
                            look_at   <0.0 , 1.0 , 0.0>}
camera{Camera_0}
// sun ---------------------------------------------------------------------
#if(1)
light_source {
  0*x                 
  color rgb <1,1,1>/1.5
#if(1)
  area_light
  <2, 0, 0> <0, 0, 2> 
  3, 3                
  adaptive 1
  jitter              
  circular            
  orient              
#end
  translate <-1500, 150, -1000>
}
#end

// Garage Light
#if(1)
light_source {
  0*x                  
  color rgb <.93,.78,.44>/1
#if(0)
  area_light
  <.05, 0, 0> <0, 0, .05> 
  3, 3                
  adaptive 1          
  jitter              
  circular            
  orient              
#end  
  translate <0, 6, 0>
  fade_distance 3
  fade_power 2
  media_interaction off
}
#end
// sky ---------------------------------------------------------------------
#if(0)
sky_sphere { pigment { gradient <0,1,0>
                       color_map { [0.00 rgb <1.0,1.0,1.0>/2]
                                   [0.30 rgb <0.5,0.5,1.0>/2]
                                   [0.70 rgb <0.7,0.7,1.0>/2]
                                   [1.00 rgb <1.0,1.0,1.0>/2] 
                                 } 
                       scale 2         
                     } // end of pigment
           } //end of skysphere 
#else
sphere { 
  0,4000
  pigment { image_map { hdr "rnl_probe.hdr" once interpolate 2 map_type 7 } } 
  finish { ambient .0 diffuse 1 } 
  hollow
  rotate y*180
  translate <0,0,0>
}            
#end

// fog ---------------------------------------------------------------------
#if(0)
fog{fog_type   2
    distance   50
    color      White
    fog_offset 0.1
    fog_alt    2.0
    //turbulence 0.8
    }
#end
// ground ------------------------------------------------------------------
#if(0)
plane{ <0,1,0>, .1 
  texture{
    pigment{
      image_map {
        jpeg "DSC01915.jpg"
        map_type 0
        interpolate 2
      }
    }
    finish{ambient 0 diffuse .8}
    scale 10
    rotate x*90
  }
} // end of plane
#else
height_field{
 tga "dirtfloor.tga" smooth double_illuminate
 translate <-.5,0,-.5>
 scale<20,.2,20>
 translate y*.05 
 texture{
   pigment{
   image_map{
     jpeg "ground_tile.jpg"
     map_type 0
     interpolate 2
   }
 }
 finish {ambient 0 diffuse .8}
 rotate x*90
 scale <4,1,3>
 }
} 

#declare puddles=material {
    texture {
      pigment {
        color rgbt <1, 1, 1, .5>//.17>
      }
      finish {
        ambient 0.0
        diffuse 0.0

        reflection {
          0.0, 1.0
          fresnel on
        }

        specular 0.4
        roughness 0.003
      }
#if(1)  normal {
        function {
          f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2)
        } 0.8
        scale <.05,0.01,0.05>
      }
#end
    }
    interior {
      ior 1.33
    media {
      scattering { 2 <0.5, 0.65, 0.4> }
//      fade_distance 1
//      fade_power 1002
      }
    }
  }


plane { y, 0.12 
  material{puddles} 
  }
#end

//--------------------------------------------------------------------------
//---------------------------- scenery objects -----------------------------
//--------------------------------------------------------------------------

#declare roof_p=pigment{
      image_map {
        jpeg "DSCN0119.jpg"
        map_type 0
        interpolate 2
      }
    }

#declare roof_t=texture{
  pigment{roof_p} 
  //normal{concrete_n}
  finish{ambient 0 diffuse .8}
  scale 8
  }

#declare concrete_p=pigment{
      image_map {
        jpeg "DSC01014.jpg"
        map_type 0
        interpolate 2
      }
    }


#declare concrete_t=texture{
  pigment{concrete_p} 
  finish{ambient 0 diffuse .8}
  scale 8
  }

#declare wallwithdirt=
texture{
  image_pattern{jpeg "dirt.JPG" interpolate 2} rotate z*90 scale <4,8,8> translate y*.1
  texture_map{
    [0.0   pigment{
             image_map{jpeg "ground_tile.jpg"
               map_type 0
               interpolate 2
             }
           }
           finish {ambient 0 diffuse .4 reflection .1}
           rotate z*90
           scale 1/2]
    [1.0 concrete_t rotate z*-90 scale <1/8,1/4,1/8>]
    }   
  }


#declare wood_p=pigment{
      image_map {
        jpeg "particleBoard1.jpg"
        map_type 0
        interpolate 2
      }
    }

#declare wood_t=texture{
  pigment{wood_p} 
  finish{ambient 0 diffuse .8}
  scale 8
  }


#declare panesize=1;
#declare panecutter=
box { <-.5, -0, -.5>, <.5, 1, .5>
  scale <panesize*3,panesize,panesize>
}

#declare panespace=panesize+.05;

#declare windowcutter=union{
object{panecutter translate <0,0,-panespace/2>}
object{panecutter translate <0,0,+panespace/2>}
object{panecutter translate <0,panespace,-panespace/2>}
object{panecutter translate <0,panespace,+panespace/2>}
object{panecutter translate <0,panespace*2,-panespace/2>}
object{panecutter translate <0,panespace*2,+panespace/2>}
}


#declare walls=union{
box { <-.5, -0, -.5>, <.5, 1, .5>  scale <.1,8,20> translate x*6 texture{wallwithdirt rotate y*90}}
difference{
  box { <-.5, -0, -.5>, <.5, 1, .5>  scale <.1,8,20> translate x*-6 texture{concrete_t rotate y*90}}
  union{
    object{windowcutter translate<-6,3,0> texture{concrete_t}}
    object{windowcutter translate<-6,3,-6> texture{concrete_t}}
    object{windowcutter translate<-6,3,+6> texture{concrete_t}}
    }
}  
box { <-.5, -0, -.5>, <.5, 1, .5>  scale <12,8,.1> translate z*10 texture{wood_t}}
//box { <-.5, -0, -.5>, <.5, 1, .5>  scale <12,8,.1> translate z*-10 texture{concrete_t}}
box { <-.5, -0, -.5>, <.5, 1, .5>  scale <12,.1,20> translate y*8 texture{roof_t rotate x*90}}
}


object{walls}

#include "wheel_m.inc"
#include "wheel_o.inc"

#declare wheel=union{
object{ P_Object01 }
object{ P_Object02 }
object{ P_Object03 }
object{ P_Object05 }
object{ P_Object06 }
object{ P_Object07 }
//object{ P_Object08 }
//object{ P_Object09 }
object{ P_Object04 }
object{ P_Object10 }
}

// #####################################
//      Exclude almost all objects
// #####################################
#if(1)

object{wheel scale 2.5/1000 rotate z*90 translate <5,.8,-4>}
object{wheel scale 2.5/1000 rotate <0,180,10> translate <4.8,1.3,-4>}

#include "trashbin_m.inc"
#include "trashbin_o.inc"

#declare binlid=union{
object{ P_cover}
object{ P_handle}
}

//object{P_contener scale 2.5/100 translate <3.5,0,-8>}
//object{binlid scale 2.5/100 rotate <-100,0,0> translate <3.5,1.15,-4.8>}

#include "pioneer_wagon_m.inc"
#include "pioneer_wagon_o.inc"

#declare wagon=union{
object{ P_NO_NAME_ }
object{ P_NO_NAME_0_ }
object{ P_NO_NAME_1_ }
object{ P_NO_NAME_2_ }
object{ P_NO_NAME_3_ }
object{ P_NO_NAME_4_ }
object{ P_NO_NAME_5_ }
object{ P_NO_NAME_6_ }
object{ P_NO_NAME_7_ }
object{ P_NO_NAME_8_ }
//object{ P_NO_NAME_9_ }
object{ P_NO_NAME_10 }
object{ P_NO_NAME_11 }
object{ P_NO_NAME_12 }
object{ P_NO_NAME_13 }
object{ P_NO_NAME_14 }
object{ P_NO_NAME_15 }
object{ P_NO_NAME_16 }
object{ P_NO_NAME_17 }
object{ P_NO_NAME_18 }
object{ P_NO_NAME_19 }
object{ P_NO_NAME_20 }
object{ P_NO_NAME_21 }
object{ P_NO_NAME_22 }
object{ P_NO_NAME_23 }
object{ P_NO_NAME_24 }
object{ P_NO_NAME_25 }
object{ P_NO_NAME_26 }
object{ P_NO_NAME_27 }
object{ P_NO_NAME_28 }
object{ P_NO_NAME_29 }
object{ P_NO_NAME_30 }
object{ P_NO_NAME_31 }
object{ P_NO_NAME_32 }
object{ P_NO_NAME_33 }
object{ P_NO_NAME_34 }
object{ P_NO_NAME_35 }
object{ P_NO_NAME_36 }
object{ P_NO_NAME_37 }
object{ P_NO_NAME_38 }
//object{ P_NO_NAME_39 }
//object{ P_NO_NAME_40 }
//object{ P_NO_NAME_41 }
object{ P_NO_NAME_42 }
object{ P_NO_NAME_43 }
object{ P_NO_NAME_44 }
object{ P_NO_NAME_45 }
object{ P_NO_NAME_46 }
object{ P_NO_NAME_47 }
object{ P_NO_NAME_48 }
object{ P_NO_NAME_49 }
object{ P_NO_NAME_50 }
object{ P_NO_NAME_51 }
object{ P_NO_NAME_52 }
object{ P_NO_NAME_53 }
object{ P_NO_NAME_54 }
object{ P_NO_NAME_55 }
object{ P_NO_NAME_56 }
object{ P_NO_NAME_57 }
object{ P_NO_NAME_58 }
object{ P_NO_NAME_59 }
object{ P_NO_NAME_60 }
object{ P_NO_NAME_61 }
object{ P_NO_NAME_62 }
object{ P_NO_NAME_63 }
object{ P_NO_NAME_64 }
object{ P_NO_NAME_65 }
object{ P_NO_NAME_66 }
object{ P_NO_NAME_67 }
object{ P_NO_NAME_68 }
object{ P_NO_NAME_69 }
object{ P_NO_NAME_70 }
object{ P_NO_NAME_71 }
object{ P_NO_NAME_72 }
object{ P_NO_NAME_73 }
object{ P_NO_NAME_74 }
object{ P_NO_NAME_75 }
object{ P_NO_NAME_76 }
object{ P_NO_NAME_77 }
object{ P_NO_NAME_78 }
object{ P_NO_NAME_79 }
object{ P_NO_NAME_80 }
object{ P_NO_NAME_81 }
object{ P_NO_NAME_82 }
object{ P_NO_NAME_83 }
object{ P_NO_NAME_84 }
object{ P_NO_NAME_85 }
object{ P_NO_NAME_86 }
object{ P_NO_NAME_87 }
object{ P_NO_NAME_88 }
object{ P_NO_NAME_89 }
object{ P_NO_NAME_90 }
object{ P_NO_NAME_91 }
object{ P_NO_NAME_92 }
object{ P_NO_NAME_93 }
}

object{wagon scale 12/180 rotate y*-90 translate <2,3,0>}

#include "gear1_m.inc"
#include "gear1_o.inc"
#include "gear7_m.inc"
#include "gear7_o.inc"
#include "gear8_m.inc"
#include "gear8_o.inc"
#include "gear10_m.inc"
#include "gear10_o.inc"

object{P_Gear1 scale 1.1/22 rotate x*90 translate <2.1,.25,-5.8>}
object{P_Gear7 scale 1/22 rotate x*90 translate <1.9,.33,-5.61>}
object{P_Gear8 scale 1/22 rotate x*90 translate <2,.5,-5.65>}
object{P_Gear10 scale 1/22 rotate y*90 rotate z*-20 translate <1.55,.55,-4.5>}

#include "bikewheel_m.inc"
#include "bikewheel_o.inc"

#declare bikewheel=union{
object{ P_Line01 }
//object{ P_Tire }
object{ P_Cylinder02 }
object{ P_Cylinder03 }
object{ P_Cylinder04 }
object{ P_Cylinder05 }
object{ P_Cylinder06 }
object{ P_Cylinder07 }
object{ P_Cylinder08 }
object{ P_Cylinder09 }
object{ P_Cylinder10 }
object{ P_Cylinder11 }
object{ P_Cylinder12 }
object{ P_Cylinder13 }
object{ P_Cylinder15 }
object{ P_Cylinder16 }
object{ P_Cylinder17 }
object{ P_Cylinder18 }
object{ P_Cylinder19 }
object{ P_Cylinder20 }
object{ P_Cylinder21 }
object{ P_Cylinder22 }
object{ P_Cylinder23 }
object{ P_Cylinder24 }
object{ P_Cylinder25 }
object{ P_Cylinder49 }
//object{ P_Line019 }
object{ P_Cylinder37 }
object{ P_Cylinder26 }
object{ P_Cylinder27 }
object{ P_Cylinder28 }
object{ P_Cylinder29 }
object{ P_Cylinder30 }
object{ P_Cylinder31 }
object{ P_Cylinder32 }
object{ P_Cylinder33 }
object{ P_Cylinder34 }
object{ P_Cylinder35 }
object{ P_Cylinder36 }
object{ P_Cylinder14 }
object{ P_Cylinder38 }
object{ P_Cylinder39 }
object{ P_Cylinder40 }
object{ P_Cylinder41 }
object{ P_Cylinder42 }
object{ P_Cylinder43 }
object{ P_Cylinder44 }
object{ P_Cylinder45 }
object{ P_Cylinder46 }
object{ P_Cylinder47 }
object{ P_Cylinder48 }
object{ P_ChamferCyl }
object{ P_ChamferCy0 }
object{ P_Spring01 }
object{ P_OilTank02 }
object{ P_Cylinder01 }
object{ P_OilTank03 }
object{ P_Cylinder00 }
object{ P_Spring02 }
object{ P_Cylinder50 }
}

object{bikewheel scale 1.5/60 rotate z*-20 rotate y*0 translate <1.55,.68,-4>}
object{bikewheel scale 1.5/60 rotate y*90 rotate x*0 translate <2.3,.68,-1.4>}

//Stone 
#include "stonewheel_m.inc"
#include "stonewheel_o.inc"

//object {P_Tube01 scale 1.8/90 rotate z*0 translate <4.8,0.1,-8>}


//Millstone

// Object1
#declare Object1Material = material {
texture {
  pigment { granite scale 3}//color rgbf <1, 1, 1, 0> }
  normal {granite scale 3}
  normal {granite scale 6}
  finish  { ambient 0 diffuse .8 }
  }
}
#declare Object1 = object {
   #include "millwheel1.inc"
}
object { Object1 material { Object1Material }scale 1.8/90 rotate x*90 rotate y*90 translate <4.8,.5,-7>}



// Weed
#include "txttree.inc"

#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_1}
#declare Leaf=object{#include "gtleaf4.inc"} // declares the Leaf object
#declare Tree1=object{#include "gttree4.inc"
//        texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "gtfoliage4.inc"
        texture{txtLeaf} 
}
                                                     
union{
     object{Tree1}
     object{Foliage1}
     scale 1/35
     translate <.5+4.8,.5-.5,-7+1.5>
}

#declare Leaf=object{#include "gtleaf1.inc"} // declares the Leaf object
#declare Tree2=object{#include "gttree1.inc"
//        texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage2=object{#include "gtfoliage1.inc"
        texture{txtLeaf} 
}

union{
     object{Tree2}
     object{Foliage2}
     scale 5/35
     translate <-10,0,-20>
}


// Tyre on a rope for tree

#declare tyreonarope=union{
cylinder { // Cylndr001
  <0,0,1>, <0,0,0>, 1 
  scale <0.05, 0.05, 6.0>
  translate  1.5*z
}
torus { // Torus001
  1.65, 0.35  rotate -x*90
  rotate -90.0*x
}
}

object{tyreonarope scale 1/4 rotate x*-90 translate <-10,3,-18>}



#include "cartwheel.inc"

object{cartwheel rotate z*30 rotate y*45 scale <1,.8,1>*.8 translate<4,.3,-6>}

#include "potterswheel_m.inc"
#include "potterswheel_o.inc"
object{potterswheel scale 1/8 rotate x*-90 rotate y*20 translate <3.5,.70,-4>}

#include "paperposter.inc"

object{paperposter scale 1.2/6 rotate y*90 rotate x*60 rotate z*-3 translate <5.9,3.2,-2>}


//Exclude almost all end.
#end

light_group{

light_source {
  0*x                 
  color rgb <1,1,1>/1.5
  translate <-1500, 150, -1000>}

box {
  <-6, 0, 0>,  // Near lower left corner
  < 6, 8, 10>   // Far upper right corner
  hollow
  pigment {rgbf 1}
  interior{
    media{
      samples 20
      method 3
      scattering {1, <.02,.02,.02> }
    }
  }
}
}