
#ifndef (__BubbleBlastH)
#declare __BubbleBlastH = 42;


// BubbleBlast macro.
// make a blast of bubbles starting at 0,0,0 and going up towards height.

// are you rendering just this file? (changes camera, landscape, etc.)
// make a #declare INCLUDAGE in the main file to suppress camera definitions, etc..

#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
#end

//#include "rand.inc"
#include "textures.inc"


#macro BubbleBlast (Radius, height, speed, BubbleCount, BubbleStartSize, yourStream)
union {

// dissipate bubble amount as y increases.
	// also, bubbles on outer edges will be less as y increases.
	#local divCount = height/speed;
	#local increment = height / divCount;
	
	#local Counter = 0.00000001;
	#local MakeThisMany = BubbleCount;
	
	#local sizer = BubbleStartSize * 2;
	#local warblizer = height/(2*pi) ;
	#local divsDone =  0;

#debug "\nBuilding Bubbles...\n"
	
	#while (Counter < height)

	
		#local SphereCounter = 0;
		#while (SphereCounter < MakeThisMany)
			// place a sphere
			#local Point = 
					< (rand(yourStream)-.5)*Radius * (Radius/4+(height - Counter) / height),
						(rand(yourStream)-.5) *  increment + Counter, 
						(rand(yourStream)-.5)*Radius * (Radius/4+(height-Counter)/height)>;
			
				sphere {<0,0,0>, sizer 
							scale <(rand(yourStream) * .50) + .50  , (rand(yourStream) * .50) + .65 , (rand(yourStream)* .50) + .50 >  // oblong-ness
							scale (rand(yourStream) * .40) + .80 // size
							rotate <(rand(yourStream) * 20) -10   , (rand(yourStream)* 20) -10 , (rand(yourStream)* 20) -10 >  // oblong-ness
							
							translate Point
							translate <(rand(yourStream) - .5) * (Radius * cos (warblizer/Counter)), 
											0, 
											(rand(yourStream)- .5) * (Radius * cos(warblizer/Counter))>
							}
			#local SphereCounter = SphereCounter + 1;
		#end

		#local MakeThisMany = MakeThisMany / 2;
		#local sizer = sizer * .97; // 1 -  divsDone/divCount ;  //.90 //  ln((height - Counter))/ln(height) ; 
		#local Counter = Counter + increment;
		#local divsDone = divsDone +1 ;
	#end

//	pigment {rgb <1,0,0>}
//}
}
#end

// use Blobs instead of spheres.
// good for clumps. Bad for fizz.
#macro BubbleBlast2 (Radius, height, speed, BubbleCount, BubbleStartSize, yourStream)
//union {

blob {

	threshold 1 //.2
// dissipate bubble amount as y increases.
	// also, bubbles on outer edges will be less as y increases.
	#local divCount = height/speed;
	#local increment = height / divCount;
	
	#local Counter = 0.00000001;
	#local MakeThisMany = BubbleCount;
	
	#local sizer = BubbleStartSize * 2;
	#local warblizer = height/(2*pi) ;
	#local divsDone =  0;

#debug "\nBuilding Bubbles...\n"
	
	#while (Counter < height)

	
		#local SphereCounter = 0;
		#while (SphereCounter < MakeThisMany)
			// place a sphere
			#local Point = 
					< (rand(yourStream)-.5)*Radius * (Radius/4+(height - Counter) / height),
						(rand(yourStream)-.5) *  increment + Counter, 
						(rand(yourStream)-.5)*Radius * (Radius/4+(height-Counter)/height)>;
			
				sphere {<0,0,0>, sizer *2.6, strength 1.2 //1 
							scale <(rand(yourStream) * .50) + .50  , (rand(yourStream) * .50) + .65 , (rand(yourStream)* .50) + .50 >  // oblong-ness
							scale (rand(yourStream) * .40) + .80 // size
							rotate <(rand(yourStream) * 20) -10   , (rand(yourStream)* 20) -10 , (rand(yourStream)* 20) -10 >  // oblong-ness
//
//
//							scale <(rand(yourStream)* .25) + .75  , 1, (rand(yourStream)* .25) + .75 >  
							translate Point
							translate <(rand(yourStream) - .5) * (Radius * cos (warblizer/Counter)), 
											0, 
											(rand(yourStream)- .5) * (Radius * cos(warblizer/Counter))>
							}
			#local SphereCounter = SphereCounter + 1;
		#end

		#local MakeThisMany = MakeThisMany / 2;
		#local sizer = sizer * .97; // 1 -  divsDone/divCount ;  //.90 //  ln((height - Counter))/ln(height) ; 
		#local Counter = Counter + increment;
		#local divsDone = divsDone +1 ;
	#end

//	pigment {rgb <1,0,0>}
//}
}
#end



#if (RenderThisFileAlone)


#version 3.5;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0, 3, -50>
  right     4/3*x
  look_at   <0, 2,  0.0>
	angle 40
}
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb <.9, .8, .9>*.7] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

sphere {<0,0,0>, 1 pigment {color rgbt <1,0,0, .6>}}
#local Stream = seed(3);
object {
BubbleBlast(1, 10, .6, 5, .2, Stream)
material {texture {pigment {Clear}
				finish {
					reflection {0.3, 1 fresnel}
					conserve_energy
					irid {.3 thickness .0}
				}
				}
//				interior {ior 1.33}
	}
}



#end

#end
