// the carmagnolle suit.
// this ridgid-bodied bad boy was just begging to be poseable.
// Therefore, he is.

// don't know if this is the best way to do it, but
// I hang the bodyparts like mistletoe from the origin towards -y
// then translate them relative to the other body parts using
// inherited transforms.


#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
#end

#declare INCLUDAGE = 1; 

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "right_stuff_textures.inc"
#include "bubbleblast.inc"
#include "yardstick.inc" // macro for measuring

#declare Seedling = seed (6532); //  for messing him up a bit.

// change if working on file:
#local CAR_WORKING_CAMERA = yes;


#ifndef (HARD_EDGES)
#local HARD_EDGES = no;
#end

#ifndef (BUBBLY)
#local BUBBLY = yes;
#end

#ifndef (RAD)
#local RAD = no;
#end

#local heads =  3.5/8 ; // to measure in heads.


// Transformations to pose Mr. Carmagnolle:


#declare Move_It_Mister = // move the entire suit around the waist point.
	transform {
		translate y * .10 * heads
	}

// x = bend, y = twist,  z = side-to-side
#declare Waist_Rot = // influences entire upper body.
	transform {rotate <-20, -5, 5>}
	
#declare Shoulder_Left_Rot = // will tranform all child bones.
	transform { rotate <-40, 0, 0 >}

#declare Shoulder_Right_Rot = // will mirror on the right arm
	transform { rotate <20, 20, 30>}

#declare Forearm_Left_Rot = 
	transform { rotate <25, 15, 0>}

#declare Forearm_Right_Rot = 
	transform { rotate <30, 30, 0>}

#declare Hand_Left_Rot = 
	transform { rotate <0, 0, 0>}

#declare Hand_Right_Rot = 
	transform { rotate <0, 0, 0>}

#declare Fingers_Left_Bend = .5 ;  // a percentage. 1 is completely closed, 0 is completely open.
#declare Fingers_Right_Bend = 0 ;  // a percentage. 1 is completely closed, 0 is completely open.



	
#declare Thigh_Left_Rot =
	transform { rotate <30, 0, 10>}
#declare Thigh_Right_Rot =
	transform { rotate <-80, 0, 5>} // on a full sprint

#declare Shin_Left_Rot =
	transform { rotate <-30, 0, 0>}
#declare Shin_Right_Rot =
	transform { rotate <-8, 0, 0>}


#declare Foot_Left_Rot =
	transform { rotate <0, 0, 0>}
#declare Foot_Right_Rot =
	transform { rotate <-20, 0, 0>}
	
	
#local YARDSTICK = no;
#local YARDSTICK_UNITS = 2;
#local YARDSTICK_DOUBLE = no; // create a 3-D cross?
#local YARDSTICK_POS = 
transform {	
	rotate <0, 180 , 0>
	translate <0, 0, 0>

}

#declare mirrorMatrix  = // for creating the other side. switch x axis backwards.
transform {
	matrix <-1, 0, 0
						0, 1, 0,
						0, 0, 1,
						0, 0, 0>
}

#declare bluedIron = 
texture{
		pigment {
			bozo
			color_map {
				[ 0.300000 rgb <0.181704, 0.189761, 0.26> * .3]
				[ 1.00000 rgb <0.110000, 0.110000, 0.100000> * .3]
			}
			scale .2
		}
		normal {
			agate .08 // bozo .3
			scale .3 //<.5, .1, .5>
			turbulence 3
		}
		finish {
			diffuse .05  //.6
			ambient 0
			specular .8 // .5
			roughness  0.028
			metallic .3
			brilliance 2
			reflection .05
			irid {
				.2
				thickness .05
				turbulence .5
			}

		}
	}

#declare flatIron = // scuffed-up metal.
texture{
			pigment { rgb <0.181704, 0.189761, 0.22> * 4}
		normal {
			granite .05
			scale <.5, .1, .5>
			turbulence 1
		}
		finish {
			diffuse .1 //.8
			ambient 0
			specular  .8
			roughness 0.09
			metallic .3
			brilliance 2
		}
	}
	
#declare scratchedIron = 
material {
texture{
		granite 
		texture_map {
			[ 0.65 bluedIron  ] // .9
			[ 1.0 flatIron  ]
		}
		scale .8
	}

}


// for seeing better during testing:
#if(RenderThisFileAlone)
//#declare scratchedIron = 
//	material {texture {pigment {Yellow}}}
#end

// ************************

// for positioning:
#declare hipPoint = <0,.6, 0>; // hip influences entire upper body.
#declare neckPoint = hipPoint + y*1.7*heads;

#declare aBolt =  // for bolting stuff together
		sphere {0, .03 material {scratchedIron}}

#declare Helmet=
union {
		// helmet
		sphere {<0,0,0>, heads* .75 material {scratchedIron}}
		// cross-beams
		cylinder{ <0,0, -.05*heads>, <0, 0, .05*heads>, heads * .85 material {scratchedIron}}
		
		cylinder{ <0,0, -.02*heads>, <0, 0, .02*heads>, heads * .85
					rotate y*90 
					material {scratchedIron}
					}
		//nutcracker
		difference {
			torus { 1 * heads, heads * .05 		sturm } // ring
					
			box { // slice thru middle
			<-heads*3, -heads*3, - .4 * heads>, <heads*3, heads*3, .4 * heads>
			}
			material {texture  {flatIron}}
		}

	#local aBar = // his front left bar, transformed & duped below
		union {
			sphere_sweep {
			cubic_spline,
			9, 
			<1 * heads,0 * heads, -1.8 * heads>, 0.17 * heads // control
			<.875 * heads, 0, -.45 * heads>, 0.07 * heads // into curve
			<1 * heads, .1 * heads, -.55 * heads>, 0.06 * heads // above
			<1 * heads, 0 * heads, -.7 * heads>, 0.05 * heads // hook down
			<.6 * heads,  -.4 * heads, -.6 * heads>, 0.05 * heads
			<.4 * heads,  -.6 * heads, -.6 * heads>, 0.05 * heads // top breastplate
			<.3 * heads,  -1 * heads, -.8 * heads>, 0.05 * heads // mid
			<.4 * heads,  -1.9 * heads, -.5 * heads>, 0.05 * heads //bottom breastplate
			<.4 * heads,  -1 * heads, -0 * heads>, 0.05 * heads // control

			tolerance 1.0e-6
			}
		// eye hooks:
			union {
				torus {.1 * heads, .05 * heads sturm rotate <90, 90, 0>	
					translate <.4 * heads,  -1.9 * heads, -.5 * heads>}
				torus {.1 * heads, .05 * heads rotate x*90
					translate <.4 * heads,  -2 * heads, -.4 * heads>}
				box {<.2 * heads, -2 * heads, -.5 * heads>
						<.5 * heads, -1.5 * heads, -.55 * heads>}
			material {scratchedIron}
			}
		}
		union {
		object {aBar}
		object {aBar transform {mirrorMatrix}}
		object {aBar transform {rotate y *180}}
		object {aBar transform {mirrorMatrix rotate y * 180 }}
		material {texture {flatIron}}
		}
		
		box {<-.1*heads, -2 * heads, -.6 * heads> // breast split
			<.1*heads, -.2 * heads, -.4 * heads> material {scratchedIron} }
		#local aPort=
		union {
			difference {
				cylinder {<0,0,0>, <0,0,-.08*heads>, .12 * heads}
				cylinder {<0,0,.1>, <0,0,-.09*heads>, .10 * heads}
			material {scratchedIron}
			}
			cylinder {<0,0,-.07 * heads>, <0,0,-.08*heads>, .115 * heads material {M_NB_Old_Glass}}
		}
		union {
		#local counter = 0;
		#while (counter <4 )
		
		#local onePort = 
			object {aPort translate <0, 0, -.75*heads>
			rotate y * 15
			rotate x * 43  // slide up helmet
			rotate x * -25 * counter
			//translate x * -.25
			// rotate z * counter * 90 /4
			}
		object {onePort}
		object {onePort 
			matrix // flip on x axis (make a bizarro copy on other side of helmet)
				<-1, 0, 0
					0, 1, 0,
					0, 0, 1,
					0, 0, 0>
		}
		
		#local counter = counter + 1;
		#end
		}
		
		// another column, just spaced a bit more
		union{
		#local counter = 0;
		#while (counter <4 )
		
		#local onePort = 
			object {aPort translate <0, 0, -.75*heads>
			rotate y * 38
			rotate x * 55  // slide up helmet (trying to make it look hand-made)
			rotate x * -30 * counter
			//translate x * -.25
			// rotate z * counter * 90 /4
			}
		object {onePort}
		object {onePort 
			matrix // flip on x axis (make a bizarro copy on other side of helmet)
				<-1, 0, 0
					0, 1, 0,
					0, 0, 1,
					0, 0, 0>
		}
		
		#local counter = counter + 1;
		#end
		}
		
		
		// and another column, only 3 this time. 
		union{
		#local counter = 0;
		#while (counter <3 )
		
		#local onePort = 
			object {aPort translate <0, 0, -.75*heads>
			rotate y * 60
			rotate x * 60 
			rotate x * -40 * counter
			//translate x * -.25
			// rotate z * counter * 90 /4
			}
		object {onePort}
		object {onePort 
			matrix // flip on x axis (make a bizarro copy on other side of helmet)
				<-1, 0, 0
					0, 1, 0,
					0, 0, 1,
					0, 0, 0>
		}
		
		#local counter = counter + 1;
		#end
		}

	// put bottom at origin (neck point)
	translate y * .75 * heads
	translate y * - .1 * heads // scootch down a bit.
	translate neckPoint // move to neck point
} // end of helmet



#declare shoulderRadius = .65 * heads;
#declare aShoulder =
union {
		sphere {<0,0,0> shoulderRadius material {scratchedIron}}
	#local counter  = 0;
	#while (counter < 4)
			difference {
				// make a bit bigger:
				#local myRad = shoulderRadius +  counter * .08 * heads;
				sphere {<0,0,0>, myRad}
				box { -1 * myRad , <0, myRad*2, myRad*2> // cut in half.
						}
	
			material {scratchedIron rotate counter * 12.89} // put here to make it look different from others
	
				rotate y * 150
	//			rotate z * -25
				rotate y * counter * 20 /// * 20/4
	//			rotate y * 90
			}
			#local counter = counter + 1;
	#end
	
		object {aBolt  rotate z * 90 
					translate y * (shoulderRadius + .1 * heads)
					rotate z * 10
		}	

	// to work the joints:
	// will move the origin of an object to this point
	#declare shoulderPointL = 
	transform {
		translate
			<	.75 * heads, 			// to the right
				-shoulderRadius 	// origin at top of spheres (y)
				+ .1 * heads, 0> 	// scootch up
		translate neckPoint 			// to neck point
		
	}
	
	#declare shoulderPointR = 
	transform {
			translate
			<	-.75 * heads, 			// to the left
				-shoulderRadius 	// origin at top of spheres (y)
				+ .1 * heads, 0> 	// scootch up
		translate neckPoint 			// to neck point
	}
						

}

//sphere {shoulderPointR, 1 * heads pigment{Red}}

// shoulders (fixed)
#declare Shoulders=
union {
object {aShoulder 	transform shoulderPointL}
object {aShoulder transform shoulderPointL // make a right shoulder by mirroring.
			transform { mirrorMatrix}}

//translate neckPoint // send to neck.
}

// the Bicep, which is the part  that can move.

#declare ShoulderTransL = // inherit from shoulder point.
transform {
	rotate <30, 0, 30> // the most natural position of Bicep. ( can be changed at top)
	transform shoulderPointL
}

#declare ShoulderTransR = // inherit from shoulder point.
transform {
	mirrorMatrix // reverse of left 
	rotate <30, 0, -30> // the most natural position of Bicep. ( can be changed at top)
	transform shoulderPointR
}

#declare Bicep = 
// left Bicep: (origin is at the shoulder joint)
union {
#local foreLen = 1;
#local elbowRadius = .45 * heads;

cylinder {0, <0, -foreLen * heads, 0>, .4 * heads}
difference {
	sphere {0, elbowRadius }
	box {-heads, <heads, 0, heads>} // cut off bottom half
	rotate x * -10 // cover the inner ball a bit.
	translate y*  -foreLen * heads
}

// coverings for elbow:
	union {
		difference { // outer cover
			sphere {0, .5 * heads}
			sphere {0, .48 * heads}
			box {-1.3 *heads, <heads, heads, -.25 * heads>} // shave off a part
			scale <1, 1.2, 1>
					rotate x * -50
	
			translate y *  -.45 * heads/2 // scootch down to meet ball
			translate y * -foreLen * heads
		}
		difference { // inner cover
			sphere {0, .48 * heads}
			sphere {0, .46 * heads}
			box {-1.3 *heads, <heads, heads, -.25 * heads>} // shave off a part
			scale <1, 1.2, 1>
			rotate y * 20	
			rotate x * -60
			translate y *  -.3 * heads/2 // scootch down to meet ball
			translate y * -foreLen * heads
		}
		
		object {aBolt  translate x * (elbowRadius * 1.2)
			rotate y * 80
			translate y * -foreLen * heads
		}
		
		
		translate y * .2 * heads // make uip for my mistakes
	}
#declare elbowTransL = 
	transform {
		rotate <30, 0, -10> //  natural position
		translate y * -foreLen * heads // middle of ball.
		Shoulder_Left_Rot // inherit shoulder movements
		ShoulderTransL
	}

#declare elbowTransR = 
	transform {
		rotate <30, 0, -10> //  natural position
		translate y * -foreLen * heads // middle of ball.
		Shoulder_Right_Rot // inherit shoulder movements
		ShoulderTransR 
	}

	material {scratchedIron}

} // end BicepL

#declare BicepL =
	object {Bicep	
		transform {Shoulder_Left_Rot} // user's rotate (above)
		transform {ShoulderTransL} // from a natural position.
	}

#declare BicepR =
	object {Bicep	
	transform {Shoulder_Right_Rot} // user's rotate (above)
	transform {ShoulderTransR} // from a natural position.
	}




// Forearm
#declare Forearm = 
union {
	sphere {0, elbowRadius - .1 * heads} // elbow joint
	cylinder {0, <0, -1 * heads, 0> , .2 * heads} //  main part
	cylinder {<0, -.65 * heads, 0>, <0, -.75 * heads, 0>, .25 * heads} // cuff
	difference { // wrist:
		sphere {0, .32*heads}
		box {-heads, <heads, 0, heads>}
		translate y * -1 * heads
	}
	material {scratchedIron}
}
// wrist test
//cylinder {0, <0, -2* heads, 0>, .2*heads pigment {Red} transform {wristJointL}}

#declare wristJointL = // for the hand.
	transform {
		rotate <0,0,0> // natural position
		translate y * -1 * heads  // to the joint
		Forearm_Left_Rot // user adjust
		elbowTransL
	}

#declare wristJointR = // for the hand.
	transform {
		rotate <0,0,0> // natural position
		translate y * -1 * heads
		Forearm_Right_Rot // user adjust
		elbowTransR
	}
		

#declare ForearmL=
object {
Forearm 
	transform {
	Forearm_Left_Rot
	elbowTransL
	}
}


#declare ForearmR=
object {
Forearm 
	transform {
	Forearm_Right_Rot
	elbowTransR
	}
}



// palm (includes thumb, but not fingers)
#declare Palm=
union {
	difference { // bearing:
		sphere {0, .28 * heads}
		box {-heads, < heads, -.05*heads, heads>}
	}
	#declare handBlob = 
			blob {
			threshold 1
			cylinder {
				0, <0, -.4*heads>, .28*heads*1.5 strength 2
			}
			sphere {
				<0, -.5*heads, 0>, 0.4 * heads, strength 1.5
			}
			sphere { // push a palm into it
				<0, -.54*heads, -.2 * heads>, 0.33 * heads, strength -4.8
			}
			sturm
		}
	difference {
		blob {handBlob}

//		cone {0, .28 * heads
//				<0,-.4*heads, 0>, .4 * heads} // palm approximation
		
		torus {.28 * heads, .08*heads translate y * -.15 * heads}	// wrist shaper
		box {-heads, <heads, -.45*heads, heads>} // chop for fingers (later in file)

	}
	// thumb
	sphere_sweep {linear_spline, 3
		<.1*heads, -.25*heads, -.1*heads>, .1 * heads
		<.1*heads, -.4*heads, -.3*heads>, .05 * heads
		<.05*heads, -.45*heads, -.3*heads>, .04 * heads
		}



	material {scratchedIron}
}

#declare FingerJointL = 
		transform {
			rotate <0, 20, 0> // natural position
			translate y *-.45 * heads // at the chop of hand
			Hand_Left_Rot // user adjust
			wristJointL		// inherit wrist movements
		}

#declare FingerJointR = 
		transform {
			rotate <0, 20, 0> // natural position
			translate y *-.45 * heads // at the chop of hand
			Hand_Right_Rot // user adjust
			wristJointR		// inherit wrist movements
		}


#declare PalmL =
	object {
		Palm
		transform {
			rotate <0, 20, 0> // natural position
			Hand_Left_Rot // user adjust
			wristJointL		// inherit wrist movements
		}
	}

#declare PalmR =
	object {Palm
		transform {
			rotate <0, 20, 0> // natural position
		Hand_Right_Rot // user adjust
		wristJointR		// inherit wrist movements
		}
	}


// joint tester:
//sphere {0, .2*heads pigment {Red} transform {FingerJointL}}

// fingers:
#declare fingers=
union {
	intersection {
		blob {handBlob}
		box {-heads, <heads, -.25*heads, heads>} // chop  fingers
		translate y * .45 * heads // move to finger joint
		material {scratchedIron}

	}

//	// gaskets for finger joint: (too much of a pain)
//	union {
//		torus {.28 * heads, .04 * heads rotate x*90
//		scale y * .8
//		scale z * 9.5	
//			translate y * .1*heads}
//	
//		torus {.28 * heads, .04 * heads rotate x*90
//			scale y*.8 
//			translate y * 0 * heads}
//		material {Rubber_Mat}
//	}
}


#local bendability = 100;
#declare FingersL = 
object {
	fingers
	rotate x * bendability * Fingers_Left_Bend  // user ajusts by percentage.
	transform {FingerJointL} // inherit hand movements
}

#declare FingersR = 
object {
	fingers
	rotate x * bendability * Fingers_Left_Bend  // user ajusts by percentage.
	transform {FingerJointR} // inherit hand movements
}

// the HIP and it's children (the legs, etc.)

#local hipJointRadius = .58 * heads;


// hip
#local hipRadius = 2*heads;
#declare Hip = 
union {
	superellipsoid {<.75 .6> 
		scale hipRadius/2
		scale <1, .8, .5>
		
		translate y * - hipRadius/4 // line top to hipJoint
		}

//	#local counter = 1;
//	#local aP =
//	union {
//	#while (counter < 4) // coverings for thighs
//		difference { // left
//			intersection { 
//				sphere { 0, hipJointRadius + .03 * heads + counter * .03*heads}
//				box {<-heads,-hipJointRadius/3, -heads> ,
//						<heads,hipJointRadius/3, heads>} // grab the middle
//			}
//			cylinder {y*heads, y*-heads, hipJointRadius + .05 * heads} // inner space
//			rotate x * (-65+ counter * 25 + 
//								(rand (Seedling) - 1) * 10 // mess it up a bit
//							)
//			translate x * hipRadius/2 * 1/2
//			translate y * - .9 * heads
//		}
//	#local counter = counter + 1;
//	#end
//	rotate x * 20
//	}
//	object {aP material {scratchedIron}}
//	object {aP material {scratchedIron} transform {mirrorMatrix}}


	
	material {scratchedIron}
	translate hipPoint
}

// TORSO
#declare Torso = // doesn't have it's own transform. Is done way down the file.
union {
	cylinder {//  body shaft
			neckPoint, (neckPoint - hipPoint)/3 + hipPoint ,.75* heads
			scale z* .5
	}
	
	cylinder {// lower body shaft
			hipPoint, (neckPoint - hipPoint)/3 + hipPoint ,.95* heads
			scale z* .5
	}
	// hip coverings
	#local oneHipper = 
	difference {
		intersection {
			sphere {0, hipRadius/2 }
			box {<-heads*3, -hipRadius/25, -heads*3>, // slice middle
					<heads*3, hipRadius/25, heads*3>
			}
		}
		cylinder { //inner space
			y * -heads * 3,
			y * heads * 3,
			hipRadius/2 * .98
		}
//			translate hipPoint

	}
	union {
		object {oneHipper rotate x* 0}
		object {oneHipper scale 1.1 rotate x* 10 }
		object {oneHipper scale 1.1 rotate x* 20}
		translate hipPoint
	}


	// bolts
	object {aBolt translate x * (hipRadius/2 + .1 * heads)
		translate hipPoint }
	object {aBolt translate x * -(hipRadius/2 + .1 * heads)
		translate hipPoint }

	
	material {scratchedIron}

}




// hip joints


#declare hipJointL = 
	transform {
		rotate <20, 0, 0> // natural position
		transform {Thigh_Left_Rot}
		translate hipPoint
		translate x * hipRadius/2 * 1/2
		translate y * -.9 * heads
	}
#declare hipJointR =
	transform {
		rotate <20, 0, 0> // natural position
		transform {Thigh_Right_Rot} // user adjust
		translate hipPoint
		translate x * hipRadius/2 * 1/2
		translate y * -.9 * heads
		transform mirrorMatrix
	}

#declare kneeJointRadius = hipJointRadius * 2/3;
#declare kneeDistance = (15/11)*heads ;
#declare thigh = 
union {
	sphere {0, hipJointRadius}
	#local counter = 1;
	#while (counter < 4) // coverings
	difference { // top
		intersection { 
			sphere { 0, hipJointRadius + .03 * heads + counter * .03*heads}
			box {<-heads,-hipJointRadius/3, -heads> ,
					<heads,hipJointRadius/3, heads>} // grab the middle
		}
		cylinder {y*heads, y*-heads, hipJointRadius + .05 * heads} // inner space
		rotate x * (-65+ counter * 25 + 
							(rand (Seedling) - 1) * 10 // mess it up a bit
						)
	}
		difference { // at knee
			intersection { 
				sphere { 0, kneeJointRadius + .03 * heads + counter * .03*heads}
				box {<-heads,-kneeJointRadius/3, -heads> ,
						<heads,kneeJointRadius/3, heads>} // grab the middle
			}
			cylinder {y*heads, y*-heads, kneeJointRadius + .05 * heads} // inner space			
			rotate x * (-40+ counter * 20 + 
								(rand (Seedling) - 1) * 10 // mess it up a bit
							)
			scale y * 1.8// stretch.
			translate -y * kneeDistance // go to knee.
	}
	#local counter = counter + 1;
	#end
	object {aBolt  translate x * (kneeJointRadius + .1 * heads)
			translate -y * kneeDistance // go to knee.
						}
	object {aBolt  translate x * -(kneeJointRadius + .1 * heads)
			translate -y * kneeDistance // go to knee.
			}
	object {aBolt  translate x * (hipJointRadius + .1 * heads)}
	object {aBolt  translate x * -(hipJointRadius + .1 * heads)}
		
	cylinder {0, -y*kneeDistance kneeJointRadius}		
	material {scratchedIron}
//	transform hipJointL
}

#declare KneeJointL =
	transform {
		rotate <0, 0, 0> // natural position
		Shin_Left_Rot // user adjust
		translate -y * (15/11) * heads
		hipJointL	// inherit the hip movements

}

#declare KneeJointR =
	transform {
		rotate <0, 0, 0> // natural position
		Shin_Right_Rot // user adjust
		translate -y * (15/11) * heads // slip down to knee point.
		hipJointR	// inherit the hip movements
}
	
#declare ThighR =
	object {thigh transform {hipJointR}}

#declare ThighL =
	object {thigh transform { hipJointL}}


#declare ankleJointRadius = .35*heads;
#declare ankleDistance = (15/11 * heads);
#declare Shin = 
union {
	sphere {0, ankleJointRadius}
	cylinder {0, y*-ankleDistance, .3 * heads}
	
	difference { // covering at ankle
			intersection { 
				sphere { 0, ankleJointRadius +  .03*heads}
				box {<-heads,-ankleJointRadius, -heads> ,
						<heads,0, 0>
//						scale 2
						rotate x * 45
//						scale y * .3
						} // grab a piece of pie (and then some)
			}
			cylinder {y*heads, y*-heads, ankleJointRadius + 0 * heads} // inner space			

			rotate x * 25
			scale y * 1.6 // stretch.
			translate -y * ankleDistance // go to knee.
	}
	object {aBolt  translate x * (ankleJointRadius + .01 * heads)
				translate -y * ankleDistance // go to knee.
		}
	object {aBolt  translate x * -(ankleJointRadius + .01 * heads)
				translate -y * ankleDistance // go to knee.
		}
	
	material {scratchedIron}
}

#declare ShinL =
	object {Shin transform {KneeJointL} }
	
#declare ShinR =
	object {Shin transform {KneeJointR} }


#declare ankleJointL = 
	transform {
		rotate <5, 2, 0> // natural position (little bow-legged)
		Foot_Left_Rot // user adjust
		translate -y *(15/11 * heads) // slip down to ankle point
		KneeJointL // inherit thigh movements
	}

#declare ankleJointR = 
	transform {
		rotate <5, 2 ,0> // natural position (little bow-legged)
		Foot_Right_Rot // user adjust
		translate -y *(15/11 * heads) // slip down to ankle point
		KneeJointR // inherit thigh movements
	}

#declare foot = 
union {
	sphere {0, .25*heads}
	#declare shoeBlob = 
		blob { threshold 1
			cylinder { <0, 0 * heads,0> <0, -.25 * heads, -.2 * heads>  .43 * heads strength 1.8 } // ankle
			cylinder { <0, -.5 * heads, .25* heads>, <0, -.5 * heads, -.7 * heads>, .6 *heads strength 2} // foot 
			sphere {x * -.4 * heads, .3 strength -1.5} // arch
		}
		
	difference { // top of shoe
			blob {shoeBlob}
		box {-heads*2, <heads*2, -.5 * heads, heads*2> } // bottom sole}
	}

	intersection { // sole of shoe
			blob {shoeBlob  scale 1.08}
		box {<-heads*2, -.6*heads, -heads*2>, <heads*2, -.5 * heads, heads*2> } 
	}

	material {scratchedIron}
}

#declare FootL =
object {foot transform {ankleJointL}}
#declare FootR =
object {foot transform {ankleJointR}}




#declare Carmagnolle = 
union {
	union {
		object {Helmet}
		object {Shoulders}
		object {Torso}
		object {BicepL}
		object {BicepR}
		object {ForearmL}
		object {ForearmR}
		object {PalmL}
		object {PalmR}
		object {FingersL}
		object {FingersR}
		translate -hipPoint // get to origin
		transform Waist_Rot // rotate everything
		translate hipPoint // go back up
	}
	union {		
		object {Hip}
		object {ThighR}
		object {ThighL}
		object {ShinL}
		object {ShinR}
		object {FootL}
		object {FootR}
	}
	transform {Move_It_Mister}
}






// *************************************
#if (RenderThisFileAlone)

global_settings
{
  assumed_gamma .8 // make brighter for posing
	#if (RAD)
	radiosity {}
	ambient_light 0.005
	#end
//	ambient_light 0
}


camera
{
  location  <-4, 0, -3.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-.6, 0,  0.0>
}

#ifdef (CAR_WORKING_CAMERA)
#if (CAR_WORKING_CAMERA)
camera // working camera
{
	
	location hipPoint   +<0 * heads, 0 *heads, -13 *heads>
  direction 1.5*z
  right     4/3*x
  look_at   hipPoint + <0, 0 * heads,  0>
}
#end
#end

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color rgb 1// red 1.0  green 1.0  blue 1.0  // light's color
  translate <-8, 8, -8>
}


light_source
{
  0*x // light's position (translated below)
  color rgb .8   // light's color
  translate <0,  8, -60>
}

plane { y, -1 pigment {color rgb <0.3,0.5,0.7>}}

object {Carmagnolle}

#if (YARDSTICK)
object {YardStick (YARDSTICK_UNITS, YARDSTICK_DOUBLE)
	rotate y*180
	translate shoulderPointL
	
//	transform YARDSTICK_POS
}
#end

#end
