
// put Klingert on stage.


// are you rendering just this file? (changes camera, landscape, etc.)
// make a #declare INCLUDAGE in the main file to suppress camera definitions, etc..

#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
// change if working on file:
//#local KLING_WORKING_CAMERA = yes;
#end

#ifndef (HARD_EDGES)
#local HARD_EDGES = no;
#end

#ifndef (BUBBLY)
#local BUBBLY = no;
#end

#ifndef (RAD)
#local RAD = no;
#end


#declare INCLUDAGE = 27;

#include "metals.inc"
#include "textures.inc"
#include "right_stuff_textures.inc"
#include "bubbleblast.inc"


#if (RenderThisFileAlone)

#version 3.5;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
	#if (RAD)
	radiosity {}
	ambient_light .1
	#end
}

// ----------------------------------------
camera
{
  location  <-.6, 0.6, -8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-.6, 0.3,  0.0>
}

#ifdef (KLING_WORKING_CAMERA)
#if (KLING_WORKING_CAMERA)
camera // working camera
{
	location <-5, 0.6, -4.0>  
  direction 1.5*z
  right     4/3*x
  look_at   <-.6, 0.6,  .5>
}
#end
#end

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.3,0.5,0.7>}}

#end // render this file alone



// **********************************************


#include "klingert.inc" // objects 


#declare age_tex=
	texture{
		pigment {
			granite
			#if (RAD)
						color_map {
				[ 0.000000 rgb <0.745098, 0.517647, 0.290196>  filter  .7 transmit .9 ]
				[ 0.200000 rgbft <0.789395, 0.699657, 0.430594>  filter  .7 transmit .9 ]
				[ 1.000000 rgbft <0.915999, 0.911192, 0.843977> filter  .7 transmit .9 ]
			}
			#else
			color_map {
				[ 0.000000 rgbft <0.745098, 0.517647, 0.290196, .2, .9>]
				[ 0.200000 rgbft <0.789395, 0.699657, 0.430594, .2, .9>]
				[ 1.000000 rgbft <0.915999, 0.911192, 0.843977, .2, .9>]
			}
			#end
		}
		scale .3
	}
	
#declare clasp_material =
material {
	texture {
		pigment {P_Brass3 }
		normal { dents 1.5 scale .3}		
		finish {
			#if (RAD)
				ambient 0
				diffuse .8
			#else
			    ambient 0.30
			diffuse .4
			brilliance 3
			#end    	
		    metallic
		    specular 0.70
		    roughness 1/60
		    reflection 0.25
		}
	}
	
	texture{age_tex}
}

#declare helmet_material=
material {
	texture {
		pigment {P_Chrome2}
		normal { dents 1.5 rotate y * 60 scale .1}
		finish {
			#if (RAD)
			 	ambient 0
				diffuse .6
			#else
			   ambient 0.35
			    diffuse 0.4 // .6
			#end
	    brilliance 2
	    metallic
	    specular 0.80
	    roughness 1/20
	    reflection 0.1
		}
	}

 texture {age_tex}
}

#declare shiny_cloth=
material {
		texture{
		pigment {
			rgb <0.285832, 0.280003, 0.349996>
		}
		normal {
			wrinkles .8
			scale <.03, .06, .03>
		}
		finish {
			#if (RAD)
				ambient 0
			#else
				ambient .1
			#end
			reflection {
				rgb <.02, .02, .02>,
				rgb <0.0, 0.0, 0.0>
			}
			diffuse 0.15
			specular .1
			roughness .010
		}
	}
	scale .5
}

#declare klingert = // dude, this is long!.......
union {
	union { // the pants & other puffy stuff.
				
		
		
		mesh {Figure material {Skin}}
		union {
			mesh {kling_pants}
			mesh {right_sleeve }
			mesh {left_sleeve }
			mesh {middle_shirt }
			material {shiny_cloth}
		}
		
		translate y* ( - .00787) // place on origin
		scale 1.82/.420300 // comparable to others
		translate <0, -1.1, .6> // place to ground.
	}
	
	#declare helm_transform=
	transform {
		rotate < -16, 0, -5>
		translate <-.81,.7, .23>
	}
	
	cylinder { //bottom of suit
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.63, .4, .63>
		material {helmet_material}
		transform {helm_transform}
	}
	
	cylinder { //pants to midsection clasp
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.638, .03, .638> 
		translate y * - .18
		material {clasp_material}
		transform {helm_transform}
	
	}
	
	cylinder { //shirt to midsection clasp
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.638, .03, .638>
		translate y * .19
		material {clasp_material}
		transform {helm_transform}
	
	}
	
	cylinder { //shirt to helmet clasp
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.65, .03, .65>
		translate y * .56
		material {clasp_material}
		transform {helm_transform}
	
	}
	
	// the helmet & metal body:
	union {
		difference {
		#declare eyeheight = .8;
	#declare eyerot = 18	;	
		#declare outerH=
			union { // the helmet shape.
				sphere {
					<0.0, 0.0, 0.0>, 0.5
					scale .63
				}
				cylinder { 
					<0.0, -1, 0.0>, <0.0, 0, 0.0>, 0.5
					scale <.63, .35, .63> 
				}
				translate y*.9
			}
			object {outerH}
			object {outerH scale .9}
			// eye holes
			union{
				cylinder {
					<0, eyeheight, -.5>, <0, eyeheight, 0> , .06
					rotate y * eyerot
				}
			
				cylinder {
					<0, eyeheight, -.5>, <0, eyeheight, 0> , .06
					rotate y * -eyerot
				}
				rotate y * -5 // look a bit to the left.
			}
				material {helmet_material}
		} // end difference
		
		// eye glass
		union {
				sphere {
					<0, 0, 0> , .06
					scale <1,1,.7>
					translate <0, eyeheight, -.29>
					rotate y * eyerot
				}
			
				sphere {
					<0, 0, 0> , .06
					scale <1,1,.7>
					translate <0, eyeheight, -.29>
					rotate y * -eyerot
				}
				rotate y * -5 // look a bit to the left.
				texture {NBoldglass}
		}
		// eye sockets
		union {
				torus {
					.06, .008
					rotate x *90
					translate <0, eyeheight, -.31>
					rotate y * eyerot
				}
			
				torus {
					 .06, .008
					rotate x *90
					scale <1,1, 1>
					translate <0, eyeheight, -.31>
					rotate y * -eyerot
				}
				rotate y * -5 // look a bit to the left.
				material {Rubber_Mat} //{helmet_material}
		}
	
	
		// hose jack
		#declare hoseHeight = .65 ;
			union{
				torus { // next to helmet
					 .07, .01
					rotate x *90
					scale <1,1, 1>
					translate <0, hoseHeight, -.31>
				}
				cylinder {
					<0, hoseHeight, -.4>, <0, hoseHeight, -.3> , .06
				}	
				torus { // around hoses
					 .07, .0081
					rotate x *90
					scale <1,1, 1>
					translate <0, hoseHeight, -.4>
				}
				cylinder {
					<0, hoseHeight, -.41>, <0, hoseHeight, -.4> , .07
				}	
	
				material {Rubber_Mat }
					rotate y * -5 // look a bit to the left.
		}
		
		transform {helm_transform}
	
		
	
	}
	
	
	// hoses
	#local hoseRad = .03;
	union {
	//	sphere {0, .045 } // beginning of nose
	//	sphere {-z*.2, .045 } // coming out
	//	sphere {<-.3, -.6, -.2>, .045 } // towards waist
	//	sphere {<-.25, -.65, .2>, .045 } // at waist
	//	sphere {<-.25, -1, 1.4>, .045 } // behind waist
	//	sphere {<-.25, -1.5, 1.5>, .045 } // sinking
	//	sphere {<-.25, -1.4, 1.6>, .045 } // upwards
	//	sphere {<-0, 0, 2.5>, .045 } // upwards
	//	sphere {<.4, 2, 3>, .045 } // gone
	
		sphere_sweep { // upper
		cubic_spline,
		11,
		0, hoseRad  // control
		0, hoseRad  // beginning of nose
		<0,0, - .2>, hoseRad  // coming out
		<-.3, -.6, -.2>, hoseRad  // towards waist
		<-.28, -.65, .2>, hoseRad  // at waist
		<-.25, -1, 1.2>, hoseRad  // behind waist
		<-.25, -1.5, 1.5>, hoseRad  // sinking
		<-.25, -1.4, 1.6>, hoseRad // upwards
		<-0, 0, 2.5>, hoseRad  // upwards
		<.4, 2, 3.5>, hoseRad  // gone
		<.4, 4, 6>, hoseRad  // control
		
	//	pigment {Yellow}
		}
		
		sphere_sweep { //lower
		cubic_spline,
		11,
		<0,-0.03,0>, hoseRad  // control
		<0,-0.04,0>, hoseRad  // beginning of nose
		<0, -0.03, -.1>, hoseRad  // coming out
		<-.3, -.5, -.2>, hoseRad  // towards waist
		<-.28, -.6, .2>, hoseRad  // at waist
		<-.25, -.95, 1.2>, hoseRad  // behind waist
		<-.1, -1.5, 1.5>, hoseRad  // sinking
		<-.1, -1.4, 1.6>, hoseRad // upwards
		<.05, 0, 2.>, hoseRad  // upwards
		<.5, 2, 3>, hoseRad  // gone
		<.4, 4, 6>, hoseRad  // control
		
	//	pigment {Green}
		}	
		
		translate <0,hoseHeight + .02, -.4> rotate y* -5 transform {helm_transform}
		material {Rubber_Mat}
	}
	
	cylinder { // left arm clasp
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.21, .03, .4> * .95
		rotate <-43, 0, 46>
		translate z*-.02
		translate <-.415,.976, .38>
		material {clasp_material}
	}
	
	cylinder { // right arm clasp
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.25, .03, .4> * .95
		rotate <4, 0, -15>
		translate <-.74, 0, -.32>
		translate <-.415,.92, .46>
		material {clasp_material}
	}
	
	// the cloth snaps on the body of suit.
	union {
	#local counter = 0;
	#while (counter < 360)
		box {
			 <-.5, -.5, -.5>, < .5,.5,-.4>
			scale <.05, .05, .63>
			rotate z*45 // diamond
			rotate y*counter
			scale <1,1.5, 1>
			translate y * -.165
		}
		box { // top
			 <-.5, -.5, -.5>, < .5,.5,-.4>
			scale <.05, .05, .63>
			rotate z*45 // diamond
			rotate y*counter
			scale <1,1.5, 1>
			translate y * .165
		}
		box { // helmet
			 <-.5, -.5, -.5>, < .5,.5,-.4>
			scale <.05, .05, .63>
			rotate z*45 // diamond
			rotate y*counter
			scale <1,1.5, 1>
			translate y * .58
		}
		
	#local counter = counter + 24;
	#end
	
	
	// extra cloth to hide defects.
	cylinder { //top
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.635, .07, .635>
		translate y * .185
	}
	cylinder { //bottom
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.635, .07, .635>
		translate y * - .185
	}
	cylinder { 
		<0.0, -0.5, 0.0>, <0.0, 0.5, 0.0>, 0.5
		scale <.635, .05, .635>
		translate y * .565 // helmet
	}
		material {shiny_cloth}
	
		transform {helm_transform}
	}	
	
	// the metal snaps on cloth:
	union {
	#local counter = 0;
	#while (counter < 360)
		sphere { <0,0,-.63/2>, .01
			rotate y*counter
			translate y * -.15 // bottom
		}
		sphere { <0,0,-.63/2>, .01 
			rotate y*counter
			translate y * .15 // top
		}
	
		sphere { <0,0,-.63/2>, .01 
			rotate y*counter
			translate y * .595 // helmet
		}
	
	
	#local counter = counter + 24;
	#end
		material {helmet_material}
		transform {helm_transform}
	}

#if (BUBBLY)
#local Stream = seed(12);
	
	union {
	
			// mouth:
		object {BubbleBlast(.1, 5, .081, 4, .018, Stream) 
			translate <-.75,1.2, -.8>
		rotate x * 15 // rotate for speed look
		}
	
			// suit:
		object {BubbleBlast(.4, 5, .081, 30, .015, Stream) 
		rotate < 30, 0, 30> // rotate for speed look
		
			translate <-.75,.8, .1>
		}
				// pants:
				// left
	//	object {BubbleBlast(.2, 5, .081, 7, .01, Stream) 
	//		translate <-.7,-.25, -.2>
	//	}
		// right
//		object {BubbleBlast(.2, 5, .081, 8, .01, Stream) 
//		rotate x * 30 // rotate for speed look
//			translate <-1.1,-.3, .2>
//		}
		// hoses on right hips
		object {BubbleBlast(.2, 5, .081, 30, .01, Stream) 
			translate <-1.1,.4, .1>
		}
	
		// backside 
		object {BubbleBlast(.8, 3, .081, 30, .02, Stream) 
	rotate < 15, 0, 30>
			translate <-.8,1.2, .4>
		}
		// bubble trail 
		object {BubbleBlast(1.2, 3, .081, 60, .01, Stream) 
	rotate < 80, 0, 30>
			translate <-.8,1.2, .8>
		}
		material {air_bubble_mat}
	
	}
#end // bubbly

} // end klingert union. Whew!

#if (RenderThisFileAlone)
object {klingert}
#end
