// davinci helmet
// #declared as "leoHelmet"
// made to fit around a head that is 1 unit high.
// origin is at the neck.

#version 3.5;

// are you rendering just this file? (changes camera, landscape, etc.)
// make a #declare INCLUDAGE in the main file to suppress camera definitions, etc..

#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
#end

#local RIGID_HOSES = no; // keep nose hoses in state of perfection?

#ifndef (HARD_EDGES)
#local HARD_EDGES = no;
#end

#ifndef (BUBBLY)
#local BUBBLY = yes;
#end

#ifndef (RAD)
#local RAD = no;
#end


// declare now, so others know.
#declare INCLUDAGE = 27;

#include "textures.inc"
#include "right_stuff_textures.inc"



#include "colors.inc"


#declare helmetLeather = 
material {
		texture{
		pigment {
			bozo
			color_map {
				[ 0.000000 rgb <0.735988, 0.367956, 0.184009> ]
				[ 0.500000 rgb <0.740291, 0.440864, 0.279683> ]
				[ 1.000000 rgb <0.789990, 0.621988, 0.509987>  ]
			}
			scale .2
		}
		normal {wrinkles .4  scale .05 turbulence .2}
		finish {
			specular .3
			roughness .08
		}
	}
}

#declare goggleRims =
material {
		texture{
		pigment {
			granite
			color_map {
				[ 0.000000 rgb <0.331823, 0.312795, 0.367178> * .8 ]
				[ 1.000000 rgb <0.278996, 0.440978, 0.297581> * .8 ]
			}
		}
		normal {
			wrinkles .5
			scale .05
		}
		finish {
			specular .75 
			roughness 0.064
			metallic .5
			#if (RAD)
			ambient 0
			diffuse .2
			#else
			ambient 0
			diffuse .2
			#end
		}
	}
}


#declare goggleGlass = 
	material {
		texture {
		    pigment { rgbf <0.98, 1, 0.99, 0.95> }
		    finish {
//		        ambient 0.1
		        diffuse 0.1
		        reflection .08
		        specular 1
		        roughness .001
		    }
		}
//	interior {Glass_Interior}
	}



#local nosePoint = <0, .2, -.5>;
#local noseSize = .15;
#local hoseSize = noseSize * .25; // smaller = more tentacle-like

#if (RIGID_HOSES)
#declare hose1 = 
sphere_sweep {
	cubic_spline,
	7, 
	nosePoint + <0,0,.5>, noseSize
	nosePoint, noseSize // at nose
	nosePoint + <.1, -.1, -.3> ,  // front of nose
			hoseSize + (noseSize - hoseSize) * .66

	nosePoint + <.5, -.25, 0>, hoseSize  + (noseSize - hoseSize) * .33  // bending out
	nosePoint + <.5, .2,  .4 >, hoseSize		// bending back
	nosePoint + <.1, 1, 1.2>, hoseSize // above head
	nosePoint + <0,1.6,0>, hoseSize // control
	material {helmetLeather}
}


#declare hose2 = 
sphere_sweep {
	hose1 
	transform {
	translate -nosePoint
	matrix // mirror along x.
	<-1,  0 ,0,
		0, 1, 0,
		0, 0, 1,
		0, 0, 0>
	translate nosePoint
	}
}

#else // not rigid hoses
#declare hose1 = 
sphere_sweep {
	cubic_spline,
	8, 
	nosePoint + <0,0,.5>, noseSize
	nosePoint, noseSize // at nose
	nosePoint + <.1, -.1, -.3> ,  // front of nose
			hoseSize + (noseSize - hoseSize) * .66

	nosePoint + <.3, -.1, -.3>, hoseSize  + (noseSize - hoseSize) * .33  // bending out
	nosePoint + <.3, 0,  -.1 >, hoseSize		// bending back
	nosePoint + <.7, .5, .8>, hoseSize // before head
	nosePoint + <.1, 1.5, 1.2>, hoseSize // above head
	nosePoint + <0,2,0>, hoseSize // control
	material {helmetLeather}
}


#declare hose2 = 
sphere_sweep {
	cubic_spline,
	8, 
	nosePoint + <0,0,.5>, noseSize
	nosePoint, noseSize // at nose
	nosePoint + <.1, -.1, -.3> ,  // front of nose
			hoseSize + (noseSize - hoseSize) * .66

	nosePoint + <.26, -.3, -.1>, hoseSize  + (noseSize - hoseSize) * .33  // bending out
	nosePoint + <.5, -.3,  -.1 >, hoseSize		// bending back
	nosePoint + <.5, .5, .8>, hoseSize // before head
	nosePoint + <.1, 1.5, 1.2>, hoseSize // above head
	nosePoint + <0,2,0>, hoseSize // control
	material {helmetLeather}
	
	transform {
	translate -nosePoint
	matrix // mirror along x.
	<-1,  0 ,0,
		0, 1, 0,
		0, 0, 1,
		0, 0, 0>
	translate nosePoint
	}
}

#end // hose rigidity

// breath bag
#declare breath_bag =
union {
	superellipsoid {<.9, .8>
	rotate z * 45
	scale <1.2, .5, 1.5> * .15
	rotate x * -30 // follow flow of hoses

	translate z * -.5
	translate y * .05
	material {helmetLeather}
	}
}

#local gogSize = .13;


#declare goggle =
union {
	difference {
			superellipsoid {
				<.2, .2>
				scale gogSize
				scale z * .4
			}
	//		box {
	//		-gogSize, gogSize
	//		}
			box {
			-gogSize * .66 , gogSize * .66 scale z* 2.5
			}
		scale x * 5.7/4
		material {goggleRims}
	}
	box {
		-gogSize * .8 , gogSize * .8
		scale x * 5.7/4
		scale z * .08
		translate z * -gogSize * .2
		material {goggleGlass}
	}
	translate z * -.05 // fix my screwup
}


#declare headshape =
difference {
	blob
	{
		threshold 1
		sphere { y * 0, 1  strength 2 scale <.75, 0, .75>  }
		cylinder { y*-.5, y*0, .75 strength 1} 
		sphere {nosePoint + <0, -.5, -.1> , noseSize*2 strength 1.4 scale x * 1.3} // nose buldge
	//	sphere { <.5, -.5, -.5> , .5  strength -.6 scale <.75, 0, .75>  }
		// right goggle
		sphere { 0, 1 strength .6 scale gogSize*1.9 scale x*5.7/4 
					// scooch out a bit
					translate z * -.05
					rotate <18, 29,0> translate <-.17, .5, -.38>
					translate y * -.5
					}
		// left goggle
		sphere { 0, 1 strength .6 scale gogSize*1.9 scale x*5.7/4 
				// scooch out a bit
					translate z * -.05
					rotate <10, -25,0> translate <.17, .5, -.38>
					translate y * -.5
					}	
//		cylinder { // shape top sides (an alien buldge)
//			<0, 0.1, -.1>, <0, 0.1, .1>, .5 strength 5 rotate y *90
//		}
		cylinder { // shape back of skull
			<0, 0.1, -0>, <0, 0.1, .18>, .5 strength 5 
		}
//		cylinder { // shape brow
//			<-.18, 0.3, -.25>, <.18, 0.3, -.25 >, .4 strength 1 
//		}

	
	}
	blob // inside space
	{
		threshold 1
		sphere { y * 0, .9  strength 2 scale <.75, 0, .75>  }
		cylinder { y*-.5, y*0, .74 strength 1} 
	}
	// goggle holes
	// left
	box {gogSize * .9, -gogSize *.9 scale z*2 scale x* 5.7/4
			rotate <10, -25, -6> translate <.17, .5, -.42>
			translate y * -.5 }
	// right
	box {gogSize * .9, -gogSize * .9 scale z*2 scale x* 5.7/4
			rotate <5, 29,8> translate <-.17, .5, -.42> 
		translate y * -.5	
	}
		material {helmetLeather}
		translate y * .5
}

#declare leoHelmet = 
union {
object {hose2}
object {hose1}
object {breath_bag}
object {goggle rotate <5, 29,8> translate <-.17, .5, -.42>}
object {goggle rotate  <10, -25, -6> translate <.17, .5, -.42>}
object {headshape}
}

#if (RenderThisFileAlone)
#include "head.inc" // a guide head

object {head scale 1/.0913 material {Skin}}
object {leoHelmet}


global_settings
{
  assumed_gamma 1.0
	#if (RAD)
	radiosity {}
	ambient_light 0.005
	#end
}

// ----------------------------------------
camera
{
  location  <0.0, .35, -2.5>
//  direction 1.5*z
//  right     4/3*x
  look_at   <0.0, 0.35,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

light_source // fill
{
  0*x // light's position (translated below)
  color rgb .5
  translate <0, 1, -30>
}

light_source // inside helmet
{
  0*x // light's position (translated below)
  color rgb .15
shadowless
fade_distance .3
fade_power 2
  translate <0, .3, -.1>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

//sphere { y*0.5, .5  scale <.75, 0, .75> material {helmetLeather} }
cylinder {<0,-.5,0> <0,0,0> .5 * .75 material {Skin}} // fake neck

#end // render this file alone

