
// are you rendering from another file?
// make a #declare INCLUDAGE in the main file to suppress camera definitions, etc..



#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
#end

// now declare includage for other files (namely, the helmet):

#declare INCLUDAGE  = 3.1459;

#ifndef (BUBBLY)
#declare BUBBLY = yes;
#end

#ifndef (HARD_EDGES)
#local HARD_EDGES = yes;
#end

#ifndef (RAD)
#declare RAD = no;
#end



#include "bubbleblast.inc" // bubble machine
#include "right_stuff_textures.inc"
#include "galea.pov" // the helmet.
#include "puffdaddy.inc" // imported objects

// color mods for radiosity

#if (RAD)
#local coef = 1; // lower for more contrast.
#else
#local coef = 1;
#end
#include "textures.inc"

#declare puffdaddy_cloth =
material {
	texture{
		pigment {
			rgb <0.865, 0.649233, 0.205005> * 1.1
				* <1.3,1,1> // jack up the red to look better under water. 
		}
		normal {
			quilted
			0.08 //amount
			control0 0.83
			control1 0.05
			bump_size .8
						turbulence .4 //.08
scale .01
		}
		finish {
			specular .1 // slicker look
			roughness 1/20
			#if (RAD)
				ambient 0
				diffuse  .4  / coef // .86
			#else			
			ambient rgb .14
			diffuse .3
			#end
//			phong .02
//			phong_size 20
		}
	}
}

#declare puffdaddy_leather =
material {
	texture{
		pigment {
			rgb <0.659998, 0.460349, 0.297002>*.5 //* coef
		}
		normal {
			wrinkles 0.35
			scale <.03, .03, .03>
		}
		finish {
			#if (RAD)
				ambient 0
				diffuse .45 / coef
			#else
			ambient rgb <0.149981, 0.149981, 0.149981>
			#end
			diffuse .45
			phong .09
			phong_size 5
		}
	}
}

#declare puffdaddy_leather_red = 
material {
		texture{
		pigment {
			rgb <0.577493, 0.145251, 0.122499> //* coef
				* <3.5, 1, 1> // jack up red for better underwater look
		}
		normal {
			wrinkles .35
			scale <.03, .03, .03>
		}
		finish {
		#if (RAD)
			ambient 0
			diffuse .4 / coef
		#else
			ambient rgb 0 //<.149981, .149981, .149981>
			diffuse .2
		#end
			irid {
				.3
				thickness 0.02
				turbulence <0.0, 1.0, 0.0>
			}
			phong .09
			phong_size 5
		}
	}
}


#declare ropes = 
union {
	torus {
		0.5, 0.020
		sturm
		scale <1, 1, 1.1>
	material {ropetex}
		translate < -.1, .05, 0>
	}
	torus {
		0.5, 0.020
		sturm
		scale <1, 1, 1>
	material {ropetex}

	translate <-.04, .1, 0>
	rotate z* -5
	}
	torus {
		0.5, 0.020
		sturm
		scale <.9, 1, 1>
	material {ropetex}
	translate <.0, .15, 0>
	rotate z* -4
	}
	difference { // the hanging participle part:
		torus {
			0.5, 0.020
			sturm
		}
		box { <-1, -1, -1> <0,1,1> rotate y*-2}
		scale <1.2, 1, 1.1>
		material {ropetex}
		rotate z * 10
		translate < -.08,0 , 0>
	
	}
	scale .9
	rotate z *50
}
#if (RenderThisFileAlone)


#version 3.5;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
	#if (RAD)
	radiosity {
//      pretrace_start 0.08
//      pretrace_end   0.02
//      count 10
//      nearest_count 1
//      error_bound 0.3
//      recursion_limit 1
//      low_error_factor 0.8
//      gray_threshold 0
//      minimum_reuse 0.015
      brightness coef
//      adc_bailout 0.01/2
	}
	ambient_light 0
	#end
}

// ----------------------------------------
camera
{
  location  <-0.0, 0.6, -5.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.3,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end // render this file alone






#local puffHoses =
union { // hose link
	union
		{	cylinder {y*-.05, y * .05, .02}
			sphere  {0, .03}
			cylinder {y * .05, y * .1, .025}
			cylinder {y * -.05, y * -.1, .025}
			material {shell_material} // from galea.pov
			rotate z * -40
		}


		sphere_sweep {
		cubic_spline,
		6,
		<.8, 2.6, 1.9>, .025 // control
		<.8, 2.8, 2.5>, .025 // up
		<.6, 1.08, 1.5>, .025 	 // coming to diver
		  <.5, .5, 0>, .025// above left shoulder
		 <.08, .08, 0>, .025// into link
		<.08, .08, 0>, .025 // control
		material {Rubber_Mat}
		}
		sphere_sweep {
		cubic_spline,
		5,
		<.3, .3, 0>, .025 // control
		<-.08, -.08, 0>, .025 // out of link
		<-.18, -.06, .8>, .025 // under arm
		<.2, .8, .7>, .025 // back of helmet
		<.8, .6, .4>, .025 // control
		tolerance .1
		material {Rubber_Mat}
		}	
		translate <-.15, .8, -.8>
} // hoses




#if (BUBBLY)


#local Stream = seed(3);

#local theBubs = 	
union {
		// from puffdaddy's head:
	object {BubbleBlast2(.5, 5, .25, 120, .008, Stream) 
		rotate x * 20
		translate <0,1.2, -.4>
	}	
	// right shoulder hose clump
	object {BubbleBlast2(.1, .3, .05, 20, .01, Stream)
		rotate <30, 0, 40>
		translate <-.2,1.5, -.1>
	}

	// bubble trail:
	object {BubbleBlast(.8, 6, 1.60, 160, .008, Stream) 
	rotate <60, 0, 5> // rotate for speed look
	translate <0,1, -0>
	}
	// head fizz (front)
	object {BubbleBlast(.2, 1, .05, 160, .001, Stream) 

		translate <0,.98, -3>
	}	
//	// head fizz (back)
	object {BubbleBlast(.4, 4, .05, 80, .005, Stream) 

		rotate x * -47
		translate <0,1.7, 0>
	}		
			
	// hose link blob.
	object {BubbleBlast2(.2, .5, .1, 20, .008, Stream)
//		rotate <30, 0, 40>
	translate <-.15, .8, -.8>

	}
	// hose link fizz.
	object {BubbleBlast(.3, .5, .05, 40, .004, Stream)
	rotate <0, 0, 40>
	translate <-.15, .9, -.8>

	}	
	material {air_bubble_mat}

}

#end // bubbly





#declare puffdaddy = 
union {
	union {
		mesh {shoe_bottom }
		mesh {shoe_top }
		mesh {shoe_top_left }
		mesh {shoe_bottom_left}
		material {Rubber_Mat}
	}
	mesh {belt texture { T_Silver_5D}}
	mesh {puff_pants material { puffdaddy_leather}}
	mesh {lHand_4 material { puffdaddy_leather_red}}
	mesh {rHand_4 material { puffdaddy_leather_red}}
	mesh {head_4 material {Skin}}
	mesh {shirt material {puffdaddy_cloth}}
	
	object {galeaHelmet scale .4 rotate <0,4,2> translate <-.04, 1.3, -.48>}
	object {ropes translate <0,1, -.4>}
	
	object {puffHoses}
	#if (BUBBLY)
	object {theBubs}
	#end
}

#if (RenderThisFileAlone)
object {puffdaddy}
#end


