// Persistence of Vision Ray Tracer Scene Description File
// render at 16/9 ratio.
//


#version 3.5;

// INCLUDAGE is defined so that all include files know that they are included from here.
// the value isn't used.

#ifndef (INCLUDAGE) // i'm not being included by a rendering file. Render myself.
#declare INCLUDAGE = 299792458 ;
	
	#include "colors.inc"
	#include "textures.inc"
	#include "metals.inc"
	
	#include "skies.inc"
	#include "rad_def.inc"
	#include "bubbleblast.inc"
	
	// should the funky media be used?
	#declare FUNKADELIA = yes;
	#declare FUNKADELIA_QUICKIE = no; // do the quick & nasty with media?
	#declare PAINTERLY = yes;				// a painterly look? (best with anti-aliasing on w low recursion)
	#declare fleckEnhancement = 1  ; // how thick is sea dust?
	
	#declare FOG = no; // use fog if funkadelia is turned off?
	
	
	
	#declare CAUSTICS = yes; // make the water shimmy-shimmies?
	#declare causticBrightness = .4; // how bright?
	#declare REMOVE_SHADOWS = no; // remove shadows from the sea floor? (darker scene)
	
	#declare BUBBLY = yes; // do the bubbles (very slow)?
	#declare BUBBLE_REFLECTION = yes; // reflect on bubbles? (even slower)
	
	#declare RAD=no; // should use radiosity?
	
	#include "right_stuff_textures.inc" // textures depend on radiosity.
	
	#declare FINAL_CAMERA = yes;
	#declare STIR_UP_WATER = yes; // slightly skew camera for underwater effect 	
														// (much slower-- no vista buffers)?
	
	/// which objects to enable?
	//
	#declare Do_Carmagnolle =  yes;
	#declare Do_Klingert = yes;
	#declare Do_Puffdaddy = yes;
	#declare Do_Bellboy = yes;
	#declare Do_DaVinci = yes;
//	
	#declare Do_Landscape = yes;

#end // includage test.




				

//sphere {y*-1, 2 pigment {Red}}

//****************************************

#if (PAINTERLY)
	#declare	FUNKADELIA_QUICKIE = yes;
#end

	#include "medias.pov"


#local theStream = seed (32098);

#if (!CAUSTICS)
#declare REMOVE_SHADOWS = no;
#end


#if (FUNKADELIA)
	#if (CAUSTICS)
		#declare lightMod = 4;
	#else
		#declare lightMod = 4;
	#end
#else
#declare lightMod = <1, 1.5, 2> * .8;
#end

#declare mirrorMatrix  = // for flipping guys on the y
transform {
	matrix <-1, 0, 0
						0, 1, 0,
						0, 0, 1,
						0, 0, 0>
}


global_settings
{
  assumed_gamma 1
#if (RAD)

  radiosity { // (type, use normals, use media )
 //   Rad_Settings(Radiosity_Default, off, off)
//    Rad_Settings(Radiosity_Debug, off, off)
    Rad_Settings(Radiosity_Fast, off, off)
//    Rad_Settings(Radiosity_Normal, off, off)
//    Rad_Settings(Radiosity_2Bounce, on, on)
//    Rad_Settings(Radiosity_Final, off, off)
//
//    Rad_Settings(Radiosity_OutdoorLQ, off, off)
//    Rad_Settings(Radiosity_OutdoorHQ, off, off)
//    Rad_Settings(Radiosity_OutdoorLight, off, off)
//    Rad_Settings(Radiosity_IndoorLQ, off, off)
//    Rad_Settings(Radiosity_IndoorHQ, off, off)
  }
	ambient_light 0
#else
	ambient_light rgb 0 //1 // <1.3, 1.3, 1.4> * .8 // poor man's radiosity.
#end
//	max_trace_level 2
}


#ifdef (FINAL_CAMERA)
#if (FINAL_CAMERA)
camera // Edge 2 Edge camera. Full screen divers (no scenery)
{
  location  <-.5, 1.8, -60>
  right     16/9*x
  look_at   <0.2, .4,  0.0>
angle 5 // telephoto

#if (STIR_UP_WATER)
// a tiny bit of skewage to add to water effect:
	normal {bumps .0006  
		scale .05  
		// try to get the warble off klingert's arm... 
		translate x * .15
		translate y * -.1
	} // lazy warble (funhouse mirror).

//	normal {waves .0008  turbulence 1 rotate x* 90 scale <1, .8, 1> *.5  } // lazy warble.

//	normal {ripples .0004  turbulence 1 rotate x* 90 scale <1, .3, 1> *.3   } // healthy warble.
//	normal {ripples .0004 turbulence .2  scale .02}// fuzzy edges
#end

}

#else
// ----------------------------------------
camera // WORKING CAMERAS
{
  location  <-.5, 1.8, -60>
  right     16/9*x
  look_at   <0.3, .4,  0.0>
angle 5 // telephoto

}

camera // divers + some scenery.
{
  location  <-.5,-.5, -13>
  right     16/9*x
  look_at   <0.3, .5,  0.0>
angle 40 // telephoto
#if (STIR_UP_WATER)
// a tiny bit of skewage to add to water effect:
	normal {ripples .005  turbulence 1 rotate x* 90 scale <1, .8, 1> *.3   } // lazy warble.

//	normal {ripples .006  turbulence 2 rotate x* 90 scale <1, .3, 1> *.3   } // healthy warble.
//	normal {ripples .002 turbulence 2  scale .06}// fuzzy edges
#end
}


// EXPERIMENTAL CAMERAS
//camera // from above (needs a pathway behind )
//{
//  location  <-.5, 2, -20>
//  right     16/9*x
//  look_at   <0.3, .5,  0.0>
//angle 25 // telephoto
//
//}

//camera // long shot.
//{
//ultra_wide_angle
//  location  <0.0, .7, -3.5>
//  right     16/9*x
//  look_at   <0, 1,  0.0>
//angle 120 // that wide landscape look
//}
//camera // In your face shot
//{
//ultra_wide_angle
//
//  location  <0, 2, -3.5> 
//  right     16/9*x
//  look_at   <0, .5,  8.0>
//angle 90 // that 16mm look
//}

#end // final camera 
#end // final camera


#if (FUNKADELIA)

box {<-1300, -2, -160>, <1500, 9, 1500>
		hollow on
	 	material {	texture {pigment {Clear}}}

	interior { // see medias.pov
		media {ChosenMedia2} // scattering
		media {ChosenMedia1} // filtering
	}
}


//fog { // rejected fog
//	fog_type 2	//ground_fog
//	fog_offset -1
//	fog_alt .2 // .4
//	distance 5 // 8
//	rgb <0, 0.429412, 0.992157>  filter 0 transmit 0.2
////	rgb <0.560510, 0.852644, 0.949996> * .8 filter 0.6 transmit 0.1
//
////	rgbft <0.560510, 0.852644, 0.649996, 0.6, 0.7> * .7
////	rgb <0.460510, 0.652644, 0.749996> * .2 filter .2 transmit .5
//	turbulence .08
//	turb_depth .2
//}

//fog { // rejected
//	fog_type 1	// filter the whole scene
//
//	distance 50 // 8
//	rgb <0, 0.329412, 0.992157>  filter .2 transmit  .95
//
//	turbulence 1
////	turb_depth .2
//}

	#if (FOG)
		fog {
			fog_type 1	// filter the whole scene
		
			distance 8 // 8
			rgb <0, 0.329412, 0.992157> * 1.2 filter .1 transmit  .9
		
			turbulence 1
		//	turb_depth .2
		}
	#end

#else // no media effects. Use different type of fog.
	#if (FOG)
	fog {
		fog_type 1	// filter the whole scene
	
		distance 5 // 8
		rgb <0, 0.329412, 0.992157> * 1.5 filter .2 transmit  .85
	
		turbulence 1
	//	turb_depth .2
	}
	#end // fog
#end // funkadelia



sphere { <0,0,0>, 3000 // sky coloring for radiosity
    texture {
	 	pigment
		  {
		    gradient y
		    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
		  }     
	finish {ambient 1 diffuse 0}
    scale 3000
    }
	hollow on
	no_shadow

}


// *******************LIGHTS *****************
light_source { // main spotlight
	  <-30, 100, -15> // <0, 3, -15>
	rgb <.5, .5, 1> * 1.5 * lightMod
	spotlight
 	point_at <0, 1, -.5>
	radius 0
	falloff 13
	tightness 20
	media_interaction off
}

light_source // fill 
{
  0*x // light's position (translated below)
  color rgb <.05, .2, .2> * .8 * lightMod 
  translate <1, .8, -15>
	shadowless
	media_interaction off
}

light_source { // brighten flecks
	<0.1, 0, -3>
	rgb 1 * fleckEnhancement
	fade_distance 1.5
	fade_power 2	//quadratic
	media_attenuation
}


light_source { // highlight puffdaddy
	<-.3, 1.8, -3>
	rgb <1, .9, .9> * lightMod
	fade_distance 2.5
	fade_power 3
	media_interaction off 
}


light_source { // highlight carmagnolle ( on the head)
	<-2.2, 1.8, -1>
	rgb <.8, .8, 1> * 1 * lightMod
	fade_distance 2
	fade_power 3
	media_interaction off 
}

light_source { // highlight klingert ( on the head)
	<-.9, 1.5, -.8>
	rgb <.8, .8, 1> * 1.5 * lightMod
	fade_distance .5
	fade_power 4
	media_interaction off 
}

light_source { // highlight bellboy ( in the eyes, only subtly)
	<1.8, 1, 1>
	rgb <.8, .8, 1> * .5 * lightMod
	fade_distance 2.5
	fade_power 4
	media_interaction off 
}
light_source { // highlight bellboy ( on the feet, only subtly)
	<1.8, 0, 1>
	rgb <.8, .8, 1> * .5 * lightMod
	fade_distance 2.5
	fade_power 4
	media_interaction off 
}
light_source { // highlight bellboy  (from his left)
	<4, .6, -1>
	rgb <0, .5 , 1> * .5 * lightMod
	fade_distance 2
	fade_power 4
	media_interaction off 
}



// media highlighers 
#if (FUNKADELIA)
#if (!PAINTERLY)
	light_source { // backlight
		<-5, 10, 15> 
		rgb <1,1,1> * 20 // blast through media
		spotlight
	 	point_at <0.0, 0, 4> // 0, 0, 4
		radius .1
		falloff 30
		tightness 3
		media_attenuation
		fade_distance 8
		fade_power 4 // tail off before creating a noticable spot on the sea floor.

	}

	light_source { // right in front of camera.
		<-3, 0, -20> 
		rgb <-.3,-.5,1> * .2 // blast through media
		spotlight
	 	point_at <0.0, 1.8, -60>
		radius 60
		falloff 30
		tightness 100
		media_attenuation

	}
#else // painterly look. NEEDS quick & nasty media to be on for the effect.
			// (best with anti-aliasing on)
	light_source { // backlight
		<-5, 10, 15> 
		rgb <1,1,1> * 8 // blast through media
		spotlight
	 	point_at <0.0, 0, 4> // 0, 0, 4
		radius .1
		falloff 30
		tightness 3
		media_attenuation
		fade_distance 8
		fade_power 4 // tail off before creating a noticable spot on the sea floor.

	}
	
	light_source { // right in front of camera.
		<-3, 0, -60> 
		rgb <1,1,3> * 1// blast through media
		spotlight
	 	point_at <0.0, 100, -20>
		radius 60
		falloff 30
		tightness 100
		media_attenuation

	}
#end // painterly


//light_source  // behind puffy
//{
//  0*x // light's position (translated below)
//  color rgb fleckEnhancement //<0.997208, 0.1, 0.828000>
//  translate <0, .4, .15>
//	media_interaction on
//	fade_distance .1
//	media_attenuation on
//}



#end





#if (CAUSTICS)
light_group {
	light_source // to create the warbles on the sea floor.
	{
	 <0, 60,0 >, // light's position (translated below)
	  color rgb <1,1, 1.6> * causticBrightness  //1.5 //<.5, .5, .5>  // light's color
		media_interaction off
//		media_interaction on
//		media_attenuation on
	//	parallel
	//	point_at <0,0,0>  
	}
	
	// The water surface
	box { <-3000, 8.9999,-3000>,
			<3000, 9, 3000>
	    hollow on
	//	pigment {Clear}    
	pigment { red 0.7 green 0.7 blue 1.0 filter 1  transmit .3}
	    finish {
	 brilliance 6
	    diffuse 0.7
	    metallic
	    specular 0.80
	    roughness 1/120
	    reflection 0.8
		 }
	    interior { ior 1.0 caustics 1 }
	    //translate <5, 0, -10>
	    normal { bumps .5 turbulence .1  scale <1, .5,.5>}
	}

#end // caustics
	
	#ifndef (Do_Landscape)
		#declare Do_Landscape = no;
	#end
	
	#if (Do_Landscape)
	height_field
	{
		tga "seafloor.tga"
		smooth // some bug with smoothing makes black spots.
		material {seafloor_tex}
		//	pigment {color rgb <0.65,0.5,0.3>*2}
	//		    finish { ambient 0 diffuse 0.4 }	
		translate <-.5, -.5, -.5>
		scale <100, 50, 100>
		translate y*22.6  //- 13.5
	}
	#else
		plane {
			<0.0, 1, 0.0>, -1
			material {seafloor_tex scale <100, 50, 100>}
		}
	#end // landscape

#if (CAUSTICS)
	#if (REMOVE_SHADOWS)
	}
	#else
	global_lights on
	}
	#end

#end // light group closure

// PUFFDADDY

#ifdef (Do_Puffdaddy) // so I can comment it out.
#if (Do_Puffdaddy)
	#include "puffdaddy.pov"
	object {puffdaddy translate x * .1}
#end // ifdef
#end // if (Do_Puffdaddy)


#ifdef (Do_Bellboy)
#if (Do_Bellboy)
	#include "bellboy.pov"

	object {bellboy translate < 2.2, .3, -.8>}


#end // ifdef do_bellboy
#end // if do_bellboy




#ifdef (Do_Klingert)
#if (Do_Klingert)

	#include "Klingert.pov"
	object {klingert}
#end // ifdef do_klingert
#end // if do_klingert


#ifdef (Do_DaVinci)
#if (Do_DaVinci)

#include "davinci.pov"
	object {davinci translate x* .1}
#end // ifdef do_davinci
#end // if (do_davinci)



#ifdef (Do_Carmagnolle)
#if (Do_Carmagnolle)

#include "Carmagnolle.pov"
object {Carmagnolle 
//	rotate y *-16
	transform {mirrorMatrix}
	rotate y * -15
	translate <-1.8, 0, 1>}
#end // ifdef carmag
#end // if do carmagnolle



#include "copyright.pov"
// the copyright gel:
#if (!PAINTERLY) 
object {
copyrightLight(rgb <1, 1, 1> * .5 * lightMod , 1.1)
rotate z * 6
rotate y * -1.6
	translate < 2.85, -.17, -20>			}



#else // has to be brighter & bigger
// This didn't work out. Too fuzzy at 712 x 400.
//object {
//copyrightLight(rgb <1, 1, 1> * 1 * lightMod , 1.1)
//rotate z * 6
//rotate y * -1.6
//	translate < 2.85, -.17, -20>			}

#end




//// foreground bubbles (man, was it a dumb idea)
//#if (FORE_BUBBLES)
//object {BubbleBlast(.8, 50, 6.50, 120, .005, theStream)
//	rotate <90, 0, 45>
//	translate <-.3, 1.3,  -50>
//	material {air_bubble_mat}
//}
//#end


//sphere {0, .8 pigment {Red} 
//		translate <-.3, 1.3, -50>
//}
//object {dustCone scale y * .5  rotate x * 45 translate y * -1}
