//
//  The actual waterpump object include file.
//

#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "stones.inc"

#declare metalcolor = <0.2,0.2,0.2>;

// the spout.
#declare spout = merge {
	cylinder {
		<0,0,0>
		<0,0.5,0>
		0.15
		pigment { color rgb metalcolor }
		rotate z*-90
		translate <0.1,4.3,0>
	}
	difference {
		torus {
			1
			0.15
			pigment { color rgb metalcolor }
		}
		torus {
			1
			0.12
			pigment { color rgb metalcolor }
		}
		box {
			<-1.15,-1,-1.15>
			<0,1,1.15>
			pigment { color rgb metalcolor }
		}
		box {
			<-1.15,-1,-1.15>
			<1.15,1,0>
			pigment { color rgb metalcolor }
		}
		rotate x*-90
		translate <0.6,3.3,0>
	}
}
// End of spuout object

#declare waterpump =
// The main post
cylinder {
	<0,0,0>
	<0,5,0>
	0.25
	pigment { color rgb metalcolor }
    finish { roughness 0.8 }
}

// The top outter shaft
cylinder {
	<0,4,0>
	<0,5,0>
	0.35
	pigment { color rgb metalcolor }
    finish { roughness 0.8 }
}
	

// The cap and handle bracket
cylinder {
    <0,5,0>
    <0,5.1,0>
    0.4
    pigment { color rgb metalcolor }
    finish { roughness 0.9 }
} 

prism {
    linear_spline
    0,
    0.03,
    4,
    <0,0>,
    <0,0.34>,
    <0.1,0.34>,
    <0.2,0>
    rotate x*-90
    translate <-0.4,5.1,-0.031>
    pigment { color rgb metalcolor }
    finish { roughness 0.8 }
}

prism {
    linear_spline
    0,
    0.03,
    4,
    <0,0>,
    <0,0.34>,
    <0.1,0.34>,
    <0.2,0>
    rotate x*-90
    translate <-0.4,5.1,0.031>
    pigment { color rgb metalcolor }
    finish { roughness 0.9 }
}


// piston
cylinder {
    <0,4,0>
    <0,5.5,0>
    0.025
    pigment { color rgb metalcolor }
}

// handle
prism {
    cubic_spline
    0,
    0.35,
    19,
    < 0, 3>,
    < 0, 0>,
    < 3,0.5>,
    < 5, 1>,
    < 6,1.5>,
    < 7.8,2.2>,
    <8.75,2.6>,  // Highest underside point.
    < 9.7,2.3>,
    <11, 1>,
    <11.5,1.5>,  // Last point to the right.
    <11, 2>,
    < 9,3.5>,   // Top point.
    < 7,2.75>,
    <5.5,2>,
    < 3, 1.3>,
    < 1,0.75>,
    <0.2,0.6>,
    < 0, 0>,
    < 3, 0>
    translate <-6,-0.25,-1.5>
    scale <0.4,0.4,0.4>
    rotate x*-90
    rotate z*50
    translate <-1.2,3.9,0>
    pigment { color rgb metalcolor }
    finish { roughness 0.8 }
}

//icesicle


cone {
    <0,1,0>, 0.12
    <0,0,0>, 0.02
    texture {
        pigment { color rgbf <0.8,0.8,0.8, 0.9> }
        normal { bumps 0.7 scale 0.2 }
        finish { diffuse 0.5 ambient 0.4 reflection 0.1 }

    }
    interior { refraction 1.5 caustics 0.9 }
    translate <1.56,2.35,0>
}

object { spout }
// End of waterpump object


