//BE SURE TO SET +w1024 +h512


// 39h 29m = RAD + 16h = render

#include "colors.inc"
#include "stones.inc" 
#include "functions.inc"
#include "woods.inc"
#declare cm = .01;
#include "units.inc"                                                   


#declare R1 = seed(1334);

#declare PreTrace = 1;  //0 = compute radiosity only  1 = final render

#declare Moon_Pos = <1000,50,-40>; //z -50            

#include "trebuchet.inc"
#include "wall.inc"


// low camera
#declare Camera_Pos = <-50 * Feet,15 * Feet,0 * Feet>;    
                               
#declare Rad_Quality = 2;  
     

#global_settings{assumed_gamma 1  
                 max_trace_level 100
             
                 
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.02
        count 50
        error_bound 0.5
        recursion_limit 1
        brightness 1
        media on
        normal on 
        always_sample off
        save_file "TrebRad1"
     #else 
        load_file "TrebRad1"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008   //A=.01  B=.007
        count 200              //A=200  B=100
        error_bound 0.25       //A=.25  B=.15
        recursion_limit 3      //A=1    B=3
        brightness 1
        media on
        normal on 
        always_sample off
        save_file "TrebRad2"
     #else 
        load_file "TrebRad2"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.005
        count 400   
        error_bound 0.1
        recursion_limit 5  
        media on
        normal on
        always_sample off
        save_file "TrebRad3"
     #else 
        load_file "TrebRad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #end

}

fog {
     fog_type 2
     distance 1500 //2000
     color rgbt<0.3, 0.3, 0.5,.6>
     fog_offset 7
     fog_alt 10 
     turbulence 2 scale 100
    } 

// Low camera
camera { 
   location Camera_Pos
   up       y
   right    x*2
   angle    60
   look_at  <80* Feet,-5 * Feet,-5 * Feet>  //x=80  y = -5  z = -5
}

light_source {  //outside light
   Moon_Pos - <50,0,0>  
   color <.5,.4,.4>   //<.3,.3,.5>       //.3,.3,.5
   media_interaction off
   media_attenuation off
} 

sky_sphere {  // front lit
   pigment {  Black }
}


////////////////////////////////
// Ground Plane
////////////////////////////////
union {
        difference{

                    isosurface {
                                 function { y + (f_noise3d(x*.5,0,z*.5) * 2.0) }
                                 contained_by { box { -500, 500 } }
                                 max_gradient 1.908 
                                 texture {T_Snow}
                                 normal{ bozo 2 scale 10}
                    }
          
                   sphere_sweep {
                                 cubic_spline     // alternative spline curves
                                 7,               // number of specified sphere positions
                                 < -100* Feet, 10 * Feet, 0 * Feet>, 40 * Feet                
                                 <  -50* Feet, 10 * Feet, 0 * Feet>, 40 * Feet                
                                 < 100 * Feet, 10 * Feet, 0 * Feet>, 40 * Feet
                                 < 450 * Feet, 10 * Feet, 0 * Feet>, 40 * Feet                
                                 < 450 * Feet, 10 * Feet, 100 * Feet>, 40 * Feet
                                 < 450 * Feet, 10 * Feet, 200 * Feet>, 40 * Feet
                                 < 450 * Feet, 10 * Feet, 300 * Feet>, 40 * Feet
                  }
                  texture{ pigment { crackle
                                     color_map{
                                               [0.0 color <  0,   0,   0>]
                                               [1.0 color <  1,   1,   1>]
                                              }
                                   } scale 1.0   //1.5
    
                          }
                  finish{ambient .2}
          }

          box { <-100 * Feet,-6 * Feet,-50 * Feet> , <500 * Feet, -5.5 * Feet, 50 * Feet> 
                material {Water }
                normal{ bozo scale 1.3}
          }
} 
 
        //Smoke media box
       box{<500 * Feet,0 * Feet,-800 * Feet>, <-40 * Feet,500 * Feet,50 * Feet>
            texture{pigment{rgbt <1,1,1,1>}}
            hollow on     
            interior {
               media {
                   emission .006/2.5
                   intervals 1
                   samples 10   //8   35,250   128,128
                   method 3
                   density {
                            marble            
                            turbulence .3 omega .7  // 0.3  
                            color_map {
                                       [0.0 color rgb <0, 0, 0>]
                                       [0.9 color rgb <0, 0, 0>]
                                       [0.91 color rgb <1, 1, 1>]
                                       [1.0 color rgb < 1, 1, 1>]
                                      }
                            }
                  scale 10
               } //end media
           } //end interior 
        } 
 

object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) 
       scale <1,.27,.2> 
       translate<50 * Feet, -4 * Feet, 60 * Feet>}

object{MakeRoundWall(typeWall,pEllipsoid,tetaWall,yWall,rWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) 
       scale <.4,.3,.2> 
       translate<50 * Feet, -4 * Feet, 60 * Feet>}

object{MakeRoundWall(typeWall,pEllipsoid,tetaWall,yWall,rWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) 
       scale <.4,.3,.2> 
       translate<390 * Feet, -4 * Feet, 60 * Feet>}  
      
       
#object{Trebuchet1 rotate<0,-90,0> translate<100 * Feet,-3 * Feet,-70 * Feet> }  
#object{Trebuchet1 rotate<0,-90,0> translate<200 * Feet,-3 * Feet,-92 * Feet> }       
#object{Trebuchet2 rotate<0,-90,0> translate<350 * Feet,-3 * Feet,-60 * Feet> } 

//Near Fires
#object{Fire2 rotate<0,0,0> translate< 50 * Feet,-3 * Feet,-67 * Feet> }   //50,-3,-67  52,-3,-63
#object{Fire1 rotate<0,0,0> translate<160 * Feet,-3 * Feet,-55 * Feet> }
#object{Fire1 rotate<0,0,0> translate<300 * Feet,-3 * Feet,-60 * Feet> }     
 
//Distant Fires
#object{Fire1 rotate<0,0,0> scale 1.1 translate<1000 * Feet,-3 * Feet,50 * Feet> }       
#object{Fire1 rotate<0,0,0> scale 1.1 translate<1250 * Feet,-3 * Feet,10 * Feet> }  
#object{Fire1 rotate<0,0,0> scale 1.1 translate<1500 * Feet,-3 * Feet,-30 * Feet> } 
#object{Fire1 rotate<0,0,0> scale 1.1 translate<1000 * Feet,-3 * Feet,-70 * Feet> } 
#object{Fire1 rotate<0,0,0> scale 1.1 translate<1250 * Feet,-3 * Feet,-110 * Feet> }  
#object{Fire1 rotate<0,0,0> scale 1.1 translate<1500 * Feet,-3 * Feet,-150 * Feet> }


Draw_Moon (1)

Draw_Stars(1) 

Draw_Man(1) 

Draw_Rocks(1)

Draw_Arrows(1)

Draw_Grass(1)

Draw_Bushes(1)                  