#declare MechText=material {
	GreasyIron
	}
#declare SupportText=texture {
	SpokeText
}

#declare Support=union {
	cylinder {
		z*-50,
		z*50,
		35
	}
	box {
		20*(x+y)+10*z,
		-20*x-600*y-10*z
		rotate z*20
	}
	box {
		20*(x+y)+10*z,
		-20*x-600*y-10*z
		rotate z*-20
	}
	texture { SupportText}
}

object {
	Support
	translate z*-(WheelWidth+180)
}

object {
	Support
	translate z*(WheelWidth+200)
}

object {
	Support
	translate z*1100
}

object {
	cylinder {
		z*(WheelWidth+1300),
		z*-(WheelWidth+300),
		30
	}
	material {
		MechText
	}
	#if (Anim)
	rotate z*WheelRot*RealClock
	#end
}

#declare ToothFreq=10;

#declare CogRadius=100;
#declare CogWidth=30;
#declare CogCircum=2*pi*CogRadius;
#declare NumHoles=4;
#declare NumTeeth=CogCircum/ToothFreq; 
#declare temp=0;

#declare Cog1 = union {
	difference {
		cylinder {
			z*-CogWidth,
			z*CogWidth,
			CogRadius
		}
		#while (temp<NumHoles)
		sphere {
			0,
			CogRadius/4
			translate x*CogRadius*.63
			rotate z*temp/NumHoles*360
		}
		#declare temp=temp+1;
		#end
	}
	#declare temp=0;
	#while (temp<NumTeeth) 
	box {
		x*CogRadius+z*CogWidth+y*ToothFreq/6,
		x*(CogRadius+7)+z*-CogWidth+y*-(ToothFreq/6)
		rotate z*(temp/NumTeeth*360)
	}
	#declare temp=temp+1;
	#end
}

object {
	Cog1
	translate z*400
	material {CogText}
	#if(Anim)
	rotate z*WheelRot*RealClock
	#end
}

#declare CogRadius=50;
#declare CogWidth=25;
#declare CogCircum=2*pi*CogRadius;
#declare NumTeeth=CogCircum/ToothFreq; 
#declare NumHoles=3;
#declare temp=0;

#declare Cog2 = union {
	difference {
		cylinder {
			z*-CogWidth,
			z*CogWidth,
			CogRadius
		}
		#while (temp<NumHoles)
		sphere {
			0,
			CogRadius/4
			translate x*CogRadius*.63
			rotate z*temp/NumHoles*360
		}
		#declare temp=temp+1;
		#end
	}
	#declare temp=0;
	#while (temp<NumTeeth) 
	box {
		x*CogRadius+z*CogWidth+y*ToothFreq/6,
		x*(CogRadius+7)+z*-CogWidth+y*-(ToothFreq/6)
		rotate z*(temp/NumTeeth*360)
	}
	#declare temp=temp+1;
	#end
}

#declare Support=union {
	cylinder {
		z*-20,
		z*20,
		20
	}
	box {
		20*(x+y)+7*z,
		-20*x-600*y-7*z
		rotate z*20
	}
	box {
		20*(x+y)+7*z,
		-20*x-600*y-7*z
		rotate z*-20
	}
	texture { SupportText}
}

#declare AxisAndCogs= union {
	object {
		Cog2
		translate z*400
		material {CogText}
	}
	cylinder {
		z*300,
		z*800,
		10
		material {MechText}
	}

	object {
		Cog2
		translate z*700
		material {CogText}
	}
#if (Anim)
	rotate -(z*2*WheelRot*RealClock)
#end
	
}

union {
	object{
		AxisAndCogs
	}
	object {
		Support
		translate 450*z
	}
	object {
		Support
		translate 650*z
	}

	translate x*162
}

union {
	object{
	AxisAndCogs
	}
	object {
		Support
		translate 450*z
	}
	object {
		Support
		translate 650*z
	}
	translate x*-162
}
