
// bottom channel

union {
//Side1
	box {
		x*-500+z*-HalfChannelWidth,
		x*500+y*100+z*-(HalfChannelWidth-30)
	}
//Side2
	box {
		x*-500+z*HalfChannelWidth,
		x*500+y*100+z*(HalfChannelWidth-30)
	}
//Bottom
	box {
		x*-500+z*HalfChannelWidth,
		x*500+z*-HalfChannelWidth+y*5
	}
	rotate z*-20
	translate WheelRad*-1.3*y

	material { EntryText}
}

union {//Just Sides
	box {
		z*-HalfChannelWidth-y*170,
		x*1500+y*100+z*-(HalfChannelWidth-30)
	}
	box {
		z*HalfChannelWidth-y*170,
		x*1500+y*100+z*(HalfChannelWidth-30)
	}
	rotate z*-5
	translate WheelRad*-1.3*y

	material { EntryText}
}	

#declare PPSeed=seed(1437);
#declare NumBlobs=10000;
#declare CompRadius=30;
#if (!WFBlobs) #declare CompRadius=CompRadius/BlobSphereRatio; #end
#declare CompStrength=1;

#if (Anim)
#declare PPFileName=concat("PP",str(FrameNum, 0,0),".dat");
#else
#declare PPFileName="PP.dat";
#end

#if (WritePP*PlungePool)
#fopen PPFile PPFileName write
#debug concat("Opened file ",PPFileName ," to write the plunge pool details to\n")
#else
#fopen PPFile PPFileName read
#debug concat("Opened file ",PPFileName ," to read the plunge pool details from\n")
#end

#declare temp=0;

union {//Just Bottom
	#if (PlungePool)
	difference {
		blob {
			threshold 0.85
	#if (!WritePP)			// If Reading from file
	#local DROPPOS=<0,0,1>;
	#local ReadInDrops=0;

	

	#while (defined(PPFile))
	#read (PPFile,DROPPOS)
		sphere {
			DROPPOS,
			CompRadius
			#if (WFBlobs) , CompStrength #end
		}
		#local ReadInDrops=ReadInDrops+1;
		#end
	
	#debug concat("Read in ", str(ReadInDrops,2,0), " droplets of water for the plunge pool\n")
	
	#else 				// i.e, If not reading from file

		#debug concat("temp=", str(temp,0,0),"\n")
		#while (temp<NumBlobs)
			
		#declare FPos=VRand_In_Box(
				x*-1000+z*HalfChannelWidth,
				x*1000+z*-HalfChannelWidth+y*200, PPSeed);

		#write (PPFile, FPos", \n")

		sphere {
			FPos,
			CompRadius
			#if (WFBlobs) , CompStrength #end
		}
	#if (temp/1000=floor(temp/1000))
	#debug concat ("Done ",str(temp,4,0)," out of ",str(NumBlobs,4,0),"\n")
	#end

		#declare temp=temp+1;
		#end	// end while loop
		#end	// reading from file
			material { WaterText }
		}
			plane {
				z, -HalfChannelWidth
			}
		#if(Anim)
		translate x*WaterTrans*RealClock
		#end
	}
	#end
	box {
		z*HalfChannelWidth,
		x*1000+z*-HalfChannelWidth+y*5
	}
	rotate z*-5
	translate (WheelRad*-1.3-170)*y+450*x
	material { EntryText}
}

