#if (ShowWF)

#if (Anim)
#declare FileName=concat("WF",str(FrameNum, 0,0),".dat");
#else
#declare FileName="WF.dat";
#end


#if (WriteWF)
#fopen WFFile FileName write
#debug concat("Opened file ",FileName ," for write\n")
#else
#fopen WFFile FileName read
#debug concat("Opened file ",FileName ," for read\n")
#end


#declare StandDev=1.5;//3.5;
#declare WFNumBlobs=27000;
#declare CompRadius=10;
#if (!WFBlobs) #declare CompRadius=CompRadius/BlobSphereRatio; #end
#declare CompStrength=1;
#declare temp=0;

//#declare XAcc=0;
#declare YAcc=-4.9;	//Always used as half value, so halved
//#declare ZAcc=0;

#if (WFBlobs)
#if (EntryWater)
merge {
	box {
		x*-1000+y*34+z*-58,
		x*20+y*5+z*58
		material { WaterText translate z*100 scale x*10+y+z}
	}
	#else union {
#end
	blob {
		threshold .8
		
#else 
object {
	merge {

#end

#if (!WriteWF)			// If Reading from file
#local DROPPOS=<0,0,1>;
#local ReadInDrops=0;
#while (defined(WFFile))
#read (WFFile,DROPPOS)
	sphere {
		DROPPOS,
		CompRadius
		#if (WFBlobs) , CompStrength #end
	}
	#local ReadInDrops=ReadInDrops+1;
	#end

#debug concat("Read in ", str(ReadInDrops,2,0), " droplets of water for the waterfall\n")

#else 				// i.e, If not reading from file

#declare WFNewSeed=seed(1641);
#declare WFPosSeed=seed(1034);
#declare WFVelSeed=seed(1035);
#declare WFTimeSeed=seed(1046);

#if (Anim)
#declare TimeMax=15+15*pow(AnimWFTimeScale,RealClock);
#else 	//if else
#declare TimeMax=15;
#end

#while (temp<WFNumBlobs) 		

#declare IXPos=RRand(-50,5,WFNewSeed);
#if (IXPos<0) #declare IYPos=RRand(25, 30, WFPosSeed);
#else #declare IYPos=RRand(5, 30, WFPosSeed);
#end
#if (IXPos<0) #declare IZPos=RRand(-45, 45, WFPosSeed);
#else #declare IZPos=RRand(-55, 55, WFPosSeed);
#end
#declare IZPos=RRand(-55, 55, WFPosSeed);
#declare IXVel=Rand_Normal(55, 5*StandDev, WFVelSeed);
#declare IYVel=Rand_Normal(0, StandDev/4, WFVelSeed);
#declare IZVel=Rand_Normal(0, 5*StandDev, WFVelSeed);

#declare PTime=RRand(0,TimeMax,WFTimeSeed);

#declare FXPos=(IXPos+IXVel*PTime);
#declare FYPos=(IYPos+IYVel*PTime+YAcc*PTime*PTime);
#declare FZPos=(IZPos+IZVel*PTime);

#declare FPos=<FXPos, FYPos, FZPos>;

#write (WFFile, FPos", \n")

	sphere {
		FPos,
		CompRadius
		#if (WFBlobs) , CompStrength #end
	}
	
#declare temp=temp+1;
#if (temp/1000=floor(temp/1000))
#debug concat ("Done ",str(temp,4,0)," out of ",str(WFNumBlobs,4,0),"\n")
#end
#end


#end
	}
	rotate z*-5
	translate WheelRad*1.3*y
	material { WaterText }
}

#end // #if (ShowWF)
