#declare QWheelText= texture {
	pigment {
		colour rgb .05
	}
}
#declare QSpokeText=texture {
	pigment {
		colour Red
	}
}


#declare FirstSpoke=cylinder {
	0, (WheelRad-10)*x, 10
}


#declare FirstBucket=box {
	y*-5+z*-z*(WheelWidth/2-2),
	x*100+y*5+z*(WheelWidth/2-2)
	rotate z*20
	translate x*(WheelRad-10)
}

#declare NumberBuckets=30;
#declare temp=0;

#declare Buckets=union{
	#while (temp<NumberBuckets)
	object {
		FirstBucket
		rotate z*(360/NumberBuckets*temp)
	}
	#declare temp=temp+1;
	#end
}

#declare NumberPerSide=12;
#declare temp=0;

#declare Spokes=union{
	#while (temp<NumberPerSide)
	object {
		FirstSpoke
		translate (WheelWidth/2-10)*z
		rotate z*(360/NumberPerSide*temp)
	}
	object {
		FirstSpoke
		translate -(WheelWidth/2-10)*z
		rotate z*(360/NumberPerSide*(temp+.5))
	}
	#declare temp=temp+1;
	#end
}




union {
	difference {
		cylinder {
  			WheelWidth/2*z,  -WheelWidth/2*z,  WheelRad
	  		// open
		}
		cylinder {
			WheelWidth/2*z*1.1, -WheelWidth/2*z*1.1, WheelRad-30
		}
		
		texture {WheelText}
	}

	cylinder {
		WheelWidth/2*z*1.2, -WheelWidth/2*z*1.1, 60
		texture {WheelText}
	}

	object {
		Spokes
		texture {SpokeText}
	}
	
	object {
		Buckets
		texture {WheelText}
	}
		
	#if(Anim)
	rotate z*WheelRot*RealClock	// Animation
	#end
	
}	
