// Persistence of Vision Ray Tracer Scene Description File
// File: wheel.pov
// Vers: 3.5
// Desc: Waterwheel IRTC entry
// Date: started 11/2/2003
// Auth: Henry Bush

#version 3.5;

#declare Media=on;
#declare DeadGoodMedia=on;
#declare Radiosity=off;
#declare AllWater=on;
#declare QuickTexts=off;

#declare Anim=on;
#include "anim.inc"

#if (QuickTexts) #declare GoodWater=off; #else #declare GoodWater=on; #end

#declare Camera=1;
// 1= final					2= high angle from front
// 3= looking at bottom from front		4= looking at bottom from behind
// 5= looking at bottom from side		6= looking at centre from side
// 7= looking at mech				8= equiv to 3, but from other side
// 9= equiv to 1, but from other side		10= looking down on wheel from side
#include "cameras.inc"
#include "colors.inc"

    #if (Radiosity)
#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
  }
}

#else 
#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient .37// 0.25
        diffuse 0.6
        specular 0.3
      }
  }
}

    #end
    
//#declare AmbValue=0.2;
#include "wheeltextures.inc"

global_settings {
//  assumed_gamma 1.0
  max_trace_level 256
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1.5                  // brightness of radiosity effects (0..1) [1]

      adc_bailout .005
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      save_file "wwsavedradiosity"       // save radiosity data
      //load_file "wwsavedradiosity"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
  

}




// ----------------------------------------

#declare WheelRad=400;
#declare WheelWidth=150;
#declare MediaRad=1000;

sphere {
	0
	1
	hollow
  pigment {
    gradient y
    color_map {
      [0.0 rgb .8]
      [0.7 rgb <.4,.5,.8>]
    }
    
  }
    finish {
    	ambient .8
	specular 0
    }
  scale 200000
}

light_source { // The sun
  <0, 0, 0>            
  color rgb 3 
  translate <-150000, 30000, 40000>
  }

#declare WSH=-200;
#declare WEH=400;

/*light_source { // The sun
  <0, 0, 0>            
  color rgb 2 
  translate <-150000, 100000, 40000>
  }*/


/*light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb .3  // light's color
  translate <300, 600, 300>
  }*/

// ----------------------------------------

#declare SprayMaterial= material {
  texture {
    pigment { color rgb 1 filter 1 }
    finish { diffuse 0 specular 0}
  }
  interior {
media {
#if (DeadGoodMedia)
  intervals 25           // number of intervals used for sampling [10]
#else
  intervals 15
#end
  samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  confidence 0.8         // statistic parameter higher->better quality [0.9]
  variance 2.0/128       // statistic parameter lower->better quality [1.0/128]
  ratio 0.9              // distribution between lit and unlit areas [0.9]
  scattering {           // scattering media
#if (DeadGoodMedia)
    2,                   // scattering type 1=isotropic; 2=Mie haze; 3=Mie murky
    rgb .002//.0025          // color was 4, 0.0006
#else 
1,
    rgb .0010//.0025          // color
#end
                        // 4=Rayleigh; 5=Henyey-Greenstein
  }
  method 2
  jitter 1.5           // randomness for method 2&3
  

  density {
    spherical
//    scale 100
  }
/*  density {
    spherical
//    scale 100
  }*/
  
   density {
	  wrinkles          
	  scale .02
  }
scale MediaRad
}


  }
}


#if (Media)
sphere {
	<0,0,0>
	1
	hollow
	scale MediaRad
	material {
		SprayMaterial
	}
//	scale <.8,1,.8>
	translate (WheelRad+250)*x-(WheelRad+100)*y
}
#end

#include "Wheel.inc"
#include "channels.inc"
#include "mech.inc"
#include "floorandwalls.inc"

