/****************************************************************************
 * Project: This Strange Engine 
 * File:    strange.inc
 * Author:  Alcibiade <alcibiade@alcibiade.org>
 * Date:    Feb. 2003
 *
 * Description:
 *   This file contains the declaration of the StrangeEngine object
 *
 ****************************************************************************/

#version unofficial MegaPov 1.000000;

#include "colors.inc"
#include "woods.inc"

#declare T_OldBrassNormal = texture {
	//pigment { color rgb <120/255, 60/255, 44/255> }
	pigment {
		agate
		turbulence 0.85
		color_map {
			[0.000 color rgb <60/255, 30/255, 22/255>]
			[0.002 color rgb <130/255, 60/255, 24/255>]
			[0.998 color rgb <130/255, 60/255, 24/255>]
			[1.000 color rgb <100/255, 45/255, 33/255>]
		}

		scale 6
	}

	finish {
		ambient 0.05
		diffuse 1.10
		brilliance 1.0		// 1
		specular 1.0
		roughness 0.02
		//reflection 0.1
		metallic
	}

	normal {
		crackle 0.2
		scale 1/5
	}
}
texture {
	pigment {
		crackle
		pigment_map {
			[0.00 
				agate

				color_map {
					[0.00 color rgbt <0.00, 0.00, 0.00, 0.50>]
					[0.20 color rgbt <0.00, 0.00, 0.00, 1.00>]
					[1.00 color rgbt <0.00, 0.00, 0.00, 1.00>]
				}

				scale 4
			]
			[0.12 color rgbt <0.00, 0.00, 0.00, 1.00>]
			[1.00 color rgbt <0.00, 0.00, 0.00, 1.00>]
		}

		scale 1/5
	}

	finish {
		ambient 0.0
		diffuse 1.0
	}
}

#declare T_OldBrass = T_OldBrassNormal

#declare T_OldLeather = texture {
	pigment {
		//color rgb <0.40, 0.25, 0.18>
		color rgb <0.40, 0.35, 0.18>
	}

	normal {
		crackle 0.9
		scale 0.07
	}
}

#declare T_OldGlass = texture {
	pigment {
		spherical

		pigment_map {
			[0.00 rgbf <0.3, 0.2, 0.1, 0.15>]
			[0.02 agate
				color_map {
					[0.00 rgbf <0.3, 0.2, 0.1, 0.2>]
					[1.00 rgbf <1.0, 0.9, 0.8, 0.7>]
				}
				scale 1/4
				]

			[0.20 rgbf <1.0, 1.0, 1.0, 0.8>]
			[1.00 rgbf <1.0, 1.0, 1.0, 0.8>]
		}

		scale 3.6
	}

	normal {
		bumps 0.05
		scale 0.17
	}
}

#declare I_OldGlass = interior {
	ior 1.4
}

#declare T_ClockBack1 = texture {
	pigment {
		//color White
		image_map {
			png "cadran1.png"
		}
		scale 2.3
		translate <-1.15, -1.15, 0>
	}
	normal {
		bumps 0.3
		scale 1/15
	}
}

#declare T_ClockBack = T_ClockBack1

#declare T_ClockFront = texture {
	pigment {
		color rgb 0.2
	}
}

#declare T_VumeterBack = texture {
	pigment {
		color rgb 0.
	}
}

#declare T_VumeterFore = texture {
	pigment {
		bumps
		color_map {
			[0.0 rgb <0.1, 0.0, 0.0>]
			[1.0 rgb <1.0, 0.0, 0.0>]
		}
		scale 1/10
	}

	finish {
		ambient 0.8
		diffuse 0.6
	}
}

#declare Valve = union {
	cylinder { 0*z,  0.50*z, 1.9 }
	cylinder { 0*z, -0.65*z, 0.4 }

	intersection {
		box { <-1,-1,0>, <1,1,-0.5> }
		box { <-0.7, -1, 1>, <0.7, 1, -0.6> }
		box { <-0.7, -1, 1>, <0.7, 1, -0.6> rotate 120*z }
		box { <-0.7, -1, 1>, <0.7, 1, -0.6> rotate 240*z }
	}

	box { <-0.6, -1.2, 0>, <0.6, 1.2, 0.5> rotate -20*x translate 3.0*y - 0.25*z }
	box { <-0.6, -1.2, 0>, <0.6, 1.2, 0.5> rotate -20*x translate 3.0*y - 0.25*z rotate 120*z }
	box { <-0.6, -1.2, 0>, <0.6, 1.2, 0.5> rotate -20*x translate 3.0*y - 0.25*z rotate 240*z }

	blob {
		threshold 0.45

		#declare a=0;
		#while ( a < 360 )
			#if ( a/60 = div(a,60) )
				cylinder { -0.7*x, 0.7*x, 1.4, 1 translate 3.8*y rotate z*a }
			#else
				cylinder { -1.0*x, 1.0*x, 1.0, 1 translate 3.5*y rotate z*a }
			#end
			#declare a = a + 30;
		#end
	}
}

#declare Cutpipe = difference {
	cylinder { -7*y, 8*y, 1.80 }
	cylinder { -8*y, 9*y, 1.50 }
	plane    { z, 0  rotate 32*x translate 4.5*y }
}

#declare Clock = union {
	cylinder { 2*z, 0, 0.05 }	// Clock fixation to body
	cylinder {			// Clock background
		-0.1*z, -0.2*z,   0.9
		texture { T_ClockBack }
	}

	difference {			// Clock border
		cylinder {  0,     -z/2, 1 }
		cylinder { -0.1*z, -z,   0.9 }
	}

	union {
		#declare a = 0;
		#while ( a < 360 )
			box { <-0.04, 0, -0.2>, <0.04, 0.17, -0.23> translate 0.6*y rotate a*z }
			#declare a = a + 30;
		#end

		cylinder { -0.2*z, -0.23*z, 0.10 }

		texture { T_ClockFront }
	}
}

#declare Arrow =union {
	cylinder {
		0, 5 * y, 0.6
	}

	sphere {
		0, 1.5
		scale <1, 0.6, 1>
		translate 5 * y
	}

	cone {
		5 * y, 1.5, 8 * y, 0
	}

	scale <1, 1, 0.2>
	scale 1/14

	texture { T_ClockFront }
}

#declare Heart = union {
	sphere { < 0.7, 1, 0> , 1 }
	sphere { <-0.7, 1, 0> , 1 }
	cone {
		y, 1.7,
		-1.5*y, 0
		scale x+y+0.8*z
	}

	texture {
		pigment { color rgb <1,0,0> }
	}

	finish {
		ambient    0.000
		diffuse    1.000
		specular   1.000
		roughness  0.001
		reflection 0.000
	}

	normal {
		agate 0.3
		scale 0.6
		translate 3
		rotate <33, 54, 38>
	}
}

#declare Pump = union {
	difference {
		blob {
			threshold 0.001

			sphere { -2.2*y, 2, 1 scale 0.5*x+y+z }
			sphere { -2.2*y, 2, 1 scale 0.5*x+y+z rotate z*20 }
			sphere { -2.2*y, 2, 1 scale 0.5*x+y+z rotate z*40 }
			sphere { -2.2*y, 2, 1 scale 0.5*x+y+z rotate z*60 }
		}

		cylinder { <-2, -2.2, 0>, <0, -2.2, 0>, 2.1 }
		cylinder { < 0, -2.2, 0>, <2, -2.2, 0>, 2.1 rotate z*60 }
	}

	cylinder { <-0.07, -2.2, 0>, <0.07, -2.2, 0>, 2 rotate z*20 }
	cylinder { <-0.07, -2.2, 0>, <0.07, -2.2, 0>, 2 rotate z*40 }
	cylinder { <-0.00, -2.2, 0>, <0.50, -2.2, 0>, 2 rotate z*60 }

	#declare a = 0;
	#while ( a < 360 )
		sphere {
			0, 0.2
			scale x+y/2+z
			translate 2*y
			rotate a*x
			translate 0.25*x - 2.2*y
			rotate z*60
			texture { T_OldBrass }
		}

		#declare a = a + 30;
	#end

	texture { T_OldLeather }

	translate 2.2*y
}

#declare WoodenBase = difference {
	union {
		// Z-axis bars
		superellipsoid { <0.10, 0.10> scale <0.90, 2.30, 8.50> translate  8 * x }
		superellipsoid { <0.10, 0.10> scale <0.90, 2.30, 8.50> translate -8 * x }

		// X-axis bars
		superellipsoid { <0.10, 0.10> scale <10,   0.20, 0.70> translate <0, 0.80,  6> }
		superellipsoid { <0.10, 0.10> scale <10,   0.20, 0.70> translate <0, 0.80, -6> }
	}

	cylinder { -12 * x, 12 * x, 6  scale <1.00, 1.10, 1.00>  translate 7 * y }
	plane { y, 0 }
	
	texture {
		T_Wood17
	//	pigment { color rgb 1. }
	}
	normal {
		agate 0.6
		scale <1.50, 1.40, 3.00>
		rotate <10,12,15>
	}

	translate -6.9 * y
}

#declare SineLights = union {
	#declare i = 0;
	#while ( i < 14 )

		box {
			<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
			translate 3 * sin(radians(i*360/13)) * y + 1.20 * i * x
		}

		#if ( engine_status & mod(i, 2) = 0 )
		light_source {
			0 color rgb 0.
			glow {
				type 2
				color <0.8,0,0>
				location 0
				size 0.8
				fade_power 3
				translate 3 * sin(radians(i*360/13)) * y + 1.20 * i * x
			}
		}
		#end

		#declare i = i + 1;
	#end
}


#declare StrangeEngine = union {
	// Cutpipes lightsources

	#if ( engine_status = on )
	union {
		light_source { 0 color rgb <1.00, 0.86, 0.86> translate -9.0*x +  8.0*y + 3*z media_interaction false }
		light_source { 0 color rgb <1.00, 0.86, 0.86> translate -5.4*x + 10.0*y + 3*z media_interaction false }
		light_source { 0 color rgb <1.00, 0.86, 0.86> translate -1.8*x + 11.5*y + 3*z media_interaction false }
		light_source { 0 color rgb <1.00, 0.86, 0.86> translate  1.8*x + 11.5*y + 3*z media_interaction false }
		light_source { 0 color rgb <1.00, 0.86, 0.86> translate  5.4*x + 10.0*y + 3*z media_interaction false }
		light_source { 0 color rgb <1.00, 0.86, 0.86> translate  9.0*x +  8.0*y + 3*z media_interaction false }
	}
	#end

	difference {
		union {
			cylinder { -12.5 * x, 12.4 * x, 6.0 }	// Main body
			cylinder {   0.0 * z, -6.5 * z, 4.8 }

			object   { Cutpipe translate -9.0*x +  5.5*y + 3*z }	// Upper Pipes
			object   { Cutpipe translate -5.4*x +  7.5*y + 3*z }
			object   { Cutpipe translate -1.8*x + 10.0*y + 3*z }
			object   { Cutpipe translate  1.8*x + 10.0*y + 3*z }
			object   { Cutpipe translate  5.4*x +  7.5*y + 3*z }
			object   { Cutpipe translate  9.0*x +  5.5*y + 3*z }
		}
		cylinder { 2 * y, 7 * y, 1.5 translate <-9.0, 0, 3> }
		cylinder { 2 * y, 7 * y, 1.5 translate <-5.4, 0, 3> }
		cylinder { 2 * y, 7 * y, 1.5 translate <-1.8, 0, 3> }
		cylinder { 2 * y, 7 * y, 1.5 translate < 9.0, 0, 3> }
		cylinder { 2 * y, 7 * y, 1.5 translate < 5.4, 0, 3> }
		cylinder { 2 * y, 7 * y, 1.5 translate < 1.8, 0, 3> }

		cylinder { -11.0 * x, 11.0 * x, 5.0 }		// Inside body
		cylinder {         0, -6.6 * z, 3.6 }		// Hole
	}

	cylinder {						// Window
			-0.3*z, 0.1*z, 3.6
			texture  { T_OldGlass } 
			interior { I_OldGlass }
			translate -6 * z
	}

	object { Heart scale 1.4 translate -1.5*y }		// Heart

	cylinder { -12.0 * x, -6.5 * x, 6.2 }			// Lateral expansions
	cylinder {  12.0 * x,  6.5 * x, 6.2 }
	cylinder { -11.0 * x, -9.5 * x, 6.4 }			// Side rings
	cylinder {  11.0 * x,  9.5 * x, 6.4 }

	#declare a = 0;						// Hublot nodes
	#while ( a < 360 )
		sphere { 0*x, 0.50 scale x + y + 0.5*z translate 4.2*y - 6.5*z rotate (a+22.5)*z }
		#declare a = a + 45;
	#end

	#declare a = 0;						// Side rings nodes
	#while ( a < 360 )
		sphere { 0*x, 0.60 scale x + 0.5*y + z translate -10.25*x + 6.40*y rotate -a*x }
		sphere { 0*x, 0.60 scale x + 0.5*y + z translate  10.25*x + 6.40*y rotate -a*x }
		sphere { 0*x, 0.60 scale 0.5*x + y + z translate -12.50*x + 5.35*y rotate -a*x }
		sphere { 0*x, 0.60 scale 0.5*x + y + z translate  12.50*x + 5.35*y rotate -a*x }
		#declare a = a + 30;
	#end

	object { Clock           translate <6.5,  2.8, -6.5> }	// Clocks
	object { Clock scale 1.3 translate <6.5,  0.0, -6.5> }
	object { Clock           translate <6.5, -2.8, -6.5> }

	object { Arrow rotate -34 * z           translate <6.5,  2.8, -6.74> }	// Arrows
	object { Arrow rotate  66 * z scale 1.3 translate <6.5,  0.0, -6.80> }
	object { Arrow rotate 159 * z           translate <6.5, -2.8, -6.74> }
	object { Arrow rotate -71 * z scale 0.7 translate <6.5, -2.8, -6.80> }

	difference {						// Top Vumeter
		box { <0.0, 0.0,  0.00>, <4.0, 2.75, -1> }
		box { <0.2, 0.2, -0.25>, <3.8, 2.55, -2> }
		translate 3*x + 8*y
	}
	box { <3.2, 8.2, -0.25>, <6.8, 10.55, -0.3> texture { T_VumeterBack } }

#if ( engine_status = on )
	object { SineLights scale 0.2 translate 3.4*x + 9.3*y - z/2  texture { T_VumeterFore } }
#end

	cylinder { <4.0, 5, -0.30>, <4.0, 8.0, -0.30>, 0.10 }	// VM pipes
	cylinder { <5.6, 5, -0.30>, <5.6, 8.0, -0.30>, 0.15 }
	cylinder { <6.2, 5, -0.30>, <6.2, 8.0, -0.30>, 0.15 }
	difference {
		box { <4.0, 0.4, -0.10>, <4.7, 2.2, -0.40> }
		box { <3.9, 0.5,  0.00>, <4.6, 2.1, -0.50> }
		translate 3*x + 8*y
	}

	cylinder { <-12.5, 3.0, 0>, <-14.0, 3.0, 0>, 2.5 }	// Cheminee
	cylinder { <-12.5, 3.0, 0>, <-14.3, 3.0, 0>, 2.3 }
	cylinder { <-12.5, 3.0, 0>, <-16.3, 3.0, 0>, 1.7 }
	box      { <-12.5, 3.55, -1.80>, <-15.0, 2.45, 1.80> }
	cylinder { <-15.0, 3.00, -1.80>, <-15.0, 3.00, 1.80>, 0.55 }
	box      { <-12.5, 1.00, -0.55>, <-15.0, 3.00, 0.55> }
	cylinder { <-15.0, 1.00,  0.00>, <-15.0, 3.00, 0.00>, 0.55 }
	cylinder { <-12.5, 3.0, 0>, <-16.9, 3.0, 0>, 1.4 }
	cylinder { <-12.5, 3.0, 0>, <-19.5, 3.0, 0>, 0.9 }
	box      { <-19.0, 3.0, -0.1>, <-16, 4.4, 0.1> }
	cylinder { <-18.5, 3.0, -1.2>, <-18.5, 3.0, 1.2>, 0.4 } // Cheminee: Axe
	box      { <-19.5, 3.0, -0.2>, <-18.5, 4.9, 0.2> }
	cylinder { <-18.5, 3.0, 0.0>, <-18.5,  6.0, 0.0>, 0.9 }
	difference { 
		cylinder { <-18.5, 4.9, 0.0>, <-18.5, 16.0, 0.0>, 1.05 }
		torus { 1.05, 0.05 translate <-18.5, 6.5, 0> }
		torus { 1.05, 0.05 translate <-18.5, 7.0, 0> }
		torus { 1.05, 0.05 translate <-18.5, 7.5, 0> }
	}
	cylinder { <-18.5, 16.0, 0.0>, <-18.5, 16.3, 0.0>, 2.00 }
	box { <-0.5, 0, -0.10>, <0, -6, 0.10> rotate 4*z              translate <-19.50, 16.20,  0.00> }
	box { <-0.5, 0, -0.10>, <0, -6, 0.10> rotate 4*z rotate  90*y translate <-18.50, 16.20,  1.00> }
	box { <-0.5, 0, -0.10>, <0, -6, 0.10> rotate 4*z rotate 180*y translate <-17.50, 16.20,  0.00> }
	box { <-0.5, 0, -0.10>, <0, -6, 0.10> rotate 4*z rotate 270*y translate <-18.50, 16.20, -1.00> }

	#declare a = 0;
	#while ( a < 360 )
		cylinder { -1.5*x, 0*x, 0.2  translate 2.5*y rotate -a*x translate <-12.5, 3.0, 0> }
		#declare a = a + 30;
	#end

	box      { <-15, -3.8, -4.0>, <-12.5, -1.2, -3> }	// Valve
	cylinder { <-15, -2.5, -5.8>, <-15.0, -2.5, -3>, 1.3 }
	object   { Valve scale 0.55 rotate 50*z translate <-15, -2.5, -6> }

	object { Pump scale 2.6 translate 12.5*x }		// Pump
	object {
		cylinder { 12.4*x, 12.5*x, 6 }
		texture { T_OldLeather }
	}

	object { WoodenBase }

#if ( engine_status = on )
	light_source {
		5*x + y, color rgb <1,0.8,0>
//		area_light z, y, 2, 2
		media_interaction true
		media_attenuation true
	}

	light_source {
		4*z, color rgb <1,0.8,0.4>
		media_interaction true
		media_attenuation true
		glow {
			type 1
			size 3
			color rgb <1,0.8,0.4>
			fade_power 4
		//	translate 1 * z
		}
	}

	light_source {
		-4*x - 1*y, color rgb <1,0.3,0>
		media_interaction true
		media_attenuation true
	}
#end


	texture { T_OldBrass }
}
