/****************************************************************************
 * Project: This Strange Engine 
 * File:    strange.pov
 * Author:  Alcibiade <alcibiade@alcibiade.org>
 * Date:    Feb. 2003
 *
 * Description:
 *   Main scene description... This is the one to render if you want the
 *   full image. Use the #declares below to tune the scene for faster rendering
 *   if needed.

 * Warning: This scene requires at least megapov 1.0 and Rune's Particle
 *          System includable in "particle/..."
 *
 ****************************************************************************/


// This should be true...

#declare has_wall      = true;
#declare has_ground    = true;
#declare has_engine    = true;
#declare has_fire      = true;
#declare has_smoke     = true;
#declare has_mainlamp  = true;
#declare has_crate     = true;
#declare has_cloth     = true;
#declare full_lights   = true;
#declare engine_status = on;
#declare cloth_rebuild = true;

// This should be false...

#declare has_backlamp  = false;
#declare has_devlamp   = false;

// -----------------------------

#include "strange.inc"
#include "brickwall.inc"
#include "crate.inc"
#include "cloth.inc"
#include "particle/particle.inc"


camera {
	right 2.10 * x
	up    1.20 * y
	location <0, 12, -60>
	look_at  <0, 11,   0>
	angle 45
//--- Temp
//	location <0, 25, -60>
//	translate <-19, 0, 0>
//
	rotate -clock*y
}

background { color rgb <0.40, 0.40, 0.50> }

global_settings {
	max_trace_level 120.00
}

#if ( has_backlamp )
light_source {
	<-5, 9, 16> color 1.
}
#end


#if ( has_devlamp )
light_source {
	<20, 20, -50> color rgb 1.0
	media_interaction false
	media_attenuation false
}
#end


#if ( has_mainlamp )
light_source {
	< -3, 5, -16.00>, color rgb <0.9, 0.7, 0.5>
#if ( full_lights )
	area_light 6 * x, 6 * y, 7, 7
#end
	fade_distance 18
	fade_power 1
	media_interaction true
	media_attenuation true
}
#end


#if ( has_ground )
union {
	height_field {  // ground
		png "ground.png"
		translate < 0.0, 0, -0.5>
	}

	height_field {  // ground
		png "ground.png"
		translate <-1.0, 0, -0.5>
	}

	scale <50, 0.1, 50>

	texture {
		pigment {
			gradient y

			color_map {
				[0.00 color rgb 0.2]
				[1.00 color rgb 1.0]
			}

			scale 0.11
		}

		finish {
			ambient 0.00
			diffuse 0.70
			specular 0.5
			roughness 0.01
			reflection 0.30
		}

		normal {
			hexagon 0.80
			scale 1.10
			translate 0.5 * y
		}
		normal {
			crackle 0.3
			scale 0.2
		}
	}
	texture {
		pigment {
			agate

			color_map {
				[0.00 color rgbt 1.00]
				[0.99 color rgbt 1.00]
				[1.00 color rgbt 0.20]
			}

			scale 2
		}
	}
}
#end

#if ( has_crate )
#local RightCrates = union {
	object { Crate() rotate 7 * y scale <0.50, 0.40, 0.90> translate <23, 0.2, -5> }
	object { Crate() rotate 9 * y scale <0.45, 0.45, 0.85> translate <27, 4.2, -5> }
}

#local RightSimpleCrates = union {
	object { SimpleCrate() rotate 7 * y scale <0.50, 0.40, 0.90> translate <23, 0.2, -5> }
	object { SimpleCrate() rotate 9 * y scale <0.45, 0.45, 0.85> translate <27, 4.2, -5> }
}

#local LeftCrates = union {
	object { Crate() rotate -5 * y scale 0.6 translate <-29, 6.0, -3> }
	object { Crate() rotate -3 * y scale 0.7 translate <-25, 0.1, -5> }
}

#local LeftSimpleCrates = union {
	object { SimpleCrate() rotate -5 * y scale 0.6 translate <-29, 6.0, -3> }
	object { SimpleCrate() rotate -3 * y scale 0.7 translate <-25, 0.1, -5> }
	plane { y, 0 }
}


object { LeftCrates }
object { RightCrates }

#if ( has_cloth )
Cloth_01(LeftSimpleCrates, <-29, 13, -2>, <17, 0, 12> )
#end

#end

#if ( has_wall )
object {
	BrickWall(20, 10)
	translate -10 * x
	scale 3.00
	translate 10.5 * z
}
#end

#if ( has_engine )
object {
	StrangeEngine
	translate <-1, 7, 0>
}
#end

// -------------------------------------------------------------- Fire

#if ( has_fire )
   
// Clock settings
// **************
   
   #declare particle_start  = 0.0;
   #declare particle_end    = 2.0;
   #declare particle_cyclic = on;
   #declare particle_steps  = 100;
   
// General particle settings
// *************************
   
   #declare particle_frequency = 40;
   #declare particle_life      = 0.7;
   #declare particle_lifeturb  = 0.3;
   #declare particle_seed      = 123;
   //#declare particle_maxnumber = 100;
   
// Environment settings
// ********************
   
   #declare particle_drag      = 0.0;
   #declare particle_transfer  = 0.0;
   
   #macro particle_gravity  (Clock,Point) 40*y #end
   #macro particle_wind     (Clock,Point) <0,0,0> #end
   
// Emitter settings
// ****************
   
   #macro particle_emitter  (Clock) <-1, 3,0> #end
   #macro particle_emitting (Clock) on      #end
   #macro particle_emitvect (Clock) <0,0,0> #end
   #macro particle_emitturb (Clock) 1.5     #end
// #macro particle_emitobj  (Clock) sphere {0, 2.0 scale <1,0.1,1> translate 0.5*y} #end
   #macro particle_emitobj  (Clock) cylinder {-3 * x, 3* x, 1.0 scale <1,0.1,1> translate 0.5*y} #end
   #macro particle_emitobjn (Clock) 0.0     #end
   
// Collision settings
// ******************
   
// (Collision settings not used)
   
// Call particle system
// ********************
   
   particle_system ("fire")
   
// Load system
// ***********
   
   #include "particle/fire.inc"
   
   #declare fire_method     = 1;
   #declare fire_color      = <0.85,0.45,0.15>;
   #declare fire_intensity  = 2.0;
   #declare fire_highlight  = 2.0;
   #declare fire_samples    = 5;
   #declare fire_turbulence = 1.0;
   #declare fire_size       = 1.2;
   #declare fire_stretch    = 0.1;
   
   fire_create("fire")
#end

// -------------------------------------------------------------- Smoke

#if ( has_smoke )
   
// Clock settings
// **************
   
   #declare particle_start  = 0.0;
   #declare particle_end    = 1.0;
   #declare particle_cyclic = on;
   #declare particle_steps  = 100;
   
// General particle settings
// *************************
   
   #declare particle_frequency = 150;
   #declare particle_life      = 1.0;
   #declare particle_lifeturb  = 0.3;
   #declare particle_seed      = 123;
   //#declare particle_maxnumber = 100;
   
// Environment settings
// ********************
   
   #declare particle_drag      = 1.0;
   #declare particle_transfer  = 1.0;
   
   #macro particle_gravity  (Clock,Point) <0,50,0> #end
   #macro particle_wind     (Clock,Point) <0, 0,0> #end
   
// Emitter settings
// ****************
   
   #macro particle_emitter  (Clock) 0 #end
   #macro particle_emitting (Clock) on      #end
   #macro particle_emitvect (Clock) 0 #end
   #macro particle_emitturb (Clock) 1.0     #end
   #macro particle_emitobj  (Clock) union {
	sphere { 0, 2 scale <0.7, 0.5, 1> translate < -9.5, 17, 3> }
	sphere { 0, 2 scale <0.7, 0.5, 1> translate < -6.5, 19, 3> }
	sphere { 0, 2 scale <0.7, 0.5, 1> translate < -3.0, 21, 3> }

	sphere { 0, 2 scale <0.7, 0.5, 1> translate <  1.0, 21, 3> }
	sphere { 0, 2 scale <0.4, 0.5, 1> translate <  4.5, 19, 3> }
	sphere { 0, 2 scale <0.7, 0.5, 1> translate <  7.5, 17, 3> }

	sphere { 0, 2 scale <1.5, 0.5, 1> translate <-19.5, 23, 0> }
	} #end

   #macro particle_emitobjn (Clock) 0.0     #end
   
// Collision settings
// ******************
   
// (Collision settings not used)
   
// Particle element macro (optional)
// *********************************
   
   #include "particle/smoke.inc"
   
// These settings are constant in this example, so they can
// be #declared outside of the particle_element macro.
   #declare smoke_emission   = 1.0;
   #declare smoke_absorption = 1.0;
   #declare smoke_scattering = 0;
   #declare smoke_startsize  = 1.2;
   #declare smoke_endsize    = 1.9;
   #declare smoke_samples    = 1;
   #declare smoke_intervals  = 3;
   
   #macro particle_element ()
//    Do things with the particle data here. Available data:
//    p_id,        p_random,    p_location,  p_direction, p_life,
//    p_age,       p_birth,     p_state,     p_rotate
      
//    This setting is dependent on the particle_element data,
//    so it is #declared inside of the particle_element macro.
      #declare smoke_color = color rgb <0.41, 0.35, 0.34>;
      
      smoke_element()
   #end
   
// Call particle system
// ********************
   
   particle_system ("smoke")

#end
