// 16court.Pov                 "Palazzo Borghese ( Rome )     p 252 "Architectural Drawings" (Pepin Press }       10April 2003

#include "colors.inc" 

global_settings { max_trace_level 10 }

background { color rgb < 0.6, 0.6, 0.8 > }

camera {
         location < 2, 10, -95 >
         look_at  < 0, 12, 0 > 
         angle 30
       }
       
light_source { < 200, 800, -400 > color White }    
light_source { < 40, 2, -100 > color rgb < 0.2, 0.1, 0.05 > shadowless }           
light_source { < -60, 70, 200 > color rgb < 0.4, 0.4, 0.5 > shadowless }     
light_source { < -10, 8, 5 > color rgb < 0.15, 0.12, 0.1 > shadowless } 

// **************************************************************************  
// TEXTURES **********************

#declare Colls =
            texture {
              pigment {
                       marble
                       color_map {
                                  [ 0 color White ]                                      
                                  [ 0.2 color NewTan ] 
                                  [ 0.4 color rgb < 0.9, 0.65, 0.6 > ]
                                  [ 0.42 color Gray50 ]    
                                  [ 0.58 color Gray50 ] 
                                  [ 0.6 color rgb < 0.9, 0.65, 0.6 >  ]  
                                  [ 0.76 color rgb < 0.9, 0.65, 0.6 >  ] 
                                  [ 0.8 color White ] 
                                  [ 1 color Tan ] 
                                  }
                             scale 7 
                       turbulence 1  octaves 9 omega 0.6 lambda 4    
                     }
             finish { ambient 0.23 }
             scale 0.5
                   } 
            texture {
              pigment {
                       marble
                       color_map {
                                  [ 0 color Clear ]  
                                  [ 0.475 color Clear ]
                                  [ 0.485 color Gray50 ]    
                                  [ 0.515 color Gray50 ] 
                                  [ 0.518 color Clear  ] 
                                  [ 1 color Clear ] 
                                  }
                             scale 2.5 
                       turbulence 1   octaves 5
                     }
             finish { ambient 0.23 reflection 0.1 phong 1 } 
             scale 0.25
                   }                        

#declare Arom =
               texture {
                          pigment {
                                    granite 
                                    color_map {
                                               [ 0, 0.2 color rgb < 1, 0.9, 0.85 > 
                                                        color rgb < 1, 0.98, 0.87 > ]
                                               [ 0.2, 0.4 color rgb < 0.96, 0.98, 0.87 > 
                                                          color rgb < 0.86, 0.86, 0.86 > ]
                                               [ 0.4, 0.6 color rgb < 0.86, 0.8, 0.86 > 
                                                          color rgb < 1, 0.9, 0.66 > ]
                                               [ 0.6, 0.8 color rgb < 0.93, 0.96, 0.9 >
                                                          color rgb < 0.93, 0.9, 0.86 > ]
                                               [ 0.8, 1.0 color rgb < 0.89, 0.88, 0.8 > 
                                                          color rgb < 0.8, 0.9, 0.98 > ]
                                              }
                                          turbulence 0.7
                                   }
                           finish { ambient 0.23 phong 1 }
                         }
 texture {
              pigment {
                       marble
                       color_map {
                                  [ 0 color Clear ]  
                                  [ 0.475 color Clear ]
                                  [ 0.485 color Gray50 ]    
                                  [ 0.515 color Gray50 ] 
                                  [ 0.518 color Clear  ] 
                                  [ 1 color Clear ] 
                                  }
                             scale 2.5 
                       turbulence 1   octaves 5
                     }
             finish { ambient 0.23 reflection 0.1  } 
             scale 0.75
                   }                                                  
#declare Brom =
               texture {
                          pigment {
                                    granite 
                                    color_map {
                                               [ 0, 0.2 color rgb < 1, 0.9, 0.85 > 
                                                        color rgb < 1, 0.98, 0.87 > ]
                                               [ 0.2, 0.4 color rgb < 0.96, 0.98, 0.87 > 
                                                          color rgb < 0.86, 0.86, 0.86 > ]
                                               [ 0.4, 0.6 color rgb < 0.86, 0.8, 0.86 > 
                                                          color rgb < 1, 0.9, 0.66 > ]
                                               [ 0.6, 0.8 color rgb < 0.93, 0.96, 0.9 >
                                                          color rgb < 0.93, 0.9, 0.86 > ]
                                               [ 0.8, 1.0 color rgb < 0.89, 0.88, 0.8 > 
                                                          color rgb < 0.8, 0.9, 0.98 > ]
                                              }
                                          turbulence 0.7
                                   }
                           finish { ambient 0.23 reflection 0.2 phong 1 }
                         }

#declare Folls =
            texture {
              pigment {
                       marble
                       color_map {
                                  [ 0 color White ]                                      
                                  [ 0.2 color NewTan ] 
                                  [ 0.4 color rgb < 0.9, 0.65, 0.6 > ]
                                  [ 0.42 color Gray50 ]    
                                  [ 0.58 color Gray50 ] 
                                  [ 0.6 color rgb < 0.9, 0.65, 0.6 >  ]  
                                  [ 0.76 color rgb < 0.9, 0.65, 0.6 >  ] 
                                  [ 0.8 color White ] 
                                  [ 1 color Tan ] 
                                  }
                             scale 7 
                       turbulence 1  octaves 9 omega 0.6 lambda 4    
                     }
             finish { ambient 0.23 reflection 0.2 }
             scale 0.5
                   }
                   
// COLUMNS ***********************************************                   
                    
#declare Rails =                                                              // coving for top of Capital
                 union {
                         cylinder { < -1.25, 0, -1.5 >,< -1.25, 0, 1.5 >,0.15 } 
                         cylinder { < 1.25, 0, -1.5 >,< 1.25, 0, 1.5 >,0.15 }
                         cylinder { < -1.5, 0, -1.25 >,< 1.5, 0, -1.25 >,0.15 }
                         cylinder { < -1.5, 0, 1.25 >,< 1.5, 0, 1.25 >,0.15 } 
                                         texture { Arom }
                       } 
#declare Top =                                                                // top of Capital
                difference {
                                      box { < -1.25, 0, -1.25 >,< 1.25, 0.2, 1.25 > }
                                      object { Rails }                                                     
                                                   texture { Arom }
                                    } 
#declare Head =                                                              // head block over columns
               difference {
                            union {
                                    object { Top scale < 3.1, 3, 1.75 > translate y*23.35 }
                                    box { < -3.25, 22.9, -1.75 >,< 3.25, 23.55, 1.75 > } 
                                     box { < -3.18, 22.67, -1.66 >,< 3.18, 22.9, 1.66 > }
                                     box { < -3.11, 22.43, -1.57 >,< 3.11, 22.67, 1.57 > }
                                     box { < -3.04, 22.19, -1.48 >,< 3.04, 23.43, 1.48 > }
                                     box { < -2.97, 21.95, -1.39 >,< 2.97, 22.19, 1.39 > }
                                    box { < -2.9, 21.15, -1.3 >,< 2.9, 21.95, 1.3 > }
                                    object { Top scale < 2.6, 1.5, 1.2 > translate y*20.85 }
                                    box { < -2.8, 20.45, -1.2 >,< 2.8, 20.85, 1.2 > }
                                   }
                            box { < -4, 20, -4 >,< 0, 24, 4 > }
                                       texture { Colls }
                           }                                                                      
                                                             
#declare Capital =                                                              // column capital
                 union { 
                         
                         object { Top translate y*20.25 }
                         torus { 1, 0.24 scale < 1, 0.75, 1 > translate y*18.9 }    
                         torus { 1, 0.24 scale < 1, 0.5, 1 > translate y*19.95 }   
                         torus { 1, 0.24 scale < 1, 0.75, 1 > translate y*19.65 }
                         box { < -1.1, 20.25, -1.3 >,< 1.1, 20.1, 1.3 > } 
                         difference { 
                                      union { 
                                              cylinder { < -1.1, 19.85, -1.3 >,< -1.1, 19.85, 1.3 >,0.4 }   
                                              cylinder { < 1.1, 19.85, -1.3 >,< 1.1, 19.85, 1.3 >,0.4 }
                                            }
                                      union {        
                                               cylinder { < -0.9, 19.85, -1.4 >,< -0.9, 19.85, 1.4 >,0.29 }  
                                               cylinder { < 0.9, 19.85, -1.4 >,< 0.9, 19.85, 1.4 >,0.29 } 
                                            }
                                     }
                          cylinder { < -0.9, 19.7, -1.3 >,< -0.9, 19.7, 1.3 >,0.29 }    
                          cylinder { < 0.9, 19.7, -1.3 >,< 0.9, 19.7, 1.3 >,0.29 }          
                                   texture { Arom }
                        }
#declare Base =                                                                  // square post under column
                union {
                        superellipsoid { < 0.1, 0.1 > scale < 1.35, 2.6, 1.35 > translate y*2.6 } 
                        superellipsoid { < 0.1, 0.1 > scale < 1.6, 0.75, 1.6 > translate y*0.75 }
                        superellipsoid { < 0.1, 0.1 > scale < 1.6, 0.375, 1.6 > translate y*4.825 }
                                                 texture { Colls }
                       }                                                                                             
#declare Outer =                                                                 // to close outer gap between Bases
                object { Base scale < 1.9, 1, 0.1 > translate z*1.45 } 
                                       
#declare Column =                                                                // column floor to roof
                 union {  
                          object { Capital }
                          object { Base }                              
                          cylinder { < 0, 5.2, 0 >,< 0, 20.45, 0 >,1 }
                          box { < -1.5, 5.2, -1.5 >,< 1.5, 5.5, 1.5 > }
                          torus { 1.2, 0.3 scale  < 1, 0.6, 1 > translate y*5.74 }
                          difference {
                                       cylinder { < 0, 5.86, 0 >,< 0, 6.16, 0 >,1.2 }
                                       torus { 1.25, 0.225 translate y*6.16 }
                                     }  
                          torus { 1, 0.24 scale < 1, 0.75, 1 > translate y*6.34 } 
                                     texture { Arom }
                       } 
                       
// BALUSTRADES ****************************************                       
                       
#declare Baluster =                                                             // single baluster
                   union {
                           box { < -0.4, 0, -0.4 >,< 0.4, 0.5, 0.4 > }
                           sphere { < 0, 0, 0 >,0.4  scale < 1, 0.75, 1 > translate y*0.5 }
                           sphere { < 0, 0, 0 >,0.4 scale < 1, 0.5, 1 > translate y*1 }
                           lathe {
                                  cubic_spline
                                  12
                                  < -0.15, 0 >,
                                  < 0, 0 >,
                                  < 0.15, 0 >,
                                  < 0.3, 0.2 >,
                                  < 0.35, 0.4 >,
                                  < 0.2, 0.75 >,
                                  < 0.15, 1.1 >,
                                  < 0.25, 1.35 >,
                                  < 0.4, 1.6 >,
                                  < 0.2, 1.8 >,
                                  < 0, 2 >,
                                  < -0.2, 2.2 >
                                  translate y*1.2
                                  }
                                    translate y*1.5
                                    texture { Arom }
                          }
#declare Balustrade =                                                                 // balustrade panel
                     union { 
                            superellipsoid { < 0.1, 0.1 > scale < 6.5, 0.375, 1 >  // toprail
                                                    translate y*4.825 
                                                    texture { Colls }
                                           }                                  
                            object { Baluster } 
                            object { Baluster translate x*1.05 }   
                            object { Baluster translate x*2.1 }  
                            object { Baluster translate x*3.15 }  
                            object { Baluster translate x*4.2 }          
                            object { Baluster translate x*5.25 }   
                            object { Baluster translate x*6.3 }     
                            object { Baluster translate x*-1.05 }   
                            object { Baluster translate x*-2.1 }  
                            object { Baluster translate x*-3.15 }  
                            object { Baluster translate x*-4.2 }          
                            object { Baluster translate x*-5.25 }   
                            object { Baluster translate x*-6.3 } 
                            superellipsoid { < 0.1, 0.1 > scale < 6.5, 0.75, 1 >   // bottom rail
                                                    translate y*0.75
                                                    texture { Colls }
                                           }                                                                             
                           } 
#declare Topbal =                                                                  // balustrade panel for roof        
                  union {                                                          
                           object { Base scale < 1.9, 1, 1 > translate x*-8.9 } 
                           object { Balustrade } 
                                       translate y*31
                        } 
#declare Roofbal =                                                                  // roof balustrade
                 union { 
                        object { Topbal }
                        object { Topbal translate x*17.8 }    
                        object { Topbal translate x*35.6 }   
                        object { Topbal translate x*-17.8 }    
                        object { Topbal translate x*-35.6 } 
                        object { Base scale < 1.9, 1, 1 > translate < 44.5, 31, 0 > } 
                       }
#declare Rib =                                                                       // section of cornice
                union {
                        box { < -8.9, -0.3, -1.3 >,< 8.9, 0, 0 > }
                        cylinder { < -8.9, -0.15, -1.3 >,< 8.9, -0.15, -1.3 >,0.15 }
                        box { < -8.9, -0.3, -0.9 >,< 8.9, -0.6, -0.9 > }
                        cylinder { < -8.9, -0.45, -0.9 >,< 8.9, -0.45, -0.9 >,0.15 }
                                       texture { Arom }
                       }                                         
#declare Cornice =                                                                    // cornice
                  union {
                         box { < -8.9, -1.1, 0 >,< 8.9, 0, -1 > } 
                         object { Rib translate z*-0.7 }
                         object { Rib translate y*-1.1 }
                                    texture { Arom }
                        }            
                                                
#declare Face =                                                                     // outside facing above columns
               union {
                      torus { 6.15, 0.15 rotate x*90 }
                      torus { 7, 0.15 rotate x*90 }
                      torus { 7.85, 0.15 rotate x*90 }
                      difference {
                                  cylinder { < 0, 0, -0.05 >,< 0, 0, 0.05 >,7.9 }
                                  cylinder { < 0, 0, -0.1 >,< 0, 0, 0.1 >,6 }
                                 }
                      cylinder { < -8.9, 7.85, 0 >,< 8.9, 7.85, 0 >,0.15 }            
                      torus { 1, 0.2 rotate z*90 scale < 1, 1, 0.2 > translate < 0.2, 7.2, 0 > }   
                      torus { 1, 0.2 rotate z*90 scale < 1, 1, 0.2 > translate < 0.6, 7.2, 0 > }  
                      torus { 1, 0.2 rotate z*90 scale < 1, 1, 0.2 > translate < -0.2, 7.2, 0 > }  
                      torus { 1, 0.2 rotate z*90 scale < 1, 1, 0.2 > translate < -0.6, 7.2, 0 > } 
                                      clipped_by {
                                                  box { < -8.9, 0, -1 >,< 8.9, 11, 1 > }
                                                 } 
                                      texture { Arom } 
                     }                 
                                                                                                                    
#declare Roof =                                                                      // ceiling/roof, above columns
              union {
                     object { Cornice rotate y*180 translate < 0, 35, 0.3 > }                                             
                     object { Face translate < 0, 23.95, 0.92 > }
                     difference { 
                                  union {
                                         box { < -8.9, 23.95, 0.9 >,< 8.9, 32.8, 0.95 > pigment { color NewTan } }     
                                         box { < -8.9, 23.95, -31 >,< 8.9, 34, 0.9 > } 
                                        }
                                  union {
                                          cylinder { < -9, 0, -15 >,< 9, 0, -15 >,14
                                                          scale < 1, 0.45, 1 >
                                                          translate y*23.95 
                                                    }
                                          cylinder { < 0, 23.95, -42 >,< 0, 23.95, 2 >,6 }
                                         }
                                                      
                                } 
                     difference {
                                  cylinder { < -7.8, 0, -15 >,< -6.2, 0, -15 >,14 }  
                                  cylinder { < -9, 0, -15 >,< -5, 0, -15 >,13.25 }
                                                          clipped_by {
                                                                        box { < -10, 0, -15 >,< -5, 15, 2 > }
                                                                      }   
                                   
                                                          scale < 1, 0.45, 1 >
                                                          translate y*23.95 
                                }                                                            
                     difference {
                                  cylinder { < 7.8, 0, -15 >,< 6.2, 0, -15 >,14 }  
                                  cylinder { < 9, 0, -15 >,< 5, 0, -15 >,13.25 }
                                                          clipped_by {
                                                                        box { < 10, 0, -15 >,< 5, 15, 2 > }
                                                                      }    
                                                          scale < 1, 0.45, 1 >
                                                          translate y*23.95 
                                } 
                                scale < 1, 1, 2 >   
                                                      pigment { color White }
                                                      normal { crackle scale 0.1 }
                                                      finish { ambient 0.3 }
                   }
                   
// Floor *******************                   
                   
#declare Grout = cylinder { < -20, 0, 0 >,< 20, 0, 0 >,0.04 pigment { color Gray60 } finish { ambient 0.2 } }
#declare Sett =
               union {
                      object { Grout }
                      object { Grout translate z*1 }   
                      object { Grout translate z*2 }
                      object { Grout translate z*3 }
                      object { Grout translate z*4 }
                      object { Grout translate z*5 }
                      object { Grout translate z*6 }
                      object { Grout translate z*7 }
                      object { Grout translate z*8 }
                      object { Grout translate z*9 } 
                      object { Grout translate z*10 }       
                      object { Grout translate z*-1 }   
                      object { Grout translate z*-2 }
                      object { Grout translate z*-3 }
                      object { Grout translate z*-4 }
                      object { Grout translate z*-5 }
                      object { Grout translate z*-6 }
                      object { Grout translate z*-7 }
                      object { Grout translate z*-8 }
                      object { Grout translate z*-9 } 
                      object { Grout translate z*-10 } 
                     }
#declare Grid =
                union {
                        object { Sett }
                        object { Sett rotate y*90 }
                      }
#declare Diags =                                                      // block of diagonal tiles
                 difference {
                             box { < -6.3, 0, 0.5 >,< 6.3, -1, -12 >
                                      texture { Brom }
                                 }
                             object { Grid rotate y*45 translate z*-6 }
                             }                                                       
#declare Atile =
                 box { < -1.3, 0, 0.5 >,< 1.3, -1, -2.05 > texture { Brom } } 
#declare Tiles =
                 union {
                         object { Atile }
                         object { Atile translate z*-2.6 }   
                         object { Atile translate z*-5.2 }  
                         object { Atile translate z*-7.8 }  
                         object { Atile translate z*-10.4 }  
                         object { Atile translate z*-13 }  
                         object { Atile translate z*-15.6 }  
                         object { Atile translate z*-18.2 }  
                         object { Atile translate z*-20.8 }  
                         object { Atile translate z*-23.4 }  
                         object { Atile translate z*-26 }     
                         object { Atile translate z*-28.6 }  
                         object { Atile translate z*-31.2 }  
                         object { Atile translate z*-33.8 }       
                         object { Atile translate z*-36.4 }  
                         object { Atile translate z*-39 }  
                         object { Atile translate z*-41.6 }
                        }                                                                   
#declare Floor =                                                                    // floor 
                 union {
                        box { < -8.9, 0, 0.5 >,< -8.7, -1, -41 > texture { Folls } }   
                        box { < 8.9, 0, 0.5 >,< 8.7, -1, -41 > texture { Folls } } 
                        object { Diags }
                        box { < -6.3, 0, -12 >,< 6.3, -1, -24 > texture { Folls } }
                        object { Diags translate z*-24.5 } 
                        box { < -6.3, 0, -36.5 >,< 6.3, -1, -48.5 > texture { Folls } }
                        object { Tiles translate x*-7.5 }
                        object { Tiles translate x*7.5 }
                       } 
                
// MAIN MODULES ************************************************************                     

                                                                                    
#declare Panel =                                                            // full building module
                union {                           
                        object { Balustrade }
                        object { Outer translate x*8.9 }   
                        object { Outer translate x*-8.9 }                            
                        object { Head translate x*-8.9 }
                        object { Head rotate y*180 translate x*8.9 }                             
                        object { Column translate x*-7.25 } 
                        object { Column translate x*7.25 } 
                        object { Roof }
                        object { Floor }
                       } 

                                      
#declare End =                                                  // five panels ( end or half side )
              union {                       
                      object { Panel }
                      object { Panel translate x*17.8 }   
                      object { Panel translate x*-17.8 }    
                      object { Panel translate x*35.6 }   
                      object { Panel translate x*-35.6 } 
                                      
                              scale < 1, 0.9, 1 >
                    }                                     
#declare Farend =                                            // far end outer
              union {                       
                      object { Panel }
                      object { Panel translate x*17.8 }   
                      object { Panel translate x*-17.8 }    
                      object { Panel translate x*35.6 }   
                      object { Panel translate x*-35.6 }        
                      object { Panel translate x*53.4 }   
                      object { Panel translate x*-53.4 } 
                              scale < 1, 0.9, 1 >
                    } 
                    
#declare Tend =                                                     // this end , with extra posts 
               union {
                       object { End } 
                       union {
                               object { Head rotate y*180 translate x*1.65 }
                               object { Column  }
                                        scale < 1, 0.9, 1 > translate x*-46.05 
                             }
                       union {
                               object { Head  translate x*-1.65 }
                               object { Column  }
                                        scale < 1, 0.9, 1 > translate x*46.05 
                             }  
                     } 
                     
// to control reflections ************************************************************************                     
                     

box { < -50, 0.1, -50 >,< 50, -50, -100 >                              
               pigment { color Gray75 }
               finish { ambient 0.2 }
    }                                      
box { < -50, 45, -140 >,< 50, -25, -101 >                              
               pigment { color Gray50 }
               finish { ambient 0.2 }
    }                                                                                      
box { < -50, 45, -140 >,< -150, -25, -101 >                              
               pigment { color Gray50 }
               finish { ambient 0.2 }
    }                                    
box { < -100, 45, -140 >,< -150, -25, 0 >                              
               pigment { color Gray50 }
               finish { ambient 0.2 }
    } 
    
    
// *******************************************************************************************    
                                                
object { Tend  }                                                    // this end     

object { Tend translate y*-31 }                                     // this end next down
                          
object { Farend  translate z*240.5 }                                // far end outer- this level          
object { Farend  translate < 0, -31, 240.5 > }                      // far end outer- next down

object { Tend rotate y*180 translate z*180 }                        // far end - this level
object { Tend rotate y*180 translate < 0, -31, 180 > }              // far end - next down  

object { End rotate y*90 translate < -46, 0, 45.75 > }            // left side - this level
object { End rotate y*90 translate < -46, 0, 134.75 > }           // left side - this level - far end 

object { End rotate y*-90 translate < 46, 0, 45.75 > }            // right side - this level
object { End rotate y*-90 translate < 46, 0, 134.75 > }           // right side - this level - far end
       
object { End rotate y*90 translate < -46, -31, 45.75 > }            // left side - next down
object { End rotate y*90 translate < -46, -31, 134.75 > }           // left side - next down - far end

object { End rotate y*-90 translate < 46, -31, 45.75 > }            // right side - next down
object { End rotate y*-90 translate < 46, -31, 134.75 > }           // right side - next down - far end                                                                   
                          
object { Roofbal translate z*179 }                          
object { Roofbal rotate y*-90 translate < -46, 0, 45.75 > } 
object { Roofbal rotate y*-90 translate < -46, 0, 134.75 > }   
object { Roofbal rotate y*-90 translate < 46, 0, 45.75 > } 
object { Roofbal rotate y*-90 translate < 46, 0, 134.75 > }  
               
// top floor  **********************************************************************               
               
#declare Side =
               union {
                      box { < 0, 0, 0 >,< 4.9, 29, 1 > 
                                 pigment { color NewTan }
                                 finish { ambient 0.3 }
                          } 
                      box { < 1.2, 0, -0.25 >,< 3.7, 29, 1 > }
                      cylinder { < 1.45, 24, -0.5 >,< 1.45, 27, -0.5 >,0.25 }  
                      cylinder { < 1.95, 24, -0.5 >,< 1.95, 27, -0.5 >,0.25 } 
                      cylinder { < 2.45, 24, -0.5 >,< 2.45, 27, -0.5 >,0.25 } 
                      cylinder { < 2.95, 24, -0.5 >,< 2.95, 27, -0.5 >,0.25 } 
                      cylinder { < 3.45, 24, -0.5 >,< 3.45, 27, -0.5 >,0.25 }
                                     texture { Arom }
                     }
#declare Sill =
               union {
                       box { < 4.9, 0, 0 >,< 12.9, 6, 1 >
                                 pigment { color NewTan }
                                 finish { ambient 0.3 }
                          } 
                       cylinder { < 4.7, 6, -0.5 >,< 13.1, 6, -0.5 >,0.2 }
                       box { < 4.7, -0.1, 0 >,< 13.1, 0.1, 1.5 >
                               rotate x*-20
                               translate < 0, 6, -0.5 >
                           }
                                      texture { Arom }
                       }
#declare Lintel =
                 union {
                         box { < 4.7, 22, 0 >,< 13.1, 29, 1 > 
                                 pigment { color NewTan }
                                 finish { ambient 0.3 }
                             } 
                         cylinder { < 4.7, 22, -0.5 >,< 13.1, 22, -0.5 >,0.2 }
                         box { < 4.7, -0.1, 0 >,< 13.1, 0.1, 1.5 >
                               rotate x*-20
                               translate < 0, 22, -0.5 >
                             } 
                               texture { Arom }
                        } 
#declare Mullion =
                    union {
                            cylinder { < 0, 6, -0.5 >,< 0, 22, -0.5 >,0.2 }
                            box { < -0.2, 6, -0.5 >,< 0.2, 22.2, 1.5 > }
                                       texture { Arom }
                          }                                     
#declare Unit =
               cylinder { < -0.25, 30, -0.5 >,< 0.25, 30, -0.5 >,1
                               texture { Arom }
                        }
#declare Frieze =
                union { 
                        object { Unit translate x*0.5 }  
                        object { Unit translate x*1.5 } 
                        object { Unit translate x*2.5 } 
                        object { Unit translate x*3.5 } 
                        object { Unit translate x*4.5 } 
                        object { Unit translate x*5.5 } 
                        object { Unit translate x*6.5 } 
                        object { Unit translate x*7.5 } 
                        object { Unit translate x*8.5 } 
                        object { Unit translate x*9.5 } 
                        object { Unit translate x*10.5 } 
                        object { Unit translate x*11.5 } 
                        object { Unit translate x*12.5 } 
                        object { Unit translate x*13.5 } 
                        object { Unit translate x*14.5 } 
                        object { Unit translate x*15.5 } 
                        object { Unit translate x*16.5 } 
                        object { Unit translate x*17.5 } 
                      }
#declare Soffit =
                  difference {
                               box { < 0, 31, 1 >,< 17.8, 36, -4 > }
                               cylinder { < -1, 31, -4 >,< 18, 31, -4 >,4 }
                                             texture { Arom }
                             }                                        
                                                     
                                                                                                    
                                                                      
                      

#declare High =                                                     // main building panel
               union {
                      object { Sill }
                      object { Lintel }
                      object { Side }
                      object { Side translate x*12.9 }
                      object { Frieze }
                      object { Soffit } 
                      object { Mullion translate x*4.9 }
                      object { Mullion translate x*8.9 }
                      object { Mullion translate x*12.9 }
                      cylinder { < 0, 24, 0 >,< 17.8, 24, 0 >,0.25 }     
                      cylinder { < 0, 27, 0 >,< 17.8, 27, 0 >,0.25 } 
                                    scale < 1, 0.85, 1 >
                                    texture { Arom }
                     } 
#declare Hiwall =
                 union {                     
                        object { High }
                        object { High translate x*17.8 }   
                        object { High translate x*35.6 }  
                        object { High translate x*53.4 }  
                        object { High translate x*71.2 }  
                        object { High translate x*89 }  
                        object { High translate x*106.8 } 
                      }
object { Hiwall rotate y*-90 translate < -52, 30, 100 > }      
object { Hiwall rotate y*-90 translate < -70, 0, 100 > }     
object { Hiwall rotate y*90 translate < 52, 30, 220 > }     
object { Hiwall rotate y*90 translate < 70, 0, 220 > } 

#declare Block =
                box { < -50, 0, 0 >,< 50, 30, 1 > pigment { color rgb < 0.56, 0.4, 0.36 > } }   // a generic wall
        
object { Block scale < 2, 1, 1 > translate < 0, -31, 250 > }     // outer wall-next down
object { Block translate < -107, 0, 250 > }       // end of left cloister
object { Block translate < 107, 0, 250 > }       // end of right cloister

box { < 70, 0, -100 >,< 71, 100, 200 > pigment { color White } }       // to block through-light 

// SKY ************************

cylinder { < -100, 0, 0 >,< 100, 0, 0 >,1        // background sky
             texture {
                       pigment { 
                                 gradient y
                                 color_map {
                                            [ 0 color Gray70 ]
                                            [ 0.4 color rgb < 0.89, 0.89, 0.98 > ]
                                            [ 1.0 color rgb < 0.9, 0.9, 1 > ]
                                           }
                               }
                       finish { ambient 1 diffuse 0 }
                       }
             scale < 5000, 5000, 7000 >
             translate y*-50
           }                                      
             
#declare Clouds =
                   union {             
plane { y, 0                 // top of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.5 color Clear ]
                                          [ 0.75 color White ]
                                          [ 1 color White ] 
                                         }
                              turbulence 0.6  lambda 2.5           
                      }
               finish { ambient 1 } 
               scale < 350, 1, 750 > 
                translate < 500, 210, 0 >
       }  
       
plane { y, 0                 // middle of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.5 color Clear ]
                                          [ 0.75 color rgb < 0.95, 0.85, 0.92 > ]
                                          [ 1 color rgb < 0.8, 0.75, 0.8 > ] 
                                         }
                              turbulence 0.6  lambda 3.5           
                      }
               finish { ambient 0.7 } 
               scale < 350, 1, 750 > 
                translate < 500, 205, 0 >
       }  
                                                    
plane { y, 0                 // base of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.5 color Clear ]
                                          [ 0.75 color rgb < 0.85, 0.76, 0.9 > ]
                                          [ 1 color rgb < 0.75, 0.55, 0.85 > ] 
                                         }
                              turbulence 0.6  lambda 4           
                      }
               finish { ambient 0.7 } 
               scale < 350, 1, 750 > 
                translate < 500, 200, 0 >
       } 
           }
object { Clouds rotate x*1.7 translate x*-500 } 

plane { y, -49 pigment { color Gray90 } finish { ambient 0.4 } } 

// STATUES **************************************************** 


#declare Cup =
             sphere { < 0, 0, 0 >,0.015
               clipped_by {
                       box { < -0.02, -0.02, -0.02 >,< 0.02, 0.02, 0 > }
                          }
               scale < 1, 1, 0.4 >
               texture { Arom }
                     }
#declare Ear =
           union {
                  torus { 0.02, 0.005  rotate x*90 }
                  sphere { < 0, 0, 0 >,0.01 translate < -0.01, 0, 0 > }
                     scale < 1, 1.1, 0.5 >
                     texture { Arom }
                 }

#declare Nose =
             union {
                    torus { 0.03, 0.01  scale < 0.5, 0.5, 1.5 >   
                          rotate z*-50
                          translate < 0.015, -0.08, 0 >                            
                          }
                    cone { < 0, 0, 0 >,0.007,< 0, -0.06, 0 >,0.025 }
                    sphere { < 0, 0, 0 >,0.025
                           scale < 1, 0.25, 1 >
                           translate < 0, -0.06, 0 >
                           }   
                     scale < 1, 1, 0.65 >
                     rotate z*-17
                     texture { Arom }
                    }
#declare Brow =   
        union {
            cone { < 0, 0.02, 0 >,0.075,< 0, -0.005, 0 >,0.08 } 
            sphere { < 0, 0, 0 >,0.08
                     scale < 1, 0.25, 1 >
                     translate < 0, -0.005, 0 >
                   }   
                 scale < 1, 1, 0.96 >  
                 rotate z*-3  
                 translate < -0.012, 0, 0 >        
                  texture { Arom } 
               }
#declare Mouth =   
           difference {
                     cylinder { < 0, 0, 0 >,< 0.001, -0.09, 0 >,0.07 }
                     box { < -0.1, 0, -0.1 >,< 0.1, -0.1, 0.1 >
                             rotate z*30
                             translate < 0, -0.06, 0 >
                         }
                         translate < -0.02, 0, 0 > 
                         texture { Arom }
                            }  
                            
#declare Eye =
              difference {
                          sphere { < 0, 0, 0 >,0.015
                                    scale < 1.5, 1, 0.8 >
                                 }
                          sphere { < 0, 0, 0 >,0.007
                                     translate z*-0.007
                                 }
                                   texture { Arom }
                          }
#declare Lox =
                torus { 0.05, 0.01 
                              rotate x*90 
                              scale < 0.7, 1.1, 2 >
                              rotate z*25 
                              translate < 0.05, 0.04, 0 > 
                              texture { Arom }
                      } 
#declare Hair =
               union { 
                       object { Lox scale < 1, 1.2, 1 > translate y*-0.02 }
                       object { Lox scale < 1, 1.2, 1 > translate y*-0.02 rotate y*30 }  
                       object { Lox scale < 1, 1.2, 1 > translate y*-0.02 rotate y*45 } 
                       object { Lox rotate y*80 }  
                       object { Lox rotate y*-80 }  
                       object { Lox rotate y*62 }  
                       object { Lox rotate y*-62 } 
                       object { Lox scale < 1, 1.2, 1 > translate y*-0.02 rotate y*-30 }  
                       object { Lox scale < 1, 1.2, 1 > translate y*-0.02 rotate y*-45 }     
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*95 }  
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*-95 }       
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*110 }  
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*-110 }
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*125 }  
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*-125 }
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*140 }  
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*-140 } 
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*155 }  
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*-155 }
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*170 }  
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*-170 } 
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*185 }  
                       object { Lox scale < 1, 0.8, 1 > translate y*0.018 rotate y*-185 }        
                      }                                                                                                    

#declare Head =                            // facing left
            union {
                   sphere { < 0, 0, 0 >,0.1           // skull
                           scale < 0.9, 1, 0.8 >  
                          } 
                   object { Hair }      
                   
                   sphere { < 0, 0, 0 >,0.1            // jaw
                           scale < 0.4, 0.95, 0.75 >  
                           rotate z*-60 
                           translate < -0.012, -0.07, 0 >
                          }
                   sphere { < 0, 0, 0 >,0.102            // beard
                           scale < 0.4, 0.9, 0.75 >  
                           rotate z*-60 
                           translate < -0.0175, -0.069, 0 >
                           texture { Arom }
                          }
                 object { Eye rotate y*70 translate < -0.075, -0.02, -0.025 > }     
                 object { Eye rotate y*110 translate < -0.075, -0.02, 0.025 > }
                 object { Ear rotate y*20 translate < 0.02, -0.04, -0.078 > }
                 object { Ear rotate y*-20 translate < 0.02, -0.04, 0.078 > }
                 object { Cup rotate y*-20 translate < 0.02, -0.04, 0.079 > } 
                 object { Cup rotate < 180, 20, 0 > 
                              translate < 0.02, -0.04, -0.079 > }
                  
                   object { Mouth }
                   object { Brow }
                   object { Nose translate < -0.075, 0, 0 > }
                   cone { < 0, 0, 0 >,0.05,< 0.03, -0.15, 0 >,0.06 } //neck
                   texture { Arom }
                   translate < -0.03, 0.15, 0 > 
                             scale 6.25
                   }
         // zero point for head is now centre of neck




#declare Uparm =
                  union {
                         sphere { < 0, 0, 0 >,0.35 }
                         cone { < 0, 0, 0 >,0.3,< 0, -1.8, 0 >,0.2 }
                         sphere { < 0, 0, 0 >,0.33
                                       scale < 0.8, 3.3, 1 >
                                       translate < 0, -0.8, 0 >
                                }       
                         sphere { < 0, -1.8, 0 >,0.2 }
                                      texture { Arom }
                        } 
#declare Fingers =
                   difference {
                                 torus { 0.6, 0.1 scale < 1, 3.4, 0.6 > }
                                 box { < -1, -1, -1 >,< 1, 1, 0 > }
                                         texture { Arom }
                              }
                        
#declare Lefhand =
                   union {
                          object { Fingers }
                          cylinder { < -0.7, 0.2, 0 >,< 0.3, 0.2, 0 >,0.1 }
                                         translate x*0.6 
                                         scale 0.5
                                         rotate y*90
                                         texture { Arom }
                         }                                                 
#declare Rithand =
                   union {
                          object { Fingers }
                          cylinder { < 0.7, 0.2, 0 >,< -0.3, 0.2, 0 >,0.1 }
                                         translate x*-0.6 
                                         scale 0.5
                                         rotate y*-90 
                                         texture { Arom }
                         }                                                                                 
                                                                                  
#declare Rforarm =
                  union {
                         sphere { < 0, 0, 0 >,0.2 }
                         cone { < 0, 0, 0 >,0.2,< 0, -1.4, 0 >,0.15 }
                         sphere { < 0, 0, 0 >,0.22
                                      scale < 1, 3.5, 1 >
                                      translate y*-0.4
                                }      
                         sphere { < 0, -1.4, 0 >,0.15 } 
                         object { Rithand 
                                      rotate x*-90
                                      translate y*-1.4 
                                }      
                                      texture { Arom }                                       
                        }                                            
#declare Lforarm =
                  union {
                         sphere { < 0, 0, 0 >,0.2 }
                         cone { < 0, 0, 0 >,0.2,< 0, -1.4, 0 >,0.15 }
                         sphere { < 0, 0, 0 >,0.22
                                      scale < 1, 3.5, 1 >
                                      translate y*-0.4
                                }      
                         sphere { < 0, -1.4, 0 >,0.15 } 
                         object { Lefhand 
                                      rotate x*-90
                                      translate y*-1.4 
                                }      
                                      texture { Arom }
                        }                         

                                                                                
#declare Thigh =
                  union {
                         sphere { < 0, 0, 0 >,0.45 }  
                         sphere { < 0, 0, 0 >,0.615 
                                    scale < 0.6, 1, 1 >
                                    translate < 0, 0, 0.2 >
                                }
                         cone { < 0, 0, 0 >,0.45,< 0, -2.5, 0 >,0.3 }
                         sphere { < 0, 0, 0 >,0.5
                                      scale < 1, 3.5, 1 >
                                      translate < 0, -1.2, 0 >
                                }      
                         sphere { < 0, -2.5, 0 >,0.35 }
                                      texture { Arom }
                        }                                                           
#declare Calf =
                  union {
                         sphere { < 0, 0, 0 >,0.35 }
                         cone { < 0, 0, 0 >,0.3,< 0, -2.5, 0 >,0.17 }
                         sphere { < 0, 0, 0 >,0.3
                                      scale < 1, 2.6, 1 >
                                      translate < 0, -0.8, 0.15 >
                                }                                   
                         sphere { < 0, 0, 0 >,0.28
                                      scale < 1, 3, 1 >
                                      translate < 0, -1.2, 0.05 >
                                }             
                         sphere { < 0, -2.5, 0 >,0.2 }
                                      texture { Arom }
                        } 
#declare Groin =
                 cylinder { < -0.5, 0, 0 >,< 0.5, 0, 0 >,0.4
                                  scale < 1, 1.5, 1 >
                                  texture { Arom }
                          } 
#declare Waist = 
                union {
                         cylinder { < 0, 0, 0 >,< 0, 1, 0 >,0.75 }
                         cone { < 0, 1, 0.2 >,0.75,< 0, 0, 0.6 >,0.65 }
                                scale < 1, 1, 0.5 >
                                texture { Arom }
                          }
#declare Chest = 
                union {
                         superellipsoid { < 0.25, 0.25 > 
                                             scale < 0.35, 0.5, 0.45 > 
                                             rotate y*15
                                             translate < -0.23, -0.56, -0.05 >
                                        }                                    
                          superellipsoid { < 0.2, 0.2 > 
                                             scale < 0.35, 0.5, 0.45 >
                                             rotate y*-15
                                             translate < 0.23, -0.56, -0.05 >
                                        }                    
                         cone { < 0, 0, 0 >,1.1,< 0, -2, 0 >,0.75
                                scale < 1, 1, 0.5 > 
                              }  
                                texture { Arom }
                        }                                   
#declare Shoulder =
                    union {
                            cylinder { < -1, 0, 0 >,< 1, 0, 0 >,0.3 }
                            sphere { < 0, 0, 0 >,1.1
                                       scale < 1, 0.6, 0.5 >
                                   }   
                                       texture { Arom }
                            } 
#declare Foot =
               union {
                       sphere { < 0, 0, 0 >,0.22 } 
                       cone { < 0, 0, 0 >,0.25,< 0, -0.15, 0 >,0.35 }
                       sphere { < 0, 0, 0 >,0.25 
                                  scale < 1.3, 1, 2.5 >
                                  translate < 0, -0.15, -0.35 > }
                                  texture { Arom }
                     }                                                                               
#declare Astatue =
                   union {
                          object { Head rotate y*-90 translate z*-0.2 } 
                          object { Shoulder translate y*-0.35 }
                          object { Chest translate y*-0.35 }                                                                                                 
                          object { Uparm translate  < -0.95, -0.35, 0 > }
                          object { Rforarm rotate z*-15 translate < -0.95, -2.15, 0 > } 
                          union {   
                                  object { Uparm }                           
                                  object { Lforarm  rotate x*30 translate y*-1.8 }
                                              rotate x*15
                                              translate < 0.95, -0.35, 0 >
                                 }              
                                  
                          object { Waist translate y*-2.6 }
                          object { Thigh translate < -0.5, -2.8, 0 > }
                          object { Calf translate < -0.5, -5.3, 0 > }
                          object { Foot translate < -0.5, -7.9, 0 > }       
                          object { Thigh translate < 0.5, -2.8, 0 > }
                          object { Calf translate < 0.5, -5.3, 0 > }
                          object { Foot translate < 0.5, -7.9, 0 > } 
                          object { Groin translate y*-2.8 }
                         }                                                                
#declare Bstatue =
                   union {
                          
                          union {                                                               // torso
                                   object { Head rotate < 0, -80, -15 >  translate z*-0.2 }   
                                   object { Shoulder translate y*-0.35 }
                                   object { Chest translate y*-0.35 } 
                                   object { Waist translate y*-2.6 } 
                                    translate y*2.6
                                    rotate < -10, 0, -10 >
                                    translate y*-2.6 
                                } 
                          union {                                                                // right arm                                                                                                        
                                   object { Uparm translate  < -0.95, -0.35, 0 > }
                                   object { Rforarm rotate x*90 translate < -0.95, -2.15, -0.2 > }
                                        rotate < 100, 45, 0 >
                                        translate < 0.4, -0.2, -1.1 >
                                } 
                                        
                          union {                                                               // left arm  
                                  object { Uparm }                           
                                  object { Lforarm  rotate x*30 translate y*-1.8 }
                                              rotate < 15, 0, 10 >
                                              translate < 1.25, -0.35, -0.4 >
                                 }              
                                  
                          union {                                                               // right leg
                                  object { Thigh  }
                                  object { Calf rotate x*-55 translate < 0, -2.5, 0 > }
                                  
                                            rotate x*25 
                                            translate < -0.5, -2.8, 0 >
                                } 
                          union {                                                                // left leg                    
                                   object { Thigh }
                                   object { Calf rotate x*-30  translate < 0, -2.5, 0 > }
                                 
                                                     rotate < -8, -20, 0 >
                                                    translate < 0.5, -2.8, 0 >
                                }
                          object { Groin translate y*-2.8 } 
                          object { Foot translate < -0.5, -7.3, 0.2 > }   // right
                          object { Foot translate < -0.25, -7.3, 2 > }    // left
                                               translate y*-0.6                        // standing on y=-8
                         } 
                         
#declare Spear = 
                  union {
                         sphere { < 0, 0, 0 >,0.1 scale < 1, 4, 1 > translate y*10 }   
                         cylinder { < 0, 0, 0 >,< 0, 10, 0 >,0.06 } 
                                        texture { Arom }
                         }                                       
#declare Cstatue =
                   union {
                          
                          union {                                                               // torso
                                   object { Head rotate y*-90 translate z*-0.2 }   
                                   object { Shoulder translate y*-0.35 }
                                   object { Chest translate y*-0.35 } 
                                   object { Waist translate y*-2.6 } 
                                    translate y*2.6
                                    rotate < 10, 0, 0 >
                                    translate y*-2.6 
                                } 
                          union {                                                                // right arm                                                                                                        
                                   object { Uparm translate  < -0.95, -0.35, 0 > }
                                   object { Rforarm rotate x*90 translate < -0.95, -2.15, -0.2 > }
                                        rotate < -10, 0, 0 >
                                        translate < -0.21, -0.05, 0.21 >
                                } 
                                        
                          union {                                                               // left arm  
                                  object { Uparm }                           
                                  object { Lforarm  rotate x*10 translate y*-1.8 }
                                              rotate < 60, -20, 0 >
                                              translate < 1.05, -0.38, 0.35 >
                                 }              
                                  
                          union {                                                               // right leg
                                  object { Thigh  }
                                  object { Calf rotate x*-10 translate < 0, -2.5, 0 > }
                                  
                                            rotate x*-5 
                                            translate < -0.5, -2.8, 0 >
                                } 
                          union {                                                                // left leg                    
                                   object { Thigh }
                                   object { Calf rotate x*-30  translate < 0, -2.5, 0 > }
                                 
                                                     rotate < 12, -20, 0 >
                                                    translate < 0.5, -2.8, 0 >
                                }
                          object { Groin translate y*-2.8 } 
                          object { Foot translate < -0.5, -7.7, 0.8 > }   // right
                          object { Foot translate < 0.5, -7.7, 0.25 > }    // left 
                          object { Spear rotate < -20, -20, 0 > translate < 1.49, -8, -0.5 > }
                                               translate y*-0.15
                         }                          
#declare Cape =
                union {
                        cone { < 0, 0, 0 >,1.2,< 0, -4, 0 >,1.8 }
                        torus { 1.8, 0.1
                                    translate y*-4
                              }
                                 clipped_by {
                                              box { < -2, -4.5, 0 >,< 2, 1.5, 2 > }
                                            } 
                                       scale < 1.1, 1, 0.6 >
                                       rotate x*-10
                                       translate z*-0.15     
                                       texture { Arom }
                      }                                 
                                                                                                         
#declare Dstatue =
                   union {
                          
                          union {                                                               // torso 
                                   object { Cape translate y*-0.3 }
                                   object { Head rotate y*-90 translate z*-0.2 }   
                                   object { Shoulder translate y*-0.35 }
                                   object { Chest translate y*-0.35 } 
                                   object { Waist translate y*-2.6 } 
                                    translate y*2.6
                                    rotate < 10, 0, 0 >
                                    translate y*-2.6 
                                } 
                          union {                                                                // right arm                                                                                                        
                                   object { Uparm translate  < -0.95, -0.35, 0 > }
                                   object { Rforarm rotate x*20 translate < -0.95, -2.15, 0 > }
                                        rotate < -10, 0, 0 >
                                        translate < -0.15, -0.05, 0.28 >
                                } 
                                        
                          union {                                                               // left arm  
                                  object { Uparm }                           
                                  object { Lforarm  rotate x*90 translate < 0, -1.8, -0.2 > }
                                              rotate < 0, -20, 0 >
                                              translate < 1.05, -0.38, 0.35 >
                                 }              
                                  
                          union {                                                               // right leg
                                  object { Thigh  }
                                  object { Calf rotate x*-10 translate < 0, -2.5, 0 > }
                                  
                                            rotate < 20, 15, 0 > 
                                            translate < -0.5, -2.8, 0 >
                                } 
                          union {                                                                // left leg                    
                                   object { Thigh }
                                   object { Calf rotate x*-20  translate < 0, -2.5, 0 > }
                                 
                                                     rotate < 5, -20, 0 >
                                                    translate < 0.5, -2.8, 0 >
                                }
                          object { Groin translate y*-2.8 } 
                          object { Foot rotate y*20 translate < -0.85, -7.7, -1.3 > }   // right
                          object { Foot rotate y*-10 translate < 0.3, -7.7, 0.35 > }    // left
                          torus { 0.43, 0.1 
                                       scale < 1, 1, 1.8 > 
                                       rotate x*-63 
                                       translate < 0, -0.35, 0 >
                                       texture { Arom }
                                }       
                          superellipsoid { < 0.2, 0.2 >                                 // stand
                                             scale < 0.25, 2.85, 0.5 > 
                                             rotate y*-10
                                             translate < 1.5, -5.1, -0.75 > 
                                             texture { Arom }
                                         }
                                               translate y*-0.15
                         } 
#declare Coat =
                union {
                        cone { < 0, 0, 0 >,1.2,< 0, -5.5, 0 >,1.5 }
                        torus { 1.5, 0.1
                                    translate y*-5.5
                              }
                                 clipped_by {
                                              box { < -2, -7.5, -0.4 >,< 2, 1.5, 2 > }
                                            } 
                                       scale < 1.1, 1, 0.6 >
                                       rotate x*-10
                                       translate z*-0.15     
                                       texture { Arom }
                      }                                 
                                                                                                         
#declare Estatue =
                   union {
                          
                          union {                                                               // torso 
                                   object { Coat translate y*-0.3 } 
                                   triangle { < -1.6, -5.8, 0.56 >,                            // add to cape
                                              < -1.36, -0.5, 0 >,
                                              < -1.32, -0.975, -1.3 >                                                
                                            } 
                                   cylinder { < -1.6, -5.8, 0.56 >,< -1.32, -0.975, -1.3 >,0.1 }  
                                   cylinder { < 1.6, -5.8, 0.56 >,< 1.32, -0.4, -0.4 >,0.1 }                         

                                   torus { 0.15, 0.08 rotate x*90 scale < 1.2, 1, 1 > translate < -1.15, -1, -1.3 > }              
                                   object { Head rotate y*-90 translate z*-0.2 }   
                                   object { Shoulder translate y*-0.35 }
                                   object { Chest translate y*-0.35 } 
                                   object { Waist translate y*-2.6 } 
                                    translate y*2.6
                                    rotate < 10, 0, 0 >
                                    translate y*-2.6 
                                     texture { Arom }
                                } 
                          union {                                                                // right arm                                                                                                        
                                   object { Uparm translate  < -0.95, -0.35, 0 > }
                                   object { Rforarm rotate < 120, -90, 0 > translate < -0.95, -2.15, 0 > }
                                        rotate < 70, 0, 0 >
                                        translate < -0.15, -0.35, 0.68 >
                                } 
                                        
                          union {                                                               // left arm  
                                  object { Uparm }                           
                                  object { Lforarm  rotate x*25 translate < 0, -1.8, -0.2 > }
                                              rotate < -10, -20, 0 >
                                              translate < 1.05, -0.38, 0.35 >
                                 }              
                                  
                          union {                                                               // right leg
                                  object { Thigh  }
                                  object { Calf rotate x*-10 translate < 0, -2.5, 0 > }
                                  
                                            rotate < 20, 15, 0 > 
                                            translate < -0.5, -2.8, 0 >
                                } 
                          union {                                                                // left leg                    
                                   object { Thigh }
                                   object { Calf rotate x*-20  translate < 0, -2.5, 0 > }
                                 
                                                     rotate < 5, -20, 0 >
                                                    translate < 0.5, -2.8, 0 >
                                }
                          object { Groin translate y*-2.8 } 
                          object { Foot rotate y*20 translate < -0.85, -7.7, -1.3 > }   // right
                          object { Foot rotate y*-10 translate < 0.3, -7.7, 0.35 > }    // left
                          torus { 0.33, 0.25 
                                       scale < 1, 1, 1.8 > 
                                       rotate x*-73 
                                       translate < 0, -0.85, 0.1 >
                                       texture { Arom }
                                }       
                          
                                               translate y*-0.15
                         } 
                         

object { Bstatue rotate y*20  translate < -44, 44, 178.5 >  }     

object { Dstatue rotate y*20  translate < -8.4, 44.1, 179.5 >  } 
      
object { Estatue rotate y*70  translate < 9.4, 44, 178.5 >  }     

object { Cstatue rotate y*-25  translate < 44, 44, 178.5 >  } 

// DISTANT VEGETATION ************************************************* 

#declare Twig =
                cylinder { < 0, 0, 0 >,< 0, 0.5, 0 >,0.05
                               pigment { color rgb < 0.8, 0.7, 0.6 > }
                               finish { ambient 0.2 }
                         } 
                         
#declare Twigig =
                 union {
                         object { Twig scale < 0.5, 1.2, 0.5 > rotate z*35 }
                         object { Twig scale < 0.5, 1.2, 0.5 >  rotate z*-25 }
                       }                                                   
#declare Branch =
                   union {                         
                           object { Twig  }
                           object { Twig scale < 0.8, 1.2, 0.8 > rotate z*30 translate y*0.5 }
                           object { Twig scale < 0.7, 1.2, 0.7 > rotate z*-40 translate < -0.15, 0.7, 0 > }
                           object { Twigig rotate y*50 translate < -0.3, 1, 0 > }   
                           object { Twigig rotate < 0, -60, -25 >  translate < 0.25, 1.15, 0 > }
                           object { Twigig scale < 1, 1.5, 1 > rotate < 0, 80, -45 > translate < 0, 0.25, 0 > }                                 
                         } 
#declare Branches =
                   union {
object { Branch rotate z*15 translate < -2.5, 0, 0 > }   
object { Branch rotate < 0, 60, -15 > translate < 0.25, 0, 0 > } 
object { Branch rotate y*180 translate < -4.5, 0.3, 0 > }  
object { Branch rotate y*60 translate < 8, 0.3, 0 > }
object { Branch rotate z*18 translate < -11, 0.3, 0 > }    
object { Branch rotate z*18 translate < 17, 0.3, 0 > } 
object { Branch rotate y*180 translate < 23.4, 0, 0 > }  
object { Branch rotate y*60 translate < 31, 0.3, 0 > }
                           scale 5
                         }
object { Branches translate < 0, -2, 1000 > }                                                                                              


#declare Dist =                                             
                height_field {
                               tga "Gran2.tga" smooth
                               translate < -0.5, -0.5, -0.5 >
                               scale < 430, 60, 260 > 
                               pigment {
                                         granite
                                         color_map {
                                                     [ 0 color rgb < 0.5, 0.6, 0.4 > ]  
                                                     [ 0.1 color rgb < 0.5, 0.6, 0.4 > ]
                                                     [ 0.1 color Clear ]   
                                                     [ 0.5 color Clear ]
                                                     [ 0.5 color rgb < 0.5, 0.6, 0.4 > ]
                                                     [ 0.6 color rgb < 0.5, 0.6, 0.4 > ] 
                                                     [ 0.6 color Clear ]
                                                     [ 0.8 color Clear ] 
                                                     [ 1.0 color rgb < 0.8, 0.8, 0.3 > ] 
                                                   }
                                             scale 20
                                         }
                                 finish { ambient 0.4 diffuse 0.4 } 
                                 translate < 1, 2, 0 >
                               }
                                            
object { Dist translate < 0, -1, 1000 > } 


                                        // END                                                               
                                                                  