//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 9 materials and 38 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/30/2003    (30.04.2003)
//



/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
//  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     100.0
  color <0.6,0.6,0.6,0.0,0.0>
  turbulence   <2.0,4.0,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 5.0
  up           <0,0,1>
  fog_offset   5.0
  fog_alt      1.0
}

fog {
  fog_type 2    // Ground Fog
  distance     5.0
  color <1.0,0.94902,0.85098,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      0.25
}

camera {  //  Camera StdCam
  location  <     -3.250,     -25.250,       1.750>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.36807,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         46.65403    // Vertical      34.991
  look_at   <      4.298,      -0.767,       5.612>
}

//
// *******  L I G H T S *******
//



light_source {   // Light003
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.2500
  shadowless
  translate  <19.25, -41.5, 7.25>
}


light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <22.375, 31.875, 22.25>
}


//
// ********  MATERIALS  *******
//

#include "final2.inc"

// COMMON GALAXY OPTIONS 
#declare galaxy_colour1 = < 1.3, 1.2, .8> ; 
#declare galaxy_colour2 = < 1, .5, .3 > ; 
#declare galaxy_rotate = < 90, 180, 0> ; 

// GALAXY BACKGROUND 
#declare galaxy_bgstars = 4; 
#declare galaxy_bgnebula = off; 
#declare galaxy_nebula_sphere = 5; 
#include "GALAXY.BG" 

// GALAXY OBJECTS 
#declare galaxy_object_name = "Nebula3" 
#declare galaxy_cluster_name = "Star4" 
#include "GALAXY.OBJ" 
#declare galaxy_object_name = "Comet2" 
#declare galaxy_cluster_name = "" 
#include "GALAXY.OBJ" 


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//



object {   // HgtFld001
  height_field {
    sys /*unknown extension [BMP]*/ "C:\Program Files\Moray For Windows\My Scenes\Final\Heightfield Test\Ground12.bmp"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Green_Ground
  }
  scale <39.125, 34.75, 3.625>
  translate  3.75*z
}


#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <-3.250, -25.250, 1.750>;  // using camera 'StdCam'
#declare lookat = <4.298, -0.767, 5.612>;
#declare light_loc = <22.37500, 31.87500, 22.25000>;  // using light source 'Light002'

#declare flare_size = 1.000;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sunset1.flr"
#include "NKFlare\nkflare.inc"




box { // Monolith
  <-1, -1, -1>, <1, 1, 1>
  material {
    Mono_Black
  }
  scale <2.389807, 0.853369, 5.110741>
  rotate 16.113926*z
  translate  <-0.331511, 0.0, 4.840066>
}


union { // Upper_Ring
  box { // Cube032_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <1.537299, 0.588152, 0.267036>
    rotate -30.519154*z
    translate  <5.489346, 7.920107, 2.013006>
  }
  box { // Cube031_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <1.701872, 0.644851, 0.267036>
    rotate -60.203381*z
    translate  <8.191245, 5.302643, 2.013006>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <1.680893, 0.608215, 0.267036>
    rotate -80.760414*z
    translate  <9.499978, 1.840834, 2.013006>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <1.889241, 0.574323, 0.267036>
    rotate -99.833336*z
    translate  <9.499978, -2.169797, 2.013006>
  }
  box { // Cube028_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <1.534835, 0.641434, 0.267036>
    rotate -124.24646*z
    translate  <8.191245, -5.673823, 2.013006>
  }
  box { // Cube027_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <1.652146, 0.619154, 0.267036>
    rotate -146.047562*z
    translate  <5.615998, -8.122419, 2.013006>
  }
  box { // Cube026_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <1.815802, 0.559859, 0.267036>
    rotate -168.466721*z
    translate  <1.943104, -9.515585, 2.013006>
  }
  box { // Cube025_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <1.549301, 0.543449, 0.267036>
    rotate 173.294632*z
    translate  <-1.814225, -9.726671, 2.013006>
  }
  box { // Cube024_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <1.805801, 0.531097, 0.267036>
    rotate 144.066422*z
    translate  <-5.276033, -8.333505, 2.013006>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <1.805801, 0.531097, 0.267036>
    rotate 122.845612*z
    translate  <-7.977932, -5.462737, 2.013006>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <1.582665, 0.574649, 0.267036>
    rotate 99.001511*z
    translate  <-9.328882, -1.958711, 2.013006>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <1.617757, 0.526346, 0.267036>
    rotate 81.134132*z
    translate  <-9.286665, 1.671966, 2.013006>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <1.534332, 0.513333, 0.267036>
    rotate 61.503578*z
    translate  <-8.062367, 5.091557, 2.013006>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <1.749382, 0.575363, 0.267036>
    rotate 30.837374*z
    translate  <-5.524833, 7.812969, 2.013006>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <1.629674, 0.518335, 0.267036>
    rotate 15.388541*z
    translate  <-1.884024, 9.210452, 2.013006>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <1.751834, 0.536665, 0.282607>
    rotate -10.793842*z
    translate  <1.940664, 9.284003, 2.028577>
  }
  material {
    Gray_Rock
  }
  translate  1.347655*z
}


union { // Main_Circle
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.864302, 0.457208, 1.0>
    translate  <-0.078552, 9.504812, 0.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.597119, 0.802587, 1.0>
    translate  <9.740469, 0.0, 0.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.789512, 0.470697, 1.0>
    rotate 88.475143*z
    translate  <-9.464148, 0.059608, 0.0>
  }
  box { // Cube004_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <0.907428, 0.50876, 1.0>
    translate  <-0.119216, -9.740469, 0.0>
  }
  box { // Cube005_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <0.52922, 0.844305, 1.0>
    rotate 46.454201*z
    translate  <6.991143, 6.991143, 0.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.879964, 0.518909, 1.0>
    rotate -44.24897*z
    translate  <-6.991143, -6.912591, 0.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.794659, 0.475179, 1.0>
    rotate 41.474293*z
    translate  <-6.951005, 6.628468, 0.0>
  }
  box { // Cube008_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <0.99376, 0.585168, 1.0>
    rotate 43.29092*z
    translate  <6.928759, -7.188911, 0.0>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.499691, 0.82251, 1.0>
    rotate 66.820129*z
    translate  <3.77328, 8.776123, 0.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.827282, 0.467457, 1.0>
    rotate 19.458473*z
    translate  <-3.851832, 8.672272, 0.0>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.779049, 0.478433, 1.0>
    rotate 64.574089*z
    translate  <-8.844742, 3.441732, 0.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.460718, 0.870694, 1.0>
    rotate 23.669458*z
    translate  <9.112051, 3.6134, 0.0>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.786446, 0.526731, 1.0>
    rotate -64.256699*z
    translate  <-9.033499, -3.534847, 0.0>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.937576, 0.540451, 1.0>
    rotate 62.85675*z
    translate  <8.973891, -4.168817, 0.0>
  }
  box { // Cube015_M_iso
    <-1, -1, -1>, <1, 1, 1>
    scale <0.887925, 0.546389, 1.0>
    rotate 23.640461*z
    translate  <3.849056, -9.071387, 0.0>
  }
  box { // Cube016_M_iso_PRIMARY
    <-1, -1, -1>, <1, 1, 1>
    scale <0.958322, 0.505559, 1.0>
    rotate -22.865532*z
    translate  <-3.849056, -9.190603, 0.0>
  }
  material {
    Dark_Gray
  }
  scale <1.0, 1.0, 1.592968>
  translate  1.503605*z
}


cylinder { // Cylndr001
  <0,0,1>, <0,0,0>, 1 
  material {
    AberGraniteGR
  }
  scale 8.366441
  translate  -31.375*z
}


