#declare deltazwischenraum = 0.1;
#declare PI = 3.141529654;
#declare ringrotvarianz = 2;
#declare rotationsvarianz = 15;               

#macro kegeldach(innenradius,deltaradius,Seed)
	union {
	
		//Einzelrotationsvarianz (Scheisswort) in Grad
		#local R1 = seed (Seed);
		
		//Die untere Kante des Turmes
		#local  level=0;
		#local verdrehung = 0;
		
		//Hhenschleife
		//Umfang entspricht der Anzahl der Kltzchen
		#local nextumfang = 2 * PI * innenradius;
		
		//Wenn nchster Umfang < 1 ist letzte Ebene erreicht
		#while ( nextumfang > (1 + deltazwischenraum) )
			
			#local umfang = nextumfang;
			#local nextumfang = 2 * PI * (innenradius - deltaradius);
			
		
			//Kltzchenreihe setzen
			#local numofbricks=umfang/(2-deltazwischenraum);
			#local winkel = 360 / numofbricks;
			#local verdrehung = verdrehung + (winkel/2) * 1.3;
			
			//Anfangsrotation
			#local startrot = ringrotvarianz*rand(R1)+verdrehung;
		
			#while ( numofbricks > 0)
				#local actrot = rotationsvarianz*rand(R1)-(rotationsvarianz/2); 
				
				object { halbklotz(rand(R1))
						 rotate <0,actrot,0>
						 translate innenradius*x
						 translate level*y
						 rotate <0,(numofbricks * winkel)+startrot,0>
				}
		
				#local numofbricks = numofbricks - 1;
			//Ende Kreisschleife
			#end         
		
			//Umfang verringern fr nchste Ebene
			#local innenradius = innenradius - deltaradius;
			
			//level erhhen
			#local level = level + 1;
		#end
		
		//Schlusskltzchen setzen
		object { halbklotz(rand(R1))
			translate level*y
		}
		
	}
#end

#macro rundturm(innenradius,Height,Seed)
	union {
	
		//Einzelrotationsvarianz (Scheisswort) in Grad
		#local R1 = seed (Seed);
		
		//Die untere Kante des Turmes
		#local verdrehung = 0;
		#local umfang = 2 * PI * innenradius;
		
		#local numofbricks=int(umfang/(2-deltazwischenraum));
		#local winkel = 360 / numofbricks;
		
		#local  level=0;
		//Wenn nchster Umfang < 1 ist letzte Ebene erreicht
		#while (level<Height)
		
			#local verdrehung = verdrehung + (winkel/2)+5*rand(R1)-2.5;
			
			//Anfangsrotation
			#local startrot = ringrotvarianz*rand(R1)+verdrehung;
			#local i=numofbricks;
			#while ( i > 0)
				#local actrot = rotationsvarianz*rand(R1)-(rotationsvarianz/2);
				#local actwinkel = 3*rand(R1)-1.5; 
				
				object { halbklotz(rand(R1))
						 rotate <0,actrot,0>
						 translate innenradius*x
						 translate level*y
						 rotate <0,(i * winkel+actwinkel)+startrot,0>
				}
		
				#local i = i - 1;
			//Ende Kreisschleife
			#end         
			
			//level erhhen
			#local level = level + 1;
		#end
	}
#end