// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#declare Radiosity=on;

global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
    #end
  }
}

// ----------------------------------------

camera {
  right x*image_width/image_height
  location  <-2,3.5,-7>
  look_at   <2,2,0>
}

// focal blur camera
camera {
  location  <-2,3.5,-7>
  look_at  <2,2,0>
  right     x*image_width/image_height
  aperture 0.75           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 100        // number of rays per pixel for sampling
  focal_point <0,1,0>    // point that is in focus <X,Y,Z>
  confidence 1           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/10000            // [0...1] how precise to calculate (smaller is more accurate)
}



light_source {
  <300,500,-400>       // light's position
  color rgb <1, 1, 1>  // light's color
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

// ----------------------------------------

plane {
  y, 0
  texture {
    //pigment {rgb 1}
    pigment {
      checker
      color rgb <1.0, 0.8, 0.6>
      color rgb <1.0, 0.3, 0.3>
      scale 0.5
    }
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 1
        specular 0.3
	reflection 0.9
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
	reflection 0.9
      }
    #end
  }
  /*
  texture {
    pigment {
      checker
      color rgb <1.0, 0.8, 0.6>
      color rgb <1.0, 0.0, 0.0>
      scale 0.5
    }
  }
  */
}

#declare Box = box {
	<-0.5, 0, -0.5>
	< 0.5, 1,  0.5>
}

#declare R = seed(5324);
#declare RCol = seed(522003);

#macro MakeBoxes(Num)

//#declare Num = 5;
#declare Min = min_extent(Box)/2-y*0.5;//<-0.5, 0, -0.5>;
#declare Max = max_extent(Box)/2-y*0.5;//<0.5, 1, 0.5>;

union {
#while(Num > 0)
	#declare Point = <Min.x + (Max.x-Min.x)*rand(R), Max.y, Min.z + (Max.z-Min.z)*rand(R)>;
	#declare Scale = 0.5 + 0.5*rand(R);
	#declare Angle = y*360*rand(R);
	
	object {
		Box

		pigment { color rgb 0.2 + 0.8*<rand(RCol), rand(RCol), rand(RCol)> }

		scale Scale
		rotate Angle
		translate Point
	}

	#declare Min = Min + y*Scale;
	#declare Max = Max + y*Scale;
	#declare Num = Num - 1;
#end
}

#end

#declare Boxes1 = MakeBoxes(5);
#declare Boxes2 = MakeBoxes(5);

object {
	Boxes1
	translate x
}

object {
	Boxes2
	translate -x
}


difference {
	union {
		box {
			<-1.5, 0  , -0.5>
			< 1.5, 0.7,  0.5>
		}

		cylinder {
			<0, 0.2, -0.5>
			<0, 0.2,  0.5>
			1
		}
	}

	cylinder {
		<0, 0, -0.6>
		<0, 0,  0.6>
		0.5
	}

	box {
		<-1.6, -0.9, -0.6>
		< 1.6,  0  ,  0.6>
	}

	pigment { color rgb 0.2 + 0.8*<rand(RCol), rand(RCol), rand(RCol)> }

	rotate -z*1.5
	translate y*3.63
}

#declare bashen = 150;
#declare RPos = seed(324);

#while(bashen > 0)
	object {
		MakeBoxes(7*rand(R))
		translate <-30 + 70*rand(RPos), 0, 100*rand(RPos)>
	}

	#declare bashen = bashen - 1;
#end



