#version 3.5;



global_settings {
  assumed_gamma 1.0
  max_trace_level 200
}

#include "kolors.inc"
#include "golds.inc"
#include "functions.inc"
#include "bridge.inc"
#include "statue.inc"

// ----------------------------------------

#declare camera_point = 1;  // 1 is the final 

#if (camera_point = 0)
camera {
  location  <-20, 5, -22>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-30.5, 10,  -10.0>
  angle 35
}
#end
#if (camera_point = 1)
camera {
  up y
  right x
  location  <-44, 5, -22.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <40.5, 25,  0.0>
  angle 34
}
#end
#if (camera_point = 2)
camera {
  up y
  right x
  location  <40.5,38,-50>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <40.5, 38, 3.0>
}
#end

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 SteelBlue4]
//      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

#declare layers = 0; 

#while (layers < 10)
 sphere {0,10000-layers*100
 pigment{
  bozo
  color_map{
   [0.4 rgbt 1]
   [0.5 rgbt 0.95]
   [1 White*2]
  }
  turbulence .8
  scale 800
 } 
 scale <3.2,1,3.2>}
 #declare layers = layers + 1;
#end

light_source {
  <-30, 100, -0>       // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 80, -30>
}

light_source {
  <100, 100, -1000>       // light's position (translated below)
  color rgb <1, 1, 1>*1.5  // light's color
  translate <-30, 30, -30>
} 

/*light_source {
  <-30, 30, -100>       // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
}*/

light_source {
 <150,20,-30>
 color rgb <1, 1, 1>*0.3  // light's color
}                                         

box{<149,20.1,-29>,<151,20.2,-31> pigment{Black}}
// #############################################################
// #############################################################
// #############################################################

#declare OBELISK = object{
 union{
  difference{
   prism{
    conic_sweep
    linear_spline
    0, 1, 5,
    <-2,-2>,<2,-2>,<2,2>,<-2,2>,<-2,-2>
    rotate <180,0,0>
    translate <0,1,0>
    scale <1,100,1>
   }
   box {<-2,50,-2>,<2,105,2>}
  } 
  prism{
   conic_sweep
   linear_spline
   0,1,5,
   <-1,-1>,<1,-1>,<1,1>,<-1,1>,<0,0>
   rotate 180*x
   translate <0,51,0>
  }
 }
}

#declare OBELISK = object{
 union{
  difference{
   prism{
    conic_sweep
    linear_spline
    0, 1, 5,
    <-2,-2>,<2,-2>,<2,2>,<-2,2>,<-2,-2>
    rotate <180,0,0>
    translate <0,1,0>
    scale <1,100,1>
   }
   box {<-2,50,-2>,<2,105,2>}
  } 
  prism{
   conic_sweep
   linear_spline
   0,1,5,
   <-1,-1>,<1,-1>,<1,1>,<-1,1>,<0,0>
   rotate 180*x
   translate <0,51,0>
  }
  sphere{y*52,1 texture{T_Gold_4A}}
 }
}


#declare OBELISK2 = object{
difference{
 object{OBELISK texture{DRY_STONE_O}}
 union{
  text{ 
   ttf "KINGTUT1.TTF" "OU" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1.3,2,-2>
  }

  text{ 
   ttf "KINGTUT1.TTF" "N" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1,4,-2>
  }


  text{ 
   ttf "KINGTUT1.TTF" "&" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,5.5,-2>
  }
 
  text{ 
   ttf "KINGTUT1.TTF" "YM" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,7.3,-2>
  }

  text{ 
   ttf "KINGTUT1.TTF" "iD" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,9.3,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "+/$" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1.1,11.3,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "Ip" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1,13.3,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "Ow" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1.5,15.3,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "&h" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1.3,17.3,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "m" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,19.3,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "qa" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1,20.7,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "j" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,22.2,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "c/" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,24.2,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "N" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1.1,26.2,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "RS" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1.1,27.5,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "s" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1.1,28.5,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "n" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.6,29.5,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "u" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.6,31.5,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "zz?" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1,33.5,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "D" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,35.5,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "~" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-1,37.5,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "Y" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.6,39,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "M" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.6,45,-2>
  }
  
  text{ 
   ttf "KINGTUT1.TTF" "q" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.4,47,-2>
  }
    
  text{ 
   ttf "KINGTUT1.TTF" "e" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.8,40.5,-2>
  }
    
  text{ 
   ttf "KINGTUT1.TTF" "c" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.6,41.5,-2>
  }
    
  text{ 
   ttf "KINGTUT1.TTF" "b" 0.5,0 
   scale 2 
   pigment{Red} 
   translate <-0.9,43.5,-2>
  }

 }
}
}


#declare UPPER_ARCH_LEVEL3 = object{
 union{
  box{<-11.5,10.2,-0.15>,<11.5,10.5,0.15>} // 1.band
  box{<-11.5,10.5,-0.25>,<11.5,10.6,0.25>} 
  box{<-11.5,10.6,-0.15>,<11.5,10.7,0.15>} 
  box{<-11.5,10.7,-0.25>,<11.5,10.8,0.25>} 
  box{<-11.5,10.8,-0.35>,<11.5,11.2,0.35>}
  box{<-11.5,11.2+1,5>,<11.5,11.2+0.9,-0.375>} // 2.band 
  box{<-11.5,11.2+0.9,5>,<11.5,11.2+0.8,-0.25>}
  box{<-11.5,11.2+3,-1.125>,<11.5,11.2+3.125,1>} // 3. band
  box{<-11.5,11.2+3.125,-1.25>,<11.5,11.2+3.25,1>}
  box{<-11.5,11.2+3.25,-1.35>,<11.5,11.2+3.3,1>}
  box{<-11.5,11.2+3.3,-1.45>,<11.5,11.2+3.35,1>}
  box{<-11.5,11.2+3.35,-1.55>,<11.5,11.2+3.5,1>}
 }
}

#declare ARCH_LEVEL3 = object{
 union{
  difference{
   union{
    object{e_cylinder(<0,0,0>,    <0,0,20>,   6,0.3)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 6.3,0.3)}
    object{e_cylinder(<0,0,0>,    <0,0,20>,   6.4,0.1)}
    object{e_cylinder(<0,0,-0.2>, <0,0,20.2>, 6.7,0.3)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 6.8,0.1)}
    object{e_cylinder(<0,0,-0.2>, <0,0,20.2>, 6.9,0.1)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 7,0.1)}
    difference{
     box{<-11,0,0>,<11,11.5,20>}
     cylinder{<0,0,-1>,<0,0,21>,7}
    }
   }
   box{<-15,0,-5>,<15,-15,25>}
  }
 }
}

#macro HALF_RECT(side,length)
 difference{
  box{<-side/2,-side/2,0>,<side/2,side/2,length> rotate z*45 }
  box{<-side/sqrt(2)*1.01, 0 -0.01>,<side/sqrt(2)*1.01,-side/sqrt(2)*1.01,1.01*length> 
   translate <0,0,-0.05*length>}
 }
#end

#macro HALF_RECT_SHELL(side,length,thick)
 difference{
  object{HALF_RECT(side,length)}
  object{HALF_RECT(side-thick*sqrt(2),1.1*length) translate <0,-0.001,-0.05*length>}
 }
#end

#declare GUARDIAN_ANGEL = object{
 union{
  object{STATUE(0,-90,-90,90,0) translate<0,3,0> texture{DRY_STONE}}
  cylinder{<-1.7,-8,-2>,<-1.7,8,-2>,0.125 texture{T_Gold_1B}}
  cone{<-1.7,8,-2>,0.2,<-1.7,9,-2>,0.3 texture{T_Gold_1B}}
  cone{<-1.7,9,-2>,0.3,<-1.7,11,-2>,0.1 texture{T_Gold_1B}}
  sphere{<1.9,0,-1>,3 scale<0.1,1,1> texture{CLEAN_STONE}}
 }
}

#declare RECT_ROOF = object{
 union{
  object{HALF_RECT_SHELL(sqrt(2)*35/2,36,1)}
  object{HALF_RECT_SHELL(sqrt(2)*34/2,37,0.5) translate<0,0,-0.5>}
  object{HALF_RECT_SHELL(sqrt(2)*33.5/2,36,1)}
  object{HALF_RECT(sqrt(2)*32.5/2,35) translate <0,0,0.5>}
 }
 texture{CLEAN_STONE}
}

#declare RECT_LEVEL3 = object{
 union{
  object{RECT_PILLAR rotate y*90 translate <0.2,4,5> translate<13.2,0,-1>}
  object{RECT_PILLAR rotate y*90 translate <4.8,4,5> translate<-13.2,0,-1>}
  object{RECT_PILLAR rotate y*90 translate <-0.3,4,6> translate<13.2,0,-1>}
  object{RECT_PILLAR rotate y*90 translate <5.3,4,6> translate<-13.2,0,-1>}
  object{RECT_PILLAR rotate y*90 translate <0.7,4,4> translate<13.2,0,-1>}
  object{RECT_PILLAR rotate y*90 translate <4.3,4,4> translate<-13.2,0,-1>}
 }
}

#declare LEVEL_3 = object{
 union{
  object{ARCH_LEVEL3 translate <40.5,36.7,6> texture{CLEAN_STONE}}
  object{RECT_LEVEL3 translate <38,32.7,1> texture{DRY_STONE}}
  object{RECT_ROOF scale<1,0.5,1> translate <128,36.7,-10>}
  object{GUARDIAN_ANGEL scale 0.45 translate<54,43.5,3>}
  object{GUARDIAN_ANGEL scale 0.45 translate<81,43.5,3>}
  object{GUARDIAN_ANGEL scale 0.45 translate<108,43.5,3> }
 }
}

// #############################################################
// #############################################################
// #############################################################

object{LEVEL_1} 
object{LEVEL_2}
object{LEVEL_3} 
object{OBELISK2 rotate y*90 translate <165,20,-20> texture{DRY_STONE}}

// *******************************************************************************
// ********************************* WATER ***************************************
// *******************************************************************************

#declare WATER = 1;


#if (WATER)
isosurface {
	function { y+f_noise3d(x, 0, z) }
	threshold 0
	accuracy 0.00001
	contained_by {box{<-200,5,80>,<400,-20,-300>}}
	max_gradient 2
	open
	texture {
		pigment {color DarkGreen}
		finish {
		  diffuse 0.1 
		  ambient 0.1 
		  specular 0.0 
		  reflection <0.6,0.6,0.65>
		}
	}
	scale <1,0.05,1>
	translate y*2.4
	
}                
#end