//  Persistence of Vision Raytracer V3.1
//  World definition file.
/*  File created for the IRTC by Chris Painter
    Moray, mgrass, and tom tree used
    Hope you like this Dr. Mayfield, the code is just one big horribly miscommented nightmare!
*/
//


#include "mgrass.pov"
#include "grass.inc"
#include "IRTC.inc"

default {
 texture
      {      
         pigment
         {
            color rgb <0.4375, 0.604167, 0.479167>
         }      
         normal
         {
            wrinkles , .6
            turbulence 1.0
            omega 0.6
            frequency 2.0
            phase 1.0
            ramp_wave
            scale  0.4
         } 
         finish {
          specular 0.2
          diffuse 0.8
         } 
     } 
} 

global_settings {
  adc_bailout 0.003922
  ambient_light <.5,.5,.5>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }
camera {  //  Camera Main_Camera
  location  <    -65,      150,     3200>
  up        .75*y
  right     -x
  direction 2.3*z
  look_at   <     55,      60,    2501>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <   -171.546,     760.013,     435.780> // Attached to KEY
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.78826,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle        124.24703    // Vertical      93.185
  look_at   <   -171.222,     759.223,     435.260> // Following KEY
}

*/

/*
camera {  //  Camera SpotCam002
  location  <    213.419,     152.195,     395.259> // Attached to Fill
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    2.74951,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle        154.23702    // Vertical     115.678
  look_at   <    212.940,     151.895,     394.434> // Following Fill
}

*/

//
// *******  L I G H T S *******
//

#declare KEY = light_source {   // Spotlight KEY
  <435.780393, 760.012861, 171.545963>
  color rgb <0.6, 0.6, .99>*1.9
  spotlight
    point_at  <0.0, 0, .1>
    falloff    54.806  // outer radius (in deg)
    radius     32.012  // inner radius
    tightness  0.000 
}
/*
#declare Fill = light_source {   // Spotlight Fill
  <0.0, 0.0, 0.0>
  color rgb <0.70, 0.70, .95>*.6
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    46.829  // outer radius (in deg)
    radius     24.032  // inner radius
    tightness  0.000
  rotate <14.429202, -220.938477, 58.88055>
  translate  <197.180378, 77.630679, -108.016772>
}
*/
#declare Fill = light_source {   // Spotlight Fill
  <0.0, 0.0, 0.0>
  color rgb <0.75, 0.75, .99>*.6
  
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    46.829  // outer radius (in deg)
    radius     13.776  // inner radius
    tightness  0.000
  rotate <39.818565, -201.780304, 69.696602>
  translate  <455.637227, 77.630679, -358.346047>
}

#declare Interior_fixture_light = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.9, 0.9, 0.75>*2
  media_interaction on
  media_attenuation on
  translate  <651.011246, -217, 12>
} 
/*
#declare Light002 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.843>*0.9999
  fade_distance  4.0
  fade_power 0.5
  translate  <60.677407, 38.028027, 9.423814>
}
*/
/*
#declare Light001 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.9999
  fade_distance  4.0
  fade_power 0.5
  scale 3.026099
  translate  <22.448557, 56.119017, -4.303219>
}
*/
#declare HgtFld002 = object { 
  height_field {
    sys /*unknown extension [BMP]*/ "C:\Documents and Settings\Joseph_Greg\Desktop\HFTEST.bmp"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    B1_Grass
  }
  scale <1000.0, 700.0, 150.0>
  rotate <90.0, -86.67408, -180.0>
  translate  <-2451.016931, 146.026801, -579.507898>
}
#declare RndCube006 = merge {
  sphere { <0.4900, 0.4900, 0.4900>, 0.0100 }
  sphere { <0.4900, -0.4900, 0.4900>, 0.0100 }
  sphere { <-0.4900, -0.4900, 0.4900>, 0.0100 }
  sphere { <-0.4900, 0.4900, 0.4900>, 0.0100 }
  sphere { <0.4900, 0.4900, -0.4900>, 0.0100 }
  sphere { <0.4900, -0.4900, -0.4900>, 0.0100 }
  sphere { <-0.4900, -0.4900, -0.4900>, 0.0100 }
  sphere { <-0.4900, 0.4900, -0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, 0.4900>, <-0.4900, 0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, -0.4900, 0.4900>, <-0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, -0.4900, -0.4900>, <-0.4900, -0.4900, -0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, -0.4900>, <-0.4900, 0.4900, -0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, -0.4900>, <0.4900, 0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, -0.4900, -0.4900>, <0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <-0.4900, -0.4900, -0.4900>, <-0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <-0.4900, 0.4900, -0.4900>, <-0.4900, 0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, 0.4900>, <0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, -0.4900>, <0.4900, -0.4900, -0.4900>, 0.0100 }
  cylinder { <-0.4900, 0.4900, -0.4900>, <-0.4900, -0.4900, -0.4900>, 0.0100 }
  cylinder { <-0.4900, 0.4900, 0.4900>, <-0.4900, -0.4900, 0.4900>, 0.0100 }
  box { <-0.4900, -0.4900, -0.5000> <0.4900, 0.4900, 0.5000> }
  box { <-0.4900, -0.5000, -0.4900> <0.4900, 0.5000, 0.4900> }
  box { <-0.5000, -0.4900, -0.4900> <0.5000, 0.4900, 0.4900> }
  scale <1.804714, 1.317174, 0.024253>
  translate  <-16.948995, -14.98305, 12.38145>
}
#declare RndCube007 = merge {
  sphere { <0.4900, 0.4900, 0.4900>, 0.0100 }
  sphere { <0.4900, -0.4900, 0.4900>, 0.0100 }
  sphere { <-0.4900, -0.4900, 0.4900>, 0.0100 }
  sphere { <-0.4900, 0.4900, 0.4900>, 0.0100 }
  sphere { <0.4900, 0.4900, -0.4900>, 0.0100 }
  sphere { <0.4900, -0.4900, -0.4900>, 0.0100 }
  sphere { <-0.4900, -0.4900, -0.4900>, 0.0100 }
  sphere { <-0.4900, 0.4900, -0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, 0.4900>, <-0.4900, 0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, -0.4900, 0.4900>, <-0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, -0.4900, -0.4900>, <-0.4900, -0.4900, -0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, -0.4900>, <-0.4900, 0.4900, -0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, -0.4900>, <0.4900, 0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, -0.4900, -0.4900>, <0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <-0.4900, -0.4900, -0.4900>, <-0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <-0.4900, 0.4900, -0.4900>, <-0.4900, 0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, 0.4900>, <0.4900, -0.4900, 0.4900>, 0.0100 }
  cylinder { <0.4900, 0.4900, -0.4900>, <0.4900, -0.4900, -0.4900>, 0.0100 }
  cylinder { <-0.4900, 0.4900, -0.4900>, <-0.4900, -0.4900, -0.4900>, 0.0100 }
  cylinder { <-0.4900, 0.4900, 0.4900>, <-0.4900, -0.4900, 0.4900>, 0.0100 }
  box { <-0.4900, -0.4900, -0.5000> <0.4900, 0.4900, 0.5000> }
  box { <-0.4900, -0.5000, -0.4900> <0.4900, 0.5000, 0.4900> }
  box { <-0.5000, -0.4900, -0.4900> <0.5000, 0.4900, 0.4900> }
  material {
    Atari_woodgrain
  }
  scale <1.80111, 0.052965, 0.212714>
  rotate 180.0*x
  translate  <-16.948995, -15.633801, 12.325627>
}
#declare Topfrontparts = union {
  object { RndCube006 }
  object { RndCube007 }
}
#declare Front_pannels = difference {
  object { Topfrontparts }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    scale <0.059819, -0.764805, 0.163916>
    rotate <0.0, -142.898254, -180.0>
    translate  <-17.830666, -15.031187, 12.269904>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.059819, -0.764805, -0.163916>
    rotate 37.101746*y
    translate  <-16.066901, -15.031187, 12.269084>
  }
}
// Include contains 'TransSweep008'
#include "arc_prepov.in1"

#declare TransSweep008 = object {
  TransSweep008_Raw
  scale <0.258083, 0.5, 0.1975>
  rotate <-90.0, 0.0, -180.0>
  translate  <1.441192, -0.191712, 0.0>
  scale <3.311432, 431.015869, 1.0>
  rotate -180.0*x
  translate  <-22.701464, -346.205808, 13.445725>
}
// Include contains 'TransSweep006'
#include "arc_prepov.in2"

#declare TransSweep006 = object {
  TransSweep006_Raw
  scale <0.258083, 0.5, 0.1975>
  rotate <-90.0, 0.0, -180.0>
  translate  <1.441192, -0.191712, 0.0>
  scale <3.311432, 431.015869, 1.0>
  rotate <-180.0, 0.0, -180.0>
  translate  <-13.070218, -95.810531, 13.445725>
}
#declare Group005 = union {
  object { TransSweep008 }
  object { TransSweep006 }
  scale <1.0, 0.02, 1.0>
  translate  <1.747364, -10.513908, -0.744664>
}
// Include contains 'TransSweep005'
#include "arc_prepov.in3"

#declare TransSweep005 = object {
  TransSweep005_Raw
  scale <0.258083, 0.5, 0.1975>
  rotate <-90.0, 0.0, -180.0>
  translate  <1.441192, -0.191712, 0.0>
  scale <3.311432, 0.172406, 1.0>
  rotate 180.0*x
  translate  <-20.954008, -15.821213, 12.701188>
}
// Include contains 'TransSweep002'
#include "arc_prepov.in4"

#declare TransSweep002 = object {
  TransSweep002_Raw
  scale <0.258083, 0.5, 0.1975>
  rotate <-90.0, 0.0, -180.0>
  translate  <1.441192, -0.191712, 0.0>
  scale <3.311432, 0.172406, 1.0>
  rotate <180.0, 0.0, 180.0>
  translate  <-11.322972, -15.72102, 12.701177>
}
#declare Front_lower = union {
  object { TransSweep005 }
  object { TransSweep002 }
}
// Include contains 'TransSweep007'
#include "arc_prepov.in5"

#declare TransSweep007 = object {
  TransSweep007_Raw
  scale <0.258083, 0.5, 0.1975>
  rotate <-90.0, 0.0, -180.0>
  translate  <1.441192, -0.191712, 0.0>
  scale <3.311432, 0.172406, 1.0>
  rotate 180.0*x
  translate  <-20.954008, -15.821213, 12.701188>
}
// Include contains 'TransSweep003'
#include "arc_prepov.in6"

#declare TransSweep003 = object {
  TransSweep003_Raw
  scale <0.258083, 0.5, 0.1975>
  rotate <-90.0, 0.0, -180.0>
  translate  <1.441192, -0.191712, 0.0>
  scale <3.311432, 0.172406, 1.0>
  rotate <180.0, 0.0, 180.0>
  translate  <-11.322972, -15.72102, 12.701177>
}
#declare Back_lower1 = union {
  object { TransSweep007 }
  object { TransSweep003 }
  translate  1.681442*y
}
#declare Basehunks = union {
  object { Group005 }
  object { Front_lower }
  object { Back_lower1 }
  scale <0.85, 0.82, 1.0>
  translate  <-3.232718, -2.761228, 0.0>
}
#declare RndCube008 = merge {
  sphere { <4.6400, 0.8400, 0.0150>, 0.0100 }
  sphere { <4.6400, -0.8400, 0.0150>, 0.0100 }
  sphere { <-4.6400, -0.8400, 0.0150>, 0.0100 }
  sphere { <-4.6400, 0.8400, 0.0150>, 0.0100 }
  sphere { <4.6400, 0.8400, -0.0150>, 0.0100 }
  sphere { <4.6400, -0.8400, -0.0150>, 0.0100 }
  sphere { <-4.6400, -0.8400, -0.0150>, 0.0100 }
  sphere { <-4.6400, 0.8400, -0.0150>, 0.0100 }
  cylinder { <4.6400, 0.8400, 0.0150>, <-4.6400, 0.8400, 0.0150>, 0.0100 }
  cylinder { <4.6400, -0.8400, 0.0150>, <-4.6400, -0.8400, 0.0150>, 0.0100 }
  cylinder { <4.6400, -0.8400, -0.0150>, <-4.6400, -0.8400, -0.0150>, 0.0100 }
  cylinder { <4.6400, 0.8400, -0.0150>, <-4.6400, 0.8400, -0.0150>, 0.0100 }
  cylinder { <4.6400, 0.8400, -0.0150>, <4.6400, 0.8400, 0.0150>, 0.0100 }
  cylinder { <4.6400, -0.8400, -0.0150>, <4.6400, -0.8400, 0.0150>, 0.0100 }
  cylinder { <-4.6400, -0.8400, -0.0150>, <-4.6400, -0.8400, 0.0150>, 0.0100 }
  cylinder { <-4.6400, 0.8400, -0.0150>, <-4.6400, 0.8400, 0.0150>, 0.0100 }
  cylinder { <4.6400, 0.8400, 0.0150>, <4.6400, -0.8400, 0.0150>, 0.0100 }
  cylinder { <4.6400, 0.8400, -0.0150>, <4.6400, -0.8400, -0.0150>, 0.0100 }
  cylinder { <-4.6400, 0.8400, -0.0150>, <-4.6400, -0.8400, -0.0150>, 0.0100 }
  cylinder { <-4.6400, 0.8400, 0.0150>, <-4.6400, -0.8400, 0.0150>, 0.0100 }
  box { <-4.6400, -0.8400, -0.0250> <4.6400, 0.8400, 0.0250> }
  box { <-4.6400, -0.8500, -0.0150> <4.6400, 0.8500, 0.0150> }
  box { <-4.6500, -0.8400, -0.0150> <4.6500, 0.8400, 0.0150> }
  scale 0.189826
  rotate -136.699997*x
  translate  <-16.94889, -14.716711, 12.513333>
}
#declare RndCube018 = merge {
  sphere { <4.2415, 0.4940, 0.0400>, 0.0100 }
  sphere { <4.2415, -0.4940, 0.0400>, 0.0100 }
  sphere { <-4.2415, -0.4940, 0.0400>, 0.0100 }
  sphere { <-4.2415, 0.4940, 0.0400>, 0.0100 }
  sphere { <4.2415, 0.4940, -0.0400>, 0.0100 }
  sphere { <4.2415, -0.4940, -0.0400>, 0.0100 }
  sphere { <-4.2415, -0.4940, -0.0400>, 0.0100 }
  sphere { <-4.2415, 0.4940, -0.0400>, 0.0100 }
  cylinder { <4.2415, 0.4940, 0.0400>, <-4.2415, 0.4940, 0.0400>, 0.0100 }
  cylinder { <4.2415, -0.4940, 0.0400>, <-4.2415, -0.4940, 0.0400>, 0.0100 }
  cylinder { <4.2415, -0.4940, -0.0400>, <-4.2415, -0.4940, -0.0400>, 0.0100 }
  cylinder { <4.2415, 0.4940, -0.0400>, <-4.2415, 0.4940, -0.0400>, 0.0100 }
  cylinder { <4.2415, 0.4940, -0.0400>, <4.2415, 0.4940, 0.0400>, 0.0100 }
  cylinder { <4.2415, -0.4940, -0.0400>, <4.2415, -0.4940, 0.0400>, 0.0100 }
  cylinder { <-4.2415, -0.4940, -0.0400>, <-4.2415, -0.4940, 0.0400>, 0.0100 }
  cylinder { <-4.2415, 0.4940, -0.0400>, <-4.2415, 0.4940, 0.0400>, 0.0100 }
  cylinder { <4.2415, 0.4940, 0.0400>, <4.2415, -0.4940, 0.0400>, 0.0100 }
  cylinder { <4.2415, 0.4940, -0.0400>, <4.2415, -0.4940, -0.0400>, 0.0100 }
  cylinder { <-4.2415, 0.4940, -0.0400>, <-4.2415, -0.4940, -0.0400>, 0.0100 }
  cylinder { <-4.2415, 0.4940, 0.0400>, <-4.2415, -0.4940, 0.0400>, 0.0100 }
  box { <-4.2415, -0.4940, -0.0500> <4.2415, 0.4940, 0.0500> }
  box { <-4.2415, -0.5040, -0.0400> <4.2415, 0.5040, 0.0400> }
  box { <-4.2515, -0.4940, -0.0400> <4.2515, 0.4940, 0.0400> }
  scale 0.189826
  translate  <-16.948893, -14.508133, 12.617177>
}
// Include contains 'TransSweep011'
#include "arc_prepov.in7"

#declare TransSweep011 = object {
  TransSweep011_Raw
  scale 0.25
  rotate <110.0, 0.0, -90.0>
  translate  <-16.129102, -14.52719, 12.589868>
}
// Include contains 'TransSweep010'
#include "arc_prepov.in8"

#declare TransSweep010 = object {
  TransSweep010_Raw
  scale 0.25
  rotate <70.0, 0.0, -90.0>
  translate  <-17.698286, -14.527191, 12.564205>
}
#declare backplate_main1 = merge {
  sphere { <2.6250, 0.3525, 0.0050>, 0.0100 }
  sphere { <2.6250, -0.3525, 0.0050>, 0.0100 }
  sphere { <-2.6250, -0.3525, 0.0050>, 0.0100 }
  sphere { <-2.6250, 0.3525, 0.0050>, 0.0100 }
  sphere { <2.6250, 0.3525, -0.0050>, 0.0100 }
  sphere { <2.6250, -0.3525, -0.0050>, 0.0100 }
  sphere { <-2.6250, -0.3525, -0.0050>, 0.0100 }
  sphere { <-2.6250, 0.3525, -0.0050>, 0.0100 }
  cylinder { <2.6250, 0.3525, 0.0050>, <-2.6250, 0.3525, 0.0050>, 0.0100 }
  cylinder { <2.6250, -0.3525, 0.0050>, <-2.6250, -0.3525, 0.0050>, 0.0100 }
  cylinder { <2.6250, -0.3525, -0.0050>, <-2.6250, -0.3525, -0.0050>, 0.0100 }
  cylinder { <2.6250, 0.3525, -0.0050>, <-2.6250, 0.3525, -0.0050>, 0.0100 }
  cylinder { <2.6250, 0.3525, -0.0050>, <2.6250, 0.3525, 0.0050>, 0.0100 }
  cylinder { <2.6250, -0.3525, -0.0050>, <2.6250, -0.3525, 0.0050>, 0.0100 }
  cylinder { <-2.6250, -0.3525, -0.0050>, <-2.6250, -0.3525, 0.0050>, 0.0100 }
  cylinder { <-2.6250, 0.3525, -0.0050>, <-2.6250, 0.3525, 0.0050>, 0.0100 }
  cylinder { <2.6250, 0.3525, 0.0050>, <2.6250, -0.3525, 0.0050>, 0.0100 }
  cylinder { <2.6250, 0.3525, -0.0050>, <2.6250, -0.3525, -0.0050>, 0.0100 }
  cylinder { <-2.6250, 0.3525, -0.0050>, <-2.6250, -0.3525, -0.0050>, 0.0100 }
  cylinder { <-2.6250, 0.3525, 0.0050>, <-2.6250, -0.3525, 0.0050>, 0.0100 }
  box { <-2.6250, -0.3525, -0.0150> <2.6250, 0.3525, 0.0150> }
  box { <-2.6250, -0.3625, -0.0050> <2.6250, 0.3625, 0.0050> }
  box { <-2.6350, -0.3525, -0.0050> <2.6350, 0.3525, 0.0050> }
  translate  <-11.979092, 0.446254, 0.745898>
}
#declare RndCube046 = merge {
  sphere { <0.1800, 0.0825, 0.0900>, 0.0100 }
  sphere { <0.1800, -0.0825, 0.0900>, 0.0100 }
  sphere { <-0.1800, -0.0825, 0.0900>, 0.0100 }
  sphere { <-0.1800, 0.0825, 0.0900>, 0.0100 }
  sphere { <0.1800, 0.0825, -0.0900>, 0.0100 }
  sphere { <0.1800, -0.0825, -0.0900>, 0.0100 }
  sphere { <-0.1800, -0.0825, -0.0900>, 0.0100 }
  sphere { <-0.1800, 0.0825, -0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, 0.0900>, <-0.1800, 0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, -0.0825, 0.0900>, <-0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, -0.0825, -0.0900>, <-0.1800, -0.0825, -0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, -0.0900>, <-0.1800, 0.0825, -0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, -0.0900>, <0.1800, 0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, -0.0825, -0.0900>, <0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <-0.1800, -0.0825, -0.0900>, <-0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <-0.1800, 0.0825, -0.0900>, <-0.1800, 0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, 0.0900>, <0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, -0.0900>, <0.1800, -0.0825, -0.0900>, 0.0100 }
  cylinder { <-0.1800, 0.0825, -0.0900>, <-0.1800, -0.0825, -0.0900>, 0.0100 }
  cylinder { <-0.1800, 0.0825, 0.0900>, <-0.1800, -0.0825, 0.0900>, 0.0100 }
  box { <-0.1800, -0.0825, -0.1000> <0.1800, 0.0825, 0.1000> }
  box { <-0.1800, -0.0925, -0.0900> <0.1800, 0.0925, 0.0900> }
  box { <-0.1900, -0.0825, -0.0900> <0.1900, 0.0825, 0.0900> }
  translate  <-10.678087, 0.207914, 0.730836>
}
#declare RndCube047 = merge {
  sphere { <0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  box { <-0.1600, -0.0650, -0.1000> <0.1600, 0.0650, 0.1000> }
  box { <-0.1600, -0.0750, -0.0900> <0.1600, 0.0750, 0.0900> }
  box { <-0.1700, -0.0650, -0.0900> <0.1700, 0.0650, 0.0900> }
  translate  <-11.574434, 0.207914, 0.730836>
}
#declare RndCube048 = merge {
  sphere { <0.1800, 0.0825, 0.0900>, 0.0100 }
  sphere { <0.1800, -0.0825, 0.0900>, 0.0100 }
  sphere { <-0.1800, -0.0825, 0.0900>, 0.0100 }
  sphere { <-0.1800, 0.0825, 0.0900>, 0.0100 }
  sphere { <0.1800, 0.0825, -0.0900>, 0.0100 }
  sphere { <0.1800, -0.0825, -0.0900>, 0.0100 }
  sphere { <-0.1800, -0.0825, -0.0900>, 0.0100 }
  sphere { <-0.1800, 0.0825, -0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, 0.0900>, <-0.1800, 0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, -0.0825, 0.0900>, <-0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, -0.0825, -0.0900>, <-0.1800, -0.0825, -0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, -0.0900>, <-0.1800, 0.0825, -0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, -0.0900>, <0.1800, 0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, -0.0825, -0.0900>, <0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <-0.1800, -0.0825, -0.0900>, <-0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <-0.1800, 0.0825, -0.0900>, <-0.1800, 0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, 0.0900>, <0.1800, -0.0825, 0.0900>, 0.0100 }
  cylinder { <0.1800, 0.0825, -0.0900>, <0.1800, -0.0825, -0.0900>, 0.0100 }
  cylinder { <-0.1800, 0.0825, -0.0900>, <-0.1800, -0.0825, -0.0900>, 0.0100 }
  cylinder { <-0.1800, 0.0825, 0.0900>, <-0.1800, -0.0825, 0.0900>, 0.0100 }
  box { <-0.1800, -0.0825, -0.1000> <0.1800, 0.0825, 0.1000> }
  box { <-0.1800, -0.0925, -0.0900> <0.1800, 0.0925, 0.0900> }
  box { <-0.1900, -0.0825, -0.0900> <0.1900, 0.0825, 0.0900> }
  translate  <-13.32844, 0.207914, 0.730836>
}
#declare RndCube049 = merge {
  sphere { <0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  box { <-0.1600, -0.0650, -0.1000> <0.1600, 0.0650, 0.1000> }
  box { <-0.1600, -0.0750, -0.0900> <0.1600, 0.0750, 0.0900> }
  box { <-0.1700, -0.0650, -0.0900> <0.1700, 0.0650, 0.0900> }
  translate  <-10.111315, 0.207914, 0.730836>
}
#declare RndCube050 = merge {
  sphere { <0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  box { <-0.1600, -0.0650, -0.1000> <0.1600, 0.0650, 0.1000> }
  box { <-0.1600, -0.0750, -0.0900> <0.1600, 0.0750, 0.0900> }
  box { <-0.1700, -0.0650, -0.0900> <0.1700, 0.0650, 0.0900> }
  translate  <-12.46706, 0.207914, 0.730836>
}
#declare RndCube051 = merge {
  sphere { <0.0650, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.0650, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.0650, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.0650, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.0650, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.0650, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.0650, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.0650, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, 0.0900>, <-0.0650, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, -0.0650, 0.0900>, <-0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, -0.0650, -0.0900>, <-0.0650, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, -0.0900>, <-0.0650, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, -0.0900>, <0.0650, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, -0.0650, -0.0900>, <0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.0650, -0.0650, -0.0900>, <-0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.0650, 0.0650, -0.0900>, <-0.0650, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, 0.0900>, <0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, -0.0900>, <0.0650, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.0650, 0.0650, -0.0900>, <-0.0650, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.0650, 0.0650, 0.0900>, <-0.0650, -0.0650, 0.0900>, 0.0100 }
  box { <-0.0650, -0.0650, -0.1000> <0.0650, 0.0650, 0.1000> }
  box { <-0.0650, -0.0750, -0.0900> <0.0650, 0.0750, 0.0900> }
  box { <-0.0750, -0.0650, -0.0900> <0.0750, 0.0650, 0.0900> }
  translate  <-12.012315, 0.207914, 0.730836>
}
#declare Backplate_top1 = difference {
  object { backplate_main1 }
  object { RndCube046 }
  object { RndCube047 }
  object { RndCube048 }
  object { RndCube049 }
  object { RndCube050 }
  object { RndCube051 }
}
#declare RndCube052 = merge {
  sphere { <0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  box { <-0.1600, -0.0650, -0.1000> <0.1600, 0.0650, 0.1000> }
  box { <-0.1600, -0.0750, -0.0900> <0.1600, 0.0750, 0.0900> }
  box { <-0.1700, -0.0650, -0.0900> <0.1700, 0.0650, 0.0900> }
  translate  <-14.129089, 0.207914, 0.49543>
}
#declare RndCube053 = merge {
  sphere { <0.0400, 0.0250, 0.1900>, 0.0100 }
  sphere { <0.0400, -0.0250, 0.1900>, 0.0100 }
  sphere { <-0.0400, -0.0250, 0.1900>, 0.0100 }
  sphere { <-0.0400, 0.0250, 0.1900>, 0.0100 }
  sphere { <0.0400, 0.0250, -0.1900>, 0.0100 }
  sphere { <0.0400, -0.0250, -0.1900>, 0.0100 }
  sphere { <-0.0400, -0.0250, -0.1900>, 0.0100 }
  sphere { <-0.0400, 0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, 0.1900>, <-0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, 0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, -0.1900>, <-0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <-0.0400, 0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, -0.1900>, <0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <-0.0400, -0.0250, -0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, -0.1900>, <-0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, 0.1900>, <0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, -0.1900>, <-0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, 0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  box { <-0.0400, -0.0250, -0.2000> <0.0400, 0.0250, 0.2000> }
  box { <-0.0400, -0.0350, -0.1900> <0.0400, 0.0350, 0.1900> }
  box { <-0.0500, -0.0250, -0.1900> <0.0500, 0.0250, 0.1900> }
  translate  <-14.054257, 0.207914, 0.616004>
}
#declare CSG013 = union {
  object { RndCube052 }
  object { RndCube053 }
}
#declare sw_4 = difference {
  object { CSG013 }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.007989, 0.212908, 0.832637>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.037203, 0.212908, 0.832637>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.063343, 0.212908, 0.832637>
  }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.086406, 0.212908, 0.832637>
  }
  translate  <4.012033, -0.0, -0.0>
}
#declare RndCube054 = merge {
  sphere { <0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  box { <-0.1600, -0.0650, -0.1000> <0.1600, 0.0650, 0.1000> }
  box { <-0.1600, -0.0750, -0.0900> <0.1600, 0.0750, 0.0900> }
  box { <-0.1700, -0.0650, -0.0900> <0.1700, 0.0650, 0.0900> }
  translate  <-14.118641, 0.207914, 0.49543>
}
#declare RndCube055 = merge {
  sphere { <0.0400, 0.0250, 0.1900>, 0.0100 }
  sphere { <0.0400, -0.0250, 0.1900>, 0.0100 }
  sphere { <-0.0400, -0.0250, 0.1900>, 0.0100 }
  sphere { <-0.0400, 0.0250, 0.1900>, 0.0100 }
  sphere { <0.0400, 0.0250, -0.1900>, 0.0100 }
  sphere { <0.0400, -0.0250, -0.1900>, 0.0100 }
  sphere { <-0.0400, -0.0250, -0.1900>, 0.0100 }
  sphere { <-0.0400, 0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, 0.1900>, <-0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, 0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, -0.1900>, <-0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <-0.0400, 0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, -0.1900>, <0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <-0.0400, -0.0250, -0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, -0.1900>, <-0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, 0.1900>, <0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, -0.1900>, <-0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, 0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  box { <-0.0400, -0.0250, -0.2000> <0.0400, 0.0250, 0.2000> }
  box { <-0.0400, -0.0350, -0.1900> <0.0400, 0.0350, 0.1900> }
  box { <-0.0500, -0.0250, -0.1900> <0.0500, 0.0250, 0.1900> }
  translate  <-14.054257, 0.207914, 0.616004>
}
#declare CSG014 = union {
  object { RndCube054 }
  object { RndCube055 }
}
#declare sw_5 = difference {
  object { CSG014 }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.014621, 0.212908, 0.832637>
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.041624, 0.212908, 0.832637>
  }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.067764, 0.212908, 0.832637>
  }
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.090827, 0.212908, 0.832637>
  }
  translate  <1.649562, -0.002343, -0.0>
}
#declare RndCube056 = merge {
  sphere { <0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.1600, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, -0.0650, -0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, -0.0650, -0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, 0.0900>, <0.1600, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.1600, 0.0650, -0.0900>, <0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, -0.0900>, <-0.1600, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.1600, 0.0650, 0.0900>, <-0.1600, -0.0650, 0.0900>, 0.0100 }
  box { <-0.1600, -0.0650, -0.1000> <0.1600, 0.0650, 0.1000> }
  box { <-0.1600, -0.0750, -0.0900> <0.1600, 0.0750, 0.0900> }
  box { <-0.1700, -0.0650, -0.0900> <0.1700, 0.0650, 0.0900> }
  translate  <-14.129089, 0.207914, 0.49543>
}
#declare RndCube057 = merge {
  sphere { <0.0400, 0.0250, 0.1900>, 0.0100 }
  sphere { <0.0400, -0.0250, 0.1900>, 0.0100 }
  sphere { <-0.0400, -0.0250, 0.1900>, 0.0100 }
  sphere { <-0.0400, 0.0250, 0.1900>, 0.0100 }
  sphere { <0.0400, 0.0250, -0.1900>, 0.0100 }
  sphere { <0.0400, -0.0250, -0.1900>, 0.0100 }
  sphere { <-0.0400, -0.0250, -0.1900>, 0.0100 }
  sphere { <-0.0400, 0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, 0.1900>, <-0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, 0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, -0.1900>, <-0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <-0.0400, 0.0250, -0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, -0.0250, -0.1900>, <0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <-0.0400, -0.0250, -0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, -0.1900>, <-0.0400, 0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, 0.1900>, <0.0400, -0.0250, 0.1900>, 0.0100 }
  cylinder { <0.0400, 0.0250, -0.1900>, <0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, -0.1900>, <-0.0400, -0.0250, -0.1900>, 0.0100 }
  cylinder { <-0.0400, 0.0250, 0.1900>, <-0.0400, -0.0250, 0.1900>, 0.0100 }
  box { <-0.0400, -0.0250, -0.2000> <0.0400, 0.0250, 0.2000> }
  box { <-0.0400, -0.0350, -0.1900> <0.0400, 0.0350, 0.1900> }
  box { <-0.0500, -0.0250, -0.1900> <0.0500, 0.0250, 0.1900> }
  translate  <-14.054257, 0.207914, 0.616004>
}
#declare CSG015 = union {
  object { RndCube056 }
  object { RndCube057 }
}
#declare sw_6 = difference {
  object { CSG015 }
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.0102, 0.212908, 0.832637>
  }
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.041624, 0.212908, 0.832637>
  }
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.067764, 0.212908, 0.832637>
  }
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019898, 0.052653, 0.019898>
    rotate -45.0*y
    translate  <-14.093038, 0.212908, 0.832637>
  }
  translate  <2.544617, -0.009654, -0.0>
}
#declare RndDisc028 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0530, 0.0530, 0.4000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0370, 0.0370, 0.4080> translate -0.0040*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0550, 0.0550, 0.3960> translate 0.0020*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0350, 0.0350, 0.4080> translate --0.0020*z }
  }
  torus { 0.0530, 0.0020  rotate -x*90 translate  0.3980*z bounded_by { box { <-0.0550, -0.0550, 0.3960>, <0.0550, 0.0550, 0.4000> } } }
  torus { 0.0530, 0.0020  rotate -x*90 translate  0.0020*z bounded_by { box { <-0.0550, -0.0550, -0.0000>, <0.0550, 0.0550, 0.0040> } } }
  torus { 0.0370, 0.0020  rotate -x*90 translate  0.3980*z bounded_by { box { <-0.0390, -0.0390, 0.3960>, <0.0390, 0.0390, 0.4000> } } }
  torus { 0.0370, 0.0020  rotate -x*90 translate  0.0020*z bounded_by { box { <-0.0370, -0.0370, -0.0000>, <0.0370, 0.0370, 0.0020> } } }
  material {
    B1_shiny_Metal
  }
  translate  <-12.014316, 0.212079, 0.381949>
}
#declare RndCube058 = merge {
  sphere { <0.0650, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.0650, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.0650, -0.0650, 0.0900>, 0.0100 }
  sphere { <-0.0650, 0.0650, 0.0900>, 0.0100 }
  sphere { <0.0650, 0.0650, -0.0900>, 0.0100 }
  sphere { <0.0650, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.0650, -0.0650, -0.0900>, 0.0100 }
  sphere { <-0.0650, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, 0.0900>, <-0.0650, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, -0.0650, 0.0900>, <-0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, -0.0650, -0.0900>, <-0.0650, -0.0650, -0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, -0.0900>, <-0.0650, 0.0650, -0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, -0.0900>, <0.0650, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, -0.0650, -0.0900>, <0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.0650, -0.0650, -0.0900>, <-0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <-0.0650, 0.0650, -0.0900>, <-0.0650, 0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, 0.0900>, <0.0650, -0.0650, 0.0900>, 0.0100 }
  cylinder { <0.0650, 0.0650, -0.0900>, <0.0650, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.0650, 0.0650, -0.0900>, <-0.0650, -0.0650, -0.0900>, 0.0100 }
  cylinder { <-0.0650, 0.0650, 0.0900>, <-0.0650, -0.0650, 0.0900>, 0.0100 }
  box { <-0.0650, -0.0650, -0.1000> <0.0650, 0.0650, 0.1000> }
  box { <-0.0650, -0.0750, -0.0900> <0.0650, 0.0750, 0.0900> }
  box { <-0.0750, -0.0650, -0.0900> <0.0750, 0.0650, 0.0900> }
  translate  <-12.015981, 0.211177, 0.504499>
}
#declare CSG016 = union {
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.201062>
    rotate -90.0*y
    translate  <-60.905598, -73.983366, -8.943683>
  }
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.157126>
    rotate -90.0*y
    translate  <-60.905314, -73.983366, -9.147097>
  }
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate <0.0, -23.990986, 180.0>
    translate  <-60.6735, -73.982214, -9.073396>
  }
  cylinder { // Cord18
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.748521, -73.906425, -9.092421>
  }
  cylinder { // Cord19
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.706213, -73.906425, -8.997227>
  }
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate -23.990986*y
    translate  <-61.136733, -73.983366, -9.073396>
  }
  cylinder { // Cord20
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.061712, -74.059156, -9.092421>
  }
  cylinder { // Cord21
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.10402, -74.059156, -8.997227>
  }
}
#declare CSG017 = union {
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.201062>
    rotate -90.0*y
    translate  <-60.905598, -73.983366, -8.943683>
  }
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.157126>
    rotate -90.0*y
    translate  <-60.905314, -73.983366, -9.147097>
  }
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate <0.0, -23.990986, 180.0>
    translate  <-60.6735, -73.982214, -9.073396>
  }
  cylinder { // Cord22
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.748521, -73.906425, -9.092421>
  }
  cylinder { // Cord23
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.706213, -73.906425, -8.997227>
  }
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate -23.990986*y
    translate  <-61.136733, -73.983366, -9.073396>
  }
  cylinder { // Cord24
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.061712, -74.059156, -9.092421>
  }
  cylinder { // Cord25
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.10402, -74.059156, -8.997227>
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    scale <0.106607, 0.082812, 0.215897>
    rotate <180.0, -90.0, 0.0>
    translate  <-60.901732, -73.968924, -9.037142>
  }
  scale <0.95, 0.9, 0.9>
  translate  <-3.046022, -7.413367, -0.902077>
}
#declare CSG018 = difference {
  object { CSG016 }
  object { CSG017 }
}
#declare RndDisc029 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-60.903856, -73.907699, -8.990176>
}
#declare RndDisc030 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-60.771687, -73.907699, -8.990176>
}
#declare RndDisc031 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-60.650985, -73.907699, -8.990176>
}
#declare RndDisc032 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-61.040665, -73.907699, -8.990176>
}
#declare RndDisc033 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-61.164653, -73.907699, -8.990176>
}
#declare RndDisc034 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-61.098988, -73.907699, -9.113069>
}
#declare RndDisc035 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-60.969685, -73.907699, -9.113069>
}
#declare RndDisc036 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-60.707793, -73.907699, -9.113069>
}
#declare RndDisc037 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-60.83642, -73.907699, -9.113069>
}
#declare Pins2 = union {
  object { RndDisc029 }
  object { RndDisc030 }
  object { RndDisc031 }
  object { RndDisc032 }
  object { RndDisc033 }
  object { RndDisc034 }
  object { RndDisc035 }
  object { RndDisc036 }
  object { RndDisc037 }
  sphere { // Sphere075
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.707378, -74.041721, -9.112292>
  }
  sphere { // Sphere076
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.836169, -74.041721, -9.112292>
  }
  sphere { // Sphere077
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-61.098733, -74.041721, -9.112292>
  }
  sphere { // Sphere078
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.969942, -74.041721, -9.112292>
  }
  sphere { // Sphere079
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-61.164908, -74.041721, -8.989904>
  }
  sphere { // Sphere080
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.650453, -74.041721, -8.989904>
  }
  sphere { // Sphere081
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-61.040386, -74.041721, -8.989904>
  }
  sphere { // Sphere082
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.771418, -74.041721, -8.989904>
  }
  sphere { // Sphere083
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.903767, -74.041721, -8.989904>
  }
  material {
    B1_shiny_Metal
  }
  scale 0.8
  translate  <-12.176822, -14.745712, -1.799273>
}
#declare RndCube059 = merge {
  sphere { <0.1900, 0.0900, 0.0900>, 0.0100 }
  sphere { <0.1900, -0.0900, 0.0900>, 0.0100 }
  sphere { <-0.1900, -0.0900, 0.0900>, 0.0100 }
  sphere { <-0.1900, 0.0900, 0.0900>, 0.0100 }
  sphere { <0.1900, 0.0900, -0.0900>, 0.0100 }
  sphere { <0.1900, -0.0900, -0.0900>, 0.0100 }
  sphere { <-0.1900, -0.0900, -0.0900>, 0.0100 }
  sphere { <-0.1900, 0.0900, -0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, 0.0900>, <-0.1900, 0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, -0.0900, 0.0900>, <-0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, -0.0900, -0.0900>, <-0.1900, -0.0900, -0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, -0.0900>, <-0.1900, 0.0900, -0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, -0.0900>, <0.1900, 0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, -0.0900, -0.0900>, <0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <-0.1900, -0.0900, -0.0900>, <-0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <-0.1900, 0.0900, -0.0900>, <-0.1900, 0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, 0.0900>, <0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, -0.0900>, <0.1900, -0.0900, -0.0900>, 0.0100 }
  cylinder { <-0.1900, 0.0900, -0.0900>, <-0.1900, -0.0900, -0.0900>, 0.0100 }
  cylinder { <-0.1900, 0.0900, 0.0900>, <-0.1900, -0.0900, 0.0900>, 0.0100 }
  box { <-0.1900, -0.0900, -0.1000> <0.1900, 0.0900, 0.1000> }
  box { <-0.1900, -0.1000, -0.0900> <0.1900, 0.1000, 0.0900> }
  box { <-0.2000, -0.0900, -0.0900> <0.2000, 0.0900, 0.0900> }
  scale <1.5625, 1.5625, 1.25>
  rotate <-90.0, 0.0, -180.0>
  translate  <-60.901681, -73.760094, -9.048078>
}
#declare Port3 = merge {
  object { CSG018 }
  object { Pins2 }
  object { RndCube059 }
  material {
    B1_Black_Shiny_plastic_1_1
  }
  scale <0.64, 0.8, 0.64>
  rotate <-90.0, 0.0, 180.0>
  translate  <-49.659238, -5.582856, -58.446641>
}
#declare CSG019 = union {
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.201062>
    rotate -90.0*y
    translate  <-60.905598, -73.983366, -8.943683>
  }
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.157126>
    rotate -90.0*y
    translate  <-60.905314, -73.983366, -9.147097>
  }
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate <0.0, -23.990986, 180.0>
    translate  <-60.6735, -73.982214, -9.073396>
  }
  cylinder { // Cord26
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.748521, -73.906425, -9.092421>
  }
  cylinder { // Cord27
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.706213, -73.906425, -8.997227>
  }
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate -23.990986*y
    translate  <-61.136733, -73.983366, -9.073396>
  }
  cylinder { // Cord28
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.061712, -74.059156, -9.092421>
  }
  cylinder { // Cord29
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.10402, -74.059156, -8.997227>
  }
}
#declare CSG020 = union {
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.201062>
    rotate -90.0*y
    translate  <-60.905598, -73.983366, -8.943683>
  }
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    scale <0.033317, 0.074531, 0.157126>
    rotate -90.0*y
    translate  <-60.905314, -73.983366, -9.147097>
  }
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate <0.0, -23.990986, 180.0>
    translate  <-60.6735, -73.982214, -9.073396>
  }
  cylinder { // Cord30
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.748521, -73.906425, -9.092421>
  }
  cylinder { // Cord31
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate <-90.0, 0.0, 180.0>
    translate  <-60.706213, -73.906425, -8.997227>
  }
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023303, 0.074531, 0.0576>
    rotate -23.990986*y
    translate  <-61.136733, -73.983366, -9.073396>
  }
  cylinder { // Cord32
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.061712, -74.059156, -9.092421>
  }
  cylinder { // Cord33
    <0,0,1>, <0,0,0>, 1 
    scale <0.08701, 0.08701, 0.15>
    rotate -90.0*x
    translate  <-61.10402, -74.059156, -8.997227>
  }
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    scale <0.106607, 0.082812, 0.215897>
    rotate <180.0, -90.0, 0.0>
    translate  <-60.901732, -73.968924, -9.037142>
  }
  scale <0.95, 0.9, 0.9>
  translate  <-3.046022, -7.413367, -0.902077>
}
#declare CSG021 = difference {
  object { CSG019 }
  object { CSG020 }
}
#declare RndDisc038 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-60.903856, -73.907699, -8.990176>
}
#declare RndDisc039 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-60.771687, -73.907699, -8.990176>
}
#declare RndDisc040 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-60.650985, -73.907699, -8.990176>
}
#declare RndDisc041 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-61.040665, -73.907699, -8.990176>
}
#declare RndDisc042 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate -90.0*x
  translate  <-61.164653, -73.907699, -8.990176>
}
#declare RndDisc043 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-61.098988, -73.907699, -9.113069>
}
#declare RndDisc044 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-60.969685, -73.907699, -9.113069>
}
#declare RndDisc045 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-60.707793, -73.907699, -9.113069>
}
#declare RndDisc046 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 3.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 2.0000> translate 0.5000*z }
  torus { 0.5000, 0.5000  rotate -x*90 translate  2.5000*z bounded_by { box { <-1.0100, -1.0100, 1.9900>, <1.0100, 1.0100, 3.0100> } } }
  torus { 0.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-1.0100, -1.0100, -0.0100>, <1.0100, 1.0100, 1.0100> } } }
  scale <-0.04, -0.04, -0.057236>
  rotate <-90.0, -0.0, -0.0>
  translate  <-60.83642, -73.907699, -9.113069>
}
#declare Pins3 = union {
  object { RndDisc038 }
  object { RndDisc039 }
  object { RndDisc040 }
  object { RndDisc041 }
  object { RndDisc042 }
  object { RndDisc043 }
  object { RndDisc044 }
  object { RndDisc045 }
  object { RndDisc046 }
  sphere { // Sphere084
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.707378, -74.041721, -9.112292>
  }
  sphere { // Sphere085
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.836169, -74.041721, -9.112292>
  }
  sphere { // Sphere086
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-61.098733, -74.041721, -9.112292>
  }
  sphere { // Sphere087
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.969942, -74.041721, -9.112292>
  }
  sphere { // Sphere088
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-61.164908, -74.041721, -8.989904>
  }
  sphere { // Sphere089
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.650453, -74.041721, -8.989904>
  }
  sphere { // Sphere090
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-61.040386, -74.041721, -8.989904>
  }
  sphere { // Sphere091
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.771418, -74.041721, -8.989904>
  }
  sphere { // Sphere092
    <0,0,0>,1
    scale <-0.039545, -0.09792, -0.039545>
    rotate <0.0, 0.0, 180.0>
    translate  <-60.903767, -74.041721, -8.989904>
  }
  material {
    B1_shiny_Metal
  }
  scale 0.8
  translate  <-12.176822, -14.745712, -1.799273>
}
#declare RndCube060 = merge {
  sphere { <0.1900, 0.0900, 0.0900>, 0.0100 }
  sphere { <0.1900, -0.0900, 0.0900>, 0.0100 }
  sphere { <-0.1900, -0.0900, 0.0900>, 0.0100 }
  sphere { <-0.1900, 0.0900, 0.0900>, 0.0100 }
  sphere { <0.1900, 0.0900, -0.0900>, 0.0100 }
  sphere { <0.1900, -0.0900, -0.0900>, 0.0100 }
  sphere { <-0.1900, -0.0900, -0.0900>, 0.0100 }
  sphere { <-0.1900, 0.0900, -0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, 0.0900>, <-0.1900, 0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, -0.0900, 0.0900>, <-0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, -0.0900, -0.0900>, <-0.1900, -0.0900, -0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, -0.0900>, <-0.1900, 0.0900, -0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, -0.0900>, <0.1900, 0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, -0.0900, -0.0900>, <0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <-0.1900, -0.0900, -0.0900>, <-0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <-0.1900, 0.0900, -0.0900>, <-0.1900, 0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, 0.0900>, <0.1900, -0.0900, 0.0900>, 0.0100 }
  cylinder { <0.1900, 0.0900, -0.0900>, <0.1900, -0.0900, -0.0900>, 0.0100 }
  cylinder { <-0.1900, 0.0900, -0.0900>, <-0.1900, -0.0900, -0.0900>, 0.0100 }
  cylinder { <-0.1900, 0.0900, 0.0900>, <-0.1900, -0.0900, 0.0900>, 0.0100 }
  box { <-0.1900, -0.0900, -0.1000> <0.1900, 0.0900, 0.1000> }
  box { <-0.1900, -0.1000, -0.0900> <0.1900, 0.1000, 0.0900> }
  box { <-0.2000, -0.0900, -0.0900> <0.2000, 0.0900, 0.0900> }
  scale <1.5625, 1.5625, 1.25>
  rotate <-90.0, 0.0, -180.0>
  translate  <-60.901681, -73.760094, -9.048078>
}
#declare Port4 = merge {
  object { CSG021 }
  object { Pins3 }
  object { RndCube060 }
  material {
    B1_Black_Shiny_plastic_1_1
  }
  scale <0.64, 0.8, 0.64>
  rotate <-90.0, 0.0, 180.0>
  translate  <-52.30613, -5.582856, -58.446641>
}
#declare Backplate_total1 = union {
  object { Backplate_top1 }
  object { sw_4 }
  object { sw_5 }
  object { sw_6 }
  object { RndDisc028 }
  object { RndCube058 }
  object { Port3 }
  object { Port4 }
  scale 0.333333
  rotate <-69.689629, 0.0, 0.0>
  translate  <-12.955983, -14.659685, 12.565875>
}
#declare CSG022 = union {
  object { RndCube008 }
  object { RndCube018 }
  object { TransSweep011 }
  object { TransSweep010 }
  object { Backplate_total1 }
  rotate 80.699997*x
  translate  <0.118079, -10.456387, 16.654295>
}
#declare faceplate_part1 = union {
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <-0.165851, -0.169342, -0.232179>
    translate  <-2.891113, 8.029654, 5.803081>
  }
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    scale <2.142025, 0.326238, 0.114484>
    translate  <-5.083961, 8.208592, 5.687307>
  }
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.080494, -0.238612, -0.114484>
    rotate <-180.0, 0.0, -160.429855>
    translate  <-2.909062, 8.268402, 5.687307>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <-0.165851, -0.169342, -0.232179>
    translate  <-7.273534, 8.035091, 5.803081>
  }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.080494, -0.238612, -0.114484>
    rotate <-180.0, 0.0, -21.954607>
    translate  <-7.264297, 8.25209, 5.687307>
  }
  scale 0.333333
  rotate <43.0, 0.0, -0.0>
  translate  <-15.258472, -15.41926, 9.25878>
}
#declare Cuts = union {
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.138482, -0.316687, -0.054122>
    rotate <180.0, -70.0, -180.0>
    translate  <-16.050469, -14.568464, 12.532262>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.139229, -0.316687, -0.051112>
    rotate <180.0, 70.0, 180.0>
    translate  <-17.845784, -14.568464, 12.527761>
  }
  object { faceplate_part1 }
  rotate 80.699997*x
  translate  <0.118079, -10.456387, 16.654295>
}
#declare fback_plates = difference {
  object { CSG022 }
  object { Cuts }
  rotate -304.0*x
  translate  0.0*y
  rotate -136.699997*x
  translate  <-0.118079, -14.745594, -13.010343>
}
#declare HgtFld001 = object { 
  height_field {
    sys /*unknown extension [BMP]*/ "C:\Documents and Settings\Joseph_Greg\Desktop\New Folder\ridges.bmp"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <0.904089, 0.416716, 0.018672>
  translate  <-16.948723, -15.215803, 12.408066>
}
// Include contains 'TransSweep039'
#include "arc_prepov.in9"

#declare TransSweep039 = object {
  TransSweep039_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -100.0>
  translate  <-7.151415, 7.842987, 16.020474>
}
// Include contains 'TransSweep040'
#include "arc_prepov.i10"

#declare TransSweep040 = object {
  TransSweep040_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -100.0>
  translate  <-7.151415, 7.842987, 16.033299>
}
// Include contains 'TransSweep053'
#include "arc_prepov.i11"

#declare TransSweep053 = object {
  TransSweep053_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.020474>
}
// Include contains 'TransSweep054'
#include "arc_prepov.i12"

#declare TransSweep054 = object {
  TransSweep054_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.033299>
}
// Include contains 'TransSweep055'
#include "arc_prepov.i13"

#declare TransSweep055 = object {
  TransSweep055_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, 180.0>
  translate  <-7.254068, 7.914326, 16.020474>
}
// Include contains 'TransSweep056'
#include "arc_prepov.i14"

#declare TransSweep056 = object {
  TransSweep056_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, 180.0>
  translate  <-7.252915, 7.916632, 16.033299>
}
// Include contains 'TransSweep057'
#include "arc_prepov.i15"

#declare TransSweep057 = object {
  TransSweep057_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.020474>
}
// Include contains 'TransSweep058'
#include "arc_prepov.i16"

#declare TransSweep058 = object {
  TransSweep058_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.033299>
}
// Include contains 'TransSweep059'
#include "arc_prepov.i17"

#declare TransSweep059 = object {
  TransSweep059_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.020474>
}
// Include contains 'TransSweep060'
#include "arc_prepov.i18"

#declare TransSweep060 = object {
  TransSweep060_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.033299>
}
#declare Curve4 = union {
  object { TransSweep039 }
  object { TransSweep040 }
  object { TransSweep053 }
  object { TransSweep054 }
  object { TransSweep055 }
  object { TransSweep056 }
  object { TransSweep057 }
  object { TransSweep058 }
  object { TransSweep059 }
  object { TransSweep060 }
  translate  <-0.464673, 0.050734, 0.0>
}
// Include contains 'TransSweep061'
#include "arc_prepov.i19"

#declare TransSweep061 = object {
  TransSweep061_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.020474>
}
// Include contains 'TransSweep062'
#include "arc_prepov.i20"

#declare TransSweep062 = object {
  TransSweep062_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.033299>
}
// Include contains 'TransSweep063'
#include "arc_prepov.i21"

#declare TransSweep063 = object {
  TransSweep063_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.020474>
}
// Include contains 'TransSweep064'
#include "arc_prepov.i22"

#declare TransSweep064 = object {
  TransSweep064_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.033299>
}
// Include contains 'TransSweep065'
#include "arc_prepov.i23"

#declare TransSweep065 = object {
  TransSweep065_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.020474>
}
// Include contains 'TransSweep066'
#include "arc_prepov.i24"

#declare TransSweep066 = object {
  TransSweep066_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.033299>
}
#declare Curve5 = union {
  object { TransSweep061 }
  object { TransSweep062 }
  object { TransSweep063 }
  object { TransSweep064 }
  object { TransSweep065 }
  object { TransSweep066 }
  rotate -180.0*z
  translate  <-10.442987, 16.381818, 0.0>
}
// Include contains 'TransSweep067'
#include "arc_prepov.i25"

#declare TransSweep067 = object {
  TransSweep067_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.020474>
}
// Include contains 'TransSweep068'
#include "arc_prepov.i26"

#declare TransSweep068 = object {
  TransSweep068_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.033299>
}
// Include contains 'TransSweep069'
#include "arc_prepov.i27"

#declare TransSweep069 = object {
  TransSweep069_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.020474>
}
// Include contains 'TransSweep070'
#include "arc_prepov.i28"

#declare TransSweep070 = object {
  TransSweep070_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.033299>
}
// Include contains 'TransSweep071'
#include "arc_prepov.i29"

#declare TransSweep071 = object {
  TransSweep071_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.020474>
}
// Include contains 'TransSweep072'
#include "arc_prepov.i30"

#declare TransSweep072 = object {
  TransSweep072_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.033299>
}
#declare Curve6 = union {
  object { TransSweep067 }
  object { TransSweep068 }
  object { TransSweep069 }
  object { TransSweep070 }
  object { TransSweep071 }
  object { TransSweep072 }
  rotate -90.0*z
  translate  <-15.398116, 1.276996, 0.0>
}
// Include contains 'TransSweep073'
#include "arc_prepov.i31"

#declare TransSweep073 = object {
  TransSweep073_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -100.0>
  translate  <-7.151415, 7.842987, 16.020474>
}
// Include contains 'TransSweep074'
#include "arc_prepov.i32"

#declare TransSweep074 = object {
  TransSweep074_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -100.0>
  translate  <-7.151415, 7.842987, 16.033299>
}
// Include contains 'TransSweep075'
#include "arc_prepov.i33"

#declare TransSweep075 = object {
  TransSweep075_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.020474>
}
// Include contains 'TransSweep076'
#include "arc_prepov.i34"

#declare TransSweep076 = object {
  TransSweep076_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -120.0>
  translate  <-7.185342, 7.846176, 16.033299>
}
// Include contains 'TransSweep077'
#include "arc_prepov.i35"

#declare TransSweep077 = object {
  TransSweep077_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, 180.0>
  translate  <-7.254068, 7.914326, 16.020474>
}
// Include contains 'TransSweep078'
#include "arc_prepov.i36"

#declare TransSweep078 = object {
  TransSweep078_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, 180.0>
  translate  <-7.252915, 7.916632, 16.033299>
}
// Include contains 'TransSweep079'
#include "arc_prepov.i37"

#declare TransSweep079 = object {
  TransSweep079_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.020474>
}
// Include contains 'TransSweep080'
#include "arc_prepov.i38"

#declare TransSweep080 = object {
  TransSweep080_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -140.0>
  translate  <-7.215974, 7.861514, 16.033299>
}
// Include contains 'TransSweep081'
#include "arc_prepov.i39"

#declare TransSweep081 = object {
  TransSweep081_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.020474>
}
// Include contains 'TransSweep082'
#include "arc_prepov.i40"

#declare TransSweep082 = object {
  TransSweep082_Raw
  scale <1.0, 1.0, 0.01>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.239322, 7.886126, 16.033299>
}
#declare Curve7 = union {
  object { TransSweep073 }
  object { TransSweep074 }
  object { TransSweep075 }
  object { TransSweep076 }
  object { TransSweep077 }
  object { TransSweep078 }
  object { TransSweep079 }
  object { TransSweep080 }
  object { TransSweep081 }
  object { TransSweep082 }
  rotate 99.0*z
  translate  <3.601584, 16.30439, 0.0>
}
// Include contains 'TransSweep083'
#include "arc_prepov.i41"

#declare TransSweep083 = object {
  TransSweep083_Raw
  translate  <-5.099721, 8.463955, 2.076407>
}
// Include contains 'TransSweep084'
#include "arc_prepov.i42"

#declare TransSweep084 = object {
  TransSweep084_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  translate  <-5.099721, 8.45113, 2.076407>
}
#declare Group012 = union {
  object { TransSweep083 }
  object { TransSweep084 }
  scale <1.0, 1.0, 0.1>
  rotate <90.0, 0.0, -20.0>
  translate  <-2.714139, 6.931389, 7.569344>
}
// Include contains 'TransSweep085'
#include "arc_prepov.i43"

#declare TransSweep085 = object {
  TransSweep085_Raw
  translate  <-5.099721, 8.463955, 2.076407>
}
// Include contains 'TransSweep086'
#include "arc_prepov.i44"

#declare TransSweep086 = object {
  TransSweep086_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  translate  <-5.099721, 8.45113, 2.076407>
}
#declare Group013 = union {
  object { TransSweep085 }
  object { TransSweep086 }
  scale <1.0, 1.0, 0.1>
  rotate <90.0, 0.0, -160.0>
  translate  <-7.716013, 6.067335, 7.569344>
}
// Include contains 'TransSweep087'
#include "arc_prepov.i45"

#declare TransSweep087 = object {
  TransSweep087_Raw
  translate  <-5.099721, 8.463955, 2.076407>
}
// Include contains 'TransSweep088'
#include "arc_prepov.i46"

#declare TransSweep088 = object {
  TransSweep088_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  translate  <-5.099721, 8.45113, 2.076407>
}
#declare Group014 = union {
  object { TransSweep087 }
  object { TransSweep088 }
  scale <1.0, 1.0, 0.9>
  rotate <90.0, 0.0, -90.0>
  translate  <-1.255434, 2.794698, 7.569976>
}
// Include contains 'TransSweep089'
#include "arc_prepov.i47"

#declare TransSweep089 = object {
  TransSweep089_Raw
  translate  <-5.099721, 8.463955, 2.076407>
}
// Include contains 'TransSweep090'
#include "arc_prepov.i48"

#declare TransSweep090 = object {
  TransSweep090_Raw
  material {
    B1_Orange_Shiny_plastic_1
  }
  translate  <-5.099721, 8.45113, 2.076407>
}
#declare Group015 = union {
  object { TransSweep089 }
  object { TransSweep090 }
  scale <1.0, 1.0, 0.85>
  rotate <90.0, 0.0, -90.0>
  translate  <-1.467211, 3.459903, 7.569976>
}
#declare Orange_line_bar1 = union {
  object { Curve4 }
  object { Curve5 }
  object { Curve6 }
  object { Curve7 }
  object { Group012 }
  object { Group013 }
  object { Group014 }
  object { Group015 }
  material {
    B1_Black_Shiny_plastic_1_1
  }
  scale 0.333333
  rotate <43.182648, 0.0, 0.0>
  translate  <-15.161758, -13.058482, 6.747315>
}
#declare RndCube022 = merge {
  sphere { <0.4000, 0.4000, 4.9000>, 0.1000 }
  sphere { <0.4000, -0.4000, 4.9000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 4.9000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 4.9000>, 0.1000 }
  sphere { <0.4000, 0.4000, -4.9000>, 0.1000 }
  sphere { <0.4000, -0.4000, -4.9000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -4.9000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -4.9000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 4.9000>, <-0.4000, 0.4000, 4.9000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 4.9000>, <-0.4000, -0.4000, 4.9000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -4.9000>, <-0.4000, -0.4000, -4.9000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -4.9000>, <-0.4000, 0.4000, -4.9000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -4.9000>, <0.4000, 0.4000, 4.9000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -4.9000>, <0.4000, -0.4000, 4.9000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -4.9000>, <-0.4000, -0.4000, 4.9000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -4.9000>, <-0.4000, 0.4000, 4.9000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 4.9000>, <0.4000, -0.4000, 4.9000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -4.9000>, <0.4000, -0.4000, -4.9000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -4.9000>, <-0.4000, -0.4000, -4.9000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 4.9000>, <-0.4000, -0.4000, 4.9000>, 0.1000 }
  box { <-0.4000, -0.4000, -5.0000> <0.4000, 0.4000, 5.0000> }
  box { <-0.4000, -0.5000, -4.9000> <0.4000, 0.5000, 4.9000> }
  box { <-0.5000, -0.4000, -4.9000> <0.5000, 0.4000, 4.9000> }
  scale <1.424617, 1.063232, 0.014291>
  rotate -0.0*y
  translate  <-16.951545, -14.953577, 12.195117>
}
#declare faceplate_part3 = merge {
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale <-0.165851, -0.169342, -0.232179>
    translate  <-2.891113, 8.029654, 5.803081>
  }
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    scale <2.142025, 0.326238, 0.114484>
    translate  <-5.083961, 8.208592, 5.687307>
  }
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.080494, -0.238612, -0.114484>
    rotate <-180.0, 0.0, -160.429855>
    translate  <-2.909062, 8.268402, 5.687307>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <-0.165851, -0.169342, -0.232179>
    translate  <-7.273534, 8.035091, 5.803081>
  }
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.080494, -0.238612, -0.114484>
    rotate <-180.0, 0.0, -21.954607>
    translate  <-7.264297, 8.25209, 5.687307>
  }
  material {
    Panel_Text
    scale <4.825323, 0.765735, 1.0>
    translate <-7.488759, 7.790148, 5.848028>
  }
  scale <1.0, 1.0, 0.3>
  translate  <-0.15308, 0.0, 3.949457>
}
#declare RndCube019 = merge {
  sphere { <1.8000, 0.3000, 9.8000>, 0.2000 }
  sphere { <1.8000, -0.3000, 9.8000>, 0.2000 }
  sphere { <-1.8000, -0.3000, 9.8000>, 0.2000 }
  sphere { <-1.8000, 0.3000, 9.8000>, 0.2000 }
  sphere { <1.8000, 0.3000, -9.8000>, 0.2000 }
  sphere { <1.8000, -0.3000, -9.8000>, 0.2000 }
  sphere { <-1.8000, -0.3000, -9.8000>, 0.2000 }
  sphere { <-1.8000, 0.3000, -9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, 9.8000>, <-1.8000, 0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, 9.8000>, <-1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, -9.8000>, <-1.8000, -0.3000, -9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -9.8000>, <-1.8000, 0.3000, -9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -9.8000>, <1.8000, 0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, -9.8000>, <1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <-1.8000, -0.3000, -9.8000>, <-1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, -9.8000>, <-1.8000, 0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, 9.8000>, <1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -9.8000>, <1.8000, -0.3000, -9.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, -9.8000>, <-1.8000, -0.3000, -9.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, 9.8000>, <-1.8000, -0.3000, 9.8000>, 0.2000 }
  box { <-1.8000, -0.3000, -10.0000> <1.8000, 0.3000, 10.0000> }
  box { <-1.8000, -0.5000, -9.8000> <1.8000, 0.5000, 9.8000> }
  box { <-2.0000, -0.3000, -9.8000> <2.0000, 0.3000, 9.8000> }
  scale <-0.392823, -0.410309, -0.006841>
  rotate <-0.0, 0.0, -180.0>
  translate  <-5.233535, 8.147449, 5.655028>
}
#declare switchplate2 = difference {
  object { faceplate_part3 }
  cylinder { // Hole8
    <0,0,1>, <0,0,0>, 1 
    scale <-0.055943, -0.123103, -0.248041>
    translate  <-3.680925, 8.145111, 5.775733>
  }
  cylinder { // Hole9
    <0,0,1>, <0,0,0>, 1 
    scale <-0.055943, -0.123103, -0.248041>
    translate  <-4.129154, 8.145111, 5.775733>
  }
  cylinder { // Hole10
    <0,0,1>, <0,0,0>, 1 
    scale <-0.055943, -0.123103, -0.248041>
    translate  <-6.333751, 8.145111, 5.775733>
  }
  cylinder { // Hole11
    <0,0,1>, <0,0,0>, 1 
    scale <-0.055943, -0.123103, -0.248041>
    translate  <-6.780754, 8.145111, 5.775733>
  }
  object { RndCube019 }
  translate  0.156596*x
}
#declare RndCube061 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <-1.391625, -1.900565, -0.015197>
  rotate -180.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare RndCube062 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <1.013531, 1.611831, 0.023076>
  rotate -0.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare switch_detail8 = difference {
  object { RndCube061 }
  object { RndCube062 }
}
#declare RndDisc047 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 10.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 9.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  9.7000*z bounded_by { box { <-1.0060, -1.0060, 9.3940>, <1.0060, 1.0060, 10.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  material {
    B1_shiny_Metal
  }
  scale 0.043853
  translate  <-6.574136, 8.194425, 5.527319>
}
#declare Switch8 = union {
  object { switch_detail8 }
  object { RndDisc047 }
  cylinder { // pad8
    <0,0,1>, <0,0,0>, 1 
    scale <-0.1, -0.1, -0.035269>
    translate  <-6.572412, 8.189178, 5.579328>
  }
  translate  3.05*x
}
#declare RndCube063 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <-1.391625, -1.900565, -0.015197>
  rotate -180.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare RndCube064 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <1.013531, 1.611831, 0.023076>
  rotate -0.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare switch_detail9 = difference {
  object { RndCube063 }
  object { RndCube064 }
}
#declare RndDisc048 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 10.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 9.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  9.7000*z bounded_by { box { <-1.0060, -1.0060, 9.3940>, <1.0060, 1.0060, 10.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  material {
    B1_shiny_Metal
  }
  scale 0.043853
  translate  <-6.574136, 8.194425, 5.527319>
}
#declare Switch9 = union {
  object { switch_detail9 }
  object { RndDisc048 }
  cylinder { // pad9
    <0,0,1>, <0,0,0>, 1 
    scale <-0.1, -0.1, -0.035269>
    translate  <-6.572412, 8.189178, 5.579328>
  }
  translate  2.599854*x
}
#declare RndCube065 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <-1.391625, -1.900565, -0.015197>
  rotate -180.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare RndCube066 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <1.013531, 1.611831, 0.023076>
  rotate -0.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare switch_detail10 = difference {
  object { RndCube065 }
  object { RndCube066 }
}
#declare RndDisc049 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 10.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 9.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  9.7000*z bounded_by { box { <-1.0060, -1.0060, 9.3940>, <1.0060, 1.0060, 10.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  material {
    B1_shiny_Metal
  }
  scale 0.043853
  translate  <-6.574136, 8.194425, 5.527319>
}
#declare Switch10 = union {
  object { switch_detail10 }
  object { RndDisc049 }
  cylinder { // pad10
    <0,0,1>, <0,0,0>, 1 
    scale <-0.1, -0.1, -0.035269>
    translate  <-6.572412, 8.189178, 5.579328>
  }
  translate  0.395257*x
}
#declare RndCube067 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <-1.391625, -1.900565, -0.015197>
  rotate -180.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare RndCube068 = merge {
  sphere { <0.0000, 0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, 4.9500>, 0.0500 }
  sphere { <0.0000, 0.0500, -4.9500>, 0.0500 }
  sphere { <0.0000, -0.0500, -4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, 0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, -0.0500, -4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, 4.9500>, <0.0000, -0.0500, 4.9500>, 0.0500 }
  cylinder { <0.0000, 0.0500, -4.9500>, <0.0000, -0.0500, -4.9500>, 0.0500 }
  box { <-0.0500, -0.0500, -4.9500> <0.0500, 0.0500, 4.9500> }
  scale <1.013531, 1.611831, 0.023076>
  rotate -0.0*z
  translate  <-6.573041, 8.14804, 5.651816>
}
#declare switch_detail11 = difference {
  object { RndCube067 }
  object { RndCube068 }
}
#declare RndDisc050 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 10.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 9.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  9.7000*z bounded_by { box { <-1.0060, -1.0060, 9.3940>, <1.0060, 1.0060, 10.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  material {
    B1_shiny_Metal
  }
  scale 0.043853
  translate  <-6.574136, 8.194425, 5.527319>
}
#declare Switch11 = union {
  object { switch_detail11 }
  object { RndDisc050 }
  cylinder { // pad11
    <0,0,1>, <0,0,0>, 1 
    scale <-0.1, -0.1, -0.035269>
    translate  <-6.572412, 8.189178, 5.579328>
  }
  translate  -0.05*x
}
#declare RndCube069 = merge {
  sphere { <7.9000, 0.9000, 0.9000>, 0.1000 }
  sphere { <7.9000, -0.9000, 0.9000>, 0.1000 }
  sphere { <-7.9000, -0.9000, 0.9000>, 0.1000 }
  sphere { <-7.9000, 0.9000, 0.9000>, 0.1000 }
  sphere { <7.9000, 0.9000, -0.9000>, 0.1000 }
  sphere { <7.9000, -0.9000, -0.9000>, 0.1000 }
  sphere { <-7.9000, -0.9000, -0.9000>, 0.1000 }
  sphere { <-7.9000, 0.9000, -0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, 0.9000>, <-7.9000, 0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, -0.9000, 0.9000>, <-7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, -0.9000, -0.9000>, <-7.9000, -0.9000, -0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, -0.9000>, <-7.9000, 0.9000, -0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, -0.9000>, <7.9000, 0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, -0.9000, -0.9000>, <7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <-7.9000, -0.9000, -0.9000>, <-7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <-7.9000, 0.9000, -0.9000>, <-7.9000, 0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, 0.9000>, <7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, -0.9000>, <7.9000, -0.9000, -0.9000>, 0.1000 }
  cylinder { <-7.9000, 0.9000, -0.9000>, <-7.9000, -0.9000, -0.9000>, 0.1000 }
  cylinder { <-7.9000, 0.9000, 0.9000>, <-7.9000, -0.9000, 0.9000>, 0.1000 }
  box { <-7.9000, -0.9000, -1.0000> <7.9000, 0.9000, 1.0000> }
  box { <-7.9000, -1.0000, -0.9000> <7.9000, 1.0000, 0.9000> }
  box { <-8.0000, -0.9000, -0.9000> <8.0000, 0.9000, 0.9000> }
  scale <0.007993, 0.1, 0.1>
  rotate -45.0*x
  translate  <-12.434248, -0.850709, 1.100813>
}
#declare PPin2 = difference {
  object { RndCube069 }
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    scale <0.066255, 0.059814, 0.07657>
    translate  <-12.434742, -0.934919, 1.15982>
  }
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    scale <0.066255, 0.059814, 0.07657>
    translate  <-12.434742, -0.765844, 1.15982>
  }
  translate  <1.013215, 0.0, -0.054549>
}
#declare RndCube020 = merge {
  sphere { <7.9000, 0.9000, 0.9000>, 0.1000 }
  sphere { <7.9000, -0.9000, 0.9000>, 0.1000 }
  sphere { <-7.9000, -0.9000, 0.9000>, 0.1000 }
  sphere { <-7.9000, 0.9000, 0.9000>, 0.1000 }
  sphere { <7.9000, 0.9000, -0.9000>, 0.1000 }
  sphere { <7.9000, -0.9000, -0.9000>, 0.1000 }
  sphere { <-7.9000, -0.9000, -0.9000>, 0.1000 }
  sphere { <-7.9000, 0.9000, -0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, 0.9000>, <-7.9000, 0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, -0.9000, 0.9000>, <-7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, -0.9000, -0.9000>, <-7.9000, -0.9000, -0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, -0.9000>, <-7.9000, 0.9000, -0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, -0.9000>, <7.9000, 0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, -0.9000, -0.9000>, <7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <-7.9000, -0.9000, -0.9000>, <-7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <-7.9000, 0.9000, -0.9000>, <-7.9000, 0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, 0.9000>, <7.9000, -0.9000, 0.9000>, 0.1000 }
  cylinder { <7.9000, 0.9000, -0.9000>, <7.9000, -0.9000, -0.9000>, 0.1000 }
  cylinder { <-7.9000, 0.9000, -0.9000>, <-7.9000, -0.9000, -0.9000>, 0.1000 }
  cylinder { <-7.9000, 0.9000, 0.9000>, <-7.9000, -0.9000, 0.9000>, 0.1000 }
  box { <-7.9000, -0.9000, -1.0000> <7.9000, 0.9000, 1.0000> }
  box { <-7.9000, -1.0000, -0.9000> <7.9000, 1.0000, 0.9000> }
  box { <-8.0000, -0.9000, -0.9000> <8.0000, 0.9000, 0.9000> }
  scale <0.007993, 0.1, 0.1>
  rotate -45.0*x
  translate  <-12.434248, -0.850709, 1.100813>
}
#declare PPin3 = difference {
  object { RndCube020 }
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    scale <0.066255, 0.059814, 0.07657>
    translate  <-12.434742, -0.934919, 1.15982>
  }
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    scale <0.066255, 0.059814, 0.07657>
    translate  <-12.434742, -0.765844, 1.15982>
  }
}
#declare RndCube070 = merge {
  sphere { <3.3000, 0.6000, 0.5500>, 0.2000 }
  sphere { <3.3000, -0.6000, 0.5500>, 0.2000 }
  sphere { <-3.3000, -0.6000, 0.5500>, 0.2000 }
  sphere { <-3.3000, 0.6000, 0.5500>, 0.2000 }
  sphere { <3.3000, 0.6000, -0.5500>, 0.2000 }
  sphere { <3.3000, -0.6000, -0.5500>, 0.2000 }
  sphere { <-3.3000, -0.6000, -0.5500>, 0.2000 }
  sphere { <-3.3000, 0.6000, -0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, 0.5500>, <-3.3000, 0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, -0.6000, 0.5500>, <-3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, -0.6000, -0.5500>, <-3.3000, -0.6000, -0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, -0.5500>, <-3.3000, 0.6000, -0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, -0.5500>, <3.3000, 0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, -0.6000, -0.5500>, <3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <-3.3000, -0.6000, -0.5500>, <-3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <-3.3000, 0.6000, -0.5500>, <-3.3000, 0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, 0.5500>, <3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, -0.5500>, <3.3000, -0.6000, -0.5500>, 0.2000 }
  cylinder { <-3.3000, 0.6000, -0.5500>, <-3.3000, -0.6000, -0.5500>, 0.2000 }
  cylinder { <-3.3000, 0.6000, 0.5500>, <-3.3000, -0.6000, 0.5500>, 0.2000 }
  box { <-3.3000, -0.6000, -0.7500> <3.3000, 0.6000, 0.7500> }
  box { <-3.3000, -0.8000, -0.5500> <3.3000, 0.8000, 0.5500> }
  box { <-3.5000, -0.6000, -0.5500> <3.5000, 0.6000, 0.5500> }
  scale <0.204535, 0.17892, 0.168879>
  rotate 0.0*x
  translate  <-11.927757, -0.802588, 1.02413>
}
#declare Basesolids1 = merge {
  object { PPin2 }
  object { PPin3 }
  object { RndCube070 }
}
#declare RndCube071 = merge {
  sphere { <3.3000, 0.6000, 0.5500>, 0.2000 }
  sphere { <3.3000, -0.6000, 0.5500>, 0.2000 }
  sphere { <-3.3000, -0.6000, 0.5500>, 0.2000 }
  sphere { <-3.3000, 0.6000, 0.5500>, 0.2000 }
  sphere { <3.3000, 0.6000, -0.5500>, 0.2000 }
  sphere { <3.3000, -0.6000, -0.5500>, 0.2000 }
  sphere { <-3.3000, -0.6000, -0.5500>, 0.2000 }
  sphere { <-3.3000, 0.6000, -0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, 0.5500>, <-3.3000, 0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, -0.6000, 0.5500>, <-3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, -0.6000, -0.5500>, <-3.3000, -0.6000, -0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, -0.5500>, <-3.3000, 0.6000, -0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, -0.5500>, <3.3000, 0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, -0.6000, -0.5500>, <3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <-3.3000, -0.6000, -0.5500>, <-3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <-3.3000, 0.6000, -0.5500>, <-3.3000, 0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, 0.5500>, <3.3000, -0.6000, 0.5500>, 0.2000 }
  cylinder { <3.3000, 0.6000, -0.5500>, <3.3000, -0.6000, -0.5500>, 0.2000 }
  cylinder { <-3.3000, 0.6000, -0.5500>, <-3.3000, -0.6000, -0.5500>, 0.2000 }
  cylinder { <-3.3000, 0.6000, 0.5500>, <-3.3000, -0.6000, 0.5500>, 0.2000 }
  box { <-3.3000, -0.6000, -0.7500> <3.3000, 0.6000, 0.7500> }
  box { <-3.3000, -0.8000, -0.5500> <3.3000, 0.8000, 0.5500> }
  box { <-3.5000, -0.6000, -0.5500> <3.5000, 0.6000, 0.5500> }
  scale <0.196177, 0.147081, 0.128511>
  rotate 0.0*x
  translate  <-11.927757, -0.802588, 1.02413>
}
#declare Port5 = difference {
  object { Basesolids1 }
  object { RndCube071 }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    scale <0.390494, 0.024775, 0.07657>
    translate  <-11.927692, -0.850381, 1.096879>
  }
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    scale <0.083602, 0.024775, 0.024092>
    translate  <-12.582639, -0.850381, 1.14532>
  }
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    scale <0.063475, 0.024775, 0.07657>
    translate  <-11.293468, -0.850381, 1.096879>
  }
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    scale <0.083602, 0.024775, 0.024092>
    translate  <-11.273552, -0.850381, 1.14532>
  }
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    scale <0.747353, 0.024775, 0.010312>
    translate  <-11.928644, -0.840296, 1.096879>
  }
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    scale <0.063475, 0.024775, 0.07657>
    translate  <-12.561844, -0.850381, 1.096879>
  }
}
#declare RndCube072 = merge {
  sphere { <1.8000, 0.3000, 9.8000>, 0.2000 }
  sphere { <1.8000, -0.3000, 9.8000>, 0.2000 }
  sphere { <-1.8000, -0.3000, 9.8000>, 0.2000 }
  sphere { <-1.8000, 0.3000, 9.8000>, 0.2000 }
  sphere { <1.8000, 0.3000, -9.8000>, 0.2000 }
  sphere { <1.8000, -0.3000, -9.8000>, 0.2000 }
  sphere { <-1.8000, -0.3000, -9.8000>, 0.2000 }
  sphere { <-1.8000, 0.3000, -9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, 9.8000>, <-1.8000, 0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, 9.8000>, <-1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, -9.8000>, <-1.8000, -0.3000, -9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -9.8000>, <-1.8000, 0.3000, -9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -9.8000>, <1.8000, 0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, -9.8000>, <1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <-1.8000, -0.3000, -9.8000>, <-1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, -9.8000>, <-1.8000, 0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, 9.8000>, <1.8000, -0.3000, 9.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -9.8000>, <1.8000, -0.3000, -9.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, -9.8000>, <-1.8000, -0.3000, -9.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, 9.8000>, <-1.8000, -0.3000, 9.8000>, 0.2000 }
  box { <-1.8000, -0.3000, -10.0000> <1.8000, 0.3000, 10.0000> }
  box { <-1.8000, -0.5000, -9.8000> <1.8000, 0.5000, 9.8000> }
  box { <-2.0000, -0.3000, -9.8000> <2.0000, 0.3000, 9.8000> }
  scale <-0.391681, -0.410309, -0.006841>
  rotate -180.0*z
  translate  <-11.927757, -0.791603, 1.152425>
}
#declare Cartrige_parts1 = merge {
  object { RndCube072 }
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    scale <0.829348, 0.229891, 0.098406>
    translate  <-11.925225, -0.79199, 1.024556>
  }
}
#declare RndCube073 = merge {
  sphere { <1.8000, 0.3000, 4.8000>, 0.2000 }
  sphere { <1.8000, -0.3000, 4.8000>, 0.2000 }
  sphere { <-1.8000, -0.3000, 4.8000>, 0.2000 }
  sphere { <-1.8000, 0.3000, 4.8000>, 0.2000 }
  sphere { <1.8000, 0.3000, -4.8000>, 0.2000 }
  sphere { <1.8000, -0.3000, -4.8000>, 0.2000 }
  sphere { <-1.8000, -0.3000, -4.8000>, 0.2000 }
  sphere { <-1.8000, 0.3000, -4.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, 4.8000>, <-1.8000, 0.3000, 4.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, 4.8000>, <-1.8000, -0.3000, 4.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, -4.8000>, <-1.8000, -0.3000, -4.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -4.8000>, <-1.8000, 0.3000, -4.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -4.8000>, <1.8000, 0.3000, 4.8000>, 0.2000 }
  cylinder { <1.8000, -0.3000, -4.8000>, <1.8000, -0.3000, 4.8000>, 0.2000 }
  cylinder { <-1.8000, -0.3000, -4.8000>, <-1.8000, -0.3000, 4.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, -4.8000>, <-1.8000, 0.3000, 4.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, 4.8000>, <1.8000, -0.3000, 4.8000>, 0.2000 }
  cylinder { <1.8000, 0.3000, -4.8000>, <1.8000, -0.3000, -4.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, -4.8000>, <-1.8000, -0.3000, -4.8000>, 0.2000 }
  cylinder { <-1.8000, 0.3000, 4.8000>, <-1.8000, -0.3000, 4.8000>, 0.2000 }
  box { <-1.8000, -0.3000, -5.0000> <1.8000, 0.3000, 5.0000> }
  box { <-1.8000, -0.5000, -4.8000> <1.8000, 0.5000, 4.8000> }
  box { <-2.0000, -0.3000, -4.8000> <2.0000, 0.3000, 4.8000> }
  scale <0.383376, 0.36941, 0.02831>
  rotate 0.0*x
  translate  <-11.927757, -0.791603, 1.094414>
}
#declare Cart_Port1 = difference {
  object { Cartrige_parts1 }
  object { RndCube073 }
  material {
    B1_Black_Shiny_plastic_1_1
  }
}
#declare Something_in_the_middle1 = merge {
  object { Port5 }
  object { Cart_Port1 }
  material {
    B1_Black_Shiny_plastic_1_1
  }
  translate  <6.850818, 8.939052, 4.502603>
}
#declare FacePlate2 = union {
  object { switchplate2 }
  object { Switch8 }
  object { Switch9 }
  object { Switch10 }
  object { Switch11 }
  object { Something_in_the_middle1 }
  material {
    B1_Black_Shiny_plastic_1_1
  }
  scale 0.333333
  rotate <43.0, 0.0, 0.0>
  translate  <-15.261088, -15.427218, 9.267493>
}
#declare TOPTEXT = union {
  text {   // TText012
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "A         B",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      B1_Black_Shiny_plastic_1_1
    }
    scale 0.051287
    translate  <0.406266, 0.131655, 0.946682>
  }

  text {   // TText011
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "A         B",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <-0.497804, 0.131655, 0.946682>
  }

  text {   // TText010
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "RIGHT",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <-1.321005, 0.217175, 0.946682>
  }

  text {   // TText009
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "CONTROLER",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <-1.410279, 0.146131, 0.946682>
  }

  text {   // TText008
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3 - 4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <1.915763, 0.141057, 0.946682>
  }

  text {   // TText007
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "CHANNEL",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <1.849793, 0.217175, 0.946682>
  }

  text {   // TText006
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "CONTROLER",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <1.240845, 0.146131, 0.946682>
  }

  text {   // TText005
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "LEFT",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <1.342336, 0.217175, 0.946682>
  }

  text {   // TText004
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "DIFFICULTY",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <-0.534456, 0.217175, 0.946682>
  }

  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "DIFFICULTY",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <0.35787, 0.217175, 0.946682>
  }

  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.086445
    translate  <0.338833, 0.167404, 0.922186>
  }

  text {   // TText013
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "POWER",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.051287
    translate  <-0.022524, 0.217175, 0.946682>
  }

  material {
    B1_Black_Shiny_plastic_1_1
  }
  scale 0.333333
  rotate <0.0, 0.0, 0.0>
  translate  <-16.983665, -14.530734, 12.297626>
}
#declare Front_logo = object { 
  height_field {
    sys /*unknown extension [BMP]*/ "C:\Documents and Settings\Joseph_Greg\Desktop\New Folder\A_logo.bmp"
    water_level 0.2738
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    B1_shiny_Metal
  }
  scale <0.059276, 0.060633, 0.004525>
  rotate 90.0*x
  translate  <-16.239566, -15.657412, 12.332005>
}
#declare Atari_2600 = union {
  object { Front_pannels }
  object { Basehunks }
  object { fback_plates }
  object { HgtFld001 }
  object { Orange_line_bar1 }
  object { RndCube022 }
  object { FacePlate2 }
  object { TOPTEXT }
  object { Front_logo }
  material {
    B1_Black_lumpy_plastic_1_1
  }
  scale 221.0
  rotate -170.0*z
  translate  <-2446.685676, -4430.795961, -2708.434846>
}
#declare Group007 = union {
  object { Atari_2600 }
  object { Interior_fixture_light }
  rotate <90.0, -71.589897, -180.0>
  translate  <475.409935, 27.176897, -530.519116>
}
#declare RndCube002 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <-4.084166, -3.899228, -26.821508>
  rotate <180.0, -0.0, -45.0>
  translate  <21.861479, 36.52475, -21.449869>
}
#declare RndCube003 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <-4.084166, -3.899228, -26.821508>
  rotate <180.0, -0.0, -45.0>
  translate  <22.177708, 73.523604, -21.449869>
}
#declare RndCube004 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <-4.084166, -3.899228, -26.821508>
  rotate <180.0, -0.0, -45.0>
  translate  <40.202791, 55.709341, -21.449869>
}
#declare RndCube001 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <-4.084166, -3.899228, -26.821508>
  rotate <180.0, -0.0, -45.0>
  translate  <3.836396, 55.603931, -21.449869>
}
#declare CSG003 = difference {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <17.27095, 16.92173, 6.095877>
    rotate -45.0*z
    translate  <21.5009, 54.492429, -32.477558>
  }
  material {
    B1invisble
  }
}
#declare Table_wf_legs_cut = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <24.348738, 24.348738, 1.11418>
    translate  <21.753176, 55.92016, -8.637839>
  }
  torus { // Torus001
    1.9, 0.1  rotate -x*90
    scale <12.859064, 12.859064, 5.01019>
    translate  <21.753176, 55.709341, -8.02355>
  }
  object { RndCube002 }
  object { RndCube003 }
  object { RndCube004 }
  object { RndCube001 }
  object { CSG003 }
  material {
    Streaky_Steel_Metal
  }
  rotate 23.982513*z
  translate  <19.147634, -32.478161, 0.0>
}
#declare CSG002 = difference {
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      B1BlackBase
    }
    scale <1.059398, 1.059398, 2.392487>
    rotate -180.0*z
    translate  <-0.085105, -2.330196, 24.22467>
  }
  sphere { // Sphere017
    <0,0,0>,1
    no_shadow
    scale 1.040441
    translate  <-0.072689, -2.332458, 24.713441>
  }
}
#declare Light_fixture = union {
  object { CSG002 }
  sphere { // Sphere018
    <0,0,0>,1
    material {
      B1_Glass2
    }
    no_shadow
    scale 1.040441
    translate  <-0.072689, -2.332458, 24.739986>
  }
  sphere { // Sphere070
    <0,0,0>,1
    material {
      White_globe
    }
    no_shadow
    scale 0.629691
    translate  <-0.091352, -2.340096, 25.125271>
  }
  material {
    B1BlackBase
  }
  translate  <-9.136481, 24.799019, 0.0>
}
#declare Back = union {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.314692, -2.622429, 0.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.339841, -0.163358, 0.0>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.419589, 4.510578, 0.0>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, 0.0, -180.0>
    translate  <4.307995, 0.944022, -0.680591>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.356433, 2.138358, 0.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, 0.0, -180.0>
    translate  <-2.212923, 0.944014, -0.66926>
  }
  material {
    T_Wood33
  }
  rotate <-0.076497, 86.291283, 179.95076>
  translate  <3.726585, 1.850934, 8.710232>
}
#declare Scraps = union {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, -1.985147, -180.0>
    translate  <4.287924, 0.944075, -0.820288>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <5.257231, 0.392854, 0.392854>
    rotate -90.0*z
    translate  <4.273378, 0.908471, -5.62285>
  }
  material {
    T_Wood33
  }
}
#declare Bolts = union {
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.11689, 6.539315, 4.379156>
  }
  sphere { // Sphere012
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.112912, -4.773505, 4.379156>
  }
  sphere { // Sphere011
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.270536, 7.503124, -5.623534>
  }
  sphere { // Sphere010
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.248733, -5.694876, -5.590109>
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.264697, -5.686111, -0.782004>
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.264697, 7.499788, -0.80647>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.126746, -5.692416, 4.379156>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.148846, 7.508877, 4.326462>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.546651, -5.680081, 10.850995>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.546651, 7.505146, 10.895196>
  }
  sphere { // Sphere015
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <-4.365125, 6.45188, -6.850925>
  }
  sphere { // Sphere014
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.115062, -4.631663, -6.828825>
  }
  sphere { // Sphere013
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.120891, 6.35685, -6.812387>
  }
  sphere { // Sphere016
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <-4.314693, -4.508971, -6.856587>
  }
  sphere { // Sphere009
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <-3.583977, -5.127488, -0.561001>
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <-3.615906, 7.069683, -0.536619>
  }
  material {
    Copper_Metal
  }
}
#declare Arms1 = union {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <-4.92413, -0.665105, -0.496253>
    rotate -180.0*x
    translate  <-0.108178, -4.443769, 5.508219>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <2.403059, 1.115701, 0.976638>
    translate  <-0.86747, -4.9525, 5.017141>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <-2.094056, -0.704396, -0.496102>
    rotate -180.0*x
    translate  <-2.938136, -5.375359, 5.508332>
  }
  material {
    T_Wood33
  }
  rotate <-0.074802, 0.0, -0.23095>
  translate  <0.206166, 11.056488, -1.125987>
}
#declare Arms2 = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <-4.92413, -0.665105, -0.496253>
    rotate -180.0*x
    translate  <-0.108178, -4.443769, 5.508219>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <2.403059, 1.115701, 0.976638>
    translate  <-0.86747, -4.9525, 5.017141>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <-2.094056, -0.704396, -0.496102>
    rotate -180.0*x
    translate  <-2.938136, -5.375359, 5.508332>
  }
  material {
    T_Wood33
  }
  rotate <180.0, 0.0, -0.23095>
  translate  <0.129494, -9.243839, 9.897646>
}
#declare Group003 = union {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <3.347849, 0.392854, 0.392854>
    translate  <1.716678, -4.591608, -6.871907>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <3.347849, 0.392854, 0.392854>
    translate  <1.692056, 6.319144, -6.857134>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.784044, 0.70071, 8.199678>
    translate  <-2.21539, -4.467108, -3.554711>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.829505, 0.70071, 7.996645>
    translate  <-2.212733, 6.328449, -3.688143>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <180.0, -1.985147, 180.0>
    translate  <-2.255476, 0.944075, -0.587288>
  }
  object { Arms1 }
  object { Arms2 }
  material {
    T_Wood33
  }
  translate  <-1.316815, 0.032118, 0.0>
}
#declare TaperSweep002 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.161057, 0.212571, 0.253481>
  rotate <-179.855026, 0.0, -0.0>
  translate  <1.106656, 5.815004, 2.747066>
}
#declare TaperSweep001 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.161057, 0.215286, 0.255781>
  rotate <-179.855026, 0.0, -0.0>
  translate  <1.106656, 3.418483, 2.733709>
}
#declare Legs = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.167839, 0.214069, 2.210595>
    translate  <1.107349, 5.816536, 0.287471>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.167839, 0.214069, 2.190489>
    translate  <1.107349, 3.418745, 0.289978>
  }
  object { TaperSweep002 }
  object { TaperSweep001 }
  material {
    T_Wood33
  }
  scale <4.671401, 4.671401, 5.811321>
  translate  <-0.839177, -20.664743, -0.702458>
}
#declare Seat = union {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.314692, -2.622429, 0.0>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.339841, -0.163358, 0.0>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.419589, 4.510578, 0.0>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.356433, 2.138358, 0.0>
  }
  material {
    T_Wood33
  }
  scale <1.192588, 1.0, 1.006675>
  rotate 1.985147*y
  translate  -0.835049*x
}
#declare Chair_1 = union {
  object { Back }
  object { Scraps }
  object { Bolts }
  object { Group003 }
  object { Legs }
  object { Seat }
  material {
    Copper_Metal
  }
  rotate 71.237999*z
  translate  <32.469106, 50.91326, -14.700991>
}
#declare Back1 = union {
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.314692, -2.622429, 0.0>
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.339841, -0.163358, 0.0>
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.419589, 4.510578, 0.0>
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, 0.0, -180.0>
    translate  <4.307995, 0.944022, -0.680591>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.356433, 2.138358, 0.0>
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, 0.0, -180.0>
    translate  <-2.212923, 0.944014, -0.66926>
  }
  material {
    T_Wood33
  }
  rotate <-0.076497, 86.291283, 179.95076>
  translate  <3.726585, 1.850934, 8.710232>
}
#declare Scraps1 = union {
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, -1.985147, -180.0>
    translate  <4.287924, 0.944075, -0.820288>
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    scale <5.257231, 0.392854, 0.392854>
    rotate -90.0*z
    translate  <4.273378, 0.908471, -5.62285>
  }
  material {
    T_Wood33
  }
}
#declare Bolts1 = union {
  sphere { // Sphere020
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.11689, 6.539315, 4.379156>
  }
  sphere { // Sphere021
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.112912, -4.773505, 4.379156>
  }
  sphere { // Sphere022
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.270536, 7.503124, -5.623534>
  }
  sphere { // Sphere023
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.248733, -5.694876, -5.590109>
  }
  sphere { // Sphere024
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.264697, -5.686111, -0.782004>
  }
  sphere { // Sphere025
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.264697, 7.499788, -0.80647>
  }
  sphere { // Sphere026
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.126746, -5.692416, 4.379156>
  }
  sphere { // Sphere027
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.148846, 7.508877, 4.326462>
  }
  sphere { // Sphere028
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.546651, -5.680081, 10.850995>
  }
  sphere { // Sphere029
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.546651, 7.505146, 10.895196>
  }
  sphere { // Sphere030
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <-4.365125, 6.45188, -6.850925>
  }
  sphere { // Sphere031
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.115062, -4.631663, -6.828825>
  }
  sphere { // Sphere032
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.120891, 6.35685, -6.812387>
  }
  sphere { // Sphere051
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <-4.314693, -4.508971, -6.856587>
  }
  sphere { // Sphere052
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <-3.583977, -5.127488, -0.561001>
  }
  sphere { // Sphere053
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <-3.615906, 7.069683, -0.536619>
  }
  material {
    Copper_Metal
  }
}
#declare Arms3 = union {
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    scale <-4.92413, -0.665105, -0.496253>
    rotate -180.0*x
    translate  <-0.108178, -4.443769, 5.508219>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <2.403059, 1.115701, 0.976638>
    translate  <-0.86747, -4.9525, 5.017141>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    scale <-2.094056, -0.704396, -0.496102>
    rotate -180.0*x
    translate  <-2.938136, -5.375359, 5.508332>
  }
  material {
    T_Wood33
  }
  rotate <-0.074802, 0.0, -0.23095>
  translate  <0.206166, 11.056488, -1.125987>
}
#declare Arms4 = union {
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    scale <-4.92413, -0.665105, -0.496253>
    rotate -180.0*x
    translate  <-0.108178, -4.443769, 5.508219>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <2.403059, 1.115701, 0.976638>
    translate  <-0.86747, -4.9525, 5.017141>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <-2.094056, -0.704396, -0.496102>
    rotate -180.0*x
    translate  <-2.938136, -5.375359, 5.508332>
  }
  material {
    T_Wood33
  }
  rotate <180.0, 0.0, -0.23095>
  translate  <0.129494, -9.243839, 9.897646>
}
#declare Group004 = union {
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    scale <3.347849, 0.392854, 0.392854>
    translate  <1.716678, -4.591608, -6.871907>
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <3.347849, 0.392854, 0.392854>
    translate  <1.692056, 6.319144, -6.857134>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.784044, 0.70071, 8.199678>
    translate  <-2.21539, -4.467108, -3.554711>
  }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    scale <0.829505, 0.70071, 7.996645>
    translate  <-2.212733, 6.328449, -3.688143>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <180.0, -1.985147, 180.0>
    translate  <-2.255476, 0.944075, -0.587288>
  }
  object { Arms3 }
  object { Arms4 }
  material {
    T_Wood33
  }
  translate  <-1.316815, 0.032118, 0.0>
}
#declare TaperSweep003 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.161057, 0.212571, 0.253481>
  rotate <-179.855026, 0.0, -0.0>
  translate  <1.106656, 5.815004, 2.747066>
}
#declare TaperSweep004 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.161057, 0.215286, 0.255781>
  rotate <-179.855026, 0.0, -0.0>
  translate  <1.106656, 3.418483, 2.733709>
}
#declare Legs1 = union {
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    scale <0.167839, 0.214069, 2.210595>
    translate  <1.107349, 5.816536, 0.287471>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    scale <0.167839, 0.214069, 2.190489>
    translate  <1.107349, 3.418745, 0.289978>
  }
  object { TaperSweep003 }
  object { TaperSweep004 }
  material {
    T_Wood33
  }
  scale <4.671401, 4.671401, 5.811321>
  translate  <-0.839177, -20.664743, -0.702458>
}
#declare Seat1 = union {
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.314692, -2.622429, 0.0>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.339841, -0.163358, 0.0>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.419589, 4.510578, 0.0>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.356433, 2.138358, 0.0>
  }
  material {
    T_Wood33
  }
  scale <1.192588, 1.0, 1.006675>
  rotate 1.985147*y
  translate  -0.835049*x
}
#declare Chair_2 = union {
  object { Back1 }
  object { Scraps1 }
  object { Bolts1 }
  object { Group004 }
  object { Legs1 }
  object { Seat1 }
  material {
    Copper_Metal
  }
  rotate 170.064316*z
  translate  <-8.198614, 39.915055, -14.700991>
}
#declare Back3 = union {
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.314692, -2.622429, 0.0>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.339841, -0.163358, 0.0>
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.419589, 4.510578, 0.0>
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, 0.0, -180.0>
    translate  <4.307995, 0.944022, -0.680591>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.356433, 2.138358, 0.0>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, 0.0, -180.0>
    translate  <-2.212923, 0.944014, -0.66926>
  }
  material {
    T_Wood33
  }
  rotate <-0.076497, 86.291283, 179.95076>
  translate  <3.726585, 1.850934, 8.710232>
}
#declare Scraps3 = union {
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <-180.0, -1.985147, -180.0>
    translate  <4.287924, 0.944075, -0.820288>
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    scale <5.257231, 0.392854, 0.392854>
    rotate -90.0*z
    translate  <4.273378, 0.908471, -5.62285>
  }
  material {
    T_Wood33
  }
}
#declare Bolts3 = union {
  sphere { // Sphere054
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.11689, 6.539315, 4.379156>
  }
  sphere { // Sphere055
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.112912, -4.773505, 4.379156>
  }
  sphere { // Sphere056
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.270536, 7.503124, -5.623534>
  }
  sphere { // Sphere057
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.248733, -5.694876, -5.590109>
  }
  sphere { // Sphere058
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.264697, -5.686111, -0.782004>
  }
  sphere { // Sphere059
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.264697, 7.499788, -0.80647>
  }
  sphere { // Sphere060
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.126746, -5.692416, 4.379156>
  }
  sphere { // Sphere061
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.148846, 7.508877, 4.326462>
  }
  sphere { // Sphere062
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.546651, -5.680081, 10.850995>
  }
  sphere { // Sphere063
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <4.546651, 7.505146, 10.895196>
  }
  sphere { // Sphere064
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <-4.365125, 6.45188, -6.850925>
  }
  sphere { // Sphere065
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.115062, -4.631663, -6.828825>
  }
  sphere { // Sphere066
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <5.120891, 6.35685, -6.812387>
  }
  sphere { // Sphere067
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    rotate -90.0*z
    translate  <-4.314693, -4.508971, -6.856587>
  }
  sphere { // Sphere068
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <-3.583977, -5.127488, -0.561001>
  }
  sphere { // Sphere069
    <0,0,0>,1
    scale <0.168176, 0.051952, 0.168176>
    translate  <-3.615906, 7.069683, -0.536619>
  }
  material {
    Copper_Metal
  }
}
#declare Arms7 = union {
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    scale <-4.92413, -0.665105, -0.496253>
    rotate -180.0*x
    translate  <-0.108178, -4.443769, 5.508219>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <2.403059, 1.115701, 0.976638>
    translate  <-0.86747, -4.9525, 5.017141>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    scale <-2.094056, -0.704396, -0.496102>
    rotate -180.0*x
    translate  <-2.938136, -5.375359, 5.508332>
  }
  material {
    T_Wood33
  }
  rotate <-0.074802, 0.0, -0.23095>
  translate  <0.206166, 11.056488, -1.125987>
}
#declare Arms8 = union {
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    scale <-4.92413, -0.665105, -0.496253>
    rotate -180.0*x
    translate  <-0.108178, -4.443769, 5.508219>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <2.403059, 1.115701, 0.976638>
    translate  <-0.86747, -4.9525, 5.017141>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    scale <-2.094056, -0.704396, -0.496102>
    rotate -180.0*x
    translate  <-2.938136, -5.375359, 5.508332>
  }
  material {
    T_Wood33
  }
  rotate <180.0, 0.0, -0.23095>
  translate  <0.129494, -9.243839, 9.897646>
}
#declare Group006 = union {
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <3.347849, 0.392854, 0.392854>
    translate  <1.716678, -4.591608, -6.871907>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <3.347849, 0.392854, 0.392854>
    translate  <1.692056, 6.319144, -6.857134>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.784044, 0.70071, 8.199678>
    translate  <-2.21539, -4.467108, -3.554711>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    scale <0.829505, 0.70071, 7.996645>
    translate  <-2.212733, 6.328449, -3.688143>
  }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.580411, -4.979139, -0.352132>
    rotate <180.0, -1.985147, 180.0>
    translate  <-2.255476, 0.944075, -0.587288>
  }
  object { Arms7 }
  object { Arms8 }
  material {
    T_Wood33
  }
  translate  <-1.316815, 0.032118, 0.0>
}
#declare TaperSweep007 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.161057, 0.212571, 0.253481>
  rotate <-179.855026, 0.0, -0.0>
  translate  <1.106656, 5.815004, 2.747066>
}
#declare TaperSweep008 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.161057, 0.215286, 0.255781>
  rotate <-179.855026, 0.0, -0.0>
  translate  <1.106656, 3.418483, 2.733709>
}
#declare Legs3 = union {
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    scale <0.167839, 0.214069, 2.210595>
    translate  <1.107349, 5.816536, 0.287471>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    scale <0.167839, 0.214069, 2.190489>
    translate  <1.107349, 3.418745, 0.289978>
  }
  object { TaperSweep007 }
  object { TaperSweep008 }
  material {
    T_Wood33
  }
  scale <4.671401, 4.671401, 5.811321>
  translate  <-0.839177, -20.664743, -0.702458>
}
#declare Seat3 = union {
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.314692, -2.622429, 0.0>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.339841, -0.163358, 0.0>
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.419589, 4.510578, 0.0>
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <4.979139, 0.725311, 0.300899>
    rotate <180.0, 0.0, 180.0>
    translate  <0.356433, 2.138358, 0.0>
  }
  material {
    T_Wood33
  }
  scale <1.192588, 1.0, 1.006675>
  rotate 1.985147*y
  translate  -0.835049*x
}
#declare Chair_4 = union {
  object { Back3 }
  object { Scraps3 }
  object { Bolts3 }
  object { Group006 }
  object { Legs3 }
  object { Seat3 }
  material {
    Copper_Metal
  }
  rotate <-0.0, 0.0, -94.387207>
  translate  <8.958501, 1.740631, -14.700991>
}
#declare Crystal_Ball = difference {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      B1BlackBase
    }
    scale <2.313075, 2.313075, 5.223724>
    rotate <180.0, 0.0, 180.0>
    translate  <22.440383, 56.123336, -2.262844>
  }
  sphere { // Sphere050
    <0,0,0>,1
    material {
      Crystal
    }
    scale 2.49845
    translate  <22.461212, 56.102406, -4.320274>
  }
  material {
    B1BlackBase
  }
}
#declare Crystal_Ball1 = union {
  object { Crystal_Ball }
  sphere { // Sphere033
    <0,0,0>,1
    material {
      Crystal
    }
    scale 2.49845
    translate  <22.461212, 56.102406, -4.320274>
  }
  translate  <-4.861581, -30.049854, 0.0>
}
#declare Room_interior = union {
  object { Table_wf_legs_cut }
  object { Light_fixture }
  object { Chair_1 }
  object { Chair_2 }
  object { Chair_4 }
  object { Crystal_Ball1 }
  translate  <192.864603, 4.894924, 1.873285>
}
#declare Window17 = difference {
  box { // Glass_Base144
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base145
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base146
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base147
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base148
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base149
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base150
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base151
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base152
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
}
#declare Window18 = difference {
  box { // Glass_Base153
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base154
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base155
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base156
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base157
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base158
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base159
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base160
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base161
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
  translate  -12.139144*y
}
#declare Window19 = difference {
  box { // Glass_Base162
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base163
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base164
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base165
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base166
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base167
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base168
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base169
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base170
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
  translate  -10.157885*z
}
#declare Window20 = difference {
  box { // Glass_Base171
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base172
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base173
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base174
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base175
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base176
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base177
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base178
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base179
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
  translate  <0.0, -12.170592, -10.157885>
}
#declare Beveled_Glass4 = union {
  object { Window17 }
  object { Window18 }
  object { Window19 }
  object { Window20 }
  material {
    T_Glass3
  }
}
#declare Curtainrod4 = union {
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale 0.15461
    rotate -90.0*x
    translate  <45.443546, 67.251269, 22.090093>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.201836, 0.080666, 0.157781>
    translate  <45.637273, 67.336007, 22.090652>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    scale <0.201836, 0.080666, 0.157781>
    rotate 0.0*z
    translate  <45.637273, 40.831325, 22.090652>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale 0.15461
    rotate <-90.0, 0.0, 0.0>
    translate  <45.443546, 40.746587, 22.090093>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    material {
      Bronze_Metal1
    }
    scale <0.0787, 0.0787, 14.354499>
    rotate <-90.0, 0.0, 0.0>
    translate  <45.438384, 40.700725, 22.089175>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    material {
      Bronze_Metal1
    }
    scale <0.044673, 0.044673, 14.351971>
    rotate <-90.0, 0.0, 0.0>
    translate  <45.439265, 53.125116, 22.089175>
  }
  material {
    B1_Lt_gray_wood_window
  }
  translate  <12.390624, 1.630192, -1.334405>
}
#declare Window_Frame4 = union {
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -10.834474, -0.499579>
    rotate <-90.0, 0.0, -180.0>
    translate  <59.158344, 68.27774, 9.160905>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -12.919562, -0.499579>
    rotate <-180.0, 0.0, -180.0>
    translate  <59.158344, 55.859659, 19.496063>
  }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -10.834474, -0.499579>
    rotate <-90.0, 0.0, -180.0>
    translate  <59.158344, 43.435491, 9.160905>
  }
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1White_Bleu_Agate
    }
    scale <-3.042685, -13.670194, -0.78455>
    rotate <-180.0, 0.0, -180.0>
    translate  <59.344043, 55.886387, -1.584667>
  }
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.654394, -12.178944, -0.257406>
    rotate 180.0*z
    translate  <59.158344, 55.935807, 9.110445>
  }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.654394, -10.834474, -0.257406>
    rotate <-90.0, 0.0, 180.0>
    translate  <59.158344, 55.861759, 9.002732>
  }
  material {
    B1_Lt_gray_wood_window
    translate <-0.086696, -0.047289, 0.000000>
  }
}
#declare Window21 = difference {
  box { // Glass_Base180
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base181
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base182
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base183
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base184
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base185
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base186
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base187
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base188
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
}
#declare Window22 = difference {
  box { // Glass_Base189
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base190
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base191
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base192
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base193
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base194
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base195
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base196
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base197
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
  translate  -12.139144*y
}
#declare Window23 = difference {
  box { // Glass_Base198
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base199
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base200
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base201
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base202
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base203
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base204
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base205
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base206
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
  translate  -10.157885*z
}
#declare Window24 = difference {
  box { // Glass_Base207
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.258805, -5.932878, -5.02255>
    rotate -180.0*z
    translate  <59.158344, 61.943127, 14.207849>
  }
  box { // Glass_Base208
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -10.0*z
    translate  <58.456982, 66.763259, 14.207849>
  }
  box { // Glass_Base209
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 10.0*z
    translate  <59.855686, 66.763259, 14.207849>
  }
  box { // Glass_Base210
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate 170.0*z
    translate  <59.859081, 57.120211, 14.211296>
  }
  box { // Glass_Base211
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.491308, -1.214556, -5.02255>
    rotate -170.0*z
    translate  <58.460377, 57.120211, 14.211296>
  }
  box { // Glass_Base212
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, -9.999993, -180.0>
    translate  <58.020373, 61.940749, 17.28263>
  }
  box { // Glass_Base213
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <180.0, 9.999993, -180.0>
    translate  <60.289211, 61.940749, 17.281623>
  }
  box { // Glass_Base214
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, -9.999993, 180.0>
    translate  <60.294701, 61.943127, 11.134901>
  }
  box { // Glass_Base215
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.776269, -5.932878, -2.119001>
    rotate <-0.0, 9.999993, 180.0>
    translate  <58.023597, 61.943127, 11.135656>
  }
  translate  <0.0, -12.170592, -10.157885>
}
#declare Beveled_Glass5 = union {
  object { Window21 }
  object { Window22 }
  object { Window23 }
  object { Window24 }
  material {
    T_Glass3
  }
}
#declare Curtainrod5 = union {
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale 0.15461
    rotate -90.0*x
    translate  <45.443546, 67.251269, 22.090093>
  }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    scale <0.201836, 0.080666, 0.157781>
    translate  <45.637273, 67.336007, 22.090652>
  }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    scale <0.201836, 0.080666, 0.157781>
    rotate 0.0*z
    translate  <45.637273, 40.831325, 22.090652>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale 0.15461
    rotate <-90.0, 0.0, 0.0>
    translate  <45.443546, 40.746587, 22.090093>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    material {
      Bronze_Metal1
    }
    scale <0.0787, 0.0787, 14.354499>
    rotate <-90.0, 0.0, 0.0>
    translate  <45.438384, 40.700725, 22.089175>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    material {
      Bronze_Metal1
    }
    scale <0.044673, 0.044673, 14.351971>
    rotate <-90.0, 0.0, 0.0>
    translate  <45.439265, 53.125116, 22.089175>
  }
  material {
    B1_Lt_gray_wood_window
  }
  translate  <12.390624, 1.630192, -1.334405>
}
#declare Window_Frame5 = union {
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -10.834474, -0.499579>
    rotate <-90.0, 0.0, -180.0>
    translate  <59.158344, 68.27774, 9.160905>
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -12.919562, -0.499579>
    rotate <-180.0, 0.0, -180.0>
    translate  <59.158344, 55.859659, 19.496063>
  }
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -10.834474, -0.499579>
    rotate <-90.0, 0.0, -180.0>
    translate  <59.158344, 43.435491, 9.160905>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1White_Bleu_Agate
    }
    scale <-3.042685, -13.670194, -0.78455>
    rotate <-180.0, 0.0, -180.0>
    translate  <59.344043, 55.886387, -1.584667>
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.654394, -12.178944, -0.257406>
    rotate 180.0*z
    translate  <59.158344, 55.935807, 9.110445>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.654394, -10.834474, -0.257406>
    rotate <-90.0, 0.0, 180.0>
    translate  <59.158344, 55.861759, 9.002732>
  }
  material {
    B1_Lt_gray_wood_window
    translate <-0.086696, -0.047289, 0.000000>
  }
}
#declare Window_Cwhole_shibangD4 = union {
  object { Beveled_Glass5 }
  object { Curtainrod5 }
  object { Window_Frame5 }
}
#declare Window_Cwhole_shibangD5 = union {
  object { Beveled_Glass4 }
  object { Curtainrod4 }
  object { Window_Frame4 }
  object { Window_Cwhole_shibangD4 }
  scale 0.9
  rotate 90.0*z
  translate  <233.559416, 39.907226, -2.951312>
}
#declare RndCube009 = merge {
  sphere { <0.4500, 0.4500, 0.4500>, 0.0500 }
  sphere { <0.4500, -0.4500, 0.4500>, 0.0500 }
  sphere { <-0.4500, -0.4500, 0.4500>, 0.0500 }
  sphere { <-0.4500, 0.4500, 0.4500>, 0.0500 }
  sphere { <0.4500, 0.4500, -0.4500>, 0.0500 }
  sphere { <0.4500, -0.4500, -0.4500>, 0.0500 }
  sphere { <-0.4500, -0.4500, -0.4500>, 0.0500 }
  sphere { <-0.4500, 0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, 0.4500>, <-0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <-0.4500, 0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, -0.4500>, <0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <-0.4500, -0.4500, -0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, -0.4500>, <-0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, 0.4500>, <0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  box { <-0.4500, -0.4500, -0.5000> <0.4500, 0.4500, 0.5000> }
  box { <-0.4500, -0.5000, -0.4500> <0.4500, 0.5000, 0.4500> }
  box { <-0.5000, -0.4500, -0.4500> <0.5000, 0.4500, 0.4500> }
  material {
    B1_Black_lumpy_plastic_1
  }
  scale <2.304712, 2.510257, 0.470276>
  translate  <-35.919434, -49.870661, -11.324968>
}
#declare RndCube013 = merge {
  sphere { <0.4500, 0.4500, 0.4500>, 0.0500 }
  sphere { <0.4500, -0.4500, 0.4500>, 0.0500 }
  sphere { <-0.4500, -0.4500, 0.4500>, 0.0500 }
  sphere { <-0.4500, 0.4500, 0.4500>, 0.0500 }
  sphere { <0.4500, 0.4500, -0.4500>, 0.0500 }
  sphere { <0.4500, -0.4500, -0.4500>, 0.0500 }
  sphere { <-0.4500, -0.4500, -0.4500>, 0.0500 }
  sphere { <-0.4500, 0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, 0.4500>, <-0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <-0.4500, 0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, -0.4500>, <0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <-0.4500, -0.4500, -0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, -0.4500>, <-0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, 0.4500>, <0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  box { <-0.4500, -0.4500, -0.5000> <0.4500, 0.4500, 0.5000> }
  box { <-0.4500, -0.5000, -0.4500> <0.4500, 0.5000, 0.4500> }
  box { <-0.5000, -0.4500, -0.4500> <0.5000, 0.4500, 0.4500> }
  scale <2.239755, 2.439507, 0.471878>
  translate  <-35.918912, -49.870842, -11.65579>
}
#declare Top_pattern = union {
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <0.27, 0.27, 0.104095>
    translate  <-36.712255, -49.045648, -5.731444>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <0.925877, 0.925877, 0.108266>
    translate  <-36.001801, -49.991063, -5.736491>
  }
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.254281, -0.261008, -0.027734>
    rotate 135.0*z
    translate  <-36.554228, -49.207031, -5.654977>
  }
  material {
    B1_Black_Shiny_plastic_1
  }
  translate  <0.094859, -0.004367, -5.428549>
}
#declare RndCube014 = merge {
  sphere { <0.4500, 0.4500, 0.4500>, 0.0500 }
  sphere { <0.4500, -0.4500, 0.4500>, 0.0500 }
  sphere { <-0.4500, -0.4500, 0.4500>, 0.0500 }
  sphere { <-0.4500, 0.4500, 0.4500>, 0.0500 }
  sphere { <0.4500, 0.4500, -0.4500>, 0.0500 }
  sphere { <0.4500, -0.4500, -0.4500>, 0.0500 }
  sphere { <-0.4500, -0.4500, -0.4500>, 0.0500 }
  sphere { <-0.4500, 0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, 0.4500>, <-0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <-0.4500, 0.4500, -0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, -0.4500, -0.4500>, <0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <-0.4500, -0.4500, -0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, -0.4500>, <-0.4500, 0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, 0.4500>, <0.4500, -0.4500, 0.4500>, 0.0500 }
  cylinder { <0.4500, 0.4500, -0.4500>, <0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, -0.4500>, <-0.4500, -0.4500, -0.4500>, 0.0500 }
  cylinder { <-0.4500, 0.4500, 0.4500>, <-0.4500, -0.4500, 0.4500>, 0.0500 }
  box { <-0.4500, -0.4500, -0.5000> <0.4500, 0.4500, 0.5000> }
  box { <-0.4500, -0.5000, -0.4500> <0.4500, 0.5000, 0.4500> }
  box { <-0.5000, -0.4500, -0.4500> <0.5000, 0.4500, 0.4500> }
  material {
    B1_Black_lumpy_plastic_1
  }
  scale <2.192318, 2.38784, 0.447343>
  rotate <-0.0, -0.0, 179.99321>
  translate  <-35.917315, -49.870322, -11.498417>
}
#declare erfga = merge {
  object { RndCube009 }
  object { RndCube013 }
  object { Top_pattern }
  object { RndCube014 }
  material {
    B1_Black_lumpy_plastic_1
  }
  translate  <-0.266077, 0.075707, 5.437432>
}
#declare RndCube021 = merge {
  sphere { <0.9050, 0.9050, 9.9000>, 0.1000 }
  sphere { <0.9050, -0.9050, 9.9000>, 0.1000 }
  sphere { <-0.9050, -0.9050, 9.9000>, 0.1000 }
  sphere { <-0.9050, 0.9050, 9.9000>, 0.1000 }
  sphere { <0.9050, 0.9050, -9.9000>, 0.1000 }
  sphere { <0.9050, -0.9050, -9.9000>, 0.1000 }
  sphere { <-0.9050, -0.9050, -9.9000>, 0.1000 }
  sphere { <-0.9050, 0.9050, -9.9000>, 0.1000 }
  cylinder { <0.9050, 0.9050, 9.9000>, <-0.9050, 0.9050, 9.9000>, 0.1000 }
  cylinder { <0.9050, -0.9050, 9.9000>, <-0.9050, -0.9050, 9.9000>, 0.1000 }
  cylinder { <0.9050, -0.9050, -9.9000>, <-0.9050, -0.9050, -9.9000>, 0.1000 }
  cylinder { <0.9050, 0.9050, -9.9000>, <-0.9050, 0.9050, -9.9000>, 0.1000 }
  cylinder { <0.9050, 0.9050, -9.9000>, <0.9050, 0.9050, 9.9000>, 0.1000 }
  cylinder { <0.9050, -0.9050, -9.9000>, <0.9050, -0.9050, 9.9000>, 0.1000 }
  cylinder { <-0.9050, -0.9050, -9.9000>, <-0.9050, -0.9050, 9.9000>, 0.1000 }
  cylinder { <-0.9050, 0.9050, -9.9000>, <-0.9050, 0.9050, 9.9000>, 0.1000 }
  cylinder { <0.9050, 0.9050, 9.9000>, <0.9050, -0.9050, 9.9000>, 0.1000 }
  cylinder { <0.9050, 0.9050, -9.9000>, <0.9050, -0.9050, -9.9000>, 0.1000 }
  cylinder { <-0.9050, 0.9050, -9.9000>, <-0.9050, -0.9050, -9.9000>, 0.1000 }
  cylinder { <-0.9050, 0.9050, 9.9000>, <-0.9050, -0.9050, 9.9000>, 0.1000 }
  box { <-0.9050, -0.9050, -10.0000> <0.9050, 0.9050, 10.0000> }
  box { <-0.9050, -1.0050, -9.9000> <0.9050, 1.0050, 9.9000> }
  box { <-1.0050, -0.9050, -9.9000> <1.0050, 0.9050, 9.9000> }
  material {
    Walls
  }
  scale <-1.165809, -1.051607, -0.03841>
  rotate <-180.0, 0.0, 90.0>
  translate  <0.223006, 1.721555, -0.605207>
}
#declare Important_cuts = union {
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <0.130964, 0.248003, 0.981354>
    rotate <-90.0, 0.0, 180.0>
    translate  <-0.600201, 1.271413, -0.991023>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <0.78, 0.78, 0.049917>
    rotate 180.0*z
    translate  <0.223889, 1.844975, -0.215409>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <0.23, 0.23, 0.134618>
    rotate 180.0*z
    translate  <0.934488, 0.896755, -0.275146>
  }
  box { // cuts3
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1_DMFLightOak
    }
    scale <0.187247, 0.165461, 0.158232>
    rotate <-0.0, -0.0, -90.0>
    translate  <1.362957, 1.899309, -0.477711>
  }
  box { // cuts2
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1_DMFLightOak
    }
    scale <0.07047, 0.165461, 0.330786>
    rotate <-0.0, -0.0, -90.0>
    translate  <1.362957, 1.497991, -0.637282>
  }
  box { // cuts
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1_DMFLightOak
    }
    scale <0.070805, 0.149859, 0.333573>
    rotate <-0.0, -0.0, -90.0>
    translate  <1.362957, 0.933271, -0.639863>
  }
  box { // cuts1
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1_DMFLightOak
    }
    scale <0.182449, 0.14763, 0.331832>
    rotate <-0.0, -0.0, -90.0>
    translate  <1.362957, 1.213874, -0.638728>
  }
  object { RndCube021 }
  rotate <0.0, -0.0, -180.0>
  translate  <-35.94913, -48.074747, -5.450297>
}
#declare Base = difference {
  object { erfga }
  object { Important_cuts }
  material {
    B1_Black_lumpy_plastic_1
  }
  translate  <0.187287, -0.239651, -5.437432>
}
#declare RndCube011 = merge {
  sphere { <0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <0.1000, 0.0000, -0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, 0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <-0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  box { <-0.1000, -0.0500, -0.4500> <0.1000, 0.0500, 0.4500> }
  scale <0.891378, 0.827824, 1.363536>
  rotate -120.0*z
  translate  <-35.856101, -50.093432, -11.765496>
}
#declare RndCube010 = merge {
  sphere { <0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <0.1000, 0.0000, -0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, 0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <-0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  box { <-0.1000, -0.0500, -0.4500> <0.1000, 0.0500, 0.4500> }
  scale <0.891378, 0.827824, 1.363536>
  translate  <-35.989594, -49.86118, -11.765496>
}
#declare RndCube012 = merge {
  sphere { <0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <0.1000, 0.0000, -0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, 0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <-0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  box { <-0.1000, -0.0500, -0.4500> <0.1000, 0.0500, 0.4500> }
  scale <0.891378, 0.827824, 1.363536>
  rotate 120.0*z
  translate  <-35.85586, -49.938577, -11.765496>
}
#declare RndCube015 = merge {
  sphere { <0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <0.1000, 0.0000, -0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, 0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <-0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  box { <-0.1000, -0.0500, -0.4500> <0.1000, 0.0500, 0.4500> }
  scale <0.891378, 0.827824, 1.363536>
  rotate -120.0*z
  translate  <-36.123466, -49.93871, -11.765496>
}
#declare RndCube016 = merge {
  sphere { <0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <0.1000, 0.0000, -0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, 0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <-0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  box { <-0.1000, -0.0500, -0.4500> <0.1000, 0.0500, 0.4500> }
  scale <0.891378, 0.827824, 1.363536>
  rotate 120.0*z
  translate  <-36.123521, -50.093108, -11.765496>
}
#declare RndCube017 = merge {
  sphere { <0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, 0.4500>, 0.0500 }
  sphere { <0.1000, 0.0000, -0.4500>, 0.0500 }
  sphere { <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, 0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, -0.4500>, 0.0500 }
  cylinder { <0.1000, 0.0000, -0.4500>, <0.1000, 0.0000, 0.4500>, 0.0500 }
  cylinder { <-0.1000, 0.0000, -0.4500>, <-0.1000, 0.0000, 0.4500>, 0.0500 }
  box { <-0.1000, -0.0500, -0.4500> <0.1000, 0.0500, 0.4500> }
  scale <0.891378, 0.827824, 1.363536>
  translate  <-35.989892, -50.170554, -11.765496>
}
#declare RndDisc006 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 0.5000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1100, 0.1100, 0.5100> translate -0.0050*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.3000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0100, 0.0100, 0.5100> translate -0.0950*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.4000*z bounded_by { box { <-1.0020, -1.0020, 0.2980>, <1.0020, 1.0020, 0.5020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.1100, 0.1000  rotate -x*90 translate  0.4000*z bounded_by { box { <-0.2120, -0.2120, 0.2980>, <0.2120, 0.2120, 0.5020> } } }
  torus { 0.1100, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.1120, -0.1120, -0.0020>, <0.1120, 0.1120, 0.1020> } } }
  scale <0.18, 0.18, 0.179237>
  translate  <-35.995204, -50.015767, -11.173759>
}
#declare Stick = union {
  object { RndCube011 }
  object { RndCube010 }
  object { RndCube012 }
  object { RndCube015 }
  object { RndCube016 }
  object { RndCube017 }
  object { RndDisc006 }
  material {
    B1_Black_Shiny_plastic_1
  }
  scale <1.1, 1.1, 1.3>
  translate  <3.610631, 4.85216, 5.148291>
}
#declare Rubber_rings = union {
  torus { // Torus005
    0.8, 0.1  rotate -x*90
    scale 0.395876
    translate  <-36.002138, -50.001055, -11.077173>
  }
  torus { // Torus004
    1.05, 0.1  rotate -x*90
    scale 0.395876
    translate  <-36.002138, -50.001055, -11.110854>
  }
  torus { // Torus003
    1.3, 0.1  rotate -x*90
    scale 0.395876
    translate  <-36.002138, -50.001055, -11.147852>
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.523511, 0.523511, 0.173298>
    rotate 180.0*x
    translate  <-36.003007, -50.003395, -10.978202>
  }
  torus { // Torus006
    0.65, 0.1  rotate -x*90
    scale <0.329897, 0.329897, 0.395876>
    rotate <-0.0, 0.0, -180.0>
    translate  <-36.002998, -50.003673, -11.025387>
  }
  material {
    B1_Black_Shiny_plastic_1
  }
  scale <1.2, 1.2, 1.0>
  translate  <7.219796, 9.833759, 0.09217>
}
#declare RndDisc004 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  scale <0.22, 0.22, 0.3>
  translate  <-36.81931, -49.20431, -11.251372>
}
#declare CSG001 = union {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 7.0>
    translate  <245.838645, 68.481834, 12.641505>
  }
  sphere { // Sphere019
    <0,0,0>,1
    scale <12.400001, 12.400001, 1.897758>
    rotate -90.0*z
    translate  <245.373835, 67.657923, 28.108242>
  }
  scale 0.016129
  rotate <0.0, -0.0, 90.0>
  translate  <-35.726156, -53.160864, -11.396504>
}
#declare Button = difference {
  object { RndDisc004 }
  object { CSG001 }
  material {
    B1_Button_Red_1
  }
  translate  <0.124731, -0.009149, -0.053321>
}
#declare Orange_dots = union {
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022373, -0.044101, -0.019237>
    rotate -90.0*z
    translate  <-36.84506, -49.93612, -5.632248>
  }
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022152, -0.044542, -0.019237>
    translate  <-36.824032, -49.914658, -5.632248>
  }
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022167, -0.044512, -0.019237>
    rotate -15.143143*z
    translate  <-36.793294, -49.779766, -5.632248>
  }
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022192, -0.044463, -0.019237>
    rotate -25.219063*z
    translate  <-36.743338, -49.630519, -5.632248>
  }
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022263, -0.04432, -0.019237>
    rotate -45.285049*z
    translate  <-36.578322, -49.399995, -5.632248>
  }
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022225, -0.044396, -0.019237>
    rotate -35.268318*z
    translate  <-36.669873, -49.512843, -5.632248>
  }
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022301, -0.044245, -0.019237>
    rotate -55.267406*z
    translate  <-36.467647, -49.303459, -5.632248>
  }
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022334, -0.044179, -0.019237>
    rotate -65.217667*z
    translate  <-36.345684, -49.242039, -5.632248>
  }
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022359, -0.04413, -0.019237>
    rotate -75.141914*z
    translate  <-36.224101, -49.206412, -5.632248>
  }
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022167, -0.044512, -0.019237>
    rotate 15.143143*z
    translate  <-36.784546, -50.208365, -5.632248>
  }
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022192, -0.044463, -0.019237>
    rotate 25.219063*z
    translate  <-36.749272, -50.331165, -5.632248>
  }
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022225, -0.044396, -0.019237>
    rotate 35.268318*z
    translate  <-36.68846, -50.454347, -5.632248>
  }
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022301, -0.044245, -0.019237>
    rotate 55.267406*z
    translate  <-36.481149, -50.658595, -5.632248>
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022263, -0.04432, -0.019237>
    rotate 45.285049*z
    translate  <-36.59288, -50.566129, -5.632248>
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022334, -0.044179, -0.019237>
    rotate 65.217667*z
    translate  <-36.364638, -50.732795, -5.632248>
  }
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022359, -0.04413, -0.019237>
    rotate 75.141914*z
    translate  <-36.216869, -50.78325, -5.632248>
  }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022373, -0.044101, -0.019237>
    rotate 90.0*z
    translate  <-36.083313, -50.814295, -5.632248>
  }
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022373, -0.044101, -0.019237>
    rotate 90.0*z
    translate  <-36.841144, -50.047007, -5.632248>
  }
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022152, -0.044542, -0.019237>
    translate  <-36.818161, -50.068469, -5.632248>
  }
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022152, -0.044542, -0.019237>
    translate  <-36.062064, -50.835534, -5.632248>
  }
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022373, -0.044101, -0.019237>
    rotate 90.0*z
    translate  <-35.153415, -50.048214, -5.632248>
  }
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022373, -0.044101, -0.019237>
    rotate 90.0*z
    translate  <-35.912886, -50.811873, -5.632248>
  }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022152, -0.044542, -0.019237>
    rotate 180.0*z
    translate  <-35.934136, -50.835086, -5.632248>
  }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022152, -0.044542, -0.019237>
    rotate 180.0*z
    translate  <-35.174444, -50.069677, -5.632248>
  }
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022167, -0.044512, -0.019237>
    rotate 164.856857*z
    translate  <-35.205182, -50.204568, -5.632248>
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022192, -0.044463, -0.019237>
    rotate 154.78093*z
    translate  <-35.255137, -50.353815, -5.632248>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022263, -0.04432, -0.019237>
    rotate 134.714951*z
    translate  <-35.420153, -50.584339, -5.632248>
  }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022225, -0.044396, -0.019237>
    rotate 144.731689*z
    translate  <-35.328603, -50.471491, -5.632248>
  }
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022301, -0.044245, -0.019237>
    rotate 124.732597*z
    translate  <-35.530828, -50.680875, -5.632248>
  }
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022334, -0.044179, -0.019237>
    rotate 114.782333*z
    translate  <-35.652791, -50.742295, -5.632248>
  }
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022359, -0.04413, -0.019237>
    rotate 104.858086*z
    translate  <-35.774375, -50.777922, -5.632248>
  }
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022167, -0.044512, -0.019237>
    rotate -164.856857*z
    translate  <-35.213929, -49.775969, -5.632248>
  }
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022192, -0.044463, -0.019237>
    rotate -154.78093*z
    translate  <-35.249203, -49.65317, -5.632248>
  }
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022225, -0.044396, -0.019237>
    rotate -144.731689*z
    translate  <-35.310016, -49.529987, -5.632248>
  }
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022301, -0.044245, -0.019237>
    rotate -124.732597*z
    translate  <-35.517326, -49.325739, -5.632248>
  }
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022263, -0.04432, -0.019237>
    rotate -134.714951*z
    translate  <-35.405595, -49.418205, -5.632248>
  }
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022334, -0.044179, -0.019237>
    rotate -114.782333*z
    translate  <-35.633837, -49.251539, -5.632248>
  }
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022359, -0.04413, -0.019237>
    rotate -104.858086*z
    translate  <-35.781606, -49.201084, -5.632248>
  }
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022373, -0.044101, -0.019237>
    rotate -90.0*z
    translate  <-35.157332, -49.937328, -5.632248>
  }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.022152, -0.044542, -0.019237>
    rotate 180.0*z
    translate  <-35.180315, -49.915866, -5.632248>
  }
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "TOP",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.105788
    translate  <-36.109773, -49.18644, -5.720852>
  }

  material {
    B1_Orange_Shiny_plastic_1
  }
  translate  <0.016069, -0.16831, -5.437432>
}
#declare Plug_line = difference {
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      B1_Black_Shiny_plastic_1
    }
    scale <0.112164, 0.112164, 2.193599>
    rotate 90.0*x
    translate  <-57.921307, -59.177222, -6.022204>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    scale <0.164098, 0.749944, 0.267002>
    translate  <-57.936088, -59.881203, -6.086044>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <22.757079, 11.761637, -5.760143>
}
#declare Atari_Joystick = union {
  object { Base }
  object { Stick }
  object { Rubber_rings }
  object { Button }
  object { Orange_dots }
  object { Plug_line }
  material {
    B1_Black_Shiny_plastic_1
  }
  scale 62.0
  rotate -90.0*z
  translate  <3296.540837, -2207.28838, 709.889155>
}
#declare L_Door_window_frame1 = union {
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.867406, -0.938562>
    rotate -90.0*z
    translate  <12.344775, 85.575498, -24.578743>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <-0.647213, -0.330998, -7.781583>
    rotate <180.0, 90.0, 0.0>
    translate  <8.451917, 84.550317, -23.679026>
  }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.04391, -3.903987, -0.992099>
    rotate -90.0*z
    translate  <12.344775, 85.586444, -24.024457>
  }
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, -16.163043>
  }
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, -7.237056>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, 1.688931>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, 10.6515>
  }
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -4.899971, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, 19.579394>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -22.867241, -0.499579>
    rotate <-90.0, 0.0, -90.0>
    translate  <7.94238, 85.572551, -2.790275>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -22.867241, -0.499579>
    rotate <-90.0, 0.0, -90.0>
    translate  <16.747171, 85.572551, -2.790275>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <-0.647213, -0.330998, -7.781583>
    rotate <180.0, 90.0, 0.0>
    translate  <8.451917, 86.617372, -23.664467>
  }
  material {
    B1_Lt_gray_wood_window
  }
  translate  <0.0, 4.916855, -1.076375>
}
#declare L_Door_Window_Glass1 = union {
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.199924>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, -20.902129>
  }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, -12.724333>
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, -3.828014>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, 5.103316>
  }
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, 5.103316>
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, -3.828014>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, -12.724333>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.199924>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, -20.902129>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.785128, 14.007416>
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 88.336251, 14.007416>
  }
  material {
    Glass3
  }
  translate  1.436162*y
}
#declare R_Door_Window = union {
  object { L_Door_window_frame1 }
  object { L_Door_Window_Glass1 }
  scale 0.9
  translate  <232.085033, 12.176992, -4.489633>
}
#declare L_Door_window_frame = union {
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.867406, -0.938562>
    rotate -90.0*z
    translate  <12.344775, 85.575498, -24.578743>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <-0.647213, -0.330998, -7.781583>
    rotate <180.0, 90.0, 0.0>
    translate  <8.451917, 84.550317, -23.679026>
  }
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.04391, -3.903987, -0.992099>
    rotate -90.0*z
    translate  <12.344775, 85.586444, -24.024457>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, -16.163043>
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, -7.237056>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, 1.688931>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -3.903987, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, 10.6515>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -4.899971, -0.499579>
    rotate -90.0*z
    translate  <12.344775, 85.572551, 19.579394>
  }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -22.867241, -0.499579>
    rotate <-90.0, 0.0, -90.0>
    translate  <7.94238, 85.572551, -2.790275>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -22.867241, -0.499579>
    rotate <-90.0, 0.0, -90.0>
    translate  <16.747171, 85.572551, -2.790275>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <-0.647213, -0.330998, -7.781583>
    rotate <180.0, 90.0, 0.0>
    translate  <8.451917, 86.617372, -23.664467>
  }
  material {
    B1_Lt_gray_wood_window
  }
  translate  <0.0, 4.916855, -1.076375>
}
#declare L_Door_Window_Glass = union {
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.199924>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, -20.902129>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, -12.724333>
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, -3.828014>
  }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.772413, 5.103316>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, 5.103316>
  }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, -3.828014>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, -12.724333>
  }
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.199924>
    rotate <180.0, 0.0, 180.0>
    translate  <12.344378, 88.336251, -20.902129>
  }
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 89.785128, 14.007416>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    scale <-3.891315, -0.300501, -3.995064>
    rotate <-180.0, 0.0, -180.0>
    translate  <12.344378, 88.336251, 14.007416>
  }
  material {
    Glass3
  }
  translate  1.436162*y
}
#declare L_Door_Window = union {
  object { L_Door_window_frame }
  object { L_Door_Window_Glass }
  scale 0.9
  translate  <197.07206, 12.110617, -4.489633>
}
#declare Door_Frame = union {
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -12.582905, -0.499579>
    rotate -90.0*z
    translate  <36.044362, 94.297826, 18.496981>
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -22.867241, -0.499579>
    rotate <-90.0, 0.0, -90.0>
    translate  <23.936583, 94.297826, -3.866647>
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.371397, -22.867241, -0.499579>
    rotate <-90.0, 0.0, -90.0>
    translate  <48.128307, 94.297826, -3.866647>
  }
  material {
    B1_Lt_gray_wood_window
  }
  translate  -3.395248*y
}
#declare Hinge_Cyes_a_hingeD = union {
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 14.384961>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 12.284084>
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 11.259728>
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 12.822344>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.26, 0.26, 0.55171>
    translate  <28.04727, 86.398493, 13.31166>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.27, 0.27, 0.302597>
    translate  <28.04727, 86.398493, 10.458186>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.27, 0.27, 0.302597>
    translate  <28.04727, 86.398493, 14.85163>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.26, 0.26, 0.55171>
    translate  <28.04727, 86.398493, 11.77169>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 10.720094>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 13.802585>
  }
  material {
    Chrome1
  }
  translate  <19.550125, 2.880327, -0.497346>
}
#declare Hinge_Cyes_a_hingeD1 = union {
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 14.384961>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 12.284084>
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 11.259728>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 12.822344>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.26, 0.26, 0.55171>
    translate  <28.04727, 86.398493, 13.31166>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.27, 0.27, 0.302597>
    translate  <28.04727, 86.398493, 10.458186>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.27, 0.27, 0.302597>
    translate  <28.04727, 86.398493, 14.85163>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.26, 0.26, 0.55171>
    translate  <28.04727, 86.398493, 11.77169>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 10.720094>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 13.802585>
  }
  material {
    Chrome1
  }
  translate  <19.550125, 2.880327, -16.06638>
}
#declare Hinge_Cyes_a_hingeD2 = union {
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 14.384961>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 12.284084>
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 11.259728>
  }
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.197495, 0.428754>
    translate  <28.04691, 86.662233, 12.822344>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.26, 0.26, 0.55171>
    translate  <28.04727, 86.398493, 13.31166>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.27, 0.27, 0.302597>
    translate  <28.04727, 86.398493, 10.458186>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.27, 0.27, 0.302597>
    translate  <28.04727, 86.398493, 14.85163>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    material {
      B_Silver
    }
    scale <0.26, 0.26, 0.55171>
    translate  <28.04727, 86.398493, 11.77169>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 10.720094>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.072582>
    translate  <28.04727, 86.398493, 13.802585>
  }
  material {
    Chrome1
  }
  translate  <19.550125, 2.880327, -32.55124>
}
#declare RndDisc001 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale 1.198735
  rotate -90.0*x
  translate  <26.892657, 93.115137, -4.848076>
}
#declare RndDisc002 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale 1.198735
  rotate -90.0*x
  translate  <26.892657, 85.399194, -4.848076>
}
#declare Knob = union {
  sphere { // Sphere071
    <0,0,0>,1
    scale 1.242296
    translate  <26.894898, 93.270828, -4.845927>
  }
  object { RndDisc001 }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <1.349238, 1.349238, 3.19563>
    rotate -90.0*x
    translate  <26.914179, 88.451632, -4.821731>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <0.380052, 0.380052, 6.22046>
    rotate -90.0*x
    translate  <26.914179, 87.003828, -4.821731>
  }
  object { RndDisc002 }
  sphere { // Sphere072
    <0,0,0>,1
    scale 1.242296
    translate  <26.894898, 86.51043, -4.845927>
  }
  material {
    New_Brass_1
  }
  scale 0.8
  translate  <5.074079, 18.531844, -0.616121>
}
#declare CSG011 = union {
  box { // Door_wood
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1_DMFLightOak
    }
    scale <11.523378, 1.0, 22.146437>
    translate  <32.244011, 90.185619, -4.260873>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    material {
      New_Brass_1
    }
    scale <0.7, 0.7, 2.369184>
    rotate <-90.0, 0.0, 0.0>
    translate  <31.675761, 88.960631, 7.564705>
  }
  rotate -0.0*z
}
#declare Peephole_cut = difference {
  object { CSG011 }
  sphere { // Sphere073
    <0,0,0>,1
    material {
      Glass3
    }
    scale <-0.620973, -1.471936, -0.620973>
    rotate <180.0, 0.0, 180.0>
    translate  <31.673418, 90.146133, 7.573073>
  }
  rotate 0.0*z
  translate  <3.799545, 0.442858, 0.0>
}
#declare Door_Total = union {
  object { Door_Frame }
  object { Hinge_Cyes_a_hingeD }
  object { Hinge_Cyes_a_hingeD1 }
  object { Hinge_Cyes_a_hingeD2 }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    material {
      B_Silver
    }
    scale <-2.478544, -12.582905, -0.111126>
    rotate -90.0*z
    translate  <36.044362, 92.083534, -26.632048>
  }
  object { Knob }
  sphere { // Sphere074
    <0,0,0>,1
    material {
      Glass3
    }
    scale <-0.620973, -1.471936, -0.620973>
    rotate <180.0, 0.0, 180.0>
    translate  <35.472963, 90.588991, 7.573073>
  }
  object { Peephole_cut }
  material {
    B1_DMFLightOak
  }
  scale 0.9
  translate  <193.398447, 11.786233, -4.489633>
}
#declare Group001 = union {
  object { R_Door_Window }
  object { L_Door_Window }
  object { Door_Total }
  translate  3.250455*z
}
#declare Group002 = union {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1white_ceiling
    }
    scale <-49.734051, -51.686829, -0.580407>
    rotate -180.0*z
    translate  <206.052263, 39.300155, 16.843835>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <-49.734051, -21.470549, -0.580407>
    rotate <90.0, 0.0, 90.0>
    translate  <254.401623, 37.71493, -4.122563>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      Walls
    }
    scale <-49.734051, -21.470549, -0.580407>
    rotate <90.0, 0.0, 90.0>
    translate  <157.702902, 38.507542, -4.122563>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <-49.734051, -21.470549, -0.580407>
    rotate <90.0, 0.0, -180.0>
    translate  <206.052263, -11.427043, -4.122563>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      B1carpet
    }
    scale <-49.734051, -51.686829, -0.580407>
    rotate -180.0*z
    translate  <206.052263, 39.300155, -25.088961>
  }
  material {
    Walls
  }
}
#declare HgtFld003 = object { 
  height_field {
    sys /*unknown extension [BMP]*/ "C:\Documents and Settings\Joseph_Greg\Desktop\WALK_Cheap_bumpy.bmp"
    water_level 0.1
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Concrete
  }
  scale <34.0, 111.0, 1.3875>
  rotate <-0.0, 0.0, -180.0>
  translate  <247.819179, 208.140516, -26.334378>
}
#declare Group008 = union {
  object { Room_interior }
  object { Window_Cwhole_shibangD5 }
  object { Atari_Joystick }
  object { Group001 }
  object { Group002 }
  object { HgtFld003 }
  text {   // TText014
    ttf      "C:\WINDOWS\Fonts\Cour.ttf",
    "1101",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      B1_Button_Red_1
    }
    scale <4.0, 4.0, 0.1>
    rotate <90.0, -0.1, -180.0>
    translate  <229.583601, 94.389738, 7.81127>
  }

  rotate 6.670923*z
  translate  <-179.438985, 22.771441, 27.176897>
}
#declare OVERALL = union {
  object { Group008 }
  rotate <-90.0, -90.0, 0.0>
}
/**********************************ENTIRE SCENE OBJECTS***************************/
union { // Group009
  object { KEY }
  object { Fill }
  object { HgtFld002 }
  plane { // Plane001
    z,0
    material {
      B1_Grass
    }
    rotate <-90.0, -90.0, 0.0>
  }
  object { Group007 }
  object { OVERALL }
  rotate -90.0*y 
  translate <0, 0, 2500>
}



/***************************NON MORAY SEGMENTS*************************/

sky_sphere {

pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                    color rgb <0.258, 0.258, 0.435>  ]
        [0.5, 1.001 color rgb <0.258, 0.258, 0.435>
                    color rgb <0.258, 0.258, 0.435> ]
    }
    scale <6, 1, 6>
    translate <0,.5,0>
    }
      translate -1
      rotate <0, -90, 0>
    
  }



/*
plane { y, 0
  material{Grass}
  translate  <0,0,0> 
}

*/


#declare lPatch=50;               // size of patch
#declare nBlade=30;               // number of blades per line
#declare ryBlade = 60;            // initial y rotation of blade
#declare segBlade= 15;            // number of blade segments
#declare lBlade = .8;             // length of blade
#declare wBlade = .1;              // width of blade at start
#declare wBladeEnd = 0.05;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,-1,2>;       // direction of the force bending the blade (<0,1,1> = 45)
#declare pwBend = 3;             // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 3;           // standard deviation of blade scale;
#declare stdBend = 0;             // standard deviation of blade bending;
#declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;           // true creates a mesh file
#declare fname = "lgrass.inc"     // name of the mesh file to create

//MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)


#declare nxPrairie=250;           // number of patches for the first line
#declare addPatches=0;            // number of patches to add at each line
#declare nzPrairie=250;           // number of lines of patches
#declare rd=seed(3421);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

#declare objectPatch=#include "fgrass.inc"  
MakePrairie(lPatch,nxPrairie,0,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
#declare rd=seed(587);
MakePrairie(lPatch,nxPrairie,0,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
#declare rd=seed(547);            // random seed
#declare objectPatch=#include "dgrass.inc"  
MakePrairie(lPatch,nxPrairie,0,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
#declare rd=seed(342);            // random seed
#declare objectPatch=#include "lgrass.inc"  
MakePrairie(lPatch,nxPrairie,0,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest) 



  

// maketree used to make bushes and trees
#include "colors.inc"
#include "txttree.inc"

// Bush 1
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_3}
#declare Leaf=object{#include "deadleaves_1.inc"} // declares the Leaf object
#declare Tree1=object{#include "deadbush_1.inc"
//        texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "deadsprigs_1.inc"
        texture{txtLeaf} 
}
                                                     
union{
     object{Tree1}
     object{Foliage1}
     translate   <  -60,      0,    2663>     // <40, 0 ,150>
     scale 1
 
} 

// Bush 2
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_3}
#declare Leaf=object{#include "deadleaves_2.inc"} // declares the Leaf object
#declare Tree1=object{#include "deadbush_2.inc"
//        texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "deadsprigs_2.inc"
        texture{txtLeaf} 
}
                                                     
union{
     object{Tree1}
     object{Foliage1}
     translate   <  -5,      0,    2650>     // <40, 0 ,150>
     scale 1
 
} 

// Bush 3
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_3}
#declare Leaf=object{#include "deadleaves_3.inc"} // declares the Leaf object
#declare Tree1=object{#include "deadbush_3.inc"
//        texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "deadsprigs_3.inc"
        texture{txtLeaf} 
}
                                                     
union{
     object{Tree1}
     object{Foliage1}
     translate   <  55,      0,    2646>     // <40, 0 ,150>
     scale 1
 
}
// Bush 4
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_3}
#declare Leaf=object{#include "deadleaves_4.inc"} // declares the Leaf object
#declare Tree1=object{#include "deadbush_4.inc"
//        texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "deadsprigs_4.inc"
        texture{txtLeaf} 
}
                                                     
union{
     object{Tree1}
     object{Foliage1}
     translate   <  25,      0,    2648>     // <40, 0 ,150>
     scale 1
 
}




