camera {
    spherical
    location 0
    look_at z
}

plane {y, -0.01  pigment {color rgb 0}}

difference {
    sphere {0, 1}
    sphere {0, 0.85}
    hollow
    pigment {color rgbt 1}
    finish {ambient 1  diffuse 0}
    interior {
        media {
            method 3
            intervals 1
            samples 4, 7
            scattering {
                1
                color rgb 7.75
                extinction 0.45
            }
            density {
                wrinkles
                turbulence 0.5
                omega 0.7
                lambda 2.35
                scale <0.6, 0.155, 0.6>*0.5
                color_map {
                    [0    color rgb 0.3]
                    [0.5  color rgb 0.6]
                    [1    color rgb 1]
                }
            }
        }
    }
}

background {color rgb <0.15, 0.15, 0.25>}

light_source {1000*z  color rgb 1  rotate -63.5*x}

fog {
    fog_type 2
    distance 630
    color rgbt <0.875, 0.875, 0.9, 0.125>
    fog_offset 1.2*110
    fog_alt 0.12
}

