#declare Z = seed (123);

light_source {<-100, 200, -350>  color rgb 1}

light_source {-<-100, 200, -350>  color rgb 0.425 shadowless}

#declare n_o_sectors = 10;
#declare n_o_floors = 30;
#declare block_height = 1;
#declare n_o_block_radii = 5;
#declare block_rad = array [n_o_block_radii] {1.5, 2, 2.5, 3, 4};

#global_settings {max_trace_level 18}

camera {
    location <-7, 1, -15>
    look_at 21*y
    angle 58
    focal_point block_height*n_o_floors*0.65*y
    aperture 0.195
    blur_samples 40
    confidence 0.99
    variance 1/60000
}

#declare S_s_mat =
material {
    texture {
        pigment {color rgb 0.5}
        finish {
            brilliance 4
            ambient 0.2
            metallic
            reflection {
                1
                fresnel
                metallic
            }
            specular 1
            roughness 0.025
        }
        normal {
            bump_map {
                jpeg "bmap006.jpg"
                interpolate 2
            } 0.8
            scale <5/n_o_sectors, 0.75*block_height, 1>
            warp {cylindrical}
            rotate 180/n_o_sectors*y
        }
    }
    interior {ior 11}
}

#declare Balcony_mat =
material {
    texture {
        pigment {color rgb <0.425, 0.425, 0.45>}
        finish {
            brilliance 3
            metallic
            reflection {
                1
                fresnel
                metallic
            }
            specular 0.65
            roughness 0.04        
        }
    }
    interior {ior 7.5}
}

#declare Glass_mat =
material {
    texture {
        pigment {color rgbt 1}
        finish {
            reflection {0.78}
            conserve_energy
            specular 0.22
            roughness 0.0035
        }
        normal {bumps 0.03  scale 1.5}
    }
    interior {ior 1.43}
}

#declare Glass2_mat =
material {
    texture {
        pigment {color rgbt 1}
        finish {
            reflection {
                1
                fresnel
            }
            conserve_energy
            specular 0.125
            roughness 0.0035
        }
    }
    interior {ior 1.43}
}

#declare Room_tex =
texture {
    pigment {color rgb 0.35}
    finish {ambient 1  diffuse 0}
}

#declare Bridge_mat =
material {
    texture {
        pigment {color rgb <0.5, 0.515, 0.55>}
        finish {
            brilliance 3
            metallic
            reflection {
                1
                fresnel
                metallic
            }
            specular 0.65
            roughness 0.04        
        }
    }
    interior {ior 8}
}

#declare Bridge_n_mat =
material {
    texture {
        pigment {color rgb <0.5, 0.515, 0.55>}
        finish {
            brilliance 3
            metallic
            reflection {
                1
                fresnel
                metallic
            }
            specular 0.65
            roughness 0.04        
        }
        normal {
            bump_map {jpeg "bmap004.jpg"  interpolate 2} 0.55
            rotate 90*x
            scale 1.5
        }
    }
    interior {ior 8}
}

#declare Bridge_n2_mat =
material {
    texture {
        pigment {color rgb <0.5, 0.515, 0.55>}
        finish {
            brilliance 3
            metallic
            reflection {
                1
                fresnel
                metallic
            }
            specular 0.65
            roughness 0.04        
        }
        normal {
            bump_map {jpeg "bmap004.jpg"  interpolate 2} 0.35
            rotate 90*x
            scale 2
        }
    }
    interior {ior 8}
}

#declare L_s_m_mat =
material {
    texture {
        pigment {color rgb 0.5}
        finish {
            brilliance 4
            ambient 0.2
            metallic
            reflection {
                1
                fresnel
                metallic
            }
            specular 1
            roughness 0.025
        }
    }
    interior {ior 11}
}

#declare glow_color = color rgb <0.775, 1, 0.2>;
#declare Glowing_fluid_mat =
material {
    texture {
        pigment {color rgbt 1}
        finish {
            reflection {
                1
                fresnel
            }
            conserve_energy
            specular 0.085
            roughness 0.0042
        }
    }
    interior {
        ior 1.33
        media {
            method 3
            intervals 1
            samples 3, 6
            emission 0.475
            density {color glow_color}
        }
    }
}

#declare balcony_rad_dist = 0.075;
#declare balcony_height = 0.35;
#macro Balcony ()
    #declare balcony_angle_dist = 180*balcony_rad_dist/(pi*block_rad_arr [n_o_floors-II] [n_o_sectors-I]);
    union {
        union {
            cylinder {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.02}
            cylinder {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.02  rotate (180/n_o_sectors-balcony_angle_dist)*y}
            cylinder {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.02  rotate (-180/n_o_sectors+balcony_angle_dist)*y}
            cylinder {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.02  rotate (90/n_o_sectors-balcony_angle_dist/2)*y}
            cylinder {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.02  rotate (-90/n_o_sectors+balcony_angle_dist/2)*y}
            sphere {<0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.05  rotate (180/n_o_sectors-balcony_angle_dist)*y}
            sphere {<0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.05  rotate (-180/n_o_sectors+balcony_angle_dist)*y}
            cylinder {<0, block_height+balcony_height, 0>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.02  rotate (180/n_o_sectors-balcony_angle_dist)*y}
            cylinder {<0, block_height+balcony_height, 0>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+balcony_rad_dist>, 0.02  rotate (-180/n_o_sectors+balcony_angle_dist)*y}
            rotate -180/n_o_sectors*y
        }
        intersection {
            torus {block_rad_arr [n_o_floors-II] [n_o_sectors-I]-balcony_rad_dist, 0.02  translate (block_height+balcony_height)*y}
            box {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <block_rad_arr [n_o_floors-II] [n_o_sectors-I], 2*block_height, block_rad_arr [n_o_floors-II] [n_o_sectors-I]>  rotate -balcony_angle_dist*y}
            box {<-block_rad_arr [n_o_floors-II] [n_o_sectors-I], block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <0, 2*block_height, block_rad_arr [n_o_floors-II] [n_o_sectors-I]>  rotate (-360/n_o_sectors+balcony_angle_dist)*y}
        }
        #local III = 2*block_rad_arr [n_o_floors-II] [n_o_sectors-I]-1;
        #while (III > 0)
            cylinder {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+III/2>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+III/2>, 0.02  rotate -balcony_angle_dist*y}
            cylinder {<0, block_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+III/2>, <0, block_height+balcony_height, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]+III/2>, 0.02  rotate (-360/n_o_sectors+balcony_angle_dist)*y}
            #local III = III-1;
        #end
    }
#end

#declare block_rad_arr = array [n_o_floors] [n_o_sectors]
#declare II = n_o_floors;
#while (II > 0)
    #declare I = n_o_sectors;
    #while (I > 0)
        #declare window_case = true;
        #if ((I = n_o_sectors & II = 20) | (I = 3 & II = 13))  #declare window_case = false;  #end
        #if (window_case)
            #declare block_rad_arr [n_o_floors-II] [n_o_sectors-I] = block_rad [floor (n_o_block_radii*rand (Z))];
        #else
            #declare block_rad_arr [n_o_floors-II] [n_o_sectors-I] = 4;
        #end
        #if (I = 2 & II = 30)  #declare block_rad_arr [n_o_floors-II] [n_o_sectors-I] = 3;  #end
        #declare I = I-1;
    #end
    #declare II = II-1;
#end

#declare glow_color2 = color rgb <0.5, 0.58, 1>;
#declare Sky_scraper =
union {
    #declare II = n_o_floors;
    #while (II > 0)
        union {
            #declare I = n_o_sectors;
            #while (I > 0)
                #declare window_case = true;
                #if ((I = n_o_sectors & II = 20) | (I = 3 & II = 13))  #declare window_case = false;  #end
                intersection {
                    cylinder {0, block_height*y, block_rad_arr [n_o_floors-II] [n_o_sectors-I]}
                    box {<0, -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <block_rad_arr [n_o_floors-II] [n_o_sectors-I], block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]>}
                    box {<-block_rad_arr [n_o_floors-II] [n_o_sectors-I], -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <0, block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]>  rotate -360/n_o_sectors*y}
                    #if (window_case)
                        intersection {
                            cylinder {0.2*block_height*y, 0.8*block_height*y, block_rad_arr [n_o_floors-II] [n_o_sectors-I]+0.1}
                            box {<0, -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <block_rad_arr [n_o_floors-II] [n_o_sectors-I], block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]+0.1>  rotate -5*y}
                            box {<-block_rad_arr [n_o_floors-II] [n_o_sectors-I], -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <0, block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]+0.1>  rotate (-360/n_o_sectors+5)*y}
                            inverse
                        }
                    #end
                    rotate I/n_o_sectors*360*y
                    material {S_s_mat}
                }
                #if (II = n_o_floors)
                    object {
                        Balcony ()
                        rotate I/n_o_sectors*360*y
                        material {Balcony_mat}
                    }
                #else
                    #if (block_rad_arr [n_o_floors-II-1] [n_o_sectors-I] < block_rad_arr [n_o_floors-II] [n_o_sectors-I])
                        object {
                            Balcony ()
                            rotate I/n_o_sectors*360*y
                            material {Balcony_mat}
                        }
                    #end
                #end
                intersection {
                    cylinder {0.2*block_height*y, 0.8*block_height*y, block_rad_arr [n_o_floors-II] [n_o_sectors-I]-0.02}
                    box {<0, -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <block_rad_arr [n_o_floors-II] [n_o_sectors-I], block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]+0.1>  rotate -5*y}
                    box {<-block_rad_arr [n_o_floors-II] [n_o_sectors-I], -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <0, block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]+0.1>  rotate (-360/n_o_sectors+5)*y}
                    rotate I/n_o_sectors*360*y
                    material {Glass_mat}
                }
                intersection {
                    cylinder {0.2*block_height*y, 0.8*block_height*y, block_rad_arr [n_o_floors-II] [n_o_sectors-I]-0.025}
                    box {<0, -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <block_rad_arr [n_o_floors-II] [n_o_sectors-I], block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]+0.1>  rotate -5*y}
                    box {<-block_rad_arr [n_o_floors-II] [n_o_sectors-I], -0.1, -block_rad_arr [n_o_floors-II] [n_o_sectors-I]>, <0, block_height+0.1, block_rad_arr [n_o_floors-II] [n_o_sectors-I]+0.1>  rotate (-360/n_o_sectors+5)*y}
                    texture {Room_tex}
                    rotate I/n_o_sectors*360*y
                }
                #declare I = I-1;
            #end
            translate II*block_height*y
        }
        #declare II = II-1;
    #end
    #declare Antenna =
    union {
        #declare Crystal =
        lathe {
            bezier_spline
            4,
            <0, -1>, <1.25, -0.5>, <1.25, 0.5>, <0, 1>
            hollow
            scale <1, 2.5, 1>
        }
        object {
            Crystal
            pigment {color rgbt 1}
            finish {
                reflection {
                    1
                    fresnel
                }
                conserve_energy
                specular 0.125
                roughness 0.0035
            }
            interior {
                ior 1.45
                media {
                    method 3
                    intervals 1
                    samples 3, 6
                    emission 4*0.135
                    density {color glow_color2}
                }
            }
        }
        union {
            torus {2, 0.15}
            difference {
                union {
                    torus {1, 0.15}
                    cylinder {-2*x, 2*x, 0.125  rotate 45*y}
                }
                object {Crystal  scale 1.001}
            }
            difference {
                torus {2, 0.125  rotate 90*x}
                box {<-2.125, 0, -2.125>, 2.125}
                scale <1, 1.5, 1>
            }
            sphere {-2*y, 0.3  rotate -65*z  scale <1, 1.5, 1>}
            cylinder {-2*y, -20*y, 0.125  rotate -65*z  translate -cos (radians (65))*1.5*y}
            material {L_s_m_mat}
        }
        rotate 65*z
    }
    object {
        Antenna
        rotate -38*y
        translate 20.5*y
        scale 0.2
        translate <0, n_o_floors*block_height, -2.5>
        rotate -360/n_o_sectors*1/5*y
        rotate 2/n_o_sectors*360*y
    }
    object {
        Antenna
        rotate -133*y
        translate 32*y
        scale 0.2
        translate <0, n_o_floors*block_height, -2>
        rotate -360/n_o_sectors*4/5*y
        rotate 2/n_o_sectors*360*y
    }
    // Antenna2
    union {
        torus {2.5, 0.15}
        cylinder {-4*x, 4*x, 0.125}
        sphere {-4*x, 0.225}
        sphere {4*x, 0.225}
        cylinder {-2.5*x, 2.5*x, 0.125  rotate 60*y}
        cylinder {-2.5*x, 2.5*x, 0.125  rotate -60*y}
        cylinder {13*y, -37*y, 0.125}
        sphere {13*y, 0.15}
        rotate -51*y
        translate 49*y
        scale 0.2
        translate <0, n_o_floors*block_height, -1.8>
        rotate -360/n_o_sectors*2/5*y
        rotate 2/n_o_sectors*360*y
        material {L_s_m_mat}
    }
    // Cables
    union {
        torus {0.1, 0.04*block_height}
        cylinder {-0.1*z, -30*z, 0.008*block_height}
        translate -block_rad_arr [24] [2]*z
        rotate -360/n_o_sectors/2*y
        rotate 2/n_o_sectors*360*y
        translate 24.1*block_height*y
        material {Balcony_mat}
    }
    union {
        torus {0.1, 0.04*block_height}
        cylinder {-0.1*z, -30*z, 0.008*block_height}
        translate -block_rad_arr [24] [2]*z
        rotate -360/n_o_sectors/4*y
        rotate 2/n_o_sectors*360*y
        translate 24.1*block_height*y
        material {Balcony_mat}
    }
    union {
        torus {0.1, 0.04*block_height}
        cylinder {-0.1*z, -30*z, 0.008*block_height}
        translate -block_rad_arr [20] [2]*z
        rotate -360/n_o_sectors/2*y
        rotate 2/n_o_sectors*360*y
        translate 20.1*block_height*y
        material {Balcony_mat}
    }
}

#declare Bridge =
union {
    union {
        difference {
            box {<-4*pi*(180/n_o_sectors)/180*2/3, 0, 0>, <4*pi*(180/n_o_sectors)/180*2/3, 0.1, -20>}
            cylinder {-y, y, 4}
            material {Bridge_n2_mat}
        }
        difference {
            cylinder {0, -20*z, 4*pi*(180/n_o_sectors)/180*1/3  scale <1, 0.15/(4*pi*(180/n_o_sectors)/180*1/3), 1>}
            cylinder {-y, y, 4}
            material {Bridge_n_mat}
        }
        difference {
            union {
                cylinder {<-4*pi*(180/n_o_sectors)/180/2, 0.1, -5.5>, <-4*pi*(180/n_o_sectors)/180/2, -0.85*block_height, -3.5>, 0.06}
                cylinder {<4*pi*(180/n_o_sectors)/180/2, 0.1, -5.5>, <4*pi*(180/n_o_sectors)/180/2, -0.85*block_height, -3.5>, 0.06}
            }
            cylinder {-y, y, 4}
            material {Bridge_mat}
        }
    }
    union {
        difference {
            union {
                cylinder {<-4*pi*(180/n_o_sectors)/180*2/3+balcony_rad_dist, balcony_height, 0>, <-4*pi*(180/n_o_sectors)/180*2/3+balcony_rad_dist, balcony_height, -20>, 0.02}
                cylinder {<4*pi*(180/n_o_sectors)/180*2/3-balcony_rad_dist, balcony_height, 0>, <4*pi*(180/n_o_sectors)/180*2/3-balcony_rad_dist, balcony_height, -20>, 0.02}
            }
            cylinder {-y, y, 4}
        }
        #declare I = 31;
        #while (I > 0)
            cylinder {<-4*pi*(180/n_o_sectors)/180*2/3+balcony_rad_dist, 0, -20+I/2>, <-4*pi*(180/n_o_sectors)/180*2/3+balcony_rad_dist, balcony_height, -20+I/2>, 0.02}
            cylinder {<4*pi*(180/n_o_sectors)/180*2/3-balcony_rad_dist, 0, -20+I/2>, <4*pi*(180/n_o_sectors)/180*2/3-balcony_rad_dist, balcony_height, -20+I/2>, 0.02}
            #declare I = I-1;
        #end
        material {Balcony_mat}
    }
    rotate -360/n_o_sectors/2*y
}

#declare link =
union {
    intersection {
        torus {0.4, 0.1  rotate 90*x}
        box {<-0.5, -0.5, -0.1>, <0, 0.5, 0.1>}
        translate 0.3*x
    }
    intersection {
        torus {0.4, 0.1  rotate 90*x}
        box {<0, -0.5, -0.1>, <0.5, 0.5, 0.1>}
        translate 0.7*x
    }
    cylinder {<0.3, 0.4, 0>, <0.7, 0.4, 0>, 0.1}
    cylinder {<0.3, -0.4, 0>, <0.7, -0.4, 0>, 0.1}
    material {Balcony_mat}
}

#declare link_length = 0.2;
#declare link_rotation = 92;
#declare link_error = 0.01;
#declare chain_start = <0, 0, -6.5>;
#declare chain_end = <0, 0, -19>;
#declare chain_scale = 0.15;

#declare Chain1 =
union {
    #include "chain11.inc"
}

#declare light_sphere_rad = 0.85;
#declare n_o_bubbles = 125;
#declare Light_sphere =
union {
    difference {
        sphere {0, 1}
        sphere {0, 0.95}
        material {Glass2_mat}
    }
    difference {
        sphere {0, 0.9499}
        box {-1, <1, 0.1, 1>  inverse}
        #declare I = n_o_bubbles;
        #while (I > 0)
            sphere {<-1+2*rand (Z), -1+1.1*rand (Z), -1+2*rand (Z)>, 0.015+0.0175*rand (Z)}
            #declare I = I-1;
        #end
        hollow
        material {Glowing_fluid_mat}
    }
    scale light_sphere_rad
}

#declare Light_sphere_metal =
difference {
    union {
        sphere {y, 0.3}
        #declare Half_torus =
            intersection {
                torus {1, 0.075  rotate 90*x}
                box {-1.1, <0, 1.1, 1.1>}
            }
        object {Half_torus}
        object {Half_torus  rotate 72*y}
        object {Half_torus  rotate -144*y}
        object {Half_torus  rotate 140*y}
        object {Half_torus  rotate -72*y}
        sphere {-y, 0.2}
        rotate 83*y
    }
    sphere {0, 1.001}
    material {L_s_m_mat}
    scale light_sphere_rad
}

#declare Light_sphere_light =
light_source {
    <0, 0.001, 0>  color glow_color
    area_light <-0.75, 0, -0.75>, <0.75, 0, 0.75>, 2, 2
    circular
    orient
    jitter
    fade_power 2
    fade_distance 4.25
    scale light_sphere_rad
}

#declare light_beams_rad = 2.8;
#declare Light_beams =
difference {
    sphere {0, light_beams_rad-0.001}
    sphere {0, light_sphere_rad+0.001}
    hollow
    pigment {color rgbt 1}
    finish {ambient 1  diffuse 0}
    interior {
        media {
            method 3
            intervals 1
            samples 2, 6
            jitter 0.4
            emission 0.125
            density {
                spherical
                scale light_beams_rad
                density_map {
                    [0  color rgb 0]
                    [1
                        spherical
                        color_map {
                            [0  color rgb 0]
                            [1  color glow_color]
                        }
                    ]
                }
            }
        }
    }
}

#declare Chain2 =
union {
    #declare n_o_links = 40;
    #declare I = n_o_links;
    #while (I > 0)
        object {link  rotate -90*z  scale link_length  translate -I*link_length*y  rotate (n_o_links-I)*link_rotation*y}
        #declare I = I-1;
    #end
}

#declare Chain3 =
union {
    #declare n_o_links2 = 20;
    #declare I = n_o_links2;
    #while (I > 0)
        object {link  rotate -90*z  scale link_length  translate -I*link_length*y  rotate (n_o_links2-I)*link_rotation*y}
        #declare I = I-1;
    #end
}

#declare cylinder_height = 13;
#declare Pipe =
union {
    union {
        cylinder {30*z, -30*z, 0.09*block_height}
        cylinder {0, cylinder_height*y, 0.125}
        sphere {cylinder_height*y, 0.25}
        cylinder {12.25*z, 12.75*z, 0.15*block_height}
        sphere {12.25*z, 0.15*block_height}
        sphere {12.75*z, 0.15*block_height}
        cylinder {-12.25*z, -12.75*z, 0.15*block_height}
        sphere {-12.25*z, 0.15*block_height}
        sphere {-12.75*z, 0.15*block_height}
        torus {0.15*block_height, 0.1*block_height  rotate 90*x  translate 12.5*z}
        torus {0.15*block_height, 0.1*block_height  rotate 90*x  translate -12.5*z}
        material {Bridge_mat}
    }
    union {
        cylinder {cylinder_height*y, 11*z, 0.02}
        cylinder {cylinder_height*y, -11*z, 0.02}
        material {Balcony_mat}
    }
    rotate -360/n_o_sectors/2*y
    rotate 4/n_o_sectors*360*y
    translate 28.1*block_height*y
}

light_group {
    object {Sky_scraper}
    object {Pipe}
    object {Chain3  translate 12.5*z  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y  translate 28.1*block_height*y}
    object {Chain2  translate -12.5*z  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y  translate 28.1*block_height*y}
    object {Bridge  translate 20*block_height*y}
    object {Bridge  rotate 3/n_o_sectors*360*y  translate 13*block_height*y}
    object {Chain1  rotate -360/n_o_sectors/2*y  translate 20*block_height*y}
    object {Chain1  rotate -360/n_o_sectors/2*y  rotate 3/n_o_sectors*360*y  translate 13*block_height*y}
    object {Chain2  translate <0, 20*block_height, -6.5>  rotate -360/n_o_sectors/2*y}
    object {Light_sphere_metal  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 20*block_height, -6.5>  rotate -360/n_o_sectors/2*y}
    object {Chain3  translate <0, 13*block_height, -6.5>  rotate 3/n_o_sectors*360*y  rotate -360/n_o_sectors/2*y}
    object {Light_sphere_metal  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 13*block_height, -6.5>  rotate -360/n_o_sectors/2*y  rotate 3/n_o_sectors*360*y}

    object {Light_sphere_light  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 20*block_height, -6.5>  rotate -360/n_o_sectors/2*y}
    object {Light_sphere_light  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 13*block_height, -6.5>  rotate -360/n_o_sectors/2*y  rotate 3/n_o_sectors*360*y}
    object {Light_sphere_light  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, 12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}
    object {Light_sphere_light  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, -12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}
    object {Light_sphere_metal  rotate 195.3*y  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, 12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}
    object {Light_sphere_metal  rotate 82.6*y  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, -12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}
    global_lights on
}

object {Light_sphere  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 20*block_height, -6.5>  rotate -360/n_o_sectors/2*y}
object {Light_beams  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 20*block_height, -6.5>  rotate -360/n_o_sectors/2*y}

object {Light_sphere  rotate 27.8*y  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 13*block_height, -6.5>  rotate -360/n_o_sectors/2*y  rotate 3/n_o_sectors*360*y}
object {Light_beams  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 13*block_height, -6.5>  rotate -360/n_o_sectors/2*y  rotate 3/n_o_sectors*360*y}

object {Light_sphere  rotate 252.1*y  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, 12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}
object {Light_beams  translate (-n_o_links2*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, 12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}

object {Light_sphere  rotate 12.3*y  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, -12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}
object {Light_beams  translate (-n_o_links*link_length-light_sphere_rad-1.5*link_length)*y  translate <0, 28.1*block_height, -12.5>  rotate -360/n_o_sectors/2*y  rotate (180+4/n_o_sectors*360)*y}

sky_sphere {
    pigment {
        image_map {jpeg "clouds.jpg"  map_type 1  interpolate 2}
        rotate 31.5*y
    }
}

plane {y, 0
    pigment {color rgb 0.5}
    normal {
        bump_map {jpeg "bmap005.jpg"  interpolate 2} 0.6
        scale 4
        rotate 90*x
    }
    finish {
        specular 0.7
        roughness 0.12
    }
}
