//+850 +h600
// +sc0.123471 +sr0.398134 +ec0.840934 +er0.735614  angle 20
 
#include "colors.inc"
#include "mgrass.pov"
#include "fgrass1.inc"
#include "fgrass2.inc"
#include "Weeds.inc"


#declare cm = .01;
#include "units.inc"                                                   

#declare R1 = seed(4456);
#declare PreTrace = 1;  //0 = compute radiosity only  1 = final render
#declare Rad_Quality = 3; //use 3 for final 

global_settings{ assumed_gamma 1
                 max_trace_level 50 
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.02
        count 50
        error_bound 0.5
        recursion_limit 3
        brightness 1
//        media on
        normal on 
        always_sample off
        save_file "Home1Rad1"
     #else 
        load_file "Home1Rad1"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008   //A=.01  B=.007
        count 200              //A=200  B=100
        error_bound 0.25       //A=.25  B=.15
        recursion_limit 3      //A=1    B=3
        brightness 1
//        media on
        normal on 
        always_sample off
        save_file "Home1Rad2"
     #else 
        load_file "Home1Rad2"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 400   
        error_bound 0.12
        recursion_limit 4  
        media on
        normal on
        always_sample off
        save_file "Home1Rad3"
     #else 
        load_file "Home1Rad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #end

}

camera {
    angle 20
    location <-50 * Feet, 30 * Feet, -250 * Feet>
    look_at <5 * Feet, 5 * Feet, 0 * Feet>
//    location <0 * Feet, 150 * Feet, 0 * Feet>
//    look_at <0 * Feet, 0 * Feet, 0 * Feet>
  }


light_source {
  0*x                 // light's position (translated below)
  color rgb 2.0       // light's color
  area_light
  <200 * Feet, 0, 0> <0, 200 * Feet, 0> // lights spread out across this distance (x * z)
  5, 5                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <200 * Feet, 100 * Feet, -200 * Feet> //x=200
} 

sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.5  color CornflowerBlue ]
        [ 1.0  color MidnightBlue ]
      }
      scale 2
      translate -1
    }
  } 

#declare F_MetalB  = 
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.70
    roughness 1/60
    reflection 0.25
}
#declare P_Copper2   = color rgb <0.50, 0.25, 0.15>; 
#declare T_Copper_2B = texture { pigment { P_Copper2 } finish { F_MetalB  } }

#declare P_WoodGrain9A =
pigment {
    wood  
    turbulence 0.1
    octaves 4
    lambda 3
    scale 0.2
    rotate <0.125, 0.125, 0>
}

#declare P_WoodGrain9B =
pigment {
    wood
    turbulence 0.1          
    octaves 4
    lambda 3.5
    scale 0.2
    rotate <0.125, 0.125, 0>
    translate <0.015, 0.015, 0.015>
}
#declare M_Wood9A = 
color_map { 
    [0.0, 0.5 color rgb <1.00, 0.85, 0.50>
              color rgb <0.60, 0.40, 0.16>]
    [0.5, 0.7 color rgb <0.60, 0.40, 0.16>
              color rgb <0.60, 0.40, 0.16>]
    [0.7, 1.0 color rgb <0.60, 0.40, 0.16>
              color rgb <1.00, 0.85, 0.50>]
}
#declare M_Wood9B = 
color_map { 
    [0.0, 0.5 color rgbt <1.00, 0.70, 0.25, 1.00>
              color rgbt <0.50, 0.30, 0.06, 0.40>]
    [0.5, 0.7 color rgbt <0.50, 0.30, 0.06, 0.40>
              color rgbt <0.50, 0.30, 0.06, 0.30>]
    [0.7, 1.0 color rgbt <0.50, 0.30, 0.06, 0.40>
              color rgbt <1.00, 0.70, 0.25, 1.00>]
}

// Yellowish-brown burl (heavily turbulated)
#declare T_Wood9   =         
    texture { pigment { P_WoodGrain9A  color_map { M_Wood9A }}}
    texture { pigment { P_WoodGrain9B  color_map { M_Wood9B }}}

//--------- Tan Cream & Red Rose
#declare T_Grnt12 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbt <0.996, 0.969, 0.800, 0.000>
                    color rgbt <0.996, 0.682, 0.604, 0.000>]
    [0.154, 0.308   color rgbt <0.996, 0.682, 0.604, 0.000>
                    color rgbt <0.906, 0.820, 0.714, 0.000>]
    [0.308, 0.444   color rgbt <0.906, 0.820, 0.714, 0.000>
                    color rgbt <0.816, 0.631, 0.537, 0.000>]
    [0.444, 0.615   color rgbt <0.816, 0.631, 0.537, 0.000>
                    color rgbt <0.890, 0.792, 0.675, 0.000>]
    [0.615, 0.812   color rgbt <0.890, 0.792, 0.675, 0.000>
                    color rgbt <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbt <0.973, 0.627, 0.627, 0.000>
                    color rgbt <0.996, 0.969, 0.800, 0.000>]
   }
 }
 }

#declare T_Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbt <0.027, 0.012, 0.012, 0.000>
                    color rgbt <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbt <0.851, 0.812, 0.741, 0.235>
                    color rgbt <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbt <0.792, 0.694, 0.690, 0.839>
                    color rgbt <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbt <0.631, 0.506, 0.471, 0.608>
                    color rgbt <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbt <0.851, 0.812, 0.741, 0.922>
                    color rgbt <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbt <0.647, 0.655, 0.655, 0.282>
                    color rgbt <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }

#declare T_Crack1 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black transmit 0.6 color Black transmit 1.0]
    [0.04, 0.97 color Scarlet transmit 0.80 color DimGray transmit 0.90]
    [0.97, 1.001 color Black transmit 0.9 color Black transmit 1.0]
   }
 }
 }

//------------- White Cream Marble with Pink veining
#declare T_Stone5 =
texture{T_Grnt12  scale <2, 3, 2> rotate <0, 0, 40>}
texture{T_Grnt17a scale <2, 3, 2> rotate <0, 0, -30>}
texture{T_Crack1  scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

#declare HouseMaterial=
material{  
            texture{T_Wood9 rotate <0,90,0> scale .4}
            texture {
                      pigment {
                                bozo scale .6         
                                color_map {
                                           [0.0 color rgbt <0.86, 0.58, 0.44, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     }
}

    

#declare MailBox =
merge{    
//post
       box{<-.5 * Feet, 0 * Feet, -.5 * Feet> , <.5 * Feet, 5 * Feet, .5 * Feet>
            texture{T_Wood9 rotate <0,90,0> scale .4}
            texture {
                      pigment {
                                bozo scale .6         
                                color_map {
                                           [0.0 color rgbt <0.86, 0.58, 0.44, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     }
            finish {
                    ambient 0
                    diffuse 0.8 
                   }
       normal{wrinkles 5.0 scale .3}
       }

//mail box 
  union{
      superellipsoid {<.5,.5>
      }            
      box{<-0.5, -0.6, 0.0 >,<-.5, 0.6, -1.01> pigment{Black}}
      box{<-0.5, 0.6, 0.0 >,<0.5, 0.6, -1.01> pigment {Black}}
      box{< 0.5, 0.6, 0.0 >,<0.49, -0.5, -1.01> pigment {Black}}
      sphere{<0.0, 0.2, -1.0>, -.15 pigment{Brown}}

      texture{T_Copper_2B}
      scale <1 * Feet, 1 * Feet, 2 * Feet>
      translate<0 * Feet, 6 * Feet, 0 * Feet>
  }
//flag
  box{<-.3 * Feet, 0 * Feet, -1.5 * Feet>,<.3 * Feet, .3 * Feet, 1 * Feet>
      pigment{Red}
      translate <-1 * Feet, 6 * Feet, 0 * Feet>
      }
      
}

#macro SideWalk (A,B,C)
     superellipsoid { <A,B>
                      scale <2.5 * Feet, 1 * Feet, 2.5 * Feet>
                      translate <0,0,0> 
                      rotate<0,C * 180,0>       
                      texture{T_Stone5}
                      finish{phong 0 }
      }
#end 
  
#declare House = 
merge{

  prism {
    linear_sweep
    0 * Feet, // sweep the following shape from here ...
    8 * Feet, // ... up through here
    7, // the number of points making up the shape ...
    <6 * Feet,10 * Feet>, 
    <-6 * Feet,10 * Feet>, 
    <-10 * Feet,0 * Feet>, 
    <-6 * Feet,-10 * Feet>, 
    <6 * Feet, -10 * Feet>,
    <10 * Feet,0 * Feet>, 
    <6 * Feet,10 * Feet>
/*          texture {
                    pigment { color rgbf<1.0, 1.0, 1.0, 0.6> }
                    finish {
                            specular 1
                            roughness 0.001
                            ambient 0
                            diffuse 0
                            reflection 0.5
                           }   
                   } */
    hollow
  } 

  box{<-6 * Feet, 0 * Feet, -6 * Feet>,<6 * Feet, 8 * Feet, 15 * Feet> 
      pigment{Black}
      translate<0 * Feet, 0 * Feet, 16 * Feet>
      }
  box{<-6 * Feet, 0 * Feet, -6 * Feet>,<6 * Feet, 8 * Feet, 6 * Feet> 
      pigment{Black}
      translate<0 * Feet, 0 * Feet, -16 * Feet>
      }
  box{<-5.5 * Feet, 0 * Feet, -5.5 * Feet>,<5.5 * Feet, 8 * Feet, 5.5 * Feet> 
      pigment{Black}
      rotate<0,68,0>
      translate<-13 * Feet, 0 * Feet, -7 * Feet>
      }
  box{<-5.5 * Feet, 0 * Feet, -5.5 * Feet>,<5.5 * Feet, 8 * Feet, 5.5 * Feet> 
      pigment{Black}
      rotate<0,68,0>
      translate<13 * Feet, 0 * Feet, 7 * Feet>
      }
difference{
  box{<-5.5 * Feet, 0 * Feet, -5.5 * Feet>,<5.5 * Feet, 8 * Feet, 15 * Feet> 
      pigment{Black}
      }    
  cylinder{<0 * Feet, 0 * Feet> ,  <0 * Feet, 9 * Feet>,  2.5 * Feet
  }
  rotate<0,-68,0>
  translate<-13 * Feet, 0 * Feet, 7 * Feet>
}   
      
  box{<-5.5 * Feet, 0 * Feet, -10 * Feet>,<5.5 * Feet, 8 * Feet, 5.5 * Feet> 
      pigment{Black}
      rotate<0,-68,0>
      translate<13 * Feet, 0 * Feet, -7 * Feet>
      }  
      
merge{
   cone { <0 * Feet, 8.1 * Feet, 0 * Feet>, 23.0 * Feet,
          <0 * Feet,  23 * Feet, 0 * Feet>, 20.0 * Feet 
          open
          material{HouseMaterial}
          normal{wrinkles 5.0 scale .3}
          hollow
   }

   torus { 19.5 * Feet, 1 * Feet
           material{HouseMaterial rotate<0,90,0>}
           normal{wrinkles 5.0 scale .3}
           translate<0 * Feet, 23.5 * Feet, 0 * Feet>
         }

         
  cylinder { <0 * Feet, 24.5 * Feet> ,  <0 * Feet, 24 * Feet>,  19 * Feet
          texture {
                    pigment { color rgbt<1.0, 1.0, 1.0, 0.6> }
                    finish {
                            specular 1
                            roughness 0.001
                            ambient 0
                            diffuse 0
                            reflection 0.25
                           }   
                   }
           hollow
         }
}

difference{
  sphere_sweep {
    linear_spline                // alternative spline curves
    6,                            // number of specified sphere positions
    <  0.0 * Feet, 14.0 * Feet,   20.0 * Feet>, 6 * Feet                // position, radius
    <  0.0 * Feet, 15.0 * Feet,   26.0 * Feet>, 6 * Feet                 // ...
    <  5.0 * Feet, 17.0 * Feet,   28.0 * Feet>, 6 * Feet
    <  10.0 * Feet, 20.0 * Feet,   26.2 * Feet>, 6 * Feet
    < 25.0 * Feet, 23.0 * Feet,   20.2 * Feet>, 6 * Feet
    < 29.0 * Feet, 25.0 * Feet,   0 * Feet>, 6 * Feet
    tolerance 0.001             // optional
    texture{T_Stone5}
    finish{phong 0 }
    hollow
  }
  
    cylinder { <0 * Feet, -6.5 * Feet> ,  <0 * Feet, 5 * Feet>,  4.5 * Feet 
           rotate <90,-15,0>
           translate <28.5 * Feet, 24 * Feet, 0 * Feet>
           hollow
         }
} 

hollow
}  //end House
  
   cone { <0 * Feet, 8.1 * Feet, 0 * Feet>, 22.99 * Feet,
          <0 * Feet,  23 * Feet, 0 * Feet>, 19.99 * Feet 
          open
          inverse
          pigment {  image_map {
                                jpeg "erise1.jpg" 
                                map_type 2   
                                interpolate 2     
                                once           
                               } scale <5,8,1> rotate<0,20,0>
                  }
          hollow
          translate<0, -20 * Feet, 0>
   }
   
   plane{ y,-20 * Feet 
          pigment{Gray30}
   } 


difference{
                             
#declare CamLoc = <-50 * Feet, 30 * Feet, -250 * Feet>;
#declare Scale = .5 * Feet;

plane{ y,0 
    texture {
          pigment {
                   crackle metric 1 form<0.8,0,0> 
                   color_map {
                              [0.0 color Brown ]
                              [0.5 color DarkBrown ]
                              [0.5 color DarkBrown]
                              [1.0 color DarkTan ]
                             }
                   scale .3
                   warp { turbulence 0.5 }
                  }
            }
   normal{crackle 2}
}
  
  cylinder { <0 * Feet, -2 * Feet> ,  <0 * Feet, 2 * Feet>,  20.5 * Feet 
             pigment{rgbt<1,1,1,1>}
           }
}


#object {SideWalk(.5,.9,rand(R1)*180)
         translate<30 * Feet, 0 * Feet, -8 * Feet>
         }

#object {SideWalk(.3,.8,rand(R1)*180)
//         translate<20 * Feet, 0 * Feet, -16 * Feet>
         translate<24 * Feet, 0 * Feet, -14 * Feet>
         }

#object {SideWalk(.1,.9,rand(R1)*180)
//         translate<22 * Feet, 0 * Feet, -24 * Feet>
         translate<28 * Feet, 0 * Feet, -23 * Feet>
         }

#object {SideWalk(.6,.3,rand(R1)*180)
//         translate<12 * Feet, 0 * Feet, -32 * Feet>
         translate<19 * Feet, 0 * Feet, -26 * Feet>
         }

#object {SideWalk(.2,.7,rand(R1)*180)
//         translate<14 * Feet, 0 * Feet, -40 * Feet>
         translate<22 * Feet, 0 * Feet, -35 * Feet>
         }

#object {SideWalk(.5,.5,rand(R1)*180)
//         translate<4 * Feet, 0 * Feet, -48 * Feet>
         translate<11 * Feet, 0 * Feet, -38 * Feet>
         }

#object {SideWalk(.5,.5,rand(R1)*180)
//         translate<6 * Feet, 0 * Feet, -56 * Feet>
         translate<14 * Feet, 0 * Feet, -47 * Feet>
         }

#object {SideWalk(.5,.5,rand(R1)*180)
//         translate<-4 * Feet, 0 * Feet, -64 * Feet>
         translate<3 * Feet, 0 * Feet, -50 * Feet>
         }

#object {SideWalk(.5,.5,rand(R1)*180)
         translate<6 * Feet, 0 * Feet, -60 * Feet>
         }

#object {SideWalk(.5,.5,rand(R1)*180)
         translate<-3 * Feet, 0 * Feet, -63 * Feet>
         }

#object{MailBox
        translate<-12 * Feet, 0 * Feet, -64 * Feet>
        }
        
#object{House  
        rotate<0,0,0>  //y-55
        translate <0, -20 * Feet,0>
        }   

//Make Grass

 #declare GrassDensity = .5;       
 #declare X = -35;
 #while (X < 90)
    #declare Z = -75;  
    #while (Z < 165)
                  
        #if ( ( (X>-20) & (X<32)) & ( (Z>-10) & (Z<20) )  )  //#if ( ( (X>-20) & (X<50)) & ( (Z>-65) & (Z<135) ) ) 
            #debug "Patch Skipped\n"
        #else
            #if (rand(R1) > 0.1)
            #object{Grass 
                    scale  0.03 * Feet
                    translate <(X + (GrassDensity * rand(R1))) * Feet,  (.6 * rand(R1)) * Feet, (Z + (GrassDensity * rand(R1))) * Feet>
            } 
            #else
            #object{Grass1 
                    scale  0.02 * Feet
                    translate <(X + (GrassDensity * rand(R1))) * Feet,  (.6 * rand(R1)) * Feet, (Z + (GrassDensity * rand(R1))) * Feet>
            } 
            #end
        #end
        
        #declare Z = Z + GrassDensity;
    #end 
    #declare X = X + GrassDensity;
    #debug concat("\nline " str(X,4,0) " => 90 finished\n") 
#end 

#debug "Grass Done\n" 

// format        1           2          3        4       5                  6                7           8              9            10
// makeWeedPatch(patchLength,patchWidth,numWeeds,devBend,numBladeRangeStart,numBladeRangeEnd,stalkHeight,devStalkHeight,devBladeRot, randSeed)


// lots of variance
#object { 
  makeWeedPatch(13 * Feet, 10 * Feet, 40, 0, 6, 8, 10 * Feet, 0.05 , 0.3 ,seed(12))
  translate <20 * Feet, 0 * Feet, -5 * Feet>
} 

#debug "Weeds 1 of 2 done\n"

// little variance
#object { 
  makeWeedPatch(100 * Feet, 40 * Feet, 100, 0, 6, 8, 20 * Feet, 0.05, 0.6, seed(18))
  translate <-15 * Feet, 0 * Feet, -30 * Feet>
  rotate<0,-30,0>
} 
                                       
#debug "Weeds 2 of 2 done, making flowers\n"

#include "plants1.inc"

#declare Theta = 170;
#declare DegToRad = pi/180;
#while (Theta < 270)
   
   #object {New_plant_1
            rotate<0,rand(R1) * 180, 0>
            scale 0.01
            translate<23 * cos(Theta * DegToRad) * Feet,
                      0,
                      30 * sin (Theta * DegToRad) * Feet>
           }
   #object {New_plant_4
            rotate<0,rand(R1) * 180, 0>
            scale 0.01
            translate<23 * cos((Theta+10) * DegToRad) * Feet,
                      0,
                      30 * sin ((Theta+10) * DegToRad) * Feet>
        }                                
   #declare Theta = Theta + 20;
#end   

