//+850 +h600
//+sc0.000000 +sr0.075314 +ec1.000000 +er0.527197 angle 64

#include "colors.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "shapes.inc"

#declare cm = .01;
#include "units.inc"                                                   

#declare R1 = seed(4456);
#declare PreTrace = 1;  //0 = compute radiosity only  1 = final render
#declare Rad_Quality = 3;  //use 3 for final

#declare HouseMaterial=  
material{  
            texture{T_Wood9 rotate <0,90,0> scale .4}
            texture {
                      pigment {
                                bozo scale .6         
                                color_map {
                                           [0.0 color rgbt <0.86, 0.58, 0.44, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     }
} 

global_settings{ assumed_gamma 1
                 max_trace_level 200 
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.02
        count 50
        error_bound 0.5
        recursion_limit 3
        brightness 1
        media on
        normal on 
        always_sample off
        save_file "Home3Rad1"
     #else 
        load_file "Home3Rad1"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008   //A=.01  B=.007
        count 200              //A=200  B=100
        error_bound 0.25       //A=.25  B=.15
        recursion_limit 3      //A=1    B=3
        brightness 1
        media on
        normal on 
        always_sample off
        save_file "Home3Rad2"
     #else 
        load_file "Home3Rad2"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 400   
        error_bound 0.12
        recursion_limit 3  
//        media on
        normal on
        always_sample off
        save_file "Home3Rad3"
     #else 
        load_file "Home3Rad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #end

}

camera {
    angle 64
//    location <10 * Feet, -14 * Feet, -21 * Feet> //low angle 80
//    look_at <-1 * Feet, -19 * Feet, 0 * Feet>    //low angle 

    location <5 * Feet, -14 * Feet, -8 * Feet> //low angle 80
    look_at <-16 * Feet, -27 * Feet,  30 * Feet>    //low angle


//    location <0 * Feet, -18 * Feet, -20 * Feet> //reg angle 70
//    look_at <0 * Feet, -18 * Feet, 10 * Feet>
  }

#include "Lighting.inc"
#include "House.inc"

//earth globe 
sphere { <0 * Feet, 0 * Feet, 0 * Feet> 
          1 * Feet       
          pigment {  image_map {
                                 png "HFEarth.png"
                                 map_type 1   
                                 interpolate 2     
                                 once           
                               }  
                  }
          scale 11 * Feet //8
          rotate<-40,180,0>
          translate<0 * Feet, -19.5 * Feet, 0 * Feet>//-19.5
} 

MakeStair()             


#object{BookCase
      rotate<0,-80,0>
      translate<-32 * Feet, -17 * Feet, 16.5 * Feet>
}
#object{BookCase
      rotate<0,-60,0>
      translate<-31 * Feet, -17 * Feet, 21 * Feet>
} 
#object{BookCase
      rotate<0,-53,0>
      translate<-29.5 * Feet, -17 * Feet, 25 * Feet>
}

#object{Storage
      scale <1 , .5 , 1>  
      translate<4 * Feet, -13.5 * Feet, 36 * Feet>
}
#object{Storage
      scale <1 , .5 , 1>  
      translate<9 * Feet, -13.5 * Feet, 36 * Feet>
}

#object{ Counter
      translate<1 * Feet, -19 * Feet, 34.5 * Feet>
      } 
#object{ Counter
      translate<4 * Feet, -19 * Feet, 34.5 * Feet>
      } 
#object{ Counter
      translate<7 * Feet, -19 * Feet, 34.5 * Feet>
      } 
#object{ Counter
      translate<10 * Feet, -19 * Feet, 34.5 * Feet>
      } 
                                
#object{House  
        rotate<0,0,0>  //y-55
        translate <0, -20 * Feet,0>
        }   


