#declare BubbleMedia =
media {
	emission 4    //in bubble
	method 3
        samples 5,10 
      }


//BookCase
#declare BookCase=
union{
  box{<-2 * Feet, -4 * Feet, -1.5 * Feet>,<2 * Feet, 4 * Feet, -1.4 * Feet>
      texture{T_Wood32 rotate <90,90,0> 
               scale .3
             }                                            
      }
  cylinder{<0 * Feet, 0 * Feet, -2.01 * Feet>
           <0 * Feet, 0 * Feet, -1.99 * Feet>
           1.5 * Feet
           scale <1, 2,  1 >
           texture {
                    pigment { color rgbf<.9, .9, .9, .5> }
                    finish {
                            specular 1
                            roughness 0.001
                            ambient 0
                            diffuse 0
                            reflection 0.2
                           }   
          }      
    }            
 
  box{<2 * Feet, -4 * Feet, -1.5 * Feet>,<2 * Feet, 4 * Feet, 2 * Feet>
      texture{T_Wood32 rotate <90,0,0> 
              scale .3
              }                                            
      } 
  box{<-2 * Feet, -4 * Feet, -1.5 * Feet>,<-2 * Feet, 4 * Feet, 2 * Feet>
      texture{T_Wood32 rotate <90,0,0> 
              scale .3
             }                                            
      } 
}

//Storage above counter
#declare Storage=
union{
  box{<-8 * Feet, -2 * Feet, -2 * Feet>,<-7.5 * Feet, 2 * Feet, 2 * Feet>
      texture{T_Wood32 rotate <90,90,0> 
              scale 2
             }                                            
      }
  box{<-7.5 * Feet, -2 * Feet, -2 * Feet>,<-4.5 * Feet, -1.5 * Feet, 2 * Feet>
      texture{T_Wood32 rotate <0,90,0> 
              scale 2
             }                                            
      }
  box{<-4.5 * Feet, -2 * Feet, -2 * Feet>,<-4 * Feet, 2 * Feet, 2 * Feet>
      texture{T_Wood32 rotate <90,90,0> 
              scale .5
             }                                            
      }
  box{<-8 * Feet, -1.5 * Feet, -2 * Feet>,<-4.5 * Feet, 2 * Feet, 2 * Feet>
      texture{T_Wood32 rotate <0,90,0> 
              scale 2
             }                                           
      }  
  box{<-7.5 * Feet, -1.5 * Feet, -2.1 * Feet>,<-4.5 * Feet, 1.5 * Feet, -1.9 * Feet>
      texture {
           pigment { color rgbf<.9, .9, .9, .5> }
           finish {
                   specular 1
                   roughness 0.001
                   ambient 0
                   diffuse 0
                   reflection 0.4
                  }   
       }      
  }             
 
  box{<-4 * Feet, -2 * Feet, -2 * Feet>,<-4.1 * Feet, 2 * Feet, 2 * Feet>
      texture{T_Wood32 rotate <90,0,0> 
              scale 1
             }                                            
      } 
  hollow
}

//Counter
#declare Counter=

union{
  box{<-6 * Feet, -2 * Feet, -4 * Feet>,<-3 * Feet, 2 * Feet, 4 * Feet>
      texture{T_Wood32 rotate <90,90,0> 
              scale .5 
             }                                            
      }
  box{<-5.5 * Feet, -1.5 * Feet, -4.1 * Feet>,<-3.5 * Feet, 1.5 * Feet, 3.9 * Feet>
      texture { T_Wood18 rotate <0,0,0> 
                scale .6
               }      
  }               
 
  box{<-4 * Feet, -2 * Feet, -1.5 * Feet>,<-4.1 * Feet, 2 * Feet, 1.5 * Feet>
      texture{T_Wood32 rotate <90,0,0>
             }                                            
      }

  box{<-6 * Feet, 2.5 * Feet, -4.3 * Feet>,<-3 * Feet, 2 * Feet, 4 * Feet>
      texture{T_Stone5}  
      }

  box{<-6 * Feet, 3 * Feet, -.001 * Feet>,<-3 * Feet, 2.5 * Feet, .001 * Feet>
      texture{T_Stone5}  
      }

}

//Blank Walls
#declare Room1 =
difference{ 
  box{<-6 * Feet, -1 * Feet, -6 * Feet>,<6 * Feet, 8.0 * Feet, 24 * Feet>
 
      }
  box{<-5.9 * Feet, -1.01 * Feet, -6.1 * Feet>,<6.1 * Feet, 8.1 * Feet, 26.1 * Feet> 
      }
}

#declare Room3 =
  box{<-6 * Feet, -1 * Feet, -6 * Feet>,<6 * Feet, 8.0 * Feet, 24 * Feet>
 
     }

//Clear Plastic Wall
#declare Room2 =

difference{
union{ 
  box{<-6 * Feet, -.99 * Feet, -6 * Feet>,<-5.5 * Feet, 7.99 * Feet, 25 * Feet>}
  box{<-6.01 * Feet, -.99 * Feet, -6 * Feet>,<-5.49 * Feet, -.5 * Feet, 25 * Feet>
      material{HouseMaterial}
      }
  box{<-6.01 * Feet, 7.5 * Feet, -6 * Feet>,<-5.49 * Feet, 7.99 * Feet, 25 * Feet>
       material{HouseMaterial}
     }
  box{<-6.01 * Feet, 7.49 * Feet, -6 * Feet>,<-5.49 * Feet, -.49 * Feet, -5.5 * Feet>
       material{HouseMaterial}
     }
  #local One = -5.75;
  #local Two =  0;
  #while (Two < 7.5)
     #local Three = -5.5;
     #while (Three < 23)
        sphere { <(  One +   0) * Feet, 
                  (  Two +   (.35*rand(R1))) * Feet, 
                  (Three + (.2*rand(R1))) * Feet>, 
                  0.15 * Feet
                  pigment{color rgbt<1,1,1,1>}
                  finish{  ambient 0
                           diffuse 0 
                         }
                  hollow
                  interior {
                             ior 1.0
                             media{BubbleMedia}
                           }
               }
//           #debug concat("X = " str(One,3,1) " Y = " str(Two,3,1) " Z = " str(Three,3,1) "\n")
        #local Three = Three + .5; // .5
     #end //Z1
  #local Two = Two + .5; // .5
  #end //Y1 
  } //end union bubbles
      
  cylinder{ <-5 * Feet, 6 * Feet, 6 * Feet>
            <-10 * Feet, 6 * Feet, 6 * Feet>
              7.5 * Feet
              scale <2 * Feet, 1.5 * Feet, 4 * Feet>
          }
          
  pigment{color rgbt<1,1,1,.7> }
  hollow
  finish {
          specular 0.7
          roughness 0.001
          ambient 0
          diffuse 0
          reflection {
                       0.0, 0.1
                       fresnel on
                     }
          conserve_energy
  }  
  interior {
    ior 1.7  
  }

}  //end difference


//Spiral Staircase
#declare StairX = -13.5;
#declare StairZ = 13.5;
         
#macro MakeStair() 

  box{<-.25 * Feet, -25 * Feet, -.25 * Feet>,<.25 * Feet, -8 * Feet, .25 * Feet> 
      texture{T_Copper_2B}
      translate<StairX * Feet, 0 * Feet, StairZ * Feet>
      no_shadow
     }

  sphere{<0,0,0>, .8 * Feet
      texture{T_Chrome_5D}
      translate<StairX * Feet, -7.2 * Feet, StairZ * Feet> 
      no_shadow
  }      

#declare Step=
       box{<0 * Feet, 0 * Feet, -0.3 * Feet>,<3 * Feet, .1 * Feet, .3 * Feet> //3 = 2.5
           texture{T_Copper_2B}
           no_shadow
          }

#declare Post= 
sphere_sweep {
              linear_spline                // alternative spline curves
              2,                            // number of specified sphere positions
              <  2.9 * Feet, 0 * Feet, 0 * Feet>, .1 * Feet                // position, radius
              <  2.9 * Feet, 4 * Feet, 0 * Feet>, .1 * Feet                 // ...
              tolerance 0.001             // optional
              texture{T_Copper_2B}
              no_shadow
             } 


   #local K = 6 / pi;
   #local Height = -12;
   #local Theta = 0;
   #local Theta1 = Theta * pi / 180;
   #local X = StairX + 3; 
   #local Z = StairZ + .5;     
   #while (Theta < 270)
       #local Theta1 = Theta * pi / 180;
       #local Y = Height - (K * Theta1);

       #object{Step                 
               rotate<0,Theta,0>
               translate<StairX * Feet, Y * Feet, StairZ * Feet>
               }
               
       #object{Post
               rotate<0,Theta,0>
               translate<StairX * Feet, Y * Feet, StairZ * Feet>
               }               

       #local Top = < 2.9 * Feet , 4 * Feet, 0 * Feet>;
       #local Top = vaxis_rotate(Top,<0,1,0>,Theta);
       #local Top = Top + <StairX * Feet, Y * Feet, StairZ * Feet>;
       #local Bottom = < 2.9 * Feet , 4 * Feet, 0 * Feet>;
       #local Bottom = vaxis_rotate(Bottom,<0,1,0>,Theta+15);
       #local Temp1 = (Theta+15) * pi / 180;
       #local Temp = Height - (K * Temp1);

       #local Bottom = Bottom + <StairX * Feet, Temp * Feet, StairZ * Feet>;

       sphere_sweep {
                      linear_spline                // alternative spline curves
                      2,                            // number of specified sphere positions
                      Top, .2 * Feet                // position, radius
                      Bottom, .2 * Feet                 // ...
                      tolerance 0.001             // optional
                      texture{T_Copper_2B}
                      no_shadow
                    } 
             
       #local Theta = Theta + 15;
   #end 

#end //macro

         

#declare House = 
union{
   #difference{
              plane{ y,8 * Feet 
                    material{HouseMaterial} 
                    } 

              cylinder{<0 * Feet, 7.9 * Feet> ,  <0 * Feet, 8.1 * Feet>,  3.3 * Feet //3.3=2.7
                        open
                        hollow
                        material{HouseMaterial} 
                        translate<StairX * Feet, 0 * Feet, StairZ * Feet>
                       }  
              prism {
                      linear_sweep
                      7.9 * Feet, // sweep the following shape from here ...
                      8.1 * Feet, // ... up through here
                      7, // the number of points making up the shape ...
                     <6 * Feet,10 * Feet>, 
                     <-6 * Feet,10 * Feet>, 
                     <-10 * Feet,0 * Feet>, 
                     <-6 * Feet,-10 * Feet>, 
                     <6 * Feet, -10 * Feet>,
                     <10 * Feet,0 * Feet>, 
                     <6 * Feet,10 * Feet>
                     pigment { color rgbt<1, 1, 1, 1> }
                     hollow
                    }     
    }//end difference    

   difference{
               cone { <0 * Feet,   8 * Feet, 0 * Feet>, 23.0 * Feet,
                     <0 * Feet,  23 * Feet, 0 * Feet>, 20.0 * Feet
                     open
                     inverse
                     pigment {  image_map {
                                            jpeg "erise1.jpg" 
                                            map_type 2   
                                            interpolate 2     
                                            once           
                                           } scale <5,8,1> rotate<0,-20,0>
                              }
                                  
                     hollow
               }
               
               sphere_sweep {
                             linear_spline                // alternative spline curves
                             6,                            // number of specified sphere positions
                             <  0.0 * Feet, 14.0 * Feet,   19.0 * Feet>, 6.5 * Feet  // 6 - 6.5
                             <  0.0 * Feet, 15.0 * Feet,   26.0 * Feet>, 6 * Feet 
                             <  5.0 * Feet, 17.0 * Feet,   28.0 * Feet>, 6 * Feet
                             <  10.0 * Feet, 20.0 * Feet,   26.2 * Feet>, 6 * Feet
                             < 25.0 * Feet, 23.0 * Feet,   20.2 * Feet>, 6 * Feet
                             < 29.0 * Feet, 25.0 * Feet,   0 * Feet>, 6 * Feet
                             tolerance 0.001             // optional
                             texture{T_Stone5}
                             finish{phong 0 }
                             hollow
                            } 

   } //end difference
    
  sphere_sweep {
          linear_spline                // alternative spline curves
          11,                            // number of specified sphere positions
          <  -5 * Feet, 14.0 * Feet,   20.0 * Feet>, .3 * Feet                
          <  -5 * Feet, 14.0 * Feet,   22.0 * Feet>, .3 * Feet                
          <  -6 * Feet, 14.0 * Feet,   22.0 * Feet>, .3 * Feet                
          <  -5 * Feet, 14.0 * Feet,   22.0 * Feet>, .3 * Feet               
          <  -5 * Feet, 15.0 * Feet,   26.0 * Feet>, .3 * Feet                
          <  -6 * Feet, 15.0 * Feet,   26.0 * Feet>, .3 * Feet                
          <  -5 * Feet, 15.0 * Feet,   26.0 * Feet>, .3 * Feet                
          <  0 * Feet, 17.0 * Feet,   30.0 * Feet>, .3 * Feet
          <  0 * Feet, 17.0 * Feet,   31.0 * Feet>, .3 * Feet
          <  0 * Feet, 17.0 * Feet,   30.0 * Feet>, .3 * Feet
          <  8 * Feet, 20.0 * Feet,   26.2 * Feet>, .3 * Feet
          tolerance 0.001
          material{HouseMaterial}
         }  

//Interior Walls

  #object{Room2 
      rotate<0,0,0>
      translate<0 * Feet, 0 * Feet, 15.5 * Feet>
      } 

//left wall and door + knob
union{      
  box{<-.1 * Feet, -1 * Feet, 0 * Feet>,  //10.77
      <.1 * Feet, 8 * Feet, 14.7 * Feet>     
       texture{pigment { crackle form <1,0,0>
                         pigment_map{
                                      [0 color rgbt <0.5, 0.5, 0.5, 0.1>]
                                      [1 color rgbt <1.0, 1.0, 1.5, 0.1>]
                                    } scale .05
                        } 
       }
       rotate<0,-21,0>
       translate<-5.5 * Feet, 0 * Feet, -14 * Feet>   //-12          
     }
       
  box{<-.2 * Feet, -1 * Feet, 4 * Feet>,  //10.77
      <.2 * Feet, 8 * Feet, 7 * Feet>     
      texture{T_Wood32 rotate <90,90,0> scale .7}                                            
      translate<-5.5 * Feet, 0 * Feet, -14 * Feet>   //-12 
     }
               
  sphere{<0.5 * Feet, 3 * Feet, 5 * Feet>,.5 * Feet
         texture{T_Copper_2B}
         translate<-5.5 * Feet, 0 * Feet, -14 * Feet>   //-12 
        }            
}
      
/*  #object{Room1 
//      pigment{Green}
      pigment{White}
      rotate<0,31,0>
      translate<-13.5 * Feet, 0 * Feet, -33 * Feet>
      }

  box{<-6 * Feet, 0 * Feet, -10 * Feet>,
      <-10 * Feet, 1 * Feet, 0 * Feet>     
         texture{pigment { crackle form <1,0,0>
                           pigment_map{
                           [0 color rgbt <0.5, 0.5, 0.5, 0.1>]
                           [1 color rgbt <1.0, 1.0, 1.5, 0.1>]
                         } scale .01
                }
          }
      } 

       
  #object{Room1 
//      pigment{Green}
      pigment{White}
      rotate<0,90,0>
      translate<-34 * Feet, 0 * Feet, -6 * Feet>
      } 
  #object{Room1
//      pigment{Green}
      pigment{White}
      rotate<0,31,0>
      translate<14 * Feet, 0 * Feet, 12 * Feet>
      } 
  #object{Room1 
//      pigment{NeonPink}
      pigment{White}
      rotate<0,-90,0>
      translate<33 * Feet, 0 * Feet, 6 * Feet>
      } */  
      
//  #object{Room1 
//      pigment{Yellow}
//      rotate<0,-27,0>
//      translate<22 * Feet, 0 * Feet, -28 * Feet>
//      } 

//Outer Wall     
   cylinder { <0 * Feet, -1 * Feet> ,  <-.1 * Feet, 8.1 * Feet>,  40 * Feet
           open
           hollow
           texture{pigment { crackle form <1,0,0>
                             pigment_map{
                             [0 color rgbt <0.5, 0.5, 0.5, 0.1>]
                             [1 color rgbt <1.0, 1.0, 1.5, 0.1>]
                           } scale .02
                  }
            } 

    } 

//Ceiling and Floor Molding
torus { 40 * Feet, .5 * Feet
           material{HouseMaterial}
           translate<0 * Feet, -1 * Feet, 0 * Feet>
         }
torus { 40 * Feet, .5 * Feet
           material{HouseMaterial}
           translate<0 * Feet, 8 * Feet, 0 * Feet>
         } 

//top ring
torus { 20 * Feet, 1 * Feet
        texture{T_Wood1 scale .5 rotate<90,0,0>}
        normal{crackle 1}
        translate<0 * Feet, 23.5 * Feet, 0 * Feet>
      } 
//floor ring
torus { 23 * Feet, .25 * Feet
        material{HouseMaterial}
        translate<0 * Feet, 8.25 * Feet, 0 * Feet>
      } 

//skylight
prism {
       linear_sweep
       7.9 * Feet, // sweep the following shape from here ...
       8.01 * Feet, // ... up through here
       7, // the number of points making up the shape ...
       <6 * Feet,10 * Feet>, 
       <-6 * Feet,10 * Feet>, 
       <-10 * Feet,0 * Feet>, 
       <-6 * Feet,-10 * Feet>, 
       <6 * Feet, -10 * Feet>,
       <10 * Feet,0 * Feet>, 
       <6 * Feet,10 * Feet>  
        texture {
                pigment { color rgbf<.9, .9, .9, .3> }
                finish {
                        specular 1
                        roughness 0.001
                        ambient 0
                        diffuse 0
                       }   
                }      
}

//right floor
prism {
        linear_sweep
        -.99 * Feet, // sweep the following shape from here ...
        -.98 * Feet, // ... up through here
        5, // the number of points making up the shape ...
        <-6 * Feet,10* Feet>, 
        <-6 * Feet,43 * Feet>, 
        < 6 * Feet,43 * Feet>, 
        < 6 * Feet,10 * Feet>, 
        <-6 * Feet,10 * Feet> 
        pigment { Black} //T_Stone43
        }

#declare X = -4.5;
#while (X <10)
  #declare Z = 11;
  #while (Z < 40)           
    box{<-1,-1,-1>,<1,1,1>
        texture{T_Stone43 scale 2}
        scale<1 * Feet, .1 * Feet, 1* Feet>
        translate<X * Feet, -1 * Feet, Z * Feet>
    }                                           
    #declare Z = Z + 2.1; //+2 - 2.1
  #end
#declare X = X + 2.1;
#end
    

//left floor
prism {
        linear_sweep
        -.99 * Feet, // sweep the following shape from here ...
        -.98 * Feet, // ... up through here
        5, // the number of points making up the shape ...
        <-6 * Feet,10 * Feet>, 
        <-6 * Feet,43 * Feet>, 
        <-100 * Feet,43 * Feet>, 
        <-10 * Feet,0 * Feet>, 
        <-6 * Feet,10 * Feet>
        texture{pigment { gradient x
                          pigment_map{
                                      [0 color rgbt <1.0, 1.0, 1.0, 0.0>]
                                      [0.5 color rgbt <0.55, 0.09, 0.09, 0.0>]
                                      [1.0 color rgbt <0.55, 0.09, 0.09, 0.0>]
                                     } scale .5
                        }
        } 
        texture{pigment { gradient z
                          pigment_map{
                                      [0 color rgbt <1.0, 1.0, 1.0, 0.5>]
                                      [0.5 color rgbt <0.55, 0.09, 0.09, 0.5>]
                                      [1.0 color rgbt <0.55, 0.09, 0.09, 0.5>]
                                     } scale .5
                        }
        }
        normal{bumps 5 scale .01}
}    

//Center Floor
prism {
       linear_sweep
       -.99 * Feet, // sweep the following shape from here ...
       -.98 * Feet, // ... up through here
       7, // the number of points making up the shape ...
       <6 * Feet,10 * Feet>, 
       <-6 * Feet,10 * Feet>, 
       <-10 * Feet,0 * Feet>, 
       <-6 * Feet,-10 * Feet>, 
       <6 * Feet, -10 * Feet>,
       <10 * Feet,0 * Feet>, 
       <6 * Feet,10 * Feet>  
        texture{pigment { gradient x
                          pigment_map{
                                      [0 color rgbt  <.5, .5, .5, 0.0>]
                                      [.5 color rgbt <.7, .7, .7, 0.0>]
                                      [1 color rgbt  <1., 1., 1., 0.0>]
                                     } scale .8
                        }scale .05
        } 
        texture{pigment { gradient z
                          pigment_map{
                                      [0 color rgbt  <.5, .5, .5, 0.5>]
                                      [.5 color rgbt <.7, .7, .7, 0.5>]
                                      [1 color rgbt  <1., 1., 1., 0.5>]
                                    } scale .08
                        }
        }

}

//picture 
//  box{<-6 * Feet, -4 * Feet, -.1 * Feet>,<6 * Feet, 4 * Feet, .1 * Feet>
  box{<-1 * Feet , -1 * Feet , -1 * Feet >,<1 * Feet , 1 * Feet , 1 * Feet>
  pigment{Red}
      pigment {  image_map {
                             gif "picture.gif" 
                             map_type 0   
                             interpolate 2     
                             once           
                            } scale <.3,.3,1>
               }             
      
      scale<12 , 8 , .2 >
      translate<-6 * Feet, -4 * Feet, -.1 * Feet>
      rotate<0,-20,0>                                       
      translate<-13 * Feet, 3.6 * Feet, 37.5 * Feet>
      } 

hollow
} //end union House
 

//door molding
torus { 7 * Feet, .5 * Feet
          rotate<90,90,0>
           material{HouseMaterial}
           scale <1 * Feet, 1.5 * Feet, 4 * Feet> 
           translate<-5.5 * Feet, 2.8 * Feet, 6.7 * Feet>
           translate<0 * Feet, -20 * Feet, 15.5 * Feet>
         }
