#declare Lamp =
union{
   difference{
      sphere{<0,0,0>, 1.5 * Feet} 
      plane{y, 0.7 * Feet}
      rotate<180,0,0>
      hollow
      texture { T_Chrome_5D }
      translate<0,8 * Feet,0>
   }
   light_source { < 0 * Feet,   0 * Feet, 0 * Feet> 
               color White
               circular
               area_light
              <2 * Feet, 0, 0> <0, 0, 2 * Feet> // lights spread out across this distance (x * z)
               2, 2                // total number of lights in grid (4x*4z = 16 lights)
               adaptive 0          // 0,1,2,3...
               jitter              // adds random softening of light
               fade_distance 10 * Feet
               fade_power 2
               orient                              
               translate <0 * Feet, 7.7 * Feet, 0 * Feet>
             } 

   difference{
      sphere{<0,0,0>, 1 * Feet} 
      plane{y,0.5 * Feet}
      texture{T_Chrome_5D}
/*      finish {  
               brilliance 10        
               phong 0.1
               phong_size 200
               metallic
              } */
   }
} 

#macro MakeLamp()
#local LampX = -22;
#local LampZ = 32;

   #local K = .3 / pi;
   #local Height = -21.5;
   #local Theta = 0;
   #local Theta1 = Theta * pi / 180;
   #local X = LampX + .3; 
   #local Z = LampZ + .3;     
   #while (Theta < 360 * 10)
       #local Theta1 = Theta * pi / 180;
       #local Y = Height - (K * Theta1);

       #local Top = < .3 * Feet , 7 * Feet, 0 * Feet>;
       #local Top = vaxis_rotate(Top,<0,1,0>,Theta);
       #local Top = Top + <LampX * Feet, Y * Feet, LampZ * Feet>;
       #local Bottom = < .3 * Feet , 7 * Feet, 0 * Feet>;
       #local Bottom = vaxis_rotate(Bottom,<0,1,0>,Theta+15);
       #local Temp1 = (Theta+15) * pi / 180;
       #local Temp = Height - (K * Temp1);

       #local Bottom = Bottom + <LampX * Feet, Temp * Feet, LampZ * Feet>;

       sphere_sweep {
                      linear_spline                // alternative spline curves
                      2,                            // number of specified sphere positions
                      Top, .2 * Feet                // position, radius
                      Bottom, .2 * Feet                 // ...
                     tolerance 0.001             // optional
                     texture{T_Chrome_5D}
                    //no_shadow
                    } 
             
       #local Theta = Theta + 15;
   #end 
#end //make lamp 
    
#object{Lamp
        translate<-22 * Feet, -21.5 * Feet, 32 * Feet>
//        translate<-13 * Feet, -21.5 * Feet, 18 * Feet>

}

MakeLamp()

light_source { <200 * Feet, 800 * Feet, -200 * Feet> color rgb<3,3,3> }
               

#declare Light =
   sphere{<0,0,0>,.5 * Feet
          pigment{Black}
   }


//picture light

light_source {
  0*x                     // light's position (translated below)
  color rgb <3,3,3>       
  spotlight              
  point_at <-11 * Feet, -18 * Feet, 50 * Feet>      // direction of spotlight
  radius 110                // hotspot (inner, in degrees)
  tightness 25            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 120               // intensity falloff radius (outer, in degrees)
  looks_like {Light}
  translate <-11 * Feet, -12 * Feet, 25 * Feet> // <x y z> position of light
}


//kitchen light 1

light_source {
  0*x                     // light's position (translated below)
  color rgb <.3,.3,.3>       
  looks_like {Light}
               circular
               area_light
              <2 * Feet, 0, 0> <0, 0, 2 * Feet> // lights spread out across this distance (x * z)
               2, 2                // total number of lights in grid (4x*4z = 16 lights)
               adaptive 0          // 0,1,2,3...
               jitter              // adds random softening of light
               fade_distance 5 * Feet  //15
               fade_power 2 
               orient                            
  translate <0 * Feet, -12 * Feet, 15 * Feet> // <x y z> position of light
}
 

// book case light

light_source {
  0*x                     // light's position (translated below)
  color White * 1       // light's color 1.5
  spotlight               // this kind of light source
  point_at <-40 * Feet, -16 * Feet, 5 * Feet>      // direction of spotlight
  radius 160                // hotspot (inner, in degrees)
  tightness 25            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 170               // intensity falloff radius (outer, in degrees)
  looks_like {Light}
  translate <-15 * Feet, -12 * Feet, 19 * Feet> // <x y z> position of light
}


