
global_settings { assumed_gamma 2.2 }

#include "colors.inc "
#include "woods.inc"    
#include "glass.inc"     
#include "shippulley.inc"    
#include "Lbshipcomp1.inc"
#include "shipsky.inc" 
#include "ropecoil.inc"   
#include "Shipatdoc.inc"
#include "Shipatsea.inc"
#include "shipoutline2.inc"  
#include "lbshipdock1.inc" 
#include "draftlamp2.inc"        

camera{ location<-5,5,-305>  look_at <5,0,0>  } 
background{color rgb<0,.8,.9>*.9}  
light_source{<-0,10,-280>color White*1.1  }  
light_source{<0,300,-290>color White*1 shadowless }
 
                          
  
#declare GrassBlade =
 difference{
cone { <0, 1, 0>, 0.0, <0, -1, 0>, 1.0 } 
cone { <0, 1, 0>, 0.0, <0, -1, 0>, 1.0 translate -.01*z}
 pigment{ color Green*.5  } 
 scale <.02,1,.02>  
rotate 10*x
}  

 
#declare Grasspatch =
union{
#declare Count=0;
 #while (Count < 100)
  object { GrassBlade translate x*.5*cos(Count)*Count/300 rotate 20*cos(Count)*z rotate 20*sin(Count)*x
  
  translate z*10*sin(Count)  translate sin(Count)*y
   
  rotate -10*x
  translate -30*x  scale <5,1,5>  translate -37*y
}
  #declare Count=Count+1;
 #end  
  }   
 
   
#declare Count = 0;
 #while (Count <1000)
  difference{
 object { Grasspatch  translate x*.1*cos(Count)*Count 
  
     rotate mod(Count,10)*y     translate 75*x  translate -45*z
 
} 
 prism {                                
  linear_sweep  
  
  -1000,        
   1000,         
  15,          
  
   < -150,-50>,  <50,-50>, < 50,50>, < -150,50>,<-140,45>,
   <-142,40>,<-132,30>, < -142,20>, < -130,10>,<-128,0>,
   <-127.2,-10>,<-127,-20>, < -126,-30>, < -125,-40>,
   
   
    <-150,  -50>
  

       translate 100*x    scale <1,1,2>}   
     
     
      
 scale <2,1,1.2> translate -10*x
 
  }
  #declare Count=Count+1;
 #end  
  
  
 
   
#declare DandPetal = 
sphere { <0, -0. 0>, 0.2 scale <3,.2,.1> pigment {color Yellow} rotate -5*z}    
 
#declare DandyBlossom =  
union{ 
 union{
union{
#declare Count=0;
 #while (Count < 30)
  object { DandPetal rotate 90*x rotate 12*Count*y  }
  #declare Count=Count+1;
 #end  
       
 }      
union{
#declare Count=0;
 #while (Count < 30)
  object { DandPetal rotate -1*z scale <.9,1,1> rotate 90*x rotate 12*Count*y  rotate 2*y }
  #declare Count=Count+1;
 #end  
 translate .02*y      
 }    
union{
#declare Count=0;
 #while (Count < 30)
  object { DandPetal rotate -2*z scale <.8,1,1> rotate 90*x rotate 12*Count*y  rotate 3*y }
  #declare Count=Count+1;
 #end  
 translate .04*y      
 }   
union{
#declare Count=0;
 #while (Count < 30)
  object { DandPetal rotate -3*z scale <.6,1,1> rotate 90*x rotate 12*Count*y  rotate 3*y }
  #declare Count=Count+1;
 #end  
 translate .06*y      
 }  
union{
#declare Count=0;
 #while (Count < 15 )
  object { DandPetal rotate -4*z  scale <.4,1,1> rotate 90*x rotate 24*Count*y  rotate 3*y }
  #declare Count=Count+1;
 #end  
 translate .08*y      
 }  

 union{
#declare Count=0;
 #while (Count < 15 )
  object { DandPetal rotate -5*z scale <.2,1,1> rotate 90*x rotate 24*Count*y  rotate 4*y }
  #declare Count=Count+1;
 #end  
 translate .1*y      
 }
  union{
#declare Count=0;
 #while (Count < 15 )
  object { DandPetal rotate -5*z scale <.2,1,1> rotate 90*x rotate 24*Count*y  rotate 4*y }
  #declare Count=Count+1;
 #end  
 translate .1*y      
 }   
 scale <1,2,1> rotate -10*x}
 
  
 } 
         
 
 
 
 
    
          
       
      

#declare Dandypatch =
union{ 
object {DandyBlossom  translate -90*z   translate -85*x  rotate -10*x translate -10*y}


object {DandyBlossom  translate -95*z   translate -92*x  rotate -10*x translate -10*y}


object {DandyBlossom  translate -90*z   translate -92*x  rotate -10*x translate -10*y}
union{ 

object {DandyBlossom  translate -95*z   translate -82*x  rotate -10*x translate -10*y}

object {DandyBlossom  translate -87*z   translate -92*x  rotate -10*x translate -10*y} 
  translate 5*x translate -5*z       }
union{ 

object {DandyBlossom  translate -95*z   translate -82*x  rotate -10*x translate -10*y}

object {DandyBlossom  translate -87*z   translate -92*x  rotate -10*x translate -10*y} 
  translate -5*x translate -5*z       }  translate -2*y}

     union{
   
object {Dandypatch translate 20*z translate -10*x translate -2*y} 
object {Dandypatch translate -10*z translate 10*x translate -7.5*y} 
object {Dandypatch translate 41*z translate -10*x translate -1*y} 
object {Dandypatch translate 10*z translate 0*x translate -4*y} 
object {Dandypatch translate 0*z translate 0*x translate -6*y }   
object {Dandypatch translate 60*z translate -20*x} 
object {Dandypatch translate 55*z  translate -10*x} 
translate -1*y}       
       



#declare FS_Glass1 =
finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.025
    roughness 0.003
    
}

#declare TS_Glass1 =
texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
    finish { FS_Glass1 }
}

object {Shipsky translate 500*y}
#declare P_WoodGrain1A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}

#declare P_WoodGrain1B =
pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}

#declare P_WoodGrain2A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.15, .15, 1>
}

#declare P_WoodGrain2B =
pigment {
    wood  
    turbulence <0.1, 0.35, 0.1>
    octaves 5
    lambda 3.25
    scale <0.25, .25, 1>
    rotate <5, 10, 5>
    translate -x*2
}      
      
      
      
#declare M_Wood1A =
color_map { 
    [0.0, 0.1 color rgb <0.88, 0.60, 0.40> *1.5
              color rgb <0.88, 0.60, 0.40>*1.5]
    [0.1, 0.9 color rgb <0.88, 0.60, 0.40>*1.5
              color rgb <0.60, 0.30, 0.20>*1.5]
    [0.9, 1.0 color rgb <0.60, 0.30, 0.20>*1.5
              color rgb <0.60, 0.30, 0.20>*1.5]
}
#declare M_Wood1B = 
color_map { 
    [0.0, 0.1 color rgbt <0.55, 0.32, 0.20, 0.100> 
              color rgbt <0.55, 0.32, 0.20, 0.500>]
    [0.1, 0.2 color rgbt <0.55, 0.35, 0.20, 0.650>
              color rgbt <0.88, 0.60, 0.40, 0.975>]
    [0.2, 0.3 color rgbt <0.88, 0.60, 0.40, 0.975>
              color rgbt <0.60, 0.30, 0.20, 1.000>]
    [0.3, 0.4 color rgbt <0.60, 0.30, 0.20, 0.100> 
              color rgbt <0.60, 0.30, 0.20, 0.500>]
    [0.4, 0.9 color rgbt <0.60, 0.30, 0.20, 0.650>
              color rgbt <0.88, 0.60, 0.40, 0.975>]
    [0.9, 1.0 color rgbt <0.88, 0.60, 0.40, 0.975>
              color rgbt <0.55, 0.32, 0.20, 1.000>]
}  


#declare M_Wood1Aa =
color_map { 
    [0.0, 0.1 color rgb <0.88, 0.60, 0.40>*.8 
              color rgb <0.88, 0.60, 0.40>*.8]
    [0.1, 0.9 color rgb <0.88, 0.60, 0.40>*.8
              color rgb <0.60, 0.30, 0.20>*.8]
    [0.9, 1.0 color rgb <0.60, 0.30, 0.20>*.8
              color rgb <0.60, 0.30, 0.20>*.8]
}
#declare M_Wood1Bb = 
color_map { 
    [0.0, 0.1 color rgbt <0.55, 0.32, 0.20, 0.100> 
              color rgbt <0.55, 0.32, 0.20, 0.500>]
    [0.1, 0.2 color rgbt <0.55, 0.35, 0.20, 0.650>
              color rgbt <0.88, 0.60, 0.40, 0.975>]
    [0.2, 0.3 color rgbt <0.88, 0.60, 0.40, 0.975>
              color rgbt <0.60, 0.30, 0.20, 1.000>]
    [0.3, 0.4 color rgbt <0.60, 0.30, 0.20, 0.100> 
              color rgbt <0.60, 0.30, 0.20, 0.500>]
    [0.4, 0.9 color rgbt <0.60, 0.30, 0.20, 0.650>
              color rgbt <0.88, 0.60, 0.40, 0.975>]
    [0.9, 1.0 color rgbt <0.88, 0.60, 0.40, 0.975>
              color rgbt <0.55, 0.32, 0.20, 1.000>]
}  
    
#declare T_Wood1 =
    texture { pigment { P_WoodGrain1A  color_map { M_Wood1A }}}
    texture { pigment { P_WoodGrain1B  color_map { M_Wood1B }}}  


#declare T_Wood1a =
    texture { pigment { P_WoodGrain1A  color_map { M_Wood1Aa }}}
    texture { pigment { P_WoodGrain1B  color_map { M_Wood1Bb }}}    
  
 #declare M_Wood1A =
color_map { 
    [0.0, 0.1 color rgb <0.59, 0.41, 0.31>
              color rgb <0.92, 0.78, 0.62>]
              
    [0.1, 0.9 color rgb <0.6, 0.4, 0.2>
              color rgb <0.8, 0.7, 0.60>]          
             
              
    
}
#declare M_Wood1B = 
color_map { 
    [0.0, 0.2 color rgbf <0.6, 0.4, 0.2, 0.100>*2 
              color rgbf <0.55, 0.55, 0.55, 0.500>]
    [0.2, 0.7 color rgbf <0.4, 0.35, 0.2, 0.650>
              color rgbf <0.7, 0.6, 0.4, 0.975>]
    [0.7, 1 color rgbf <0.6, 0.60, 0.6, 0.975>
              color rgbf <0.30, 0.30, 0.20, 1.000>*2]
    
}            


#declare T_WoodDock =
    texture { pigment { P_WoodGrain1A  color_map { M_Wood1A }}}
    texture { pigment { P_WoodGrain1B  color_map { M_Wood1B }}}
 
#declare Floorboard  =  box { <-1, -1, -1>, <1, 1, 1>  scale <10,.1,.5> }
#declare Floor =
union{   
 box { <-1, -1, -1>, <1, 1, 1>  scale <10,.02,10> texture{T_Wood23 rotate 90*y} }
object {Floorboard texture{T_Wood23 rotate 90*y}} 
object {Floorboard translate 1.05*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate 2.1*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate 3.15*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate 4.2*z texture{T_Wood23 rotate 90*y}}                            
object {Floorboard translate 5.25*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate 6.3*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate 7.35*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate 8.4*z texture{T_Wood23 rotate 90*y}}  
object {Floorboard translate 9.45*z texture{T_Wood23 rotate 90*y}}                                  
                                                                
object {Floorboard translate -1.05*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate -2.1*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate -3.15*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate -4.2*z texture{T_Wood23 rotate 90*y}}                            
object {Floorboard translate -5.25*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate -6.3*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate -7.35*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate -8.4*z texture{T_Wood23 rotate 90*y}}
object {Floorboard translate -9.45*z texture{T_Wood23 rotate 90*y}}  

} 
                              

#declare Beam  = box { <-1, -1, -1>, <1, 1, 1> scale <10,.25,.25> } 


#declare Office =
union{  
box { <-1, -1, -1>, <1, 1, 1> 
  
texture {pigment {color White*1.5}}
 scale <10,10,.1> finish {crand .025} translate -10*z}
difference{
box { <-1, -1, -1>, <1, 1, 1> 
texture {pigment {color White*.8}}

 
 scale <10,10,.1> finish {crand .025}}
box { <-1, -1, -1>, <1, 1, 1> texture {pigment {color White}} scale <4,5,100> finish {crand .025} translate .5*y }  
box { <-1, -1, -1>, <1, 1, 1> texture {pigment {color White}} scale <1.5,5,100> finish {crand .025} translate .5*y translate 7.5*x } 
box { <-1, -1, -1>, <1, 1, 1> texture {pigment {color White}} scale <1.5,5,100> finish {crand .025} translate .5*y translate -7.5*x } 

translate 10*z }    

#declare T_WindowFrame =  
T_Wood1a
union{  
box { <-1, -1, -1>, <1, 1, 1> scale <.2,4.9,.25> translate 4*x translate .5*y  texture {T_WindowFrame rotate 90*y rotate 90*z}} 
box { <-1, -1, -1>, <1, 1, 1> scale <.2,4.9,.25> translate -4*x translate .5*y  texture {T_WindowFrame rotate 90*y rotate 90*z}} 
box { <-1, -1, -1>, <1, 1, 1> scale <.2,4.9,.25> translate -9*x translate .5*y  texture {T_WindowFrame rotate 90*y rotate 90*z}} 
box { <-1, -1, -1>, <1, 1, 1> scale <.2,4.9,.25> translate -6*x translate .5*y  texture {T_WindowFrame rotate 90*y rotate 90*z}} 
box { <-1, -1, -1>, <1, 1, 1> scale <.2,4.9,.25> translate 6*x translate .5*y  texture {T_WindowFrame rotate 90*y rotate 90*z}} 
box { <-1, -1, -1>, <1, 1, 1> scale <.2,4.9,.25> translate 9*x translate .5*y  texture {T_WindowFrame rotate 90*y rotate 90*z}} 
box { <-1, -1, -1>, <1, 1, 1> scale <4.2,.2,.25>  translate -4.25*y  texture {T_WindowFrame rotate 90*y }} 
box { <-1, -1, -1>, <1, 1, 1> scale <4.2,.2,.25>  translate 5.25*y  texture {T_WindowFrame rotate 90*y }} 
box { <-1, -1, -1>, <1, 1, 1> scale <1.7,.2,.25> translate -7.5*x translate -4.25*y  texture {T_WindowFrame rotate 90*y }} 
box { <-1, -1, -1>, <1, 1, 1> scale <1.7,.2,.25> translate -7.5*x translate 5.25*y  texture {T_WindowFrame rotate 90*y }} 
box { <-1, -1, -1>, <1, 1, 1> scale <1.7,.2,.25> translate 7.5*x translate -4.25*y  texture {T_WindowFrame rotate 90*y }} 
box { <-1, -1, -1>, <1, 1, 1> scale <1.7,.2,.25> translate 7.5*x translate 5.25*y  texture {T_WindowFrame rotate 90*y }}  
box { <-1, -1, -1>, <1, 1, 1> texture {TS_Glass1} interior {ior 1.71} scale <4,5,.01>  translate .5*y }  
box { <-1, -1, -1>, <1, 1, 1> texture {TS_Glass1} interior {ior 1.71} scale <1.5,5,.01>  translate .5*y translate 7.5*x } 
box { <-1, -1, -1>, <1, 1, 1> texture {TS_Glass1} interior {ior 1.71} scale <1.5,5,.01>  translate .5*y translate -7.5*x } 
 translate 10*z     }
box { <-1, -1, -1>, <1, 1, 1> 
 
texture {pigment {color White*1.25}} 

scale <.1,10,10> finish {crand .015}  translate 10.25*x}
box { <-1, -1, -1>, <1, 1, 1>
 
texture {pigment {color White*1.25}} 
scale <.1,10,10> finish {crand .025}  translate -10.25*x}
//ceiling
box { <-1, -1, -1>, <1, 1, 1> 
texture {pigment {color White*1.75}}
scale <10,.1,10>finish {crand .025}  translate 6.25*y}
object {Beam texture {T_Wood1a rotate 90*y} translate 6*y translate 10*z}
object {Beam texture {T_Wood1a rotate 90*y } translate -5*y translate 10*z}  
object {Beam texture {T_Wood1a rotate 90*y} translate 6*y translate -10*z}
object {Beam texture {T_Wood1a rotate 90*y } translate -5*y translate- 10*z}  
object {Beam texture {T_Wood1a rotate 90*y rotate 2*z translate 2*y }rotate 90*z  translate 5*x translate 10*z}
object {Beam texture {T_Wood1a  rotate 90*y rotate -2*z }rotate 90*z  translate -5*x translate 10*z}
object {Beam  texture {T_Wood1a rotate 90*y rotate -2*z translate -1*y }rotate 90*z  translate 10*x translate 10*z}
object {Beam  texture {T_Wood1a  rotate 90*y  rotate -2*z translate 1*y }rotate 90*z  translate -10*x translate 10*z}
object {Beam  texture {T_Wood1a rotate 90*y rotate -2*z translate -1*y }rotate 90*z  translate 10*x translate -10*z}
object {Beam  texture {T_Wood1a  rotate 90*y  rotate -2*z translate 1*y }rotate 90*z  translate -10*x translate -10*z}
object {Beam texture {T_Wood1a rotate 90*y rotate 2*z translate 2*y }rotate 90*z  translate 5*x translate -10*z}
object {Beam texture {T_Wood1a  rotate 90*y rotate -2*z }rotate 90*z  translate -5*x translate -10*z}
object {Beam rotate 90*y texture {T_Wood1} translate 5*x translate 6*y }
object {Beam rotate 90*y texture {T_Wood1} translate -5*x translate 6*y } 
object {Beam rotate 90*y texture {T_Wood1} translate 10*x translate 6*y }
object {Beam rotate 90*y texture {T_Wood1} translate -10*x translate 6*y }
object {Beam rotate 90*y texture {T_Wood1} translate 10*x translate -5*y }
object {Beam rotate 90*y texture {T_Wood1} translate -10*x translate -5*y }
object {Floor  rotate 90*y translate -5.2*y}
}

object {Office scale 10  translate -210*z }   
      
#declare Triangle45 =

difference{

prism {                                
  linear_sweep  
  linear_spline 
  0,         
   0.001,      
  4,         
  
  < -1, 0>, < 0,  0>, < 0, 1>, < -1.0,  0>
} 

prism {                                
  linear_sweep  
  linear_spline 
  -10,         
   10,      
  4,         
   <-.66621, .15>, < -.15, .15>, < -.15, .66621>, <-.6621,  .15>
   
} 


 texture{pigment {color Green} finish{irid{ .1}}}
} 





#declare Triangle30 =

difference{


prism {                                
  linear_sweep  
  linear_spline 
  0,         
   0.001,      
  4,         
  
  < -1.732, 0>, < 0,  0>, < 0, 1>, < -1.732,  0>
} 


prism {                                
  linear_sweep  
  linear_spline 
  -10,         
   10,      
  4,         
  
  < -1.17, .15>, <-.15,  .15>, < -.15, .74>, < -1.17,  .15>
  
} 
  

texture{pigment {color Green} finish{irid{ .1}}}
}


#declare Compass2 =
union{
cylinder { <0, 1, 0>, <0, 1.5, 0>, .2  texture {T_Chrome_5A} finish {crand .2}} 
cylinder { <0, .25, 0>, <0, 1, 0>, .05 } 

#difference{

 cylinder { <0, .65, -.2>, <0, .65,.2>, .3 }
 cylinder { <0, .65, -5>, <0, .65, 5>, .25 }
 
  
 }   
 cylinder { <0, .2, -.2>, <0, .2,.2>, .15 }
 
 sphere { <-.075, -.085, 0>, 0.1 scale <1,20,1> rotate -10*z }
  sphere { <.075, -.085, 0>, 0.1 scale <1,20,1> rotate 10*z }
  
 cylinder { <-.05, -1, 0>, <.05, -1,0>, .25 } 
 cylinder { <-.5, -1, 0>, <.5, -1,0>, .03 }  
 cylinder { <-.55, -1, 0>, <-.5, -1,0>, .05 }
 cylinder { <.5, -1, 0>, <.55, -1,0>, .05 }
 cone { <0, -4, 0>, 0.02, <0, -4.25, 0>, 0 translate -.70*x  translate .5*y pigment {color Black}} 
 cone { <0, -4, 0>, 0.02, <0, -4.25, 0>, 0 translate .70*x  translate .5*y } 
 
 cylinder { <0, -4, -.02>, <0, -4,.02>, .125 translate .625*x translate .9*y }
 cylinder { <0, -4, -.02>, <0, -4,.02>, .125 translate -.625*x translate .9*y translate  -.2*z }
 cylinder { <0, -4, -.03>, <0, -4,.03>, .02 translate -.625*x translate .9*y translate  -.2*z pigment {color Gray60} }
texture {T_Chrome_5A}}
 
 
 #declare Triruler =
union{  

prism {                                
  linear_sweep  
 
  -5,         
   5,        
  4,           
 
  < -.5, 0>, < 0,  (1/1.7320)>, < .5, -0>, < -.5,  0>  
 
  
} 
#declare Line =

box { <-1, -1, -1>, <1, 1, 1> scale <.01,.01,.1> rotate -45*y  translate .1*z translate .45*x  pigment {color Black}}
 
object {Line}
object {Line translate .2*y}
object {Line translate .4*y}
object {Line translate .6*y}
object {Line translate .8*y} 
object {Line translate 1*y}
object {Line translate 1.2*y}
object {Line translate 1.4*y}
object {Line translate 1.6*y}
object {Line translate 1.8*y}
object {Line translate 2*y}
object {Line translate 2.2*y}
object {Line translate 2.4*y} 
object {Line translate 2.6*y}
object {Line translate 2.8*y}
object {Line translate 3*y}
object {Line translate 3.2*y}
object {Line translate 3.4*y} 
object {Line translate 3.6*y}
object {Line translate 3.8*y}
object {Line translate 4*y}
object {Line translate 4.2*y}
object {Line translate 4.4*y} 
object {Line translate 4.6*y}
object {Line translate 4.8*y}     
object {Line translate -.2*y}
object {Line translate -.4*y}
object {Line translate -.6*y}
object {Line translate -.8*y} 
object {Line translate -1*y}
object {Line translate -1.2*y}
object {Line translate -1.4*y}
object {Line translate -1.6*y}
object {Line translate -1.8*y}
object {Line translate -2*y}
object {Line translate -2.2*y}
object {Line translate -2.4*y} 
object {Line translate -2.6*y}
object {Line translate -2.8*y}
object {Line translate -3*y}
object {Line translate -3.2*y}
object {Line translate -3.4*y} 
object {Line translate -3.6*y}
object {Line translate -3.8*y}
object {Line translate -4*y}
object {Line translate -4.2*y}
object {Line translate -4.4*y} 
object {Line translate -4.6*y}
object {Line translate -4.8*y}     

pigment {color White*1.65}   rotate 90*z rotate 180*y  
 }

#declare Frenchcurve =  
union{  

cylinder { <0, 0, -.02>, <0, 0, .02>, .25 translate -.75*x }
cylinder { <0, 0, -.02>, <0, 0,.02>, .2 translate .8*x scale <1,1.5,1>rotate 10*z translate -.1*y  }
cylinder { <0, 0, -.02>, <0, 0,.02>, .25  translate -.5*y  translate -.25*x}
     
difference{
cylinder { <0, 0, -.02>, <0, 0,.02>, 1 }
cylinder { <0, 0, -1>, <0, 0,1>, .7 }
cylinder { <0, 0, -.02>, <0, 0,.02>, .25 scale <1.,1,2> translate -.3*y  translate -.42*x} 
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10*y }
}    
}
     
#declare Tablebracketpt  = 
union{  

cylinder { <0, -7.5, -.05>, <0,-7.5, .05>, .75 }
box { <-1, -1, -1>, <1, 1, 1> scale <.75,7.5,.1>}
}    

#declare Tablebracket = 
union{  
box { <-1, -1, -1>, <1, 1, 1>scale<.3,.02,.2>     pigment {color Gray30} finish {crand .5} rotate 10*z translate 1.5*y}

difference{
cylinder { <0, 0, -.1>, <0, 0, .1>, .2   }
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10*y}  
 pigment {color Gray30} finish {crand .5}  rotate 10*z  translate 1.5*y
}
difference{ 
object{Tablebracketpt }
object{Tablebracketpt scale <.6,.8,10> }
 pigment {color Gray40} finish {crand .5} scale .2}
    }

  
#declare Draftingtable =

union{ 

object {Tablebracket rotate 90*y translate 10*x translate 3*y rotate -20*x translate 3*z}
union{
cylinder { <9.7, 0, 0>, <10.3, 0, 0>, .05  pigment {color Gray30} finish {crand .5} }
sphere { <0, 0, 0>, 0.2  scale <.2,1,1> translate 10.2*x  pigment {color Gray30} finish {crand .5} } 
translate 3.0*y translate 1.9*z
}
#declare Draw =
union{
box { <-1, -1, -1>, <1, 1, 1> scale <1.4,.5,2.5> texture {T_Wood35 rotate 90*y scale 1.2}finish {reflection .1 ambient .5 brilliance 1}} 
cone { <0, 0, -2.5>, .13, <0, 0, -2.7>, .15  }
sphere { <0, 0, 0>, 0.2 scale <1,1,.25> translate -2.7*z }
 }

box { <-1, -1, -1>, <1, 1, 1>  scale <.2,3.5,.2> translate 9.8*x translate 4.8*z  translate -.5*y texture {T_Wood35 rotate 90*x scale 1.2}finish {reflection .1 ambient .5 brilliance 1}}  
box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2> translate -9.8*x translate 4.8*z translate -.5*y texture {T_Wood35 rotate 90*x scale 1.2}finish {reflection .1 ambient .5 brilliance 1}}
box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2>translate 9.8*x translate -4.8*z translate -.5*y texture {T_Wood35 rotate 90*x scale 1.2}finish {reflection .1 ambient .5 brilliance 1}}
box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2>translate -9.8*x translate -4.8*z translate -.5*y   texture {T_Wood35 rotate 90*x scale 1.2}finish {reflection .1 ambient .5 brilliance 1}} 

box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2>translate 3.*x translate 4.8*z translate -.5*y  texture {T_Wood35 rotate 90*x scale 1.2}finish {reflection .1 ambient .5 brilliance 1}}
box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2>translate 3.*x translate -4.8*z translate -.5*y  texture {T_Wood35 rotate 90*x scale 1.2}finish {reflection .1 ambient .5 brilliance 1}} 
 

box { <-1, -1, -1>, <1, 1, 1> scale <10.,.15,5> translate 3*y texture {T_Wood35 rotate 90*y scale 1.2}finish {reflection .1 ambient .5 brilliance 1}}
box { <-1, -1, -1>, <1, 1, 1> scale <10.2,.05,5> translate 4*y rotate -10*x}  

 
 box { <-1, -1, -1>, <1, 1, 1> scale <1.75,1.45,2.4>*2 translate 6.25*x  translate .1*y texture {T_Wood35 rotate 90*y scale 1.2}finish {reflection .1 ambient .5 brilliance 1}} 
 box { <-1, -1, -1>, <1, 1, 1> scale <1.76,1.45,2.1>*2 translate 6.25*x  translate .1*y texture {T_Wood35  scale .5}finish {reflection .1 ambient .5 brilliance 1}} 
 
  object{Draw  scale 2 translate 6.25*x translate 1.2*y texture {T_Wood35 rotate 90*y scale 1.2}finish {reflection .1 ambient .5 brilliance 1}}
 object{Draw  scale 2 translate 6.25*x translate -1.2*y texture {T_Wood35 rotate 90*y scale 1.2}finish {reflection .1 ambient .5 brilliance 1}} 

} 

#declare DrawHandle = 
union{
torus { 0.8, 0.1 scale <1,1,.3> }
box { <-1, -1, -1>, <1, 1, 1> scale <.25,.25,.05>  translate .8*x}
box { <-1, -1, -1>, <1, 1, 1>  scale <.25,.25,.05> translate -.8*x}
  texture{T_Gold_2A}              }   
  
  
#declare Screw =
 
difference{      
sphere { <0, 0, 0>, 0.15 } 
box { <-1, -1, -1>, <1, 1, 1> scale <.02,.3,.3> translate -.25*z } 
  
  texture{T_Brass_4A}
}
#declare Draftingtable2 =

union{  

object {DrawHandle translate -4.5*x translate -5*z scale <1,1,1> translate 1.85*y}   
object {DrawHandle translate 4.5*x translate -5*z scale <1,1,1>translate 1.85*y}   
box { <-1, -1, -1>, <1, 1, 1>  scale <.2,3.5,.2> translate 9.8*x translate 4.8*z translate -.5*y texture {T_Wood35 rotate 90*z}}  
box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2> translate -9.8*x translate 4.8*z translate -.5*y texture {T_Wood35 rotate 90*z}}
box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2>translate 9.8*x translate -4.8*z translate -.5*y texture {T_Wood35 rotate 90*z} }
box { <-1, -1, -1>, <1, 1, 1> scale <.2,3.5,.2>translate -9.8*x translate -4.8*z translate -.5*y texture {T_Wood35 rotate 90*z}} 

box { <-1, -1, -1>, <1, 1, 1> scale <10,.15,5> translate 3*y}
#declare ScrewGroup =
union{
object {Screw  scale <.5,.5,1> translate -5*z translate 2.0*y translate  3.55*x}
object {Screw  scale <.5,.5,1> translate -5*z translate 1.7*y translate  3.55*x}
object {Screw  scale <.5,.5,1> translate -5*z translate 2.0*y translate  3.85*x}
object {Screw  scale <.5,.5,1> translate -5*z translate 1.7*y translate  3.85*x}
 }
object {ScrewGroup}
object {ScrewGroup translate 1.6*x} 
object {ScrewGroup translate -7.4*x}
object {ScrewGroup translate -9*x} 



box { <-1, -1, -1>, <1, 1, 1> scale <9.8,1,4.8> translate 1.9*y texture {T_Wood35 rotate 90*y scale 2}}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.7,5> translate 1.9*y translate -4.5*x texture {T_Wood35 rotate 90*y scale .5}}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.7,5> translate 1.9*y translate 4.5*x texture {T_Wood35 rotate 88*y scale .5 }}  
} 
  
  
  
    
     
     
     union{ 
object {Draftingtable
   texture {T_Wood35 scale 2 rotate 90*y } finish {reflection .1 ambient .5 brilliance 1}
 }   
 
 object {Lamp scale .2  rotate 90*y translate 7.25*y translate 2.5*z translate -2*x}
object {Compass2  scale .5 translate 16*y rotate 80*x translate 2*y translate 7*x translate -1*x translate -12.5*z }
object {Triruler scale .5 translate 4.2*y rotate -10*x translate 5*x translate -.2*y }

object {Frenchcurve    rotate 80*x translate -4*z translate 3.4*y  pigment{color Green} translate 7*x}
object {Triangle30  rotate -10*x translate 4.05*x translate 4.2*y}
object {Triangle45 rotate -10*x translate 5.5*x translate 4.2*y}
#declare Shipplan =

box { <-1, -1, -1>, <1, 1, 1> scale <6,4,.1>texture {pigment {image_map {tga "shiphullall5.tga" once  } }scale <6,4,.1>} } 


object {Shipplan  rotate 90*x  scale <2,.01,2> rotate -10*x translate 3.41*y translate -9*x translate -4*z}

translate -90*z texture {T_Wood1}  translate -13*x translate -21.5*y  

scale 2  
 rotate 1*y translate -5*x }    
 
 
 
 
#declare Shipplan2 =
  
box { <-1, -1, -1>, <1, 1, 1> scale <6,4,.1> texture {pigment {image_map {tga "Shipmastplan.tga" once  } }scale <6,4,.1>} } 


#declare Shipplan3 =
  
box { <-1, -1, -1>, <1, 1, 1> scale <4,4,.1> texture {pigment {image_map {tga "Shipend3.tga" once  } }scale <4,4,.1>} } 
union{
union{
object {Draftingtable2 texture {T_Wood35 scale 2 rotate 90*y } finish {reflection .1 ambient .5 brilliance 1}}
object {Shipplan2 rotate 90*x scale <1.5,1,1.5> translate 3.3*y  translate - 9*x translate -3*z }

translate -90*z translate 8*x translate -21.5*y scale 2}
 
object {Compbox scale .75 translate -185 *z translate 27*x translate -35*y } 
  rotate 1*y     }
      
union{ 
object {Lamp scale .2  rotate 90*y translate 7.25*y translate 2.5*z translate -3*x}
object {Shipplan3 rotate 90*x scale <1.5,1,1.5> translate 4.4*y rotate -18*x  translate -3*z}
object {Triruler scale .5 translate 4.3*y rotate -10*x translate 5*x translate -.2*y }

object {Frenchcurve scale <2,1,2>   rotate 80*x translate -4*z translate 3.45*y  pigment{color Green} translate 7*x}
object {Triangle30 scale <2,1,2>  rotate -10*x translate 6*x translate 4.15*y}

object {Draftingtable  texture {T_Wood35 scale 1 rotate 90*y } finish {reflection .1 ambient .5 brilliance 1} 
}scale 2.0  
 
  rotate 90*y translate -160*z translate 65*x    translate -43*y} 
  
  
   
  
union{ 

union{ 
    
union{ 

union{ 
union{

box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}}
box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate 1.1*y translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}}
box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate -1.1*y translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}} 
box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate -2.2*y translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}}
box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate -3.3*y translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}}
box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate -4.4*y translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}} 
box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate -5.5*y translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}}
box { <-1, -1, -1>, <1, 1, 1> scale <1,.5,12> translate -6.6*y translate -4*x translate 14*z texture {T_Wood23 rotate 90*y}}


box { <-1, -1, -1>, <1, 1, 1> scale <1,5,12> translate -4*x translate 14*z pigment {color Black} scale <.99,.9,.99> translate -3*y}

object {Drydockpt}
 scale 3 translate -10*z rotate -2*z rotate 60*y } 
object {Drydockpt scale 3 translate 70*z rotate -2*z rotate 60*y }
translate -25*x} 
object {Hull2 scale <1.25,1.25,1.25>    rotate -1*x rotate -30*y translate 10*x translate -10*y}

scale <1.0,1.5,1.5>} 
           
object {Drydockpt scale 3 translate 70*z rotate -2*z rotate 60*y }
translate -25*x} 
 rotate -90*y     translate 40*x translate -40*y    translate -30*z
}             



 #declare WaterBlue = rgb <.4,.6,.853>*.8;     

difference{
box { <-1, -1, -1>, <1, 1, 1>  scale <1000,10,500> pigment { WaterBlue*1.25 }
    normal {
      gradient x
      normal_map {
        [ 0.0 bumps 1 scale .1]
        [ 1.0 ripples 1 scale .5]
      }
        scale <10,2,2>  
        
        translate -5*z  rotate -60*z translate 5*x rotate -60*y }  translate 350*z translate -78*y rotate -2*x}
                
    box { <-1, -1, -1>, <1, 1, 1>  scale <142,1000,40> rotate 60*y 
translate -25*x
scale 1.5 translate 10*z rotate -90*y translate -40*y  
translate 115*z  translate 200*x }  }            
               
object {Shipatsea scale 10  rotate 100*y translate 600*z translate -60*x translate -2*y  }   
 
union{
object {Shiphullsolid scale .3  texture {T_Wood13 }finish {ambient .5 brilliance.5}     translate 0*x rotate 90*y  translate 12*y translate -120*z translate -99*x}    

#declare Linkpair =
union{
object {Link  } 
object {Link rotate 90*y translate 15*y }
}
#declare Straightchain =

union{
object {Linkpair} 
object {Linkpair translate 30*y} 
object {Linkpair translate 60*y} 
object {Linkpair translate 90*y} 
object {Linkpair translate 120*y} 
object {Linkpair translate 150*y} 
object {Linkpair translate 180*y}
object {Linkpair translate 210*y} 
object {Linkpair translate 240*y} 
object {Linkpair translate 270*y}
object {Linkpair translate 300*y} 
object {Linkpair translate 330*y} 
object {Linkpair translate 360*y}
object {Linkpair translate 390*y} 
object {Linkpair translate 420*y} 
object {Linkpair translate 450*y}

}

object {Straightchain 
  scale .075 translate -125*z translate -100*x translate 15*y}
 object {Straightchain 
  scale .075 translate -140*z translate -100*x translate 15*y}
  translate 10*y   } 
 
   
object {BlockAndTackle 
 scale 2 translate -170*z translate -54*y  translate -40*x  rotate 15*y
 }     
   

#declare Draftstool =
 
 union{   
 torus { 0.65, 0.05 texture {T_Wood35} translate .65*y}
difference{
 cylinder { <0, 0, 0>, <0, .1, 0>, .75 translate 2*y texture {T_Wood35} }
 cylinder { <0, 0, 0>, <0, .1, 0>, .75 scale .925 translate 2.095*y texture {T_Wood35} }
 }
 cylinder { <0, -.5, 0>, <0, 2, 0>, .05  translate -.55*x translate .55*z  texture {T_Wood35 rotate 90*x} rotate -2*x rotate -2*z }
 cylinder { <0, -.5, 0>, <0, 2, 0>, .05 translate .55*x translate .55*z  texture {T_Wood35 rotate 90*x} rotate -2*x rotate 2.*z }  
 
 cylinder { <0, -.5, 0>, <0, 2, 0>, .05 translate .55*x translate -.6*z  texture {T_Wood35 rotate 90*x} rotate 2*x rotate 2.*z }
 
 
 cylinder { <0, -.5, 0>, <0, 2, 0>, .05 translate -.55*x translate -.6*z  texture {T_Wood35 rotate 90*x} rotate 2*x rotate -2*z }  
                                                                                                                                                    
 } 

 union{
 object {Draftstool scale 4 translate -210*z  translate 50*x }
 object {Draftstool scale 4 translate -250*z  translate -40*x }
 object {Draftstool scale 4 translate -230*z  translate 50*x } 
 translate -50*y
 translate 60*z
    }     
     
 object {Wheel scale 7.5 rotate 90*y translate -135*z  translate 100*x translate 20*y texture {T_Brass_5A}}
       #declare Hook =
       
       union{   
       sphere { <0, 0, 0>, 1  scale <.2,1,1> translate 1*x}
       cylinder { <.8, 0, 0>, <3, 0, 0>, .2 } 
       difference{
       torus { 0.8, 0.2 }  
       
       box { <-1, -1, -1>, <1, 1, 1>  scale 5 translate -5*z translate 5*x }
       box { <-1, -1, -1>, <1, 1, 1>  scale 5 translate -5.5*z translate -5*x  }
       }
      texture {T_Brass_3A}  }
       
    
    
     union{   
     
     object {Hook rotate 90*x translate -160.5*z translate 100*x translate 6.5*y} 
     object {Hook rotate 90*x translate -147.75*z translate 100*x translate 6.85*y}  
     object {Hook scale 2 rotate 90*x translate -135.25*z translate 99.5*x translate 4.4*y}  
      
    object {Anchor scale 3 rotate 90*y rotate 90*x translate -135*z   translate 100*x texture {T_Brass_3A} translate -5*y} 
    
    
    object {Anchorchain scale .15  rotate 90*y  rotate 45*x translate -137.5*z translate 100*x  translate .5*y}
    object {Anchorchain scale .15  rotate 90*y rotate 35*x translate -149.55*z translate 100*x translate 1.975*y}    
    
    translate -10*y} 
         

#declare Dockposts =
union{ 
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 6.3*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 10.5*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 12.6*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 16.8*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 21*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 23.1*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 27.3*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 30.5*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 36.8*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 41*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 45.4*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 49.7*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 51.8*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 53.9*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 56*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 58.1*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 60.2*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 62.3*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 64.4*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 66.5*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 68.6*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 70.7*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 72.8*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 74.9*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 77*z }
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 79.1*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 81.2*z}
cylinder { <0, -3, 0>, <0, 3, 0>, .25 texture {T_WoodDock}translate 83.3*z}

} 


#declare Dock =  

union{
object {Dockposts translate -2.2*x translate -1*y}
object {Dockposts translate 2.2*x translate -1*y}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 2.1*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 4.2*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 6.3*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 8.4*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 10.5*z}
 
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 12.6*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 14.7*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 16.8*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 18.9*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 21*z}
  
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 23.1*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 25.2*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 27.3*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 28.4*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 30.5*z}

box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 32.6*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 34.7*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 36.8*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 38.9*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 41*z}

box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 43.1*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 45.4*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 47.6*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 49.7*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 51.8*z}


box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 53.9*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 56*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 58.1*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 60.2*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 62.3*z}


box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 64.4*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 66.5*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 68.6*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 70.7*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 72.8*z}

box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 74.9*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 77*z }
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 79.1*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 81.2*z}
box { <-1, -1, -1>, <1, 1, 1> scale <4,.1,1> texture {T_WoodDock}translate 83.3*z}
}  

union{
union{
object {Dock scale 3 translate 320*z  translate 10*x rotate -38*y translate -55*y }    
object {Dock scale 3 rotate -128*y translate -55*y translate 280*z  translate -190*x }translate 20*x}  
object {Shipatdock scale 10 rotate 50*y translate 380*z translate -310*x translate -12.25*y}
      }  
      
     
    