// Persistence of Vision Ray Tracer Scene Description File
// File: blob.inc
// Vers: 3.5
// Desc: CreateBlobbedObj macro
// Date: 2003/03/30
// Auth: Maurizio Tomasi
//

#version 3.5;

#include "rand.inc"


/* Create a "blobbed" object that is symmetric to the y axis.
   N is the number of blobs to be used, RndSeed the random seed
   (to be initialized with the "seed" function). */
   
#macro CreateBlobbedObj (N, RndSeed)
    blob
    {
        threshold 0.2
        
        #local Count = 0;
        #while (Count < N)
            #local CurPos = VRand_In_Sphere (RndSeed);
            
            sphere { < CurPos.x, CurPos.y,  CurPos.z>, 0.4, 0.1 }
            sphere { <-CurPos.x, CurPos.y,  CurPos.z>, 0.4, 0.1 }
            sphere { < CurPos.x, CurPos.y, -CurPos.z>, 0.4, 0.1 }
            sphere { <-CurPos.x, CurPos.y, -CurPos.z>, 0.4, 0.1 }
    
            #declare Count = Count + 1;
        #end
    }
#end

/* Create a "blobbed" object that is symmetric to the y axis and
   is limited by box { PtA, PtB }.
   N is the number of blobs to be used, RndSeed the random seed
   (to be initialized with the "seed" function). */

#macro CreateBlobbedObj_Box (N, PtA, PtB, Radius, RndSeed)
    blob
    {
        threshold Radius / 2
        
        #local Count = 0;
        #while (Count < N)
            #local CurPos = VRand_In_Box (PtA, PtB, RndSeed);
            
            sphere { < CurPos.x, CurPos.y,  CurPos.z>, Radius, Radius / 4 }
            sphere { <-CurPos.x, CurPos.y,  CurPos.z>, Radius, Radius / 4 }
            sphere { < CurPos.x, CurPos.y, -CurPos.z>, Radius, Radius / 4 }
            sphere { <-CurPos.x, CurPos.y, -CurPos.z>, Radius, Radius / 4 }
    
            #declare Count = Count + 1;
        #end
    }
#end
