// Persistence of Vision Ray Tracer Scene Description File
// File: ladder.inc
// Vers: 3.5
// Desc: Iron ladder
// Date: 2003/04/18
// Auth: Maurizio Tomasi
//

#version 3.5;

#include "math.inc"

/*
global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}
*/

// ----------------------------------------

#local LadderSlope = 0.6;
#local LadderHeight = 0.5;
#local BarRadius = 0.01;

#local LadderBase1 = 
cylinder
{
    <0, 0, 0>, <1.0, LadderSlope, 0>, BarRadius
}

#local LadderBase2 =
cylinder
{
    <1.0, LadderSlope, 0>, <1.5, LadderSlope, 0>, BarRadius
}

#local LadderBars1 =
union
{
    #local Count = 0;
    #while (Count < 1.0)
        
        cylinder
        {
            <0, 0, 0>, <0, LadderHeight, 0>, BarRadius
            
            translate <Count, LadderSlope * Count/1.0, 0>
        }
        
        #declare Count = Count + 0.05;
    #end
}

#local LadderBars2 =
union
{
    #local Count = 0;
    #while (Count < 0.5)
        
        cylinder
        {
            <0, 0, 0>, <0, LadderHeight, 0>, BarRadius
            
            translate <1.0 + Count, LadderSlope, 0>
        }
        
        #declare Count = Count + 0.05;
    #end
}

#local LadderBars3 =
union
{
    #local Count = -0.5;
    #while (Count < 0.5)
        
        cylinder
        {
            <0, 0, 0>, <0, LadderHeight, 0>, BarRadius
            
            translate <1.5, LadderSlope, Count>
        }
        
        #declare Count = Count + 0.05;
    #end
}

#local Steps =
union
{
    #local Count = 0.1;
    #while (Count < 1.0)
        
        box
        {
            <-0.05, 0, 0>, <0.05, 2 * BarRadius, -0.5>
            translate <Count, LadderSlope * Count/1.0, 0>
        }
        
        #declare Count = Count + 0.1;
    #end
}

#local LadderComponent =
union
{
    object { LadderBase1 }
    object { LadderBars1 }
    object { LadderBars3 }
    
    object { LadderBase1 translate <0, 0, -0.5> }
    object { LadderBase2 translate <0, 0, -0.5> }
    object { LadderBars1 translate <0, 0, -0.5> }
    object { LadderBars2 translate <0, 0, -0.5> }
 
    object { LadderBars2 translate <0, 0, 0.5> }
    
    object { Steps }
    
    union
    {
        object { LadderBase1 }
        object { LadderBase1 translate <0, 0, -0.5> }
        object { LadderBase2 translate <0, 0, -0.5> }
        object { LadderBase2 translate <0, 0,  0.5> }
        
        translate LadderHeight * y
    }
    
    cylinder
    {
        <1.5, LadderSlope + LadderHeight, -0.5>,
        <1.5, LadderSlope + LadderHeight, 0.5>, BarRadius
    }
    
    // Platform
    box
    {
        <1.0, LadderSlope, -0.5>, <1.5, LadderSlope + 2 * BarRadius, 0.5>
    }
}

#declare Ladder =
union
{
    #local Count = 0;
    #while (Count < 4)
    
        #if (even (Count))

            object
            {
                LadderComponent

                translate <0.0, LadderSlope * Count, 0.0>
            }

        #else

            object
            {
                LadderComponent
                rotate 180*y
                translate <1.0, LadderSlope * Count, 0.0>
            }
        
        #end
                
        #declare Count = Count + 1;
    #end
}

/*
object
{
    Ladder
        
    rotate -60*y
    translate -1*y
    pigment { color rgb <0.4, 0.4, 0.5> }
}
*/