// Persistence of Vision Ray Tracer Scene Description File
// File: window.inc
// Vers: 3.5
// Desc: Decorated window
// Date: 2003/03/30
// Auth: Maurizio Tomasi
//

#version 3.5;

#local Radius = 1.0;
#local BaseHeight = 1.5;
#local ImageAspectRatio = 1293/522;

/* The shape of the window (solid object).  This is useful to
   use in CSG operations like intersection or difference.  It is
   fully contained in box { <-Radius/2, 0, -0.5>, <Radius/2, BaseHeight+Radius, 0.5> } */

#declare WindowShape =
union
{
    intersection
    {
        cylinder
        {
            <-Radius/2, BaseHeight, -0.5>,
            <-Radius/2, BaseHeight,  0.5>,
            Radius
        }
        
        box
        {
            <   -0.01, BaseHeight,         -0.51>,
            <Radius/2, BaseHeight + Radius, 0.51>
        }
    }
    
    intersection
    {
        cylinder
        {
            <Radius/2, BaseHeight, -0.5>,
            <Radius/2, BaseHeight,  0.5>,
            Radius
        }
        
        box
        {
            <     0.01, BaseHeight,         -0.51>,
            <-Radius/2, BaseHeight + Radius, 0.51>
        }
    }

    box
    {
        <-Radius/2, 0.0,              -0.5>
        < Radius/2, BaseHeight + 0.01, 0.5>
    }
    
    scale <0.90, 1.025, 1.0>
}


#declare WindowFrame =
height_field
{
    png "window.png"
    smooth
    water_level 0.6
    
    translate -0.5*x
    rotate -90*x
    translate 0.5*z
    
    scale <1, ImageAspectRatio, 1>
}
