//orthonormal
//by tek

#include "transforms.inc"
#include "rad_def.inc"

global_settings {
//  this doesn't quite work, it shows the seam
//	radiosity { Rad_Settings(Radiosity_Fast, off, off) }
}

//stone
//#default { pigment { rgb 1 } finish { ambient 0 diffuse 1 } normal { /*agate .3 agate_turb .7 scale .3*/ granite -.1 } }
//marble
#default {
	pigment {
		pigment_pattern {
			//marble triangle_wave
			granite scale <8,2,8>
			colour_map { [0 rgb 0][1 rgb 1] }
		}
		turbulence .3
		rotate <0,45,60>
		scale .5
		poly_wave .07
		colour_map { [.5 rgb <0,0,.3>][1 rgb 1] }
	}
	finish { ambient 0 diffuse 1 specular 1 roughness .1 reflection { .05, 1 falloff 5 } conserve_energy }
}


#macro m_Lights()
	#local vDir = <-1,3,2>;
	
	light_source {
		<2,3,1>*10000 rgb <.2,.3,.4> //"ambient light" but with directional variants.
		parallel
		point_at 0
		shadowless
	}

	light_source {
		vDir*10000
		rgb <.8,.75,.7>
	  parallel
		point_at 0
		//shadowless
	}
#end


/*
//rgb lighting, for a very different image
#macro m_Lights()
	light_source {
	  y*10000, rgb x
	  parallel
	  point_at -y*10000
	  shadowless
	}

	light_source {
	  x*10000, rgb x+y
	  parallel
	  point_at -x*10000
	  shadowless
	}

	light_source {
	  z*10000, rgb z
	  parallel
	  point_at -z*10000
	  shadowless
	}
#end
*/



#if (1) //set this to 0 to get perspective camera, it hurts your braing even more!
	camera {
		orthographic
		right			x*23
		up				y*23*image_height/image_width
		direction z
		
		location <0,0,-50>
		look_at <0,0,0>
	}
#else
	camera {
		right			x
		up				y*image_height/image_width
		direction z*.75
		
		location -18*z*1.5
		look_at 0
	}
#end


//laziness
#macro m_( obj, pos )
	object { obj translate pos }
#end


#declare oBox =
	box { -.5, .5 } //I was trying rounded boxes, but the illusion doesn't quite work 'cause I couldn't smooth the concave corners.


#declare oSlope =
	intersection {
		box { -.5, .5 }
		plane { x+y, 0 }
	}


#declare oSteps =
	merge {
		#local i = 0;
		#local j = .1;
		#while (i < 1-j/2)
			box { <-.5,i-.5,-.5>, <.5-i,i+j-.5,.5> }
			#local i = i + j;
		#end 
	}

#declare oRoof =
	intersection {
		plane { -y, 0 }
		plane { y, 0 rotate 30*x translate 1.5*z }
		plane { y, 0 rotate -30*x translate -1.5*z }
		plane { y, 0 rotate 30*z translate -1.5*x }
		plane { y, 0 rotate -30*z translate 1.5*x }
		translate -y/2
	}


#declare oLogo =
	//evilsuperbrain logo
	union {
		#local oRing =
			union {
				m_(box { -.5, .5 }, <-1, 0, 0>)
				m_(box { -.5, .5 }, <-1, 1, 0>)
				m_(box { -.5, .5 }, <-1, 2, 0>)
				m_(box { -.5, .5 }, <0, 2, 0>)
				m_(box { -.5, .5 }, <1, 2, 0>)
				m_(box { -.5, .5 }, <1, 1, 0>)
				m_(box { -.5, .5 }, <1, 0, 0>)
				m_(box { -.5, .5 }, <1, -1, 0>)
				m_(box { -.5, .5 }, <1, -2, 0>)
				m_(box { -.5, .5 }, <0, -2, 0>)
				m_(box { -.5, .5 }, <-1, -2, 0>)
				m_(box { -.5, .5 }, <-1, -2, 0>)
				m_(box { -.5, .5 }, <-1, -1, 0>)
				rotate 90*y
			}
		object { oRing pigment { rgb y } }
		object { oRing rotate <0,90,90> pigment { rgb z } }
		object { oRing rotate <90,0,90> pigment { rgb x } }
		
		scale .2
	}


//define one half of the scene (the left half)
#declare oScene =	
	light_group {
		#declare X = -20;
		#while ( X <= 20)
			#declare Y = -20;
			#while ( Y <= 20)

				#if ( X+Y/2+abs(Y)*.4 >= 0 //only place about half the blocks, but allow an overlap so the perspective shot works better.
							& X+Y*1 >= 0 ) //fix some errors in shadows.
							
					object {
						oBox
						translate <X, Y, -X-Y>
						no_shadow
						//Note that these are drawn with no shadow, this means we must duplicate some of these later in situations where they look wrong without a shadow.
					}
					
				#end
			
				#declare Y = Y + 1;
			#end
			#declare X = X + 1;
		#end

		//most central steps	
		object { oSteps translate <1, 0, 0> no_shadow }	//these cast a shadow onto the other half of the picture. causing a very small artefact.
		object { oSteps translate <2, -1, 0> no_shadow }

		//big flights
		m_(oBox, <3, -2, 0>)
		m_(oBox, <4, -3, 0>)
		m_(oBox, <4, -2, 0>)
		m_(oBox, <4, -2, -1>)
		object { oSteps rotate -90*y translate <5, -2, -1> }
		object { oSteps rotate -90*y translate <5, -1, -2> }
		m_(oBox, <5, -2, -2>)	//plateau
		m_(oBox, <5, -3, 0>)	//plateau
		m_(oBox, <5, -3, -1>)
		m_(oBox, <5, -4, 0>)
		m_(oBox, <6, -3, 0>)
		m_(oBox, <6, -3, -1>)
		m_(oBox, <6, -3, -2>)
		m_(oBox, <6, -4, 0>)
		m_(oBox, <6, -4, -1>)
		m_(oBox, <6, -5, 0>)
		m_(oBox, <6, -6, 0>-.001) //just for the shadows
		m_(oSteps, <7, -3, -2>)
		m_(oBox, <7, -3, -3>)
		m_(oBox, <7, -4, -2>)
		m_(oBox, <6, -2, -3>)
		m_(oBox, <8, -4, -3>) //low walkway
		m_(oBox, <8, -4, -2>)
		m_(oBox, <8, -5, -2>)
		m_(oBox, <3, -1, -1>) //steps by houses
		object { oSteps rotate -90*y translate <4, -1, -1> }
		m_(oSteps, <3,0,-2>)
		m_(oBox, <2, 0, -1>)

		//house
		m_(oBox, <4, -1, -2>)
		m_(oBox, <5, -1, -3>)
		m_(oBox, <5, 0, -3>)
		m_(oBox, <5, 1, -3>)
		m_(oBox, <5, 0, -4>)
		m_(oBox, <5, 1, -5>)
		m_(oBox, <4, 1, -3>)
		m_(oBox, <3, 1, -3>)
		m_(oBox, <5, 2, -3>)
		m_(oBox, <5, 2, -4>)
		m_(oBox, <5, 2, -5>)
		m_(oBox, <4, 2, -3>)
		m_(oBox, <3, 2, -3>)
		m_(oRoof, <4, 3, -4>)

		//shelf
		object { oSlope rotate -90*z translate <2, 2, -2> }
		m_(oSteps, <1, 1, -1>)
		m_(oBox, <1, 2, -2>)
		m_(oBox, <1, 1, -2>-.001)//this one's just for shadows.
		m_(oBox, <2, 2, -3>)
		object { oSteps rotate -90*y translate <0,2,-1> }
		object { oSteps rotate -90*y translate <2,3,-3> }
		m_(oBox, <2, 3, -4>)
		
		//upper plateau		
		m_(oBox, <-3, 5, -1>) //walls
		m_(oBox, <-3, 6, -1>)
		m_(oBox, <-3, 6, -2>)
		m_(oBox, <-4, 6, -1>)
		m_(oBox, <-1, 5, -3>)
		m_(oBox, <-1, 6, -3>)
		m_(oBox, <-1, 6, -4>)
		m_(oBox, <-1, 6, -5>-.001)//this one's just for shadows.
		m_(oBox, <-2, 6, -3>)
		m_(oBox, <-2, 4, -1>) //ground
		m_(oBox, <-1, 4, -1>)
		m_(oBox, <-1, 4, -2>)
		m_(oBox, <0, 4, -2>)
		object { oSlope rotate 90*x translate <0, 4, -1> }
		object { oSlope rotate 90*x translate <1, 4, -2> }
		m_(oBox, <-1, 3, -1>)
		m_(oBox, <-1, 2, -1>-.001)//this one's just for shadows.
		object { oSteps rotate 90*y translate <0, 4, -3> }
		object { oSteps rotate 90*y translate <1, 4, -3> }
		m_(oBox, <1, 3, -3>)
		
		//back stairs
		object { oSteps rotate -90*y translate <2, 4, -5> }
		m_(oSteps, <3, 4, -6>)
		m_(oSteps, <4, 3, -6>)
		m_(oSteps, <5, 2, -6>)
		m_(oBox, <6, 1, -6>)
		m_(oBox, <6, 1, -7>-.001)//this one's just for shadows.
		object { oSteps rotate -90*y translate <6, 1, -5> }
		m_(oBox, <6, 0, -5>)
		object { oSteps rotate -90*y translate <6, 0, -4> }
		m_(oBox, <6, -1, -4>)
		object { oSteps rotate -90*y translate <6, -1, -3> }
		m_(oBox, <6, -2, -3>)
		m_(oSteps, <7, -2, -3>)
		object { oSteps rotate -90*y translate <8, -3, -3> }
		m_(oBox, <8, -3, -4>)
		m_(oBox, <8, -3, -5>-.001)//this one's just for shadows.

		//sculptures		
		m_(oLogo, <6.5,-2,.5>) //lower plateau
		object { oLogo Reorient_Trans(<1,1,1>,z) scale <1,1,-1> Reorient_Trans(z,<1,1,1>) translate <-1.5, 5, -1.5> } //upper plateau
		
		
		m_Lights()

		global_lights on	
	}

object {
	oScene

	translate -y/2
	
	Reorient_Trans( <1,1,1>, <1,0,1> )
	Reorient_Trans( <1,0,1>, -z )
}

object {
	oScene
	
	translate -y/2

	Reorient_Trans( <1,1,1>, <1,0,1> )
	Reorient_Trans( <1,0,1>, -z )
	rotate 180*z
	translate -0*z
	//pigment { rgb x } comment this in to make it more obvious how the trick is done.
}
