// Persistence of Vision Ray Tracer Scene Description File
// chateau.pov by Sylvain Girard 
// sylvaingirard@multimania.com
//
// Commence le 03/08/2002
//
// Cette scene est totalement libre de droit.
// Vous pouvez la modifier ou l'utiliser a des
// fins commerciales A CONDITION DE M'EN INFORMER.
// 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	    // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions

#include "skies.inc"
#include "metals.inc"
#include "woods.inc"

#include "finish.inc"

// unit : cm

#declare PortailOuvert = 80;

#declare Herbe = on;
#declare Arbre = on;
#declare Nuages = on;
#declare Rad_Quality = 2;

global_settings
{
  assumed_gamma 1
  charset utf8
  max_trace_level 20

#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
    pretrace_start 0.08
    pretrace_end   0.02
    count 50
    error_bound 0.5
    recursion_limit 1
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
    pretrace_start 0.08
    pretrace_end   0.01
    count 120
    error_bound 0.25
    recursion_limit 1
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 400
    error_bound 0.1
    recursion_limit 1
  }
 #break
 #case (4)
  radiosity {             // --- Settings 4 (medium quality, recursion_limit 2) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 350
    error_bound 0.15
    recursion_limit 2
  }
 #break
 #end

}

#declare W_Signature =
text
{
  ttf "COMIC.TTF", " ZeSly 2003", 0.01, 0
  scale 0.02
  pigment {color rgb 1}
  finish {ambient 1 diffuse 1}
}

#declare B_Signature =
text
{
  ttf "COMIC.TTF", " ZeSly 2003", 0.01, 0
  scale 0.02
  pigment {color rgb 0}
  finish {ambient 1 diffuse 1}
}

#if (defined(cam) = false)
  #declare cam = 4;
#end

// +w320 +h180
// +w512 +h288
// +w640 +h360
// +w800 +h450
// +w1024 +h576 +a
// +w1600 +h900 +a
 
#switch (cam)
#case (0)     // Plan large face au portail
  light_source { <-5000,8000,0> color rgb 1.6 }
  #include "screen.inc"
  Set_Camera(<0,170,-3000>, <0,300,0>, 40)
  Set_Camera_Aspect(16,9)
  Screen_Object ( B_Signature, <1,0>, <0.04,0.02>, true, 1 )
  #break
#case (1)     // Camra de construction
  light_source { <-5000,8000,-2000> color rgb 1.6 }
  camera
  {
    //orthographic
    location <-400,350,4700>
    look_at <-400,350,5000>
    //location <1000,250,3600>
    //look_at <3000,250,5500>
    //translate 5000*z
    //angle 30
  }
  #declare Herbe = off;
  #break
#case (2)     // Vue de la facade ouest
  light_source { <-3000,8000,10000> color rgb 1.6 }
  #include "screen.inc"
  //Set_Camera(<-5000,170,10000>, <-700,600,6000>, 40)
  Set_Camera(<-3000,170,9500>, <-800,600,6000>, 67) // set location, look_at and angle
  Set_Camera_Aspect(16,9)
  Screen_Object ( W_Signature, <1,0>, <0.04,0.02>, true, 1 )
  #break
#case (3)     // Vue arienne
  light_source { <-5000,8000,-2000> color rgb 1.6 }
  #include "screen.inc"
  Set_Camera(<-10000,5000,-500>, <0,0,4500>, 40)
  Screen_Object ( B_Signature, <1,0>, <0.04,0.02>, true, 1 )
  #declare Nuages = off;
  #break
#case (4)     // Facade est

  light_source { <-5000,8000,0> color rgb 1.6 }

  #include "screen.inc"
  Set_Camera(<-3000,300,-1000>, <0,300,5000>, 50)
  Set_Camera_Aspect(16,9)
  Screen_Object ( B_Signature, <1,0>, <0.04,0.02>, true, 1 )

  #break
#case (-1)  // Vue aerienne orthographique pour l'image_map des pelouses
  light_source { <0,100000,5000> color rgb 1.6 }
  camera
  {
    orthographic
    location 8500*y
    look_at 0
    //angle 60
    rotate 90*y
    translate 6000*z
  }
  #declare Herbe = off;
#end

#declare M_Sky = 
material // M_Sky 
{ 
  texture 
  { 
    pigment {  color rgb <0.0, 0.4, 1.0> } 
    finish 
    { 
      ambient 0.7 
      diffuse 0.0 
    } 
  } 
  interior 
  { 
    media 
    { 
      scattering 
      {
        4 , rgb <0.0018, 0.0020, 0.005>*0.0003
      } 
      density 
      { 
        spherical 
        color_map 
        { 
          [ 0.0 rgb 0 ] 
          [ 1.0 rgb 0.1 ]
        } 
      } 
    } 
  } 
} 

sphere
{ // Sky 
  <0,0,0>,1 
  translate -0.994*y 
  material { M_Sky }
  no_shadow 
  double_illuminate 
  hollow 
  scale 3000000.0*30
}

#if (Nuages = on)

// The SkyShell macro is from scenes/advanced/mediasky.pov

#declare PlanetSize = 200000000;

/*#macro SkyShell(minAlt, maxAlt, Int)
difference
{
	sphere {< 0, 0, 0>, 1 scale (PlanetSize + maxAlt)}
	sphere {< 0, 0, 0>, 1 scale (PlanetSize + minAlt)}
	hollow
  texture {pigment {color rgbf 1}}
	translate -y*PlanetSize
	interior {Int}
}
#end

SkyShell(100000, 130000,
	interior
	{
		media
		{
			method 3 aa_threshold 0.1 aa_level 3
			samples 4
			intervals 1
			absorption 0.000005
			scattering { 1, color rgb 0.00001 extinction 1 }

			density
			{
			  wrinkles
				scale < 5, 2, 2>*80000
				warp { turbulence 2 }
				color_map
				{
          [ 0.0  rgb 1.0 ]
          [ 0.35 rgb 1.0 ]
          [ 0.4  rgb 0.0 ]
          [ 1.0  rgb 0.0 ]
					/[0 color rgb 1]
					[0.35 color rgb 0.85]
					[0.4 color rgb 0.035]
					[0.5 color rgb 0.0]
					[1.0 color rgb 0.0]
				}
			}
		}
	}
)*/

// the clouds
#include "i_stsky.inc"
#declare dark_color=SkyBlue*.3+White*.65;
#declare light_color=White;// *.9+SkyBlue*.2;
#declare height=100000;
#declare cloud_level=.6;
#declare planes=15;
#declare pdist=400;
#declare ppatt=pigment{wrinkles}
#declare pturb=.5;
#declare pocta=8;
#declare plamb=3.5;
#declare pomeg=.5;
#declare tdist=30;
#declare sfactor=110000;
#declare dfactor=.9;
#declare border=.2;
#declare fstart=.7;
#declare fend=.8;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 5*y
}

#end

#declare T_Sol =
texture
{
  //pigment { color rgb <1.1, 0.7, 0.3> }
  pigment { color rgb <1.1, 0.7, 0.4> }     
  finish
  {
    specular 0.06
    //diffuse 0.6
    ambient <0.8, 0.9, 1.4>*0.1
  }
  normal
  {
    granite 0.3
    scale 0.1
  }
}

#declare Herbe_map =
pigment
{
  image_map
  {
    png "herbe_map.png" transmit 79,1
  }
  rotate 90*x
  rotate 90*y
  scale <4249*2,1,5842*2>
  translate <-4249,0,-18>
}

#if (Herbe = on)

  #include "functions.inc"
  #include "herbe.pov"
  
  #if (cam = 0 | cam = 4)
    #debug "Vue est\n"
    #declare StartZ = -10;
    #declare EndZ = 5500;
  #else #if (cam = 2)
    #debug "Vue ouest\n"
    #declare StartZ = 5500;
    #declare EndZ = 11660;
  #else
    #debug "Vue entiere\n"
    #declare StartZ = -10;
    #declare EndZ = 11660;
  #end
  #end
  
  #declare ScanX = -4245;
  #declare Density = 20;
  #declare nbplace = 0;
  
  #while (ScanX <= 4245)
  
    #declare ScanZ = StartZ;
    #while (ScanZ <= EndZ)
      #declare Vect = <ScanX,1,ScanZ>;
      #declare Eval = eval_pigment(Herbe_map,Vect);
      #if (Eval.x = 0)
        object
        {
          Herbe
          scale (1+1*rand(rd))
          rotate y*360*(0.5-rand(rd))*1
          translate Vect
        }
        #declare nbplace = 1 + nbplace;
      #end
  
      #declare ScanZ = ScanZ + Density;
    #end
  
    #declare ScanX = ScanX + Density;
  #end
  
  #debug concat(str(nbplace,0,0)," grass patches placed\n")
  
#else
  box
  {
    <-4249,0.1,-18>
    < 4249,  1,11666>
    pigment { Herbe_map }
    finish { ambient 0 diffuse 0.3 }
  }
#end

#if (Arbre = on)
#declare rd = seed(24);
#include "sapin.inc"
object { TREE scale 2500 rotate (360*rand(rd))*y translate <2900,0,10000> }
object { TREE scale 2450 rotate (360*rand(rd))*y translate <3300,0,10000> }

#declare sz = -2300;
#while (sz < 2400)
  object { TREE scale 1500+(rand(rd)*250) rotate (360*rand(rd))*y translate <sz,0,9900+(rand(rd)*200)> }
  #declare sz = sz + 400 + (rand(rd)*200);
#end

object { TREE scale 1500 rotate (360*rand(rd))*y translate <-2900,0,10000> }
object { TREE scale 2200 rotate (360*rand(rd))*y translate <-3300,0,10000> }
object { TREE scale 2300 rotate (360*rand(rd))*y translate <-3700,0,9900> }
object { TREE scale 2350 rotate (360*rand(rd))*y translate <-4000,0,10000> }
object { TREE scale 2550 rotate (360*rand(rd))*y translate <-6000,0,10000> }

object { TREE scale 1500 rotate (360*rand(rd))*y translate <-3100,0,2000> }

object { TREE scale 1500 rotate (360*rand(rd))*y translate <2300,0,800> }
object { TREE scale 1500 rotate (360*rand(rd))*y translate <2500,0,1800> }
object { TREE scale 2500 rotate (360*rand(rd))*y translate <3000,0,2500> }

#debug "Les sapins sont places\n"
#include "sapin2.inc"
object { TREE scale 2200 translate <3000,0,1500> }
#debug "Le sapin2 est place\n"
#include "feuillus1.inc"
object { TREE scale 1000 rotate -10*z translate <-2500,0,3200> }
#debug "Le feuillus1 est place\n"
#include "buisson1.inc"
object { TREE scale 400 rotate (360*rand(rd))*y translate <2400,0,3500> }
object { TREE scale 300 rotate (360*rand(rd))*y translate <2700,0,3500> }
object { TREE scale 370 rotate (360*rand(rd))*y translate <3100,0,3500> }
object { TREE scale 250 rotate (360*rand(rd))*y translate <2500,0,3250> }
object { TREE scale 200 rotate (360*rand(rd))*y translate <2800,0,3300> }

object { TREE scale 300 rotate (360*rand(rd))*y translate <-2400,0,3500> }
object { TREE scale 400 rotate (360*rand(rd))*y translate <-2800,0,3500> }
object { TREE scale 370 rotate (360*rand(rd))*y translate <-3100,0,3500> }

#debug "Les buisson1 sont places\n"
#end

plane { y, 0 texture { T_Sol } }


#declare T_Murette =
texture
{
  pigment
  {
    gradient y
    pigment_map
    {
      [0 Gray60 ]
      [1
        dents
        color_map
        {
          [0.0 Gray10 ]
          [0.8 Gray60 ]
        }
      ]
    }
    
  }
  finish
  {
    ambient 0.0
    diffuse 0.7
    crand 0.05
  }
  scale <10,50,10>
}

#declare T_FerKhaki =
texture
{
  pigment { color rgb <0.15,0.2,0.1> }
  finish { Shiny }
}  

#declare P_Murclaire = //color rgb <0.780,0.686,0.576>;
pigment
{
  wrinkles
  color_map
  {
    [ 0.0 DarkBrown ]
    [ 0.3 color rgb <0.780,0.686,0.576> ]
  }
  scale 3
}

#declare P_Salete =
pigment
{
  wrinkles
  color_map
  {
    [ 0.0 DarkBrown/2 ]
    [ 0.3 DarkOliveGreen ]
  }
  scale 3
}

#declare F_Mur =
finish
{
  ambient 0.0
  diffuse 0.8
  crand 0.05
}

#declare T_MurClaire =
texture
{
  pigment { P_Murclaire }
  finish { F_Mur }
}

#declare T_MurSale1 =
texture
{
  pigment
  {
    dents
    scallop_wave
    frequency 0.5
    pigment_map
    {
      [ 0.0 P_Murclaire scale 1/<10,500,10>]
      [ 0.8 P_Salete scale 1/<10,500,10> ]
    }
    scale <10,500,10>
  }
  finish { F_Mur }
}

#declare T_MurSale2 =
texture
{
  pigment
  {
    dents
    pigment_map
    {
      [ 0.05 P_Murclaire scale 1/100 ]
      [ 0.2 //P_Salete ]
        wrinkles
        scallop_wave
        frequency 0.5
        pigment_map
        {
          [ 0.0 P_Murclaire scale 1/(<20,50,20>/2) ]
          [ 0.8 P_Salete scale 1/(<20,50,20>/2) ]
        }
        scale <20,50,20>/200
      ]
    }
    scale 100
  }
  finish { F_Mur }
}

#declare P_MurSale3 =
pigment
{
  wrinkles
  scallop_wave
  frequency 0.5
  pigment_map
  {
    [ 0.0 P_Murclaire ]
    [ 0.8 P_Salete ]
  }
}

#declare T_MurSale3 =
texture
{
  pigment
  {
    wrinkles
    scallop_wave
    frequency 0.5
    pigment_map
    {
      [ 0.0 P_Murclaire scale 1/30 ]
      [ 0.8 P_Salete scale 1/30]
    }
    scale 30
  }
  finish { F_Mur }
}

#declare T_MurSale3b =
texture
{
  pigment
  {
    gradient y
    pigment_map
    {
      [ 0
        wrinkles
        scallop_wave
        frequency 0.5
        pigment_map
        {
          [ 0.0 P_Murclaire scale 1/30 ]
          [ 0.8 P_Salete scale 1/30]
        }
      ]
      [ 1 P_Murclaire scale 1/50]
    }
    scale 50
    translate 10*y
  }
  finish { F_Mur }
}

#declare T_MurSale3c =
texture
{
  pigment
  {
    planar
    pigment_map
    {
      [ 0 P_Murclaire scale 1/60]
      [ 1
        wrinkles
        scallop_wave
        frequency 0.5
        pigment_map
        {
          [ 0.0 P_Murclaire scale 1/28 ]
          [ 0.8 P_Salete scale 1/28 ]
        }
        scale 0.4
      ]
    }
    scale 70
    rotate 90*x
    translate 1059*z
  }
  finish { F_Mur }
}

#declare T_MurSale4 =
texture
{
  pigment
  {
    gradient y
    pigment_map
    {
      [ 0
        wrinkles
        scallop_wave
        frequency 0.4
        pigment_map
        {
          [ 0.0 P_Murclaire scale 1/40 ]
          [ 1.0 P_Salete scale 1/40]
        }
        scale 0.4
      ]
      [ 1 P_Murclaire scale 1/100]
    }
    scale 100
  }
  finish { F_Mur }
}

/*#declare _T_MurMap =
texture
{
  pigment { image_map { jpeg "mur2.jpg" } }  
  finish { ambient 0.0 diffuse 0.8 }
  scale <154.2,141.67,1>
}*/

#declare T_MurMap =
texture
{
  pigment
  {
    brick
    pigment
    {
      dents
      color_map
      {
        [ 0.0 VeryDarkBrown/2 ] 
        [ 0.6 color rgb <0.780,0.686,0.636> ]
      }
      scale 3
    }
    pigment
    {
      wrinkles
      color_map
      {
        [ 0.0 VeryDarkBrown ]
        [ 0.3 color rgb <0.780,0.686,0.636> ]
      }
      scale 3
    }
    brick_size <50,28.33333,50>
    mortar 0.5
  }
  finish { F_Mur }
}

#declare T_Bois =
texture { T_Wood2 scale 10 }


//#declare BleuToit = color rgb <0.22,0.20,0.35>;
#declare BleuToit = color rgb <0.07,0.1,0.3>;
#declare FinishToit =
finish
{
  ambient 0.0
  diffuse 0.4
  specular 0.3
  roughness 0.1
}

#declare T_Toit1 =
texture
{
  pigment
  {
    brick      
    pigment { color rgb 0 }
    pigment
    { //color BleuToit }
      bozo
      pigment_map
      {
        [0.4 //Gray ]
          gradient y
          pigment_map
          {
            [ 0 BleuToit ]
            [ 1
              wrinkles
              color_map
              {
                [0.0 Gray90 ]
                [0.6 BleuToit ]
              }
              scale <1,0.5,1>
            ]
          }
          scale <10,200,10>/<200,500,200>
        ]
        [0.6 BleuToit ]
      }
      scale <200,500,200>
    }
    brick_size <15,10,15>
    mortar 0.5
  }
  finish { FinishToit }
}

#declare T_Toit2 =
texture
{
  pigment
  {
    brick      
    pigment { color rgb 0 }
    pigment
    { //color BleuToit }
      bozo
      pigment_map
      {
        [0.4 //Gray ]
          gradient y
          poly_wave 2
          pigment_map
          {
            [ 0 BleuToit ]
            [ 1
              wrinkles
              color_map
              {
                [0.0 Gray90 ]
                [0.6 BleuToit ]
              }
              scale <1,0.5,1>
            ]
          }
          scale <10,300,10>/<200,500,200>
        ]
        [0.6 BleuToit ]
      }
      scale <200,500,200>
    }
    brick_size <15,10,15>
    mortar 0.5
    translate -150*y
  }
  finish { FinishToit }
}

#declare T_Toit3 =
texture
{
  pigment
  {
    brick      
    pigment { color rgb 0 }
    pigment
    { //color BleuToit }
      bozo
      pigment_map
      {
        [0.4 //Gray ]
          gradient y
          poly_wave 3
          pigment_map
          {
            [ 0 BleuToit ]
            [ 1
              wrinkles
              color_map
              {
                [0.0 Gray90 ]
                [0.6 BleuToit ]
              }
              scale <1,0.5,1>
            ]
          }
          scale <10,300,10>/(<200,500,200>*1.5)
        ]
        [0.6 BleuToit ]
      }
      scale <200,500,200>*1.5
    }
    brick_size <15,10,15>
    mortar 0.5
    translate 1200*y
  }
  finish { FinishToit }
}

#declare T_Toit =
texture
{
  pigment
  {
    brick      
    pigment { color rgb 0 }
    pigment
    { //color BleuToit }
      bozo
      pigment_map
      {
        [0.4 //Gray ]
          planar
          pigment_map
          {
            [ 0 BleuToit ]
            [ 1
              wrinkles
              color_map
              {
                [0.0 Gray90 ]
                [0.6 BleuToit ]
              }
              scale <1,0.5,1>
            ]
          }
          scale <10,300,100>/(<200,500,200>)
        ]
        [0.6 BleuToit ]
      }
      scale <200,500,200>
    }
    brick_size <15,10,15>
    mortar 0.5
    //translate 1550*y
    translate 550*y
  }
  finish { FinishToit }
}

#declare _T_Toit =
texture
{
  pigment
  {
    planar
    color_map
    {
      [ 0 BleuToit ]
      [ 1 Gray90 ]
    }
    scale 10
    translate 550*y
  }
  finish { FinishToit }
}

#declare _T_Toit =
texture
{
  pigment
  {
    brick      
    color rgb 0
    color BleuToit
    brick_size <15,10,15>
    mortar 0.5
  }
  finish { FinishToit }
}

#declare T_Vitre =
//texture { pigment { color SkyBlue } }
texture { NBglass }

////////////////////////////////////////////////////////////////////////////////
// Les panoramas
////////////////////////////////////////////////////////////////////////////////

// Panorama est : 10338 x 1164
#declare h = 3400;
#declare f = 10338/1164;
box
{
  0,1
  pigment
  {
    image_map { png "pan1.png" transmit 255,1 }
    rotate 180*y
  }
  scale <h*f,h,0.01>
  translate <-(h/2)*f,0,-5000>
  no_shadow
  finish { ambient 0 diffuse 0.5 }
}

// Panorama ouest : 5182 x 916;
#declare h = 4210;
#declare f = 5182/916;
box
{
  0,1
  pigment
  {
    image_map { png "pan2.png" transmit 0,1 }
  }
  scale <h*f,h,0.01>
  translate <-(h/2)*f,0,15000>
  no_shadow
  finish { ambient 0 diffuse 0.5 }
}

////////////////////////////////////////////////////////////////////////////////
// La grille
////////////////////////////////////////////////////////////////////////////////

#declare PiedPoteau =
union
{
  box
  {
    <-7,0,-7>
    < 7,5, 7>
  }  
  prism
  {
    conic_sweep
    linear_spline
    0.8, 1,
    5,
    <-6,-6>, <-6, 6>, < 6, 6>, < 6,-6>, <-6,-6>
    rotate 180*z
    translate y
    scale <1,225,1>
    translate 5*y
  }
  prism
  {
    conic_sweep
    linear_spline
    0.8, 1,
    5,
    <-4.8,-4.8>, <-4.8, 4.8>, < 4.8, 4.8>, < 4.8,-4.8>, <-4.8,-4.8>
    rotate 180*z
    translate y
    scale <1,10,1>
    translate 50*y
  }
  texture { T_FerKhaki }
}

#declare Poteau =
union
{
  cylinder { 0, 5*y,  4.8 }
  torus { 3.8, 1 translate 5*y }
  torus { 3.8, 1 translate 7*y }
  torus { 3.8, 1 translate 9*y }
  cone
  {
    9*y, 4.8,
    15*y, 4
  }
  cylinder { 15*y, 128*y, 4 }
  torus { 3.8, 1 translate 128*y }
  cylinder { 128*y, 137*y, 4.8 }
  torus { 5, 1 translate 137*y }
  cone
  {
    137*y, 6,
    144*y, 1
  }
  sphere { 148*y, 5 }
  cone
  {
    152*y, 1.5,
    162*y, 0
  }
  texture { T_FerKhaki }
}

#declare lg_grille = 3785;

#declare Grille =
union
{
  box
  {
    <350,0,-7.5>,
    <lg_grille,52,7.5>
    texture { T_Murette }
  }

  union
  {
    #declare b = 15;
    #declare a = 1;
    #while (b < lg_grille)
      #if (mod(b,315))
        cylinder
        {
          <(355 + b),55,0>,
          <(355 + b),180,0>,
          1
        }
      #else
        cone
        {
          <(355 + b),52,0>, 2
          <(355 + b),180,0>, 1
        }
      #end
        cone
        {
          <(347.5 + b),55,0>, 1
          <(347.5 + b),65,0>, 0.2
        }
      #if (a > 0)
        cone
        {
          <(355 + b),180,0>, 1
          <(355 + b),200,0>, 0.2
        }
        #declare r = 0;
        #while (r < 360)
          intersection
          {
            difference
            {
              cylinder
              {
                <12.5,12.5, 0.5>,
                <12.5,12.5,-0.5>
                12.5
              }
              cylinder
              {
                <12.5,12.5, 1>,
                <12.5,12.5,-1>
                12
              }
            }
            box
            {
              <-1,12.5, 1>
              <12.5,-1,-1>
            }
            rotate r*z
            translate <(355 + b),180,0> 
          }
        #declare r = r + 90;
        #end
      #else
        cone
        {
          <(355 + b),180,0>, 1
          <(355 + b),190,0>, 0.2
        }
      #end
    #declare a = -a;
    #declare b = b + 15;
    #end
    box
    {
      <355,54,-1>
      <lg_grille,55,1>
    }
    box
    {
      <355,180,-1>
      <lg_grille,181,1>
    }
    texture { T_FerKhaki }
  }
  object { Poteau translate <355,52,0> }
  object { Poteau translate <lg_grille,52,0> } 
  translate -8*x
}
  
#declare Portail =
union
{
  cylinder
  {
    <2, 0,0>
    <2,55,0>
    2
  }
  cone
  {
    <2,52,0>, 2
    <2,180,0>, 1
  }
  cylinder
  {
    <212, 0,0>
    <212,55,0>
    2
  }
  cone
  {
    <212,52,0>, 2
    <212,180,0>, 1
  }
  box
  {
    <2, 3,-0.1>
    <212,54, 0.1>
  }

  box
  {
    <2, 3,-1>
    <222,4, 1>
  }
  box
  {
    <2, 54,-1>
    <222,55, 1>
  }
  box
  {
    <2, 180,-1>
    <222,181, 1>
  }

  difference
  { 
    box
    {
      <10, 7,-1>
      <50,49, 1>
    }
    box
    {
      <11, 8,-2>
      <49,48, 2>
    }
  }
  prism
  {
    conic_sweep
    linear_spline
    0,1
    5
    < 20, 20.5>, <-20, 20.5>, <-20,-20.5>, < 20,-20.5>, < 20, 20.5>
    rotate <90,0,0>
    translate <30,27.5,-1.1>
  }
  
  difference
  { 
    box
    {
      <164, 7,-1>
      <204,49, 1>
    }
    box
    {
      <165, 8,-2>
      <203,48, 2>
    }
  }
  prism
  {
    conic_sweep
    linear_spline
    0,1
    5
    < 20, 20.5>, <-20, 20.5>, <-20,-20.5>, < 20,-20.5>, < 20, 20.5>
    rotate <90,0,0>
    translate <184,27.5,-1.1>
  }
  
  difference
  { 
    box
    {
      <55, 7,-1>
      <159,49, 1>
    }
    box
    {
      <56, 8,-2>
      <158,48, 2>
    }
  }
  prism
  {
    conic_sweep
    linear_spline
    0,1
    5
    < 51, 20.5>, <-51, 20.5>, <-51,-20.5>, < 51,-20.5>, < 51, 20.5>
    rotate <90,0,0>
    translate <107,27.5,-1.1>
  }
  
  box
  {
    <230, 3,-1>
    <355, 4, 1>
  }
  box
  {
    <230,55,-1>
    <355,54, 1>
  }
  box
  {
    <230,180,-1>
    <355,181, 1>
  }
  cone
  {
    <2,180,0>, 1
    <2,200,0>, 0.2
  }
  #declare r = 0;
  #while (r <= 180)
    intersection
    {
      difference
      {
        cylinder
        {
          <12.5,12.5, 0.5>,
          <12.5,12.5,-0.5>
          12.5
        }
        cylinder
        {
          <12.5,12.5, 1>,
          <12.5,12.5,-1>
          12
        }
      }
      box
      {
        <-1,12.5, 1>
        <12.5,-1,-1>
      }
      //#if (s < 0)
        rotate 180*y
      //#end
      rotate r*x
      translate <2,180,0> 
    }
  #declare r = r + 180;
  #end
  
  #declare b = 2;
  #declare a = -1;
  #while (b < 212)
    cylinder
    {
      <(15 + b),55,0>,
      <(15 + b),180,0>,
      1
    }
    cone
    {
      <(7.5 + b),55,0>, 1
      <(7.5 + b),65,0>, 0.2
    }
    #if (a > 0)
      cone
      {
        <(15 + b),180,0>, 1
        <(15 + b),200,0>, 0.2
      }
      #if (b = 197)
        #declare r = 90;
        #declare rr = 270;
      #else
        #declare r = 0;
        #declare rr = 360;
      #end
      #while (r < rr)

        intersection
        {
          difference
          {
            cylinder
            {
              <12.5,12.5, 0.5>,
              <12.5,12.5,-0.5>
              12.5
            }
            cylinder
            {
              <12.5,12.5, 1>,
              <12.5,12.5,-1>
              12
            }
          }
          box
          {
            <-1,12.5, 1>
            <12.5,-1,-1>
          }
          rotate r*z
          translate <(15 + b),180,0> 
        }
        #declare r = r + 90;
      #end
    #else
      cone
      {
        <(15 + b),180,0>, 1
        <(15 + b),190,0>, 0.2
      }
    #end
  #declare a = -a;
  #declare b = b + 15;
  #end

  texture { T_FerKhaki }
  translate -222*x
  rotate PortailOuvert*y
  translate 222*x
}

#declare Portillon =
union
{
  cylinder
  {
    <240, 0,0>
    <240,55,0>
    2
  }
  cone
  {
    <240,52,0>, 2
    <240,180,0>, 1
  }
  cylinder
  {
    <345, 0,0>
    <345,55,0>
    2
  }
  cone
  {
    <345,52,0>, 2
    <345,180,0>, 1
  }
  box
  {
    <240, 3,-0.1>
    <345,54, 0.1>
  }

  difference
  { 
    box
    {
      <245, 7,-1>
      <340,49, 1>
    }
    box
    {
      <246, 8,-2>
      <339,48, 2>
    }
  }
  prism
  {
    conic_sweep
    linear_spline
    0,1
    5
    < 46.5, 20.5>, <-46.5, 20.5>, <-46.5,-20.5>, < 46.5,-20.5>, < 46.5, 20.5>
    rotate <90,0,0>
    translate <292.5,27.5,-1.1>
  }
  
  box
  {
    <230, 3,-1>
    <355, 4, 1>
  }
  box
  {
    <230,55,-1>
    <355,54, 1>
  }
  box
  {
    <230,180,-1>
    <355,181, 1>
  }
  cone
  {
    <240,180,0>, 1
    <240,200,0>, 0.2
  }
  #declare r = 0;
  #while (r <= 180)
    intersection
    {
      difference
      {
        cylinder
        {
          <12.5,12.5, 0.5>,
          <12.5,12.5,-0.5>
          12.5
        }
        cylinder
        {
          <12.5,12.5, 1>,
          <12.5,12.5,-1>
          12
        }
      }
      box
      {
        <-1,12.5, 1>
        <12.5,-1,-1>
      }
      rotate r*x
      translate <240,180,0> 
    }
  #declare r = r + 180;
  #end
  
  #declare b = 0;
  #declare a = -1;
  #while (b < 105)
    cylinder
    {
      <(255 + b),55,0>,
      <(255 + b),180,0>,
      1
    }
    cone
    {
      <(247.5 + b),55,0>, 1
      <(247.5 + b),65,0>, 0.2
    }
    #if (a > 0)
      cone
      {
        <(255 + b),180,0>, 1
        <(255 + b),200,0>, 0.2
      }
      #declare r = 0;
      #while (r < 360)
        intersection
        {
          difference
          {
            cylinder
            {
              <12.5,12.5, 0.5>,
              <12.5,12.5,-0.5>
              12.5
            }
            cylinder
            {
              <12.5,12.5, 1>,
              <12.5,12.5,-1>
              12
            }
          }
          box
          {
            <-1,12.5, 1>
            <12.5,-1,-1>
          }
          rotate r*z
          translate <(255 + b),180,0> 
        }
      #declare r = r + 90;
      #end
    #else
      cone
      {
        <(255 + b),180,0>, 1
        <(255 + b),190,0>, 0.2
      }
    #end
  #declare a = -a;
  #declare b = b + 15;
  #end
  translate -8*x
  texture { T_FerKhaki }
}

#declare Grilles =
union
{
  object { Grille }
  object { Portillon }
  object { Portail }
  object { Grille scale <-1,1,1>}
  object { Portillon scale <-1,1,1>}
  object { Portail scale <-1,1,1>}
}

////////////////////////////////////////////////////////////////////////////////
// Le Chateau
////////////////////////////////////////////////////////////////////////////////

#declare TrouFenetreRC =
union
{
  box
  {
    <-55,150,-50>
    < 55,410, 50>
  }
  intersection
  {
    cylinder
    {
      <0,200,-50>
      <0,200, 50>
      220
    }
    box
    {
      <-55,410,-100>
      < 55,500, 100>
    }
  }
}

#declare Cadre1FenetreRC =
union
{
  box
  {
    <-57,150,0>
    < 57,410,50>
  }
  intersection
  {
    cylinder
    {
      <0,200,0>
      <0,200,50>
      222
    }
    box
    {
      <-57,410,-100>
      < 57,500, 100>
    }
  }
}

#declare Cadre2FenetreRC =
union
{
  box
  {
    <-15,415,-30>
    < 15,455,3>
  }
  #declare __kghjhv =
  union
  {
    intersection
    {
      sphere
      {
        0, 18
        scale <1,0.6,0.3>
        translate <-5,440,2>
      }
      box
      {
        < 0,440,50>
        <15,455,-50>
      }
    }
    intersection
    {
      sphere
      {
        0, 18
        scale <1,1.3,0.3>
        translate <-5,440,2>
      }
      box
      {
        < 0,440,50>
        <15,415,-50>
      }
    }
  }
  object { __kghjhv }
  object { __kghjhv scale <-1,1,1> }

  intersection
  {
    difference
    {
      cylinder
      {
        <0,200,0>
        <0,200,0.5>
        235
      }
      cylinder
      {
        <0,200,-1>
        <0,200,10>
        230
      }
    }
    box
    {
      <-75,410,-100>
      < 75,500, 100>
    }
  }
  box
  {
    <-75,370+50,0>
    <-70,330+50,0.5>
  }
  box
  {
    < 75,370+50,0>
    < 70,330+50,0.5>
  }
  box
  {
    <-65,325+50,0>
    <-70,150,0.5>
  }
  box
  {
    < 65,325+50,0>
    < 70,150,0.5>
  }
  box
  {
    <-2.5, 5,0>
    < 2.5,-5,0.5>
    rotate -45*z
    translate <70,327.5+50,0>
  }
  box
  {
    <-2.5, 5,0>
    < 2.5,-5,0.5>
    rotate 45*z
    translate <-70,327.5+50,0>
  }
  
  intersection
  {
    difference
    {
      cylinder
      {
        <0,150+50,1>
        <0,150+50,0.5>
        235
      }
      cylinder
      {
        <0,150+50,-1>
        <0,150+50,10>
        231.5
      }
    }
    box
    {
      <-75,360+50,-100>
      < 75,500, 100>
    }
  }
  box
  {
    <-75,371+50,1>
    <-71.5,330+50,0.5>
  }
  box
  {
    < 75,371+50,1>
    < 71.5,330+50,0.5>
  }
  box
  {
    <-66.5,325+50,1>
    <-70,150,0.5>
  }
  box
  {
    < 66.5,325+50,1>
    < 70,150,0.5>
  }
  box
  {
    <-1, 5,1>
    < 2.5,-4,0.5>
    rotate -45*z
    translate <70,327.5+50,0>
  }
  box
  {
    <-2.5, 5,1>
    < 1,-4,0.5>
    rotate 45*z
    translate <-70,327.5+50,0>
  }

  intersection
  {
    difference
    {
      cylinder
      {
        <0,150+50,1>
        <0,150+50,1.5>
        235
      }
      cylinder
      {
        <0,150+50,-1>
        <0,150+50,10>
        233
      }
    }
    box
    {
      <-75,360+50,-100>
      < 75,500, 100>
    }
  }
  box
  {
    <-75,372+50,1>
    <-73,330+50,1.5>
  }
  box
  {
    < 75,372+50,1>
    < 73,330+50,1.5>
  }
  box
  {
    <-68,325+50,1>
    <-70,150,1.5>
  }
  box
  {
    < 68,325+50,1>
    < 70,150,1.5>
  }
  box
  {
    <-0, 5,1>
    < 2.5,-3,1.5>
    rotate -45*z
    translate <70,327.5+50,0>
  }
  box
  {
    <-2.5, 5,1>
    < 0,-3,1.5>
    rotate 45*z
    translate <-70,327.5+50,0>
  }
  // On pose la fentre
  union
  {
    box
    {
      <-55,150,-30>
      < 55,155,-35>
    }
    box
    {
      <-55,250,-30>
      < 55,255,-35>
    }
    box
    {
      <-55,350,-30>
      < 55,355,-35>
    }
    box
    {
      <-55,150,-30>
      <-50,410,-35>
    }
    box
    {
      <-4,150,-30>
      < 4,420,-35>
    }
    box
    {
      <-2,150,-29>
      < 2,420,-30>
    }
    box
    {
      < 55,150,-30>
      < 50,410,-35>
    }
    intersection
    {
      difference
      {
        cylinder
        {
          <0,200,-30>
          <0,200,-35>
          220
        }
        cylinder
        {
          <0,200,-50>
          <0,200, 50>
          215
        }
      }
      box
      {
        <-55,410,-100>
        < 55,500, 100>
      }
    }
    pigment { White }
  }
  box
  {
    <-55,150,-34>
    < 55,420,-33>
    texture { T_Vitre }
  }
}

#declare PilierBalcon =
union
{
  box
  {
    < 7.5,0, 7.5>
    <-7.5,3,-7.5>
  }
  box
  {
    < 7.5,50, 7.5>
    <-7.5,47,-7.5>
  }
  sphere
  {
    20*y, 9
  }
  difference
  {
    cylinder
    {
      <0, 3,0>
      <0,47,0>
      6
    }
    union
    {
      torus
      {
        9,5
        translate <0,8.25,0>
      }
      torus
      {
        9,5
        scale <1,3,1>
        translate <0,40,0>
      }
    }
  }
  cylinder
  {
    47*y, 46*y
    6
  }
  torus
  {
    4.2,1
    translate <0,46,0>
  }
  torus
  {
    4,0.75
    translate <0,40,0>
  }
  torus
  {
    3.9 ,0.5
    translate <0,39.25,0>
  }
  torus
  {
    6 ,0.5
    translate <0,12.75,0>
  }
}

// Porche d'entre

#declare MPorcheEst =
union
{
  //colonnes
  box
  {
    <170,  0,-250>
    <100,100,-180>
    texture { T_MurSale4 translate <50,0,50> }
  }
  prism
  {
    conic_sweep
    linear_spline
    0.9, 1,
    5,
    <-33,-33>, <-33, 33>, < 33, 33>, < 33,-33>, <-33,-33>
    rotate 180*z
    translate y
    scale <1,300,1>
    translate <135,100,-215>
  }
  union
  {
    cylinder
    {
      <29.5,130,29.5>
      <29.5,130,-29.5>
      2.5
    }
    cylinder
    {
      <-29.5,130,29.5>
      <-29.5,130,-29.5>
      2.5
    }
    cylinder
    {
      < 29.5,130,29.5>
      <-29.5,130,29.5>
      2.5
    }
    cylinder
    {
      < 29.5,130,-29.5>
      <-29.5,130,-29.5>
      2.5
    }
    intersection
    {
      cylinder { 0, 4*x, 2.5 }
      cylinder { 0,-4*z, 2.5 }
      translate <29.5,130,-29.5> 
    }
    intersection
    {
      cylinder { 0,-4*x, 2.5 }
      cylinder { 0,-4*z, 2.5 }
      translate <-29.5,130,-29.5> 
    }
    intersection
    {
      cylinder { 0, 4*x, 2.5 }
      cylinder { 0, 4*z, 2.5 }
      translate <29.5,130,29.5> 
    }

    translate <135,0,-215>
  }
  union
  {
    cylinder
    {
      <25,140,25>
      <25,140,-25>
      2.5
    }
    cylinder
    {
      <-25,140,25>
      <-25,140,-25>
      2.5
    }
    cylinder
    {
      < 25,140,25>
      <-25,140,25>
      2.5
    }
    cylinder
    {
      < 25,140,-25>
      <-25,140,-25>
      2.5
    }
    intersection
    {
      cylinder { 0, 4*x, 2.5 }
      cylinder { 0,-4*z, 2.5 }
      translate <25,140,-25> 
    }
    intersection
    {
      cylinder { 0,-4*x, 2.5 }
      cylinder { 0,-4*z, 2.5 }
      translate <-25,140,-25> 
    }
    intersection
    {
      cylinder { 0, 4*x, 2.5 }
      cylinder { 0, 4*z, 2.5 }
      translate <25,140,25> 
    }
    translate <135,0,-215>
  }
  prism
  {
    conic_sweep
    linear_spline
    0.83, 1,
    5,
    <-30,-30>, <-30, 30>, < 30, 30>, < 30,-30>, <-30,-30>
    rotate 180*z
    translate y
    scale <1,58,1>
    translate <135,131,-215>
  }
  box
  {
    < 25,140, 25>
    <-25,450,-25>
    translate <135,0,-215>
  }
  box
  {
    <100, 45,-240>
    < 70,100,-225>
  }
  prism
  {
    conic_sweep
    linear_spline
    0.8, 1,
    5,
    <-15,-5>, <-15, 5>, < 15, 5>, < 15,-5>, <-15,-5>
    rotate 180*z
    translate y
    scale <1,80,1>
    translate <85,100,-235>
  }
  box
  {
    < 13,16, 4.5>
    <-13,20,-4.5>
    translate <85,100,-235>
  }

  prism
  {
    conic_sweep
    linear_spline
    0.8, 1,
    5,
    <-32,-32>, <-32, 32>, < 32, 32>, < 32,-32>, <-32,-32>
    scale <1,200,1>
    translate <135,290,-215>
  }
  box
  {
    < 110,450,-236>
    <-110,490,-220>
  }


  // marches
  cylinder
  {
    <100, 0,-250>
    <100,15,-250>
    68
  }
  box
  {
    <100, 0,-250>
    <  0,15,-318>
  }
  cylinder
  {
    <100,13,-318>
    <  0,13,-318>
    2
  }
  torus
  {
    68, 2
    translate <100, 13,-250>
  }
  cylinder
  {
    <100,15,-250>
    <100,30,-250>
    33
  }
  box
  {
    <100,15,-200>
    <  0,30,-283>
  }
  cylinder
  {
    <100,28,-283>
    <  0,28,-283>
    2
  }
  torus
  {
    33, 2
    translate <100, 28,-250>
  }
  box
  {
    <100,30,-248>
    <  0,45,0>
  }
  cylinder
  {
    <100,43,-248>
    <  0,43,-248>
    2
  }
  // cts
  box
  {
    <165,  0,   0>
    <120,100,-180>
    texture { T_MurSale4 }
  }
  box
  {
    <160,150,  0>
    <120,100,-35>
  }
  box
  {
    <160,150,-145>
    <120,100,-200>
  }
  box
  {
    <159,150,-145>
    <120,100,-35>
  }
  difference
  {
    box
    {
      <158,150,   0>
      <120,450,-200>
    }
    union
    {
      object
      {
        TrouFenetreRC
        rotate 90*y
        translate <130,0,-90>
      }
      object
      {
        Cadre1FenetreRC
        rotate 90*y
        translate <156,0,-90>
      }
    }
  }
  object
  {
    Cadre2FenetreRC
    rotate 90*y
    translate <158,0,-90>
  }
  box
  {
    <159,450,   0>
    <120,490,-200>
  }

  // balcon
  box
  {
    < 160,500,-240>
    < 110,510,-190>
    texture { T_MurSale3 }
  }

  box
  {
    < 158,510,-238>
    < 112,560,-192>
    texture { T_MurSale3b }
  }
  box
  {
    < 160,560,-240>
    < 110,570,-190>
  }
  cylinder
  {
    < 160,568,-240>
    < 160,568,-190>
    2
  }
  cylinder
  {
    < 110,568,-240>
    < 110,568,-190>
    2
  }
  cylinder
  {
    < 160,568,-240>
    < 110,568,-240>
    2
  }
  cylinder
  {
    < 160,568,-190>
    < 110,568,-190>
    2
  }
  intersection
  {
    cylinder { 0, 3*x,2 }
    cylinder { 0,-3*z,2 }
    translate <160,568,-240>
  }
  intersection
  {
    cylinder { 0,-3*x,2 }
    cylinder { 0,-3*z,2 }
    translate <110,568,-240>
  }
  intersection
  {
    cylinder { 0, 3*x,2 }
    cylinder { 0, 3*z,2 }
    translate <160,568,-190>
  }
  intersection
  {
    cylinder { 0,-3*x,2 }
    cylinder { 0, 3*z,2 }
    translate <110,568,-190>
  }
  
  box
  {
    < 150,560,0>
    < 120,570,-190>
  }
  cylinder
  {
    < 150,568,0>
    < 150,568,-190>
    2
  }
  cylinder
  {
    < 120,568,0>
    < 120,568,-190>
    2
  }

  box
  {
    <120,500,0>
    <150,510,-190>
    texture { T_MurSale3 }
  }
  
  #declare p = -176.25;
  #while (p < 0)
  object
  {
    PilierBalcon
    translate < 135,510,p>
  }
  #declare p = p + 27.5;
  #end

  texture { T_MurClaire }
}

#declare EncadrementPorteEst =
union
{
  difference
  {
    box
    {
      < 150, 45,-235>
      <-150,450,-220>
    }
    union
    {
      box
      {
        < 85, 45,-250>
        <-85,345,-200>
      }
      cylinder
      {
        <0,345,-250>
        <0,345,-200>
        85
      }
    }
  }
  cylinder
  {
    < 85, 45,-225>
    < 85,345,-225>
    10
  }
  cylinder
  {
    <-85, 45,-225>
    <-85,345,-225>
    10
  }
  difference
  {
    torus
    {
      85, 10
      rotate 90*x
      translate <0,345,-225>
    }
    box
    {
      <-100,345,-250>
      < 100,  0,-200>
    }
  }

  cylinder
  {
    < 87, 45,-235>
    < 87,345,-235>
    2
  }
  cylinder
  {
    <-87, 45,-235>
    <-87,345,-235>
    2
  }
  difference
  {
    torus
    {
      87, 2
      rotate 90*x
      translate <0,345,-235>
    }
    box
    {
      <-100,345,-250>
      < 100,  0,-200>
    }
  }

  cylinder
  {
    < 93, 45,-235>
    < 93,345,-235>
    4
  }
  cylinder
  {
    <-93, 45,-235>
    <-93,345,-235>
    4
  }
  difference
  {
    torus
    {
      93, 4
      rotate 90*x
      translate <0,345,-235>
    }
    box
    {
      <-100,345,-250>
      < 100,  0,-200>
    }
  }
  union
  {
    box
    {
      < 169,490,   0>
      <-169,496,-249>
    }
    box
    {
      < 170,496,   0>
      <-170,498,-250>
    }
    box
    {
      < 171,498,   0>
      <-171,500,-251>
    }
  
    box
    {
      <-110,500,-230>
      < 110,510,-200>
    }
    texture { T_MurSale3 }
  }
  box
  {
    <-110,560,-230>
    < 110,570,-200>
  }
  cylinder
  {
    <-110,568,-230>
    < 110,568,-230>
    2
  }
  cylinder
  {
    <-110,568,-200>
    < 110,568,-200>
    2
  }
  #declare p = -96.25;
  #while (p < 110)
  object
  {
    PilierBalcon
    translate <p,510,-215>
    texture { T_MurSale3b }
  }
  #declare p = p + 27.5;
  #end

  texture { T_MurClaire }
}

#declare PorteEst =
union
{
  difference
  {
    cylinder
    {
      <0,345,-225>
      <0,345,-215>
      75
    }
    box
    {
      <-100,345,-250>
      < 100,  0,-200>
    }
  }
  box
  {
    <-75,345,-230>
    < 75,340,-225>
    texture { T_Bois rotate 90*z }
  }
  cylinder
  {
    <0, 45,-225>
    <0,420,-225>
    2.5
  }
  box
  {
    <-75,345,-225>
    < 75, 45,-215>
  }
  
  #declare Motif =
  union
  {
    sphere
    {
      <10,410,-225>, 2
    }
    cylinder
    {
      <10,355,-225>
      <10,410,-225>
      2
    }
    sphere
    {
      <10,355,-225>, 2
    }
    cylinder
    {
      <10,355,-225>
      <65,355,-225>
      2
    }
    sphere
    {
      <65,355,-225>, 2
    }
    intersection
    {
      torus
      {
        66, 2
        rotate 90*x
        translate <0,345,-225>
      }
      box
      {
        <10,355,-230>
        <80,450,-220>
      }
    }

    box
    {
      <75  ,120,-225>
      < 2.5,115,-230>
    }
    prism
    {
      linear_spline
      conic_sweep
      0.9,1,5
      <-27.5,-25>,<-27.5,25>,<27.5,25>,<27.5,-25>,<-27.5,-25>
      rotate 90*x
      scale <1,1,50>
      translate <35,80,-275>
    }
    prism
    {
      linear_spline
      conic_sweep
      0.9,1,5
      <-20,-10>,<-20,10>,<20,10>,<20,-10>,<-20,-10>
      rotate 90*x
      scale <1,1,50>
      translate <37.5,145,-275>
    }
    difference
    {
      box
      {
        <-25,0,-15>
        < 25,5, 15>
      }
      box
      {
        <-22.5,-1,-12.5>
        < 22.5,10, 12.5>
      }
      rotate 90*x
      translate <37.5,145,-230>
    }
    sphere
    {
      0,2
      scale <2.5,5,2>
      translate <37.5,175,-225>
    }
    cylinder
    {
      <65,175,-225>
      <10,175,-225>
      2
    }
    sphere
    {
      <65,175,-225>
      2
    }
    sphere
    {
      <10,175,-225>
      2
    }
    cylinder
    {
      <65,175,-225>
      <65,315,-225>
      2
    }
    cylinder
    {
      <10,175,-225>
      <10,315,-225>
      2
    }
    difference
    {
      union
      {
        torus
        {
          13.75,2
          rotate 90*x
          translate <23.75,315,-225>
        }
        torus
        {
          13.75,2
          rotate 90*x
          translate <51.75,315,-225>
        }
      }
      box
      {
        <75,315,-220>
        < 0,250,-230>
      }
    }
    sphere
    {
      0,2
      scale <2.5,5,2>
      translate <37.5,310,-225>
    }
  }
  object { Motif }
  object { Motif scale <-1,1,1> }

  texture { T_Bois rotate 90*x }
}

#declare FacadeRCEst1 =
union
{
  box
  {
    <1040, 0,-5>
    <120,100,45>
    texture { T_MurSale4 }
  }
  box
  {
    <120,100,-2>
    <200,150,45>
  }
  box
  {
    <200,100,-1> //255
    <310,150,45>
  }
  box
  {
    <310,150,45>
    <430,100,-2>
  }
  box
  {
    <430,100,-1> //485
    <540,150,45>
  }
  box
  {
    <540,150,45>
    <640,100,-2>
  }
  box
  {
    <640,100,-1> //695
    <750,150,45>
  }
  box
  {
    <750,150,45>
    <850,100,-2>
  }
  box
  {
    <850,100,-1> //905
    <960,150,45>
  }
  box
  {
    <960,150,45>
    <1040,100,-2>
  }
  difference
  {
    box
    {
      < 120,150,0>
      <1040,490,45>
      texture { T_MurMap translate 150*y }
    }
    object
    {
      TrouFenetreRC
      translate <255,0,30>
    }
    object
    {
      TrouFenetreRC
      translate <485,0,30>
    }
    object
    {
      TrouFenetreRC
      translate <695,0,30>
    }
    object
    {
      TrouFenetreRC
      translate <905,0,30>
    }

    object
    {
      Cadre1FenetreRC
      rotate 180*y
      translate <255,0,2>
    }
    object
    {
      Cadre1FenetreRC
      rotate 180*y
      translate <485,0,2>
    }
    object
    {
      Cadre1FenetreRC
      rotate 180*y
      translate <695,0,2>
    }
    object
    {
      Cadre1FenetreRC
      rotate 180*y
      translate <905,0,2>
    }
  }
  object
  {
    Cadre2FenetreRC
    rotate 180*y
    translate <255,0,0>
  }
  object
  {
    Cadre2FenetreRC
    rotate 180*y
    translate <485,0,0>
  }
  object
  {
    Cadre2FenetreRC
    rotate 180*y
    translate <695,0,0>
  }
  object
  {
    Cadre2FenetreRC
    rotate 180*y
    translate <905,0,0>
  }
  
  texture { T_MurClaire }
}

// Ailes
#declare AilesRC =
union
{
  // cts
  box
  {
    < 995,  0,  10>
    <1040,100,-180>
    texture { T_MurSale4 }
  }
  box
  {
    <1000,150, 10>
    <1040,100,-35>
  }
  box
  {
    <1000,150,-145>
    <1040,100,-200>
  }
  box
  {
    <1001,150,-145>
    <1040,100,-35>
  }
  difference
  {
    box
    {
      <1007,150,  10>
      <1040,490,-200>
      texture { T_MurMap translate 150*y rotate 90*y }
    }
    union
    {
      object
      {
        TrouFenetreRC
        rotate -90*y
        translate <970,0,-90>
      }
      object
      {
        Cadre1FenetreRC
        rotate -90*y
        translate <1009,0,-90>
      }
    }
  }
  box
  {
    <1030,150,   0>
    <1040,490,-200>
    texture { T_MurMap translate 150*y rotate 90*y }
  }
  object
  {
    Cadre2FenetreRC
    rotate -90*y
    translate <1007,0,-90>
  }
  texture { T_MurClaire }
}

//colonnes RC
#declare ColScult =
union
{
  box
  {
    <-23, 0,-22>
    < 23,27,-23>
  }
  box
  {
    <-20, 3,-22>
    < 20,24,-25>
  }
  cylinder
  {
    -20*x, 20*x, 1.5
    scale <1,1.6,1>
    translate <0,3,-23>
  }
  cylinder
  {
    -20*x, 20*x, 1.5
    scale <1,1.6,1>
    translate <0,24,-23>
  }
  cylinder
  {
    3*y,24*y,1.5
    scale <1.6,1,1>
    translate <-20,0,-23>
  }
  cylinder
  {
    3*y,24*y,1.5
    scale <1.6,1,1>
    translate < 20,0,-23>
  }
  intersection
  {
    cylinder { 0*x,-2.4*x, 1.5 scale <1,1.6,1> }
    cylinder { 0*y,-2.4*y, 1.5 scale <1.6,1,1> }
    translate <-20,3,-23> 
  }
  intersection
  {
    cylinder { 0*x,-2.4*x, 1.5 scale <1,1.6,1> }
    cylinder { 0*y,-2.4*y, 1.5 scale <1.6,1,1> }
    rotate -90*z
    translate <-20,24,-23> 
  }
  intersection
  {
    cylinder { 0*x,-2.4*x, 1.5 scale <1,1.6,1> }
    cylinder { 0*y,-2.4*y, 1.5 scale <1.6,1,1> }
    rotate 180*z
    translate < 20,24,-23> 
  }
  intersection
  {
    cylinder { 0*x,-2.4*x, 1.5 scale <1,1.6,1> }
    cylinder { 0*y,-2.4*y, 1.5 scale <1.6,1,1> }
    rotate 90*z
    translate < 20,3,-23> 
  }
}    

#declare ColonneRC =
union
{
  box
  {
    < 35,  0, 35>
    <-35,100,-35>
    texture { T_MurSale4 translate <50,0,50> }
  }
  box
  {
    < 30,100, 30>
    <-30,150,-30>
  }
  box
  {
    <-23,150,-23>
    < 23,490, 23>
  }
  #declare h = 150;
  #while (h < 480)
  object { ColScult translate h*y }
  object { ColScult rotate 90*y translate h*y }
  #declare h = h + 28.33333;
  #end

  texture { T_MurClaire }
}


#declare FacadeEstAileRC =
union
{
  box
  {
    <1060,  0,-245>
    <1530,100,-185>
    texture { T_MurSale4 }
  }
  box
  {
    <1280,100,-239>
    <1390,150,-185>
  }
  box
  {
    <1050,100,-240>
    <1280,150,-185>
  }
  box
  {
    <1390,100,-240>
    <1540,150,-185>
  }
  difference
  {
    box
    {
      <1050,150,-233>
      <1550,490,-185>
      texture { T_MurMap translate 150*y }
    }
    union
    {
      object
      {
        TrouFenetreRC
        translate <1295,0,-210>
      }
      object
      {
        Cadre1FenetreRC
        translate <1295,0,-233>
      }
    }
  }
  object
  {
    Cadre2FenetreRC
    rotate 180*y
    translate <1295,0,-233>
  }

  texture { T_MurClaire }
}
  
#declare FacadeCoteRC =
union
{
  box
  {
    <1670,  0,-185>
    <1620,100,1015>
    texture { T_MurSale4 }
  }
  box
  {
    <1665,150,-185>
    <1620,100,1015>
  }
  difference
  {
    box
    {
      <1658,150,-185>
      <1620,490,1025>
      texture { T_MurMap translate 150*y rotate 90*y }
    }
    union
    {
      object
      {
        TrouFenetreRC
        rotate 90*y
        translate <1640,0,865>
      }
      object
      {
        TrouFenetreRC
        rotate 90*y
        translate <1640,0,637>
      }
      object
      {
        TrouFenetreRC
        rotate 90*y
        translate <1640,0,415>
      }
      object
      {
        TrouFenetreRC
        rotate 90*y
        translate <1640,0,30>
      }
      object
      {
        Cadre1FenetreRC
        rotate 90*y
        translate <1656,0,865>
      }
      object
      {
        Cadre1FenetreRC
        rotate 90*y
        translate <1656,0,637>
      }
      object
      {
        Cadre1FenetreRC
        rotate 90*y
        translate <1656,0,415>
      }
      object
      {
        Cadre1FenetreRC
        rotate 90*y
        translate <1656,0,30>
      }
    }
  }
  object
  {
    Cadre2FenetreRC
    rotate 90*y
    translate <1658,0,865>
  }
  object
  {
    Cadre2FenetreRC
    rotate 90*y
    translate <1658,0,637>
  }
  object
  {
    Cadre2FenetreRC
    rotate 90*y
    translate <1658,0,415>
  }
  object
  {
    Cadre2FenetreRC
    rotate 90*y
    translate <1658,0,30>
  }

  texture { T_MurClaire }
}

#declare FacadeOuestRC =
union
{
  box   // Peron Ouest de la longueur du chateau
  {
    <0 0,1010>
    <1600,70,1450>
    texture { T_MurSale4 }
  }

  box
  {
    <1050, 70,1075>
    <1540,100,1015>
  }
  box
  {
    <1050,100,1070>
    <1135,150,1015>
  }
  box
  {
    <1135,100,1069>
    <1245,150,1015>
  }
  box
  {
    <1245,100,1070>
    <1345,150,1015>
  }
  box
  {
    <1345,100,1069>
    <1455,150,1015>
  }
  box
  {
    <1455,100,1070>
    <1540,150,1015>
  }
  difference
  {
    box
    {
      <1030,150,1063>
      <1540,490,1015>
      texture { T_MurMap translate 150*y }
    }
    union
    {
      object
      {
        TrouFenetreRC
        translate <1400,0,1030>
      }
      object
      {
        Cadre1FenetreRC
        translate <1400,0,1061>
      }
      object
      {
        TrouFenetreRC
        translate <1190,0,1030>
      }
      object
      {
        Cadre1FenetreRC
        translate <1190,0,1061>
      }
    }
  }
  object
  {
    Cadre2FenetreRC
    translate <1400,0,1063>
  }
  object
  {
    Cadre2FenetreRC
    translate <1190,0,1063>
  }

  box
  {
    <1050, 70,1065>
    < 320,100,1015>
  }
  box
  {
    <1050,100,1060>
    <960,150,1015>
  }
  box
  {
    <960,100,1059>
    <850,150,1015>
  }
  box
  {
    <850,100,1060>
    <750,150,1015>
  }
  box
  {
    <750,100,1059>
    <640,150,1015>
  }
  box
  {
    <640,100,1060>
    <540,150,1015>
  }
  box
  {
    <540,100,1059>
    <430,150,1015>
  }
  box
  {
    <430,100,1060>
    <320,150,1015>
  }
  difference
  {
    box
    {
      <1050,150,1058>
      <345,490,1015>
      texture { T_MurMap translate 150*y }
    }
    union
    {
      object
      {
        TrouFenetreRC
        translate <905,0,1020>
      }
      object
      {
        Cadre1FenetreRC
        translate <905,0,1056>
      }
      object
      {
        TrouFenetreRC
        translate <695,0,1020>
      }
      object
      {
        Cadre1FenetreRC
        translate <695,0,1056>
      }
      object
      {
        TrouFenetreRC
        translate <485,0,1020>
      }
      object
      {
        Cadre1FenetreRC
        translate <485,0,1056>
      }
    }
  }
  object
  {
    Cadre2FenetreRC
    translate <905,0,1058>
  }
  object
  {
    Cadre2FenetreRC
    translate <695,0,1058>
  }
  object
  {
    Cadre2FenetreRC
    translate <485,0,1058>
  }
  box
  {
    <370,100,1015>
    <320,150,1100>
  }
  box
  {
    <365,150,1015>
    <320,490,1100>
  }

  texture { T_MurClaire }
}

#declare TrouPorteEntree =
difference
{
  box
  {
    < 130, 45,1120>
    <-130,490,1075>
    texture { T_MurMap translate 150*y }
  }
  union
  {
    box
    {
      < 65, 45,1000>
      <-65,345,1200>
    }
    cylinder
    {
      <0,345,1000>
      <0,345,1200>
      65
    }
    cone
    {
      <0,345,1120.05>, 80
      <0,345,1105>, 0
    }
    prism
    {
      linear_spline
      linear_sweep
      0, 1, 4
      <80,1120.05>,<0,1120.05>,<0,1105>,<80,1120.05>
      scale <1,245,1>
      translate 100*y
    }
    prism
    {
      linear_spline
      linear_sweep
      0, 1, 4
      <80,1120.05>,<0,1120.05>,<0,1105>,<80,1120.05>
      scale <-1,245,1>
      translate 100*y
    }
    
    cone
    {
      <0,345,1120.05>, 68.5
      <0,345,983>, 0
    }
    prism
    {
      linear_spline
      linear_sweep
      0, 1, 4
      <68.5,1120.05>,<0,1120.05>,<0,983>,<68.5,1120.05>
      scale <1,245,1>
      translate 100*y
    }
    prism
    {
      linear_spline
      linear_sweep
      0, 1, 4
      <68.5,1120.05>,<0,1120.05>,<0,983>,<68.5,1120.05>
      scale <-1,245,1>
      translate 100*y
    }
  }
}

#declare CadrePorteEntree =
union
{
  cylinder
  {
    <-80,100,1119>
    <-80,345,1119>
    1.5
  }
  cylinder
  {
    < 80,100,1119>
    < 80,345,1119>
    1.5
  }
  difference
  {
    torus
    {
      80,1.5
      rotate 90*x
      translate <0,345,1119>
    }
    box
    {
      < 100,345,1000>
      <-100,200,1200>
    }
  }
  cylinder
  {
    <-83,100,1119>
    <-83,345,1119>
    2
  }
  cylinder
  {
    < 83,100,1119>
    < 83,345,1119>
    2
  }
  difference
  {
    torus
    {
      83,2
      rotate 90*x
      translate <0,345,1119>
    }
    box
    {
      < 100,345,1000>
      <-100,200,1200>
    }
  }
  // On pose la porte
  union
  {
    box
    {
      <-65, 45,1080>
      <-60,345,1085>
    }
    box
    {
      < 65, 45,1080>
      < 60,345,1085>
    }
    difference
    {
      cylinder
      {
        <0,345,1080>
        <0,345,1085>
        65
      }
      union
      { 
        cylinder
        {
          <0,345,1000>
          <0,345,1200>
          60
        }
        box
        {
          <-70,200,1000>
          < 70,345,1200>
        }
      }
    }
    box
    {
      <-5, 90,1080>
      < 5,410,1085>
    }
    cylinder
    {
      <-5, 90,1085>
      < 5,410,1085>
      1
    }
    box
    {
      <-65, 90,1080>
      < 65,170,1085>
    }
    box
    {
      <-65,250,1080>
      < 65,255,1085>
    }
    box
    {
      <-65,340,1080>
      < 65,345,1085>
    }
    pigment { White }
  }
  box
  {
    <-65,170,1082>
    < 65,410,1083>
    texture { T_Vitre }
  }
  
}

#declare Entree =
union
{
  box
  {
    <-370, 70,1160>
    < 370,100,0>
  }
  cylinder
  {
    <-370,98,1160>
    < 370,98,1160>
    2
  }
  box
  {
    <-370,70,1180>
    < 370,90,0>
  }
  cylinder
  {
    <-370,88,1180>
    < 370,88,1180>
    2
  }
  box
  {
    <-370,70,1200>
    < 370,80,0>
  }
  cylinder
  {
    <-370,78,1200>
    < 370,78,1200>
    2
  }
  box
  {
    <-370,100,1100>
    <-310, 50,1204>
  }
  box
  {
    < 370,100,1100>
    < 310, 50,1204>
  }

  object { TrouPorteEntree translate 230*x }
  object { CadrePorteEntree translate 230*x }
  union
  {
    box
    {
      <-30,100,-30>
      < 30,150, 30>
    }
    box
    {
      <-25,150,-25>
      < 25,490, 25>
    }
    translate <115,0,1100>
  }
  object { TrouPorteEntree }
  object { CadrePorteEntree }

  
  union
  {
    box
    {
      <-30,100,-30>
      < 30,150, 30>
    }
    box
    {
      <-25,150,-25>
      < 25,490, 25>
    }
    translate <-115,0,1100>
  }
  object { TrouPorteEntree translate -230*x }
  object { CadrePorteEntree translate -230*x }

  texture { T_MurClaire }
}

#declare PlancherEtg =
union
{
  box
  {
    <1025,490,-8>
    <   0,496,1068>
  }
  box
  {
    <1025,496,-9>
    <   0,498,1069>
  }
  box
  {
    <1025,498,-10>
    <   0,500,1070>
  }

  box
  {
    <1593,490,-243>
    < 997,496,1073>
  }
  box
  {
    <1594,496,-244>
    < 996,498,1074>
  }
  box
  {
    <1595,498,-245>
    < 995,500,1075>
  }

  texture { T_MurSale3 }
}

// Etage

#declare CoinCylindrique =
intersection
{
  cylinder { 0, 4*x, 2 }
  cylinder { 0,-4*z, 2 }
  translate 568*y
}
    

#declare TrouFenetreEtg =
union
{
  box
  {
    <-55,500,-50>
    < 55,740, 50>
  }
  intersection
  {
    cylinder
    {
      <0,530,-50>
      <0,530, 50>
      220
    }
    box
    {
      <-55,740,-100>
      < 55,850, 100>
    }
  }
}

#declare Cadre1FenetreEtg =
union
{
  box
  {
    <-57,570,0>
    < 57,740,50>
  }
  intersection
  {
    cylinder
    {
      <0,530,0>
      <0,530,50>
      222
    }
    box
    {
      <-57,740,-100>
      < 57,850, 100>
    }
  }
}

#macro Cadre2Etg(tp)
union
{
  box
  {
    <-55,500,4>
    <-75,570,0>
  }
  object { CoinCylindrique rotate 180*y translate <-75,0,4> }
  object { CoinCylindrique rotate -90*y translate <-55,0,4> }
  cylinder
  {
    <-55,568,4>
    <-75,568,4>
    2
  }
  box
  {
    <-55,500,5>
    <-75,510,0>
    texture { T_MurSale3 }
  }
  box
  {
    <-55,560,5>
    <-75,570,0>
  }
  #if (tp = 0)
  #declare p = 22;
  object { PilierBalcon translate <0+p,    510,-15> }
  object { PilierBalcon translate <0+(p*2),510,-15> }
  object { PilierBalcon translate <0,      510,-15> }
  object { PilierBalcon translate <0-p,    510,-15> }
  object { PilierBalcon translate <0-(p*2),510,-15> }
  difference
  {
    union
    {
      box
      {
        <-57,460,9>
        <-73,490,0>
      }
      box
      {
        <57,460,9>
        <73,490,0>
      }
    }
    cylinder
    {
      < 80,0,9>
      <-80,0,9>
      5
      scale <1,4,1>
      translate 460*y
    }
  }
  

  #end
  box
  {
    < 55,500,4>
    < 75,570,0>
  }
  object { CoinCylindrique rotate -90*y translate <75,0,4> }
  object { CoinCylindrique rotate 180*y translate <55,0,4> }
  cylinder
  {
    < 55,568,4>
    < 75,568,4>
    2
  }
  box
  {
    < 55,500,5>
    < 75,510,0>
    texture { T_MurSale3 }
  }
  box
  {
    < 55,560,5>
    < 75,570,0>
  }
  
  cylinder
  {
    <0,765,3>
    <0,765,-30>
    15
  }
  #declare a = 0;
  #while (a < 360)
    sphere
    {
      <0,15,3>, 4
      scale <1,1,0.75>
      rotate a*z
      translate 765*y
    }
    #declare a = a + 30;
  #end
  #declare __boules =
  union
  {
    sphere { <22,767.5,0>, 8 }
    sphere { <36,765.5,0>, 7 }
    scale <1,1,0.75>
  }
  object { __boules }
  object { __boules scale <-1,1,1> }

  intersection
  {
    difference
    {
      cylinder
      {
        <0,530,0>
        <0,530,0.5>
        235
      }
      cylinder
      {
        <0,530,-1>
        <0,530,10>
        230
      }
    }
    box
    {
      <-75,740,-100>
      < 75,850, 100>
    }
  }
  box
  {
    <-75,750,0>
    <-70,710,0.5>
  }
  box
  {
    < 75,750,0>
    < 70,710,0.5>
  }
  box
  {
    <-65,705,0>
    <-70,570,0.5>
  }
  box
  {
    < 65,705,0>
    < 70,570,0.5>
  }
  box
  {
    <-2.5, 5,0>
    < 2.5,-5,0.5>
    rotate -45*z
    translate <70,707.5,0>
  }
  box
  {
    <-2.5, 5,0>
    < 2.5,-5,0.5>
    rotate 45*z
    translate <-70,707.5,0>
  }
  
  intersection
  {
    difference
    {
      cylinder
      {
        <0,530,1>
        <0,530,0.5>
        235
      }
      cylinder
      {
        <0,530,-1>
        <0,530,10>
        231.5
      }
    }
    box
    {
      <-75,740,-100>
      < 75,850, 100>
    }
  }
  box
  {
    <-75,751,1>
    <-71.5,710,0.5>
  }
  box
  {
    < 75,751,1>
    < 71.5,710,0.5>
  }
  box
  {
    <-66.5,705,1>
    <-70,570,0.5>
  }
  box
  {
    < 66.5,705,1>
    < 70,570,0.5>
  }
  box
  {
    <-1, 5,1>
    < 2.5,-4,0.5>
    rotate -45*z
    translate <70,707.5,0>
  }
  box
  {
    <-2.5, 5,1>
    < 1,-4,0.5>
    rotate 45*z
    translate <-70,707.5,0>
  }

  intersection
  {
    difference
    {
      cylinder
      {
        <0,530,1>
        <0,530,1.5>
        235
      }
      cylinder
      {
        <0,530,-1>
        <0,530,10>
        233
      }
    }
    box
    {
      <-75,740,-100>
      < 75,850, 100>
    }
  }
  box
  {
    <-75,752,1>
    <-73,710,1.5>
  }
  box
  {
    < 75,752,1>
    < 73,710,1.5>
  }
  box
  {
    <-68,705,1>
    <-70,570,1.5>
  }
  box
  {
    < 68,705,1>
    < 70,570,1.5>
  }
  box
  {
    <-0, 5,1>
    < 2.5,-3,1.5>
    rotate -45*z
    translate <70,707.5,0>
  }
  box
  {
    <-2.5, 5,1>
    < 0,-3,1.5>
    rotate 45*z
    translate <-70,707.5,0>
  }
  // On pose la fentre
  union
  {
    box
    {
      <-55,500,-30>
      < 55,505,-35>
    }
    box
    {
      <-55,680,-30>
      < 55,685,-35>
    }
    box
    {
      <-55,500,-30>
      <-50,740,-35>
    }
    box
    {
      <-4,500,-30>
      < 4,750,-35>
    }
    box
    {
      <-2,500,-29>
      < 2,750,-30>
    }
    box
    {
      < 55,500,-30>
      < 50,740,-35>
    }
    intersection
    {
      difference
      {
        cylinder
        {
          <0,530,-30>
          <0,530,-35>
          220
        }
        cylinder
        {
          <0,530,-50>
          <0,530, 50>
          215
        }
      }
      box
      {
        <-55,740,-100>
        < 55,850, 100>
      }
    }
    pigment { White }
  }
  box
  {
    <-55,500,-34>
    < 55,750,-33>
    texture { T_Vitre }
  }
}
#end

#declare Cadre2FenetreEtg = object { Cadre2Etg(0) }
#declare Cadre2PorteBalcon = object { Cadre2Etg(1) }

#declare FenetresEtg1 =
union
{
  object
  {
    TrouFenetreEtg
    translate <255,0,30>
  }
  object
  {
    TrouFenetreEtg
    translate <485,0,30>
  }
  object
  {
    TrouFenetreEtg
    translate <695,0,30>
  }
  object
  {
    TrouFenetreEtg
    translate <905,0,30>
  }
  object
  {
    Cadre1FenetreEtg
    rotate 180*y
    translate <255,0,2>
  }
  object
  {
    Cadre1FenetreEtg
    rotate 180*y
    translate <485,0,2>
  }
  object
  {
    Cadre1FenetreEtg
    rotate 180*y
    translate <695,0,2>
  }
  object
  {
    Cadre1FenetreEtg
    rotate 180*y
    translate <905,0,2>
  }
}  

#declare CadresEtg1 =
union
{
  object
  {
    Cadre2FenetreEtg
    rotate 180*y
    translate <255,0,0>
  }
  object
  {
    Cadre2FenetreEtg
    rotate 180*y
    translate <485,0,0>
  }
  object
  {
    Cadre2FenetreEtg
    rotate 180*y
    translate <695,0,0>
  }
  object
  {
    Cadre2FenetreEtg
    rotate 180*y
    translate <905,0,0>
  }
  box
  {
    <1040,560,-1>
    <  55,570,25>
  }
  cylinder
  {
    <1040,568,-1>
    <  55,568,-1>
    2
  }
  box
  {
    <1040,500,-1>
    <  55,510,25>
    texture { T_MurSale3 }
  }

}

#declare FacadeEtgEst =
union
{
  box
  {
    < 1040,800,-1>
    <-1040,806,45>
  }
  box
  {
    < 1040,806,-2>
    <-1040,808,45>
  }
  box
  {
    < 1040,808,-3>
    <-1040,810,45>
  }

  difference
  {
    box
    {
      < 1040,500,0>
      <-1040,850,45>
      texture { T_MurMap translate 500*y }
    }
    union
    {
      object
      {
        TrouFenetreEtg
        translate <0,0,30>
      }
      object
      {
        Cadre1FenetreEtg
        translate <0,0,2>
      }
    }
    object { FenetresEtg1 }
    object { FenetresEtg1 scale <-1,1,1> }
  }
  object
  {
    Cadre2PorteBalcon
    rotate 180*y
  }
  object { CadresEtg1 }
  object { CadresEtg1 scale <-1,1,1> }
  texture { T_MurClaire }
}

#declare ColonneEtg =
union
{
  box
  {
    < 28,500, 28>
    <-28,510,-28>
    texture { T_MurSale3 }
  }
  box
  {
    < 25,510, 25>
    <-25,560,-25>
  }
  box
  {
    < 28,560, 28>
    <-28,570,-28>
  }
  cylinder
  {
    <-28,568, 28>
    <-28,568,-28>
    2
  }
  cylinder
  {
    < 28,568,-28>
    <-28,568,-28>
    2
  }
  intersection
  {
    cylinder
    {
      <-28,568,-40>
      <-28,568,-28>
      2
    }
    cylinder
    {
      <-40,568,-28>
      <-28,568,-28>
      2
    }
  }
  
  box
  {
    < 23,570, 23>
    <-23,850,-23>
  }
  box
  {
    < 24,800, 24>
    <-24,806,-24>
  }
  box
  {
    < 25,806, 25>
    <-25,808,-25>
  }
  box
  {
    < 26,808, 26>
    <-26,810,-26>
  }
  
  texture { T_MurClaire }
}

// Ailes
#declare AilesEtg =
union
{
  box
  {
    <1006,560,10>
    <1040,570,-200>
  }
  cylinder
  {
    <1006,568,10>
    <1006,568,-200>
    2
  }
  box
  {
    <1006,500,10>
    <1040,510,-200>
    texture { T_MurSale3 }
  }

  box
  {
    <1006,800,10>
    <1040,806,-200>
  }
  box
  {
    <1005,806,10>
    <1040,808,-200>
  }
  box
  {
    <1004,808,10>
    <1040,810,-200>
  }
  difference
  {
    box
    {
      <1007,500,  10>
      <1040,850,-200>
      texture { T_MurMap translate 500*y rotate 90*y }
    }
    union
    {
      object
      {
        TrouFenetreEtg
        rotate -90*y
        translate <1000,0,-90>
      }
      object
      {
        Cadre1FenetreEtg
        rotate -90*y
        translate <1009,0,-90>
      }
    }
  }
  box
  {
    <1030,500,   0>
    <1040,850,-200>
    texture { T_MurMap translate 500*y rotate 90*y }
  }
  object
  {
    Cadre2FenetreEtg
    rotate -90*y
    translate <1007,0,-90>
  }
  texture { T_MurClaire }
}

#declare FacadeEstAileEtg =
union
{
  box
  {
    <1050,560,-234>
    <1540,570,-185>
  }
  cylinder
  {
    <1050,568,-234>
    <1540,568,-234>
    2
  }
  box
  {
    <1050,500,-234>
    <1540,510,-185>
    texture { T_MurSale3 }
  }

  box
  {
    <1050,800,-234>
    <1540,806,-185>
  }
  box
  {
    <1050,806,-235>
    <1540,808,-185>
  }
  box
  {
    <1050,808,-236>
    <1540,810,-185>
  }
  difference
  {
    box
    {
      <1050,500,-233>
      <1540,850,-185>
      texture { T_MurMap translate 500*y }
    }
    union
    {
      object
      {
        TrouFenetreEtg
        translate <1295,0,-210>
      }
      object
      {
        Cadre1FenetreEtg
        rotate 180*y
        translate <1295,0,-231>
      }
    }
  }
  object
  {
    Cadre2FenetreEtg
    rotate 180*y
    translate <1295,0,-233>
  }

  texture { T_MurClaire }
}
  
#declare FacadeCoteEtg =
union
{
  box
  {
    <1659,560,1025>
    <1620,570,-185>
  }
  cylinder
  {
    <1659,568,1025>
    <1659,568,-234>
    2
  }
  box
  {
    <1659,500,1025>
    <1620,510,-185>
    texture { T_MurSale3 }
  }

  box
  {
    <1659,800,1025>
    <1620,806,-185>
  }
  box
  {
    <1660,806,1025>
    <1620,808,-185>
  }
  box
  {
    <1661,808,1025>
    <1620,810,-185>
  }
  
  difference
  {
    box
    {
      <1658,500,-185>
      <1620,850,1025>
      texture { T_MurMap translate 500*y rotate 90*y }
    }
    union
    {
      object
      {
        TrouFenetreEtg
        rotate 90*y
        translate <1640,0,30>
      }
      object
      {
        TrouFenetreEtg
        rotate 90*y
        translate <1640,0,415>
      }
      object
      {
        TrouFenetreEtg
        rotate 90*y
        translate <1640,0,800>
      }
      object
      {
        Cadre1FenetreEtg
        rotate 90*y
        translate <1656,0,30>
      }
      object
      {
        Cadre1FenetreEtg
        rotate 90*y
        translate <1656,0,415>
      }
      object
      {
        Cadre1FenetreEtg
        rotate 90*y
        translate <1656,0,800>
      }
    }
  }
  object
  {
    Cadre2FenetreEtg
    rotate 90*y
    translate <1658,0,30>
  }
  object
  {
    Cadre2FenetreEtg
    rotate 90*y
    translate <1658,0,415>
  }
  object
  {
    Cadre2FenetreEtg
    rotate 90*y
    translate <1658,0,800>
  }

  texture { T_MurClaire }
}

#declare FacadeOuestEtg =
union
{
  box
  {
    <1030,560,1064>
    <1540,570,1015>
  }
  cylinder
  {
    <1030,568,1064>
    <1540,568,1064>
    2
  }
  box
  {
    <1030,500,1064>
    <1540,510,1015>
    texture { T_MurSale3 }
  }

  box
  {
    <1030,800,1064>
    <1540,806,1015>
  }
  box
  {
    <1030,806,1065>
    <1540,808,1015>
  }
  box
  {
    <1030,808,1066>
    <1540,810,1015>
  }
  difference
  {
    box
    {
      <1030,500,1063>
      <1540,850,1015>
      texture { T_MurMap translate 500*y }
    }
    union
    {
      object
      {
        TrouFenetreEtg
        translate <1400,0,1030>
      }
      object
      {
        Cadre1FenetreEtg
        translate <1400,0,1061>
      }
      object
      {
        TrouFenetreEtg
        translate <1190,0,1030>
      }
      object
      {
        Cadre1FenetreEtg
        translate <1190,0,1061>
      }
    }
  }
  object
  {
    Cadre2FenetreEtg
    translate <1400,0,1063>
  }
  object
  {
    Cadre2FenetreEtg
    translate <1190,0,1063>
  }

  box
  {
    <1050,560,1059>
    <345,570,1015>
  }
  cylinder
  {
    <1050,568,1059>
    <345,568,1059>
    2
  }
  box
  {
    <1050,500,1059>
    <345,510,1015>
    texture { T_MurSale3 }
  }
  box
  {
    <1050,800,1059>
    <345,806,1015>
  }
  box
  {
    <1050,806,1060>
    <345,808,1015>
  }
  box
  {
    <1050,808,1061>
    <345,810,1015>
  }
  difference
  {
    box
    {
      <1050,500,1058>
      < 345,850,1015>
      texture { T_MurMap translate 500*y }
    }
    union
    {
      object
      {
        TrouFenetreEtg
        translate <905,0,1020>
      }
      object
      {
        Cadre1FenetreEtg
        translate <905,0,1056>
      }
      object
      {
        TrouFenetreEtg
        translate <695,0,1020>
      }
      object
      {
        Cadre1FenetreEtg
        translate <695,0,1056>
      }
      object
      {
        TrouFenetreEtg
        translate <485,0,1020>
      }
      object
      {
        Cadre1FenetreEtg
        translate <485,0,1056>
      }
    }
  }
  object
  {
    Cadre2FenetreEtg
    translate <905,0,1058>
  }
  object
  {
    Cadre2FenetreEtg
    translate <695,0,1058>
  }
  object
  {
    Cadre2FenetreEtg
    translate <485,0,1058>
  }

  box
  {
    <366,560,1015>
    <320,570,1100>
  }
  cylinder
  {
    <366,568,1015>
    <366,568,1100>
    2
  }
  box
  {
    <366,500,1015>
    <320,510,1100>
    texture { T_MurSale3c }
  }
  box
  {
    <366,800,1015>
    <320,806,1100>
  }
  box
  {
    <367,806,1015>
    <320,808,1100>
  }
  box
  {
    <368,808,1015>
    <320,810,1100>
  }
  box
  {
    <365,500,1015>
    <320,850,1100>
  }
  texture { T_MurClaire }
}

#declare Balcon =
union
{
  union
  {
    box
    {
      < 370,490,1000>
      <-370,496,1300>
    }
    box
    {
      < 371,496,1000>
      <-371,498,1301>
    }
    box
    {
      < 372,498,1000>
      <-372,500,1302>
    }
    texture { T_MurSale3c }
  }
  
  #declare Bcote =
  union
  {
    box
    {
      <367.5,500,1100>
      <347.5,510,1280>
    }
    box
    {
      <367.5,560,1100>
      <347.5,570,1280>
    }
    cylinder
    {
      <367.5,568,1100>
      <367.5,568,1280>
      2
    }
    cylinder
    {
      <347.5,568,1100>
      <347.5,568,1280>
      2
    }
    
    box
    {
      <369,500,1299>
      <320,510,1269>
    }
    box
    {
      <367,560,1297>
      <320,510,1271>
    }
    box
    {
      <310,560,1295.5>
      <320,510,1262.5>
    }
    box
    {
      <369,562,1299>
      <320,570,1269>
    }
    box
    {
      <368,560,1298>
      <321,570,1270>
    }
    cylinder
    {
      <369,568,1269>
      <320,568,1269>
      2
    }
    cylinder
    {
      <369,568,1299>
      <320,568,1299>
      2
    }
    cylinder
    {
      <320,568,1269>
      <320,568,1299>
      2
    }
    cylinder
    {
      <369,568,1269>
      <369,568,1299>
      2
    }
    object { CoinCylindrique rotate -90*y translate <369,0,1299> }
    object { CoinCylindrique rotate 180*y translate <320,0,1299> }
    object { CoinCylindrique rotate  90*y translate <320,0,1269> }
    object { CoinCylindrique rotate   0*y translate <369,0,1269> }
    #declare p = 1143.75;
    #while (p < 1269)
    object
    {
      PilierBalcon
      translate < 357.5,510,p>
    }
    #declare p = p + 27.5;
    #end
    
    box
    {
      <142,500,1299>
      < 88,510,1269>
    }
    box
    {
      <140,560,1297>
      < 90,510,1271>
    }
    box
    {
      <140,560,1295.5>
      <150,510,1262.5>
    }
    box
    {
      < 90,560,1295.5>
      < 80,510,1262.5>
    }
    box
    {
      <142,562,1299>
      < 88,570,1269>
    }
    box
    {
      <141,560,1298>
      < 89,570,1270>
    }
    cylinder
    {
      <140,568,1269>
      < 90,568,1269>
      2
    }
    cylinder
    {
      <140,568,1299>
      < 90,568,1299>
      2
    }
    cylinder
    {
      < 90,568,1269>
      < 90,568,1299>
      2
    }
    cylinder
    {
      <140,568,1269>
      <140,568,1299>
      2
    }
    object { CoinCylindrique rotate -90*y translate <140,0,1299> }
    object { CoinCylindrique rotate 180*y translate < 90,0,1299> }
    object { CoinCylindrique rotate  90*y translate < 90,0,1269> }
    object { CoinCylindrique rotate   0*y translate <140,0,1269> }
    #declare p = 163.75;
    #while (p < 310)
    object
    {
      PilierBalcon
      translate <p,510,1284>
    }
    #declare p = p + 27.5;
    #end
  }
  object { Bcote }
  object { Bcote scale <-1,1,1> }
  #declare p = -66.75;
  #while (p < 80)
  object
  {
    PilierBalcon
    translate <p,510,1284>
  }
  #declare p = p + 27;
  #end
  box
  {
    < 320,500,1296.5>
    <-320,510,1261.5>
  }
  box
  {
    < 320,560,1296.5>
    <-320,570,1261.5>
  }
  cylinder
  {
    < 320,568,1296.5>
    <-320,568,1296.5>
    2
  }
  cylinder
  {
    < 320,568,1261.5>
    <-320,568,1261.5>
    2
  }

  texture { T_MurClaire }
}

#declare ColonneBalcon =
union
{
  box
  {
    < 28,500, 28>
    <-28,510,-28>
    texture { T_MurSale3c translate -1087*z}
  }
  box
  {
    < 25,510, 25>
    <-25,560,-25>
  }
  box
  {
    < 28,560, 28>
    <-28,570,-28>
  }
  cylinder
  {
    <-28,568, 28>
    <-28,568,-28>
    2
  }
  cylinder
  {
    < 28,568, 28>
    < 28,568,-28>
    2
  }
  cylinder
  {
    <-28,568, 28>
    < 28,568, 28>
    2
  }
  object { CoinCylindrique rotate -90*y translate <28,0,28> }
  object { CoinCylindrique rotate 180*y translate <-28,0,28> }
  
  box
  {
    < 23,570, 23>
    <-23,850,-23>
  }
  box
  {
    < 24,800, 24>
    <-24,806,-24>
  }
  box
  {
    < 25,806, 25>
    <-25,808,-25>
  }
  box
  {
    < 26,808, 26>
    <-26,810,-26>
  }
  
  texture { T_MurClaire }
}

#declare FacadeBalcon =
union
{
  difference
  {
    union
    {
      box
      {
        < 366,500,1121>
        <-366,510,1075>
      }
      box
      {
        < 366,560,1121>
        <-366,570,1075>
      }
      cylinder
      {
        < 366,568,1121>
        <-366,568,1121>
        2
      }
      box
      {
        < 366,800,1121>
        <-366,806,1075>
      }
      box
      {
        < 367,806,1122>
        <-367,808,1075>
      }
      box
      {
        < 368,808,1123>
        <-368,810,1075>
      }
      box
      {
        < 365,500,1120>
        <-365,850,1075>
        texture { T_MurMap translate 500*y }
      }
    }
    union
    {
      object
      {
        TrouFenetreEtg
        translate <-230,0,1090>
      }
      object
      {
        TrouFenetreEtg
        translate <0,0,1090>
      }
      object
      {
        TrouFenetreEtg
        translate <230,0,1090>
      }
      object
      {
        Cadre1FenetreEtg
        translate <-230,0,1118>
      }
      object
      {
        Cadre1FenetreEtg
        translate <0,0,1118>
      }
      object
      {
        Cadre1FenetreEtg
        translate <230,0,1118>
      }
    }
  }
  object
  {
    Cadre2PorteBalcon
    translate <-230,0,1120>
  }
  object
  {
    Cadre2PorteBalcon
    translate <0,0,1120>
  }
  object
  {
    Cadre2PorteBalcon
    translate <230,0,1120>
  }

  object
  {
    ColonneBalcon
    translate <115,0,1100>
  }
  object
  {
    ColonneBalcon
    translate <-115,0,1100>
  }
  object
  {
    ColonneBalcon
    translate <345,0,1100>
  }
  object
  {
    ColonneBalcon
    translate <-345,0,1100>
  }
  
  texture { T_MurClaire }
}

#declare PlancherCbl =
union
{
  box
  {
    <1025,850,-20>
    <   0,860,1075>
  }
  box
  {
    <1025,860,-22>
    <   0,865,1077>
  }
  box
  {
    <1025,865,-25>
    <   0,875,1080>
  }

  box
  {
    <1600,850,-250>
    < 990,860,1080>
  }
  box
  {
    <1602,860,-252>
    < 987,865,1082>
  }
  box
  {
    <1605,865,-255>
    < 985,875,1085>
  }

  box
  {
    <  0,850,1000>
    <380,860,1135>
  }
  box
  {
    <  0,860,1000>
    <382,865,1137>
  }
  box
  {
    <  0,865,1000>
    <385,875,1140>
  }

  #declare a = 1002;
  #while (a < 1590)
  box
  {
    <a,847,-230>
    <a + 10,850,-245>
  }
  #declare a = a + 38.4;
  #end
  #declare a = -235;
  #while (a < 0)
  box
  {
    <1010,847,a>
    < 995,850,a + 10>
  }
  #declare a = a + 38.4;
  #end
  #declare a = 1002;
  #while (a > 0)
  box
  {
    <a,847,5>
    <a - 10,850,-10>
  }
  #declare a = a - 38.4;
  #end
  #declare a = -240;
  #while (a < 1070)
  box
  {
    <1580,847,a>
    <1595,850,a + 10>
  }
  #declare a = a + 38.2;
  #end
  #declare a = 1002;
  #while (a < 1590)
  box
  {
    <a,847,1060>
    <a + 10,850,1075>
  }
  #declare a = a + 38.4;
  #end
  #declare a = 975;
  #while (a > 345)
  box
  {
    <a,847,1055>
    <a - 10,850,1070>
  }
  #declare a = a - 38.4;
  #end
  #declare a = 1123;
  #while (a > 1070)
  box
  {
    <360,847,a>
    <375,850,a - 10>
  }
  #declare a = a - 38.4;
  #end
  #declare a = 370;
  #while (a > 0)
  box
  {
    <a,847,1115>
    <a - 10,850,1130>
  }
  #declare a = a - 38.4;
  #end
  texture { T_MurSale2 }
}

// Combles
#declare TrouFenetreCblCentre =
union
{
  box
  {
    <-50, 875,-50>
    < 50,1020, 50>
  }
  intersection
  {
    cylinder
    {
      <0,810,-50>
      <0,810, 50>
      220
    }
    box
    {
      <-50,1020,-100>
      < 50,1100, 100>
    }
  }
}

#declare Cadre1FenetreCblCentre =
union
{
  box
  {
    <-52,875,0>
    < 52,1020,50>
  }
  intersection
  {
    cylinder
    {
      <0,810,0>
      <0,810,50>
      222
    }
    box
    {
      <-52,1100,-100>
      < 52,1020, 100>
    }
  }
}

#declare Cadre2PorteCblCentre =
union
{
  intersection
  {
    difference
    {
      cylinder
      {
        <0,810,0>
        <0,810,1>
        232
      }
      cylinder
      {
        <0,810,-10>
        <0,810, 10>
        229
      }
    }
    box
    {
      <-62,1100,-100>
      < 62,1020, 100>
    }
  }
  box
  {
    <-62, 875,0>
    <-59,1031,1>
  }
  box
  {
    < 62, 875,0>
    < 59,1031,1>
  }
  // On pose la fentre
  union
  {
    box
    {
      <-52,875,-30>
      < 52,880,-35>
    }
    box
    {
      <-52,925,-30>
      < 52,927,-35>
    }
    box
    {
      <-52,975,-30>
      < 52,977,-35>
    }
    box
    {
      <-52,875,-30>
      <-47,1020,-35>
    }
    box
    {
      < 52,875,-30>
      < 47,1020,-35>
    }
    box
    {
      <-4,875,-30>
      < 4,1030,-35>
    }
    box
    {
      <-2,875,-29>
      < 2,1030,-30>
    }
    intersection
    {
      difference
      {
        cylinder
        {
          <0,810,-30>
          <0,810,-35>
          222
        }
        cylinder
        {
          <0,810,-50>
          <0,810, 50>
          217
        }
      }
      box
      {
        <-52,1100,-100>
        < 52,1020, 100>
      }
    }
    pigment { White }
  }
  box
  {
    <-55,875,-34>
    < 55,1030,-33>
    texture { T_Vitre }
  }

}      


#declare ColonneCombles =
union
{
  box
  {
    < 28,875, 28>
    <-28,905,-28>
    texture { T_MurSale2 }
  }
  box
  {
    < 23, 905, 23>
    <-23,1080,-23>
  }
  
  box
  {
    < 24,1040, 24>
    <-24,1042,-24>
  }
  box
  {
    < 25,1042, 25>
    <-25,1044,-25>
  }
  
  texture { T_MurClaire }
}

#declare ComblesCentre =
union
{
  box
  {
    < 380,1080,1140>
    <-380,1090,1000>
  }
  #declare ix = 369;
  #while (ix > -370)
    box
    {
      <ix    ,1080,1130>
      <ix - 8,1077,1100>
    }
    #declare ix = ix - 10;
  #end
  difference
  {
    union
    {
      box
      {
        < 366,875,1121>
        <-366,905,1075>
        texture { T_MurSale2 }
      }
      box
      {
        < 365, 905,1120>
        <-365,1080,1075>
        texture { T_MurMap translate 905*y }
      }
      box
      {
        < 366,1040,1121>
        <-366,1042,1075>
      }
      box
      {
        < 367,1042,1122>
        <-367,1044,1075>
      }
    }
    union
    {
      object
      {
        TrouFenetreCblCentre
        translate <-230,0,1090>
      }
      object
      {
        TrouFenetreCblCentre
        translate <0,0,1090>
      }
      object
      {
        TrouFenetreCblCentre
        translate <230,0,1090>
      }
      object
      {
        Cadre1FenetreCblCentre
        translate <-230,0,1118>
      }
      object
      {
        Cadre1FenetreCblCentre
        translate <0,0,1118>
      }
      object
      {
        Cadre1FenetreCblCentre
        translate <230,0,1118>
      }
    }
  }
  object
  {
    Cadre2PorteCblCentre
    translate <-230,0,1120>
  }
  object
  {
    Cadre2PorteCblCentre
    translate <0,0,1120>
  }
  object
  {
    Cadre2PorteCblCentre
    translate <230,0,1120>
  }
  
  object
  {
    ColonneCombles
    translate <115,0,1100>
  }
  object
  {
    ColonneCombles
    translate <-115,0,1100>
  }
  object
  {
    ColonneCombles
    translate <345,0,1100>
  }
  object
  {
    ColonneCombles
    translate <-345,0,1100>
  }
  texture { T_MurClaire }
}

#declare CblCote =
union
{
  box
  {
    <366,875,1121>
    <320,905,1000>
    texture { T_MurSale1 }
  }
  box
  {
    <365, 905,1120>
    <320,1080,1000>
    texture { T_MurMap translate 905*y rotate 90*y }
  }
  box
  {
    <366,1040,1121>
    <320,1042,1000>
  }
  box
  {
    <367,1042,1122>
    <320,1044,1000>
  }
  #declare iz = 1120;
  #while (iz > 600)
    box
    {
      <375,1080,iz>
      <360,1077,iz - 8>
    }
    #declare iz = iz - 10;
  #end
  texture { T_MurClaire }
}

#declare TrouFenetreCbl =
union
{
  box
  {
    <-50, 875,-50>
    < 50,1010, 50>
  }
  intersection
  {
    cylinder
    {
      <0,800,-50>
      <0,800, 50>
      220
    }
    box
    {
      <-50,1010,-100>
      < 50,1100, 100>
    }
  }
}

#declare Cadre2PorteCbl =
union
{
  intersection
  {
    difference
    {
      cylinder
      {
        <0,810,-100>
        <0,810,7>
        237
      }
      cylinder
      {
        <0,810,-200>
        <0,810, 200>
        235
      }
    }
    box
    {
      <-80,1100,-100>
      < 80,1020, 100>
    }
  }
  intersection
  {
    difference
    {
      cylinder
      {
        <0,810,-100>
        <0,810,5>
        235
      }
      cylinder
      {
        <0,810,-200>
        <0,810, 200>
        225
      }
    }
    box
    {
      <-76,1100,-100>
      < 76,1020, 100>
    }
  }
  box
  {
    <-70, 875,0>
    < 70,1035,-70>
  }
}      

// On pose la fentre
#declare FenetreCbl =
union
{
  union
  {
    box
    {
      <-50,875,-30>
      < 50,880,-35>
    }
    box
    {
      <-50,925,-30>
      < 50,927,-35>
    }
    box
    {
      <-50,975,-30>
      < 50,977,-35>
    }
    box
    {
      <-50,875,-30>
      <-45,1010,-35>
    }
    box
    {
      < 50,875,-30>
      < 45,1010,-35>
    }
    box
    {
      <-4,875,-30>
      < 4,1020,-35>
    }
    box
    {
      <-2,875,-29>
      < 2,1020,-30>
    }
    intersection
    {
      difference
      {
        cylinder
        {
          <0,800,-30>
          <0,800,-35>
          220
        }
        cylinder
        {
          <0,800,-50>
          <0,800, 50>
          215
        }
      }
      box
      {
        <-50,1100,-100>
        < 50,1010, 100>
      }
    }
    pigment { White }
  }
  box
  {
    <-50,875,-34>
    < 50,1020,-33>
    texture { T_Vitre }
  }
}

#declare FenetreCbl1 =
union
{
  object
  {
    FenetreCbl
    rotate 180*y
    translate <255,0,0>
  }
  object
  {
    FenetreCbl
    rotate 180*y
    translate <485,0,0>
  }
  object
  {
    FenetreCbl
    rotate 180*y
    translate <695,0,0>
  }
  object
  {
    FenetreCbl
    rotate 180*y
    translate <905,0,0>
  }
}

#declare CadresCbl1 =
union
{
  object
  {
    Cadre2PorteCbl
    rotate 180*y
    translate <255,0,0>
  }
  object
  {
    Cadre2PorteCbl
    rotate 180*y
    translate <485,0,0>
  }
  object
  {
    Cadre2PorteCbl
    rotate 180*y
    translate <695,0,0>
  }
  object
  {
    Cadre2PorteCbl
    rotate 180*y
    translate <905,0,0>
  }
}

#declare TrousCbl1 =
union
{
  object
  {
    TrouFenetreCbl
    rotate 180*y
    translate <255,0,30>
  }
  object
  {
    TrouFenetreCbl
    rotate 180*y
    translate <485,0,30>
  }
  object
  {
    TrouFenetreCbl
    rotate 180*y
    translate <695,0,30>
  }
  object
  {
    TrouFenetreCbl
    rotate 180*y
    translate <905,0,30>
  }
}

#declare CblEst =
union
{
  difference
  {
    union
    {
      box
      {
        <-1100,  0,0>
        < 1100,170,1>
        texture { T_Toit1 }
        rotate 10*x
        translate <0,905,5>
      }
      
      box
      {
        < 1040,875,-5>
        <-1040,905,45>
        texture { T_MurSale1 }
      }
      object
      {
        Cadre2PorteCbl
        rotate 180*y
      }
      object { CadresCbl1 }
      object { CadresCbl1 scale <-1,1,1> }
    }
    union
    {
      object
      {
        TrouFenetreCbl
        translate <0,0,30>
      }
      object { TrousCbl1 }
      object { TrousCbl1 scale <-1,1,1> }
    }
    texture { T_MurClaire }
  }
  object
  {
    FenetreCbl
    rotate 180*y
  }
  object { FenetreCbl1 }
  object { FenetreCbl1 scale <-1,1,1> }
}


#declare CblAile =
union
{
  difference
  {
    union
    {
      prism
      {
        linear_spline
        linear_sweep
        0,1,5
        <0,-230>,<170,-201>,<170,40>,<0,40>,<0,-230>
        texture { T_Toit1 rotate 90*z }
        rotate 80*z
        translate <1014,905,0>
      }
      box
      {
        <1002,875,10>
        <1040,905,-235>
        texture { T_MurSale1 }
      }
      object
      {
        Cadre2PorteCbl
        rotate -90*y
        translate <1009,0,-90>
      }
    }
    object
    {
      TrouFenetreCbl
      rotate -90*y
      translate <1030,0,-90>
    }
    texture { T_MurClaire }
  }
  cylinder
  {
    <1014, 905,-230>
    <1043,1070,-201>
    4
    pigment { color BleuToit }
    finish { FinishToit }
  }
  object
  {
    FenetreCbl
    rotate -90*y
    translate <1009,0,-90>
  }
   
}
      
#declare CblAileEst =
union
{
  difference
  {
    union
    {
      prism
      {
        linear_spline
        linear_sweep
        0,1,5
        <1576,0>,<1547,170>,<1043,170>,<1014,0>,<1576,0>
        texture { T_Toit1 rotate 90*x }
        rotate -80*x
        translate <0,905,-230>
      }
      box
      {
        <1040,875,-235>
        <1583,905,-185>
        texture { T_MurSale1 }
      }
      object
      {
        Cadre2PorteCbl
        rotate 180*y
        translate <1295,0,-231>
      }
    }
    object
    {
      TrouFenetreCbl
      translate <1295,0,-210>
    }
    texture { T_MurClaire }
  }
  object
  {
    FenetreCbl
    rotate 180*y
    translate <1295,0,-231>
  }
  cylinder
  {
    <1576, 905,-230>
    <1547,1070,-201>
    4
    pigment { color BleuToit }
    finish { FinishToit }
  }
}    
        
#declare CblAileCote =
union
{
  difference
  {
    union
    {
      prism
      {
        linear_spline
        linear_sweep
        0,1,5
        <0,-230>,<170,-201>,<170,1031>,<0,1060>,<0,-230>
        texture { T_Toit1 rotate -90*z }
        rotate 100*z
        translate <1578,905,0>
      }
      box
      {
        <1583,875,-185>
        <1560,905,1025>
        texture { T_MurSale1 }
      }
      object
      {
        Cadre2PorteCbl
        rotate 90*y
        translate <1578,0,30>
      }
      object
      {
        Cadre2PorteCbl
        rotate 90*y
        translate <1578,0,415>
      }
      object
      {
        Cadre2PorteCbl
        rotate 90*y
        translate <1578,0,800>
      }
    }
    union
    {
      object
      {
        TrouFenetreCbl
        rotate 90*y
        translate <1550,0,30>
      }
      object
      {
        TrouFenetreCbl
        rotate 90*y
        translate <1550,0,415>
      }
      object
      {
        TrouFenetreCbl
        rotate 90*y
        translate <1550,0,800>
      }
    }
    texture { T_MurClaire }
  }
  object
  {
    FenetreCbl
    rotate 90*y
    translate <1578,0,30>
  }
  object
  {
    FenetreCbl
    rotate 90*y
    translate <1578,0,415>
  }
  object
  {
    FenetreCbl
    rotate 90*y
    translate <1578,0,800>
  }
}

#declare CblOuest =
union
{
  union
  {
    prism
    {
      linear_spline
      linear_sweep
      0,1,5
      <0,-230>,<170,-201>,<170,-100>,<0,-100>,<0,-230>
      texture { T_Toit1 rotate 90*z }
      rotate 80*z
      translate <1014,905,0>
    }
    box
    {
      <1002,875,-100>
      <1040,905,-235>
      texture { T_MurSale1 }
    }
    cylinder
    {
      <1014, 905,-230>
      <1043,1070,-201>
      4
      pigment { color BleuToit }
      finish { FinishToit }
    }
    scale <1,1,-1>
    translate 828*z
  }
  difference
  {
    union
    {
      box
      {
        <1050,  0,0>
        < 345,170,1>
        texture { T_Toit1 }
        rotate -10*x
        translate <0,905,1053>
      }
      box
      {
        <1050,905,1058>
        < 345,875,1015>
        texture { T_MurSale1 }
      }
      object
      {
        Cadre2PorteCbl
        translate <905,0,1058>
      }
      object
      {
        Cadre2PorteCbl
        translate <695,0,1058>
      }
      object
      {
        Cadre2PorteCbl
        translate <485,0,1058>
      }
    }
    union
    {
      object
      {
        TrouFenetreCbl
        translate <905,0,1020>
      }
      object
      {
        TrouFenetreCbl
        translate <695,0,1020>
      }
      object
      {
        TrouFenetreCbl
        translate <485,0,1020>
      }
    }
    texture { T_MurClaire }
  }
  object
  {
    FenetreCbl
    translate <905,0,1058>
  }
  object
  {
    FenetreCbl
    translate <695,0,1058>
  }
  object
  {
    FenetreCbl
    translate <485,0,1058>
  }
}

#declare PlancherGrenier =
union
{
  box
  {
    <   0,1070,23>
    <1055,1075,1032>
  }
  box
  {
    <1035,1070,-209>
    <1555,1075,1037>
  }
  #declare ix = 370;
  #while (ix < 1040)
    box
    {
      <ix + 12,1060,1030>
      <ix,     1070,1031>
    }
    cylinder
    {
      <ix + 6,1060,1030>
      <ix + 6,1060,1031>
      6
    }
    #declare ix = ix + 15;
  #end  
  #declare ix = 1040;
  #while (ix < 1550)
    box
    {
      <ix + 12,1060,1035>
      <ix,     1070,1036>
    }
    cylinder
    {
      <ix + 6,1060,1035>
      <ix + 6,1060,1036>
      6
    }
    box
    {
      <ix + 12,1060,-208>
      <ix,     1070,-207>
    }
    cylinder
    {
      <ix + 6,1060,-208>
      <ix + 6,1060,-207>
      6
    }
    #declare ix = ix + 15;
  #end  
  #declare ix = 1.5;
  #while (ix < 1040)
    box
    {
      <ix + 12,1060,24>
      <ix,     1070,25>
    }
    cylinder
    {
      <ix + 6,1060,24>
      <ix + 6,1060,25>
      6
    }
    #declare ix = ix + 15;
  #end  
  #declare iz = -207;
  #while (iz < 1030)
    box
    {
      <1554,1060,iz + 12>
      <1553,1070,iz>
    }
    cylinder
    {
      <1554,1060,iz + 6>
      <1553,1060,iz + 6>
      6
    }
    #declare iz = iz + 15;
  #end  
  #declare iz = -207;
  #while (iz < 25)
    box
    {
      <1034,1060,iz + 12>
      <1033,1070,iz>
    }
    cylinder
    {
      <1034,1060,iz + 6>
      <1033,1060,iz + 6>
      6
    }
    #declare iz = iz + 15;
  #end  
  pigment { color BleuToit }
  finish { FinishToit }
}
  
// Toit
#declare TrouFenetreToit =
box
{
  <-25,1165,0>
  < 25,1225,300>
}

#declare ToitCentreOuest =
union
{
  union
  {
    box
    {
      <  5, 0,1140>
      <405,10,600>
    }
    box
    {
      <  0,10,1142>
      <406,15,600>
    }
    box
    {
      < -1,15,1143>
      <406,16,600>
      texture { T_Toit rotate <90,90,0> }
    }
    #declare ix = 398;
    #while (ix > 10)
      box
      {
        <ix    ,-3,1130>
        <ix - 8, 0,1100>
      }
      #declare ix = ix - 10;
    #end
    rotate 18*z
    translate <-380,1080,0>
  }
  prism
  {
    linear_spline
    linear_sweep
    0,1,4
    <0,0>,<-370,0>,<0,125>,<0,0>
    rotate -90*x
    translate <0,1090,1120>
    texture { T_MurMap translate 1090*y }
  }
  texture { T_MurClaire }
}

#declare FaitiereCentre =
difference
{
  cylinder
  {
    <0,1219,1000>
    <0,1219,1133>
    2
  }
  box
  {
    <-5,1219,600>
    < 5,1200,1200>
  }
  pigment { color BleuToit }
  finish { FinishToit }
}  

#declare PrincipalToit =
union
{
  difference
  {
    prism
    {
      linear_spline
      linear_sweep
      0,1,5
      <1035,0>,<550,560>,<-550,560>,<-1035,0>,<1035,0>
      texture { T_Toit rotate 90*x }
      rotate -26.5*x
      translate <0,1075,27>
    }
    union
    {
      object { TrouFenetreToit }
      object { TrouFenetreToit translate -485*x }
      object { TrouFenetreToit translate  485*x }
      translate 170*z
    }
  }
  difference
  {
    prism
    {
      linear_spline
      linear_sweep
      0,1,5
      <1035,0>,<550,560>,<-550,560>,<-1035,0>,<1035,0>
      texture { T_Toit rotate 90*x }
      rotate -26.5*x
      scale <1,1,-1>
      translate <0,1075,1028>
    }
    union
    {
      object { TrouFenetreToit rotate 180*y translate -485*x }
      object { TrouFenetreToit rotate 180*y translate  485*x }
      translate 885*z
    }
  }
  prism
  {
    linear_spline
    linear_sweep
    0,1,4
    <0,27>,<0,1028>,<545,527.5>,<0,27>
    texture { T_Toit rotate <90,90,0> }
    rotate (180-27.3)*z
    translate <1035,1075,0>
  }
  prism
  {
    linear_spline
    linear_sweep
    0,1,4
    <0,27>,<0,1028>,<545,527.5>,<0,27>
    texture { T_Toit rotate <90,90,0> }
    rotate (180-27.3)*z
    translate <1035,1075,0>
    scale <-1,1,1>
  }
  union
  {
    cylinder
    {
      <1035,1075,27>
      < 550,1325,527.5>
      4
    }
    cylinder
    {
      <-1035,1075,27>
      <-550,1325,527.5>
      4
    }
    cylinder
    {
      <1035,1075,1028>
      < 550,1325,527.5>
      4
    }
    cylinder
    {
      <-1035,1075,1028>
      <-550,1325,527.5>
      4
    }
    cylinder
    {
      < 550,1325,527.5>
      <-550,1325,527.5>
      4
    }
    pigment { color BleuToit }
    finish { FinishToit }
  }
}  
  
#declare ToitAile =
union
{
  prism
  {
    linear_spline
    linear_sweep
    0,1,5
    <0,-205>,<0,1033>,<-285,800>,<-285,30>,<0,-205>
    texture { T_Toit3 rotate <90,-90,0> }
    rotate -26*z
    translate <1551,1075,0>
  }
  prism
  {
    linear_spline
    linear_sweep
    0,1,5
    <0,-205>,<0,1033>,<-287,800>,<-287,30>,<0,-205>
    texture { T_Toit3 rotate <90,-90,0> }
    rotate -26*z
    scale <-1,1,1>
    translate <1039,1075,0>
  }
  prism
  {
    linear_spline
    linear_sweep
    0,1,4
    <1551,0>,<1039,0>,<1295,266>,<1551,0>
    texture { T_Toit3 rotate <90,0,0> }
    rotate -28*x
    translate <0,1075,-205>
  }
  prism
  {
    linear_spline
    linear_sweep
    0,1,4
    <1551,0>,<1039,0>,<1295,266>,<1551,0>
    texture { T_Toit3 rotate <90,0,0> }
    rotate -28*x
    scale <1,1,-1>
    translate <0,1075,1033>
  }
  union
  {
    cylinder
    {
      <1551,1075,-205>
      <1295,1200,30>
      4
    }
    cylinder
    {
      <1039,1075,-205>
      <1295,1200,30>
      4
    }
    cylinder
    {
      <1551,1075,1033>
      <1295,1200,800>
      4
    }
    cylinder
    {
      <1039,1075,1033>
      <1295,1200,800>
      4
    }
    cylinder
    {
      <1295,1200,30>
      <1295,1200,800>
      4
    }
    pigment { color BleuToit }
    finish { FinishToit }
  }
  box
  {
    < 550,0,0>
    <1295,0,515.5>
    texture { T_Toit rotate <90,0,0> }
    rotate -14*x
    translate <0,1075,27>
  }
  box
  {
    < 550,0,0>
    <1295,0,515.5>
    texture { T_Toit rotate <90,0,0> }
    rotate -14*x
    scale <1,1,-1>
    translate <0,1075,1028>
  }
  cylinder
  {
    < 550,1200,527.5>
    <1295,1200,527.5>
    4
    pigment { color BleuToit }
    finish { FinishToit }
  }
}

// Chemins
#declare ChemineCoteAile =
union
{
  box
  {
    <-20,935,-35>
    < 20,905, 35>
  }
  difference
  {
    box
    {
      <-15, 935,-33>
      < 15,1065, 33>
    }
    box
    {
      <13, 945,-23> 
      <20,1055, 23>
    }
  }
  box
  {
    <-21,1065,-36>
    < 21,1067, 36>
  }
  box
  {
    <-20,1065,-35>
    < 20,1075, 35>
  }
  box
  {
    <-21,1073,-36>
    < 21,1075, 36>
  }
  difference
  {
    box
    {
      <-15,1075,-30>
      < 15,1300, 30>
    }
    union
    {
      box
      {
        <13,1080,-20> 
        <20,1290, 20>
      }
      box
      {
        <-13,1080,-20> 
        <-20,1290, 20>
      }
      cylinder
      {
        <0,1187.5, 28>
        <0,1187.5, 35>
        8
      }
      box
      {
        <-8,1202.5, 28>
        < 8,1290, 35>
      }
      box
      {
        <-8,1172.5, 28>
        < 8,1085, 35>
      }
      cylinder
      {
        <0,1187.5,-28>
        <0,1187.5,-35>
        8
      }
      box
      {
        <-8,1202.5,-28>
        < 8,1290,-35>
      }
      box
      {
        <-8,1172.5,-28>
        < 8,1085,-35>
      }
    }
  }
  box
  {
    <-17,1300,-32>
    < 17,1305, 32>
  }
  box
  {
    <-15,1305,-33>
    <-13,1315,-31>
  }
  box
  {
    < 15,1305,-33>
    < 13,1315,-31>
  }
  box
  {
    < 15,1305, 33>
    < 13,1315, 31>
  }
  box
  {
    <-15,1305, 33>
    <-13,1315, 31>
  }
  box
  {
    <-20,1315,-35>
    < 20,1317, 35>
  }
  texture { T_MurMap rotate 90*y }
}  

#declare ChemineInterieurAile =
union
{
  box
  {
    <-20,1065,-35>
    < 20,1100, 35>
  }
  difference
  {
    box
    {
      <-15,1100,-30>
      < 15,1300, 30>
    }
    union
    {
      box
      {
        <13,1110,-20> 
        <20,1290, 20>
      }
      box
      {
        <-13,1110,-20> 
        <-20,1290, 20>
      }
      cylinder
      {
        <0,1187.5, 28>
        <0,1187.5, 35>
        8
      }
      box
      {
        <-8,1202.5, 28>
        < 8,1290, 35>
      }
      box
      {
        <-8,1172.5, 28>
        < 8,1110, 35>
      }
      cylinder
      {
        <0,1187.5,-28>
        <0,1187.5,-35>
        8
      }
      box
      {
        <-8,1202.5,-28>
        < 8,1290,-35>
      }
      box
      {
        <-8,1172.5,-28>
        < 8,1110,-35>
      }
    }
  }
  box
  {
    <-17,1300,-32>
    < 17,1305, 32>
  }
  box
  {
    <-15,1305,-33>
    <-13,1315,-31>
  }
  box
  {
    < 15,1305,-33>
    < 13,1315,-31>
  }
  box
  {
    < 15,1305, 33>
    < 13,1315, 31>
  }
  box
  {
    <-15,1305, 33>
    <-13,1315, 31>
  }
  box
  {
    <-20,1315,-35>
    < 20,1317, 35>
  }
  texture { T_MurMap }
}  

#declare ChemineCoteAiles =
union
{
  object { ChemineCoteAile translate <1570,0,145> }
  object { ChemineCoteAile translate <1570,0,685> }
}

#declare ChemineCentreAile =
union
{
  difference
  {
    box
    {
      <1200,1000,100>
      <1290,1250,140>
    }
    box
    {
      <-50,  0, 90>
      <150,100,150>
      rotate 26*z
      translate <1200,1180,0>
    }
  }
  
  difference
  {
    box
    {
      <1205,1100,105>
      <1285,1300,135>
    }
    union
    {
      intersection
      {
        union
        {
          box
          {
            <1210,1100,107>
            <1275,1290,100>
          }
          box
          {
            <1215,1100,133>
            <1275,1290,150>
          }
        }
        box
        {
          <-50,  0, 90>
          <150,100,150>
          rotate 26*z
          translate <1200,1190,0>
        }
      }
      box
      {
        <1207,1190,115>
        <1150,1290,125>
      }
      box
      {
        <1283,1230,115>
        <1290,1290,125>
      }
    }
  }
  box
  {
    <1203,1300,103>
    <1287,1305,137>
  }
  box
  {
    <1205,1305,105>
    <1207,1315,107>
  }
  box
  {
    <1285,1305,135>
    <1283,1315,133>
  }
  box
  {
    <1205,1305,133>
    <1207,1315,135>
  }
  box
  {
    <1285,1305,105>
    <1283,1315,107>
  }
  box
  {
    <1203,1315,103>
    <1287,1317,137>
  }
  texture { T_MurMap }
}

#declare ChemineEst =
union
{
  difference
  {
    box
    {
      <380,1100,230>
      <420,1300,340>
    }
    box
    {
      <300,  0,-50>
      <500,200,150>
      rotate -26.5*x
      translate <0,1220,230>
    }
  }
  difference
  {
    box
    {
      <385,1100,235>
      <415,1390,285>
    }
    union
    {
      box
      {
        <392,1240,237>
        <407,1380,230>
      }
      intersection
      {
        union
        {
          box
          {
            <387,1200,245>
            <350,1380,275>
          }
          box
          {
            <413,1200,245>
            <450,1380,275>
          }
        }
        box
        {
          <300,  0,-50>
          <500,200,150>
          rotate -26.5*x
          translate <0,1230,230>
        }
      }
    }
  }
  box
  {
    <383,1390,233>
    <417,1395,287>
  }
  box
  {
    <385,1395,235>
    <387,1405,237>
  }
  box
  {
    <413,1395,235>
    <415,1405,237>
  }
  box
  {
    <385,1395,283>
    <387,1405,285>
  }
  box
  {
    <413,1395,283>
    <415,1405,285>
  }
  box
  {
    <380,1405,230>
    <420,1407,290>
  }

  difference
  {
    box
    {
      <385,1000,285>
      <415,1360,335>
    }
    union
    {
      box
      {
        <392,1300,333>
        <407,1350,350>
      }
      intersection
      {
        union
        {
          box
          {
            <387,1200,295>
            <350,1350,325>
          }
          box
          {
            <413,1200,295>
            <450,1350,325>
          }
        }
        box
        {
          <300,  0,-50>
          <500,200,200>
          rotate -26.5*x
          translate <0,1230,230>
        }
      }
    }
  }
  box
  {
    <383,1360,285>
    <417,1365,337>
  }
  union
  {
    cylinder
    {
      <400,1360,310>
      <400,1440,310>
      10
      open
    }
    box
    {
      <410,  1435,311>
      <410.5,1445,309>
    }
    box
    {
      <390,  1435,311>
      <390.5,1445,309>
    }
    cone
    {
      <400,1445,310>,15
      <400,1452,310>,0
      open
    }
    texture { T_Chrome_4B }
  }
  
  texture { T_MurMap rotate 90*y }
}

#declare ChemineCentreOuest =
union
{
  difference
  {
    box
    {
      < 55,1100,585>
      <105,1400,535>
    }
    box
    {
      <  0,  0,-50>
      <200,200,150>
      rotate  26.5*x
      translate <0,1365,490>
    }
  }
  difference
  {
    box
    {
      < 60,1100,580>
      <100,1400,540>
    }
    union
    {
      box
      {
        < 70,1350,542>
        < 90,1390,500>
      }
      box
      {
        < 70,1330,578>
        < 90,1390,600>
      }
      intersection
      {
        union
        {
          box
          {
            <62,1100,570>
            < 0,1390,550>
          }
          box
          {
            < 98,1100,570>
            <150,1390,550>
          }
        }
        box
        {
          <  0,  0,-50>
          <200,200,150>
          rotate  26.5*x
          translate <0,1375,490>
        }
      }
    }
  }
  box
  {
    < 58,1400,582>
    <102,1408,538>
  }
  box
  {
    < 56,1408,584>
    <104,1410,536>
  }
  union
  {
    cylinder
    {
      <80,1410,560>
      <80,1490,560>
      10
      open
    }
    box
    {
      <90,  1485,561>
      <89.5,1495,559>
    }
    box
    {
      <70,  1485,561>
      <69.5,1495,559>
    }
    cone
    {
      <80,1495,560>,15
      <80,1502,560>,0
      open
    }
    texture { T_Chrome_4B }
  }
  
  texture { T_MurMap }
}

#declare ChemineNordOuest =
union
{
  difference
  {
    box
    {
      <380,1100,840>
      <420,1300,730>
    }
    box
    {
      <300,  0,-150>
      <500,200,  50>
      rotate 26.5*x
      //scale <1,1,-1>
      translate <0,1220,840>
    }
  }
  difference
  {
    box
    {
      <385,1000,835>
      <415,1360,735>
    }
    union
    {
      box
      {
        <392,1240,833>
        <407,1350,840>
      }
      intersection
      {
        union
        {
          box
          {
            <387,1200,825>
            <350,1350,795>
          }
          box
          {
            <413,1200,825>
            <450,1350,795>
          }
        }
        box
        {
          <300,  0,-150>
          <500,200,50>
          rotate 26.5*x
          translate <0,1230,840>
        }
      }
      box
      {
        <392,1300,737>
        <407,1350,750>
      }
      intersection
      {
        union
        {
          box
          {
            <387,1200,775>
            <350,1350,745>
          }
          box
          {
            <413,1200,775>
            <450,1350,745>
          }
        }
        box
        {
          <300,  0,-200>
          <500,200,50>
          rotate 26.5*x
          translate <0,1230,840>
        }
      }
    }
  }
  box
  {
    <383,1365,837>
    <417,1360,733>
  }
  #declare ChapeauChemine =
  union
  {
    cylinder
    {
      <400,1360,785>
      <400,1400,785>
      10
      open
    }
    box
    {
      <410,  1395,786>
      <410.5,1405,784>
    }
    box
    {
      <390,  1395,786>
      <390.5,1405,784>
    }
    cone
    {
      <400,1405,785>,15
      <400,1412,785>,0
      open
    }
    texture { T_Chrome_4B }
  }
  object { ChapeauChemine translate -30*z }
  object { ChapeauChemine }
  object { ChapeauChemine translate  30*z }
  texture { T_MurMap rotate 90*y }
}

#declare ChemineSudOuest =
union
{
  difference
  {
    box
    {
      <380,1100,840>
      <420,1300,730>
    }
    box
    {
      <300,  0,-150>
      <500,200,  50>
      rotate 26.5*x
      //scale <1,1,-1>
      translate <0,1220,840>
    }
  }
  difference
  {
    box
    {
      <385,1000,835>
      <415,1360,735>
    }
    union
    {
      box
      {
        <392,1240,833>
        <407,1350,840>
      }
      intersection
      {
        union
        {
          box
          {
            <387,1200,825>
            <350,1350,795>
          }
          box
          {
            <413,1200,825>
            <450,1350,795>
          }
        }
        box
        {
          <300,  0,-150>
          <500,200,50>
          rotate 26.5*x
          translate <0,1230,840>
        }
      }
      box
      {
        <392,1300,737>
        <407,1350,750>
      }
      intersection
      {
        union
        {
          box
          {
            <387,1200,775>
            <350,1350,745>
          }
          box
          {
            <413,1200,775>
            <450,1350,745>
          }
        }
        box
        {
          <300,  0,-200>
          <500,200,50>
          rotate 26.5*x
          translate <0,1230,840>
        }
      }
    }
  }
  box
  {
    <383,1365,837>
    <417,1360,733>
  }
  box
  {
    <385,1365,835>
    <387,1375,833>
  }
  box
  {
    <385,1365,735>
    <387,1375,737>
  }
  box
  {
    <415,1365,835>
    <413,1375,833>
  }
  box
  {
    <415,1365,735>
    <413,1375,737>
  }
  box
  {
    <383,1375,837>
    <417,1377,733>
  }
  scale <-1,1,1>
  texture { T_MurMap rotate 90*y }
}

#declare ChemineSudOuestHaut =
union
{
  difference
  {
    box
    {
      < 55,1100,585>
      <105,1400,535>
    }
    box
    {
      <  0,  0,-50>
      <200,200,150>
      rotate  26.5*x
      translate <0,1365,490>
    }
  }
  difference
  {
    box
    {
      < 60,1100,580>
      <100,1400,540>
    }
    union
    {
      box
      {
        < 70,1350,542>
        < 90,1390,500>
      }
      box
      {
        < 70,1330,578>
        < 90,1390,600>
      }
      intersection
      {
        union
        {
          box
          {
            <62,1100,570>
            < 0,1390,550>
          }
          box
          {
            < 98,1100,570>
            <150,1390,550>
          }
        }
        box
        {
          <  0,  0,-50>
          <200,200,150>
          rotate  26.5*x
          translate <0,1375,490>
        }
      }
    }
  }
  box
  {
    < 58,1400,582>
    <102,1405,538>
  }
  box
  {
    < 60,1405,580>
    < 62,1415,582>
  }
  box
  {
    < 60,1405,538>
    < 62,1415,540>
  }
  box
  {
    <100,1405,580>
    <102,1415,582>
  }
  box
  {
    <100,1405,538>
    <102,1415,540>
  }
  box
  {
    < 58,1415,582>
    <102,1417,538>
  }
  translate -435*x
  texture { T_MurMap }
}

#declare FenetreToit =
union
{
  union
  {
    box
    {
      <-40,1159,0>
      <-25,1225,200>
    }
    box
    {
      < 40,1159,0>
      < 25,1225,200>
    }
    box
    {
      <-40,1221,-4>
      <-28,1225,200>
    }
    box
    {
      < 40,1221,-4>
      < 28,1225,200>
    }
    difference
    {
      cylinder
      {
        <0,1190,0>
        <0,1190,200>
        40
      }
      union
      {
        cylinder
        {
          <0,1190,-1>
          <0,1190,201>
          25
        }
        box
        {
          <-60,1190,-1>
          < 60,1300,201>
        }
      }
    }
    difference
    {
      cylinder
      {
        <0,1200,0>
        <0,1200,200>
        40
      }
      union
      {
        cylinder
        {
          <0,1200,-1>
          <0,1200,201>
          25
        }
        box
        {
          <-60,1200,-1>
          < 60,1000,201>
        }
      }
    }
    difference
    {
      cylinder
      {
        <0,1200,-4>
        <0,1200,200>
        40
      }
      union
      {
        cylinder
        {
          <0,1200,-5>
          <0,1200,201>
          35
        }
        box
        {
          <-60,1221,-5>
          < 60,1000,201>
        }
      }
    }
    
    union
    {
      difference
      {
        cylinder
        {
          <0,1190,5>
          <0,1190,10>
          25
        }
        union
        {
          cylinder
          {
            <0,1190,-1>
            <0,1190,201>
            20
          }
          box
          {
            <-60,1190,-1>
            < 60,1300,201>
          }
        }
      }
      box
      {
        <25,1190,5>
        <20,1200,10>
      }
      #declare a = 35;
      box
      {
        <-1.5,-25,5>
        < 1.5, 25,10>
        rotate a*z
        translate 1195*y
      }
      box
      {
        <-1.5,-25,5>
        < 1.5, 25,10>
        rotate -a*z
        translate 1195*y
      }
      box
      {
        <-25,1190,5>
        <-20,1200,10>
      }
      difference
      {
        cylinder
        {
          <0,1200,5>
          <0,1200,10>
          25
        }
        union
        {
          cylinder
          {
            <0,1200,-1>
            <0,1200,201>
            20
          }
          box
          {
            <-60,1200,-1>
            < 60,1000,201>
          }
        }
      }
      pigment { color BleuToit+<0.2,0.2,0.2> }
      finish { FinishToit }
    }
    pigment { color BleuToit }
    finish { FinishToit }
  }  
  box
  {
    <-25,1165,8>
    < 25,1225,9>
    texture { T_Vitre }
  }
}

#declare FenetresToitEst =
union
{
  object { FenetreToit }
  object { FenetreToit translate  485*x }
  object { FenetreToit translate -485*x }
  translate 170*z
}

#declare FenetresToitOuest =
union
{
  object { FenetreToit rotate 180*y translate  485*x }
  object { FenetreToit rotate 180*y translate -485*x }
  translate 885*z
}

#declare FenetresToitAile =
union
{
  object { FenetreToit rotate -90*y translate 30*z }
  object { FenetreToit rotate -90*y translate 415*z }
  object { FenetreToit rotate -90*y translate 800*z }
  translate <1520,-57,0>
}

#declare GrandPicSurToit =
union
{
  box
  {
    <-15,1300,-15>
    < 15,1370, 15>
  }
  sphere
  {
    0, 10
    scale <1,2,0.3>
    translate <0,1345,-15>
  }
  sphere
  {
    0, 10
    scale <1,2,0.3>
    translate <0,1345, 15>
  }
  sphere
  {
    0, 10
    scale <0.3,2,1>
    translate <-15,1345,0>
  }
  sphere
  {
    0, 10
    scale <0.3,2,1>
    translate < 15,1345,0>
  }
  box
  {
    <-17,1370,-17>  
    < 17,1375, 17>  
  }
  difference
  {
    cylinder
    {
      1375*y, 1430*y, 15
    }
    torus
    {
      15,10
      scale <1,4,1>
      translate 1415*y
    }
  }
  sphere
  {
    1440*y,15
  }
  cone
  {
    1450*y,4
    1650*y,0.5
  }
  sphere
  {
    1650*y,1
  }
  cylinder
  {
    1650*y,1800*y,0.5
  }
  translate <550,0,527.5>
  pigment { color BleuToit+<0.2,0.2,0.2> }
  finish { FinishToit }
}

#declare GrandPicSurToitAile =
union
{
  box
  {
    <-10,1300,-10>
    < 10,1360, 10>
  }
  sphere
  {
    0, 7.5
    scale <1,2,0.3>
    translate <0,1340,-10>
  }
  sphere
  {
    0, 7.5
    scale <1,2,0.3>
    translate <0,1340, 10>
  }
  sphere
  {
    0, 7.5
    scale <0.3,2,1>
    translate <-10,1340,0>
  }
  sphere
  {
    0, 7.5
    scale <0.3,2,1>
    translate < 10,1340,0>
  }
  box
  {
    <-12,1360,-12>  
    < 12,1365, 12>  
  }
  difference
  {
    cylinder
    {
      1365*y, 1405*y, 10
    }
    torus
    {
      11,7.5
      scale <1,4,1>
      translate 1395*y
    }
  }
  sphere
  {
    1410*y,10
  }
  cone
  {
    1415*y,3
    1550*y,0.1
  }
  pigment { color BleuToit+<0.2,0.2,0.2> }
  finish { FinishToit }
}

#declare EscalierPeronOuest =
union
{
  #declare m = 0;
  #while (m <= 50)
  cylinder
  {
    <-490,68 - m,1450 + (m * 2)>
    < 490,68 - m,1450 + (m * 2)>
    2
  }
  box
  {
    <-490,60 - m,1450>
    < 490,50 - m,1470 + (2 * m)>
  }
  #declare m = m + 10;
  #end
  cylinder
  {
    <-490,8,1570>
    < 490,8,1570>
    2
  }
  
  texture { T_MurClaire }
}

#declare Ferro01 =
difference
{
  union
  {
    cylinder
    {
      <0,0,1441>
      <0,0,1443>
      5
      scale <1,2,1>
      translate 11*y
    }
    cylinder
    {
      <0,0,1441>
      <0,0,1443>
      4
    }
    cylinder
    {
      <0,0,1441>
      <0,0,1443>
      5
      scale <1,2,1>
      translate -11*y
    }
  }
  union
  {
    cylinder
    {
      <0,0,1440>
      <0,0,1450>
      4
      scale <1,2.25,1>
      translate 11*y
    }
    cylinder
    {
      <0,0,1440>
      <0,0,1450>
      3
    }
    cylinder
    {
      <0,0,1440>
      <0,0,1450>
      4
      scale <1,2.25,1>
      translate -11*y
    }
  }
}
#declare FerroBalustrade =
union
{
  box
  {
    <-1, 70,1441>
    < 1,145,1443>
  }
  box
  {
    <10, 95,1441>
    <11,145,1443>
  }
  box
  {
    <49.5, 95,1441>
    <50.5,110,1443>
  }
  box
  {
    <49.5,145,1441>
    <50.5,130,1443>
  }
  difference
  {
    cylinder
    {
      <0,120,1441>
      <0,120,1443>
      10
      scale <2,1,1>
    }
    cylinder
    {
      <0,120,1440>
      <0,120,1445>
      9
      scale <2.11,1,1>
    }
    translate 50*x
  }
  box
  {
    <90, 95,1441>
    <89,145,1443>
  }
  box
  {
    <10,100,1441>
    <90,101,1443>
  }
  box
  {
    <10,140,1441>
    <90,139,1443>
  }
  box
  {
    < 0,0,1441>
    <28,1,1443>
    rotate 26.5*z
    translate <10.5,100.5,0>
  }
  box
  {
    < 0,0,1441>
    <28,-1,1443>
    rotate -26.5*z
    translate <10.5,139.5,0>
  }
  box
  {
    < 0,0,1441>
    <28,1,1443>
    rotate 206.5*z
    translate <89.5,139.5,0>
  }
  box
  {
    < 0,0,1441>
    <28,-1,1443>
    rotate -206.5*z
    translate <89.5,100.5,0>
  }
  object { Ferro01 translate <5,120,0> }
  object { Ferro01 translate <95,120,0> }
}    

#declare SymetriePeron =
union
{
  box // ici
  {
    < 485,70,1455>
    <1600,85,1430>
  }
  difference
  {
    box
    {
      <490, 0,1450>
      <510,90,1570>
    }
    box
    {
      <400,  0,0>
      <600,100,-500>
      rotate 26.5*x
      translate <0,20,1570>
    }
    texture { T_MurSale4 }
  }
  box
  {
    <485,  0    ,0>
    <515,-13.424,120>
    rotate 26.5*x
    translate <0,85,1455>
  }
  box
  {
    <485, 0,1580>
    <515,50,1550>
  }
  box
  {
    <1600, 0,1050>
    <2850,70,1070>
    texture { T_MurSale4 }
  }
  box
  {
    <1600,70,1050>
    <2850,85,1075>
  }
  
  #declare m = 0;
  #while (m <= 50)
    cylinder
    {
      <1600 + (m * 2),68 - m,1435>
      <1600 + (m * 2),68 - m,1075>
      2
    }
    box
    {
      <1600,          60 - m,1435>
      <1620 + (2 * m),50 - m,1075>
    }
    #declare m = m + 10;
  #end
  cylinder
  {
    <1720,8,1450>
    <1720,8,1075>
    2
  }
  box
  {
    <  0,  0    ,1430>
    <110,-13.424,1455>
    rotate -26.5*z
    translate <1600,85,0>
  }
  box
  {
    <  0,  0    ,1435>
    <110,-100,1450>
    rotate -26.5*z
    translate <1600,75,0>
    texture { T_MurSale4 }
  }
  box
  {
    <1680, 0,1430>
    <1705,45,1455>
  }
  cylinder
  {
    <1700, 0,1450>
    <1700,10,1450>
    20
  }
  torus
  {
    20,2
    translate <1700, 8,1450>
  }
  
  box
  {
    <1500, 85,1450>
    <1450,140,1435>
  }
  box
  {
    <1502,150,1452>
    <1448,140,1433>
  }
  box
  {
    <1000, 85,1450>
    <1050,140,1435>
  }
  box
  {
    <1052,150,1452>
    < 998,140,1433>
  }
  union
  {
    box
    {
      < 499,144,1440>
      <1600,146,1444>
    }
    box
    {
      < 499, 95,1441>
      <1600, 93,1443>
    }
    box
    {
      <1599, 70,1441>
      <1601,145,1443>
    }
    #declare p = 1050;
    #while (p < 1450)
      object { FerroBalustrade translate p*x }
      #declare p = p + 100;
    #end
    #declare p = 500;
    #while (p < 1000)
      object { FerroBalustrade translate p*x }
      #declare p = p + 100;
    #end
    object { FerroBalustrade translate 1500*x }
    #declare FerroEscalier =
    union
    {
      box
      {
        <1699, 30,1441>
        <1701,105,1443>
      }
      box
      {
        <1679, 30,1441>
        <1681,105,1443>
      }
      box
      {
        <  0, 0   ,1440>
        < 90,-1.79,1444>
        rotate -26.5*z
        translate <1600,146,0>
      }
      box
      {
        <  0, 0   ,1441>
        < 90,-1.79,1443>
        rotate -26.5*z
        translate <1600,95,0>
      }
      box
      {
        <1680,104,1440>
        <1701,106,1444>
      }
      box
      {
        <1679,55,1443>
        <1701,53,1441>
      }
      intersection
      {
        difference
        {
          cylinder
          {
            <1700,100,1444>
            <1700,100,1440>
            6
          }
          cylinder
          {
            <1700,100,1450>
            <1700,100,1430>
            4
          }
        }
        box
        {
          <1700,150,1450>
          <1750, 98,1430>
        }
      }
      box
      {
        <1610, 90.0142,1441>
        <1611,140.0142,1443>
      }
      difference
      {
        cylinder
        {
          <0,0,1441>
          <0,0,1443>
          10
          scale <2,1,1>
        }
        cylinder
        {
          <0,0,1440>
          <0,0,1445>
          9
          scale <2.11,1,1>
        }
        rotate -26.5*z
        translate <1645,97.564,0>
      }
      box
      {
        <1644.5,87    ,1443>
        <1645.5,72.564,1441>
      }
      box
      {
        <1644.5,108    ,1443>
        <1645.5,122.564,1441>
      }
      box
      {
        <11,0    ,1441>
        <90,0.894,1443>
        rotate -26.5*z
        translate <1600,100,0>
      }
      box
      {
        <11,0    ,1441>
        <90,0.895,1443>
        rotate -26.5*z
        translate <1600,139,0>
      }
      object { Ferro01 translate <1605,117.507,0> }
      box
      {
        < 0,0,1441>
        <20,1,1443>
        rotate 4*z
        translate <1610,95.014,0>
      }
      box
      {
        <50,0,1441>
        <70,1,1443>
        rotate 4*z
        translate <1610,95.014,0>
      }
      box
      {
        < 0,0,1441>
        <34,1,1443>
        rotate -46.5*z
        translate <1610,134.014,0>
      }
      box
      {
        < 67,0,1441>
        <100,1,1443>
        rotate -46.5*z
        translate <1610,134.014,0>
      }
      object { Ferro01 translate <1685,80,0> }
      object { Ferro01 translate <1695,80,0> }
    }
    object { FerroEscalier }
    box
    {
      <1690.5, 55,1441>
      <1689.5,105,1443>
    }
    texture { T_FerKhaki }
  }
  texture { T_MurClaire }
}

#declare TerrasseSerre =
union
{
  box
  {
    <1600, 0,120>
    <2450,70,100>
    texture { T_MurSale4 }
  }
  box
  {
    <1600,70,120>
    <2450,85, 95>
  }
  box
  {
    <2450, 0,-350>
    <2850,70,-370>
    texture { T_MurSale4 }
  }
  box
  {
    <2450,70,-350>
    <2850,85,-375>
  }
  union
  {
    box
    {
      <1600, 0,1050>
      <2850,70, 120>
    }
    box
    {
      <2450, 0,120>
      <2850,70,-350>
    }
    texture { T_Sol }
  }
  #declare m = 0;
  #while (m <= 60)
    cylinder
    {
      <2430 - (m * 2),68 - m, 100>
      <2430 - (m * 2),68 - m,-350>
      2
    }
    box
    {
      <2450,          70 - m, 100>
      <2430 - (2 * m),60 - m,-350>
    }
    #declare m = m + 10;
  #end
  box
  {
    <  0, 0    ,-350>
    <110,13.424,-375>
    rotate (180+26.5)*z
    translate <2450,85,0>
  }
  box
  {
    <  0, 0,-350>
    <110,80,-370>
    rotate (180+26.5)*z
    translate <2450,70,0>
    texture { T_MurSale4 }
  }
  box
  {
    <2345, 0,-350>
    <2370,45,-375>
  }
  cylinder
  {
    <2350, 0,-350>
    <2350,10,-350>
    40
  }
  cylinder
  {
    <2350,10,-350>
    <2350,20,-350>
    20
  }
  torus
  {
    40,2
    translate <2350, 8,-350>
  }
  torus
  {
    20,2
    translate <2350,18,-350>
  }

  union
  {
    box
    {
      <2449,144,-360>
      <2850,146,-364>
    }
    box
    {
      <2449, 95,-361>
      <2850, 93,-363>
    }
    object { FerroBalustrade translate <2450,0,-1804> }
    object { FerroBalustrade translate <2550,0,-1804> }
    object { FerroBalustrade translate <2650,0,-1804> }
    object { FerroBalustrade translate <2750,0,-1804> }
    box
    {
      <2434,144,110>
      <1600,146,114>
    }
    box
    {
      <2434, 95,111>
      <1600, 93,113>
    }
    intersection
    {
      difference
      {
        cylinder
        {
          <2435,140,114>
          <2435,140,110>
          6
        }
        cylinder
        {
          <2435,140,150>
          <2435,140,100>
          4
        }
      }
      box
      {
        <2435,200,150>
        <2500,138,100>
      }
    }
    #declare f = 2440;
    #while (f > 1600)
      object { FerroBalustrade scale <-1,1,1> translate <f,0,-1340> }
      #declare f = f - 100;
    #end
    box
    {
      <2850,144,1050>
      <1600,146,1054>
    }
    box
    {
      <2850, 95,1051>
      <1600, 93,1053>
    }
    #declare f = 2850;
    #while (f > 1600)
      object { FerroBalustrade scale <-1,1,1> translate <f,0,-390> }
      #declare f = f - 100;
    #end
    object { FerroEscalier translate <-4050,0,-1804> }
    texture { T_FerKhaki }
  }
  texture { T_MurClaire }
}

#declare MurInterieur =
box
{
  < 1500,   0,520>
  <-1500,1070,530>
  pigment { White }
}

#declare Chateau =
union
{
  object { MPorcheEst }
  object { MPorcheEst scale <-1,1,1>}
  object { EncadrementPorteEst }
  object { PorteEst }
  object { FacadeRCEst1 }
  object { FacadeRCEst1 scale <-1,1,1> }
  object { AilesRC }
  object { AilesRC scale <-1,1,1> }
  object { ColonneRC translate <1025,0,-215> }
  object { ColonneRC translate <1025,0,-215> scale <-1,1,1> }
  object { FacadeEstAileRC }
  object { FacadeEstAileRC scale <-1,1,1> }
  object { ColonneRC rotate -90*y translate <1565,0,-215> }
  object { ColonneRC rotate -90*y translate <1565,0,-215> scale <-1,1,1> }
  object { FacadeCoteRC translate -75*x }
  object { FacadeCoteRC translate -75*x  scale <-1,1,1> }
  object { ColonneRC rotate 180*y translate <1565,0,1045> }
  object { ColonneRC rotate 180*y translate <1565,0,1045> scale <-1,1,1> }
  object { ColonneRC rotate 90*y translate <1025,0,1045> }
  object { ColonneRC rotate 90*y translate <1025,0,1045> scale <-1,1,1> }
  object { FacadeOuestRC }
  object { FacadeOuestRC scale <-1,1,1> }
  object { ColonneRC rotate 180*y translate <345,0,1100> }
  object { ColonneRC rotate 180*y translate <345,0,1100> scale <-1,1,1> }
  object { Entree }
  object { PlancherEtg } 
  object { PlancherEtg scale <-1,1,1> } 
  object { FacadeEtgEst }
  object { ColonneEtg translate <1025,0,-215> }
  object { ColonneEtg translate <1025,0,-215> scale <-1,1,1> }
  object { ColonneEtg rotate -90*y translate <1565,0,-215> }
  object { ColonneEtg rotate -90*y translate <1565,0,-215> scale <-1,1,1> }
  object { ColonneEtg rotate 180*y translate <1565,0,1045> }
  object { ColonneEtg rotate 180*y translate <1565,0,1045> scale <-1,1,1> }
  object { ColonneEtg rotate 90*y translate <1025,0,1045> }
  object { ColonneEtg rotate 90*y translate <1025,0,1045> scale <-1,1,1> }
  object { AilesEtg }
  object { AilesEtg scale <-1,1,1> }
  object { FacadeEstAileEtg }
  object { FacadeEstAileEtg scale <-1,1,1> }
  object { FacadeCoteEtg translate -75*x }
  object { FacadeCoteEtg translate -75*x  scale <-1,1,1> }
  object { FacadeOuestEtg }
  object { FacadeOuestEtg scale <-1,1,1> }
  object { Balcon }
  object { FacadeBalcon }
  object { PlancherCbl } 
  object { PlancherCbl scale <-1,1,1> } 
  object { ComblesCentre }
  object { CblCote }
  object { CblCote scale <-1,1,1> }
  object { CblEst }
  object { CblAile }
  object { CblAile scale <-1,1,1> }
  object { CblAileEst }
  object { CblAileEst scale <-1,1,1> }
  object { CblAileCote }
  object { CblAileCote scale <-1,1,1> }
  object { CblAileEst scale <1,1,-1> translate 828*z }
  object { CblAileEst scale <-1,1,-1> translate 828*z }
  object { CblOuest }
  object { CblOuest scale <-1,1,1> }
  object { ToitCentreOuest }
  object { ToitCentreOuest scale <-1,1,1> }
  object { PlancherGrenier }
  object { PlancherGrenier scale <-1,1,1> }
  object { FaitiereCentre }
  object { PrincipalToit }
  object { ToitAile }
  object { ToitAile scale <-1,1,1> }
  object { ChemineCoteAiles }
  object { ChemineCoteAiles scale <-1,1,1> }
  object { ChemineInterieurAile translate <-1025,0,970> }
  object { ChemineInterieurAile translate < 1025,0,68> }
  object { FenetresToitEst }
  object { FenetresToitOuest }
  object { FenetresToitAile }
  object { FenetresToitAile scale <-1,1,1> }
  object { GrandPicSurToit }
  object { GrandPicSurToit scale <-1,1,1> }
  object { GrandPicSurToitAile translate < 1295,-120,30> }
  object { GrandPicSurToitAile translate < 1295,-120,800> }
  object { GrandPicSurToitAile translate <-1295,-120,30> }
  object { GrandPicSurToitAile translate <-1295,-120,800> }
  object { ChemineCentreAile }
  object { ChemineCentreAile scale <-1,1,1> }
  object { ChemineEst }
  object { ChemineCentreOuest }
  object { ChemineNordOuest }
  object { ChemineSudOuest }
  object { ChemineSudOuestHaut }
  object { EscalierPeronOuest }
  object { SymetriePeron }
  object { SymetriePeron scale <-1,1,1> }
  object { TerrasseSerre }
  object { TerrasseSerre scale <-1,1,1> }
  object { MurInterieur }
}

////////////////////////////////////////////////////////////////////////////////

#include "vasque1.inc"
#include "vasque2.inc"

#declare MuretteParking =
union
{
  box
  {
    <-2, 0,-12>
    <50,10, 12>
    translate <400,0,0>
  }
  box
  {
    < 0,10,-10>
    <50,60, 10>
    translate <400,0,0>
  }
  box
  {
    <-2,60,-12>
    <50,70, 12>
    translate <400,0,0>
  }
  box
  {
    < 400, 0,-10>
    <1590,10, 10>
  }
  box
  {
    < 400,60,-10>
    <1590,70, 10>
  }
  #declare p = 63.75;
  #declare np = 1;
  #while (np <= 36)
    object
    {
      PilierBalcon
      translate <p + 400,10,0>
    }
    #declare p = p + 27.5;
    #if (mod(np,12) = 0)
      #declare p = p + 50;
    #end
    #declare np = np + 1;
  #end
  box
  {
    <780, 0,-12>
    <830,10, 12>
  }
  box
  {
    <780,10,-10>
    <830,60, 10>
  }
  box
  {
    <780,60,-12>
    <830,70, 12>
  }
  box
  {
    <1160, 0,-12>
    <1210,10, 12>
  }
  box
  {
    <1210,10,-10>
    <1160,60, 10>
  }
  box
  {
    <1210,60,-12>
    <1160,70, 12>
  }
  box
  {
    <1540, 0,-12>
    <1590,10, 12>
  }
  box
  {
    <1540,10,-10>
    <1590,60, 10>
  }
  box
  {
    <1540,60,-12>
    <1590,70, 12>
  }
  
  intersection
  {
    difference
    {
      union
      {
        cylinder
        {
          <1590, 0,700>
          <1590,10,700>
          710
        }
        cylinder
        {
          <1590,60,700>
          <1590,70,700>
          710
        }
      }
      cylinder
      {
        <1590,-1,700>
        <1590,71,700>
        690
      }
    }
    box
    {
      <1590,-1,700>
      <3000,71,-90>
    }
  }
  #declare p = 2.25/2;
  #declare np = 1;
  #while (p < 90)

    #if (mod(np,12))
      object
      {
        PilierBalcon
        translate -700*z
        rotate -p*y
        translate <1590,10,700>
      }
    #else
      #declare pp = p + (2.25*3);
      #while (p <= pp)
        union
        {
          box
          {
            <-15, 0,-12>
            < 15,10, 12>
          }
          box
          {
            <-14,10,-10>
            < 14,60, 10>
          }
          box
          {
            <-15,60,-12>
            < 15,70, 12>
          }
          translate -700*z
          rotate -p*y
          translate <1590,0,700>
        }
        #declare p = p + 2.25;
      #end
      #declare p = p - 2.25;
    #end

    #declare p = p + 2.25;
    #declare np = np + 1;
  #end

  object
  {
    vasque1
    rotate 180*x
    translate 0.45*y
    scale 100
    translate <425,70,0>
    //texture { T_FerKhaki }
  }
  object
  {
    vasque2
    rotate 180*x
    translate 0.45*y
    scale 100
    translate <805,70,0>
    //texture { T_FerKhaki }
  }
  object
  {
    vasque1
    rotate 180*x
    translate 0.45*y
    scale 100
    translate <1185,70,0>
    //texture { T_FerKhaki }
  }
  object
  {
    vasque2
    rotate 180*x
    translate 0.45*y
    scale 100
    translate <1565,70,0>
    //texture { T_FerKhaki }
  }
  object
  {
    vasque1
    rotate 180*x
    translate 0.45*y
    scale 100
    translate -700*z
    rotate -29.25*y
    translate <1590,70,700>
    //texture { T_FerKhaki }
  }

  texture { T_MurClaire }
  translate 3000*z
}

#declare MurettesParking =
union
{
  object { MuretteParking }
  object { MuretteParking scale <-1,1,1> }
}

////////////////////////////////////////////////////////////////////////////////
// Les dpendances
////////////////////////////////////////////////////////////////////////////////

#declare ColonneDep =
union
{
  box
  {
    <-35,  0,-35>
    < 35,100, 35>
    texture { T_MurSale4 translate <50,0,50> }
  }
  box
  {
    <-30,100,-30>
    < 30,150, 30>
  }
  box
  {
    <-25,150,-25>
    < 25,500, 25>
  }
  box
  {
    <-30,500,-30>
    < 30,510, 30>
    texture { T_MurSale2 translate 50*y }
  }
  box
  {
    <-31,510,-32>
    < 31,512, 32>
  }
  texture { T_MurClaire }
}

#declare MurCoteFP =
union
{
  union
  {
    box
    {
      <-30,  0,225>
      <  0,100, 75>
      texture { T_MurSale4 }
    }
    box
    {
      <-25,100,225>
      <  0,150, 75>
    }
    box
    {
      <-20,150,225>
      <  0,300, 75>
    }
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    <-35,  0,85>
    <  0,100,65>
    texture { T_MurSale4 }
  }
  box
  {
    <-28,100,85>
    <  0,150,65>
  }
  box
  {
    <-23,150,85>
    <  0,300,65>
  }
  box
  {
    <-25,300,225>
    <  0,320, 65>
  }
  difference
  {
    union
    {
      box
      {
        <-20,320,225>
        <  0,450, 10>
        texture { T_MurMap rotate 90*y }
      }
      intersection
      {
        cylinder
        {
          <-25,320,10>
          <  0,320,10>
          75
        }
        box
        {
          <-30,320,10>
          < 10,450,80>
        }
      }
    }
    cylinder
    {
      <-30,320,10>
      < 10,320,10>
      55
    }
  }
  texture { T_MurClaire }
}

#declare MarcheDepFP =
union
{
  box
  {
    <-150, 0,  0>
    < 150,10,-75>
  }
  box
  {
    <-112.5,10,  0>
    < 112.5,20,-55>
  }
  box
  {
    <-75,20,  0>
    < 75,30,-35>
  }
  box
  {
    <-225, 0,0>
    < 225,30,1000>
  }
  
  rotate 90*y
  texture { T_MurClaire }
}

#declare FacadeParking =
union
{
  object { ColonneDep translate <0,0,-225> }
  object { ColonneDep translate <0,0, 225> }
  object { MurCoteFP }
  object { MurCoteFP scale <1,1,-1> }
  box
  {
    <-20,395,-10>
    <  0,450, 10>
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    <-25,375,-10>
    <  0,395, 10>
    texture { T_MurClaire }
  }
  object { MarcheDepFP }
  box
  {
    <-20,450,-225>
    <  0,500, 225>
    texture { T_MurMap rotate 90*y }
  }
  union
  {
    box
    {
      <-25,500,-225>
      <  0,510, 225>
      texture { T_MurSale2 translate 50*y }
    }
    box
    {
      <-27,510,-225>
      <  0,512, 225>
    }
    cylinder
    {
      <-20,485,-55>
      <-30,485,-55>
      12
    }
    cylinder
    {
      <-20,485, 55>
      <-30,485, 55>
      12
    }
    box
    {
      <-20,473,-55>
      <-30,497, 55>
    }
    texture { T_MurClaire }
  }
}

#declare SymPorteDep =
union
{
  intersection
  {
    union
    {
      cylinder
      {
        <-5,320,10>
        < 0,320,10>
        55
      }
      torus
      {
        45,2
        rotate 90*z
        translate <-5,320,10>
      }
    }
    box
    {
      <-30,320,10>
      < 10,450,80>
    }
  }
  box
  {
    <-5,320,10>
    < 0,375,0>
  }
  box
  {
    <-5, 30,65>
    < 0,320, 0>
  }
  box
  {
    <-15,300,65>
    <  0,305, 0>
  }
  cylinder
  {
    <-15,302.5,65>
    <-15,302.5, 0>
    2.5
    texture { T_Bois rotate 90*z }
  }
  box
  {
    <-10, 30,2>
    <  0,375,0>
  }
  cylinder
  {
    <-5,365,10>
    <-5,310,10>
    2
  }
  sphere { <-5,365,10>, 2 }
  cylinder
  {
    <-5,310,55>
    <-5,310,10>
    2
  }
  sphere { <-5,310,10>, 2 }
  cylinder
  {
    <-5,320,55>
    <-5,310,55>
    2
  }
  sphere { <-5,310,55>, 2 }
  box
  {
    <-5,290,10>
    <-7,286,55>
  }
  box
  {
    <-5,200,10>
    <-7,204,55>
  }
  box
  {
    <-5,200,14>
    <-7,290,10>
  }
  box
  {
    <-5,290,55>
    <-7,200,51>
  }
  prism
  {
    linear_spline
    conic_sweep
    1,0.9,5
    <-38,-16>,<-38, 16>,< 38, 16>,< 38,-16>,<-38,-16>
    scale <1,50,1>
    rotate -90*z
    translate <-55,245,32.5>
  }
  box
  {
    <-5,190,10>
    <-7,186,55>
  }
  box
  {
    <-5,100,10>
    <-7,104,55>
  }
  box
  {
    <-5,100,14>
    <-7,190,10>
  }
  box
  {
    <-5,190,55>
    <-7,100,51>
  }
  prism
  {
    linear_spline
    conic_sweep
    1,0.9,5
    <-38,-16>,<-38, 16>,< 38, 16>,< 38,-16>,<-38,-16>
    scale <1,50,1>
    rotate -90*z
    translate <-55,145,32.5>
  }
  box
  {
    <-5,90,10>
    <-7,86,55>
  }
  box
  {
    <-5,40,10>
    <-7,44,55>
  }
  box
  {
    <-5,40,14>
    <-7,90,10>
  }
  box
  {
    <-5,90,55>
    <-7,40,51>
  }
  prism
  {
    linear_spline
    conic_sweep
    1,0.9,5
    <-21,-16>,<-21, 16>,< 21, 16>,< 21,-16>,<-21,-16>
    scale <1,50,1>
    rotate -90*z
    translate <-55,65,32.5>
  }

  texture { T_Bois rotate 90*z rotate 90*x }
}

#declare PorteDep =
union
{
  object { SymPorteDep }
  object { SymPorteDep scale <1,1,-1> }
}

#declare TrouFenetreDep =
union
{
  box
  {
    <-55,150,-50>
    < 55,320, 50>
  }
  cylinder
  {
    <0,320,-50>
    <0,320, 50>
    55
  }
}

#declare TrouLargePorteDep =
union
{
  box
  {
    <-150,100,-50>
    < 150,320, 50>
  }
  box
  {
    <-95,375,-50>
    < 95,320, 50>
  }
  cylinder
  {
    <95,320,-50>
    <95,320, 50>
    55
  }
  cylinder
  {
    <-95,320,-50>
    <-95,320, 50>
    55
  }
}

#declare FenetreDep =
union
{
  box
  {
    <-55,150,20>
    <-50,320,15>
  }
  box
  {
    < 55,150,20>
    < 50,320,15>
  }
  box
  {
    < 2.5,150,20>
    <-2.5,375,15>
  }
  box
  {
    <-55,150,20>
    < 55,155,17>
  }
  box
  {
    <-55,205,20>
    < 55,210,17>
  }
  box
  {
    <-55,260,20>
    < 55,265,17>
  }
  box
  {
    <-55,320,20>
    < 55,325,12>
  }
  box
  {
    <-55,325,20>
    < 55,330,10>
  }
  difference
  {
    cylinder
    {
      <0,320,20>
      <0,320,15>
      55
    }
    union
    {
      cylinder
      {
        <0,320, 0>
        <0,320,50>
        50
      }
      box
      {
        <-60,320, 0>
        < 60,200,50>
      }
    }
  }
  union
  {
    box
    {
      <-55,150,19>
      < 55,320,18>
    }
    cylinder
    {
      <0,320,19>
      <0,320,18>
      55
    }
    texture { T_Vitre }
  }
  pigment { White }
}

#declare CadreFenetreDep =
union
{
  box
  {
    <-75,150,0>
    <-55,300,-2>
  }
  box
  {
    < 75,150,0>
    < 55,300,-2>
  }
  difference
  {
    cylinder
    {
      <0,320,0>
      <0,320,-5>
      75
    }
    union
    {
      cylinder
      {
        <0,320,-50>
        <0,320, 50>
        55
      }
      box
      {
        <-90,320,-50>
        < 90,200, 50>
      }
    }
  }
  object { FenetreDep }
}

#declare Cadre2FenetreDep =
union
{
  box
  {
    <-75,150,0>
    <-55,320,-5>
  }
  box
  {
    < 75,150,0>
    < 55,320,-5>
  }
  difference
  {
    cylinder
    {
      <0,320,0>
      <0,320,-5>
      75
    }
    union
    {
      cylinder
      {
        <0,320,-50>
        <0,320, 50>
        55
      }
      box
      {
        <-90,320,-50>
        < 90,200, 50>
      }
    }
  }
  object { FenetreDep }
}

#declare LargePorteDep =
union
{
  box
  {
    <-170, 70,20>
    < 170,150,15>
  }
  box
  {
    <-170,150,20>
    <-165,320,15>
  }
  box
  {
    < 170,150,20>
    < 165,320,15>
  }
  box
  {
    <-20, 70,20>
    < 20,375,10>
  }
  box
  {
    <-170,370,20>
    < 170,375,15>
  }
  box
  {
    <-170,150,20>
    < 170,155,17>
  }
  box
  {
    <-170,205,20>
    < 170,210,17>
  }
  box
  {
    <-170,260,20>
    < 170,265,17>
  }
  box
  {
    <-170,320,20>
    < 170,325,12>
  }
  box
  {
    <-170,325,20>
    < 170,330,10>
  }
  box
  {
    < -95,150,20>
    <-100,375,15>
  }
  box
  {
    < 95,150,20>
    <100,375,15>
  }
  box
  {
    <-55,150,20>
    <-60,375,15>
  }
  box
  {
    < 55,150,20>
    < 60,375,15>
  }
  #declare __arc_ =
  intersection
  {
    difference
    {
      cylinder
      {
        <95,320,20>
        <95,320,15>
        55
      }
      cylinder
      {
        <95,320,-50>
        <95,320, 50>
        50
      }
    }
    box
    {
      <200,400,-50>
      < 95,320, 50>
    }
  }
  object { __arc_ }
  object { __arc_ scale <-1,1,1> }
  box
  {
    <-170,150,20>
    < 170,375,15>
    texture { T_Vitre }
  }
  pigment { White }
}  

#declare CadreLargePorteDep =
union
{
  box
  {
    <-170,150,-2>
    <-150,320, 0>
  }
  box
  {
    < 170,150,-2>
    < 150,320, 0>
  }
  box
  {
    <-95,395,-5>
    < 95,375, 0>
  }
  box
  {
    <-5,405,-10>
    < 5,370, 0>
  }
  #declare __arc =
  intersection
  {
    difference
    {
      cylinder
      {
        <95,320,-5>
        <95,320, 0>
        75
      }
      cylinder
      {
        <95,320,-50>
        <95,320, 50>
        55
      }
    }
    box
    {
      <200,400,-50>
      < 95,320, 50>
    }
  }
  object { __arc }
  object { __arc scale <-1,1,1> }
  object { LargePorteDep }
}

#declare FacadeDepEst =
union
{
  object { ColonneDep translate 1000*x }
  box
  {
    <   0,  0,-30>
    <1000,100,  0>
    texture { T_MurSale4 }
  }
  box
  {
    <   0,100,-25>
    <1000,150,  0>
  }
  difference
  {
    union
    {
      box
      {
        <   0,150,-20>
        <1000,450,  0>
        texture { T_MurMap }
      }
      box
      {
        <   0,300,-25>
        <1000,320,  0>
      }
    }
    union
    {
      object { TrouFenetreDep translate 210*x }
      object { TrouFenetreDep translate 500*x }
      object { TrouFenetreDep translate 790*x }
    }
  }
  object { CadreFenetreDep translate <210,0,-20> }
  object { CadreFenetreDep translate <500,0,-20> }
  object { CadreFenetreDep translate <790,0,-20> }
  box
  {
    <   0,450,-25>
    <1000,500,  0>
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    <   0,500,-30>
    <1000,510,  0>
    texture { T_MurSale2 translate 50*y }
  }
  box
  {
    <   0,510,-32>
    <1000,512,  0>
  }
  translate -225*z
  texture { T_MurClaire }
}

#declare FacadeDepIntEst =
union
{
  box
  {
    <  0,  0,30>
    <580,100, 0>
    texture { T_MurSale4 }
  }
  box
  {
    <  0,100,25>
    <580,150, 0>
  }
  difference
  {
    union
    {
      box
      {
        <  0,150,20>
        <580,450, 0>
        texture { T_MurMap }
      }
      box
      {
        <  0,300,25>
        <580,320, 0>
      }
    }
    object { TrouFenetreDep translate 210*x }
    object { TrouFenetreDep translate 460*x }
  }
  object { CadreFenetreDep translate <210,0,-20> scale <1,1,-1> }
  object { CadreFenetreDep translate <460,0,-20> scale <1,1,-1> }
  box
  {
    <  0,450,25>
    <580,500, 0>
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    <  0,500,30>
    <580,510, 0>
    texture { T_MurSale2 translate 50*y }
  }
  box
  {
    <  0,510,32>
    <580,512, 0>
  }
  translate 225*z
  texture { T_MurClaire }
}

#declare FacadeDepNSExt =
union
{
  object { ColonneDep translate <1000,0,2325> }
  object { ColonneDep translate <1000,0,1575> }
  box
  {
    <1030,  0,-225>
    <1000,100,2325>
    texture { T_MurSale4 }
  }
  box
  {
    <1025,100,-225>
    <1000,150,2325>
  }
  box
  {
    < 550, 0,-225>
    <1000,30,2325>
  }
  difference
  {
    
    union
    {
      box
      {
        <1020,150,-225>
        <1000,450,2325>
        texture { T_MurMap rotate 90*y }
      }
      box
      {
        <1025,300,-225>
        <1000,320,1575>
      }
    }
    union
    {
      #declare f = 0;
      #while (f < 1575)
        object {  TrouFenetreDep rotate 90*y translate <1000,0,f> }
        #declare f = f + 340;
      #end
    }
  }
  #declare f = 0;
  #while (f < 1575)
    object { CadreFenetreDep rotate -90*y translate <1020,0,f> }
    #declare f = f + 340;
  #end
  box
  {
    <1025,450,-225>
    <1000,500,2325>
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    <1030,500,-225>
    <1000,510,2325>
    texture { T_MurSale2 translate 50*y }
  }
  box
  {
    <1032,510,-225>
    <1000,512,2325>
  }
  
  texture { T_MurClaire }
}

#declare FacadeDepNSInt =
union
{
  object { ColonneDep translate < 550,0,2325> }
  object { ColonneDep translate < 550,0,1575> }
  box
  {
    <520,  0, 225>
    <550,100, 750>
    texture { T_MurSale4 }
  }
  box
  {
    <550,70, 750>
    <520, 0,1050>
  }
  box
  {
    <520,  0,1050>
    <550,100,2325>
  }
  box
  {
    <525,100, 225>
    <550,150, 750>
  }
  box
  {
    <525,100,1050>
    <550,150,2325>
  }
  difference
  {
    
    union
    {
      box
      {
        <530,150, 225>
        <550,450,2325>
        texture { T_MurMap rotate 90*y }
      }
      box
      {
        <525,300, 225>
        <550,320,1575>
      }
    }
    union
    {
      object { TrouFenetreDep rotate 90*y translate <530,0,350> }
      object { TrouFenetreDep rotate 90*y translate <530,0,575> }
      object { TrouLargePorteDep rotate 90*y translate <530,0,900> }
      object { TrouFenetreDep rotate 90*y translate <530,0,1225> }
      object { TrouFenetreDep rotate 90*y translate <530,0,1450> }

      object { TrouFenetreDep rotate 90*y translate <530,0,1700> }
      object { TrouFenetreDep rotate 90*y translate <530,0,1950> }
      object { TrouFenetreDep rotate 90*y translate <530,0,2200> }
    }
  }
  object { CadreFenetreDep rotate 90*y translate <530,0,350> }
  object { CadreFenetreDep rotate 90*y translate <530,0,575> }
  object { CadreFenetreDep rotate 90*y translate <530,0,1225> }
  object { CadreFenetreDep rotate 90*y translate <530,0,1450> }
  object { CadreLargePorteDep rotate 90*y translate <530,0,900> }

  object { Cadre2FenetreDep rotate 90*y translate <530,0,1700> }
  object { Cadre2FenetreDep rotate 90*y translate <530,0,1950> }
  object { Cadre2FenetreDep rotate 90*y translate <530,0,2200> }

  box
  {
    <530,450,-225>
    <550,500,2325>
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    <525,500,-225>
    <550,510,2325>
    texture { T_MurSale2 translate 50*y }
  }
  box
  {
    <523,510,-225>
    <550,512,2325>
  }

  texture { T_MurClaire }
}

#declare FacadeDepOuest =
union
{
  box
  {
    < 550,  0, 0>
    <1000,100,30>
    texture { T_MurSale4 }
  }
  box
  {
    < 550,100, 0>
    <1000,150,25>
  }
  difference
  {
    union
    {
      box
      {
        < 550,150, 0>
        <1000,450,20>
        texture { T_MurMap }
      }
      box
      {
        < 550,300, 0>
        <1000,320,25>
      }
    }
    object { TrouFenetreDep translate 775*x }
  }
  object { CadreFenetreDep rotate 180*y translate <775,0,20> }
  box
  {
    < 550,450,25>
    <1000,500, 0>
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    < 550,500,30>
    <1000,510, 0>
    texture { T_MurSale2 translate 50*y }
  }
  box
  {
    < 550,510,32>
    <1000,512, 0>
  }
  difference
  {
    cylinder
    {
      <775,575,15>
      <775,575,-40>
      110
    }
    union
    {
      cylinder
      {
        <775,575, 50>
        <775,575,-50>
        40
      }
      cylinder
      {
        <775,575,  0>
        <775,575,-50>
        80
      }
    }
  }
  box
  {
    <650,512,15>
    <700,630,-40>
  }
  box
  {
    <850,512,15>
    <900,630,-40>
  }
  box
  {
    <645,630,20>
    <680,635,-40>
  }
  box
  {
    <870,630,20>
    <905,635,-40>
  }
  difference
  {
    cylinder
    {
      <775,575,20>
      <775,575,-40>
      115
    }
    union
    {
      cylinder
      {
        <775,575, 50>
        <775,575,-50>
        110
      }
      box
      {
        < 500,630, 50>
        <1000,400,-50>
      }
    }
  }
  
  translate 2325*z
  texture { T_MurClaire }
}

#declare PlafondDep =
union
{
  box
  {
    < -30,450,-255>
    <1030,460, 255>
  }
  box
  {
    < 520,450, 255>
    <1030,460,2355>
  }
  box
  {
    < -35,460,-260>
    <1035,468, 260>
  }
  box
  {
    < 515,460, 260>
    <1035,468,2360>
  }
  box
  {
    < -40,468,-265>
    <1040,470, 265>
  }
  box
  {
    < 510,468, 265>
    <1040,470,2365>
    texture { T_MurClaire }
  }
  texture { T_MurSale2 }
}

#declare Toit1Dep =
union
{
  union
  {
    cylinder
    {
      <  0,512,-225>
      <215,700,   0>
      4
    }
    cylinder
    {
      <  0,512, 225>
      <215,700,   0>
      4
    }
    cylinder
    {
      <1000,512,-225>
      < 775,700,   0>
      4
    }
    cylinder
    {
      <550,512, 225>
      <775,700,   0>
      4
    }
    cylinder
    {
      <215,700,0>
      <775,700,0>
      4
    }
    cylinder
    {
      <775,700,0>
      <775,700,1625>
      4
    }
    pigment { color BleuToit }
    finish { FinishToit }
  }
  polygon
  {
    4,
    <0,512,-225>,
    <0,512, 225>,
    <215,700,0>,
    <0,512,-225>
    texture { T_Toit2 translate 180*y rotate 90*y rotate (-90+41.167)*z }
  }
  difference
  {
    polygon
    {
      5,
      <   0,512,-225>,
      <1000,512,-225>,
      < 775,700,0>,
      < 215,700,0>,
      <   0,512,-225>
    }
    union
    {
      box
      {
        <275,512, -75>
        <350,700,-150>
      }
      box
      {
        <725,512, -75>
        <650,700,-150>
      }
    }
    texture { T_Toit2 rotate (90-39.88)*x }
  }
  difference
  {
    polygon
    {
      5,
      <  0,512,225>,
      <550,512,225>,
      <775,700,0>,
      <215,700,0>,
      <  0,512,225>
    }
    box
    {
      <275,512, 75>
      <350,700,150>
    }
    texture { T_Toit2 rotate (-90+39.88)*x }
  }
  difference
  {
    polygon
    {
      5,
      <1000,512,-225>,
      < 775,700,0>,
      < 775,700,1625>,
      <1000,512,1575>,
      <1000,512,-225>
    }
    union
    {
      box
      {
        <850,512,225>
        <925,700,300>
      }
      box
      {
        <850,512,1225>
        <925,700,1300>
      }
    }
    texture { T_Toit2 rotate (90-39.88)*z }
  }
  difference
  {
    polygon
    {
      5,
      <550,512, 225>,
      <775,700,0>,
      <775,700,1625>,
      <550,512,1575>,
      <550,512, 225>
    }
    union
    {
      box
      {
        <700,512,500>
        <625,700,575>
      }
      box
      {
        <700,512,1225>
        <625,700,1300>
      }
    }
    texture { T_Toit2 rotate (-90+39.88)*z }
  }
  pigment { Red }
}

#declare Toit2Dep =
union
{
  cylinder
  {
    <550,512,1575>
    <600,700,1625>
    4
  }
  cylinder
  {
    <1000,512,1575>
    < 950,700,1625>
    4
  }
  cylinder
  {
    <550,512,2325>
    <600,700,2275>
    4
  }
  cylinder
  {
    <1000,512,2325>
    < 950,700,2275>
    4
  }
  box
  {
    <595,700,1620>
    <955,705,2280>
  }
  union
  {
    polygon
    {
      5,
      <550,512,1575>,
      <600,700,1625>,
      < 950,700,1625>,
      <1000,512,1575>,
      <550,512,1575>
      texture { T_Toit1 translate 100*y rotate (90-75.12)*x }
    }
    polygon
    {
      5,
      <550,512,2325>,
      <600,700,2275>,
      < 950,700,2275>,
      <1000,512,2325>,
      <550,512,2325>
      texture { T_Toit1 translate 100*y rotate (-90+75.12)*x }
    }
    polygon
    {
      5,
      < 950,700,1625>,
      <1000,512,1575>,
      <1000,512,2325>,
      < 950,700,2275>,
      < 950,700,1625>
      texture { T_Toit1 translate 30*y rotate (90-75.12)*z }
    }
    difference
    {
      polygon
      {
        5,
        <550,512,1575>,
        <600,700,1625>,
        <600,700,2275>,
        <550,512,2325>,
        <550,512,1575>
      }
      union
      {
        cylinder
        {
          <500,650,1800>
          <650,650,1800>
          40
        }
        box
        {
          <500,650,1760>
          <650,510,1840>
        }
      }
      texture { T_Toit1 translate 30*y rotate (-90+75.12)*z }
    }
    pigment { Red }
  }
  cylinder
  {
    <600,700,1625>
    <775,750,1775>
    4
  }
  cylinder
  {
    <950,700,1625>
    <775,750,1775>
    4
  }
  cylinder
  {
    <600,700,2275>
    <775,750,2125>
    4
  }
  cylinder
  {
    <950,700,2275>
    <775,750,2125>
    4
  }
  cylinder
  {
    <775,750,1775>
    <775,750,2125>
    4
  }
  polygon
  {
    4,
    <775,750,1775>,
    <600,700,1625>,
    <950,700,1625>,
    <775,750,1775>
  }
  polygon
  {
    4,
    <775,750,2125>,
    <600,700,2275>,
    <950,700,2275>,
    <775,750,2125>
  }
  polygon
  {
    5
    <600,700,1625>,
    <775,750,1775>,
    <775,750,2125>,
    <600,700,2275>,
    <600,700,1625>
  }
  polygon
  {
    5,
    <950,700,1625>,
    <775,750,1775>,
    <775,750,2125>,
    <950,700,2275>,
    <950,700,1625>
  }
  box
  {
    < 0,-2,-2>
    <91, 2, 2>
    rotate 15.9*z
    translate <600,700,1706.25>
  }
  box
  {
    <  0,-2,-2>
    <-91, 2, 2>
    rotate -15.9*z
    translate <950,700,1706.25>
  }
  #declare a = 1787.5;
  #while (a < 2150)
    box
    {
      <  0,-2,-2>
      <182, 2, 2>
      rotate 15.9*z
      translate <600,700,a>
    }
    box
    {
      <   0,-2,-2>
      <-182, 2, 2>
      rotate -15.9*z
      translate <950,700,a>
    }
    #declare a = a + 81.25;
  #end
  box
  {
    < 0,-2,-2>
    <91, 2, 2>
    rotate 15.9*z
    translate <600,700,2193.75>
  }
  box
  {
    <  0,-2,-2>
    <-91, 2, 2>
    rotate -15.9*z
    translate <950,700,2193.75>
  }
  box
  {
    <-2,-2,108>
    < 2, 2,158>
    rotate 18.4*x
    translate <653.125,750,2125>
  }
  box
  {
    <-2,-2, 40>
    < 2, 2,158>
    rotate 18.4*x
    translate <734.375,750,2125>
  }
  box
  {
    <-2,-2, 40>
    < 2, 2,158>
    rotate 18.4*x
    translate <815.625,750,2125>
  }
  box
  {
    <-2,-2,108>
    < 2, 2,158>
    rotate 18.4*x
    translate <896.875,750,2125>
  }
  
  box
  {
    <-2,-2,-108>
    < 2, 2,-158>
    rotate -18.4*x
    translate <653.125,750,1775>
  }
  box
  {
    <-2,-2, -40>
    < 2, 2,-158>
    rotate -18.4*x
    translate <734.375,750,1775>
  }
  box
  {
    <-2,-2, -40>
    < 2, 2,-158>
    rotate -18.4*x
    translate <815.625,750,1775>
  }
  box
  {
    <-2,-2,-108>
    < 2, 2,-158>
    rotate -18.4*x
    translate <896.875,750,1775>
  }
  
  pigment { color BleuToit }
  finish { FinishToit }
}

#declare Velux =
union
{
  box
  {
    < 0,0,0> 
    <75,5,5>
  }
  box
  {
    < 0,0,97.8>
    <75,5,92.8>
  }
  box
  {
    <0,0,0>
    <5,5,97.8>
  }
  box
  {
    <70,0,0>
    <75,5,97.8>
  }
  box
  {
    <35,0,0>
    <40,5,97.8>
  }
  box
  {
    y, <75,2,97.8>
    texture { T_Vitre }
  }
  pigment { White }
}

#declare VeluxDep =
union
{
  object
  {
    Velux
    rotate -90*y
    rotate (180+39.88)*z
    translate <625,577,1225>
  }
  object
  {
    Velux
    rotate -90*y
    rotate (180+39.88)*z
    translate <625,577,500>
  }
  object
  {
    Velux
    rotate -90*y
    rotate -39.88*z
    translate <925,571,1225>
  }
  object
  {
    Velux
    rotate -90*y
    rotate -39.88*z
    translate <925,575,225>
  }
  object
  {
    Velux
    rotate (180+39.88)*x
    translate <275,577,150>
  }
  object
  {
    Velux
    rotate -39.88*x
    translate <275,571,-150>
  }
  object
  {
    Velux
    rotate -39.88*x
    translate <650,571,-150>
  }
}

#declare FenetreToit =
union
{
  box
  {
    <550,512,1750>
    <600,640,1765>
  }
  box
  {
    <550,512,1835>
    <600,640,1850>
  }
  difference
  {
    cylinder
    {
      <550,640,1800>
      <600,640,1800>
      50
    }
    union
    {
      cylinder
      {
        <500,640,1800>
        <650,640,1800>
        35
      }
      box
      {
        <500,640,1765>
        <650,500,1835>
      }
    }
  }
  difference
  {
    cylinder
    {
      <545,640,1800>
      <600,640,1800>
      51
    }
    union
    {
      cylinder
      {
        <500,640,1800>
        <650,640,1800>
        47
      }
      box
      {
        <500,640,1752>
        <650,500,1848>
      }
    }
  }
  
  union
  {
    box
    {
      <555,512,1765>
      <560,550,1835>
    }
    box
    {
      <555,592,1765>
      <560,595,1835>
    }
    box
    {
      <555,640,1765>
      <560,637,1835>
    }
    box
    {
      <555,512,1765>
      <560,640,1768>
    }
    box
    {
      <555,512,1798>
      <560,670,1802>
    }
    box
    {
      <555,512,1832>
      <560,640,1835>
    }
    difference
    {
      cylinder
      {
        <555,640,1800>
        <560,640,1800>
        35
      }
      union
      {
        cylinder
        {
          <550,640,1800>
          <570,640,1800>
          32
        }
        box
        {
          <550,640,1700>
          <570,600,1900>
        }
      }
    }
    pigment { White }
  }
  union
  {
    cylinder
    {
      <563,640,1800>
      <562,640,1800>
      35
    }
    box
    {
      <563,512,1765>
      <562,640,1835>
    }
    texture { T_Vitre }
  }
  
  texture { T_MurClaire }
}

#declare Dependance =
union
{
  object { FacadeParking }
  object { PorteDep }
  object { FacadeDepEst }
  object { FacadeDepIntEst }
  object { FacadeDepNSExt }
  object { FacadeDepNSInt }
  object { FacadeDepOuest }
  object { PlafondDep }
  object { Toit1Dep }
  object { Toit2Dep }
  object { VeluxDep }
  object { FenetreToit }
}

#declare ChemineDepNordEst =
union
{
  difference
  {
    box
    {
      <550,600,95>
      <590,750, 5>
    }
    box
    {
      <540,  0,-50>
      <600,100,150>
      rotate 39.88*x
      translate <0,720,5>
    }
  }
  
  difference
  {
    box
    {
      <555,600,90>
      <585,800,10>
    }
    intersection
    {
      union
      {
        box
        {
          <557,600,80>
          <550,790,20>
        }
        box
        {
          <583,600,80>
          <590,790,20>
        }
        box
        {
          <565,600,83>
          <575,790,100>
        }
        box
        {
          <565,600,17>
          <575,790, 0>
        }
      }
      box
      {
        <540,  0,-50>
        <600,100,150>
        rotate 39.88*x
        translate <0,730,5>
      }
    }
    texture { T_MurMap rotate 90*y }
  }
  box
  {
    <553,800,92>
    <587,805, 8>
  }
  box
  {
    <555,805,10>
    <560,815,15>
  }
  box
  {
    <555,805,90>
    <560,815,85>
  }
  box
  {
    <580,805,10>
    <585,815,15>
  }
  box
  {
    <580,805,90>
    <585,815,85>
  }
  box
  {
    <553,815,92>
    <587,817, 8>
  }
  texture { T_MurClaire }
}

#declare ChemineDblDepNord =
union
{
  // Chemin sud
  difference
  {
    box
    {
      <660,600,880>
      <770,750,920>
    }
    box
    {
      <  50,  0,850>
      <-150,100,950>
      rotate 39.88*z
      translate <770,720,0>
    }
  }
  difference
  {
    box
    {
      <665,600,885>
      <765,800,915>
    }
    intersection
    {
      union
      {
        box
        {
          <675,600,887>
          <755,790,800>
        }
        box
        {
          <675,600,913>
          <755,790,950>
        }
        box
        {
          <667,600,895>
          <650,790,905>
        }
        box
        {
          <763,600,895>
          <800,790,905>
        }
      }
      box
      {
        <  50,  0,850>
        <-150,150,950>
        rotate 39.88*z
        translate <770,730,0>
      }
    }
    texture { T_MurMap }
  }
  box
  {
    <663,800,883>
    <767,805,917>
  }
  box
  {
    <665,805,885>
    <670,815,890>
  }
  box
  {
    <665,805,910>
    <670,815,915>
  }
  box
  {
    <760,805,910>
    <765,815,915>
  }
  box
  {
    <760,805,885>
    <765,815,890>
  }
  box
  {
    <663,815,883>
    <767,817,917>
  }
  
  // Chemin nord
  difference
  {
    box
    {
      <870,600,880>
      <780,750,920>
    }
    box
    {
      <-50,  0,850>
      <150,100,950>
      rotate -39.88*z
      translate <780,720,0>
    }
  }
  difference
  {
    box
    {
      <865,600,885>
      <785,800,915>
    }
    intersection
    {
      union
      {
        box
        {
          <855,600,887>
          <795,790,800>
        }
        box
        {
          <855,600,913>
          <795,790,950>
        }
        box
        {
          <787,600,895>
          <700,790,905>
        }
        box
        {
          <863,600,895>
          <900,790,905>
        }
      }
      box
      {
        <-50,  0,850>
        <150,120,950>
        rotate -39.88*z
        translate <780,730,0>
      }
    }
    texture { T_MurMap }
  }
  box
  {
    <867,800,883>
    <783,805,917>
  }
  box
  {
    <785,805,885>
    <790,815,890>
  }
  box
  {
    <785,805,910>
    <790,815,915>
  }
  box
  {
    <860,805,910>
    <865,815,915>
  }
  box
  {
    <860,805,885>
    <865,815,890>
  }
  box
  {
    <867,815,883>
    <783,817,917>
  }
  
  texture { T_MurClaire }
}

#declare ChemnineDepNordOuest =
union
{
  difference
  {
    box
    {
      <660,600,880>
      <770,750,920>
    }
    box
    {
      <  50,  0,850>
      <-150,100,950>
      rotate 39.88*z
      translate <770,720,0>
    }
  }
  difference
  {
    box
    {
      <665,600,885>
      <765,800,915>
    }
    intersection
    {
      union
      {
        box
        {
          <675,600,887>
          <755,790,800>
        }
        box
        {
          <675,600,913>
          <755,790,950>
        }
        box
        {
          <667,600,895>
          <650,790,905>
        }
        box
        {
          <763,600,895>
          <800,790,905>
        }
      }
      box
      {
        <  50,  0,850>
        <-150,150,950>
        rotate 39.88*z
        translate <770,730,0>
      }
    }
    texture { T_MurMap }
  }
  box
  {
    <663,800,883>
    <767,805,917>
  }
  box
  {
    <665,805,885>
    <670,815,890>
  }
  box
  {
    <665,805,910>
    <670,815,915>
  }
  box
  {
    <760,805,910>
    <765,815,915>
  }
  box
  {
    <760,805,885>
    <765,815,890>
  }
  box
  {
    <663,815,883>
    <767,817,917>
  }
  translate 700*z
  texture { T_MurClaire }
}

#declare DependanceNord =
union
{
  object { Dependance }
  object { ChemineDepNordEst }
  object { ChemineDblDepNord }
  object { ChemnineDepNordOuest }
  translate <2300,0,3960>  
}

#declare ChemnineDepSudEst =
union
{
  difference
  {
    box
    {
      <870,600,880>
      <780,750,920>
    }
    box
    {
      <-50,  0,850>
      <150,100,950>
      rotate -39.88*z
      translate <780,720,0>
    }
  }
  difference
  {
    box
    {
      <865,600,885>
      <785,800,915>
    }
    intersection
    {
      union
      {
        box
        {
          <855,600,887>
          <795,790,800>
        }
        box
        {
          <855,600,913>
          <795,790,950>
        }
        box
        {
          <787,600,895>
          <700,790,905>
        }
        box
        {
          <863,600,895>
          <900,790,905>
        }
      }
      box
      {
        <-50,  0,850>
        <150,120,950>
        rotate -39.88*z
        translate <780,730,0>
      }
    }
    texture { T_MurMap }
  }
  box
  {
    <867,800,883>
    <783,805,917>
  }
  box
  {
    <785,805,885>
    <790,815,890>
  }
  box
  {
    <785,805,910>
    <790,815,915>
  }
  box
  {
    <860,805,910>
    <865,815,915>
  }
  box
  {
    <860,805,885>
    <865,815,890>
  }
  box
  {
    <867,815,883>
    <783,817,917>
  }
  translate -710*z
  texture { T_MurClaire }
}

#declare Aeration =
union
{
  box
  {
    <30,700,-25>
    < 5,770, 25>
  }
  box
  {
    < 7,770,-25>
    < 5,775,-23>
  }
  box
  {
    <30,770,-25>
    <28,775,-23>
  }
  box
  {
    < 7,770, 23>
    < 5,775, 25>
  }
  box
  {
    <30,770, 23>
    <28,775, 25>
  }
  box
  {
    <35,777,-30>
    < 0,775, 30>
  }
  pigment { color BleuToit }
  finish { FinishToit }
}

#declare DependanceSud =
union
{
  object { Dependance }
  object { ChemnineDepSudEst }
  object { Aeration translate <780,0,1820> }
  object { Aeration translate <780,0,2080> }
  translate <2300,0,3960>  
  scale <-1,1,1>
}

////////////////////////////////////////////////////////////////////////////////
// Les trois arches
////////////////////////////////////////////////////////////////////////////////

#declare Arche1 =
union
{
  box
  {
    < 100,  0,0>
    < 105,350,5>
  }
  box
  {
    <-100,  0,0>
    <-105,350,5>
  }
  box
  {
    < 120,  0,0>
    < 125,350,5>
  }
  box
  {
    <-120,  0,0>
    <-125,350,5>
  }
  #declare a = 0;
  #while (a < 350)
    box
    {
      <-105,a,2>
      <-115,a+10,2.1>
    }
    box
    {
      < 105,a,2>
      < 125,a+10,2.1>
    }
  #declare a = a + 30;
  #end
  box
  {
    <-120,  0,0>
    <-115,350,5>
  }
  difference
  {
    cylinder
    {
      0, 6*z, 105
      scale <1,35/105,1>
    }
    union
    {
      cylinder
      {
        -1*z, 9*z, 100
        scale <1,30/100,1>
      }
      box
      {
        <-150,0,-1>
        < 150,-150,9>
      }
    }
    translate 350*y
  }
  box
  {
    <-100,335,0>
    < -90,330,5>
  }
  box
  {
    < 100,335,0>
    <  90,330,5>
  }
  difference
  {
    cylinder
    {
      0, 5*z, 95
      scale <1,35/105,1>
    }
    union
    {
      cylinder
      {
        -1*z, 6*z, 90
        scale <1,30/100,1>
      }
      box
      {
        <-150,0,-1>
        < 150,-150,6>
      }
    }
    translate 335*y
  }
  difference
  {
    cylinder
    {
      2.1*z, 2*z, 115
      scale <1,40/115,1>
      translate 360*y
    }
    union
    {
      cylinder
      {
        0, 6*z, 105
        scale <1,35/105,1>
      }
      box
      {
        <-150,0,-1>
        < 150,-150,6>
      }
      translate 350*y
    }
  }
  box
  {
    <-200,350,0>
    <-100,345,6>
  }
  box
  {
    < 210,350,0>
    < 100,345,6>
  }
  difference
  {
    cylinder
    {
      -5*z,15*z, 120
      scale <1,45/120,1>
    }
    union
    {
      cylinder
      {
        -10*z, 30*z, 115
        scale <1,40/115,1>
      }
      box
      {
        <-150,0,-10>
        < 150,-150,30>
      }
    }
    translate 360*y
  }
  box
  {
    <-200,365,-5>
    <-115,360,15>
  }
  box
  {
    < 210,365,-5>
    < 115,360,15>
  }
  box
  {
    < 210,350,-2>
    < 110,360,-2.1>
  }
  box
  {
    <-210,350,-2>
    <-110,360,-2.1>
  }
  height_field
  {
    png "hf1.png"
    smooth
    water_level 0.1
    rotate -90*x
    scale <45,45*(1893/167),5>
    translate <-167,-165,5>
  }
  union
  {
    height_field
    {
      png "hf1.png"
      smooth
      water_level 0.001
      rotate -90*x
      scale <45,45*(1893/167),5>
    }
    height_field
    {
      png "hf1.png"
      smooth
      water_level 0.001
      rotate -90*x
      scale <-45,45*(1893/167),5>
    }
    translate <167,-165,5>
  }
  union
  {
    height_field
    {
      png "arche1.png"
      smooth
      water_level 0.001
      rotate -90*x
      scale <167,110,5>
    }
    height_field
    {
      png "arche1.png"
      smooth
      water_level 0.001
      rotate -90*x
      scale <-167,110,5>
    }
    translate <0,361,5>
  }
}

#declare Arche2 =
union
{
  #declare __hf2 =
  height_field
  {
    png "hf2.png"
    smooth
    water_level 0.001
    rotate -90*x
  }
  #declare _hf2 =
  union
  {
    object { __hf2 scale < 12.5, 175,5> translate <0,175,5> }
    object { __hf2 scale <-12.5, 175,5> translate <0,175,5> }
    object { __hf2 scale < 12.5,-175,5> translate <0,175,5> }
    object { __hf2 scale <-12.5,-175,5> translate <0,175,5> }
  }
  object { _hf2 translate -137.5*x }
  object { _hf2 translate  137.5*x }
  box
  {
    <-150,  0,0>
    <-155,350,5>
  }
  box
  {
    <-120,  0,0>
    <-125,365,5>
  }
  box
  {
    <-155,345,0>
    <-120,350,5>
  }
  box
  {
    <-160,365,-5>
    <-120,360,15>
  }
  
  box
  {
    < 150,  0,0>
    < 155,350,5>
  }
  box
  {
    < 120,  0,0>
    < 125,365,5>
  }
  box
  {
    < 155,345,0>
    < 120,350,5>
  }
  box
  {
    < 160,365,-5>
    < 120,360,15>
  }
  box
  {
    < 155,350,-2>
    < 120,360,-2.1>
  }
  box
  {
    <-155,350,-2>
    <-120,360,-2.1>
  }
  difference
  {
    union
    {
      difference
      {
        cylinder { 0,   5*z,125 }
        cylinder { -1*z,6*z,120 }
      }
      difference
      {
        cylinder {  2*z,2.1*z,150 }
        cylinder { -1*z,6*z,125 }
      }
      difference
      {
        cylinder { -5*z,15*z,155 }
        cylinder { -6*z,30*z,150 }
      }
    }
    box
    {
      <-200,0,-10>
      < 200,-200,30>
    }
    translate 365*y
  }
  union
  {
    height_field
    {
      png "arche2.png"
      smooth
      water_level 0.001
      rotate -90*x
      scale <228,335,5>
    }
    height_field
    {
      png "arche2.png"
      smooth
      water_level 0.001
      rotate -90*x
      scale <-228,335,5>
    }
    translate <0,365,5>
  }
}

#declare Arche3 =
object
{
  Arche1
  scale <-1,1,1>
}

#declare TroisArches =
union
{
  object
  {
    Arche1
    translate 670*z
    rotate 15*y
  }
  object
  {
    Arche2
    translate 685*z
    rotate 45*y
  }
  object
  {
    Arche3
    translate 670*z
    rotate 75*y
  }
  translate <1590,0,4185>
  texture { T_FerKhaki }
}

////////////////////////////////////////////////////////////////////////////////
// Les deux lampadaire
////////////////////////////////////////////////////////////////////////////////

#declare Lampadaire =
union
{
  box
  {
    <-15, 0,-15>
    < 15,30, 15>
    texture { T_MurClaire }
  }
  cylinder
  {
    30*y, 200*y, 7.5
  }
  cone
  {
    200*y,7.5
    210*y,0
  }
  #declare a = 0;
  #declare d = 0;
  #declare h = 0;
  #declare ai = 5;
  #declare ns = 180 / ai;
  blob
  {
    threshold 1
  #while (a <= 180)
    sphere
    {
      <3 + d,130 + h,0>, 8, 1
      rotate a*y
    }
    #declare a = a + ai;
    #declare h = h + (100/ ns);
    #declare d = d + (20 / ns);
  #end
  }
  intersection
  {
    torus
    {
      24, 4
      rotate 90*x
    }
    box
    {
      <0,0,-10>
      <-50,50,10>
    }
    translate <0,230,0>
  }
  difference
  {
    union
    {
      torus
      {
        15, 3
        rotate 90*x
      }
      cylinder
      {
        -3*z, 3*z, 15
      }
    }
    union
    {
      box
      {
        <0,-50,-5>
        <-50,50,5>
      }
      cylinder
      {
        <0,-3,-5>
        <0,-3, 5>
        9
      }
    }
    
    translate <0,223,0>
  }
  sphere { 208*y, 4 }
  cylinder
  {
    227*y, 280*y, 5
  }
  torus
  {
    5,1
    translate 270*y
  }
  cone
  {
    275*y,0
    285*y,10
  }
  difference
  {
    sphere
    {
      300*y, 18
    }
    sphere
    {
      300*y, 17
    }
    material { M_NB_Glass }
  }
  
  translate <-500,0,1750>
  texture { T_FerKhaki }
}


////////////////////////////////////////////////////////////////////////////////

object { PiedPoteau translate <-222,0,500> }
object { Poteau translate <-222,52,500> }
object { PiedPoteau translate < 222,0,500> }
object { Poteau translate < 222,52,500> }
object { Grilles translate 500*z }

object { Chateau translate 5000*z }

object { MurettesParking }

object { DependanceNord }
object { DependanceSud }

object { TroisArches }
object { TroisArches scale <-1,1,1> }

object { Lampadaire }
object { Lampadaire scale <-1,1,1> }
