////////////////////////////////////////////////////////////////////////////////
//
// Crane.inc -- Crane for SnoBuild.pov (IRTC 3-4/2003)
//              by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#macro Crane(loc, targetLoc)

  #local CatThickness = .1;
  #local CatHeight = 3 - 2 * CatThickness;
  #local CatDepth = 2;
  #local NumWheels = 6;
  #local TotalHeight = 9;
  #local TotalWidth  = CatHeight * NumWheels + 2 * CatThickness;
  #local BodyDepth  = 12;
  #local ArmHeight = 3;
  #local ArmDepth = 3;
  #local ControlRadius = 0.2;
  #local ControlHeight = 1;
  #local ArmOffset = 1;
  
  #local xs = loc.x + TotalWidth - ArmOffset;
  #local ys = TotalHeight;
  #local xt = targetLoc.x;
  #local yt = targetLoc.y;
  
  #local ArmWidth = sqrt((xt-xs)*(xt-xs) + (yt-ys)*(yt-ys) - ArmHeight*ArmHeight);
  
  union {
    object {
      difference {
        superellipsoid {
          < 0.2, 0.2 >
          scale < TotalWidth / 2, (TotalHeight - CatHeight / 2) / 2, BodyDepth / 2 >
          translate < TotalWidth / 2, (TotalHeight - CatHeight / 2) / 2 + CatHeight / 2, BodyDepth / 2 + CatDepth >
          texture { Tx_CraneBody }
        }          
        box {
          < 1, CatHeight / 2 + .1, CatDepth + .3 >,
          < TotalWidth / 3, TotalHeight + .1, CatDepth + BodyDepth - .3 >
          texture { Tx_CraneBody }
        }
        box {
          < 0, CatHeight + 1.8, CatDepth >,
          < TotalWidth / 3, TotalHeight + .1, CatDepth + BodyDepth >
          texture { Tx_CraneBody }
        }
      }
    }
    difference {
      union {
        cylinder {
          < CatHeight / 2, CatHeight / 2, 0 >,
          < CatHeight / 2, CatHeight / 2, BodyDepth + 2 * CatDepth >,
          CatHeight / 2
        }
        box {
          < CatHeight / 2, 0, 0 >,
          < TotalWidth - CatHeight / 2, CatHeight, BodyDepth + 2 * CatDepth >
        }
        cylinder {
          < TotalWidth - CatHeight / 2, CatHeight / 2, 0 >,
          < TotalWidth - CatHeight / 2, CatHeight / 2, BodyDepth + 2 * CatDepth >,
          CatHeight / 2
        }
      }
      union {
        cylinder {
          < CatHeight / 2, CatHeight / 2, -1 >,
          < CatHeight / 2, CatHeight / 2, BodyDepth + 2 * CatDepth + 1 >,
          CatHeight / 2 - CatThickness
        }
        box {
          < CatHeight / 2, CatThickness, -1 >,
          < TotalWidth - CatHeight / 2, CatHeight - CatThickness, BodyDepth + 2 * CatDepth + 1 >
        }
        cylinder {
          < TotalWidth - CatHeight / 2, CatHeight / 2, -1 >,
          < TotalWidth - CatHeight / 2, CatHeight / 2, BodyDepth + 2 * CatDepth + 1 >,
          CatHeight / 2 - CatThickness
        }
      }
      texture { Tx_Cat }
    }
    union {
      #local i = 0;
      #while (i < NumWheels)
        cylinder {
          < CatHeight / 2 + CatHeight * i + CatThickness, CatHeight / 2, 0 >,
          < CatHeight / 2 + CatHeight * i + CatThickness, CatHeight / 2, BodyDepth + 2 * CatDepth >,
          CatHeight / 2
        }
        #local i = i + 1;
      #end
      texture { Tx_Cat }
    }
    object {
      SSM(60, 0, 0)
      rotate 90*y
      translate < TotalWidth / 3.5, CatHeight / 2, CatDepth + BodyDepth / 2 >
    }
    union {
      cylinder {
        < 0.5, CatHeight + 1.8, CatDepth + BodyDepth / 2 - 2 >,
        < 0.5, CatHeight + 1.8 + ControlHeight, CatDepth + BodyDepth / 2 - 2 >,
        ControlRadius
      }
      cylinder {
        < 0.5, CatHeight + 1.8, CatDepth + BodyDepth / 2 >,
        < 0.5, CatHeight + 1.8 + ControlHeight, CatDepth + BodyDepth / 2 >,
        ControlRadius
      }
      cylinder {
        < 0.5, CatHeight + 1.8, CatDepth + BodyDepth / 2 + 2 >,
        < 0.5, CatHeight + 1.8 + ControlHeight, CatDepth + BodyDepth / 2 + 2 >,
        ControlRadius
      }
      texture { Tx_Control }
    }
    box {
      < 0, 0, 0 >, < 1, 1, 1 >
      texture {
        pigment {
          image_map { gif "Logo.gif" once transmit 0, 1 }
        }
      }
      scale < 242, 148, .001 >
      scale < .03, .03, 1 >
      translate < TotalWidth - 8.5, CatHeight + .5, CatDepth - .001 >
    }
    union {
      difference {
        box {
          < 0, 0, 0 >,
          < ArmWidth, ArmHeight, ArmDepth >
          texture { Tx_CraneBody }
        }
        box {
          < 1, -1, -1 >,
          < ArmWidth * .9, ArmHeight / 3, ArmDepth + 1 >
          texture { Tx_CraneBody }
        }
      }
      cylinder {
        < .1, ArmHeight / 6, ArmDepth / 2 >,
        < ArmWidth - .1, ArmHeight / 6, ArmDepth / 2 >,
        .2
        texture { Tx_Cable }
      }
      translate < -ArmWidth, -ArmHeight, 0 >
      rotate < 0, 0, -degrees(asin((yt-ys) / ArmWidth))  >
      translate < TotalWidth - ArmOffset, TotalHeight, CatDepth + (BodyDepth - ArmDepth) / 2 >
    }
    cylinder {
      < TotalWidth * .5, TotalHeight, CatDepth + BodyDepth / 2 >,
      < TotalWidth * .5, TotalHeight + 1, CatDepth + BodyDepth / 2 >,
      .5
      texture { Tx_CraneBody }
    }
    cylinder {
      < TotalWidth * .5, TotalHeight, CatDepth + BodyDepth / 2 >,
      < TotalWidth * .5, TotalHeight + 5, CatDepth + BodyDepth / 2 >,
      .4
      texture { Tx_Shaft }
    }
    translate loc
  }

#end
