////////////////////////////////////////////////////////////////////////////////
//
// Params.inc -- Parameters for SnoBuild.pov (IRTC 3-4/2003)
//               by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

// Scene inclusion parameters

#declare ShowFallingSnow   =  1;
#declare ShowGroundSnow    =  1;
#declare ShowLargeSnowman  =  1;
#declare ShowSmallSnowmen  =  1;
#declare ShowTree          =  1;
#declare ShowCrane         =  1;
#declare ShowScaffolds     =  1;

// View parameters
//
// 1 = standard view
// 2 = close view of front scaffolding
// 3 = close view of crane

#declare View              =  1;

// Large snowman parameters

#declare LSMBottomDiameter = 36;
#declare LSMMiddleDiameter = 28;
#declare LSMHeadDiameter   = 18;
#declare LSMLowerOverlap   =  6;
#declare LSMUpperOverlap   =  3;
#declare LSMHeadOverBody   =  9;
            
// Small snowman parameters
            
#declare SSMScaleFactor    = 10;
#declare SSMScaleVariance  = 15;
#declare SSMLopsideFactor  = 30;

// Nose carrot parameters

#declare CNoseLength       =  6;
#declare CNoseSegmentSize  =  0.25;
#declare CNoseLargeRadius  =  0.6;
#declare CNoseSmallRadius  =  0.2;

// Scaffolding parameters

#declare ScfBarDiameter    =  0.5;
#declare ScfBoardWidth     =  1.75;
#declare ScfBoardHeight    =  0.75;

// Calculated large snowman parameters

#declare LSMBottomRadius   = LSMBottomDiameter / 2;
#declare LSMMiddleRadius   = LSMMiddleDiameter / 2;
#declare LSMHeadRadius     = LSMHeadDiameter   / 2;
#declare LSMBottomCenterY  = LSMBottomRadius;
#declare LSMMiddleCenterY  = LSMBottomDiameter + LSMMiddleRadius - LSMLowerOverlap;
#declare LSMHeadCenterY    = LSMMiddleCenterY + LSMMiddleRadius + LSMHeadOverBody + LSMHeadRadius;

// Calculated small snowman parameters

#declare SSMBottomDiameter = LSMBottomDiameter / SSMScaleFactor;
#declare SSMMiddleDiameter = LSMMiddleDiameter / SSMScaleFactor;
#declare SSMHeadDiameter   = LSMHeadDiameter   / SSMScaleFactor;
#declare SSMLowerOverlap   = LSMLowerOverlap   / SSMScaleFactor;
#declare SSMUpperOverlap   = LSMUpperOverlap   / SSMScaleFactor;
#declare SSMBottomRadius   = SSMBottomDiameter / 2;
#declare SSMMiddleRadius   = SSMMiddleDiameter / 2;
#declare SSMHeadRadius     = SSMHeadDiameter   / 2;
#declare SSMSitDepth       = SSMBottomDiameter / 5;

// Calculated nose carrot parameters

#declare CNoseSegments     = floor(CNoseLength / CNoseSegmentSize);
#declare CNoseSegmentStep  = (CNoseLargeRadius - CNoseSmallRadius) / (CNoseSegments - 1);

// Calculated scaffolding parameters

#declare ScfBarRadius      = ScfBarDiameter / 2;

// Calculated view parameters

#if (View = 2)
  #declare CameraLoc       = < 18, LSMBottomDiameter * 1.2,  -40 >;
  #declare CameraLook      = < 15,                      40,    0 >;
#else
  #if (View = 3)
    #declare CameraLoc     = < 45,                      20,  -30 >;
    #declare CameraLook    = < 55,                      40,    0 >;
  #else
    #declare CameraLoc     = < 36, LSMBottomDiameter * 1.2, -120 >;
    #declare CameraLook    = < 15,                      40,    0 >;
  #end
#end
