////////////////////////////////////////////////////////////////////////////////
//
// SBTextures.inc -- Texture definitions for SnoBuild.pov (IRTC 3-4/2003)
//                   by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

// Define texture for all snow

#declare Tx_Snow =
  texture {
    pigment {
      color rgb < 1, 1, 1 >
    }
    normal {
      granite   0.15
      scale    50
      accuracy  0.02
    }
  }

// Define texture for the crane cable

#declare Tx_Cable =
  texture {
    pigment {
      color rgb < 0.5, 0.45, 0.35 >
    }
    finish {
      ambient    0.03
      diffuse    1
      reflection 0.4
      phong      1
      phong_size 3
    }
  }

// Define texture for the coal

#declare Tx_Coal =
  texture {
    pigment {
      color < 0.2, 0.2, 0.2 >
    }
    normal {
      granite
      scale   0.2
    }
  }

// Define texture for the nose carrots

#declare Tx_Carrot =
  texture {
    pigment {
      color rgb < 1, 0.35, 0 >
    }
  }

// Define texture for the metal parts of the scaffolding

#declare Tx_Scaffold_Metal =
  texture {
    pigment {
      color rgb < 0.5, 0.45, 0.35 >
    }
    finish {
      ambient    0.03
      diffuse    1
      reflection 0.4
      phong      1
      phong_size 3
    }
  }

// Define texture for the wood parts of the scaffolding

#declare Tx_Scaffold_Wood =
  texture {
    T_Wood7
    rotate 90 * y
  }

// Define texture for a hardhat

#declare Tx_Hat =
  texture {
    pigment {
      color rgb < 1, 0.9, 0 >
    }
    finish {
      specular  0.9
      roughness 0.005
    }
  }

// Define texture for the formal hat

#declare Tx_FormalHat =
  texture {
    pigment {
      color rgb < .2, .2, .2 >
    }
  }

// Define texture for the crane body

#declare Tx_CraneBody =
  texture {
    pigment {
      color rgb < 1, 0.8, 0 >
    }
    finish {
      specular  0.9
      roughness 0.001
    }
  }

// Define texture for the crane wheels and tracks

#declare Tx_Cat =
  texture {
    pigment {
      color rgb < 0.2, 0.2, 0.2 >
    }
  }

// Define texture for the crane controls

#declare Tx_Control =
  texture {
    pigment {
      color rgb < 0.5, 0.45, 0.35 >
    }
    finish {
      ambient    0.03
      diffuse    1
      reflection 0.4
      phong      1
      phong_size 3
    }
  }

// Define texture for the crane support shaft

#declare Tx_Shaft =
  texture {
    pigment {
      color rgb < 0.5, 0.45, 0.35 >
    }
    finish {
      ambient    0.03
      diffuse    1
      reflection 0.4
      phong      1
      phong_size 3
    }
  }
