////////////////////////////////////////////////////////////////////////////////
//
// SnoBuild.pov -- IRTC 3-4/2003
//                 by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

// Crank trace level up due to falling snow

global_settings {
  max_trace_level 40
}

// Include system files

#include "colors.inc"
#include "woods.inc"

// Include pieces of this scene

#include "Params.inc"
#include "SBTextures.inc"
#include "Scaffold.inc"
#include "Snowfall.inc"
#include "GroundSnow.inc"
#include "Carrot.inc"
#include "Arms.inc"
#include "Crane.inc"
#include "Coal.inc"
#include "LSnowman.inc"
#include "Hat.inc"
#include "SSnowman.inc"

// Initialize random number stream

#declare RS = seed(0);

// Define a function to return variance scale amounts

#macro RVar(a)
  (1 + ((rand(RS) * a) - (a / 2)) / 100)
#end

// Add a bit of ambient light

#default {
  texture {
    finish {
      ambient 0.2
    }
  }
}
  
// Place the camera

camera {
  location CameraLoc
  look_at  CameraLook
  up       <  0,  1, 0 >
  right    < 4/3, 0, 0 >
}

// Light source

light_source {
  < 50, 64, -100 >
  color rgb < 1, .97, .9 >
}

//light_source {
//  < 30, 12, -50 >
//  color rgb < 1, .9, .7 >
//}

//light_source {
//  < -35, LSMBottomDiameter + 2, -(LSMBottomRadius + 3.25 + 2) >
//  color rgb < 1, .9, .7 >
//}


#if (ShowLargeSnowman = 1)
  object { LargeSnowman }
#end

#if (ShowScaffolds = 1)
  object { //front
    Scaffold(LSMBottomDiameter, 6.5, LSMBottomDiameter, 4, 3, 2)
    translate < -LSMBottomRadius, 0, -(LSMBottomRadius + 6.5 + 2) >
  }
  object { //back
    Scaffold(LSMBottomDiameter, 6.5, LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, 4, 6, 2)
    translate < -LSMBottomRadius, 0, LSMBottomRadius + 2 >
  }
  object { //left
    Scaffold(LSMBottomDiameter, 6.5, LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, 4, 6, 2)
    rotate < 0, -90, 0 >
    translate < -(LSMBottomRadius + 2), 0, -LSMBottomRadius >
  }
  object { //right
    Scaffold(LSMBottomDiameter, 6.5, LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, 4, 6, 2)
    rotate < 0, -90, 0 >
    translate < LSMBottomRadius + 2, 0, -LSMBottomRadius >
  }
#end

#if (ShowGroundSnow = 1)
  object { GroundSnow() }
#end

#if (ShowFallingSnow = 1)
  object { Snowfall(-100, 100, 11, 0.85, 0.05, 0.82, 0.05, 5) }
#end

#if (ShowTree = 1)
  #include "txttree.inc"
  #declare txtTree = texture { txtTree_3 }
  object {
    #include "pdtree1.inc"
    scale 5
    translate < -180, 0, 400 >
  }
#end

#if (ShowCrane = 1)
  object {
    Crane(< 50, 9.5, 0 >, < 0, LSMHeadCenterY + LSMHeadRadius * 2, 0 >)
  }
#end

cylinder {
  < 0, LSMHeadCenterY + LSMHeadRadius * 2 + 4, 0 >,
  < 0, LSMHeadCenterY + LSMHeadRadius, 0 >,
  .2
  texture { Tx_Cable }
}

torus {
  LSMHeadRadius + .2,
  .2
  rotate < 90, 0, 0 >
  rotate < 0, 45, 0 >
  translate < 0, LSMHeadCenterY, 0 >
  texture { Tx_Cable }
}

torus {
  LSMHeadRadius + .2,
  .2
  rotate < 90, 0, 0 >
  rotate < 0, -45, 0 >
  translate < 0, LSMHeadCenterY, 0 >
  texture { Tx_Cable }
}

// front scaffold, left
object {
  SSM(30, 0, 45)
  rotate 180*y
  translate < 0, LSMBottomDiameter, -(LSMBottomRadius + 3.25 + 2) >
}

// front scaffold, right
object {
  SSM(-20, -30, 0)
  translate < 10, LSMBottomDiameter, -(LSMBottomRadius + 3.25 + 2) >
}

// back scaffold, left
object {
  SSM(45, 60, 60)
  translate < -LSMBottomRadius / 2, LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, LSMBottomRadius + 3.25 + 2 >
}

// back scaffold, right
object {
  SSM(50, 45, 65)
  translate < 0, LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, LSMBottomRadius + 3.25 + 2 >
}

// left scaffold, front
object {
  SSM(45, 60, 65)
  rotate -90*y
  translate < -(LSMBottomRadius + 6.5 + 2), LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, -5 >
}

// left scaffold, back
object {
  SSM(55, 40, 70)
  rotate -90*y
  translate < -(LSMBottomRadius + 6.5 + 2), LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, 2 >
}

// right scaffold, front
object {
  SSM(0, 0, 45)
  rotate 90*y
  translate < LSMBottomRadius - 2, LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, -3 >
}

// right scaffold, back
object {
  SSM(55, 60, 60)
  rotate 90*y
  translate < LSMBottomRadius - 2, LSMBottomDiameter + LSMMiddleDiameter - LSMLowerOverlap, 3 >
}

object { //cluster of 3 left
  SSM(0, 0, 0)
  rotate -90*y
  translate < 35, 7, -35 >
}

object { //cluster of 3 right
  SSM(10, -20, -30)
  rotate 45*y
  translate < 45, 9, -33 >
}

object { //cluster of 3 center
  SSM(5, 0, 0)
  rotate 180*y
  translate < 40, 7, -40 >
}

object { //left looking up
  SSM(70, 0, 0)
  rotate -120*y
  translate < -30, 10, -20 >
}

object { //back
  SSM(10, 0, 0)
  rotate 10*y
  translate < 35, 1, 40 >
}

object { //front
  SSM(20, 0, 0)
  rotate -60*y
  translate < -10, 8, -50 >
}
