#include "textures.inc"
#include "metals.inc"
//The moon
#include "stars.pov"
sphere
{
   0,25
   texture
     {
        
     pigment
     {
        bozo
        turbulence 2
          octaves 7
        color_map
          {
             [0.0 rgb .3]
             [1.0 rgb 1.1]
          }
        
   
     }
        
        normal
          {
             crackle 1
             scale <.001,2,.001>
          }
        
        finish
          {
             ambient 1.0
             diffuse 0.0
          }
        scale 4
     }
   texture
     {
        pigment
          {
             bozo
             turbulence 4
             octaves 3
             color_map 
               {
                  [0.0 rgbt <0,0,0,.5>]
                  [1.0 rgbt <1,1,1,.5>]
               }
          }
        
        finish
          {
             ambient 1
             diffuse 0
          }
        scale 45
     }
   
             
   rotate <-20,40,0>
   scale 10
   translate <100,100,60>*40
}

   
     
global_settings
{
   assumed_gamma 2.2
     max_trace_level 20
/*
     radiosity
     {
        
   pretrace_start 0.08
           pretrace_end   0.04
           count 35
     
           nearest_count 5
           error_bound 1.8
           recursion_limit 3
          media true
           low_error_factor 0.5
           gray_threshold 0.0
           minimum_reuse 0.015
           brightness 1
     
           adc_bailout 0.0001
     }
 */
     
     
     
     }


default
{
   finish
     {
	ambient 0
     }
}

#declare M_Haze = material
{
      
         texture{
           pigment{ color rgbt <1.0, 1.0, 1.0, 1.0> }
         }
         interior{
           ior 1.0003
           media{  // Atmospheric
             
             intervals 2
             confidence 0.0001
             variance 1.0/1.0
             ratio 0.5


             scattering{
               3 ,  rgb .004 // henyey greenstein scattering
             
                  extinction .2
             }
              
                     
                  samples 50,100
             
            
           }
         }
}

/*
light_source
{
   <-150000,150000,0000>,1
}
*/
#declare r1 = seed(345345);
#declare h = 180;
#declare rot = 0;
#while (rot < 360) 
light_source
{
   vrotate(<-50,0,-50>,<0,rot,0>), 1.3
   spotlight
   point_at <-5 + (rand(r1) * 10),h,-5 + (rand(r1) * 10)>
     radius 4
     falloff 5
     tightness .5
   
       fade_distance 5
     media_attenuation on
}
#declare old = h;
#if (old = 130)
#declare h = 180;
#end
#if (old = 180)
#declare h = 130;
#end
#declare rot = rot + 15;
#end
#declare rot = 0;
#while (rot < 360)
light_source
{
   
   vrotate(<-35,0,-35>,<0,rot,0>), 1.3
     spotlight
     point_at <0,500,0>
     radius 3
     falloff 10
     tightness .1
     
            fade_distance 5
          media_attenuation on
}

#declare rot = rot + 45;
#end

light_source
{
   <-155,10,-155>,1
   spotlight
   radius 12
     falloff 60
     point_at <-145,0,-145>
   fade_distance 1
   media_attenuation off
}



camera
{
   location <-150,4.5,-150>*1.015
     look_at <0,100,0>
     up y * 1
     right x * 1/1.5

     
}
union
{
   #include "plaque.pov"
   translate <0,5,0>
   rotate <0,45,0>
   translate <-145,0,-145>
}

/*
camera
{
   location <-400,100,0>
   look_at y*100
   up y
   right .5*x
}
*/

union
{
   
#include "bricks.pov"
rotate <0,50,0>
bounded_by
     {
	cylinder
	  {
	     <0,0,0>,<0,250,0>,28
	  }
	
     }
   
}

#include "top.pov"

cylinder
{
   <0,0,0>,<0,180,0>,1
     texture
     {
	T_Chrome_2A
     }

}

#declare they = 0;
#declare rot = 0;
#declare topd = 15;
#declare botd = 20;
#declare last = 0;
#declare l2 = 0;
#while (they <= 180)
#declare d = (they / 180);
#declare d = (botd * (1 - d)) + (topd * d);
#declare r1 = seed(4545);
union
{

   box
     {
	<1,0,0>,<6.5,.05,1>

	  rotate <0,rot,0>
	  translate <0,they,0>
     }

   cylinder
     {
	
	vrotate(<6.5,they+3,0>,<0,rot,0>), vrotate(<6.5,they+8/12+3, 0>,<0,rot + 10,0>), .15
     }
   
   cylinder
     {
	vrotate(<6.5,they,0>,<0,rot,0>), vrotate(<6.5,they+3, 0>,<0,rot,0>), .15
     }
 

   texture
     {
	T_Chrome_2A
     }

}

#declare rot = rot + 10;
#declare they = they + 8/12;
#declare l2 = l2 + 8/12;
#if (l2 > 15)
# declare l2 = 0;
difference
{
   cylinder
     {
	<0,they,0>,<0,they-1,0>,d-1
     }

   cylinder
     {
	<0,they+1,0>,<0,they-1.5,0>,d-2
     }
   pigment {rgb .5}
}

#end
#end



#declare clouds = plane
{
   y,500
     texture
     {
	
   pigment
     {
	bozo
	turbulence 2
	color_map
	  {
	     [0.0 rgb 0]
	     [1.0 rgb 0]
	  }
     }
	finish
	  {
	     ambient 1
         diffuse 0
	  }
	scale 10000
     }
   hollow
no_shadow
 
}
plane
{
   y,0
   pigment
     {
	rgb <0,.5,0>
     }
   hollow
}

/*
object
{
  clouds
     }
*/






union
{
   

#include "modern.pov"
  

translate <0,0,100>   
}


cone
{
   <0,0,0>,300,<0,5000,0>,300
   material
     {
        M_Haze
     }
   hollow
}

   


