// Persistence of Vision Ray Tracer Scene Description File
// File: triangle.pov
// Vers: 3.5
// Desc: the impossible triangle
// Date: 28.12.2001, revised: 27.04.2003
// Auth: M .Schneider

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
#include "metals.inc"
#include "logo.inc"

#version 3.5;

// command line settings: very high quality; low quality, no normals, no shadows
// +a0.1 +am2
// +q2


// comment the following lines out to show the construction
//#declare ShowConstruction = true;
#declare Orthographic = true;

#declare LSizeX = 2.0;
#declare LSizeZ = 2.0;
#declare LRes = 8;
#declare AreaLightsOn = true; 

// textures --------------------------------------------------------------
  
#declare grain =
function{
  pigment{
    granite
    scale 0.3
    turbulence 0.5
    }
  }
  
#declare Stone_T =
texture{
  pigment{color White*0.9}
  normal{function{grain(x*15, y*15, z*15).gray}}    
  finish{
  	ambient 0.0 
  	diffuse 0.8
  	}
  }  

#declare Reflect_T =
texture{
  pigment{color White*0.5}
  normal{function{grain(x*2, y*2, z*2).gray}}
  finish{
  	ambient 0.3 
  	diffuse 0.8
    brilliance 6 
    specular 0.9 
    roughness 0.004 
    metallic 
    conserve_energy 
    reflection{0.1, 0.5 fresnel on }
    }
  }
  
#declare Figure_T =
texture{
  agate
  texture_map{[0.0 Stone_T  ]
              [1.0 Reflect_T]}
  }  


#declare Plane_T =
texture{
   T_Chrome_4C
   normal{function{grain(x*0.1, y*50, z*50).gray*0.025 + grain(x*50, y*50, z*50).gray*0.01}}
}

// environment -----------------------------------------------------------

sphere{
  <0,0,0>, 300
  pigment{
    gradient y
    scale 300
    color_map{[0.0 color White              ]
              [1.0 color rgb <0.1, 0.0, 0.9>]}
    }
  finish{ambient 1.0}
  hollow on
  }

plane{
  y, 0
  texture{Plane_T}
  }

// light ----------------------------------------------------------------------
                
light_source{
  <-1.0, 15, -10>
  color rgb <1.0, 1.0, 1.0>*1.0
  #ifdef(AreaLightsOn)
    area_light 
    x*LSizeX, z*LSizeZ, LRes, LRes
    adaptive 1
    jitter
    circular
  #end  
  }

light_source{
  <4.0, 10, 0>
  color rgb <1.0, 1.0, 1.0>*0.5
  #ifdef(AreaLightsOn)
    area_light 
    x*LSizeX, z*LSizeZ, LRes, LRes
    adaptive 1
    jitter
    circular
  #end  
  }

    
// triangle --------------------------------------------------------------

#declare Qy = 1.0;
#declare Qx = 0.2;
#declare Qz = Qx;

#declare Qgd = (Qy-Qx)/(2.0*sqrt(2.0)); // Quadric grid distance
      
#declare Quadric =
box{
  <-(Qx/2.0), -(Qy/2.0), -(Qz/2.0)>
  < Qx/2.0,  Qy/2.0,  Qz/2.0>
  }


#declare Figure =
union{
  object{
    Quadric
    clipped_by{
      plane{
        y, 0.1*sqrt(2.0)
        rotate <45, 0, 0>
      }
    }
    #ifdef(ShowConstruction) pigment{color Red} #end
    rotate <0, 45, 0>
    translate <0, Qy/2.0, 0>
    }
    
  object{
  	Povray_Logo_Prism
  	#ifdef(ShowConstruction) 
  		pigment{color Blue} 
  	#else
  		texture{Plane_T}
  	#end
  	scale 0.1
  	rotate <0, -45, 0>
  	translate <0.07, 0.20, -0.07>
  	}

  object{
    Quadric
    clipped_by{
      plane{
        x, Qy/2.0-0.01
        rotate <0, 0, -90>
      }
    }
    #ifdef(ShowConstruction) pigment{color Blue} #end
    rotate <90, 45, 0>
    translate <Qgd, Qx/2.0, Qgd>
    }
    
  object{
    Quadric
    clipped_by{
      plane{
        x, Qy/2.0-0.01
        rotate <0, 0, -90>
      }
    }
    #ifdef(ShowConstruction) pigment{color Green} #end
    no_reflection
    no_shadow
    rotate <90, -45, 0>
    translate <Qgd, Qx/2.0, 3.0*Qgd>
    }  

  #ifdef(ShowConstruction) #else texture{Figure_T} #end
}  


#declare CameraBox =
union{
  box{
    <-0.02, -0.01, -0.01>
    < 0.02,  0.01,  0.01>
    }
  cone{
    <0.02, 0, 0>, 0.005
    <0.03, 0, 0>, 0.01
    open
    }
  pigment{color White}    
  }

// scenery ---------------------------------------------------------------

object{
  Figure
  translate <-0.3, 0, 0.7>
}
  
  
// camera ----------------------------------------------------------------

#declare V1 = <0, Qy, 0>;
#declare V2 = <0, Qx, (Qy-Qx)*sqrt(2.0)>;
#declare Vdir = vnormalize(V1-V2);
#declare zoom = 1.1;

#declare front = 
camera{
  #ifdef(Orthographic)
  	orthographic
  #else
  	perspective
  #end
  location V1+Vdir*zoom
  look_at V1
  }

#declare top =
camera{
  #ifdef(Orthographic)
  	orthographic
  #else
  	perspective
  #end
  location <-0.3, 1.8, 0.9,>
  look_at <-0.3, 0, 1.1>
  }

#declare left =
camera{
  #ifdef(Orthographic)
  	orthographic
  #else
  	perspective
  #end
  location <-2.0, 1.0, 1.0>
  look_at <0, 0.75, 1.0>
  }


object{
  CameraBox
  rotate <0,-90,0>
  rotate <30, 0, 0>
  translate V1+Vdir*zoom  
  }

#declare fromRight =
camera{
  #ifdef(Orthographic)
  	orthographic
  #else
  	perspective
  #end
  location V1+Vdir*zoom + <0.05, 0.03, -0.05>
  look_at V1
  }
                    
camera{ front }                    
//camera{ fromRight }
