// Greek style column
global_settings {
  assumed_gamma 1.0
  ambient_light rgb 1.0
}

#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"
#include "metals.inc"
#include "woods.inc"

camera {
  //location <1,4,-10>  // normal
  //location <5,50,-10> //overview
  //look_at <0,4,0>
  location <1,4,-14>
  look_at <0,4,0>
}

light_source { <25,100,-10> color rgb 1 jitter }
light_source { <25,100,-10> color rgb 0.1 shadowless }

#include "cloud.inc"
sky_sphere { pigment { SummerSky } }

//Floor
cylinder { <0,1,0> <0,0,0>, 25 texture { checker texture { T_Stone17 }, texture { T_Stone6 } } } //texture { T_Stone17 }
/*box { <25, 1, 25>, <-25, 0, -25>
texture { checker texture { T_Stone17 }, texture { T_Stone6 } scale 1}
pigment { checker White, Black scale 1}
finish {
  diffuse .4
  ambient .2
  phong 1
  phong_size 100
  reflection .25
}*/
plane {
   y, 0
   pigment {color <0,0,0>}
   normal {bumps 0.03 scale 0.05}
   finish {reflection 0.7}
}

#declare column_top = 6;
#declare column_bottom = 1;
#declare flame = Yellow * 0.75;
#include "greek.inc"

//center columns
merge {
  object { short_column translate <2,0,2> }
  object { short_column translate <-2,0,2> }
  object { short_column translate <2,0,-2> }
  object { short_column translate <-2,0,-2> }
  //pigment { LightGrey }
  texture { T_Stone15 }
}

//more columns
merge {
  object { column translate <10,0,10> }
  object { column translate <10,0,6> }
  object { column translate <10,0,2> }
  object { column translate <6,0,10> }
  object { column translate <6,0,6> }
  object { column translate <6,0,2> }
  object { column translate <2,0,10> }
  object { column translate <2,0,6> }
  object { column translate <-10,0,10> }
  object { column translate <-10,0,6> }
  object { column translate <-10,0,2> }
  object { column translate <-6,0,10> }
  object { column translate <-6,0,6> }
  object { column translate <-6,0,2> }
  object { column translate <-2,0,10> }
  object { column translate <-2,0,6> }
  object { column translate <10,0,-10> }
  object { column translate <10,0,-6> }
  object { column translate <10,0,-2> }
  object { column translate <6,0,-10> }
  object { column translate <6,0,-6> }
  object { column translate <6,0,-2> }
  object { column translate <2,0,-10> }
  object { column translate <2,0,-6> }
  object { column translate <-10,0,-10> }
  object { column translate <-10,0,-6> }
  object { column translate <-10,0,-2> }
  object { column translate <-6,0,-10> }
  object { column translate <-6,0,-6> }
  object { column translate <-6,0,-2> }
  object { column translate <-2,0,-10> }
  object { column translate <-2,0,-6> }
  //pigment { White }
  texture { T_Stone15 }
}

//roof
merge {
  object { dome translate <8,column_top,8> }
  object { span translate <8,column_top,4> }
  object { span translate <8,column_top,0> }
  object { span translate <8,column_top,-4> }
  object { dome translate <8,column_top,-8> }
  object { span translate <4,column_top,8> }
  object { span translate <4,column_top,0> }
  object { span translate <4,column_top,-8> }
  object { span translate <0,column_top,8> }
  object { span translate <0,column_top,4> }
  object { dome translate <0,column_top,0> }
  object { span translate <0,column_top,-4> }
  object { span translate <0,column_top,-8> }
  object { span translate <-4,column_top,8> }
  object { span translate <-4,column_top,0> }
  object { span translate <-4,column_top,-8> }
  object { dome translate <-8,column_top,8> }
  object { span translate <-8,column_top,4> }
  object { span translate <-8,column_top,0> }
  object { span translate <-8,column_top,-4> }
  object { dome translate <-8,column_top,-8> }
  //pigment { Red }
  texture { T_Stone21 }
}

//base
difference {
  merge {
    cylinder { <0,2.2,0> <0,2,0>, 1.5 texture { T_Grnt9 } }
    cylinder { <0,2,0> <0,1.8,0>, 4 }
    cylinder { <0,1.8,0> <0,1.6,0>, 4.25 }
    cylinder { <0,1.6,0> <0,1.4,0>, 4.5 }
    cylinder { <0,1.4,0> <0,1.2,0>, 4.75 }
    cylinder { <0,1.2,0> <0,1,0>, 5 }
  }
  cylinder { <0,2.3,0> <0,1.1,0>, 1.3 texture { T_Grnt9 } }
  //pigment { Cyan }
  texture { T_Stone18 } //T_Grnt9
}

//water
cylinder { <0,2.1,0> <0,1.1,0>, 1.3
   material{
     texture {
       pigment { rgbf <1,1,1,1> }
       normal{ ripples 0.3 scale 0.25 turbulence 0.5 } //bozo
       finish {
         ambient 0
         diffuse 0.1
         reflection { 0.04, 1 }
         specular 1.5
         roughness 0.001
         brilliance 0.01
         conserve_energy
       }
     }
     interior { ior 1.33 }
   }
  /*texture {
    pigment { Sapphire_Agate }
    finish { ambient 0.45 diffuse 0.55 reflection 0.3 }
    normal { ripples 0.3 scale 0.25 turbulence 0.5 }
  }
  interior { ior 1.33 }*/
}

//hedge
difference {
  //box { <25, 2, 25>, <-25, 1, -25> }
  //box { <23, 3, 23>, <-23, 0, -23> }
  cylinder { <0,2,0> <0,1,0>, 25 }
  cylinder { <0,3,0> <0,0,0>, 23 }
  normal { crackle 0.7 metric 2 scale 0.1 }
  pigment { Green }
}

//trees
/*
#include "BIRCH.inc"
#include "TOMTREE.inc"
#declare planter = difference {
  cylinder { <0,0.2,0> <0,0,0>, 1 texture { T_Wood29 } }
  cylinder { <0,0.3,0> <0,0.1,0>, 0.8 texture { Brown_Agate } }
}
object { planter translate <4,1,12> }
object { TREE scale 5 translate <4,1,12> rotate <0, 0, 0> }
object { planter translate <-4,1,12> }
object { TREE scale 5 translate <-4,1,12> rotate <0, 0, 0> }
*/

//lights
light_source { <8,column_top + 1.35,8> flame / 10 looks_like { object { lamp } } }
light_source { <8,column_top + 0.75,0> flame / 10 looks_like { object { lamp } } }
light_source { <8,column_top + 0.75,-8> flame / 10 looks_like { object { lamp } } }
light_source { <0,column_top + 0.75,8> flame / 10 looks_like { object { lamp } } }
light_source { <0,column_top + 0.75,0> flame / 10 looks_like { object { lamp } } }
light_source { <0,column_top + 0.75,-8> flame / 10 looks_like { object { lamp } } }
light_source { <-8,column_top + 0.75,8> flame / 10 looks_like { object { lamp } } }
light_source { <-8,column_top + 0.75,0> flame / 10 looks_like { object { lamp } } }
light_source { <-8,column_top + 0.75,-8> flame / 10 looks_like { object { lamp } } }

//geodesic dome
#include "2geo08.inc"
#declare FaceTexture = texture {
  pigment { Turquoise filter 0.95 }
  finish {
    specular 1
    roughness 0.00005
    ambient 0.3
    diffuse 0.7
    crand 0.005
    reflection 0.15
  }
}

declare Geo = merge {
  object { DomeEdges no_shadow texture { T_Silver_1A } }
  object { DomePoints no_shadow texture { T_Silver_1A } }
  object { DomeFaces no_shadow texture { FaceTexture } }
}

object { Geo scale 25 rotate <0, 90, 0> }

//hills based on sample slopemt.pov
#declare Sand_Texture = texture { pigment {color <0.9,0.8,0.5>} }
#declare Vege_Texture = texture { pigment {color <0.1,0.6,0.1>} }
#declare Soil_Texture = texture { pigment {color <0.7,0.6,0.5>} }
#declare Rock_Texture = texture { pigment {color <0.6,0.6,0.6>} }
#declare Snow_Texture = texture { pigment {color rgb 1.0} finish {ambient 0.1 diffuse 0.8} }
#declare Vege2Rock_Texture = texture {
  slope {
    -y*3, 0, 0.5
    altitude y, 0.005, 0.400
  } 
  texture_map {
    [0.45, Vege_Texture]
    [0.55, Soil_Texture]
    [0.65, Soil_Texture]
    [0.65, Rock_Texture]
  }
}
#declare Rock2Snow_Texture = texture {
  slope {
    -y*2, 0, 0.5
    altitude y, 1.0, 0.4
  }
  texture_map {
    [0.75, Snow_Texture]
    [0.75, Rock_Texture]
  }
}
#declare island = height_field {
  "island.bmp"
  smooth
  scale <80,12,80>
  translate <-40,-2,-40> 
  texture {
    gradient y
    scale 10
    texture_map {
      [0.000, Sand_Texture]
      [0.005, Sand_Texture]
      [0.005, Vege2Rock_Texture]
      [0.400, Vege2Rock_Texture]
      [0.400, Rock2Snow_Texture]
      [1.000, Rock2Snow_Texture]
    }
  }
}

object { island translate <0,0,50> }
//object { island translate <0,0,-50> }
//object { island translate <50,0,0> }
//object { island translate <-50,0,0> }
//object { island translate <50,0,50> }
//object { island translate <50,0,-50> }
//object { island translate <-50,0,50> }
//object { island translate <-50,0,-50> }

//looking in
/*#include"bucky03.inc"
merge {
  object { DomeEdges no_shadow texture { T_Silver_1A } }
  object { DomePoints no_shadow texture { T_Silver_1A } }
  translate <0,4,0>  
}*/

//orientation
/*merge {
  sphere { <0, 2, 0>, 0.5 pigment { White } }
  cylinder { <0,2,0> <1,2,0>, 0.1 pigment { Red } }    // X
  cylinder { <0,2,0> <0,3,0>, 0.1 pigment { Blue } }   // Y
  cylinder { <0,2,0> <0,2,1>, 0.1 pigment { Yellow } } // Z
}*/
