// Persistence of Vision Ray Tracer Include File
// File: books.inc
// Vers: 3.5
// Desc: include file for faith.pov
// Date: 22/6/2003
// Auth: Paolo Brasolin

#include "metals.inc"

#declare cover_1 = texture { material_map { gif "3rdreich.gif" texture { pigment { agate color_map { [ 0 rgb <0.6,0.6,0> ] [ 0.1 rgb <0.3,0.3,0> ] [ 1 rgb <0.3,0.3,0> ] } } normal { agate, 0.2 } scale <1/32,1/4.25,1> } texture { T_Gold_5A } } rotate y*-90 scale <1,4.25,32> translate z*16 }
#declare cover_2 = texture { material_map { gif "dossier.gif" texture { T_Gold_3A } texture { pigment { agate color_map { [ 0 rgb <0,0.6,0.6> ] [ 0.1 rgb <0,0.3,0.3> ] [ 1 rgb <0,0.3,0.3> ] } } normal { agate, 0.2 } scale <1/32,1/2,1> } } rotate y*-90 scale <1,2,32> translate <0,4.25,16> }
#declare cover_3 = texture { material_map { gif "voodoo.gif" texture { pigment { agate color_map { [ 0 rgb <0.6,0,0.6> ] [ 0.1 rgb <0.3,0,0.3> ] [ 1 rgb <0.3,0,0.3> ] } } normal { agate, 0.2 } scale <1/32,1/3,1> } texture { T_Gold_1A } } rotate y*-90 scale <1,3,32> translate <0,6.25,16> }
#declare pages = texture { pigment { gradient y color_map { [ 0 rgb <0.5, 0.5, 0.5> ] [ 0.5 rgb <1, 1, 1> ] [ 1 rgb <0.5, 0.5, 0.5> ] } } scale  <1, 0.1, 1> }

#declare books_pile = union {
  //book_1
  union {
    //patch_cover_1
    union{
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 0.250, -16.000> <-4.458, 0.250, -16.000> <3.942, 0.269, -16.000> <10.242, 0.250, -16.000> <-10.758, 0.249, -16.075> <-4.458, 0.249, -16.075> <3.942, 0.269, -16.075> <10.242, 0.249, -16.075> <-10.833, 0.001, -16.000> <-4.534, -0.074, -16.000> <3.942, -0.001, -16.075> <10.242, 0.001, -16.075> <-10.758, 0.000, -16.000> <-4.459, -0.075, -16.000> <3.942, -0.002, -16.000> <10.242, 0.000, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 0.250, -16.000> <10.274, 0.250, -16.000> <10.323, 0.153, -16.000> <10.327, 0.185, -16.000> <10.242, 0.249, -16.075> <10.274, 0.249, -16.075> <10.323, 0.153, -16.075> <10.328, 0.185, -16.075> <10.242, 0.001, -16.075> <10.319, 0.001, -16.075> <10.482, -0.070, -16.075> <10.501, 0.006, -16.075> <10.242, 0.000, -16.000> <10.319, 0.000, -16.000> <10.482, -0.070, -16.000> <10.501, 0.005, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.327, 0.185, -16.000> <10.410, 0.754, -16.000> <10.509, 1.518, -16.000> <10.508, 2.093, -16.000> <10.328, 0.185, -16.075> <10.410, 0.754, -16.075> <10.510, 1.518, -16.075> <10.509, 2.093, -16.075> <10.501, 0.006, -16.075> <10.652, 0.619, -16.075> <10.760, 1.462, -16.075> <10.758, 2.093, -16.075> <10.501, 0.005, -16.000> <10.652, 0.618, -16.000> <10.761, 1.462, -16.000> <10.758, 2.093, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.508, 2.093, -16.000> <10.508, 2.686, -16.000> <10.404, 3.474, -16.000> <10.322, 4.061, -16.000> <10.509, 2.093, -16.075> <10.508, 2.686, -16.075> <10.405, 3.474, -16.075> <10.323, 4.062, -16.075> <10.758, 2.093, -16.075> <10.755, 2.746, -16.075> <10.635, 3.617, -16.075> <10.483, 4.252, -16.075> <10.758, 2.093, -16.000> <10.756, 2.746, -16.000> <10.635, 3.618, -16.000> <10.483, 4.253, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.322, 4.061, -16.000> <10.318, 4.091, -16.000> <10.272, 4.000, -16.000> <10.242, 4.000, -16.000> <10.323, 4.062, -16.075> <10.318, 4.092, -16.075> <10.272, 4.001, -16.075> <10.242, 4.001, -16.075> <10.483, 4.252, -16.075> <10.466, 4.323, -16.075> <10.314, 4.249, -16.075> <10.242, 4.249, -16.075> <10.483, 4.253, -16.000> <10.466, 4.323, -16.000> <10.314, 4.250, -16.000> <10.242, 4.250, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 4.000, -16.000> <3.942, 3.982, -16.000> <-4.458, 4.000, -16.000> <-10.758, 4.000, -16.000> <10.242, 3.925, -6.400> <3.942, 3.907, -6.400> <-4.458, 3.925, -6.400> <-10.758, 3.925, -6.400> <10.242, 3.925, 6.400> <3.942, 3.907, 6.400> <-4.458, 3.925, 6.400> <-10.758, 3.925, 6.400> <10.242, 4.000, 16.000> <3.942, 3.982, 16.000> <-4.458, 4.000, 16.000> <-10.758, 4.000, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 4.000, -16.000> <3.942, 3.982, -16.000> <-4.458, 4.000, -16.000> <-10.758, 4.000, -16.000> <10.242, 4.001, -16.075> <3.942, 3.982, -16.075> <-4.458, 4.001, -16.075> <-10.758, 4.001, -16.075> <10.242, 4.249, -16.075> <3.942, 4.249, -16.075> <-4.534, 4.324, -16.000> <-10.833, 4.249, -16.000> <10.242, 4.250, -16.000> <3.942, 4.249, -16.000> <-4.459, 4.325, -16.000> <-10.758, 4.250, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 0.250, 16.000> <-4.458, 0.250, 16.000> <3.942, 0.269, 16.000> <10.242, 0.250, 16.000> <-10.758, 0.325, 6.400> <-4.458, 0.325, 6.400> <3.942, 0.344, 6.400> <10.242, 0.325, 6.400> <-10.758, 0.325, -6.400> <-4.458, 0.325, -6.400> <3.942, 0.344, -6.400> <10.242, 0.325, -6.400> <-10.758, 0.250, -16.000> <-4.458, 0.250, -16.000> <3.942, 0.269, -16.000> <10.242, 0.250, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 0.250, 16.000> <10.274, 0.250, 16.000> <10.323, 0.153, 16.000> <10.327, 0.185, 16.000> <10.242, 0.325, 6.400> <10.274, 0.325, 6.400> <10.271, 0.207, 6.400> <10.275, 0.239, 6.400> <10.242, 0.325, -6.400> <10.274, 0.325, -6.400> <10.271, 0.207, -6.400> <10.275, 0.239, -6.400> <10.242, 0.250, -16.000> <10.274, 0.250, -16.000> <10.323, 0.153, -16.000> <10.327, 0.185, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.327, 0.185, 16.000> <10.410, 0.754, 16.000> <10.509, 1.518, 16.000> <10.508, 2.093, 16.000> <10.275, 0.239, 6.400> <10.358, 0.808, 6.400> <10.434, 1.518, 6.400> <10.433, 2.093, 6.400> <10.275, 0.239, -6.400> <10.358, 0.808, -6.400> <10.434, 1.518, -6.400> <10.433, 2.093, -6.400> <10.327, 0.185, -16.000> <10.410, 0.754, -16.000> <10.509, 1.518, -16.000> <10.508, 2.093, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.508, 2.093, 16.000> <10.508, 2.686, 16.000> <10.404, 3.474, 16.000> <10.322, 4.061, 16.000> <10.433, 2.093, 6.400> <10.433, 2.686, 6.400> <10.356, 3.417, 6.400> <10.274, 4.004, 6.400> <10.433, 2.093, -6.400> <10.433, 2.686, -6.400> <10.356, 3.417, -6.400> <10.274, 4.004, -6.400> <10.508, 2.093, -16.000> <10.508, 2.686, -16.000> <10.404, 3.474, -16.000> <10.322, 4.061, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.322, 4.061, 16.000> <10.318, 4.091, 16.000> <10.272, 4.000, 16.000> <10.242, 4.000, 16.000> <10.274, 4.004, 6.400> <10.270, 4.034, 6.400> <10.272, 3.925, 6.400> <10.242, 3.925, 6.400> <10.274, 4.004, -6.400> <10.270, 4.034, -6.400> <10.272, 3.925, -6.400> <10.242, 3.925, -6.400> <10.322, 4.061, -16.000> <10.318, 4.091, -16.000> <10.272, 4.000, -16.000> <10.242, 4.000, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 4.000, 16.000> <3.942, 3.982, 16.000> <-4.458, 4.000, 16.000> <-10.758, 4.000, 16.000> <10.242, 4.001, 16.075> <3.942, 3.982, 16.075> <-4.458, 4.001, 16.075> <-10.758, 4.001, 16.075> <10.242, 4.249, 16.075> <3.942, 4.249, 16.075> <-4.534, 4.324, 16.000> <-10.833, 4.249, 16.000> <10.242, 4.250, 16.000> <3.942, 4.249, 16.000> <-4.459, 4.325, 16.000> <-10.758, 4.250, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 0.000, 16.000> <-10.758, 0.000, 6.400> <-10.758, 0.000, -6.400> <-10.758, 0.000, -16.000> <-4.459, -0.075, 16.000> <-4.459, -0.075, 6.400> <-4.459, -0.075, -6.400> <-4.459, -0.075, -16.000> <3.942, -0.002, 16.000> <3.942, -0.077, 6.400> <3.942, -0.077, -6.400> <3.942, -0.002, -16.000> <10.242, 0.000, 16.000> <10.242, -0.075, 6.400> <10.242, -0.075, -6.400> <10.242, 0.000, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 0.000, 16.000> <-10.758, 0.000, 6.400> <-10.758, 0.000, -6.400> <-10.758, 0.000, -16.000> <-10.833, 0.001, 16.000> <-10.833, 0.001, 6.400> <-10.833, 0.001, -6.400> <-10.833, 0.001, -16.000> <-10.758, 0.249, 16.075> <-10.758, 0.324, 6.475> <-10.758, 0.324, -6.475> <-10.758, 0.249, -16.075> <-10.758, 0.250, 16.000> <-10.758, 0.325, 6.400> <-10.758, 0.325, -6.400> <-10.758, 0.250, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 4.000, 16.000> <-10.758, 3.925, 6.400> <-10.758, 3.925, -6.400> <-10.758, 4.000, -16.000> <-10.758, 4.001, 16.075> <-10.758, 3.926, 6.475> <-10.758, 3.926, -6.475> <-10.758, 4.001, -16.075> <-10.833, 4.249, 16.000> <-10.833, 4.249, 6.400> <-10.833, 4.249, -6.400> <-10.833, 4.249, -16.000> <-10.758, 4.250, 16.000> <-10.758, 4.250, 6.400> <-10.758, 4.250, -6.400> <-10.758, 4.250, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 4.250, -16.000> <-4.459, 4.325, -16.000> <3.942, 4.249, -16.000> <10.242, 4.250, -16.000> <-10.758, 4.250, -6.400> <-4.459, 4.325, -6.400> <3.942, 4.324, -6.400> <10.242, 4.325, -6.400> <-10.758, 4.250, 6.400> <-4.459, 4.325, 6.400> <3.942, 4.324, 6.400> <10.242, 4.325, 6.400> <-10.758, 4.250, 16.000> <-4.459, 4.325, 16.000> <3.942, 4.249, 16.000> <10.242, 4.250, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 4.250, -16.000> <10.314, 4.250, -16.000> <10.466, 4.323, -16.000> <10.483, 4.253, -16.000> <10.242, 4.325, -6.400> <10.314, 4.325, -6.400> <10.514, 4.381, -6.400> <10.531, 4.310, -6.400> <10.242, 4.325, 6.400> <10.314, 4.325, 6.400> <10.514, 4.381, 6.400> <10.531, 4.310, 6.400> <10.242, 4.250, 16.000> <10.314, 4.250, 16.000> <10.466, 4.323, 16.000> <10.483, 4.253, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.483, 4.253, -16.000> <10.635, 3.618, -16.000> <10.756, 2.746, -16.000> <10.758, 2.093, -16.000> <10.531, 4.310, -6.400> <10.683, 3.675, -6.400> <10.831, 2.746, -6.400> <10.833, 2.093, -6.400> <10.531, 4.310, 6.400> <10.683, 3.675, 6.400> <10.831, 2.746, 6.400> <10.833, 2.093, 6.400> <10.483, 4.253, 16.000> <10.635, 3.618, 16.000> <10.756, 2.746, 16.000> <10.758, 2.093, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.758, 2.093, -16.000> <10.761, 1.462, -16.000> <10.652, 0.618, -16.000> <10.501, 0.005, -16.000> <10.833, 2.093, -6.400> <10.836, 1.462, -6.400> <10.704, 0.564, -6.400> <10.553, -0.049, -6.400> <10.833, 2.093, 6.400> <10.836, 1.462, 6.400> <10.704, 0.564, 6.400> <10.553, -0.049, 6.400> <10.758, 2.093, 16.000> <10.761, 1.462, 16.000> <10.652, 0.618, 16.000> <10.501, 0.005, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.501, 0.005, -16.000> <10.482, -0.070, -16.000> <10.319, 0.000, -16.000> <10.242, 0.000, -16.000> <10.553, -0.049, -6.400> <10.534, -0.124, -6.400> <10.319, -0.075, -6.400> <10.242, -0.075, -6.400> <10.553, -0.049, 6.400> <10.534, -0.124, 6.400> <10.319, -0.075, 6.400> <10.242, -0.075, 6.400> <10.501, 0.005, 16.000> <10.482, -0.070, 16.000> <10.319, 0.000, 16.000> <10.242, 0.000, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 0.000, 16.000> <-4.459, -0.075, 16.000> <3.942, -0.002, 16.000> <10.242, 0.000, 16.000> <-10.833, 0.001, 16.000> <-4.534, -0.074, 16.000> <3.942, -0.001, 16.075> <10.242, 0.001, 16.075> <-10.758, 0.249, 16.075> <-4.458, 0.249, 16.075> <3.942, 0.269, 16.075> <10.242, 0.249, 16.075> <-10.758, 0.250, 16.000> <-4.458, 0.250, 16.000> <3.942, 0.269, 16.000> <10.242, 0.250, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 0.000, 16.000> <10.319, 0.000, 16.000> <10.482, -0.070, 16.000> <10.501, 0.005, 16.000> <10.242, 0.001, 16.075> <10.319, 0.001, 16.075> <10.482, -0.070, 16.075> <10.501, 0.006, 16.075> <10.242, 0.249, 16.075> <10.274, 0.249, 16.075> <10.323, 0.153, 16.075> <10.328, 0.185, 16.075> <10.242, 0.250, 16.000> <10.274, 0.250, 16.000> <10.323, 0.153, 16.000> <10.327, 0.185, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.501, 0.005, 16.000> <10.652, 0.618, 16.000> <10.761, 1.462, 16.000> <10.758, 2.093, 16.000> <10.501, 0.006, 16.075> <10.652, 0.619, 16.075> <10.760, 1.462, 16.075> <10.758, 2.093, 16.075> <10.328, 0.185, 16.075> <10.410, 0.754, 16.075> <10.510, 1.518, 16.075> <10.509, 2.093, 16.075> <10.327, 0.185, 16.000> <10.410, 0.754, 16.000> <10.509, 1.518, 16.000> <10.508, 2.093, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.758, 2.093, 16.000> <10.756, 2.746, 16.000> <10.635, 3.618, 16.000> <10.483, 4.253, 16.000> <10.758, 2.093, 16.075> <10.755, 2.746, 16.075> <10.635, 3.617, 16.075> <10.483, 4.252, 16.075> <10.509, 2.093, 16.075> <10.508, 2.686, 16.075> <10.405, 3.474, 16.075> <10.323, 4.062, 16.075> <10.508, 2.093, 16.000> <10.508, 2.686, 16.000> <10.404, 3.474, 16.000> <10.322, 4.061, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.483, 4.253, 16.000> <10.466, 4.323, 16.000> <10.314, 4.250, 16.000> <10.242, 4.250, 16.000> <10.483, 4.252, 16.075> <10.466, 4.323, 16.075> <10.314, 4.249, 16.075> <10.242, 4.249, 16.075> <10.323, 4.062, 16.075> <10.318, 4.092, 16.075> <10.272, 4.001, 16.075> <10.242, 4.001, 16.075> <10.322, 4.061, 16.000> <10.318, 4.091, 16.000> <10.272, 4.000, 16.000> <10.242, 4.000, 16.000> }
      texture { cover_1 }
    }
    //patch_pages_1
    union{
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 2.091, 15.000> <-3.873, 2.091, 15.000> <4.047, 2.091, 15.000> <9.987, 2.091, 15.000> <-9.813, 1.536, 15.000> <-3.873, 1.536, 15.000> <4.047, 1.536, 15.000> <9.987, 1.536, 15.000> <-9.935, 0.802, 15.000> <-3.995, 0.802, 15.000> <3.925, 0.802, 15.000> <9.865, 0.802, 15.000> <-9.987, 0.250, 15.000> <-4.047, 0.250, 15.000> <3.873, 0.250, 15.000> <9.813, 0.250, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 2.091, 15.000> <9.987, 2.091, 6.000> <9.987, 2.091, -6.000> <9.987, 2.091, -15.000> <9.987, 1.536, 15.000> <9.987, 1.536, 6.000> <9.987, 1.536, -6.000> <9.987, 1.536, -15.000> <9.865, 0.802, 15.000> <9.865, 0.802, 6.000> <9.865, 0.802, -6.000> <9.865, 0.802, -15.000> <9.813, 0.250, 15.000> <9.813, 0.250, 6.000> <9.813, 0.250, -6.000> <9.813, 0.250, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 2.091, -15.000> <4.047, 2.091, -15.000> <-3.873, 2.091, -15.000> <-9.813, 2.091, -15.000> <9.987, 1.536, -15.000> <4.047, 1.536, -15.000> <-3.873, 1.536, -15.000> <-9.813, 1.536, -15.000> <9.865, 0.802, -15.000> <3.925, 0.802, -15.000> <-3.995, 0.802, -15.000> <-9.935, 0.802, -15.000> <9.813, 0.250, -15.000> <3.873, 0.250, -15.000> <-4.047, 0.250, -15.000> <-9.987, 0.250, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 2.091, -15.000> <-9.813, 2.091, -6.000> <-9.813, 2.091, 6.000> <-9.813, 2.091, 15.000> <-9.813, 1.536, -15.000> <-9.813, 1.536, -6.000> <-9.813, 1.536, 6.000> <-9.813, 1.536, 15.000> <-9.935, 0.802, -15.000> <-9.935, 0.802, -6.000> <-9.935, 0.802, 6.000> <-9.935, 0.802, 15.000> <-9.987, 0.250, -15.000> <-9.987, 0.250, -6.000> <-9.987, 0.250, 6.000> <-9.987, 0.250, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 2.091, 15.000> <-9.813, 2.666, 15.000> <-9.935, 3.427, 15.000> <-9.987, 4.000, 15.000> <-9.813, 2.091, 6.000> <-9.813, 2.666, 6.000> <-9.935, 3.427, 6.000> <-9.987, 4.000, 6.000> <-9.813, 2.091, -6.000> <-9.813, 2.666, -6.000> <-9.935, 3.427, -6.000> <-9.987, 4.000, -6.000> <-9.813, 2.091, -15.000> <-9.813, 2.666, -15.000> <-9.935, 3.427, -15.000> <-9.987, 4.000, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 2.091, 15.000> <9.987, 2.666, 15.000> <9.865, 3.427, 15.000> <9.813, 4.000, 15.000> <4.047, 2.091, 15.000> <4.047, 2.666, 15.000> <3.925, 3.427, 15.000> <3.873, 4.000, 15.000> <-3.873, 2.091, 15.000> <-3.873, 2.666, 15.000> <-3.995, 3.427, 15.000> <-4.047, 4.000, 15.000> <-9.813, 2.091, 15.000> <-9.813, 2.666, 15.000> <-9.935, 3.427, 15.000> <-9.987, 4.000, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 2.091, -15.000> <9.987, 2.666, -15.000> <9.865, 3.427, -15.000> <9.813, 4.000, -15.000> <9.987, 2.091, -6.000> <9.987, 2.666, -6.000> <9.865, 3.427, -6.000> <9.813, 4.000, -6.000> <9.987, 2.091, 6.000> <9.987, 2.666, 6.000> <9.865, 3.427, 6.000> <9.813, 4.000, 6.000> <9.987, 2.091, 15.000> <9.987, 2.666, 15.000> <9.865, 3.427, 15.000> <9.813, 4.000, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 2.091, -15.000> <-9.813, 2.666, -15.000> <-9.935, 3.427, -15.000> <-9.987, 4.000, -15.000> <-3.873, 2.091, -15.000> <-3.873, 2.666, -15.000> <-3.995, 3.427, -15.000> <-4.047, 4.000, -15.000> <4.047, 2.091, -15.000> <4.047, 2.666, -15.000> <3.925, 3.427, -15.000> <3.873, 4.000, -15.000> <9.987, 2.091, -15.000> <9.987, 2.666, -15.000> <9.865, 3.427, -15.000> <9.813, 4.000, -15.000> }
      texture { pages }
    }
  }
  //book_2
  union {
    //patch_cover_2
    union{
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 4.407, -16.000> <-4.458, 4.407, -16.000> <3.942, 4.416, -16.000> <10.242, 4.407, -16.000> <-10.758, 4.407, -16.036> <-4.458, 4.407, -16.036> <3.942, 4.416, -16.036> <10.242, 4.407, -16.036> <-10.794, 4.288, -16.000> <-4.494, 4.252, -16.000> <3.942, 4.287, -16.036> <10.242, 4.288, -16.036> <-10.758, 4.288, -16.000> <-4.458, 4.252, -16.000> <3.942, 4.287, -16.000> <10.242, 4.288, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 4.407, -16.000> <10.269, 4.407, -16.000> <10.319, 4.350, -16.000> <10.327, 4.376, -16.000> <10.242, 4.407, -16.036> <10.269, 4.407, -16.036> <10.320, 4.350, -16.058> <10.328, 4.376, -16.058> <10.242, 4.288, -16.036> <10.319, 4.288, -16.036> <10.465, 4.221, -16.058> <10.501, 4.290, -16.058> <10.242, 4.288, -16.000> <10.319, 4.288, -16.000> <10.465, 4.221, -16.000> <10.501, 4.290, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.327, 4.376, -16.000> <10.408, 4.642, -16.000> <10.509, 5.007, -16.000> <10.508, 5.285, -16.000> <10.328, 4.376, -16.058> <10.408, 4.642, -16.058> <10.510, 5.007, -16.075> <10.509, 5.285, -16.075> <10.501, 4.290, -16.058> <10.642, 4.564, -16.058> <10.761, 4.977, -16.075> <10.758, 5.285, -16.075> <10.501, 4.290, -16.000> <10.643, 4.564, -16.000> <10.761, 4.977, -16.000> <10.758, 5.285, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.508, 5.285, -16.000> <10.508, 5.572, -16.000> <10.403, 5.948, -16.000> <10.322, 6.223, -16.000> <10.509, 5.285, -16.075> <10.508, 5.572, -16.075> <10.403, 5.948, -16.055> <10.322, 6.223, -16.055> <10.758, 5.285, -16.075> <10.755, 5.605, -16.075> <10.626, 6.029, -16.055> <10.483, 6.314, -16.055> <10.758, 5.285, -16.000> <10.756, 5.605, -16.000> <10.626, 6.029, -16.000> <10.483, 6.314, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.322, 6.223, -16.000> <10.315, 6.248, -16.000> <10.267, 6.194, -16.000> <10.242, 6.194, -16.000> <10.322, 6.223, -16.055> <10.315, 6.248, -16.055> <10.267, 6.194, -16.036> <10.242, 6.194, -16.036> <10.483, 6.314, -16.055> <10.450, 6.379, -16.055> <10.314, 6.313, -16.036> <10.242, 6.313, -16.036> <10.483, 6.314, -16.000> <10.450, 6.379, -16.000> <10.314, 6.313, -16.000> <10.242, 6.313, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 6.194, -16.000> <3.942, 6.185, -16.000> <-4.458, 6.194, -16.000> <-10.758, 6.194, -16.000> <10.242, 6.158, -6.400> <3.942, 6.149, -6.400> <-4.458, 6.158, -6.400> <-10.758, 6.158, -6.400> <10.242, 6.158, 6.400> <3.942, 6.149, 6.400> <-4.458, 6.158, 6.400> <-10.758, 6.158, 6.400> <10.242, 6.194, 16.000> <3.942, 6.185, 16.000> <-4.458, 6.194, 16.000> <-10.758, 6.194, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 6.194, -16.000> <3.942, 6.185, -16.000> <-4.458, 6.194, -16.000> <-10.758, 6.194, -16.000> <10.242, 6.194, -16.036> <3.942, 6.185, -16.036> <-4.458, 6.194, -16.036> <-10.758, 6.194, -16.036> <10.242, 6.313, -16.036> <3.942, 6.312, -16.036> <-4.494, 6.349, -16.000> <-10.794, 6.313, -16.000> <10.242, 6.313, -16.000> <3.942, 6.313, -16.000> <-4.458, 6.349, -16.000> <-10.758, 6.313, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 4.407, 16.000> <-4.458, 4.407, 16.000> <3.942, 4.416, 16.000> <10.242, 4.407, 16.000> <-10.758, 4.443, 6.400> <-4.458, 4.443, 6.400> <3.942, 4.452, 6.400> <10.242, 4.443, 6.400> <-10.758, 4.443, -6.400> <-4.458, 4.443, -6.400> <3.942, 4.452, -6.400> <10.242, 4.443, -6.400> <-10.758, 4.407, -16.000> <-4.458, 4.407, -16.000> <3.942, 4.416, -16.000> <10.242, 4.407, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 4.407, 16.000> <10.269, 4.407, 16.000> <10.319, 4.350, 16.000> <10.327, 4.376, 16.000> <10.242, 4.443, 6.400> <10.269, 4.442, 6.400> <10.267, 4.376, 6.400> <10.275, 4.402, 6.400> <10.242, 4.443, -6.400> <10.269, 4.442, -6.400> <10.267, 4.376, -6.400> <10.275, 4.402, -6.400> <10.242, 4.407, -16.000> <10.269, 4.407, -16.000> <10.319, 4.350, -16.000> <10.327, 4.376, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.327, 4.376, 16.000> <10.408, 4.642, 16.000> <10.509, 5.007, 16.000> <10.508, 5.285, 16.000> <10.275, 4.402, 6.400> <10.356, 4.668, 6.400> <10.434, 5.007, 6.400> <10.433, 5.285, 6.400> <10.275, 4.402, -6.400> <10.356, 4.668, -6.400> <10.434, 5.007, -6.400> <10.433, 5.285, -6.400> <10.327, 4.376, -16.000> <10.408, 4.642, -16.000> <10.509, 5.007, -16.000> <10.508, 5.285, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.508, 5.285, 16.000> <10.508, 5.572, 16.000> <10.403, 5.948, 16.000> <10.322, 6.223, 16.000> <10.433, 5.285, 6.400> <10.433, 5.572, 6.400> <10.355, 5.920, 6.400> <10.274, 6.196, 6.400> <10.433, 5.285, -6.400> <10.433, 5.572, -6.400> <10.355, 5.920, -6.400> <10.274, 6.196, -6.400> <10.508, 5.285, -16.000> <10.508, 5.572, -16.000> <10.403, 5.948, -16.000> <10.322, 6.223, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.322, 6.223, 16.000> <10.315, 6.248, 16.000> <10.267, 6.194, 16.000> <10.242, 6.194, 16.000> <10.274, 6.196, 6.400> <10.267, 6.220, 6.400> <10.267, 6.158, 6.400> <10.242, 6.158, 6.400> <10.274, 6.196, -6.400> <10.267, 6.220, -6.400> <10.267, 6.158, -6.400> <10.242, 6.158, -6.400> <10.322, 6.223, -16.000> <10.315, 6.248, -16.000> <10.267, 6.194, -16.000> <10.242, 6.194, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 6.194, 16.000> <3.942, 6.185, 16.000> <-4.458, 6.194, 16.000> <-10.758, 6.194, 16.000> <10.242, 6.194, 16.036> <3.942, 6.185, 16.036> <-4.458, 6.194, 16.036> <-10.758, 6.194, 16.036> <10.242, 6.313, 16.036> <3.942, 6.312, 16.036> <-4.494, 6.349, 16.000> <-10.794, 6.313, 16.000> <10.242, 6.313, 16.000> <3.942, 6.313, 16.000> <-4.458, 6.349, 16.000> <-10.758, 6.313, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 4.288, 16.000> <-10.758, 4.288, 6.400> <-10.758, 4.288, -6.400> <-10.758, 4.288, -16.000> <-4.458, 4.252, 16.000> <-4.458, 4.252, 6.400> <-4.458, 4.252, -6.400> <-4.458, 4.252, -16.000> <3.942, 4.287, 16.000> <3.942, 4.251, 6.400> <3.942, 4.251, -6.400> <3.942, 4.287, -16.000> <10.242, 4.288, 16.000> <10.242, 4.252, 6.400> <10.242, 4.252, -6.400> <10.242, 4.288, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 4.288, 16.000> <-10.758, 4.288, 6.400> <-10.758, 4.288, -6.400> <-10.758, 4.288, -16.000> <-10.794, 4.288, 16.000> <-10.794, 4.288, 6.400> <-10.794, 4.288, -6.400> <-10.794, 4.288, -16.000> <-10.758, 4.407, 16.036> <-10.758, 4.442, 6.436> <-10.758, 4.442, -6.436> <-10.758, 4.407, -16.036> <-10.758, 4.407, 16.000> <-10.758, 4.443, 6.400> <-10.758, 4.443, -6.400> <-10.758, 4.407, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 6.194, 16.000> <-10.758, 6.158, 6.400> <-10.758, 6.158, -6.400> <-10.758, 6.194, -16.000> <-10.758, 6.194, 16.036> <-10.758, 6.158, 6.436> <-10.758, 6.158, -6.436> <-10.758, 6.194, -16.036> <-10.794, 6.313, 16.000> <-10.794, 6.313, 6.400> <-10.794, 6.313, -6.400> <-10.794, 6.313, -16.000> <-10.758, 6.313, 16.000> <-10.758, 6.313, 6.400> <-10.758, 6.313, -6.400> <-10.758, 6.313, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 6.313, -16.000> <-4.458, 6.349, -16.000> <3.942, 6.313, -16.000> <10.242, 6.313, -16.000> <-10.758, 6.313, -6.400> <-4.458, 6.349, -6.400> <3.942, 6.348, -6.400> <10.242, 6.349, -6.400> <-10.758, 6.313, 6.400> <-4.458, 6.349, 6.400> <3.942, 6.348, 6.400> <10.242, 6.349, 6.400> <-10.758, 6.313, 16.000> <-4.458, 6.349, 16.000> <3.942, 6.313, 16.000> <10.242, 6.313, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 6.313, -16.000> <10.314, 6.313, -16.000> <10.450, 6.379, -16.000> <10.483, 6.314, -16.000> <10.242, 6.349, -6.400> <10.314, 6.349, -6.400> <10.499, 6.406, -6.400> <10.531, 6.342, -6.400> <10.242, 6.349, 6.400> <10.314, 6.349, 6.400> <10.499, 6.406, 6.400> <10.531, 6.342, 6.400> <10.242, 6.313, 16.000> <10.314, 6.313, 16.000> <10.450, 6.379, 16.000> <10.483, 6.314, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.483, 6.314, -16.000> <10.626, 6.029, -16.000> <10.756, 5.605, -16.000> <10.758, 5.285, -16.000> <10.531, 6.342, -6.400> <10.675, 6.056, -6.400> <10.831, 5.605, -6.400> <10.833, 5.285, -6.400> <10.531, 6.342, 6.400> <10.675, 6.056, 6.400> <10.831, 5.605, 6.400> <10.833, 5.285, 6.400> <10.483, 6.314, 16.000> <10.626, 6.029, 16.000> <10.756, 5.605, 16.000> <10.758, 5.285, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.758, 5.285, -16.000> <10.761, 4.977, -16.000> <10.643, 4.564, -16.000> <10.501, 4.290, -16.000> <10.833, 5.285, -6.400> <10.836, 4.977, -6.400> <10.695, 4.538, -6.400> <10.553, 4.265, -6.400> <10.833, 5.285, 6.400> <10.836, 4.977, 6.400> <10.695, 4.538, 6.400> <10.553, 4.265, 6.400> <10.758, 5.285, 16.000> <10.761, 4.977, 16.000> <10.643, 4.564, 16.000> <10.501, 4.290, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.501, 4.290, -16.000> <10.465, 4.221, -16.000> <10.319, 4.288, -16.000> <10.242, 4.288, -16.000> <10.553, 4.265, -6.400> <10.517, 4.195, -6.400> <10.319, 4.252, -6.400> <10.242, 4.252, -6.400> <10.553, 4.265, 6.400> <10.517, 4.195, 6.400> <10.319, 4.252, 6.400> <10.242, 4.252, 6.400> <10.501, 4.290, 16.000> <10.465, 4.221, 16.000> <10.319, 4.288, 16.000> <10.242, 4.288, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 4.288, 16.000> <-4.458, 4.252, 16.000> <3.942, 4.287, 16.000> <10.242, 4.288, 16.000> <-10.794, 4.288, 16.000> <-4.494, 4.252, 16.000> <3.942, 4.287, 16.036> <10.242, 4.288, 16.036> <-10.758, 4.407, 16.036> <-4.458, 4.407, 16.036> <3.942, 4.416, 16.036> <10.242, 4.407, 16.036> <-10.758, 4.407, 16.000> <-4.458, 4.407, 16.000> <3.942, 4.416, 16.000> <10.242, 4.407, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 4.288, 16.000> <10.319, 4.288, 16.000> <10.465, 4.221, 16.000> <10.501, 4.290, 16.000> <10.242, 4.288, 16.036> <10.319, 4.288, 16.036> <10.465, 4.221, 16.058> <10.501, 4.290, 16.058> <10.242, 4.407, 16.036> <10.269, 4.407, 16.036> <10.320, 4.350, 16.058> <10.328, 4.376, 16.058> <10.242, 4.407, 16.000> <10.269, 4.407, 16.000> <10.319, 4.350, 16.000> <10.327, 4.376, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.501, 4.290, 16.000> <10.643, 4.564, 16.000> <10.761, 4.977, 16.000> <10.758, 5.285, 16.000> <10.501, 4.290, 16.058> <10.642, 4.564, 16.058> <10.761, 4.977, 16.075> <10.758, 5.285, 16.075> <10.328, 4.376, 16.058> <10.408, 4.642, 16.058> <10.510, 5.007, 16.075> <10.509, 5.285, 16.075> <10.327, 4.376, 16.000> <10.408, 4.642, 16.000> <10.509, 5.007, 16.000> <10.508, 5.285, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.758, 5.285, 16.000> <10.756, 5.605, 16.000> <10.626, 6.029, 16.000> <10.483, 6.314, 16.000> <10.758, 5.285, 16.075> <10.755, 5.605, 16.075> <10.626, 6.029, 16.055> <10.483, 6.314, 16.055> <10.509, 5.285, 16.075> <10.508, 5.572, 16.075> <10.403, 5.948, 16.055> <10.322, 6.223, 16.055> <10.508, 5.285, 16.000> <10.508, 5.572, 16.000> <10.403, 5.948, 16.000> <10.322, 6.223, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.483, 6.314, 16.000> <10.450, 6.379, 16.000> <10.314, 6.313, 16.000> <10.242, 6.313, 16.000> <10.483, 6.314, 16.055> <10.450, 6.379, 16.055> <10.314, 6.313, 16.036> <10.242, 6.313, 16.036> <10.322, 6.223, 16.055> <10.315, 6.248, 16.055> <10.267, 6.194, 16.036> <10.242, 6.194, 16.036> <10.322, 6.223, 16.000> <10.315, 6.248, 16.000> <10.267, 6.194, 16.000> <10.242, 6.194, 16.000> }
      texture { cover_2 }
    }
    //patch_pages_2
    union{
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 5.284, 15.000> <-3.873, 5.284, 15.000> <4.047, 5.284, 15.000> <9.987, 5.284, 15.000> <-9.813, 5.016, 15.000> <-3.873, 5.016, 15.000> <4.047, 5.016, 15.000> <9.987, 5.016, 15.000> <-9.935, 4.670, 15.000> <-3.995, 4.670, 15.000> <3.925, 4.670, 15.000> <9.865, 4.670, 15.000> <-9.987, 4.407, 15.000> <-4.047, 4.407, 15.000> <3.873, 4.407, 15.000> <9.813, 4.407, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 5.284, 15.000> <9.987, 5.284, 6.000> <9.987, 5.284, -6.000> <9.987, 5.284, -15.000> <9.987, 5.016, 15.000> <9.987, 5.016, 6.000> <9.987, 5.016, -6.000> <9.987, 5.016, -15.000> <9.865, 4.670, 15.000> <9.865, 4.670, 6.000> <9.865, 4.670, -6.000> <9.865, 4.670, -15.000> <9.813, 4.407, 15.000> <9.813, 4.407, 6.000> <9.813, 4.407, -6.000> <9.813, 4.407, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 5.284, -15.000> <4.047, 5.284, -15.000> <-3.873, 5.284, -15.000> <-9.813, 5.284, -15.000> <9.987, 5.016, -15.000> <4.047, 5.016, -15.000> <-3.873, 5.016, -15.000> <-9.813, 5.016, -15.000> <9.865, 4.670, -15.000> <3.925, 4.670, -15.000> <-3.995, 4.670, -15.000> <-9.935, 4.670, -15.000> <9.813, 4.407, -15.000> <3.873, 4.407, -15.000> <-4.047, 4.407, -15.000> <-9.987, 4.407, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 5.284, -15.000> <-9.813, 5.284, -6.000> <-9.813, 5.284, 6.000> <-9.813, 5.284, 15.000> <-9.813, 5.016, -15.000> <-9.813, 5.016, -6.000> <-9.813, 5.016, 6.000> <-9.813, 5.016, 15.000> <-9.935, 4.670, -15.000> <-9.935, 4.670, -6.000> <-9.935, 4.670, 6.000> <-9.935, 4.670, 15.000> <-9.987, 4.407, -15.000> <-9.987, 4.407, -6.000> <-9.987, 4.407, 6.000> <-9.987, 4.407, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 5.284, 15.000> <-9.813, 5.562, 15.000> <-9.935, 5.921, 15.000> <-9.987, 6.194, 15.000> <-9.813, 5.284, 6.000> <-9.813, 5.562, 6.000> <-9.935, 5.921, 6.000> <-9.987, 6.194, 6.000> <-9.813, 5.284, -6.000> <-9.813, 5.562, -6.000> <-9.935, 5.921, -6.000> <-9.987, 6.194, -6.000> <-9.813, 5.284, -15.000> <-9.813, 5.562, -15.000> <-9.935, 5.921, -15.000> <-9.987, 6.194, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 5.284, 15.000> <9.987, 5.562, 15.000> <9.865, 5.921, 15.000> <9.813, 6.194, 15.000> <4.047, 5.284, 15.000> <4.047, 5.562, 15.000> <3.925, 5.921, 15.000> <3.873, 6.194, 15.000> <-3.873, 5.284, 15.000> <-3.873, 5.562, 15.000> <-3.995, 5.921, 15.000> <-4.047, 6.194, 15.000> <-9.813, 5.284, 15.000> <-9.813, 5.562, 15.000> <-9.935, 5.921, 15.000> <-9.987, 6.194, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 5.284, -15.000> <9.987, 5.562, -15.000> <9.865, 5.921, -15.000> <9.813, 6.194, -15.000> <9.987, 5.284, -6.000> <9.987, 5.562, -6.000> <9.865, 5.921, -6.000> <9.813, 6.194, -6.000> <9.987, 5.284, 6.000> <9.987, 5.562, 6.000> <9.865, 5.921, 6.000> <9.813, 6.194, 6.000> <9.987, 5.284, 15.000> <9.987, 5.562, 15.000> <9.865, 5.921, 15.000> <9.813, 6.194, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 5.284, -15.000> <-9.813, 5.562, -15.000> <-9.935, 5.921, -15.000> <-9.987, 6.194, -15.000> <-3.873, 5.284, -15.000> <-3.873, 5.562, -15.000> <-3.995, 5.921, -15.000> <-4.047, 6.194, -15.000> <4.047, 5.284, -15.000> <4.047, 5.562, -15.000> <3.925, 5.921, -15.000> <3.873, 6.194, -15.000> <9.987, 5.284, -15.000> <9.987, 5.562, -15.000> <9.865, 5.921, -15.000> <9.813, 6.194, -15.000> }
      texture { pages }
    }
    rotate y*5
  }
  //book_3
  union {
    //patch_cover_3
    union{
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 6.529, -16.000> <-4.458, 6.529, -16.000> <3.942, 6.542, -16.000> <10.242, 6.529, -16.000> <-10.758, 6.529, -16.052> <-4.458, 6.529, -16.052> <3.942, 6.542, -16.052> <10.242, 6.529, -16.052> <-10.810, 6.357, -16.000> <-4.510, 6.305, -16.000> <3.942, 6.356, -16.052> <10.242, 6.357, -16.052> <-10.758, 6.356, -16.000> <-4.459, 6.305, -16.000> <3.942, 6.355, -16.000> <10.242, 6.356, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 6.529, -16.000> <10.271, 6.529, -16.000> <10.321, 6.456, -16.000> <10.327, 6.484, -16.000> <10.242, 6.529, -16.052> <10.271, 6.529, -16.052> <10.322, 6.456, -16.064> <10.328, 6.484, -16.064> <10.242, 6.357, -16.052> <10.319, 6.357, -16.052> <10.474, 6.287, -16.064> <10.501, 6.360, -16.064> <10.242, 6.356, -16.000> <10.319, 6.356, -16.000> <10.475, 6.287, -16.000> <10.501, 6.360, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.327, 6.484, -16.000> <10.409, 6.874, -16.000> <10.509, 7.402, -16.000> <10.508, 7.801, -16.000> <10.328, 6.484, -16.064> <10.409, 6.874, -16.064> <10.510, 7.402, -16.075> <10.509, 7.801, -16.075> <10.501, 6.360, -16.064> <10.648, 6.774, -16.064> <10.760, 7.362, -16.075> <10.758, 7.801, -16.075> <10.501, 6.360, -16.000> <10.649, 6.774, -16.000> <10.761, 7.362, -16.000> <10.758, 7.801, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.508, 7.801, -16.000> <10.508, 8.212, -16.000> <10.404, 8.756, -16.000> <10.322, 9.159, -16.000> <10.509, 7.801, -16.075> <10.508, 8.212, -16.075> <10.404, 8.756, -16.062> <10.323, 9.159, -16.062> <10.758, 7.801, -16.075> <10.755, 8.255, -16.075> <10.632, 8.861, -16.062> <10.483, 9.291, -16.062> <10.758, 7.801, -16.000> <10.756, 8.255, -16.000> <10.632, 8.861, -16.000> <10.483, 9.291, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.322, 9.159, -16.000> <10.317, 9.185, -16.000> <10.269, 9.116, -16.000> <10.242, 9.116, -16.000> <10.323, 9.159, -16.062> <10.317, 9.186, -16.062> <10.269, 9.117, -16.052> <10.242, 9.117, -16.052> <10.483, 9.291, -16.062> <10.459, 9.359, -16.062> <10.314, 9.289, -16.052> <10.242, 9.289, -16.052> <10.483, 9.291, -16.000> <10.459, 9.359, -16.000> <10.314, 9.289, -16.000> <10.242, 9.289, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 9.116, -16.000> <3.942, 9.104, -16.000> <-4.458, 9.116, -16.000> <-10.758, 9.116, -16.000> <10.242, 9.065, -6.400> <3.942, 9.052, -6.400> <-4.458, 9.065, -6.400> <-10.758, 9.065, -6.400> <10.242, 9.065, 6.400> <3.942, 9.052, 6.400> <-4.458, 9.065, 6.400> <-10.758, 9.065, 6.400> <10.242, 9.116, 16.000> <3.942, 9.104, 16.000> <-4.458, 9.116, 16.000> <-10.758, 9.116, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 9.116, -16.000> <3.942, 9.104, -16.000> <-4.458, 9.116, -16.000> <-10.758, 9.116, -16.000> <10.242, 9.117, -16.052> <3.942, 9.104, -16.052> <-4.458, 9.117, -16.052> <-10.758, 9.117, -16.052> <10.242, 9.289, -16.052> <3.942, 9.288, -16.052> <-4.510, 9.340, -16.000> <-10.810, 9.288, -16.000> <10.242, 9.289, -16.000> <3.942, 9.288, -16.000> <-4.459, 9.341, -16.000> <-10.758, 9.289, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 6.529, 16.000> <-4.458, 6.529, 16.000> <3.942, 6.542, 16.000> <10.242, 6.529, 16.000> <-10.758, 6.581, 6.400> <-4.458, 6.581, 6.400> <3.942, 6.594, 6.400> <10.242, 6.581, 6.400> <-10.758, 6.581, -6.400> <-4.458, 6.581, -6.400> <3.942, 6.594, -6.400> <10.242, 6.581, -6.400> <-10.758, 6.529, -16.000> <-4.458, 6.529, -16.000> <3.942, 6.542, -16.000> <10.242, 6.529, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 6.529, 16.000> <10.271, 6.529, 16.000> <10.321, 6.456, 16.000> <10.327, 6.484, 16.000> <10.242, 6.581, 6.400> <10.271, 6.581, 6.400> <10.269, 6.493, 6.400> <10.275, 6.521, 6.400> <10.242, 6.581, -6.400> <10.271, 6.581, -6.400> <10.269, 6.493, -6.400> <10.275, 6.521, -6.400> <10.242, 6.529, -16.000> <10.271, 6.529, -16.000> <10.321, 6.456, -16.000> <10.327, 6.484, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.327, 6.484, 16.000> <10.409, 6.874, 16.000> <10.509, 7.402, 16.000> <10.508, 7.801, 16.000> <10.275, 6.521, 6.400> <10.357, 6.912, 6.400> <10.434, 7.402, 6.400> <10.433, 7.801, 6.400> <10.275, 6.521, -6.400> <10.357, 6.912, -6.400> <10.434, 7.402, -6.400> <10.433, 7.801, -6.400> <10.327, 6.484, -16.000> <10.409, 6.874, -16.000> <10.509, 7.402, -16.000> <10.508, 7.801, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.508, 7.801, 16.000> <10.508, 8.212, 16.000> <10.404, 8.756, 16.000> <10.322, 9.159, 16.000> <10.433, 7.801, 6.400> <10.433, 8.212, 6.400> <10.356, 8.716, 6.400> <10.274, 9.119, 6.400> <10.433, 7.801, -6.400> <10.433, 8.212, -6.400> <10.356, 8.716, -6.400> <10.274, 9.119, -6.400> <10.508, 7.801, -16.000> <10.508, 8.212, -16.000> <10.404, 8.756, -16.000> <10.322, 9.159, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.322, 9.159, 16.000> <10.317, 9.185, 16.000> <10.269, 9.116, 16.000> <10.242, 9.116, 16.000> <10.274, 9.119, 6.400> <10.269, 9.146, 6.400> <10.269, 9.065, 6.400> <10.242, 9.065, 6.400> <10.274, 9.119, -6.400> <10.269, 9.146, -6.400> <10.269, 9.065, -6.400> <10.242, 9.065, -6.400> <10.322, 9.159, -16.000> <10.317, 9.185, -16.000> <10.269, 9.116, -16.000> <10.242, 9.116, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 9.116, 16.000> <3.942, 9.104, 16.000> <-4.458, 9.116, 16.000> <-10.758, 9.116, 16.000> <10.242, 9.117, 16.052> <3.942, 9.104, 16.052> <-4.458, 9.117, 16.052> <-10.758, 9.117, 16.052> <10.242, 9.289, 16.052> <3.942, 9.288, 16.052> <-4.510, 9.340, 16.000> <-10.810, 9.288, 16.000> <10.242, 9.289, 16.000> <3.942, 9.288, 16.000> <-4.459, 9.341, 16.000> <-10.758, 9.289, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 6.356, 16.000> <-10.758, 6.356, 6.400> <-10.758, 6.356, -6.400> <-10.758, 6.356, -16.000> <-4.459, 6.305, 16.000> <-4.459, 6.305, 6.400> <-4.459, 6.305, -6.400> <-4.459, 6.305, -16.000> <3.942, 6.355, 16.000> <3.942, 6.304, 6.400> <3.942, 6.304, -6.400> <3.942, 6.355, -16.000> <10.242, 6.356, 16.000> <10.242, 6.305, 6.400> <10.242, 6.305, -6.400> <10.242, 6.356, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 6.356, 16.000> <-10.758, 6.356, 6.400> <-10.758, 6.356, -6.400> <-10.758, 6.356, -16.000> <-10.810, 6.357, 16.000> <-10.810, 6.357, 6.400> <-10.810, 6.357, -6.400> <-10.810, 6.357, -16.000> <-10.758, 6.529, 16.052> <-10.758, 6.580, 6.452> <-10.758, 6.580, -6.452> <-10.758, 6.529, -16.052> <-10.758, 6.529, 16.000> <-10.758, 6.581, 6.400> <-10.758, 6.581, -6.400> <-10.758, 6.529, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 9.116, 16.000> <-10.758, 9.065, 6.400> <-10.758, 9.065, -6.400> <-10.758, 9.116, -16.000> <-10.758, 9.117, 16.052> <-10.758, 9.065, 6.452> <-10.758, 9.065, -6.452> <-10.758, 9.117, -16.052> <-10.810, 9.288, 16.000> <-10.810, 9.288, 6.400> <-10.810, 9.288, -6.400> <-10.810, 9.288, -16.000> <-10.758, 9.289, 16.000> <-10.758, 9.289, 6.400> <-10.758, 9.289, -6.400> <-10.758, 9.289, -16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 9.289, -16.000> <-4.459, 9.341, -16.000> <3.942, 9.288, -16.000> <10.242, 9.289, -16.000> <-10.758, 9.289, -6.400> <-4.459, 9.341, -6.400> <3.942, 9.340, -6.400> <10.242, 9.341, -6.400> <-10.758, 9.289, 6.400> <-4.459, 9.341, 6.400> <3.942, 9.340, 6.400> <10.242, 9.341, 6.400> <-10.758, 9.289, 16.000> <-4.459, 9.341, 16.000> <3.942, 9.288, 16.000> <10.242, 9.289, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 9.289, -16.000> <10.314, 9.289, -16.000> <10.459, 9.359, -16.000> <10.483, 9.291, -16.000> <10.242, 9.341, -6.400> <10.314, 9.341, -6.400> <10.507, 9.399, -6.400> <10.531, 9.331, -6.400> <10.242, 9.341, 6.400> <10.314, 9.341, 6.400> <10.507, 9.399, 6.400> <10.531, 9.331, 6.400> <10.242, 9.289, 16.000> <10.314, 9.289, 16.000> <10.459, 9.359, 16.000> <10.483, 9.291, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.483, 9.291, -16.000> <10.632, 8.861, -16.000> <10.756, 8.255, -16.000> <10.758, 7.801, -16.000> <10.531, 9.331, -6.400> <10.680, 8.901, -6.400> <10.831, 8.255, -6.400> <10.833, 7.801, -6.400> <10.531, 9.331, 6.400> <10.680, 8.901, 6.400> <10.831, 8.255, 6.400> <10.833, 7.801, 6.400> <10.483, 9.291, 16.000> <10.632, 8.861, 16.000> <10.756, 8.255, 16.000> <10.758, 7.801, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.758, 7.801, -16.000> <10.761, 7.362, -16.000> <10.649, 6.774, -16.000> <10.501, 6.360, -16.000> <10.833, 7.801, -6.400> <10.836, 7.362, -6.400> <10.701, 6.736, -6.400> <10.553, 6.323, -6.400> <10.833, 7.801, 6.400> <10.836, 7.362, 6.400> <10.701, 6.736, 6.400> <10.553, 6.323, 6.400> <10.758, 7.801, 16.000> <10.761, 7.362, 16.000> <10.649, 6.774, 16.000> <10.501, 6.360, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.501, 6.360, -16.000> <10.475, 6.287, -16.000> <10.319, 6.356, -16.000> <10.242, 6.356, -16.000> <10.553, 6.323, -6.400> <10.527, 6.250, -6.400> <10.319, 6.305, -6.400> <10.242, 6.305, -6.400> <10.553, 6.323, 6.400> <10.527, 6.250, 6.400> <10.319, 6.305, 6.400> <10.242, 6.305, 6.400> <10.501, 6.360, 16.000> <10.475, 6.287, 16.000> <10.319, 6.356, 16.000> <10.242, 6.356, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-10.758, 6.356, 16.000> <-4.459, 6.305, 16.000> <3.942, 6.355, 16.000> <10.242, 6.356, 16.000> <-10.810, 6.357, 16.000> <-4.510, 6.305, 16.000> <3.942, 6.356, 16.052> <10.242, 6.357, 16.052> <-10.758, 6.529, 16.052> <-4.458, 6.529, 16.052> <3.942, 6.542, 16.052> <10.242, 6.529, 16.052> <-10.758, 6.529, 16.000> <-4.458, 6.529, 16.000> <3.942, 6.542, 16.000> <10.242, 6.529, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.242, 6.356, 16.000> <10.319, 6.356, 16.000> <10.475, 6.287, 16.000> <10.501, 6.360, 16.000> <10.242, 6.357, 16.052> <10.319, 6.357, 16.052> <10.474, 6.287, 16.064> <10.501, 6.360, 16.064> <10.242, 6.529, 16.052> <10.271, 6.529, 16.052> <10.322, 6.456, 16.064> <10.328, 6.484, 16.064> <10.242, 6.529, 16.000> <10.271, 6.529, 16.000> <10.321, 6.456, 16.000> <10.327, 6.484, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.501, 6.360, 16.000> <10.649, 6.774, 16.000> <10.761, 7.362, 16.000> <10.758, 7.801, 16.000> <10.501, 6.360, 16.064> <10.648, 6.774, 16.064> <10.760, 7.362, 16.075> <10.758, 7.801, 16.075> <10.328, 6.484, 16.064> <10.409, 6.874, 16.064> <10.510, 7.402, 16.075> <10.509, 7.801, 16.075> <10.327, 6.484, 16.000> <10.409, 6.874, 16.000> <10.509, 7.402, 16.000> <10.508, 7.801, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.758, 7.801, 16.000> <10.756, 8.255, 16.000> <10.632, 8.861, 16.000> <10.483, 9.291, 16.000> <10.758, 7.801, 16.075> <10.755, 8.255, 16.075> <10.632, 8.861, 16.062> <10.483, 9.291, 16.062> <10.509, 7.801, 16.075> <10.508, 8.212, 16.075> <10.404, 8.756, 16.062> <10.323, 9.159, 16.062> <10.508, 7.801, 16.000> <10.508, 8.212, 16.000> <10.404, 8.756, 16.000> <10.322, 9.159, 16.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <10.483, 9.291, 16.000> <10.459, 9.359, 16.000> <10.314, 9.289, 16.000> <10.242, 9.289, 16.000> <10.483, 9.291, 16.062> <10.459, 9.359, 16.062> <10.314, 9.289, 16.052> <10.242, 9.289, 16.052> <10.323, 9.159, 16.062> <10.317, 9.186, 16.062> <10.269, 9.117, 16.052> <10.242, 9.117, 16.052> <10.322, 9.159, 16.000> <10.317, 9.185, 16.000> <10.269, 9.116, 16.000> <10.242, 9.116, 16.000> }
      texture { cover_3 }
    }
    //patch_pages_3
    union{
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 7.799, 15.000> <-3.873, 7.799, 15.000> <4.047, 7.799, 15.000> <9.987, 7.799, 15.000> <-9.813, 7.414, 15.000> <-3.873, 7.414, 15.000> <4.047, 7.414, 15.000> <9.987, 7.414, 15.000> <-9.935, 6.910, 15.000> <-3.995, 6.910, 15.000> <3.925, 6.910, 15.000> <9.865, 6.910, 15.000> <-9.987, 6.529, 15.000> <-4.047, 6.529, 15.000> <3.873, 6.529, 15.000> <9.813, 6.529, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 7.799, 15.000> <9.987, 7.799, 6.000> <9.987, 7.799, -6.000> <9.987, 7.799, -15.000> <9.987, 7.414, 15.000> <9.987, 7.414, 6.000> <9.987, 7.414, -6.000> <9.987, 7.414, -15.000> <9.865, 6.910, 15.000> <9.865, 6.910, 6.000> <9.865, 6.910, -6.000> <9.865, 6.910, -15.000> <9.813, 6.529, 15.000> <9.813, 6.529, 6.000> <9.813, 6.529, -6.000> <9.813, 6.529, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 7.799, -15.000> <4.047, 7.799, -15.000> <-3.873, 7.799, -15.000> <-9.813, 7.799, -15.000> <9.987, 7.414, -15.000> <4.047, 7.414, -15.000> <-3.873, 7.414, -15.000> <-9.813, 7.414, -15.000> <9.865, 6.910, -15.000> <3.925, 6.910, -15.000> <-3.995, 6.910, -15.000> <-9.935, 6.910, -15.000> <9.813, 6.529, -15.000> <3.873, 6.529, -15.000> <-4.047, 6.529, -15.000> <-9.987, 6.529, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 7.799, -15.000> <-9.813, 7.799, -6.000> <-9.813, 7.799, 6.000> <-9.813, 7.799, 15.000> <-9.813, 7.414, -15.000> <-9.813, 7.414, -6.000> <-9.813, 7.414, 6.000> <-9.813, 7.414, 15.000> <-9.935, 6.910, -15.000> <-9.935, 6.910, -6.000> <-9.935, 6.910, 6.000> <-9.935, 6.910, 15.000> <-9.987, 6.529, -15.000> <-9.987, 6.529, -6.000> <-9.987, 6.529, 6.000> <-9.987, 6.529, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 7.799, 15.000> <-9.813, 8.198, 15.000> <-9.935, 8.721, 15.000> <-9.987, 9.116, 15.000> <-9.813, 7.799, 6.000> <-9.813, 8.198, 6.000> <-9.935, 8.721, 6.000> <-9.987, 9.116, 6.000> <-9.813, 7.799, -6.000> <-9.813, 8.198, -6.000> <-9.935, 8.721, -6.000> <-9.987, 9.116, -6.000> <-9.813, 7.799, -15.000> <-9.813, 8.198, -15.000> <-9.935, 8.721, -15.000> <-9.987, 9.116, -15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 7.799, 15.000> <9.987, 8.198, 15.000> <9.865, 8.721, 15.000> <9.813, 9.116, 15.000> <4.047, 7.799, 15.000> <4.047, 8.198, 15.000> <3.925, 8.721, 15.000> <3.873, 9.116, 15.000> <-3.873, 7.799, 15.000> <-3.873, 8.198, 15.000> <-3.995, 8.721, 15.000> <-4.047, 9.116, 15.000> <-9.813, 7.799, 15.000> <-9.813, 8.198, 15.000> <-9.935, 8.721, 15.000> <-9.987, 9.116, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.987, 7.799, -15.000> <9.987, 8.198, -15.000> <9.865, 8.721, -15.000> <9.813, 9.116, -15.000> <9.987, 7.799, -6.000> <9.987, 8.198, -6.000> <9.865, 8.721, -6.000> <9.813, 9.116, -6.000> <9.987, 7.799, 6.000> <9.987, 8.198, 6.000> <9.865, 8.721, 6.000> <9.813, 9.116, 6.000> <9.987, 7.799, 15.000> <9.987, 8.198, 15.000> <9.865, 8.721, 15.000> <9.813, 9.116, 15.000> }
    	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-9.813, 7.799, -15.000> <-9.813, 8.198, -15.000> <-9.935, 8.721, -15.000> <-9.987, 9.116, -15.000> <-3.873, 7.799, -15.000> <-3.873, 8.198, -15.000> <-3.995, 8.721, -15.000> <-4.047, 9.116, -15.000> <4.047, 7.799, -15.000> <4.047, 8.198, -15.000> <3.925, 8.721, -15.000> <3.873, 9.116, -15.000> <9.987, 7.799, -15.000> <9.987, 8.198, -15.000> <9.865, 8.721, -15.000> <9.813, 9.116, -15.000> }
      texture { pages }
    }
    rotate y*15
  }
}
