// Persistence of Vision Ray Tracer Include File
// File: clock.inc
// Vers: 3.5
// Desc: include file for faith.pov
// Date: 22/6/2003
// Auth: Paolo Brasolin

#include "metals.inc"
#include "glass_old.inc"
#include "colors.inc"

#declare battery_label = material {	texture { T_Chrome_2B } texture { pigment { image_map { gif "battery.gif" map_type 2 filter 0, 1 } scale 5 } finish { F_MetalC } } }
#declare quadrant_label = texture {	pigment {	image_map { jpeg "clock.jpg" map_type 0 }	scale <7,7,1>	translate <3,3.5,0>	}	finish { phong 0.2 phong_size 20 } } 
#declare quadrant_plastic = texture { pigment { color rgbf <1.0, 1.0, 1.0, 0.8> } finish { F_Glass1 } } 
#declare black_plastic = texture { pigment { Gray20 } finish { phong 0.4 phong_size 5 } } 
#declare alarm_plastic = texture { pigment { Yellow } finish { phong 0.4 phong_size 5 } } 
#declare hours_plastic = texture { pigment { Green } finish { phong 0.4 phong_size 5 } } 
#declare seconds_plastic = texture { pigment { Red } finish { phong 0.4 phong_size 5 } } 

#declare alarm_clock = union {
  //octagon
  union {
    //patch_body
    union {
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.044, 5.195, 3.516> <11.035, 6.310, 3.516> <11.023, 7.796, 3.516> <11.014, 8.911, 3.516>	<10.256, 4.399, 3.516> <10.247, 5.514, 3.516> <10.222, 8.577, 3.516> <10.213, 9.692, 3.516> <9.205, 3.338, 3.516> <9.183, 6.030, 3.516> <9.166, 8.042, 3.516> <9.145, 10.733, 3.516> <8.416, 2.542, 3.516> <8.395, 5.234, 3.516> <8.365, 8.823, 3.516> <8.344, 11.514, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.014, 8.911, 3.516> <10.213, 9.692, 3.516> <9.145, 10.733, 3.516> <8.344, 11.514, 3.516> <11.014, 8.911, 2.617> <10.213, 9.692, 2.617> <9.145, 10.733, 2.617> <8.344, 11.514, 2.617> <11.014, 8.911, 1.418> <10.213, 9.692, 1.418> <9.145, 10.733, 1.418> <8.344, 11.514, 1.418> <11.014, 8.911, 0.519> <10.213, 9.692, 0.519> <9.145, 10.733, 0.519> <8.344, 11.514, 0.519> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.344, 11.514, 3.516> <7.220, 11.504, 3.516> <5.722, 11.490, 3.516> <4.598, 11.479, 3.516> <8.344, 11.514, 2.617> <7.220, 11.504, 2.617> <5.722, 11.490, 2.617> <4.598, 11.479, 2.617> <8.344, 11.514, 1.418> <7.220, 11.504, 1.418> <5.722, 11.490, 1.418> <4.598, 11.479, 1.418> <8.344, 11.514, 0.519> <7.220, 11.504, 0.519> <5.722, 11.490, 0.519> <4.598, 11.479, 0.519> }
      bicubic_patch {	type 1 flatness 0 u_steps 3	v_steps 3	<2.001, 5.110, 3.516> <2.802, 4.329, 3.516> <3.870, 3.288, 3.516> <4.671, 2.507, 3.516> <1.992, 6.225, 3.516> <2.793, 5.444, 3.516> <3.848, 5.980, 3.516> <4.649, 5.199, 3.516> <1.980, 7.712, 3.516> <2.768, 8.508, 3.516> <3.831, 7.992, 3.516> <4.620, 8.788, 3.516> <1.971, 8.827, 3.516> <2.759, 9.622, 3.516> <3.810, 10.683, 3.516> <4.598, 11.479, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.671, 2.507, 3.516> <5.794, 2.518, 3.516> <7.293, 2.532, 3.516> <8.416, 2.542, 3.516>	<4.649, 5.199, 3.516> <5.773, 5.209, 3.516> <7.271, 5.223, 3.516> <8.395, 5.234, 3.516>	<4.620, 8.788, 3.516> <5.743, 8.798, 3.516> <7.242, 8.812, 3.516> <8.365, 8.823, 3.516>	<4.598, 11.479, 3.516> <5.722, 11.490, 3.516> <7.220, 11.504, 3.516> <8.344, 11.514, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.044, 5.195, 0.519> <11.035, 6.310, 0.519> <11.023, 7.796, 0.519> <11.014, 8.911, 0.519> <11.044, 5.195, 1.418> <11.035, 6.310, 1.418> <11.023, 7.796, 1.418> <11.014, 8.911, 1.418> <11.044, 5.195, 2.617> <11.035, 6.310, 2.617> <11.023, 7.796, 2.617> <11.014, 8.911, 2.617> <11.044, 5.195, 3.516> <11.035, 6.310, 3.516> <11.023, 7.796, 3.516> <11.014, 8.911, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.014, 8.911, 0.519> <10.213, 9.692, 0.519> <9.145, 10.733, 0.519> <8.344, 11.514, 0.519> <10.721, 8.341, 0.518> <9.920, 9.122, 0.518> <9.342, 10.131, 0.518> <8.541, 10.912, 0.518> <10.330, 7.581, 0.517> <10.330, 8.391, 0.517> <9.378, 9.536, 0.517> <8.805, 10.109, 0.517> <10.037, 7.011, 0.516> <10.037, 7.821, 0.516> <9.576, 8.933, 0.516> <9.003, 9.506, 0.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.344, 11.514, 0.519> <7.220, 11.504, 0.519> <5.722, 11.490, 0.519> <4.598, 11.479, 0.519> <8.541, 10.912, 0.518> <7.418, 10.901, 0.518> <6.294, 11.208, 0.518> <5.171, 11.198, 0.518> <8.805, 10.109, 0.517> <8.232, 10.682, 0.517> <6.745, 10.822, 0.517> <5.934, 10.822, 0.517> <9.003, 9.506, 0.516> <8.430, 10.080, 0.516> <7.318, 10.541, 0.516> <6.507, 10.541, 0.516> }
      bicubic_patch { type 1 flatness 0	u_steps 3	v_steps 3	<4.598, 11.479, 0.519> <3.810, 10.683, 0.519> <2.759, 9.622, 0.519> <1.971, 8.827, 0.519> <4.598, 11.479, 1.418> <3.810, 10.683, 1.418> <2.759, 9.622, 1.418> <1.971, 8.827, 1.418> <4.598, 11.479, 2.617> <3.810, 10.683, 2.617> <2.759, 9.622, 2.617> <1.971, 8.827, 2.617> <4.598, 11.479, 3.516> <3.810, 10.683, 3.516> <2.759, 9.622, 3.516> <1.971, 8.827, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.971, 8.827, 0.519> <1.980, 7.712, 0.519> <1.992, 6.225, 0.519> <2.001, 5.110, 0.519> <1.971, 8.827, 1.418> <1.980, 7.712, 1.418> <1.992, 6.225, 1.418> <2.001, 5.110, 1.418> <1.971, 8.827, 2.617> <1.980, 7.712, 2.617> <1.992, 6.225, 2.617> <2.001, 5.110, 2.617> <1.971, 8.827, 3.516> <1.980, 7.712, 3.516> <1.992, 6.225, 3.516> <2.001, 5.110, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.001, 5.110, 0.519> <2.802, 4.329, 0.519> <3.870, 3.288, 0.519> <4.671, 2.507, 0.519> <2.001, 5.110, 1.418> <2.802, 4.329, 1.418> <3.870, 3.288, 1.418> <4.671, 2.507, 1.418> <2.001, 5.110, 2.617> <2.802, 4.329, 2.617> <3.870, 3.288, 2.617> <4.671, 2.507, 2.617> <2.001, 5.110, 3.516> <2.802, 4.329, 3.516> <3.870, 3.288, 3.516> <4.671, 2.507, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.671, 2.507, 0.519> <5.794, 2.518, 0.519> <7.293, 2.532, 0.519> <8.416, 2.542, 0.519> <4.671, 2.507, 1.418> <5.794, 2.518, 1.418> <7.293, 2.532, 1.418> <8.416, 2.542, 1.418> <4.671, 2.507, 2.617> <5.794, 2.518, 2.617> <7.293, 2.532, 2.617> <8.416, 2.542, 2.617> <4.671, 2.507, 3.516> <5.794, 2.518, 3.516> <7.293, 2.532, 3.516> <8.416, 2.542, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.416, 2.542, 0.519> <9.205, 3.338, 0.519> <10.256, 4.399, 0.519> <11.044, 5.195, 0.519> <7.844, 2.824, 0.518> <8.632, 3.620, 0.518> <9.643, 4.195, 0.518> <10.431, 4.991, 0.518> 	<7.080, 3.199, 0.517> <7.890, 3.199, 0.517> <9.042, 4.146, 0.517> <9.615, 4.719, 0.517> <6.507, 3.481, 0.516> <7.318, 3.481, 0.516> <8.430, 3.942, 0.516> <9.003, 4.515, 0.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.416, 2.542, 0.519> <9.205, 3.338, 0.519> <10.256, 4.399, 0.519> <11.044, 5.195, 0.519> <8.416, 2.542, 1.418> <9.205, 3.338, 1.418> <10.256, 4.399, 1.418> <11.044, 5.195, 1.418> <8.416, 2.542, 2.617> <9.205, 3.338, 2.617> <10.256, 4.399, 2.617> <11.044, 5.195, 2.617> <8.416, 2.542, 3.516> <9.205, 3.338, 3.516> <10.256, 4.399, 3.516> <11.044, 5.195, 3.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.507, 3.481, 0.516> <7.318, 3.481, 0.516> <8.430, 3.942, 0.516> <9.003, 4.515, 0.516> <6.507, 3.481, 0.816> <7.318, 3.481, 0.816> <8.430, 3.942, 0.816> <9.003, 4.515, 0.816> <6.507, 3.481, 1.216> <7.318, 3.481, 1.216> <8.430, 3.942, 1.216> <9.003, 4.515, 1.216> <6.507, 3.481, 1.516> <7.318, 3.481, 1.516> <8.430, 3.942, 1.516> <9.003, 4.515, 1.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<9.003, 4.515, 0.516> <9.576, 5.088, 0.516> <10.037, 6.200, 0.516> <10.037, 7.011, 0.516> <9.615, 4.719, 0.517> <10.188, 5.292, 0.517> <10.330, 6.770, 0.517> <10.330, 7.581, 0.517> <10.431, 4.991, 0.518> <10.422, 6.106, 0.518> <10.730, 7.226, 0.518> <10.721, 8.341, 0.518> <11.044, 5.195, 0.519> <11.035, 6.310, 0.519> <11.023, 7.796, 0.519> <11.014, 8.911, 0.519> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<9.003, 4.515, 0.516> <9.576, 5.088, 0.516> <10.037, 6.200, 0.516> <10.037, 7.011, 0.516> <9.003, 4.515, 0.816> <9.576, 5.088, 0.816> <10.037, 6.200, 0.816> <10.037, 7.011, 0.816> <9.003, 4.515, 1.216> <9.576, 5.088, 1.216> <10.037, 6.200, 1.216> <10.037, 7.011, 1.216> <9.003, 4.515, 1.516> <9.576, 5.088, 1.516> <10.037, 6.200, 1.516> <10.037, 7.011, 1.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<10.037, 7.011, 0.516> <10.037, 7.821, 0.516> <9.576, 8.933, 0.516> <9.003, 9.506, 0.516> <10.037, 7.011, 0.816> <10.037, 7.821, 0.816> <9.576, 8.933, 0.816> <9.003, 9.506, 0.816> <10.037, 7.011, 1.216> <10.037, 7.821, 1.216> <9.576, 8.933, 1.216> <9.003, 9.506, 1.216> <10.037, 7.011, 1.516> <10.037, 7.821, 1.516> <9.576, 8.933, 1.516> <9.003, 9.506, 1.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.507, 10.541, 0.516> <5.697, 10.541, 0.516> <4.585, 10.080, 0.516> <4.011, 9.506, 0.516> <5.934, 10.822, 0.517> <5.124, 10.822, 0.517> <3.972, 9.876, 0.517> <3.399, 9.303, 0.517> <5.171, 11.198, 0.518> <4.382, 10.402, 0.518> <3.371, 9.826, 0.518> <2.583, 9.031, 0.518> <4.598, 11.479, 0.519> <3.810, 10.683, 0.519> <2.759, 9.622, 0.519> <1.971, 8.827, 0.519> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.507, 10.541, 0.516> <5.697, 10.541, 0.516> <4.585, 10.080, 0.516> <4.011, 9.506, 0.516> <6.507, 10.541, 0.816> <5.697, 10.541, 0.816> <4.585, 10.080, 0.816> <4.011, 9.506, 0.816> <6.507, 10.541, 1.216> <5.697, 10.541, 1.216> <4.585, 10.080, 1.216> <4.011, 9.506, 1.216> <6.507, 10.541, 1.516> <5.697, 10.541, 1.516> <4.585, 10.080, 1.516> <4.011, 9.506, 1.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.011, 9.506, 0.516> <3.438, 8.933, 0.516> <2.977, 7.821, 0.516> <2.977, 7.011, 0.516>	<3.399, 9.303, 0.517> <2.826, 8.729, 0.517> <2.684, 7.251, 0.517> <2.684, 6.441, 0.517> <2.583, 9.031, 0.518> <2.592, 7.916, 0.518> <2.285, 6.795, 0.518> <2.294, 5.680, 0.518> <1.971, 8.827, 0.519> <1.980, 7.712, 0.519> <1.992, 6.225, 0.519> <2.001, 5.110, 0.519> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.977, 7.011, 0.516> <2.977, 6.200, 0.516> <3.438, 5.088, 0.516> <4.011, 4.515, 0.516>	<2.684, 6.441, 0.517> <2.684, 5.630, 0.517> <3.636, 4.486, 0.517> <4.209, 3.913, 0.517> <2.294, 5.680, 0.518> <3.095, 4.900, 0.518> <3.672, 3.891, 0.518> <4.473, 3.110, 0.518> <2.001, 5.110, 0.519> <2.802, 4.329, 0.519> <3.870, 3.288, 0.519> <4.671, 2.507, 0.519> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.011, 4.515, 0.516> <4.585, 3.942, 0.516> <5.697, 3.481, 0.516> <6.507, 3.481, 0.516>	<4.209, 3.913, 0.517> <4.782, 3.340, 0.517> <6.269, 3.199, 0.517> <7.080, 3.199, 0.517> <4.473, 3.110, 0.518> <5.597, 3.120, 0.518> <6.720, 2.813, 0.518> <7.844, 2.824, 0.518> <4.671, 2.507, 0.519> <5.794, 2.518, 0.519> <7.293, 2.532, 0.519> <8.416, 2.542, 0.519> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.011, 4.515, 0.516> <4.585, 3.942, 0.516> <5.697, 3.481, 0.516> <6.507, 3.481, 0.516>	<4.011, 4.515, 0.816> <4.585, 3.942, 0.816> <5.697, 3.481, 0.816> <6.507, 3.481, 0.816> <4.011, 4.515, 1.216> <4.585, 3.942, 1.216> <5.697, 3.481, 1.216> <6.507, 3.481, 1.216> <4.011, 4.515, 1.516> <4.585, 3.942, 1.516> <5.697, 3.481, 1.516> <6.507, 3.481, 1.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<9.003, 9.506, 1.516> <8.430, 10.080, 1.516> <7.318, 10.541, 1.516> <6.507, 10.541, 1.516> <9.003, 9.506, 1.216> <8.430, 10.080, 1.216> <7.318, 10.541, 1.216> <6.507, 10.541, 1.216> <9.003, 9.506, 0.816> <8.430, 10.080, 0.816> <7.318, 10.541, 0.816> <6.507, 10.541, 0.816> <9.003, 9.506, 0.516> <8.430, 10.080, 0.516> <7.318, 10.541, 0.516> <6.507, 10.541, 0.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.011, 9.506, 1.516> <3.438, 8.933, 1.516> <2.977, 7.821, 1.516> <2.977, 7.011, 1.516>	<4.011, 9.506, 1.216> <3.438, 8.933, 1.216> <2.977, 7.821, 1.216> <2.977, 7.011, 1.216> <4.011, 9.506, 0.816> <3.438, 8.933, 0.816> <2.977, 7.821, 0.816> <2.977, 7.011, 0.816> <4.011, 9.506, 0.516> <3.438, 8.933, 0.516> <2.977, 7.821, 0.516> <2.977, 7.011, 0.516> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.977, 7.011, 1.516> <2.977, 6.200, 1.516> <3.438, 5.088, 1.516> <4.011, 4.515, 1.516>	<2.977, 7.011, 1.216> <2.977, 6.200, 1.216> <3.438, 5.088, 1.216> <4.011, 4.515, 1.216> <2.977, 7.011, 0.816> <2.977, 6.200, 0.816> <3.438, 5.088, 0.816> <4.011, 4.515, 0.816> <2.977, 7.011, 0.516> <2.977, 6.200, 0.516> <3.438, 5.088, 0.516> <4.011, 4.515, 0.516> }
      texture { black_plastic }
    }
    //patch_quadrant_label
    union {
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<9.007, 4.481, 1.512> <9.580, 5.054, 1.512> <10.041, 6.167, 1.512> <10.041, 6.977, 1.512> <8.434, 3.908, 1.512> <9.007, 4.481, 1.512> <8.982, 6.167, 1.512> <8.982, 6.977, 1.512> <7.321, 3.447, 1.512> <7.321, 4.506, 1.512> <7.570, 5.918, 1.512> <7.570, 6.977, 1.512> <6.511, 3.447, 1.512> <6.511, 4.506, 1.512> <6.511, 5.918, 1.512> <6.511, 6.977, 1.512> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<9.007, 9.473, 1.512> <8.434, 10.046, 1.512> <7.321, 10.507, 1.512> <6.511, 10.507, 1.512> <9.580, 8.900, 1.512> <9.007, 9.473, 1.512> <7.321, 9.448, 1.512> <6.511, 9.448, 1.512> <10.041, 7.788, 1.512> <8.982, 7.788, 1.512> <7.570, 8.036, 1.512> <6.511, 8.036, 1.512> <10.041, 6.977, 1.512> <8.982, 6.977, 1.512> <7.570, 6.977, 1.512> <6.511, 6.977, 1.512> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.511, 10.507, 1.512> <5.700, 10.507, 1.512> <4.588, 10.046, 1.512> <4.015, 9.473, 1.512> <6.511, 9.448, 1.512> <5.700, 9.448, 1.512> <4.015, 9.473, 1.512> <3.442, 8.900, 1.512> <6.511, 8.036, 1.512> <5.452, 8.036, 1.512> <4.040, 7.788, 1.512> <2.981, 7.788, 1.512> <6.511, 6.977, 1.512> <5.452, 6.977, 1.512> <4.040, 6.977, 1.512> <2.981, 6.977, 1.512> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.511, 3.447, 1.512> <6.511, 4.506, 1.512> <6.511, 5.918, 1.512> <6.511, 6.977, 1.512> <5.700, 3.447, 1.512> <5.700, 4.506, 1.512> <5.452, 5.918, 1.512> <5.452, 6.977, 1.512> <4.588, 3.908, 1.512> <4.015, 4.481, 1.512> <4.040, 6.167, 1.512> <4.040, 6.977, 1.512> <4.015, 4.481, 1.512> <3.442, 5.054, 1.512> <2.981, 6.167, 1.512> <2.981, 6.977, 1.512> }
      texture { quadrant_label }
    }
    //patch_quadrant_plastic
    union {
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<10.016, 7.012, 0.505> <10.016, 7.815, 0.505> <9.560, 8.917, 0.505> <8.992, 9.485, 0.505> <10.016, 7.012, 0.811> <10.016, 7.815, 0.811> <9.759, 9.117, 0.623> <9.191, 9.685, 0.623> <10.016, 7.012, 1.220> <10.016, 7.815, 1.220> <9.560, 8.917, 1.220> <8.992, 9.485, 1.220> <10.016, 7.012, 1.526> <10.016, 7.815, 1.526> <9.560, 8.917, 1.526> <8.992, 9.485, 1.526> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<10.016, 7.012, 0.505> <10.016, 7.815, 0.505> <9.560, 8.917, 0.505> <8.992, 9.485, 0.505> <10.016, 6.209, 0.505> <10.016, 7.012, 0.505> <8.869, 8.222, 0.098> <8.301, 8.790, 0.098> <9.560, 5.106, 0.505> <8.870, 5.792, 0.098> <8.014, 7.001, 0.066> <7.269, 7.746, 0.066> <8.992, 4.539, 0.505> <8.302, 5.224, 0.098> <7.264, 6.251, 0.066> <6.518, 6.996, 0.066> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.992, 9.485, 0.505> <8.424, 10.053, 0.505> <7.322, 10.509, 0.505> <6.519, 10.509, 0.505> <9.191, 9.685, 0.623> <8.623, 10.253, 0.623> <7.322, 10.509, 0.811> <6.519, 10.509, 0.811> <8.992, 9.485, 1.220> <8.424, 10.053, 1.220> <7.322, 10.509, 1.220> <6.519, 10.509, 1.220> <8.992, 9.485, 1.526> <8.424, 10.053, 1.526> <7.322, 10.509, 1.526> <6.519, 10.509, 1.526> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.519, 10.509, 0.505> <5.716, 10.509, 0.505> <4.614, 10.053, 0.505> <4.046, 9.485, 0.505> <6.519, 10.509, 0.811> <5.716, 10.509, 0.811> <4.414, 10.253, 0.623> <3.847, 9.685, 0.623> <6.519, 10.509, 1.220> <5.716, 10.509, 1.220> <4.614, 10.053, 1.220> <4.046, 9.485, 1.220> <6.519, 10.509, 1.526> <5.716, 10.509, 1.526> <4.614, 10.053, 1.526> <4.046, 9.485, 1.526> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.046, 9.485, 0.505> <3.478, 8.917, 0.505> <3.021, 7.815, 0.505> <3.021, 7.012, 0.505> <3.847, 9.685, 0.623> <3.279, 9.118, 0.623> <3.021, 7.815, 0.811> <3.021, 7.012, 0.811> <4.046, 9.485, 1.220> <3.478, 8.917, 1.220> <3.021, 7.815, 1.220> <3.021, 7.012, 1.220> <4.046, 9.485, 1.526> <3.478, 8.917, 1.526> <3.021, 7.815, 1.526> <3.021, 7.012, 1.526> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<3.021, 7.012, 0.505> <3.021, 6.209, 0.505> <3.478, 5.106, 0.505> <4.046, 4.539, 0.505> <3.021, 7.815, 0.505> <3.021, 7.012, 0.505> <4.168, 5.792, 0.098> <4.735, 5.224, 0.098> <3.478, 8.917, 0.505> <4.168, 8.222, 0.098> <5.023, 7.001, 0.066> <5.773, 6.251, 0.066> <4.046, 9.485, 0.505> <4.736, 8.790, 0.098> <5.768, 7.746, 0.066> <6.518, 6.996, 0.066> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.519, 3.514, 0.505> <7.322, 3.514, 0.505> <8.424, 3.971, 0.505> <8.992, 4.539, 0.505> <5.716, 3.514, 0.505> <6.519, 3.514, 0.505> <7.734, 4.656, 0.098> <8.302, 5.224, 0.098> <4.614, 3.971, 0.505> <5.303, 4.656, 0.098> <6.519, 5.505, 0.066> <7.264, 6.251, 0.066> <4.046, 4.539, 0.505> <4.735, 5.224, 0.098> <5.773, 6.251, 0.066> <6.518, 6.996, 0.066> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<3.021, 7.012, 1.526> <3.021, 6.209, 1.526> <3.478, 5.106, 1.526> <4.046, 4.539, 1.526> <3.021, 7.012, 1.220> <3.021, 6.209, 1.220> <3.478, 5.106, 1.220> <4.046, 4.539, 1.220> <3.021, 7.012, 0.811> <3.021, 6.209, 0.811> <3.278, 4.907, 0.623> <3.845, 4.340, 0.623> <3.021, 7.012, 0.505> <3.021, 6.209, 0.505> <3.478, 5.106, 0.505> <4.046, 4.539, 0.505> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.046, 4.539, 1.526> <4.614, 3.971, 1.526> <5.716, 3.514, 1.526> <6.519, 3.514, 1.526> <4.046, 4.539, 1.220> <4.614, 3.971, 1.220> <5.716, 3.514, 1.220> <6.519, 3.514, 1.220> <3.845, 4.340, 0.623> <4.413, 3.772, 0.623> <5.716, 3.514, 0.811> <6.519, 3.514, 0.811> <4.046, 4.539, 0.505> <4.614, 3.971, 0.505> <5.716, 3.514, 0.505> <6.519, 3.514, 0.505> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.519, 3.514, 1.526> <7.322, 3.514, 1.526> <8.424, 3.971, 1.526> <8.992, 4.539, 1.526> <6.519, 3.514, 1.220> <7.322, 3.514, 1.220> <8.424, 3.971, 1.220> <8.992, 4.539, 1.220> <6.519, 3.514, 0.811> <7.322, 3.514, 0.811> <8.625, 3.772, 0.623> <9.192, 4.340, 0.623> <6.519, 3.514, 0.505> <7.322, 3.514, 0.505> <8.424, 3.971, 0.505> <8.992, 4.539, 0.505> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.992, 4.539, 1.526> <9.560, 5.106, 1.526> <10.016, 6.209, 1.526> <10.016, 7.012, 1.526> <8.992, 4.539, 1.220> <9.560, 5.106, 1.220> <10.016, 6.209, 1.220> <10.016, 7.012, 1.220> <9.192, 4.340, 0.623> <9.760, 4.907, 0.623> <10.016, 6.209, 0.811> <10.016, 7.012, 0.811> <8.992, 4.539, 0.505> <9.560, 5.106, 0.505> <10.016, 6.209, 0.505> <10.016, 7.012, 0.505> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.046, 9.485, 0.505> <4.736, 8.790, 0.098> <5.768, 7.746, 0.066> <6.518, 6.996, 0.066> <4.614, 10.053, 0.505> <5.304, 9.358, 0.098> <6.519, 8.496, 0.066> <7.269, 7.746, 0.066> <5.716, 10.509, 0.505> <6.519, 10.509, 0.505> <7.734, 9.358, 0.098> <8.301, 8.790, 0.098> <6.519, 10.509, 0.505> <7.322, 10.509, 0.505> <8.424, 10.053, 0.505> <8.992, 9.485, 0.505> }
      texture { quadrant_plastic }
    }
    //patch_hours_hand
    union {
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.673, 7.211, 1.428> <6.562, 7.108, 1.428> <6.237, 7.001, 1.428> <6.305, 6.867, 1.428> <6.739, 7.160, 1.428> <6.629, 7.056, 1.428> <6.305, 6.867, 1.428> <6.374, 6.732, 1.428> <6.798, 7.045, 1.428> <6.663, 6.977, 1.428> <6.663, 6.977, 1.428> <6.665, 6.893, 1.428> <6.800, 6.961, 1.428> <6.800, 6.961, 1.428> <6.800, 6.961, 1.428> <6.800, 6.961, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.800, 6.961, 1.428> <7.190, 7.159, 1.428> <7.662, 7.509, 1.428> <8.031, 7.743, 1.428> <6.798, 7.045, 1.428> <7.188, 7.244, 1.428> <7.254, 7.349, 1.428> <7.623, 7.584, 1.428> <6.739, 7.160, 1.428> <7.147, 7.319, 1.428> <7.147, 7.319, 1.428> <7.080, 7.371, 1.428> <6.673, 7.211, 1.428> <6.673, 7.211, 1.428> <6.673, 7.211, 1.428> <6.673, 7.211, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.800, 6.961, 1.441> <7.152, 7.142, 1.444> <7.626, 7.374, 1.441> <7.973, 7.564, 1.441> <6.797, 6.960, 1.441> <7.149, 7.140, 1.444> <7.274, 7.193, 1.441> <7.621, 7.383, 1.441> <6.802, 6.958, 1.428> <7.154, 7.139, 1.432> <7.154, 7.139, 1.432> <7.152, 7.142, 1.432> <6.800, 6.961, 1.428> <6.800, 6.961, 1.428> <6.800, 6.961, 1.428> <6.800, 6.961, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.039, 7.642, 1.428> <8.048, 7.671, 1.428> <8.033, 7.713, 1.428> <8.031, 7.743, 1.428> <8.030, 7.613, 1.428> <8.039, 7.642, 1.428> <7.664, 7.478, 1.428> <7.662, 7.509, 1.428> <7.993, 7.588, 1.428> <7.641, 7.407, 1.424> <7.542, 7.340, 1.428> <7.190, 7.159, 1.428> <7.973, 7.564, 1.428> <7.621, 7.383, 1.424> <7.152, 7.142, 1.428> <6.800, 6.961, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<7.954, 7.809, 1.428> <7.925, 7.819, 1.428> <7.883, 7.804, 1.428> <7.852, 7.801, 1.428> <7.954, 7.809, 1.432> <7.925, 7.819, 1.432> <7.886, 7.805, 1.428> <7.856, 7.803, 1.428> <7.954, 7.809, 1.437> <7.925, 7.819, 1.437> <7.880, 7.814, 1.437> <7.852, 7.801, 1.437> <7.954, 7.809, 1.441> <7.925, 7.819, 1.441> <7.880, 7.814, 1.441> <7.852, 7.801, 1.441> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<7.852, 7.801, 1.428> <7.498, 7.624, 1.424> <7.026, 7.388, 1.428> <6.673, 7.211, 1.428> <7.883, 7.804, 1.428> <7.529, 7.627, 1.424> <7.434, 7.548, 1.428> <7.080, 7.371, 1.428> <7.925, 7.819, 1.428> <7.954, 7.809, 1.428> <7.600, 7.603, 1.428> <7.623, 7.584, 1.428> <7.954, 7.809, 1.428> <7.983, 7.800, 1.428> <8.008, 7.763, 1.428> <8.031, 7.743, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<7.852, 7.801, 1.428> <7.498, 7.624, 1.424> <7.026, 7.388, 1.428> <6.673, 7.211, 1.428> <7.856, 7.803, 1.428> <7.502, 7.626, 1.424> <7.025, 7.392, 1.428> <6.671, 7.215, 1.428> <7.852, 7.801, 1.437> <7.494, 7.634, 1.437> <7.023, 7.387, 1.444> <6.669, 7.210, 1.441> <7.852, 7.801, 1.441> <7.494, 7.634, 1.441> <7.026, 7.388, 1.444> <6.673, 7.211, 1.441> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.673, 7.211, 1.428> <6.562, 7.108, 1.428> <6.237, 7.001, 1.428> <6.305, 6.867, 1.428> <6.614, 7.256, 1.428> <6.504, 7.153, 1.428> <6.207, 7.059, 1.428> <6.276, 6.925, 1.428> <6.499, 7.271, 1.428> <6.437, 7.251, 1.428> <6.288, 7.083, 1.428> <6.268, 7.021, 1.428> <6.429, 7.248, 1.428> <6.367, 7.227, 1.428> <6.308, 7.145, 1.428> <6.288, 7.083, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.305, 6.867, 1.428> <6.374, 6.732, 1.428> <6.665, 6.893, 1.428> <6.800, 6.961, 1.428> <6.335, 6.809, 1.428> <6.403, 6.674, 1.428> <6.631, 6.827, 1.428> <6.766, 6.896, 1.428> <6.408, 6.746, 1.428> <6.470, 6.726, 1.428> <6.694, 6.748, 1.428> <6.747, 6.786, 1.428> <6.470, 6.726, 1.428> <6.532, 6.706, 1.428> <6.633, 6.705, 1.428> <6.686, 6.743, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.039, 7.642, 1.428> <8.039, 7.642, 1.432> <8.039, 7.642, 1.437> <8.039, 7.642, 1.441> <8.030, 7.613, 1.428> <8.030, 7.613, 1.432> <8.030, 7.613, 1.437> <8.030, 7.613, 1.441> <7.993, 7.588, 1.428> <7.996, 7.589, 1.428> <8.000, 7.579, 1.437> <8.000, 7.579, 1.441> <7.973, 7.564, 1.428> <7.976, 7.566, 1.428> <7.973, 7.564, 1.437> <7.973, 7.564, 1.441> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.031, 7.743, 1.428> <8.031, 7.743, 1.432> <8.031, 7.743, 1.437> <8.031, 7.743, 1.441> <8.033, 7.713, 1.428> <8.033, 7.713, 1.432> <8.033, 7.713, 1.437> <8.033, 7.713, 1.441> <8.048, 7.671, 1.428> <8.048, 7.671, 1.432> <8.048, 7.671, 1.437> <8.048, 7.671, 1.441> <8.039, 7.642, 1.428> <8.039, 7.642, 1.432> <8.039, 7.642, 1.437> <8.039, 7.642, 1.441> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<7.954, 7.809, 1.428> <7.954, 7.809, 1.432> <7.954, 7.809, 1.437> <7.954, 7.809, 1.441> <7.983, 7.800, 1.428> <7.983, 7.800, 1.432> <7.983, 7.800, 1.437> <7.983, 7.800, 1.441> <8.008, 7.763, 1.428> <8.008, 7.763, 1.432> <8.008, 7.763, 1.437> <8.008, 7.763, 1.441> <8.031, 7.743, 1.428> <8.031, 7.743, 1.432> <8.031, 7.743, 1.437> <8.031, 7.743, 1.441> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.800, 6.961, 1.428> <6.798, 7.045, 1.428> <6.739, 7.160, 1.428> <6.673, 7.211, 1.428> <6.802, 6.958, 1.428> <6.799, 7.042, 1.428> <6.738, 7.163, 1.428> <6.671, 7.215, 1.428> <6.797, 6.960, 1.441> <6.794, 7.044, 1.441> <6.736, 7.158, 1.441> <6.669, 7.210, 1.441> <6.800, 6.961, 1.441> <6.798, 7.045, 1.441> <6.739, 7.160, 1.441> <6.673, 7.211, 1.441> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.673, 7.211, 1.441> <6.614, 7.256, 1.441> <6.499, 7.271, 1.441> <6.429, 7.248, 1.441> <6.669, 7.210, 1.441> <6.611, 7.255, 1.441> <6.499, 7.271, 1.437> <6.429, 7.248, 1.437> <6.671, 7.215, 1.428> <6.598, 7.226, 1.428> <6.499, 7.271, 1.432> <6.429, 7.248, 1.432> <6.673, 7.211, 1.428> <6.600, 7.222, 1.428> <6.499, 7.271, 1.428> <6.429, 7.248, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.429, 7.248, 1.441> <6.367, 7.227, 1.441> <6.308, 7.145, 1.441> <6.288, 7.083, 1.441> <6.429, 7.248, 1.437> <6.367, 7.227, 1.437> <6.308, 7.145, 1.437> <6.288, 7.083, 1.437> <6.429, 7.248, 1.432> <6.367, 7.227, 1.432> <6.308, 7.145, 1.432> <6.288, 7.083, 1.432> <6.429, 7.248, 1.428> <6.367, 7.227, 1.428> <6.308, 7.145, 1.428> <6.288, 7.083, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.288, 7.083, 1.441> <6.268, 7.021, 1.441> <6.276, 6.925, 1.441> <6.305, 6.867, 1.441> <6.288, 7.083, 1.437> <6.268, 7.021, 1.437> <6.276, 6.925, 1.437> <6.305, 6.867, 1.437> <6.288, 7.083, 1.432> <6.268, 7.021, 1.432> <6.276, 6.925, 1.432> <6.305, 6.867, 1.432> <6.288, 7.083, 1.428> <6.268, 7.021, 1.428> <6.276, 6.925, 1.428> <6.305, 6.867, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.305, 6.867, 1.441> <6.335, 6.809, 1.441> <6.408, 6.746, 1.441> <6.470, 6.726, 1.441> <6.305, 6.867, 1.437> <6.335, 6.809, 1.437> <6.408, 6.746, 1.437> <6.470, 6.726, 1.437> <6.305, 6.867, 1.432> <6.335, 6.809, 1.432> <6.408, 6.746, 1.432> <6.470, 6.726, 1.432> <6.305, 6.867, 1.428> <6.335, 6.809, 1.428> <6.408, 6.746, 1.428> <6.470, 6.726, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.470, 6.726, 1.441> <6.532, 6.706, 1.441> <6.633, 6.705, 1.441> <6.686, 6.743, 1.441> <6.470, 6.726, 1.437> <6.532, 6.706, 1.437> <6.633, 6.705, 1.437> <6.686, 6.743, 1.437> <6.470, 6.726, 1.432> <6.532, 6.706, 1.432> <6.633, 6.705, 1.432> <6.686, 6.743, 1.432> <6.470, 6.726, 1.428> <6.532, 6.706, 1.428> <6.633, 6.705, 1.428> <6.686, 6.743, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.686, 6.743, 1.441> <6.747, 6.786, 1.441> <6.802, 6.887, 1.441> <6.800, 6.961, 1.441> <6.686, 6.743, 1.437> <6.747, 6.786, 1.437> <6.799, 6.886, 1.441> <6.797, 6.960, 1.441> <6.686, 6.743, 1.432> <6.747, 6.786, 1.432> <6.768, 6.892, 1.428> <6.802, 6.958, 1.428> <6.686, 6.743, 1.428> <6.747, 6.786, 1.428> <6.766, 6.896, 1.428> <6.800, 6.961, 1.428> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<7.973, 7.564, 1.428> <7.976, 7.566, 1.428> <7.973, 7.564, 1.437> <7.973, 7.564, 1.441> <7.621, 7.383, 1.424> <7.624, 7.385, 1.424> <7.626, 7.374, 1.437> <7.626, 7.374, 1.441> <7.152, 7.142, 1.428> <7.154, 7.139, 1.428> <7.149, 7.140, 1.444> <7.152, 7.142, 1.444> <6.800, 6.961, 1.428> <6.802, 6.958, 1.428> <6.797, 6.960, 1.441> <6.800, 6.961, 1.441> }
      texture { hours_plastic }
      translate <-6.5,-7,0>
      rotate z*65
      rotate z*22
      translate <6.5,7,0>
    }
    //patch_minutes_hand
    union {
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.403, 7.219, 1.393> <6.333, 7.173, 1.393> <6.267, 7.063, 1.393> <6.259, 6.979, 1.393> <5.847, 7.504, 1.389> <5.777, 7.458, 1.389> <5.754, 7.420, 1.389> <5.746, 7.336, 1.389> <5.106, 7.885, 1.393> <5.618, 7.527, 1.393> <5.618, 7.527, 1.393> <5.062, 7.812, 1.393> <4.549, 8.170, 1.393> <4.549, 8.170, 1.393> <4.549, 8.170, 1.393> <4.549, 8.170, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.403, 7.219, 1.393> <6.333, 7.173, 1.393> <6.267, 7.063, 1.393> <6.259, 6.979, 1.393> <6.506, 7.108, 1.393> <6.436, 7.062, 1.393> <6.413, 7.024, 1.393> <6.405, 6.940, 1.393> <6.824, 6.979, 1.393> <6.746, 6.850, 1.393> <6.746, 6.850, 1.393> <6.668, 6.720, 1.393> <6.746, 6.850, 1.393> <6.746, 6.850, 1.393> <6.746, 6.850, 1.393> <6.746, 6.850, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.732, 8.215, 1.393> <4.702, 8.220, 1.393> <4.661, 8.238, 1.393> <4.631, 8.230, 1.393> <4.729, 8.217, 1.393> <4.698, 8.222, 1.393> <4.661, 8.238, 1.396> <4.631, 8.230, 1.396> <4.732, 8.215, 1.401> <4.705, 8.230, 1.401> <4.661, 8.238, 1.401> <4.631, 8.230, 1.401> <4.732, 8.215, 1.405> <4.705, 8.230, 1.405> <4.661, 8.238, 1.405> <4.631, 8.230, 1.405> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.631, 8.230, 1.393> <4.601, 8.223, 1.393> <4.574, 8.188, 1.393> <4.549, 8.170, 1.393> <4.661, 8.238, 1.393> <4.631, 8.230, 1.393> <5.130, 7.903, 1.393> <5.106, 7.885, 1.393> <4.702, 8.220, 1.393> <5.203, 7.921, 1.389> <5.346, 7.803, 1.389> <5.847, 7.504, 1.389> <4.732, 8.215, 1.393> <5.233, 7.916, 1.389> <5.902, 7.518, 1.393> <6.403, 7.219, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.534, 8.069, 1.393> <4.542, 8.039, 1.393> <4.577, 8.012, 1.393> <4.595, 7.987, 1.393> <4.527, 8.099, 1.393> <4.534, 8.069, 1.393> <5.076, 7.709, 1.389> <5.094, 7.685, 1.389> <4.545, 8.140, 1.393> <5.058, 7.782, 1.393> <5.247, 7.639, 1.389> <5.760, 7.281, 1.393> <4.549, 8.170, 1.393> <5.062, 7.812, 1.393> <5.746, 7.336, 1.389> <6.259, 6.979, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.259, 6.979, 1.393> <6.252, 6.905, 1.393> <6.300, 6.800, 1.393> <6.357, 6.753, 1.393> <6.405, 6.940, 1.393> <6.398, 6.867, 1.393> <6.350, 6.758, 1.393> <6.407, 6.711, 1.393> <6.668, 6.720, 1.393> <6.635, 6.664, 1.393> <6.572, 6.721, 1.393> <6.508, 6.705, 1.393> <6.746, 6.850, 1.393> <6.712, 6.794, 1.393> <6.635, 6.737, 1.393> <6.572, 6.721, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.746, 6.850, 1.393> <6.780, 6.906, 1.393> <6.794, 7.001, 1.393> <6.778, 7.064, 1.393> <6.824, 6.979, 1.393> <6.857, 7.035, 1.393> <6.778, 7.064, 1.393> <6.762, 7.128, 1.393> <6.506, 7.108, 1.393> <6.568, 7.149, 1.393> <6.641, 7.242, 1.393> <6.709, 7.214, 1.393> <6.403, 7.219, 1.393> <6.465, 7.260, 1.393> <6.581, 7.267, 1.393> <6.649, 7.239, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.649, 7.239, 1.393> <6.581, 7.267, 1.393> <6.465, 7.260, 1.393> <6.403, 7.219, 1.393> <6.649, 7.239, 1.396> <6.581, 7.267, 1.396> <6.468, 7.259, 1.393> <6.407, 7.218, 1.393> <6.649, 7.239, 1.401> <6.581, 7.267, 1.401> <6.468, 7.258, 1.405> <6.407, 7.217, 1.405> <6.649, 7.239, 1.405> <6.581, 7.267, 1.405> <6.465, 7.260, 1.405> <6.403, 7.219, 1.405> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.732, 8.215, 1.393> <5.233, 7.916, 1.389> <5.902, 7.518, 1.393> <6.403, 7.219, 1.393> <4.729, 8.217, 1.393> <5.230, 7.918, 1.389> <5.905, 7.516, 1.393> <6.407, 7.218, 1.393> <4.732, 8.215, 1.401> <5.239, 7.926, 1.401> <5.905, 7.516, 1.409> <6.407, 7.217, 1.405> <4.732, 8.215, 1.405> <5.239, 7.926, 1.405> <5.902, 7.518, 1.409> <6.403, 7.219, 1.405> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.595, 7.987, 1.393> <4.592, 7.989, 1.393> <4.595, 7.987, 1.401> <4.595, 7.987, 1.405> <5.094, 7.685, 1.389> <5.091, 7.687, 1.389> <5.088, 7.675, 1.401> <5.088, 7.675, 1.405> <5.760, 7.281, 1.393> <5.763, 7.279, 1.393> <5.763, 7.279, 1.409> <5.760, 7.281, 1.409> <6.259, 6.979, 1.393> <6.262, 6.977, 1.393> <6.262, 6.977, 1.405> <6.259, 6.979, 1.405> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.403, 7.219, 1.405> <6.333, 7.173, 1.405> <6.267, 7.063, 1.405> <6.259, 6.979, 1.405> <6.407, 7.217, 1.405> <6.337, 7.171, 1.405> <6.270, 7.061, 1.405> <6.262, 6.977, 1.405> <6.407, 7.218, 1.393> <6.337, 7.171, 1.393> <6.270, 7.060, 1.393> <6.262, 6.977, 1.393> <6.403, 7.219, 1.393> <6.333, 7.173, 1.393> <6.267, 7.063, 1.393> <6.259, 6.979, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.259, 6.979, 1.405> <6.252, 6.905, 1.405> <6.300, 6.800, 1.405> <6.357, 6.753, 1.405> <6.262, 6.977, 1.405> <6.255, 6.903, 1.405> <6.300, 6.800, 1.401> <6.357, 6.753, 1.401> <6.262, 6.977, 1.393> <6.255, 6.903, 1.393> <6.300, 6.800, 1.396> <6.357, 6.753, 1.396> <6.259, 6.979, 1.393> <6.252, 6.905, 1.393> <6.300, 6.800, 1.393> <6.357, 6.753, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.357, 6.753, 1.405> <6.407, 6.711, 1.405> <6.508, 6.705, 1.405> <6.572, 6.721, 1.405> <6.357, 6.753, 1.401> <6.407, 6.711, 1.401> <6.508, 6.705, 1.401> <6.572, 6.721, 1.401> <6.357, 6.753, 1.396> <6.407, 6.711, 1.396> <6.508, 6.705, 1.396> <6.572, 6.721, 1.396> <6.357, 6.753, 1.393> <6.407, 6.711, 1.393> <6.508, 6.705, 1.393> <6.572, 6.721, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.572, 6.721, 1.405> <6.635, 6.737, 1.405> <6.712, 6.794, 1.405> <6.746, 6.850, 1.405> <6.572, 6.721, 1.401> <6.635, 6.737, 1.401> <6.712, 6.794, 1.401> <6.746, 6.850, 1.401> <6.572, 6.721, 1.396> <6.635, 6.737, 1.396> <6.712, 6.794, 1.396> <6.746, 6.850, 1.396> <6.572, 6.721, 1.393> <6.635, 6.737, 1.393> <6.712, 6.794, 1.393> <6.746, 6.850, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.746, 6.850, 1.405> <6.780, 6.906, 1.405> <6.794, 7.001, 1.405> <6.778, 7.064, 1.405> <6.746, 6.850, 1.401> <6.780, 6.906, 1.401> <6.794, 7.001, 1.401> <6.778, 7.064, 1.401> <6.746, 6.850, 1.396> <6.780, 6.906, 1.396> <6.794, 7.001, 1.396> <6.778, 7.064, 1.396> <6.746, 6.850, 1.393> <6.780, 6.906, 1.393> <6.794, 7.001, 1.393> <6.778, 7.064, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.778, 7.064, 1.405> <6.762, 7.128, 1.405> <6.709, 7.214, 1.405> <6.649, 7.239, 1.405> <6.778, 7.064, 1.401> <6.762, 7.128, 1.401> <6.709, 7.214, 1.401> <6.649, 7.239, 1.401> <6.778, 7.064, 1.396> <6.762, 7.128, 1.396> <6.709, 7.214, 1.396> <6.649, 7.239, 1.396> <6.778, 7.064, 1.393> <6.762, 7.128, 1.393> <6.709, 7.214, 1.393> <6.649, 7.239, 1.393> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.631, 8.230, 1.393> <4.631, 8.230, 1.396> <4.631, 8.230, 1.401> <4.631, 8.230, 1.405> <4.601, 8.223, 1.393> <4.601, 8.223, 1.396> <4.601, 8.223, 1.401> <4.601, 8.223, 1.405> <4.574, 8.188, 1.393> <4.574, 8.188, 1.396> <4.574, 8.188, 1.401> <4.574, 8.188, 1.405> <4.549, 8.170, 1.393> <4.549, 8.170, 1.396> <4.549, 8.170, 1.401> <4.549, 8.170, 1.405> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.549, 8.170, 1.393> <4.549, 8.170, 1.396> <4.549, 8.170, 1.401> <4.549, 8.170, 1.405> <4.545, 8.140, 1.393> <4.545, 8.140, 1.396> <4.545, 8.140, 1.401> <4.545, 8.140, 1.405> <4.527, 8.099, 1.393> <4.527, 8.099, 1.396> <4.527, 8.099, 1.401> <4.527, 8.099, 1.405> <4.534, 8.069, 1.393> <4.534, 8.069, 1.396> <4.534, 8.069, 1.401> <4.534, 8.069, 1.405> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.534, 8.069, 1.393> <4.534, 8.069, 1.396> <4.534, 8.069, 1.401> <4.534, 8.069, 1.405> <4.542, 8.039, 1.393> <4.542, 8.039, 1.396> <4.542, 8.039, 1.401> <4.542, 8.039, 1.405> <4.577, 8.012, 1.393> <4.573, 8.014, 1.393> <4.569, 8.004, 1.401> <4.569, 8.004, 1.405> <4.595, 7.987, 1.393> <4.592, 7.989, 1.393> <4.595, 7.987, 1.401> <4.595, 7.987, 1.405> }
      texture { hours_plastic }
      translate <-6.5,-7,0>
      rotate z*-58
      rotate z*-110
      translate <6.5,7,0>
    }
    //patch_alarm_hand
    union {
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.750, 6.894, 1.481> <6.611, 6.947, 1.481> <6.358, 7.201, 1.481> <6.286, 7.071, 1.481> <6.751, 6.852, 1.481> <6.612, 6.905, 1.481> <6.286, 7.071, 1.481> <6.214, 6.941, 1.481> <6.718, 6.793, 1.481> <6.599, 6.882, 1.481> <6.599, 6.882, 1.481> <6.563, 6.861, 1.481> <6.682, 6.771, 1.481> <6.682, 6.771, 1.481> <6.682, 6.771, 1.481> <6.682, 6.771, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.682, 6.771, 1.481> <6.718, 6.793, 1.481> <6.751, 6.852, 1.481> <6.750, 6.894, 1.481> <7.125, 6.550, 1.477> <7.161, 6.571, 1.477> <7.173, 6.594, 1.477> <7.172, 6.636, 1.477> <7.715, 6.254, 1.481> <7.293, 6.513, 1.481> <7.293, 6.513, 1.481> <7.736, 6.291, 1.481> <8.158, 6.033, 1.481> <8.158, 6.033, 1.481> <8.158, 6.033, 1.481> <8.158, 6.033, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.011, 6.039, 1.481> <8.038, 6.030, 1.481> <8.073, 6.012, 1.481> <8.102, 6.011, 1.481> <7.612, 6.258, 1.481> <7.639, 6.250, 1.481> <8.091, 6.011, 1.481> <8.120, 6.010, 1.481> <7.080, 6.551, 1.481> <7.523, 6.330, 1.477> <7.698, 6.248, 1.481> <8.141, 6.026, 1.481> <6.682, 6.771, 1.481> <7.125, 6.550, 1.477> <7.715, 6.254, 1.481> <8.158, 6.033, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.158, 6.033, 1.481> <8.155, 6.051, 1.481> <8.157, 6.078, 1.481> <8.147, 6.093, 1.481> <7.736, 6.291, 1.481> <7.732, 6.309, 1.481> <8.141, 6.101, 1.481> <8.131, 6.116, 1.481> <7.172, 6.636, 1.477> <7.570, 6.414, 1.477> <7.699, 6.358, 1.481> <8.097, 6.136, 1.481> <6.750, 6.894, 1.481> <7.147, 6.672, 1.481> <7.678, 6.377, 1.481> <8.075, 6.155, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.147, 6.093, 1.481> <8.131, 6.116, 1.481> <8.097, 6.136, 1.481> <8.075, 6.155, 1.481> <8.147, 6.093, 1.481> <8.131, 6.116, 1.481> <8.097, 6.136, 1.481> <8.075, 6.155, 1.481> <8.147, 6.093, 1.481> <8.131, 6.116, 1.481> <8.097, 6.136, 1.481> <8.075, 6.155, 1.481> <8.147, 6.093, 1.481> <8.131, 6.116, 1.481> <8.097, 6.136, 1.481> <8.075, 6.155, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.075, 6.155, 1.493> <8.075, 6.155, 1.489> <8.075, 6.155, 1.484> <8.075, 6.155, 1.481> <8.100, 6.141, 1.493> <8.100, 6.141, 1.489> <8.097, 6.136, 1.484> <8.097, 6.136, 1.481> <8.131, 6.116, 1.493> <8.131, 6.116, 1.489> <8.131, 6.116, 1.484> <8.131, 6.116, 1.481> <8.147, 6.093, 1.493> <8.147, 6.093, 1.489> <8.147, 6.093, 1.484> <8.147, 6.093, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.750, 6.894, 1.481> <6.611, 6.947, 1.481> <6.358, 7.201, 1.481> <6.286, 7.071, 1.481> <6.747, 6.983, 1.481> <6.608, 7.036, 1.481> <6.390, 7.258, 1.481> <6.318, 7.128, 1.481> <6.733, 7.116, 1.481> <6.688, 7.164, 1.481> <6.456, 7.206, 1.481> <6.393, 7.188, 1.481> <6.671, 7.181, 1.481> <6.627, 7.229, 1.481> <6.518, 7.224, 1.481> <6.456, 7.206, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.286, 7.071, 1.481> <6.214, 6.941, 1.481> <6.563, 6.861, 1.481> <6.682, 6.771, 1.481> <6.254, 7.014, 1.481> <6.182, 6.884, 1.481> <6.486, 6.816, 1.481> <6.605, 6.726, 1.481> <6.244, 6.918, 1.481> <6.262, 6.855, 1.481> <6.420, 6.681, 1.481> <6.484, 6.668, 1.481> <6.262, 6.855, 1.481> <6.279, 6.793, 1.481> <6.333, 6.698, 1.481> <6.397, 6.685, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.682, 6.771, 1.481> <6.718, 6.793, 1.481> <6.751, 6.852, 1.481> <6.750, 6.894, 1.481> <6.678, 6.773, 1.481> <6.715, 6.794, 1.481> <6.748, 6.854, 1.481> <6.746, 6.896, 1.481> <6.678, 6.773, 1.493> <6.715, 6.794, 1.493> <6.747, 6.854, 1.493> <6.746, 6.896, 1.493> <6.682, 6.771, 1.493> <6.718, 6.793, 1.493> <6.751, 6.852, 1.493> <6.750, 6.894, 1.493> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.011, 6.039, 1.481> <8.038, 6.030, 1.481> <8.073, 6.012, 1.481> <8.102, 6.011, 1.481> <8.011, 6.039, 1.481> <8.038, 6.030, 1.481> <8.073, 6.012, 1.481> <8.102, 6.011, 1.481> <8.011, 6.039, 1.481> <8.038, 6.030, 1.481> <8.073, 6.012, 1.481> <8.102, 6.011, 1.481> <8.011, 6.039, 1.481> <8.038, 6.030, 1.481> <8.073, 6.012, 1.481> <8.102, 6.011, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.102, 6.011, 1.481> <8.120, 6.010, 1.481> <8.141, 6.026, 1.481> <8.158, 6.033, 1.481> <8.102, 6.011, 1.481> <8.120, 6.010, 1.481> <8.141, 6.026, 1.481> <8.158, 6.033, 1.481> <8.102, 6.011, 1.481> <8.120, 6.010, 1.481> <8.141, 6.026, 1.481> <8.158, 6.033, 1.481> <8.102, 6.011, 1.481> <8.120, 6.010, 1.481> <8.141, 6.026, 1.481> <8.158, 6.033, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.158, 6.033, 1.481> <8.155, 6.051, 1.481> <8.157, 6.078, 1.481> <8.147, 6.093, 1.481> <8.158, 6.033, 1.481> <8.155, 6.051, 1.481> <8.157, 6.078, 1.481> <8.147, 6.093, 1.481> <8.158, 6.033, 1.481> <8.155, 6.051, 1.481> <8.157, 6.078, 1.481> <8.147, 6.093, 1.481> <8.158, 6.033, 1.481> <8.155, 6.051, 1.481> <8.157, 6.078, 1.481> <8.147, 6.093, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.102, 6.011, 1.481> <8.102, 6.011, 1.484> <8.102, 6.011, 1.489> <8.102, 6.011, 1.493> <8.073, 6.012, 1.481> <8.073, 6.012, 1.484> <8.073, 6.012, 1.489> <8.073, 6.012, 1.493> <8.038, 6.030, 1.481> <8.038, 6.030, 1.484> <8.036, 6.025, 1.489> <8.036, 6.025, 1.493> <8.011, 6.039, 1.481> <8.011, 6.039, 1.484> <8.011, 6.039, 1.489> <8.011, 6.039, 1.493> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.158, 6.033, 1.481> <8.158, 6.033, 1.484> <8.158, 6.033, 1.489> <8.158, 6.033, 1.493> <8.141, 6.026, 1.481> <8.141, 6.026, 1.484> <8.141, 6.026, 1.489> <8.141, 6.026, 1.493> <8.120, 6.010, 1.481> <8.120, 6.010, 1.484> <8.120, 6.010, 1.489> <8.120, 6.010, 1.493> <8.102, 6.011, 1.481> <8.102, 6.011, 1.484> <8.102, 6.011, 1.489> <8.102, 6.011, 1.493> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<8.147, 6.093, 1.481> <8.147, 6.093, 1.484> <8.147, 6.093, 1.489> <8.147, 6.093, 1.493> <8.157, 6.078, 1.481> <8.157, 6.078, 1.484> <8.157, 6.078, 1.489> <8.157, 6.078, 1.493> <8.155, 6.051, 1.481> <8.155, 6.051, 1.484> <8.155, 6.051, 1.489> <8.155, 6.051, 1.493> <8.158, 6.033, 1.481> <8.158, 6.033, 1.484> <8.158, 6.033, 1.489> <8.158, 6.033, 1.493> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.750, 6.894, 1.493> <6.747, 6.983, 1.493> <6.733, 7.116, 1.493> <6.671, 7.181, 1.493> <6.746, 6.896, 1.493> <6.744, 6.985, 1.493> <6.733, 7.116, 1.489> <6.671, 7.181, 1.489> <6.746, 6.896, 1.481> <6.744, 6.985, 1.481> <6.733, 7.116, 1.484> <6.671, 7.181, 1.484> <6.750, 6.894, 1.481> <6.747, 6.983, 1.481> <6.733, 7.116, 1.481> <6.671, 7.181, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.671, 7.181, 1.493> <6.627, 7.229, 1.493> <6.518, 7.224, 1.493> <6.456, 7.206, 1.493> <6.671, 7.181, 1.489> <6.627, 7.229, 1.489> <6.518, 7.224, 1.489> <6.456, 7.206, 1.489> <6.671, 7.181, 1.484> <6.627, 7.229, 1.484> <6.518, 7.224, 1.484> <6.456, 7.206, 1.484> <6.671, 7.181, 1.481> <6.627, 7.229, 1.481> <6.518, 7.224, 1.481> <6.456, 7.206, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.456, 7.206, 1.493> <6.393, 7.188, 1.493> <6.318, 7.128, 1.493> <6.286, 7.071, 1.493> <6.456, 7.206, 1.489> <6.393, 7.188, 1.489> <6.318, 7.128, 1.489> <6.286, 7.071, 1.489> <6.456, 7.206, 1.484> <6.393, 7.188, 1.484> <6.318, 7.128, 1.484> <6.286, 7.071, 1.484> <6.456, 7.206, 1.481> <6.393, 7.188, 1.481> <6.318, 7.128, 1.481> <6.286, 7.071, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.286, 7.071, 1.493> <6.254, 7.014, 1.493> <6.244, 6.918, 1.493> <6.262, 6.855, 1.493> <6.286, 7.071, 1.489> <6.254, 7.014, 1.489> <6.244, 6.918, 1.489> <6.262, 6.855, 1.489> <6.286, 7.071, 1.484> <6.254, 7.014, 1.484> <6.244, 6.918, 1.484> <6.262, 6.855, 1.484> <6.286, 7.071, 1.481> <6.254, 7.014, 1.481> <6.244, 6.918, 1.481> <6.262, 6.855, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.262, 6.855, 1.493> <6.279, 6.793, 1.493> <6.333, 6.698, 1.493> <6.397, 6.685, 1.493> <6.262, 6.855, 1.489> <6.279, 6.793, 1.489> <6.333, 6.698, 1.489> <6.397, 6.685, 1.489> <6.262, 6.855, 1.484> <6.279, 6.793, 1.484> <6.333, 6.698, 1.484> <6.397, 6.685, 1.484> <6.262, 6.855, 1.481> <6.279, 6.793, 1.481> <6.333, 6.698, 1.481> <6.397, 6.685, 1.481> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.397, 6.685, 1.493> <6.484, 6.668, 1.493> <6.605, 6.726, 1.493> <6.682, 6.771, 1.493> <6.397, 6.685, 1.489> <6.484, 6.668, 1.489> <6.601, 6.728, 1.493> <6.678, 6.773, 1.493> <6.397, 6.685, 1.484> <6.484, 6.668, 1.484> <6.601, 6.727, 1.481> <6.678, 6.773, 1.481> <6.397, 6.685, 1.481> <6.484, 6.668, 1.481> <6.605, 6.726, 1.481> <6.682, 6.771, 1.481> }
      texture { alarm_plastic }
      translate <-6.5,-7,0>
      rotate z*120
      translate <6.5,7,0>
    }
    //patch_seconds_hand
    union {
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.352, 6.749, 1.350> <6.461, 6.851, 1.350> <6.800, 6.967, 1.350> <6.715, 7.089, 1.350> <6.314, 6.767, 1.350> <6.423, 6.869, 1.350> <6.715, 7.089, 1.350> <6.629, 7.211, 1.350> <6.275, 6.822, 1.350> <6.408, 6.890, 1.350> <6.408, 6.890, 1.350> <6.405, 6.932, 1.350> <6.272, 6.864, 1.350> <6.272, 6.864, 1.350> <6.272, 6.864, 1.350> <6.272, 6.864, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.272, 6.864, 1.350> <6.275, 6.822, 1.350> <6.314, 6.767, 1.350> <6.352, 6.749, 1.350> <5.744, 6.469, 1.346> <5.748, 6.427, 1.346> <5.762, 6.406, 1.346> <5.801, 6.389, 1.346> <5.041, 5.942, 1.350> <5.592, 6.303, 1.350> <5.592, 6.303, 1.350> <5.065, 5.908, 1.350> <4.513, 5.547, 1.350> <4.513, 5.547, 1.350> <4.513, 5.547, 1.350> <4.513, 5.547, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.582, 5.677, 1.350> <4.563, 5.656, 1.350> <4.531, 5.633, 1.350> <4.517, 5.608, 1.350> <5.089, 6.033, 1.346> <5.070, 6.012, 1.346> <4.522, 5.617, 1.350> <4.509, 5.591, 1.350> <5.765, 6.508, 1.350> <5.237, 6.113, 1.346> <5.042, 5.960, 1.350> <4.514, 5.565, 1.350> <6.272, 6.864, 1.350> <5.744, 6.469, 1.346> <5.041, 5.942, 1.350> <4.513, 5.547, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.513, 5.547, 1.350> <4.530, 5.542, 1.350> <4.553, 5.528, 1.350> <4.571, 5.531, 1.350> <5.065, 5.908, 1.350> <5.082, 5.903, 1.350> <4.581, 5.532, 1.350> <4.600, 5.535, 1.350> <5.801, 6.389, 1.346> <5.292, 6.034, 1.346> <5.141, 5.911, 1.346> <4.632, 5.557, 1.350> <6.352, 6.749, 1.350> <5.844, 6.395, 1.350> <5.167, 5.922, 1.346> <4.659, 5.568, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.571, 5.531, 1.350> <4.600, 5.535, 1.350> <4.632, 5.557, 1.350> <4.659, 5.568, 1.350> <4.571, 5.531, 1.354> <4.600, 5.535, 1.354> <4.629, 5.555, 1.350> <4.656, 5.566, 1.350> <4.571, 5.531, 1.359> <4.600, 5.535, 1.359> <4.635, 5.552, 1.359> <4.659, 5.568, 1.359> <4.571, 5.531, 1.363> <4.600, 5.535, 1.363> <4.635, 5.552, 1.363> <4.659, 5.568, 1.363> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.659, 5.568, 1.350> <5.167, 5.922, 1.346> <5.844, 6.395, 1.350> <6.352, 6.749, 1.350> <4.656, 5.566, 1.350> <5.164, 5.920, 1.346> <5.847, 6.397, 1.350> <6.356, 6.752, 1.350> <4.659, 5.568, 1.359> <5.170, 5.918, 1.359> <5.847, 6.397, 1.366> <6.356, 6.752, 1.363> <4.659, 5.568, 1.363> <5.170, 5.918, 1.363> <5.844, 6.395, 1.366> <6.352, 6.749, 1.363> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.352, 6.749, 1.350> <6.461, 6.851, 1.350> <6.800, 6.967, 1.350> <6.715, 7.089, 1.350> <6.434, 6.712, 1.350> <6.542, 6.814, 1.350> <6.837, 6.913, 1.350> <6.752, 7.035, 1.350> <6.560, 6.667, 1.350> <6.622, 6.687, 1.350> <6.761, 6.877, 1.350> <6.773, 6.941, 1.350> <6.645, 6.694, 1.350> <6.707, 6.713, 1.350> <6.750, 6.813, 1.350> <6.761, 6.877, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.715, 7.089, 1.350> <6.629, 7.211, 1.350> <6.405, 6.932, 1.350> <6.272, 6.864, 1.350> <6.677, 7.142, 1.350> <6.592, 7.264, 1.350> <6.398, 7.021, 1.350> <6.265, 6.953, 1.350> <6.596, 7.194, 1.350> <6.532, 7.205, 1.350> <6.305, 7.139, 1.350> <6.266, 7.087, 1.350> <6.532, 7.205, 1.350> <6.467, 7.216, 1.350> <6.359, 7.210, 1.350> <6.320, 7.158, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.582, 5.677, 1.350> <4.579, 5.675, 1.350> <4.582, 5.677, 1.359> <4.582, 5.677, 1.363> <5.089, 6.033, 1.346> <5.086, 6.031, 1.346> <5.086, 6.038, 1.359> <5.086, 6.038, 1.363> <5.765, 6.508, 1.350> <5.768, 6.510, 1.350> <5.768, 6.510, 1.366> <5.765, 6.508, 1.366> <6.272, 6.864, 1.350> <6.275, 6.867, 1.350> <6.275, 6.867, 1.363> <6.272, 6.864, 1.363> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.272, 6.864, 1.350> <6.275, 6.822, 1.350> <6.314, 6.767, 1.350> <6.352, 6.749, 1.350> <6.275, 6.867, 1.350> <6.278, 6.825, 1.350> <6.317, 6.769, 1.350> <6.356, 6.752, 1.350> <6.275, 6.867, 1.363> <6.278, 6.825, 1.363> <6.317, 6.769, 1.363> <6.356, 6.752, 1.363> <6.272, 6.864, 1.363> <6.275, 6.822, 1.363> <6.314, 6.767, 1.363> <6.352, 6.749, 1.363> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.352, 6.749, 1.363> <6.434, 6.712, 1.363> <6.560, 6.667, 1.363> <6.645, 6.694, 1.363> <6.356, 6.752, 1.363> <6.437, 6.714, 1.363> <6.560, 6.667, 1.359> <6.645, 6.694, 1.359> <6.356, 6.752, 1.350> <6.437, 6.714, 1.350> <6.560, 6.667, 1.354> <6.645, 6.694, 1.354> <6.352, 6.749, 1.350> <6.434, 6.712, 1.350> <6.560, 6.667, 1.350> <6.645, 6.694, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.645, 6.694, 1.363> <6.707, 6.713, 1.363> <6.750, 6.813, 1.363> <6.761, 6.877, 1.363> <6.645, 6.694, 1.359> <6.707, 6.713, 1.359> <6.750, 6.813, 1.359> <6.761, 6.877, 1.359> <6.645, 6.694, 1.354> <6.707, 6.713, 1.354> <6.750, 6.813, 1.354> <6.761, 6.877, 1.354> <6.645, 6.694, 1.350> <6.707, 6.713, 1.350> <6.750, 6.813, 1.350> <6.761, 6.877, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.761, 6.877, 1.363> <6.773, 6.941, 1.363> <6.752, 7.035, 1.363> <6.715, 7.089, 1.363> <6.761, 6.877, 1.359> <6.773, 6.941, 1.359> <6.752, 7.035, 1.359> <6.715, 7.089, 1.359> <6.761, 6.877, 1.354> <6.773, 6.941, 1.354> <6.752, 7.035, 1.354> <6.715, 7.089, 1.354> <6.761, 6.877, 1.350> <6.773, 6.941, 1.350> <6.752, 7.035, 1.350> <6.715, 7.089, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.715, 7.089, 1.363> <6.677, 7.142, 1.363> <6.596, 7.194, 1.363> <6.532, 7.205, 1.363> <6.715, 7.089, 1.359> <6.677, 7.142, 1.359> <6.596, 7.194, 1.359> <6.532, 7.205, 1.359> <6.715, 7.089, 1.354> <6.677, 7.142, 1.354> <6.596, 7.194, 1.354> <6.532, 7.205, 1.354> <6.715, 7.089, 1.350> <6.677, 7.142, 1.350> <6.596, 7.194, 1.350> <6.532, 7.205, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.532, 7.205, 1.363> <6.467, 7.216, 1.363> <6.359, 7.210, 1.363> <6.320, 7.158, 1.363> <6.532, 7.205, 1.359> <6.467, 7.216, 1.359> <6.359, 7.210, 1.359> <6.320, 7.158, 1.359> <6.532, 7.205, 1.354> <6.467, 7.216, 1.354> <6.359, 7.210, 1.354> <6.320, 7.158, 1.354> <6.532, 7.205, 1.350> <6.467, 7.216, 1.350> <6.359, 7.210, 1.350> <6.320, 7.158, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<6.320, 7.158, 1.363> <6.266, 7.087, 1.363> <6.265, 6.953, 1.363> <6.272, 6.864, 1.363> <6.320, 7.158, 1.359> <6.266, 7.087, 1.359> <6.268, 6.956, 1.363> <6.275, 6.867, 1.363> <6.320, 7.158, 1.354> <6.266, 7.087, 1.354> <6.268, 6.956, 1.350> <6.275, 6.867, 1.350> <6.320, 7.158, 1.350> <6.266, 7.087, 1.350> <6.265, 6.953, 1.350> <6.272, 6.864, 1.350> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.517, 5.608, 1.350> <4.517, 5.608, 1.354> <4.517, 5.608, 1.359> <4.517, 5.608, 1.363> <4.531, 5.633, 1.350> <4.531, 5.633, 1.354> <4.531, 5.633, 1.359> <4.531, 5.633, 1.363> <4.563, 5.656, 1.350> <4.560, 5.654, 1.350> <4.559, 5.660, 1.359> <4.559, 5.660, 1.363> <4.582, 5.677, 1.350> <4.579, 5.675, 1.350> <4.582, 5.677, 1.359> <4.582, 5.677, 1.363> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.513, 5.547, 1.350> <4.513, 5.547, 1.354> <4.513, 5.547, 1.359> <4.513, 5.547, 1.363> <4.514, 5.565, 1.350> <4.514, 5.565, 1.354> <4.514, 5.565, 1.359> <4.514, 5.565, 1.363> <4.509, 5.591, 1.350> <4.509, 5.591, 1.354> <4.509, 5.591, 1.359> <4.509, 5.591, 1.363> <4.517, 5.608, 1.350> <4.517, 5.608, 1.354> <4.517, 5.608, 1.359> <4.517, 5.608, 1.363> }
      bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<4.571, 5.531, 1.350> <4.571, 5.531, 1.354> <4.571, 5.531, 1.359> <4.571, 5.531, 1.363> <4.553, 5.528, 1.350> <4.553, 5.528, 1.354> <4.553, 5.528, 1.359> <4.553, 5.528, 1.363> <4.530, 5.542, 1.350> <4.530, 5.542, 1.354> <4.530, 5.542, 1.359> <4.530, 5.542, 1.363> <4.513, 5.547, 1.350> <4.513, 5.547, 1.354> <4.513, 5.547, 1.359> <4.513, 5.547, 1.363> }
      texture { seconds_plastic }
      translate <-6.5,-7,0>
      rotate z*-125
      rotate z*-55
      translate <6.5,7,0>
    }
    translate y*-7
    rotate x*20
    translate y*7
  }
  //patch_base
  union {
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.523, 7.008, 2.758> <2.523, 6.602, 2.758> <2.523, 6.263, 2.420> <2.523, 6.263, 2.013> <2.523, 7.415, 2.758> <2.523, 7.008, 2.758> <2.523, 6.710, 2.420> <2.523, 6.710, 2.013> <2.523, 7.754, 2.420> <2.523, 7.306, 2.420> <2.523, 7.306, 2.420> <2.523, 7.306, 2.013> <2.523, 7.754, 2.013> <2.523, 7.754, 2.013> <2.523, 7.754, 2.013> <2.523, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.523, 6.263, 2.013> <2.523, 6.263, 1.606> <2.523, 6.602, 1.268> <2.523, 7.008, 1.268> <2.523, 6.710, 2.013> <2.523, 6.710, 1.606> <2.523, 7.008, 1.268> <2.523, 7.415, 1.268> <2.523, 7.306, 2.013> <2.523, 7.306, 1.606> <2.523, 7.306, 1.606> <2.523, 7.754, 1.606> <2.523, 7.754, 2.013> <2.523, 7.754, 2.013> <2.523, 7.754, 2.013> <2.523, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.527, 7.008, 2.758> <0.527, 6.602, 2.758> <0.527, 6.263, 2.420> <0.527, 6.263, 2.013> <0.527, 7.415, 2.758> <0.527, 7.008, 2.758> <0.527, 6.710, 2.420> <0.527, 6.710, 2.013> <0.527, 7.754, 2.420> <0.527, 7.306, 2.420> <0.527, 7.306, 2.420> <0.527, 7.306, 2.013> <0.527, 7.754, 2.013> <0.527, 7.754, 2.013> <0.527, 7.754, 2.013> <0.527, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.527, 6.263, 2.013> <0.527, 6.263, 1.606> <0.527, 6.602, 1.268> <0.527, 7.008, 1.268> <0.527, 6.710, 2.013> <0.527, 6.710, 1.606> <0.527, 7.008, 1.268> <0.527, 7.415, 1.268> <0.527, 7.306, 2.013> <0.527, 7.306, 1.606> <0.527, 7.306, 1.606> <0.527, 7.754, 1.606> <0.527, 7.754, 2.013> <0.527, 7.754, 2.013> <0.527, 7.754, 2.013> <0.527, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<12.495, 7.008, 2.758> <12.495, 6.602, 2.758> <12.495, 6.263, 2.420> <12.495, 6.263, 2.013> <12.495, 7.415, 2.758> <12.495, 7.008, 2.758> <12.495, 6.710, 2.420> <12.495, 6.710, 2.013> <12.495, 7.754, 2.420> <12.495, 7.306, 2.420> <12.495, 7.306, 2.420> <12.495, 7.306, 2.013> <12.495, 7.754, 2.013> <12.495, 7.754, 2.013> <12.495, 7.754, 2.013> <12.495, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<12.495, 6.263, 2.013> <12.495, 6.263, 1.606> <12.495, 6.602, 1.268> <12.495, 7.008, 1.268> <12.495, 6.710, 2.013> <12.495, 6.710, 1.606> <12.495, 7.008, 1.268> <12.495, 7.415, 1.268> <12.495, 7.306, 2.013> <12.495, 7.306, 1.606> <12.495, 7.306, 1.606> <12.495, 7.754, 1.606> <12.495, 7.754, 2.013> <12.495, 7.754, 2.013> <12.495, 7.754, 2.013> <12.495, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<10.465, 7.008, 2.758> <10.465, 6.602, 2.758> <10.465, 6.263, 2.420> <10.465, 6.263, 2.013> <10.465, 7.415, 2.758> <10.465, 7.008, 2.758> <10.465, 6.710, 2.420> <10.465, 6.710, 2.013> <10.465, 7.754, 2.420> <10.465, 7.306, 2.420> <10.465, 7.306, 2.420> <10.465, 7.306, 2.013> <10.465, 7.754, 2.013> <10.465, 7.754, 2.013> <10.465, 7.754, 2.013> <10.465, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<10.465, 6.263, 2.013> <10.465, 6.263, 1.606> <10.465, 6.602, 1.268> <10.465, 7.008, 1.268> <10.465, 6.710, 2.013> <10.465, 6.710, 1.606> <10.465, 7.008, 1.268> <10.465, 7.415, 1.268> <10.465, 7.306, 2.013> <10.465, 7.306, 1.606> <10.465, 7.306, 1.606> <10.465, 7.754, 1.606> <10.465, 7.754, 2.013> <10.465, 7.754, 2.013> <10.465, 7.754, 2.013> <10.465, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.014, 7.009, 4.004> <-0.014, 4.907, 4.004> <-0.014, 2.104, 4.004> <-0.014, 0.002, 4.004> <0.497, 7.010, 4.004> <0.497, 4.908, 4.004> <0.508, 2.700, 4.004> <0.508, 0.598, 4.004> <1.178, 7.010, 4.004> <1.189, 5.504, 4.004> <1.192, 2.900, 4.004> <1.202, 1.393, 4.004> <1.689, 7.011, 4.004> <1.699, 5.505, 4.004> <1.713, 3.496, 4.004> <1.724, 1.990, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.014, 0.002, 4.004> <3.895, 0.002, 4.004> <9.108, 0.002, 4.004> <13.017, 0.002, 4.004> <0.508, 0.598, 4.004> <4.417, 0.598, 4.004> <8.576, 0.598, 4.004> <12.485, 0.598, 4.004> <1.202, 1.393, 4.004> <4.059, 1.393, 4.004> <8.920, 1.393, 4.004> <11.776, 1.393, 4.004> <1.724, 1.990, 4.004> <4.580, 1.990, 4.004> <8.388, 1.990, 4.004> <11.245, 1.990, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<13.017, 0.002, 4.004> <13.017, 2.104, 4.004> <13.017, 4.907, 4.004> <13.017, 7.009, 4.004> <12.485, 0.598, 4.004> <12.485, 2.700, 4.004> <12.496, 4.907, 4.004> <12.496, 7.009, 4.004> <11.776, 1.393, 4.004> <11.787, 2.899, 4.004> <11.790, 5.503, 4.004> <11.801, 7.009, 4.004> <11.245, 1.990, 4.004> <11.255, 3.495, 4.004> <11.269, 5.503, 4.004> <11.280, 7.009, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.280, 7.009, 4.004> <11.269, 5.503, 4.004> <11.255, 3.495, 4.004> <11.245, 1.990, 4.004> <11.280, 7.009, 2.802> <11.269, 5.503, 2.802> <11.255, 3.495, 2.802> <11.245, 1.990, 2.802> <11.280, 7.009, 1.199> <11.269, 5.503, 1.199> <11.255, 3.495, 1.199> <11.245, 1.990, 1.199> <11.280, 7.009, -0.003> <11.269, 5.503, -0.003> <11.255, 3.495, -0.003> <11.245, 1.990, -0.003> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.245, 1.990, 4.004> <8.388, 1.990, 4.004> <4.580, 1.990, 4.004> <1.724, 1.990, 4.004> <11.245, 1.990, 2.802> <8.388, 1.990, 2.802> <4.580, 1.990, 2.802> <1.724, 1.990, 2.802> <11.245, 1.990, 1.199> <8.388, 1.990, 1.199> <4.580, 1.990, 1.199> <1.724, 1.990, 1.199> <11.245, 1.990, -0.003> <8.388, 1.990, -0.003> <4.580, 1.990, -0.003> <1.724, 1.990, -0.003> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.014, 7.009, -0.003> <-0.014, 4.907, -0.003> <-0.014, 2.104, -0.003> <-0.014, 0.002, -0.003> <-0.014, 7.009, 1.199> <-0.014, 4.907, 1.199> <-0.014, 2.104, 1.199> <-0.014, 0.002, 1.199> <-0.014, 7.009, 2.802> <-0.014, 4.907, 2.802> <-0.014, 2.104, 2.802> <-0.014, 0.002, 2.802> <-0.014, 7.009, 4.004> <-0.014, 4.907, 4.004> <-0.014, 2.104, 4.004> <-0.014, 0.002, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.014, 7.009, -0.003> <-0.014, 4.907, -0.003> <-0.014, 2.104, -0.003> <-0.014, 0.002, -0.003> <0.497, 7.010, -0.003> <0.497, 4.908, -0.003> <0.508, 2.700, -0.003> <0.508, 0.598, -0.003> <1.178, 7.010, -0.003> <1.189, 5.504, -0.003> <1.192, 2.900, -0.003> <1.202, 1.393, -0.003> <1.689, 7.011, -0.003> <1.699, 5.505, -0.003> <1.713, 3.496, -0.003> <1.724, 1.990, -0.003> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.014, 0.002, -0.003> <3.895, 0.002, -0.003> <9.108, 0.002, -0.003> <13.017, 0.002, -0.003> <-0.014, 0.002, 1.199> <3.895, 0.002, 1.199> <9.108, 0.002, 1.199> <13.017, 0.002, 1.199> <-0.014, 0.002, 2.802> <3.895, 0.002, 2.802> <9.108, 0.002, 2.802> <13.017, 0.002, 2.802> <-0.014, 0.002, 4.004> <3.895, 0.002, 4.004> <9.108, 0.002, 4.004> <13.017, 0.002, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<13.017, 0.002, -0.003> <13.017, 2.104, -0.003> <13.017, 4.907, -0.003> <13.017, 7.009, -0.003> <13.017, 0.002, 1.199> <13.017, 2.104, 1.199> <13.017, 4.907, 1.199> <13.017, 7.009, 1.199> <13.017, 0.002, 2.802> <13.017, 2.104, 2.802> <13.017, 4.907, 2.802> <13.017, 7.009, 2.802> <13.017, 0.002, 4.004> <13.017, 2.104, 4.004> <13.017, 4.907, 4.004> <13.017, 7.009, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<13.017, 7.009, -0.003> <12.496, 7.009, -0.003> <11.801, 7.009, -0.003> <11.280, 7.009, -0.003> <13.017, 7.009, 1.199> <12.496, 7.009, 1.199> <11.801, 7.009, 1.199> <11.280, 7.009, 1.199> <13.017, 7.009, 2.802> <12.496, 7.009, 2.802> <11.801, 7.009, 2.802> <11.280, 7.009, 2.802> <13.017, 7.009, 4.004> <12.496, 7.009, 4.004> <11.801, 7.009, 4.004> <11.280, 7.009, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.280, 7.009, -0.003> <11.269, 5.503, -0.003> <11.255, 3.495, -0.003> <11.245, 1.990, -0.003> <11.801, 7.009, -0.003> <11.790, 5.503, -0.003> <11.787, 2.899, -0.003> <11.776, 1.393, -0.003> <12.496, 7.009, -0.003> <12.496, 4.907, -0.003> <12.485, 2.700, -0.003> <12.485, 0.598, -0.003> <13.017, 7.009, -0.003> <13.017, 4.907, -0.003> <13.017, 2.104, -0.003> <13.017, 0.002, -0.003> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<11.245, 1.990, -0.003> <8.388, 1.990, -0.003> <4.580, 1.990, -0.003> <1.724, 1.990, -0.003> <11.776, 1.393, -0.003> <8.920, 1.393, -0.003> <4.059, 1.393, -0.003> <1.202, 1.393, -0.003> <12.485, 0.598, -0.003> <8.576, 0.598, -0.003> <4.417, 0.598, -0.003> <0.508, 0.598, -0.003> <13.017, 0.002, -0.003> <9.108, 0.002, -0.003> <3.895, 0.002, -0.003> <-0.014, 0.002, -0.003> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.724, 1.990, -0.003> <1.713, 3.496, -0.003> <1.699, 5.505, -0.003> <1.689, 7.011, -0.003> <1.724, 1.990, 1.199> <1.713, 3.496, 1.199> <1.699, 5.505, 1.199> <1.689, 7.011, 1.199> <1.724, 1.990, 2.802> <1.713, 3.496, 2.802> <1.699, 5.505, 2.802> <1.689, 7.011, 2.802> <1.724, 1.990, 4.004> <1.713, 3.496, 4.004> <1.699, 5.505, 4.004> <1.689, 7.011, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.689, 7.011, -0.003> <1.178, 7.010, -0.003> <0.497, 7.010, -0.003> <-0.014, 7.009, -0.003> <1.689, 7.011, 1.199> <1.178, 7.010, 1.199> <0.497, 7.010, 1.199> <-0.014, 7.009, 1.199> <1.689, 7.011, 2.802> <1.178, 7.010, 2.802> <0.497, 7.010, 2.802> <-0.014, 7.009, 2.802> <1.689, 7.011, 4.004> <1.178, 7.010, 4.004> <0.497, 7.010, 4.004> <-0.014, 7.009, 4.004> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.523, 6.263, 2.013> <2.523, 6.263, 1.606> <2.523, 6.602, 1.268> <2.523, 7.008, 1.268> <1.924, 6.263, 2.013> <1.924, 6.263, 1.606> <1.924, 6.602, 1.268> <1.924, 7.008, 1.268> <1.126, 6.263, 2.013> <1.126, 6.263, 1.606> <1.126, 6.602, 1.268> <1.126, 7.008, 1.268> <0.527, 6.263, 2.013> <0.527, 6.263, 1.606> <0.527, 6.602, 1.268> <0.527, 7.008, 1.268> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.523, 7.008, 1.268> <2.523, 7.415, 1.268> <2.523, 7.754, 1.606> <2.523, 7.754, 2.013> <1.924, 7.008, 1.268> <1.924, 7.415, 1.268> <1.924, 7.754, 1.606> <1.924, 7.754, 2.013> <1.126, 7.008, 1.268> <1.126, 7.415, 1.268> <1.126, 7.754, 1.606> <1.126, 7.754, 2.013> <0.527, 7.008, 1.268> <0.527, 7.415, 1.268> <0.527, 7.754, 1.606> <0.527, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.523, 7.754, 2.013> <2.523, 7.754, 2.420> <2.523, 7.415, 2.758> <2.523, 7.008, 2.758> <1.924, 7.754, 2.013> <1.924, 7.754, 2.420> <1.924, 7.415, 2.758> <1.924, 7.008, 2.758> <1.126, 7.754, 2.013> <1.126, 7.754, 2.420> <1.126, 7.415, 2.758> <1.126, 7.008, 2.758> <0.527, 7.754, 2.013> <0.527, 7.754, 2.420> <0.527, 7.415, 2.758> <0.527, 7.008, 2.758> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.527, 7.008, 2.758> <0.527, 6.602, 2.758> <0.527, 6.263, 2.420> <0.527, 6.263, 2.013> <1.126, 7.008, 2.758> <1.126, 6.602, 2.758> <1.126, 6.263, 2.420> <1.126, 6.263, 2.013> <1.924, 7.008, 2.758> <1.924, 6.602, 2.758> <1.924, 6.263, 2.420> <1.924, 6.263, 2.013> <2.523, 7.008, 2.758> <2.523, 6.602, 2.758> <2.523, 6.263, 2.420> <2.523, 6.263, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<12.495, 6.263, 2.013> <12.495, 6.263, 1.606> <12.495, 6.602, 1.268> <12.495, 7.008, 1.268> <11.886, 6.263, 2.013> <11.886, 6.263, 1.606> <11.886, 6.602, 1.268> <11.886, 7.008, 1.268> <11.074, 6.263, 2.013> <11.074, 6.263, 1.606> <11.074, 6.602, 1.268> <11.074, 7.008, 1.268> <10.465, 6.263, 2.013> <10.465, 6.263, 1.606> <10.465, 6.602, 1.268> <10.465, 7.008, 1.268> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<12.495, 7.008, 1.268> <12.495, 7.415, 1.268> <12.495, 7.754, 1.606> <12.495, 7.754, 2.013> <11.886, 7.008, 1.268> <11.886, 7.415, 1.268> <11.886, 7.754, 1.606> <11.886, 7.754, 2.013> <11.074, 7.008, 1.268> <11.074, 7.415, 1.268> <11.074, 7.754, 1.606> <11.074, 7.754, 2.013> <10.465, 7.008, 1.268> <10.465, 7.415, 1.268> <10.465, 7.754, 1.606> <10.465, 7.754, 2.013> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<12.495, 7.754, 2.013> <12.495, 7.754, 2.420> <12.495, 7.415, 2.758> <12.495, 7.008, 2.758> <11.886, 7.754, 2.013> <11.886, 7.754, 2.420> <11.886, 7.415, 2.758> <11.886, 7.008, 2.758> <11.074, 7.754, 2.013> <11.074, 7.754, 2.420> <11.074, 7.415, 2.758> <11.074, 7.008, 2.758> <10.465, 7.754, 2.013> <10.465, 7.754, 2.420> <10.465, 7.415, 2.758> <10.465, 7.008, 2.758> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<10.465, 7.008, 2.758> <10.465, 6.602, 2.758> <10.465, 6.263, 2.420> <10.465, 6.263, 2.013> <11.074, 7.008, 2.758> <11.074, 6.602, 2.758> <11.074, 6.263, 2.420> <11.074, 6.263, 2.013> <11.886, 7.008, 2.758> <11.886, 6.602, 2.758> <11.886, 6.263, 2.420> <11.886, 6.263, 2.013> <12.495, 7.008, 2.758> <12.495, 6.602, 2.758> <12.495, 6.263, 2.420> <12.495, 6.263, 2.013> }
    texture { black_plastic }
  }
  //patch_battery
  union {
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 5.030, 0.230> <-0.098, 5.030, 0.230> <-0.230, 5.030, 0.098> <-0.230, 5.030, -0.000> <-0.000, 5.030, 0.092> <-0.098, 5.030, 0.092> <-0.230, 5.030, -0.000> <-0.230, 5.030, -0.098> <-0.000, 5.030, -0.092> <-0.098, 5.030, -0.092> <-0.098, 5.030, -0.092> <-0.098, 5.030, -0.230> <-0.000, 5.030, -0.230> <-0.000, 5.030, -0.230> <-0.000, 5.030, -0.230> <-0.000, 5.030, -0.230> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 5.030, -0.230> <0.098, 5.030, -0.230> <0.230, 5.030, -0.098> <0.230, 5.030, -0.000> <-0.000, 5.030, -0.092> <0.098, 5.030, -0.092> <0.230, 5.030, -0.000> <0.230, 5.030, 0.098> <-0.000, 5.030, 0.092> <0.098, 5.030, 0.092> <0.098, 5.030, 0.092> <0.098, 5.030, 0.230> <-0.000, 5.030, 0.230> <-0.000, 5.030, 0.230> <-0.000, 5.030, 0.230> <-0.000, 5.030, 0.230> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.011, 0.666> <-0.363, 0.011, 0.666> <-0.666, 0.032, 0.363> <-0.666, 0.032, -0.000> <-0.000, 1.467, 0.664> <-0.363, 1.467, 0.664> <-0.666, 1.482, 0.363> <-0.666, 1.482, -0.000> <-0.000, 3.408, 0.662> <-0.281, 3.408, 0.662> <-0.666, 3.415, 0.281> <-0.666, 3.416, -0.000> <-0.000, 4.865, 0.661> <-0.281, 4.865, 0.661> <-0.666, 4.865, 0.281> <-0.666, 4.866, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.666, 0.032, -0.000> <-0.666, 0.032, -0.363> <-0.363, 0.011, -0.666> <-0.000, 0.011, -0.666> <-0.666, 1.482, -0.000> <-0.666, 1.482, -0.363> <-0.363, 1.467, -0.666> <-0.000, 1.467, -0.666> <-0.666, 3.416, -0.000> <-0.666, 3.416, -0.282> <-0.282, 3.409, -0.666> <-0.000, 3.409, -0.666> <-0.666, 4.866, -0.000> <-0.666, 4.866, -0.282> <-0.282, 4.866, -0.666> <-0.000, 4.866, -0.666> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.011, -0.666> <0.363, 0.011, -0.666> <0.666, 0.032, -0.363> <0.666, 0.032, -0.000> <-0.000, 1.467, -0.666> <0.363, 1.467, -0.666> <0.666, 1.482, -0.363> <0.666, 1.482, -0.000> <-0.000, 3.409, -0.666> <0.282, 3.409, -0.666> <0.666, 3.416, -0.282> <0.666, 3.416, -0.000> <-0.000, 4.866, -0.666> <0.282, 4.866, -0.666> <0.666, 4.866, -0.282> <0.666, 4.866, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.666, 0.032, -0.000> <0.666, 0.032, 0.363> <0.363, 0.011, 0.666> <-0.000, 0.011, 0.666> <0.620, 0.032, -0.000> <0.620, 0.032, 0.363> <0.363, 0.017, 0.620> <-0.000, 0.017, 0.620> <0.558, 0.042, -0.000> <0.558, 0.042, 0.280> <0.280, 0.036, 0.559> <-0.000, 0.036, 0.559> <0.513, 0.032, -0.000> <0.513, 0.032, 0.280> <0.280, 0.032, 0.513> <-0.000, 0.032, 0.513> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.865, 0.661> <-0.281, 4.865, 0.661> <-0.666, 4.865, 0.281> <-0.666, 4.866, -0.000> <-0.000, 4.865, 0.601> <-0.281, 4.865, 0.601> <-0.605, 4.865, 0.281> <-0.605, 4.866, -0.000> <-0.000, 4.860, 0.521> <-0.196, 4.860, 0.521> <-0.523, 4.860, 0.196> <-0.523, 4.860, -0.000> <-0.000, 4.866, 0.462> <-0.196, 4.866, 0.462> <-0.462, 4.866, 0.196> <-0.462, 4.866, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.666, 4.866, -0.000> <-0.666, 4.866, -0.282> <-0.282, 4.866, -0.666> <-0.000, 4.866, -0.666> <-0.605, 4.866, -0.000> <-0.605, 4.866, -0.282> <-0.282, 4.866, -0.605> <-0.000, 4.866, -0.605> <-0.523, 4.860, -0.000> <-0.523, 4.860, -0.196> <-0.196, 4.860, -0.523> <-0.000, 4.860, -0.523> <-0.462, 4.866, -0.000> <-0.462, 4.866, -0.196> <-0.196, 4.866, -0.462> <-0.000, 4.866, -0.462> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.866, -0.666> <0.282, 4.866, -0.666> <0.666, 4.866, -0.282> <0.666, 4.866, -0.000> <-0.000, 4.866, -0.605> <0.282, 4.866, -0.605> <0.605, 4.866, -0.282> <0.605, 4.866, -0.000> <-0.000, 4.860, -0.523> <0.196, 4.860, -0.523> <0.523, 4.860, -0.196> <0.523, 4.860, -0.000> <-0.000, 4.866, -0.462> <0.196, 4.866, -0.462> <0.462, 4.866, -0.196> <0.462, 4.866, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.666, 4.866, -0.000> <0.666, 4.865, 0.281> <0.281, 4.865, 0.661> <-0.000, 4.865, 0.661> <0.666, 3.416, -0.000> <0.666, 3.415, 0.281> <0.281, 3.408, 0.662> <-0.000, 3.408, 0.662> <0.666, 1.482, -0.000> <0.666, 1.482, 0.363> <0.363, 1.467, 0.664> <-0.000, 1.467, 0.664> <0.666, 0.032, -0.000> <0.666, 0.032, 0.363> <0.363, 0.011, 0.666> <-0.000, 0.011, 0.666> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.866, 0.462> <-0.196, 4.866, 0.462> <-0.462, 4.866, 0.196> <-0.462, 4.866, -0.000> <-0.000, 4.867, 0.444> <-0.196, 4.867, 0.444> <-0.444, 4.867, 0.196> <-0.444, 4.867, -0.000> <-0.000, 4.883, 0.423> <-0.172, 4.883, 0.423> <-0.423, 4.883, 0.172> <-0.423, 4.883, -0.000> <-0.000, 4.890, 0.406> <-0.172, 4.890, 0.406> <-0.406, 4.890, 0.172> <-0.406, 4.890, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.462, 4.866, -0.000> <-0.462, 4.866, -0.196> <-0.196, 4.866, -0.462> <-0.000, 4.866, -0.462> <-0.444, 4.867, -0.000> <-0.444, 4.867, -0.196> <-0.196, 4.867, -0.444> <-0.000, 4.867, -0.444> <-0.423, 4.883, -0.000> <-0.423, 4.883, -0.172> <-0.172, 4.883, -0.423> <-0.000, 4.883, -0.423> <-0.406, 4.890, -0.000> <-0.406, 4.890, -0.172> <-0.172, 4.890, -0.406> <-0.000, 4.890, -0.406> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.866, -0.462> <0.196, 4.866, -0.462> <0.462, 4.866, -0.196> <0.462, 4.866, -0.000> <-0.000, 4.867, -0.444> <0.196, 4.867, -0.444> <0.444, 4.867, -0.196> <0.444, 4.867, -0.000> <-0.000, 4.883, -0.423> <0.172, 4.883, -0.423> <0.424, 4.888, -0.172> <0.424, 4.888, -0.000> <-0.000, 4.890, -0.406> <0.172, 4.890, -0.406> <0.406, 4.890, -0.172> <0.406, 4.890, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.462, 4.866, -0.000> <0.462, 4.866, 0.196> <0.196, 4.866, 0.462> <-0.000, 4.866, 0.462> <0.523, 4.860, -0.000> <0.523, 4.860, 0.196> <0.196, 4.860, 0.521> <-0.000, 4.860, 0.521> <0.605, 4.866, -0.000> <0.605, 4.865, 0.281> <0.281, 4.865, 0.601> <-0.000, 4.865, 0.601> <0.666, 4.866, -0.000> <0.666, 4.865, 0.281> <0.281, 4.865, 0.661> <-0.000, 4.865, 0.661> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.890, 0.406> <-0.172, 4.890, 0.406> <-0.406, 4.890, 0.172> <-0.406, 4.890, -0.000> <-0.000, 4.890, 0.353> <-0.172, 4.890, 0.353> <-0.353, 4.890, 0.172> <-0.353, 4.890, -0.000> <-0.000, 4.857, 0.272> <-0.098, 4.857, 0.272> <-0.272, 4.857, 0.098> <-0.272, 4.857, -0.000> <-0.000, 4.890, 0.230> <-0.098, 4.890, 0.230> <-0.230, 4.890, 0.098> <-0.230, 4.890, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.406, 4.890, -0.000> <-0.406, 4.890, -0.172> <-0.172, 4.890, -0.406> <-0.000, 4.890, -0.406> <-0.353, 4.890, -0.000> <-0.353, 4.890, -0.172> <-0.172, 4.890, -0.353> <-0.000, 4.890, -0.353> <-0.272, 4.857, -0.000> <-0.272, 4.857, -0.098> <-0.098, 4.857, -0.272> <-0.000, 4.857, -0.272> <-0.230, 4.890, -0.000> <-0.230, 4.890, -0.098> <-0.098, 4.890, -0.230> <-0.000, 4.890, -0.230> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.890, -0.406> <0.172, 4.890, -0.406> <0.406, 4.890, -0.172> <0.406, 4.890, -0.000> <-0.000, 4.890, -0.353> <0.172, 4.890, -0.353> <0.354, 4.896, -0.172> <0.354, 4.896, -0.000> <-0.000, 4.857, -0.272> <0.098, 4.857, -0.272> <0.283, 4.890, -0.098> <0.283, 4.890, -0.000> <-0.000, 4.890, -0.230> <0.098, 4.890, -0.230> <0.230, 4.890, -0.098> <0.230, 4.890, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.406, 4.890, -0.000> <0.406, 4.890, 0.172> <0.172, 4.890, 0.406> <-0.000, 4.890, 0.406> <0.424, 4.888, -0.000> <0.424, 4.888, 0.172> <0.172, 4.883, 0.423> <-0.000, 4.883, 0.423> <0.444, 4.867, -0.000> <0.444, 4.867, 0.196> <0.196, 4.867, 0.444> <-0.000, 4.867, 0.444> <0.462, 4.866, -0.000> <0.462, 4.866, 0.196> <0.196, 4.866, 0.462> <-0.000, 4.866, 0.462> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.890, 0.230> <-0.098, 4.890, 0.230> <-0.230, 4.890, 0.098> <-0.230, 4.890, -0.000> <-0.000, 4.916, 0.197> <-0.098, 4.916, 0.197> <-0.197, 4.916, 0.098> <-0.197, 4.916, -0.000> <-0.000, 4.988, 0.230> <-0.098, 4.988, 0.230> <-0.230, 4.988, 0.098> <-0.230, 4.988, -0.000> <-0.000, 5.030, 0.230> <-0.098, 5.030, 0.230> <-0.230, 5.030, 0.098> <-0.230, 5.030, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.230, 4.890, -0.000> <-0.230, 4.890, -0.098> <-0.098, 4.890, -0.230> <-0.000, 4.890, -0.230> <-0.197, 4.916, -0.000> <-0.197, 4.916, -0.098> <-0.098, 4.916, -0.197> <-0.000, 4.916, -0.197> <-0.230, 4.988, -0.000> <-0.230, 4.988, -0.098> <-0.098, 4.988, -0.230> <-0.000, 4.988, -0.230> <-0.230, 5.030, -0.000> <-0.230, 5.030, -0.098> <-0.098, 5.030, -0.230> <-0.000, 5.030, -0.230> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 4.890, -0.230> <0.098, 4.890, -0.230> <0.230, 4.890, -0.098> <0.230, 4.890, -0.000> <-0.000, 4.916, -0.197> <0.098, 4.916, -0.197> <0.230, 4.932, -0.098> <0.230, 4.932, -0.000> <-0.000, 4.988, -0.230> <0.098, 4.988, -0.230> <0.230, 4.988, -0.098> <0.230, 4.988, -0.000> <-0.000, 5.030, -0.230> <0.098, 5.030, -0.230> <0.230, 5.030, -0.098> <0.230, 5.030, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.230, 4.890, -0.000> <0.230, 4.890, 0.098> <0.098, 4.890, 0.230> <-0.000, 4.890, 0.230> <0.283, 4.890, -0.000> <0.283, 4.890, 0.098> <0.098, 4.857, 0.272> <-0.000, 4.857, 0.272> <0.354, 4.896, -0.000> <0.354, 4.896, 0.172> <0.172, 4.890, 0.353> <-0.000, 4.890, 0.353> <0.406, 4.890, -0.000> <0.406, 4.890, 0.172> <0.172, 4.890, 0.406> <-0.000, 4.890, 0.406> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.230, 5.030, -0.000> <0.230, 5.030, 0.098> <0.098, 5.030, 0.230> <-0.000, 5.030, 0.230> <0.230, 4.988, -0.000> <0.230, 4.988, 0.098> <0.098, 4.988, 0.230> <-0.000, 4.988, 0.230> <0.230, 4.932, -0.000> <0.230, 4.932, 0.098> <0.098, 4.916, 0.197> <-0.000, 4.916, 0.197> <0.230, 4.890, -0.000> <0.230, 4.890, 0.098> <0.098, 4.890, 0.230> <-0.000, 4.890, 0.230> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.666, 0.032, -0.000> <-0.620, 0.032, -0.000> <-0.558, 0.042, -0.000> <-0.513, 0.032, -0.000> <-0.666, 0.032, 0.363> <-0.620, 0.032, 0.363> <-0.558, 0.042, 0.280> <-0.513, 0.032, 0.280> <-0.363, 0.011, 0.666> <-0.363, 0.017, 0.620> <-0.280, 0.036, 0.559> <-0.280, 0.032, 0.513> <-0.000, 0.011, 0.666> <-0.000, 0.017, 0.620> <-0.000, 0.036, 0.559> <-0.000, 0.032, 0.513> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.513, 0.032, -0.000> <-0.503, 0.030, -0.000> <-0.522, 0.002, -0.000> <-0.513, 0.000, -0.000> <-0.513, 0.032, 0.280> <-0.503, 0.030, 0.280> <-0.522, 0.002, 0.280> <-0.513, 0.000, 0.280> <-0.280, 0.032, 0.513> <-0.280, 0.032, 0.503> <-0.280, 0.002, 0.522> <-0.280, 0.000, 0.513> <-0.000, 0.032, 0.513> <-0.000, 0.032, 0.503> <-0.000, 0.002, 0.522> <-0.000, 0.000, 0.513> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.513, 0.000, -0.000> <-0.472, -0.009, -0.000> <-0.416, -0.004, -0.000> <-0.374, 0.000, -0.000> <-0.513, 0.000, 0.280> <-0.472, -0.009, 0.280> <-0.416, -0.004, 0.204> <-0.374, 0.000, 0.204> <-0.280, 0.000, 0.513> <-0.280, -0.009, 0.472> <-0.204, -0.004, 0.416> <-0.204, 0.000, 0.374> <-0.000, 0.000, 0.513> <-0.000, -0.009, 0.472> <-0.000, -0.004, 0.416> <-0.000, 0.000, 0.374> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.374, 0.000, -0.000> <-0.364, 0.001, -0.000> <-0.354, 0.016, -0.000> <-0.344, 0.016, -0.000> <-0.374, 0.000, 0.204> <-0.364, 0.001, 0.204> <-0.354, 0.016, 0.188> <-0.344, 0.016, 0.188> <-0.204, 0.000, 0.374> <-0.204, 0.001, 0.364> <-0.188, 0.016, 0.354> <-0.188, 0.016, 0.344> <-0.000, 0.000, 0.374> <-0.000, 0.001, 0.364> <-0.000, 0.016, 0.354> <-0.000, 0.016, 0.344> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.344, 0.016, -0.000> <-0.336, 0.016, -0.000> <-0.329, 0.000, -0.000> <-0.320, 0.000, -0.000> <-0.344, 0.016, 0.188> <-0.336, 0.016, 0.188> <-0.329, 0.000, 0.175> <-0.320, 0.000, 0.175> <-0.188, 0.016, 0.344> <-0.188, 0.016, 0.336> <-0.175, 0.000, 0.329> <-0.175, 0.000, 0.320> <-0.000, 0.016, 0.344> <-0.000, 0.016, 0.336> <-0.000, 0.000, 0.329> <-0.000, 0.000, 0.320> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.320, 0.000, -0.000> <-0.224, -0.005, -0.000> <-0.096, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.320, 0.000, 0.175> <-0.224, -0.005, 0.175> <-0.096, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.175, 0.000, 0.320> <-0.175, -0.005, 0.224> <-0.000, 0.000, 0.096> <-0.000, 0.000, -0.000> <-0.000, 0.000, 0.320> <-0.000, -0.005, 0.224> <-0.000, 0.000, 0.096> <-0.000, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.666, 0.032, -0.000> <0.620, 0.032, -0.000> <0.558, 0.042, -0.000> <0.513, 0.032, -0.000> <0.666, 0.032, -0.363> <0.620, 0.032, -0.363> <0.558, 0.042, -0.280> <0.513, 0.032, -0.280> <0.363, 0.011, -0.666> <0.363, 0.017, -0.620> <0.280, 0.036, -0.559> <0.280, 0.032, -0.513> <-0.000, 0.011, -0.666> <-0.000, 0.017, -0.620> <-0.000, 0.036, -0.559> <-0.000, 0.032, -0.513> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.513, 0.032, -0.000> <0.503, 0.030, -0.000> <0.522, 0.002, -0.000> <0.513, 0.000, -0.000> <0.513, 0.032, -0.280> <0.503, 0.030, -0.280> <0.522, 0.002, -0.280> <0.513, 0.000, -0.280> <0.280, 0.032, -0.513> <0.280, 0.032, -0.503> <0.280, 0.002, -0.522> <0.280, 0.000, -0.513> <-0.000, 0.032, -0.513> <-0.000, 0.032, -0.503> <-0.000, 0.002, -0.522> <-0.000, 0.000, -0.513> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.513, 0.000, -0.000> <0.472, -0.009, -0.000> <0.416, -0.004, -0.000> <0.374, 0.000, -0.000> <0.513, 0.000, -0.280> <0.472, -0.009, -0.280> <0.416, -0.004, -0.204> <0.374, 0.000, -0.204> <0.280, 0.000, -0.513> <0.280, -0.009, -0.472> <0.204, -0.004, -0.416> <0.204, 0.000, -0.374> <-0.000, 0.000, -0.513> <-0.000, -0.009, -0.472> <-0.000, -0.004, -0.416> <-0.000, 0.000, -0.374> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.374, 0.000, -0.000> <0.364, 0.001, -0.000> <0.354, 0.016, -0.000> <0.344, 0.016, -0.000> <0.374, 0.000, -0.204> <0.364, 0.001, -0.204> <0.354, 0.016, -0.188> <0.344, 0.016, -0.188> <0.204, 0.000, -0.374> <0.204, 0.001, -0.364> <0.188, 0.016, -0.354> <0.188, 0.016, -0.344> <-0.000, 0.000, -0.374> <-0.000, 0.001, -0.364> <-0.000, 0.016, -0.354> <-0.000, 0.016, -0.344> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.344, 0.016, -0.000> <0.336, 0.016, -0.000> <0.329, 0.000, -0.000> <0.320, 0.000, -0.000> <0.344, 0.016, -0.188> <0.336, 0.016, -0.188> <0.329, 0.000, -0.175> <0.320, 0.000, -0.175> <0.188, 0.016, -0.344> <0.188, 0.016, -0.336> <0.175, 0.000, -0.329> <0.175, 0.000, -0.320> <-0.000, 0.016, -0.344> <-0.000, 0.016, -0.336> <-0.000, 0.000, -0.329> <-0.000, 0.000, -0.320> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.320, 0.000, -0.000> <0.224, -0.005, -0.000> <0.096, 0.000, -0.000> <-0.000, 0.000, -0.000> <0.320, 0.000, -0.175> <0.224, -0.005, -0.175> <0.096, 0.000, -0.000> <-0.000, 0.000, -0.000> <0.175, 0.000, -0.320> <0.175, -0.005, -0.224> <-0.000, 0.000, -0.096> <-0.000, 0.000, -0.000> <-0.000, 0.000, -0.320> <-0.000, -0.005, -0.224> <-0.000, 0.000, -0.096> <-0.000, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, -0.000> <-0.000, 0.000, 0.096> <-0.000, -0.005, 0.224> <-0.000, 0.000, 0.320> <-0.000, 0.000, -0.000> <-0.000, 0.000, 0.096> <0.175, -0.005, 0.224> <0.175, 0.000, 0.320> <-0.000, 0.000, -0.000> <0.096, 0.000, -0.000> <0.224, -0.005, 0.175> <0.320, 0.000, 0.175> <-0.000, 0.000, -0.000> <0.096, 0.000, -0.000> <0.224, -0.005, -0.000> <0.320, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, 0.320> <-0.000, 0.000, 0.329> <-0.000, 0.016, 0.336> <-0.000, 0.016, 0.344> <0.175, 0.000, 0.320> <0.175, 0.000, 0.329> <0.188, 0.016, 0.336> <0.188, 0.016, 0.344> <0.320, 0.000, 0.175> <0.329, 0.000, 0.175> <0.336, 0.016, 0.188> <0.344, 0.016, 0.188> <0.320, 0.000, -0.000> <0.329, 0.000, -0.000> <0.336, 0.016, -0.000> <0.344, 0.016, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.016, 0.344> <-0.000, 0.016, 0.354> <-0.000, 0.001, 0.364> <-0.000, 0.000, 0.374> <0.188, 0.016, 0.344> <0.188, 0.016, 0.354> <0.204, 0.001, 0.364> <0.204, 0.000, 0.374> <0.344, 0.016, 0.188> <0.354, 0.016, 0.188> <0.364, 0.001, 0.204> <0.374, 0.000, 0.204> <0.344, 0.016, -0.000> <0.354, 0.016, -0.000> <0.364, 0.001, -0.000> <0.374, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, 0.374> <-0.000, -0.004, 0.416> <-0.000, -0.009, 0.472> <-0.000, 0.000, 0.513> <0.204, 0.000, 0.374> <0.204, -0.004, 0.416> <0.280, -0.009, 0.472> <0.280, 0.000, 0.513> <0.374, 0.000, 0.204> <0.416, -0.004, 0.204> <0.472, -0.009, 0.280> <0.513, 0.000, 0.280> <0.374, 0.000, -0.000> <0.416, -0.004, -0.000> <0.472, -0.009, -0.000> <0.513, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, 0.513> <-0.000, 0.002, 0.522> <-0.000, 0.032, 0.503> <-0.000, 0.032, 0.513> <0.280, 0.000, 0.513> <0.280, 0.002, 0.522> <0.280, 0.032, 0.503> <0.280, 0.032, 0.513> <0.513, 0.000, 0.280> <0.522, 0.002, 0.280> <0.503, 0.030, 0.280> <0.513, 0.032, 0.280> <0.513, 0.000, -0.000> <0.522, 0.002, -0.000> <0.503, 0.030, -0.000> <0.513, 0.032, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.011, -0.666> <-0.000, 0.017, -0.620> <-0.000, 0.036, -0.559> <-0.000, 0.032, -0.513> <-0.363, 0.011, -0.666> <-0.363, 0.017, -0.620> <-0.280, 0.036, -0.559> <-0.280, 0.032, -0.513> <-0.666, 0.032, -0.363> <-0.620, 0.032, -0.363> <-0.558, 0.042, -0.280> <-0.513, 0.032, -0.280> <-0.666, 0.032, -0.000> <-0.620, 0.032, -0.000> <-0.558, 0.042, -0.000> <-0.513, 0.032, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.032, -0.513> <-0.000, 0.032, -0.503> <-0.000, 0.002, -0.522> <-0.000, 0.000, -0.513> <-0.280, 0.032, -0.513> <-0.280, 0.032, -0.503> <-0.280, 0.002, -0.522> <-0.280, 0.000, -0.513> <-0.513, 0.032, -0.280> <-0.503, 0.030, -0.280> <-0.522, 0.002, -0.280> <-0.513, 0.000, -0.280> <-0.513, 0.032, -0.000> <-0.503, 0.030, -0.000> <-0.522, 0.002, -0.000> <-0.513, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, -0.513> <-0.000, -0.009, -0.472> <-0.000, -0.004, -0.416> <-0.000, 0.000, -0.374> <-0.280, 0.000, -0.513> <-0.280, -0.009, -0.472> <-0.204, -0.004, -0.416> <-0.204, 0.000, -0.374> <-0.513, 0.000, -0.280> <-0.472, -0.009, -0.280> <-0.416, -0.004, -0.204> <-0.374, 0.000, -0.204> <-0.513, 0.000, -0.000> <-0.472, -0.009, -0.000> <-0.416, -0.004, -0.000> <-0.374, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, -0.374> <-0.000, 0.001, -0.364> <-0.000, 0.016, -0.354> <-0.000, 0.016, -0.344> <-0.204, 0.000, -0.374> <-0.204, 0.001, -0.364> <-0.188, 0.016, -0.354> <-0.188, 0.016, -0.344> <-0.374, 0.000, -0.204> <-0.364, 0.001, -0.204> <-0.354, 0.016, -0.188> <-0.344, 0.016, -0.188> <-0.374, 0.000, -0.000> <-0.364, 0.001, -0.000> <-0.354, 0.016, -0.000> <-0.344, 0.016, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.016, -0.344> <-0.000, 0.016, -0.336> <-0.000, 0.000, -0.329> <-0.000, 0.000, -0.320> <-0.188, 0.016, -0.344> <-0.188, 0.016, -0.336> <-0.175, 0.000, -0.329> <-0.175, 0.000, -0.320> <-0.344, 0.016, -0.188> <-0.336, 0.016, -0.188> <-0.329, 0.000, -0.175> <-0.320, 0.000, -0.175> <-0.344, 0.016, -0.000> <-0.336, 0.016, -0.000> <-0.329, 0.000, -0.000> <-0.320, 0.000, -0.000> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<-0.000, 0.000, -0.320> <-0.000, -0.005, -0.224> <-0.000, 0.000, -0.096> <-0.000, 0.000, -0.000> <-0.175, 0.000, -0.320> <-0.175, -0.005, -0.224> <-0.000, 0.000, -0.096> <-0.000, 0.000, -0.000> <-0.320, 0.000, -0.175> <-0.224, -0.005, -0.175> <-0.096, 0.000, -0.000> <-0.000, 0.000, -0.000> <-0.320, 0.000, -0.000> <-0.224, -0.005, -0.000> <-0.096, 0.000, -0.000> <-0.000, 0.000, -0.000> }
    material { battery_label }
    rotate <62,10,0>
    translate <9.85,0.5,-4>
  }
  //patch_cover
  union {
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.077, 0.153, -1.312> <1.914, 0.145, -1.301> <1.696, 0.135, -1.287> <1.533, 0.127, -1.275> <2.079, 0.148, -1.289> <1.916, 0.140, -1.278> <1.698, 0.130, -1.263> <1.535, 0.122, -1.252> <2.082, 0.141, -1.258> <1.918, 0.134, -1.247> <1.701, 0.123, -1.232> <1.537, 0.116, -1.221> <2.083, 0.136, -1.235> <1.920, 0.129, -1.224> <1.702, 0.118, -1.209> <1.539, 0.111, -1.198> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.533, 0.127, -1.275> <1.359, 0.119, -1.264> <1.126, 0.108, -1.248> <0.951, 0.100, -1.236> <1.492, 1.640, -0.947> <1.318, 1.632, -0.935> <1.052, 1.620, -0.917> <0.877, 1.611, -0.905> <1.438, 3.657, -0.509> <1.230, 3.647, -0.495> <0.987, 3.636, -0.478> <0.779, 3.626, -0.464> <1.398, 5.170, -0.180> <1.190, 5.160, -0.166> <0.913, 5.147, -0.147> <0.705, 5.137, -0.133> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.407, 0.075, -1.199> <0.407, 0.075, -1.199> <0.407, 0.075, -1.199> <0.407, 0.075, -1.199> <0.359, 1.587, -0.870> <0.359, 1.587, -0.870> <0.359, 1.587, -0.870> <0.359, 1.587, -0.870> <0.294, 3.604, -0.431> <0.294, 3.604, -0.431> <0.294, 3.604, -0.431> <0.294, 3.604, -0.431> <0.246, 5.116, -0.102> <0.246, 5.116, -0.102> <0.246, 5.116, -0.102> <0.246, 5.116, -0.102> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.711, 5.121, -0.056> <0.919, 5.131, -0.070> <1.196, 5.143, -0.089> <1.404, 5.153, -0.103> <0.785, 3.610, -0.387> <0.993, 3.619, -0.401> <1.236, 3.631, -0.417> <1.444, 3.640, -0.431> <0.884, 1.595, -0.828> <1.058, 1.603, -0.840> <1.324, 1.615, -0.858> <1.498, 1.623, -0.869> <0.958, 0.084, -1.158> <1.132, 0.092, -1.170> <1.365, 0.103, -1.186> <1.539, 0.111, -1.198> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.711, 5.121, -0.056> <0.919, 5.131, -0.070> <1.196, 5.143, -0.089> <1.404, 5.153, -0.103> <0.709, 5.126, -0.079> <0.917, 5.135, -0.093> <1.194, 5.148, -0.112> <1.402, 5.158, -0.126> <0.707, 5.132, -0.110> <0.914, 5.142, -0.124> <1.192, 5.155, -0.143> <1.399, 5.165, -0.157> <0.705, 5.137, -0.133> <0.913, 5.147, -0.147> <1.190, 5.160, -0.166> <1.398, 5.170, -0.180> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.711, 5.121, -0.056> <0.919, 5.131, -0.070> <1.196, 5.143, -0.089> <1.404, 5.153, -0.103> <0.708, 5.205, -0.037> <0.916, 5.214, -0.052> <1.193, 5.227, -0.070> <1.401, 5.237, -0.085> <0.705, 5.316, -0.013> <0.912, 5.326, -0.027> <1.190, 5.339, -0.046> <1.397, 5.349, -0.060> <0.702, 5.400, 0.005> <0.910, 5.410, -0.009> <1.187, 5.423, -0.028> <1.395, 5.433, -0.042> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.702, 5.400, 0.005> <0.910, 5.410, -0.009> <1.187, 5.423, -0.028> <1.395, 5.433, -0.042> <0.700, 5.405, -0.018> <0.908, 5.415, -0.032> <1.185, 5.428, -0.051> <1.393, 5.438, -0.065> <0.698, 5.412, -0.049> <0.906, 5.422, -0.063> <1.183, 5.435, -0.082> <1.391, 5.444, -0.096> <0.696, 5.417, -0.072> <0.904, 5.427, -0.086> <1.181, 5.440, -0.105> <1.389, 5.449, -0.119> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.696, 5.417, -0.072> <0.699, 5.333, -0.090> <0.702, 5.221, -0.115> <0.705, 5.137, -0.133> <0.904, 5.427, -0.086> <0.906, 5.343, -0.105> <0.910, 5.231, -0.129> <0.913, 5.147, -0.147> <1.181, 5.440, -0.105> <1.184, 5.356, -0.123> <1.187, 5.244, -0.148> <1.190, 5.160, -0.166> <1.389, 5.449, -0.119> <1.391, 5.366, -0.138> <1.395, 5.254, -0.162> <1.398, 5.170, -0.180> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.696, 5.417, -0.072> <0.699, 5.333, -0.090> <0.702, 5.221, -0.115> <0.705, 5.137, -0.133> <0.698, 5.412, -0.049> <0.700, 5.328, -0.067> <0.704, 5.216, -0.092> <0.707, 5.132, -0.110> <0.700, 5.405, -0.018> <0.703, 5.321, -0.036> <0.706, 5.210, -0.061> <0.709, 5.126, -0.079> <0.702, 5.400, 0.005> <0.705, 5.316, -0.013> <0.708, 5.205, -0.037> <0.711, 5.121, -0.056> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.395, 5.433, -0.042> <1.397, 5.349, -0.060> <1.401, 5.237, -0.085> <1.404, 5.153, -0.103> <1.393, 5.438, -0.065> <1.396, 5.354, -0.083> <1.399, 5.242, -0.108> <1.402, 5.158, -0.126> <1.391, 5.444, -0.096> <1.393, 5.361, -0.114> <1.397, 5.249, -0.139> <1.399, 5.165, -0.157> <1.389, 5.449, -0.119> <1.391, 5.366, -0.138> <1.395, 5.254, -0.162> <1.398, 5.170, -0.180> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.711, 5.121, -0.056> <0.709, 5.126, -0.079> <0.707, 5.132, -0.110> <0.705, 5.137, -0.133> <0.785, 3.610, -0.387> <0.783, 3.615, -0.410> <0.781, 3.621, -0.441> <0.779, 3.626, -0.464> <0.884, 1.595, -0.828> <0.882, 1.600, -0.851> <0.879, 1.606, -0.882> <0.877, 1.611, -0.905> <0.958, 0.084, -1.158> <0.956, 0.089, -1.182> <0.953, 0.095, -1.213> <0.951, 0.100, -1.236> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.705, 5.137, -0.133> <0.567, 5.131, -0.124> <0.384, 5.122, -0.111> <0.246, 5.116, -0.102> <0.779, 3.626, -0.464> <0.641, 3.620, -0.455> <0.432, 3.610, -0.440> <0.294, 3.604, -0.431> <0.877, 1.611, -0.905> <0.714, 1.604, -0.894> <0.522, 1.595, -0.881> <0.359, 1.587, -0.870> <0.951, 0.100, -1.236> <0.788, 0.093, -1.225> <0.570, 0.082, -1.210> <0.407, 0.075, -1.199> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.083, 0.136, -1.235> <2.083, 0.136, -1.235> <2.083, 0.136, -1.235> <2.083, 0.136, -1.235> <2.035, 1.649, -0.906> <2.035, 1.649, -0.906> <2.035, 1.649, -0.906> <2.035, 1.649, -0.906> <1.971, 3.665, -0.467> <1.971, 3.665, -0.467> <1.971, 3.665, -0.467> <1.971, 3.665, -0.467> <1.922, 5.177, -0.138> <1.922, 5.177, -0.138> <1.922, 5.177, -0.138> <1.922, 5.177, -0.138> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<2.083, 0.136, -1.235> <1.920, 0.129, -1.224> <1.702, 0.118, -1.209> <1.539, 0.111, -1.198> <2.035, 1.649, -0.906> <1.872, 1.641, -0.895> <1.662, 1.631, -0.881> <1.498, 1.623, -0.869> <1.971, 3.665, -0.467> <1.815, 3.658, -0.457> <1.600, 3.648, -0.442> <1.444, 3.640, -0.431> <1.922, 5.177, -0.138> <1.767, 5.170, -0.127> <1.559, 5.160, -0.113> <1.404, 5.153, -0.103> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.539, 0.111, -1.198> <1.365, 0.103, -1.186> <1.132, 0.092, -1.170> <0.958, 0.084, -1.158> <1.537, 0.116, -1.221> <1.363, 0.108, -1.209> <1.130, 0.097, -1.194> <0.956, 0.089, -1.182> <1.535, 0.122, -1.252> <1.360, 0.114, -1.240> <1.128, 0.103, -1.225> <0.953, 0.095, -1.213> <1.533, 0.127, -1.275> <1.359, 0.119, -1.264> <1.126, 0.108, -1.248> <0.951, 0.100, -1.236> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.958, 0.084, -1.158> <0.794, 0.076, -1.147> <0.576, 0.066, -1.133> <0.413, 0.058, -1.121> <0.884, 1.595, -0.828> <0.720, 1.587, -0.817> <0.528, 1.578, -0.803> <0.365, 1.570, -0.792> <0.785, 3.610, -0.387> <0.647, 3.603, -0.377> <0.438, 3.593, -0.363> <0.300, 3.587, -0.354> <0.711, 5.121, -0.056> <0.573, 5.114, -0.046> <0.390, 5.106, -0.034> <0.252, 5.099, -0.024> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.413, 0.058, -1.121> <0.413, 0.058, -1.121> <0.413, 0.058, -1.121> <0.413, 0.058, -1.121> <0.365, 1.570, -0.792> <0.365, 1.570, -0.792> <0.365, 1.570, -0.792> <0.365, 1.570, -0.792> <0.300, 3.587, -0.354> <0.300, 3.587, -0.354> <0.300, 3.587, -0.354> <0.300, 3.587, -0.354> <0.252, 5.099, -0.024> <0.252, 5.099, -0.024> <0.252, 5.099, -0.024> <0.252, 5.099, -0.024> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.916, 5.194, -0.215> <1.916, 5.194, -0.215> <1.916, 5.194, -0.215> <1.916, 5.194, -0.215> <1.965, 3.682, -0.545> <1.965, 3.682, -0.545> <1.965, 3.682, -0.545> <1.965, 3.682, -0.545> <2.029, 1.665, -0.983> <2.029, 1.665, -0.983> <2.029, 1.665, -0.983> <2.029, 1.665, -0.983> <2.077, 0.153, -1.312> <2.077, 0.153, -1.312> <2.077, 0.153, -1.312> <2.077, 0.153, -1.312> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.916, 5.194, -0.215> <1.761, 5.187, -0.205> <1.553, 5.177, -0.191> <1.398, 5.170, -0.180> <1.965, 3.682, -0.545> <1.809, 3.674, -0.534> <1.594, 3.664, -0.519> <1.438, 3.657, -0.509> <2.029, 1.665, -0.983> <1.866, 1.658, -0.972> <1.656, 1.648, -0.958> <1.492, 1.640, -0.947> <2.077, 0.153, -1.312> <1.914, 0.145, -1.301> <1.696, 0.135, -1.287> <1.533, 0.127, -1.275> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.398, 5.170, -0.180> <1.399, 5.165, -0.157> <1.402, 5.158, -0.126> <1.404, 5.153, -0.103> <1.438, 3.657, -0.509> <1.440, 3.652, -0.486> <1.442, 3.645, -0.455> <1.444, 3.640, -0.431> <1.492, 1.640, -0.947> <1.494, 1.635, -0.924> <1.497, 1.628, -0.893> <1.498, 1.623, -0.869> <1.533, 0.127, -1.275> <1.535, 0.122, -1.252> <1.537, 0.116, -1.221> <1.539, 0.111, -1.198> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<1.404, 5.153, -0.103> <1.559, 5.160, -0.113> <1.767, 5.170, -0.127> <1.922, 5.177, -0.138> <1.402, 5.158, -0.126> <1.557, 5.165, -0.137> <1.765, 5.175, -0.151> <1.921, 5.182, -0.161> <1.399, 5.165, -0.157> <1.555, 5.172, -0.168> <1.763, 5.182, -0.182> <1.918, 5.189, -0.192> <1.398, 5.170, -0.180> <1.553, 5.177, -0.191> <1.761, 5.187, -0.205> <1.916, 5.194, -0.215> }
    bicubic_patch {	type 1 flatness 0	u_steps 3	v_steps 3	<0.711, 5.121, -0.056> <0.573, 5.114, -0.046> <0.390, 5.106, -0.034> <0.252, 5.099, -0.024> <0.709, 5.126, -0.079> <0.571, 5.119, -0.070> <0.388, 5.111, -0.057> <0.250, 5.104, -0.048> <0.707, 5.132, -0.110> <0.569, 5.126, -0.100> <0.385, 5.117, -0.088> <0.248, 5.111, -0.079> <0.705, 5.137, -0.133> <0.567, 5.131, -0.124> <0.384, 5.122, -0.111> <0.246, 5.116, -0.102> }
    texture { black_plastic }
  }
}
