// Persistence of Vision Ray Tracer Include File
// File: lens.inc
// Vers: 3.5
// Desc: include file for faith.pov
// Date: 22/6/2003
// Auth: Paolo Brasolin

#include "colors.inc"

#declare body = difference {
  intersection {
    difference {
      difference {
        prism { 0, 9, 13, 
          <   6.86,  25.60 >, <  18.74,  18.74 >, <  25.60,   6.86 >, <  25.60,  -6.86 >, 
          <  18.74, -18.74 >, <   6.86, -25.60 >, <  -6.86, -25.60 >, < -18.74, -18.74 >, 
          < -25.60,  -6.86 >, < -25.60,   6.86 >, < -18.74,  18.74 >, <  -6.86,  25.60 >,
          <   6.86,  25.60 >
        }
        cylinder { <0,-1,0>, <0,10,0>, 22 }
      }
      merge {
        cone { <0,4.5 ,0>, 21.5, <0, 9.01,0>, 23 }
        cone { <0,4.5 ,0>, 21.5, <0,-0.01,0>, 23 }
        cone { <0,4.51,0>, 22.5, <0, 3,   0>, 22 }
        cone { <0,4.49,0>, 22.5, <0, 6,   0>, 22 }
      }
    }
    merge {
      difference {
        cylinder { <0,-1,0>, <0,10,0>, 25.4 }
        cylinder { <0,-1,0>, <0,10,0>, 23.5 }
      }
      cylinder { <0,1,0>, <0,8,0>, 26.4 }
      torus { 25.4, 1 translate y*1 }
      torus { 25.4, 1 translate y*8 }
      torus { 23.5, 1 translate y*8 }
      torus { 23.5, 1 translate y*1 }
    }
  }
  cylinder { <23.5,4.5,0>, <29.6,4.5,0>, 3.5 }
}

#declare lens = intersection {
  intersection {
    sphere { <0, 123,0>, 122 }
    sphere { <0,-114,0>, 122 }
  }
  merge {
    cone { <0,4.51,0>, 22.5, <0, 3,   0>, 22 }
    cone { <0,4.49,0>, 22.5, <0, 6,   0>, 22 }
  }
}

#declare ring = difference {
  merge {    
    cone { <25.8,4.5,0>,4.5, <25.6,4.5,0>,4.4 }
    cylinder { <25.8,4.5,0>, <30.6,4.5,0>, 4.5 }
    cone { <30.6,4.5,0>,4.5, <31.6,4.5,0>,3.5 }
  }
  cylinder { <25.5,4.5,0>, <30.7,4.5,0>, 3.5 }
}

#declare handle = merge {
  intersection {
    intersection {
      prism {
        conic_sweep
        -0.66,-1,9,
        <  3.19,  6    >, <  6,     3.19 >,
        <  6,    -3.19 >, <  3.19, -6    >,
        < -3.19, -6    >, < -6,    -3.19 >,
        < -6,     3.19 >, < -3.19,  6    >, < 3.19, 6 >
        scale <1,200,1>
        translate y*200
      }
      cone { <0,-0.01,0>, 6.7, <0,68.01>, 4.4 }
    }   
    merge {
      difference {
        sphere { <0,10,0>, 10 scale <1,0.75,1> }
        cylinder { <0,10,0>, <0,30,0>, 20 }
      }
      cylinder { <0,10,0>, <0,100,0>, 20 }
    }
  }
  cylinder { <0,10,0>, <0,76,0>, 3.5 }
}
                           
#declare tex_glass = texture {
  pigment { color rgbt < 0.98, 0.98, 0.98, 0.9 > } 
  finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.1
    specular 0.8
    roughness 0.003
    phong 1
    phong_size 400
    reflection { 0.1, 0.5 metallic 1 }
  }
}

#declare int_glass = interior {
  ior 1.71
  dispersion 1.012
  caustics 1
}


#declare tex_ring = texture {
  gradient x
  turbulence <-0.1, 0, 0>
  lambda 2      
  omega 1 
  scale 6
  translate 1.6*x  
  texture_map { 
    [ 0.2 pigment { gradient x 
      pigment_map {
        [ 0    color Black     ]
        [ 0.05 color DarkGreen ]
        [ 0.2  color Gray45    ]
        [ 1    color Gray55    ]
      }
      turbulence <-0.05, 0, 0>
      lambda 2      
      omega 1 
    }  
    finish { 
      specular 0.2
      roughness 0.05
    }
    ]
    [ 1 pigment { gradient x 
      pigment_map {
      [ 0.25  color Gray45 ]
      [ 0.75  color Gray55 ]
      }
      turbulence <1, 0, 0>
      lambda 2.5      
      omega 0.5 
      scale 2 
    }  
    finish { 
      specular 0.6
      roughness 0.05
      reflection { 0.1 metallic 1}
    }
    ] 
  }
}

#declare tex_handle = texture {
  pigment { color Black }
  finish { specular 0.6 roughness 0.05 reflection { 0.05 } }
  normal { dents 0.5 scale x*2 }
}

#declare magnifying_lens = union {
  object { lens               translate <  0,   -4.5, 0 > texture { tex_glass  } interior { int_glass } }
  object { body               translate <  0,   -4.5, 0 > texture { tex_glass  } interior { int_glass } }
  object { ring               translate <  0,   -4.5, 0 > texture { tex_ring   } }
  object { handle rotate z*90 translate < 99.6,  0,   0 > texture { tex_handle } } 
  scale 0.1
}