// Persistence of Vision Ray Tracer Include File
// File: necro.inc
// Vers: 3.5
// Desc: include file for faith.pov
// Date: 22/6/2003
// Auth: Paolo Brasolin

#include "golds.inc"

#declare molten_metal = texture { pigment { bozo color_map { [ 0.0 rgb <0.8, 0.8, 0.8> ] [ 0.8 rgb <0.8, 0.8, 0.8> ] [ 1.0 rgb <0.5, 0.5, 0.5> ] } } normal { bumps, 0.1 } finish { specular 0.6 reflection 0.1 } scale  0.5 }
#declare cross_metal = texture { pigment { bozo color_map { [ 0.0 rgb <0.8, 0.8, 0.8> ] [ 0.8 rgb <0.8, 0.8, 0.8> ] [ 1.0 rgb <0.5, 0.5, 0.5> ] } } normal { bumps, 0.05 } finish { specular 0.6 reflection 0.05 } scale  0.01 } 
#declare molten_smoke = texture { gradient y scale <3,7.02,3> translate y*2 texture_map { [ 0 pigment { agate agate_turb .3 color_map { [ 0 rgbt 1 ] [ 0.45 rgbt <0.9, 0.9, 0.9, 0.5> ] [ 0.55 rgbt <0.9, 0.9, 0.9, 0.5> ] [ 1 rgbt 1 ] } } ] [ 1 pigment { color rgbt 1 } ] } }
#declare necronomicon_cover = texture { material_map { gif "necro.gif" texture { pigment { agate color_map { [ 0 red 1 ] [ 0.1 red 0.5 ] [ 1 red 0.5 ] } } normal { agate, 0.2 } scale <1/6,1,2> } texture { T_Gold_1A } } rotate y*90 scale <1,2,12> }
#declare necronomicon_pages =  texture { pigment { gradient y color_map { [ 0 rgb <0.8, 0.7, 0.5> ] [ 0.5 rgb <0.9, 0.8, 0.6> ] [ 1 rgb <0.8, 0.7, 0.5> ] } } scale  <1, 0.1, 1> }

#declare necronomicon = union {
  //patch_molten_metal
  union{
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.839, 2.003, 2.055> <5.864, 2.003, 2.043> <5.906, 1.981, 2.021> <5.921, 2.003, 2.013> <6.100, 2.003, 3.096> <6.125, 2.003, 3.084> <6.188, 1.981, 3.053> <6.204, 2.003, 3.045> <5.307, 2.003, 4.617> <5.326, 2.003, 4.601> <5.358, 1.983, 4.575> <5.370, 2.003, 4.566> <5.666, 2.003, 5.629> <5.684, 2.003, 5.612> <5.716, 1.983, 5.584> <5.728, 2.003, 5.575> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.921, 2.003, 2.013> <5.933, 2.019, 2.006> <5.883, 2.052, 2.016> <5.875, 2.053, 2.036> <6.204, 2.003, 3.045> <6.216, 2.019, 3.038> <6.154, 2.052, 3.054> <6.146, 2.053, 3.074> <5.370, 2.003, 4.566> <5.379, 2.019, 4.559> <5.349, 2.052, 4.586> <5.332, 2.053, 4.597> <5.728, 2.003, 5.575> <5.737, 2.019, 5.567> <5.711, 2.052, 5.596> <5.694, 2.053, 5.606> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.875, 2.053, 2.036> <5.327, 2.082, 3.399> <4.618, 2.088, 5.226> <4.080, 2.103, 6.594> <6.146, 2.053, 3.074> <5.598, 2.082, 4.437> <4.618, 2.088, 5.226> <4.080, 2.103, 6.594> <5.332, 2.053, 4.597> <4.850, 2.082, 4.895> <4.564, 2.088, 6.298> <4.080, 2.103, 6.594> <5.694, 2.053, 5.606> <5.211, 2.082, 5.905> <4.564, 2.088, 6.298> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.546, 2.003, 1.168> <4.533, 2.003, 1.147> <4.510, 1.983, 1.110> <4.501, 2.003, 1.097> <4.899, 2.003, 0.857> <4.886, 2.003, 0.835> <4.899, 1.983, 0.785> <4.891, 2.003, 0.772> <5.725, 2.003, 1.599> <5.749, 2.003, 1.586> <5.772, 1.981, 1.532> <5.787, 2.003, 1.524> <5.839, 2.003, 2.055> <5.864, 2.003, 2.043> <5.906, 1.981, 2.021> <5.921, 2.003, 2.013> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.501, 2.003, 1.097> <4.494, 2.018, 1.086> <4.526, 2.052, 1.114> <4.524, 2.053, 1.134> <4.891, 2.003, 0.772> <4.884, 2.018, 0.761> <4.896, 2.052, 0.797> <4.894, 2.053, 0.817> <5.787, 2.003, 1.524> <5.799, 2.019, 1.517> <5.760, 2.052, 1.544> <5.752, 2.053, 1.564> <5.921, 2.003, 2.013> <5.933, 2.019, 2.006> <5.883, 2.052, 2.016> <5.875, 2.053, 2.036> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.524, 2.053, 1.134> <4.399, 2.083, 2.772> <4.213, 2.088, 4.956> <4.080, 2.103, 6.594> <4.894, 2.053, 0.817> <4.769, 2.083, 2.455> <4.213, 2.088, 4.956> <4.080, 2.103, 6.594> <5.752, 2.053, 1.564> <5.204, 2.082, 2.928> <4.618, 2.088, 5.226> <4.080, 2.103, 6.594> <5.875, 2.053, 2.036> <5.327, 2.082, 3.399> <4.618, 2.088, 5.226> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.754, 2.003, 5.155> <1.737, 2.003, 5.135> <1.708, 1.985, 5.104> <1.697, 2.003, 5.088> <2.010, 2.003, 4.897> <1.992, 2.003, 4.877> <1.960, 1.985, 4.850> <1.949, 2.003, 4.834> <2.657, 2.003, 4.977> <2.636, 2.003, 4.959> <2.604, 1.983, 4.926> <2.589, 2.003, 4.913> <2.865, 2.003, 4.680> <2.844, 2.003, 4.662> <2.810, 1.983, 4.633> <2.795, 2.003, 4.620> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.697, 2.003, 5.088> <1.689, 2.015, 5.077> <1.709, 2.052, 5.101> <1.725, 2.053, 5.111> <1.949, 2.003, 4.834> <1.942, 2.015, 4.823> <1.962, 2.052, 4.846> <1.978, 2.053, 4.856> <2.589, 2.003, 4.913> <2.579, 2.017, 4.904> <2.610, 2.052, 4.924> <2.621, 2.053, 4.940> <2.795, 2.003, 4.620> <2.785, 2.017, 4.611> <2.817, 2.052, 4.630> <2.828, 2.053, 4.647> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.725, 2.053, 5.111> <2.430, 2.082, 5.557> <3.373, 2.088, 6.149> <4.080, 2.103, 6.594> <1.978, 2.053, 4.856> <2.683, 2.082, 5.302> <3.373, 2.088, 6.149> <4.080, 2.103, 6.594> <2.621, 2.053, 4.940> <2.999, 2.082, 5.522> <3.704, 2.088, 6.010> <4.080, 2.103, 6.594> <2.828, 2.053, 4.647> <3.206, 2.082, 5.229> <3.704, 2.088, 6.010> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.682, 2.003, 6.879> <0.645, 2.003, 6.878> <0.588, 1.981, 6.876> <0.558, 2.003, 6.875> <0.744, 2.003, 6.273> <0.707, 2.003, 6.272> <0.655, 1.981, 6.244> <0.625, 2.003, 6.243> <1.325, 2.003, 5.587> <1.308, 2.003, 5.567> <1.260, 1.985, 5.555> <1.249, 2.003, 5.540> <1.754, 2.003, 5.155> <1.737, 2.003, 5.135> <1.708, 1.985, 5.104> <1.697, 2.003, 5.088> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.558, 2.003, 6.875> <0.540, 2.016, 6.875> <0.591, 2.052, 6.878> <0.614, 2.053, 6.876> <0.625, 2.003, 6.243> <0.607, 2.016, 6.242> <0.656, 2.052, 6.256> <0.678, 2.053, 6.254> <1.249, 2.003, 5.540> <1.242, 2.015, 5.529> <1.268, 2.052, 5.545> <1.284, 2.053, 5.555> <1.697, 2.003, 5.088> <1.689, 2.015, 5.077> <1.709, 2.052, 5.101> <1.725, 2.053, 5.111> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.614, 2.053, 6.876> <1.653, 2.082, 6.793> <3.040, 2.088, 6.678> <4.080, 2.103, 6.594> <0.678, 2.053, 6.254> <1.718, 2.082, 6.171> <3.040, 2.088, 6.678> <4.080, 2.103, 6.594> <1.284, 2.053, 5.555> <1.989, 2.082, 6.001> <3.373, 2.088, 6.149> <4.080, 2.103, 6.594> <1.725, 2.053, 5.111> <2.430, 2.082, 5.557> <3.373, 2.088, 6.149> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.938, 2.003, 9.689> <1.920, 2.003, 9.705> <1.890, 1.983, 9.733> <1.879, 2.003, 9.742> <1.536, 2.003, 9.271> <1.518, 2.003, 9.287> <1.481, 1.983, 9.312> <1.470, 2.003, 9.321> <1.720, 2.003, 8.339> <1.697, 2.003, 8.349> <1.666, 1.983, 8.371> <1.650, 2.003, 8.377> <1.484, 2.003, 7.810> <1.460, 2.003, 7.820> <1.420, 1.983, 7.837> <1.404, 2.003, 7.843> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.879, 2.003, 9.742> <1.871, 2.019, 9.750> <1.900, 2.052, 9.729> <1.911, 2.053, 9.713> <1.470, 2.003, 9.321> <1.462, 2.019, 9.329> <1.495, 2.052, 9.308> <1.507, 2.053, 9.292> <1.650, 2.003, 8.377> <1.638, 2.017, 8.381> <1.667, 2.052, 8.364> <1.685, 2.053, 8.356> <1.404, 2.003, 7.843> <1.392, 2.017, 7.848> <1.425, 2.052, 7.833> <1.442, 2.053, 7.825> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.911, 2.053, 9.713> <2.564, 2.082, 8.779> <3.429, 2.088, 7.530> <4.080, 2.103, 6.594> <1.507, 2.053, 9.292> <2.160, 2.082, 8.358> <3.429, 2.088, 7.530> <4.080, 2.103, 6.594> <1.685, 2.053, 8.356> <2.476, 2.082, 7.986> <3.289, 2.088, 6.963> <4.080, 2.103, 6.594> <1.442, 2.053, 7.825> <2.233, 2.082, 7.455> <3.289, 2.088, 6.963> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.958, 2.003, 10.384> <3.957, 2.003, 10.411> <3.961, 1.983, 10.455> <3.955, 2.003, 10.472> <3.324, 2.003, 10.477> <3.323, 2.003, 10.503> <3.307, 1.983, 10.541> <3.301, 2.003, 10.557> <2.382, 2.003, 10.151> <2.364, 2.003, 10.167> <2.350, 1.983, 10.207> <2.339, 2.003, 10.216> <1.938, 2.003, 9.689> <1.920, 2.003, 9.705> <1.890, 1.983, 9.733> <1.879, 2.003, 9.742> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.955, 2.003, 10.472> <3.951, 2.018, 10.485> <3.942, 2.052, 10.449> <3.943, 2.053, 10.428> <3.301, 2.003, 10.557> <3.296, 2.018, 10.570> <3.302, 2.052, 10.536> <3.303, 2.053, 10.516> <2.339, 2.003, 10.216> <2.331, 2.019, 10.224> <2.347, 2.052, 10.195> <2.359, 2.053, 10.179> <1.879, 2.003, 9.742> <1.871, 2.019, 9.750> <1.900, 2.052, 9.729> <1.911, 2.053, 9.713> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.943, 2.053, 10.428> <3.980, 2.082, 9.278> <4.039, 2.088, 7.744> <4.080, 2.103, 6.594> <3.303, 2.053, 10.516> <3.340, 2.082, 9.366> <4.039, 2.088, 7.744> <4.080, 2.103, 6.594> <2.359, 2.053, 10.179> <3.011, 2.082, 9.245> <3.429, 2.088, 7.530> <4.080, 2.103, 6.594> <1.911, 2.053, 9.713> <2.564, 2.082, 8.779> <3.429, 2.088, 7.530> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.863, 2.003, 8.499> <6.883, 2.003, 8.514> <6.917, 1.984, 8.539> <6.931, 2.003, 8.549> <6.511, 2.003, 8.918> <6.531, 2.003, 8.933> <6.562, 1.984, 8.971> <6.576, 2.003, 8.982> <5.643, 2.003, 8.917> <5.656, 2.003, 8.944> <5.690, 1.981, 8.983> <5.697, 2.003, 9.003> <5.183, 2.003, 9.216> <5.196, 2.003, 9.243> <5.220, 1.981, 9.286> <5.227, 2.003, 9.306> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.931, 2.003, 8.549> <6.941, 2.017, 8.557> <6.916, 2.052, 8.537> <6.900, 2.053, 8.526> <6.576, 2.003, 8.982> <6.586, 2.017, 8.989> <6.559, 2.052, 8.964> <6.543, 2.053, 8.953> <5.697, 2.003, 9.003> <5.702, 2.018, 9.017> <5.675, 2.052, 8.981> <5.666, 2.053, 8.961> <5.227, 2.003, 9.306> <5.232, 2.018, 9.321> <5.207, 2.052, 9.282> <5.199, 2.053, 9.262> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.900, 2.053, 8.526> <6.055, 2.082, 7.946> <4.926, 2.088, 7.173> <4.080, 2.103, 6.594> <6.543, 2.053, 8.953> <5.698, 2.082, 8.373> <4.926, 2.088, 7.173> <4.080, 2.103, 6.594> <5.666, 2.053, 8.961> <5.328, 2.082, 8.162> <4.416, 2.088, 7.394> <4.080, 2.103, 6.594> <5.199, 2.053, 9.262> <4.861, 2.082, 8.463> <4.416, 2.088, 7.394> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.429, 2.003, 6.541> <7.456, 2.003, 6.533> <7.498, 1.984, 6.520> <7.518, 2.003, 6.515> <7.664, 2.003, 7.105> <7.691, 2.003, 7.097> <7.736, 1.984, 7.109> <7.757, 2.003, 7.104> <7.256, 2.003, 8.030> <7.277, 2.003, 8.046> <7.320, 1.984, 8.048> <7.334, 2.003, 8.058> <6.863, 2.003, 8.499> <6.883, 2.003, 8.514> <6.917, 1.984, 8.539> <6.931, 2.003, 8.549> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.518, 2.003, 6.515> <7.532, 2.015, 6.512> <7.503, 2.052, 6.527> <7.485, 2.053, 6.527> <7.757, 2.003, 7.104> <7.770, 2.015, 7.101> <7.742, 2.052, 7.104> <7.723, 2.053, 7.105> <7.334, 2.003, 8.058> <7.344, 2.017, 8.066> <7.316, 2.052, 8.058> <7.301, 2.053, 8.047> <6.931, 2.003, 8.549> <6.941, 2.017, 8.557> <6.916, 2.052, 8.537> <6.900, 2.053, 8.526> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.485, 2.053, 6.527> <6.464, 2.082, 6.551> <5.101, 2.088, 6.574> <4.080, 2.103, 6.594> <7.723, 2.053, 7.105> <6.702, 2.082, 7.128> <5.101, 2.088, 6.574> <4.080, 2.103, 6.594> <7.301, 2.053, 8.047> <6.455, 2.082, 7.467> <4.926, 2.088, 7.173> <4.080, 2.103, 6.594> <6.900, 2.053, 8.526> <6.055, 2.082, 7.946> <4.926, 2.088, 7.173> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.524, 2.053, 1.134> <3.635, 2.053, 1.895> <3.501, 2.053, 3.690> <2.828, 2.053, 4.647> <4.526, 2.052, 1.114> <3.637, 2.052, 1.875> <3.491, 2.052, 3.673> <2.817, 2.052, 4.630> <4.494, 2.018, 1.086> <3.593, 2.018, 1.838> <3.460, 2.017, 3.650> <2.785, 2.017, 4.611> <4.501, 2.003, 1.097> <3.599, 2.003, 1.849> <3.470, 2.003, 3.659> <2.795, 2.003, 4.620> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.614, 2.053, 6.876> <0.575, 2.053, 7.252> <1.285, 2.053, 7.481> <1.442, 2.053, 7.825> <1.653, 2.082, 6.793> <1.614, 2.082, 7.169> <2.076, 2.082, 7.112> <2.233, 2.082, 7.455> <3.040, 2.088, 6.678> <3.040, 2.088, 6.678> <3.289, 2.088, 6.963> <3.289, 2.088, 6.963> <4.080, 2.103, 6.594> <4.080, 2.103, 6.594> <4.080, 2.103, 6.594> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.943, 2.053, 10.428> <4.452, 2.053, 10.358> <4.766, 2.053, 9.540> <5.199, 2.053, 9.262> <3.942, 2.052, 10.449> <4.451, 2.052, 10.379> <4.775, 2.052, 9.560> <5.207, 2.052, 9.282> <3.951, 2.018, 10.485> <4.464, 2.018, 10.418> <4.797, 2.018, 9.602> <5.232, 2.018, 9.321> <3.955, 2.003, 10.472> <4.469, 2.003, 10.405> <4.792, 2.003, 9.587> <5.227, 2.003, 9.306> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.485, 2.053, 6.527> <7.254, 2.053, 5.969> <5.897, 2.053, 6.175> <5.694, 2.053, 5.606> <7.503, 2.052, 6.527> <7.272, 2.052, 5.969> <5.915, 2.052, 6.164> <5.711, 2.052, 5.596> <7.532, 2.015, 6.512> <7.304, 2.015, 5.949> <5.940, 2.019, 6.139> <5.737, 2.019, 5.567> <7.518, 2.003, 6.515> <7.291, 2.003, 5.952> <5.930, 2.003, 6.147> <5.728, 2.003, 5.575> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.501, 2.003, 1.097> <3.599, 2.003, 1.849> <3.470, 2.003, 3.659> <2.795, 2.003, 4.620> <4.510, 1.983, 1.110> <3.608, 1.983, 1.862> <3.485, 1.983, 3.672> <2.810, 1.983, 4.633> <4.533, 2.003, 1.147> <3.657, 2.003, 1.920> <3.514, 2.003, 3.705> <2.844, 2.003, 4.662> <4.546, 2.003, 1.168> <3.671, 2.003, 1.941> <3.535, 2.003, 3.723> <2.865, 2.003, 4.680> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.558, 2.003, 6.875> <0.518, 2.003, 7.259> <1.243, 2.003, 7.493> <1.404, 2.003, 7.843> <0.540, 2.016, 6.875> <0.500, 2.016, 7.258> <1.231, 2.017, 7.497> <1.392, 2.017, 7.848> <0.591, 2.052, 6.878> <0.552, 2.052, 7.254> <1.267, 2.052, 7.489> <1.425, 2.052, 7.833> <0.614, 2.053, 6.876> <0.575, 2.053, 7.252> <1.285, 2.053, 7.481> <1.442, 2.053, 7.825> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.955, 2.003, 10.472> <4.469, 2.003, 10.405> <4.792, 2.003, 9.587> <5.227, 2.003, 9.306> <3.961, 1.983, 10.455> <4.475, 1.983, 10.388> <4.786, 1.981, 9.567> <5.220, 1.981, 9.286> <3.957, 2.003, 10.411> <4.460, 2.003, 10.337> <4.770, 2.003, 9.519> <5.196, 2.003, 9.243> <3.958, 2.003, 10.384> <4.461, 2.003, 10.311> <4.757, 2.003, 9.492> <5.183, 2.003, 9.216> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.518, 2.003, 6.515> <7.291, 2.003, 5.952> <5.930, 2.003, 6.147> <5.728, 2.003, 5.575> <7.498, 1.984, 6.520> <7.270, 1.984, 5.957> <5.919, 1.983, 6.155> <5.716, 1.983, 5.584> <7.456, 2.003, 6.533> <7.226, 2.003, 5.983> <5.883, 2.003, 6.174> <5.684, 2.003, 5.612> <7.429, 2.003, 6.541> <7.200, 2.003, 5.991> <5.865, 2.003, 6.190> <5.666, 2.003, 5.629> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.199, 2.053, 9.262> <4.861, 2.082, 8.463> <4.416, 2.088, 7.394> <4.080, 2.103, 6.594> <4.766, 2.053, 9.540> <4.428, 2.082, 8.741> <4.416, 2.088, 7.394> <4.080, 2.103, 6.594> <4.452, 2.053, 10.358> <4.489, 2.082, 9.208> <4.039, 2.088, 7.744> <4.080, 2.103, 6.594> <3.943, 2.053, 10.428> <3.980, 2.082, 9.278> <4.039, 2.088, 7.744> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.694, 2.053, 5.606> <5.211, 2.082, 5.905> <4.564, 2.088, 6.298> <4.080, 2.103, 6.594> <5.897, 2.053, 6.175> <5.415, 2.082, 6.473> <4.564, 2.088, 6.298> <4.080, 2.103, 6.594> <7.254, 2.053, 5.969> <6.233, 2.082, 5.992> <5.101, 2.088, 6.574> <4.080, 2.103, 6.594> <7.485, 2.053, 6.527> <6.464, 2.082, 6.551> <5.101, 2.088, 6.574> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <2.828, 2.053, 4.647> <3.206, 2.082, 5.229> <3.704, 2.088, 6.010> <4.080, 2.103, 6.594> <3.501, 2.053, 3.690> <3.880, 2.082, 4.271> <3.704, 2.088, 6.010> <4.080, 2.103, 6.594> <3.635, 2.053, 1.895> <3.510, 2.083, 3.534> <4.213, 2.088, 4.956> <4.080, 2.103, 6.594> <4.524, 2.053, 1.134> <4.399, 2.083, 2.772> <4.213, 2.088, 4.956> <4.080, 2.103, 6.594> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.404, 2.003, 7.843> <1.420, 1.983, 7.837> <1.460, 2.003, 7.820> <1.484, 2.003, 7.810> <1.243, 2.003, 7.493> <1.259, 1.983, 7.487> <1.310, 2.003, 7.483> <1.333, 2.003, 7.473> <0.518, 2.003, 7.259> <0.548, 1.981, 7.260> <0.608, 2.003, 7.244> <0.645, 2.003, 7.245> <0.558, 2.003, 6.875> <0.588, 1.981, 6.876> <0.645, 2.003, 6.878> <0.682, 2.003, 6.879> }
    texture { molten_metal }
  }
  //patch_cross
  union{
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.280, 2.003, 2.509> <5.280, 2.048, 2.509> <5.280, 2.108, 2.509> <5.280, 2.153, 2.509> <5.010, 2.003, 3.678> <5.010, 2.048, 3.678> <5.010, 2.108, 3.678> <5.010, 2.153, 3.678> <4.650, 2.003, 5.237> <4.650, 2.048, 5.237> <4.650, 2.108, 5.237> <4.650, 2.153, 5.237> <4.380, 2.003, 6.406> <4.380, 2.048, 6.406> <4.380, 2.108, 6.406> <4.380, 2.153, 6.406> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.792, 2.003, 2.396> <4.792, 2.048, 2.396> <4.792, 2.108, 2.396> <4.792, 2.153, 2.396> <4.939, 2.003, 2.430> <4.939, 2.048, 2.430> <4.939, 2.108, 2.430> <4.939, 2.153, 2.430> <5.133, 2.003, 2.475> <5.133, 2.048, 2.475> <5.133, 2.108, 2.475> <5.133, 2.153, 2.475> <5.280, 2.003, 2.509> <5.280, 2.048, 2.509> <5.280, 2.108, 2.509> <5.280, 2.153, 2.509> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.944, 2.003, 5.844> <1.944, 2.048, 5.844> <1.944, 2.108, 5.844> <1.944, 2.153, 5.844> <2.529, 2.003, 5.979> <2.529, 2.048, 5.979> <2.529, 2.108, 5.979> <2.529, 2.153, 5.979> <3.308, 2.003, 6.159> <3.308, 2.048, 6.159> <3.308, 2.108, 6.159> <3.308, 2.153, 6.159> <3.893, 2.003, 6.294> <3.893, 2.048, 6.294> <3.893, 2.108, 6.294> <3.893, 2.153, 6.294> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.831, 2.003, 6.331> <1.831, 2.048, 6.331> <1.831, 2.108, 6.331> <1.831, 2.153, 6.331> <1.865, 2.003, 6.185> <1.865, 2.048, 6.185> <1.865, 2.108, 6.185> <1.865, 2.153, 6.185> <1.910, 2.003, 5.990> <1.910, 2.048, 5.990> <1.910, 2.108, 5.990> <1.910, 2.153, 5.990> <1.944, 2.003, 5.844> <1.944, 2.048, 5.844> <1.944, 2.108, 5.844> <1.944, 2.153, 5.844> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.330, 2.003, 8.730> <3.330, 2.048, 8.730> <3.330, 2.108, 8.730> <3.330, 2.153, 8.730> <3.465, 2.003, 8.145> <3.465, 2.048, 8.145> <3.465, 2.108, 8.145> <3.465, 2.153, 8.145> <3.645, 2.003, 7.366> <3.645, 2.048, 7.366> <3.645, 2.108, 7.366> <3.645, 2.153, 7.366> <3.780, 2.003, 6.781> <3.780, 2.048, 6.781> <3.780, 2.108, 6.781> <3.780, 2.153, 6.781> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.817, 2.003, 8.842> <3.817, 2.048, 8.842> <3.817, 2.108, 8.842> <3.817, 2.153, 8.842> <3.671, 2.003, 8.809> <3.671, 2.048, 8.809> <3.671, 2.108, 8.809> <3.671, 2.153, 8.809> <3.476, 2.003, 8.764> <3.476, 2.048, 8.764> <3.476, 2.108, 8.764> <3.476, 2.153, 8.764> <3.330, 2.003, 8.730> <3.330, 2.048, 8.730> <3.330, 2.108, 8.730> <3.330, 2.153, 8.730> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.216, 2.003, 7.343> <6.216, 2.048, 7.343> <6.216, 2.108, 7.343> <6.216, 2.153, 7.343> <5.631, 2.003, 7.208> <5.631, 2.048, 7.208> <5.631, 2.108, 7.208> <5.631, 2.153, 7.208> <4.852, 2.003, 7.029> <4.852, 2.048, 7.029> <4.852, 2.108, 7.029> <4.852, 2.153, 7.029> <4.267, 2.003, 6.894> <4.267, 2.048, 6.894> <4.267, 2.108, 6.894> <4.267, 2.153, 6.894> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.329, 2.003, 6.856> <6.329, 2.048, 6.856> <6.329, 2.108, 6.856> <6.329, 2.153, 6.856> <6.295, 2.003, 7.002> <6.295, 2.048, 7.002> <6.295, 2.108, 7.002> <6.295, 2.153, 7.002> <6.250, 2.003, 7.197> <6.250, 2.048, 7.197> <6.250, 2.108, 7.197> <6.250, 2.153, 7.197> <6.216, 2.003, 7.343> <6.216, 2.048, 7.343> <6.216, 2.108, 7.343> <6.216, 2.153, 7.343> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.792, 2.003, 2.396> <4.522, 2.003, 3.566> <4.163, 2.003, 5.125> <3.893, 2.003, 6.294> <4.792, 2.048, 2.396> <4.522, 2.048, 3.566> <4.163, 2.048, 5.125> <3.893, 2.048, 6.294> <4.792, 2.108, 2.396> <4.522, 2.108, 3.566> <4.163, 2.108, 5.125> <3.893, 2.108, 6.294> <4.792, 2.153, 2.396> <4.522, 2.153, 3.566> <4.163, 2.153, 5.125> <3.893, 2.153, 6.294> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.329, 2.003, 6.856> <5.744, 2.003, 6.721> <4.964, 2.003, 6.541> <4.380, 2.003, 6.406> <6.329, 2.048, 6.856> <5.744, 2.048, 6.721> <4.964, 2.048, 6.541> <4.380, 2.048, 6.406> <6.329, 2.108, 6.856> <5.744, 2.108, 6.721> <4.964, 2.108, 6.541> <4.380, 2.108, 6.406> <6.329, 2.153, 6.856> <5.744, 2.153, 6.721> <4.964, 2.153, 6.541> <4.380, 2.153, 6.406> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.280, 2.153, 2.509> <5.133, 2.153, 2.475> <4.939, 2.153, 2.430> <4.792, 2.153, 2.396> <5.010, 2.153, 3.678> <4.864, 2.153, 3.644> <4.669, 2.153, 3.599> <4.522, 2.153, 3.566> <4.650, 2.153, 5.237> <4.504, 2.153, 5.203> <4.309, 2.153, 5.158> <4.163, 2.153, 5.125> <4.380, 2.153, 6.406> <4.234, 2.153, 6.373> <4.039, 2.153, 6.328> <3.893, 2.153, 6.294> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.893, 2.153, 6.294> <3.308, 2.153, 6.159> <2.529, 2.153, 5.979> <1.944, 2.153, 5.844> <3.859, 2.153, 6.440> <3.274, 2.153, 6.305> <2.495, 2.153, 6.125> <1.910, 2.153, 5.990> <3.814, 2.153, 6.635> <3.229, 2.153, 6.500> <2.450, 2.153, 6.320> <1.865, 2.153, 6.185> <3.780, 2.153, 6.781> <3.196, 2.153, 6.646> <2.416, 2.153, 6.466> <1.831, 2.153, 6.331> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.831, 2.153, 6.331> <2.416, 2.153, 6.466> <3.196, 2.153, 6.646> <3.780, 2.153, 6.781> <1.831, 2.108, 6.331> <2.416, 2.108, 6.466> <3.196, 2.108, 6.646> <3.780, 2.108, 6.781> <1.831, 2.048, 6.331> <2.416, 2.048, 6.466> <3.196, 2.048, 6.646> <3.780, 2.048, 6.781> <1.831, 2.003, 6.331> <2.416, 2.003, 6.466> <3.196, 2.003, 6.646> <3.780, 2.003, 6.781> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.780, 2.153, 6.781> <3.645, 2.153, 7.366> <3.465, 2.153, 8.145> <3.330, 2.153, 8.730> <3.926, 2.153, 6.815> <3.791, 2.153, 7.399> <3.611, 2.153, 8.179> <3.476, 2.153, 8.764> <4.121, 2.153, 6.860> <3.986, 2.153, 7.444> <3.806, 2.153, 8.224> <3.671, 2.153, 8.809> <4.267, 2.153, 6.894> <4.132, 2.153, 7.478> <3.952, 2.153, 8.258> <3.817, 2.153, 8.842> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.817, 2.153, 8.842> <3.952, 2.153, 8.258> <4.132, 2.153, 7.478> <4.267, 2.153, 6.894> <3.817, 2.108, 8.842> <3.952, 2.108, 8.258> <4.132, 2.108, 7.478> <4.267, 2.108, 6.894> <3.817, 2.048, 8.842> <3.952, 2.048, 8.258> <4.132, 2.048, 7.478> <4.267, 2.048, 6.894> <3.817, 2.003, 8.842> <3.952, 2.003, 8.258> <4.132, 2.003, 7.478> <4.267, 2.003, 6.894> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.329, 2.153, 6.856> <5.744, 2.153, 6.721> <4.964, 2.153, 6.541> <4.380, 2.153, 6.406> <6.295, 2.153, 7.002> <5.710, 2.153, 6.867> <4.931, 2.153, 6.687> <4.346, 2.153, 6.553> <6.250, 2.153, 7.197> <5.665, 2.153, 7.062> <4.886, 2.153, 6.882> <4.301, 2.153, 6.747> <6.216, 2.153, 7.343> <5.631, 2.153, 7.208> <4.852, 2.153, 7.029> <4.267, 2.153, 6.894> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.267, 2.153, 6.894> <4.301, 2.153, 6.747> <4.346, 2.153, 6.553> <4.380, 2.153, 6.406> <4.121, 2.153, 6.860> <4.155, 2.153, 6.714> <4.200, 2.153, 6.519> <4.234, 2.153, 6.373> <3.926, 2.153, 6.815> <3.960, 2.153, 6.669> <4.005, 2.153, 6.474> <4.039, 2.153, 6.328> <3.780, 2.153, 6.781> <3.814, 2.153, 6.635> <3.859, 2.153, 6.440> <3.893, 2.153, 6.294> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.562, 2.077, 8.836> <3.562, 2.105, 8.836> <3.567, 2.127, 8.814> <3.574, 2.127, 8.787> <3.562, 2.050, 8.836> <3.562, 2.077, 8.836> <3.574, 2.127, 8.787> <3.580, 2.127, 8.760> <3.567, 2.027, 8.814> <3.574, 2.027, 8.787> <3.585, 2.077, 8.739> <3.585, 2.105, 8.739> <3.574, 2.027, 8.787> <3.580, 2.027, 8.760> <3.585, 2.050, 8.739> <3.585, 2.077, 8.739> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.562, 2.077, 8.836> <3.562, 2.105, 8.836> <3.567, 2.127, 8.814> <3.574, 2.127, 8.787> <3.482, 2.077, 8.817> <3.482, 2.105, 8.817> <3.460, 2.127, 8.789> <3.466, 2.127, 8.762> <3.401, 2.077, 8.868> <3.401, 2.105, 8.868> <3.385, 2.127, 8.836> <3.358, 2.127, 8.830> <3.382, 2.077, 8.948> <3.382, 2.105, 8.948> <3.361, 2.127, 8.943> <3.334, 2.127, 8.937> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.574, 2.127, 8.787> <3.580, 2.127, 8.760> <3.585, 2.105, 8.739> <3.585, 2.077, 8.739> <3.466, 2.127, 8.762> <3.472, 2.127, 8.736> <3.450, 2.105, 8.707> <3.450, 2.077, 8.707> <3.358, 2.127, 8.830> <3.332, 2.127, 8.823> <3.316, 2.105, 8.791> <3.316, 2.077, 8.791> <3.334, 2.127, 8.937> <3.307, 2.127, 8.931> <3.285, 2.105, 8.926> <3.285, 2.077, 8.926> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.585, 2.077, 8.739> <3.585, 2.050, 8.739> <3.580, 2.027, 8.760> <3.574, 2.027, 8.787> <3.450, 2.077, 8.707> <3.450, 2.050, 8.707> <3.472, 2.027, 8.736> <3.466, 2.027, 8.762> <3.316, 2.077, 8.791> <3.316, 2.050, 8.791> <3.332, 2.027, 8.823> <3.358, 2.027, 8.830> <3.285, 2.077, 8.926> <3.285, 2.050, 8.926> <3.307, 2.027, 8.931> <3.334, 2.027, 8.937> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.574, 2.027, 8.787> <3.567, 2.027, 8.814> <3.562, 2.050, 8.836> <3.562, 2.077, 8.836> <3.466, 2.027, 8.762> <3.460, 2.027, 8.789> <3.482, 2.050, 8.817> <3.482, 2.077, 8.817> <3.358, 2.027, 8.830> <3.385, 2.027, 8.836> <3.401, 2.050, 8.868> <3.401, 2.077, 8.868> <3.334, 2.027, 8.937> <3.361, 2.027, 8.943> <3.382, 2.050, 8.948> <3.382, 2.077, 8.948> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.675, 2.077, 9.016> <3.675, 2.105, 9.016> <3.697, 2.127, 9.021> <3.723, 2.127, 9.027> <3.693, 2.077, 8.935> <3.693, 2.105, 8.935> <3.721, 2.127, 8.913> <3.748, 2.127, 8.920> <3.643, 2.077, 8.855> <3.643, 2.105, 8.855> <3.675, 2.127, 8.839> <3.681, 2.127, 8.812> <3.562, 2.077, 8.836> <3.562, 2.105, 8.836> <3.567, 2.127, 8.814> <3.574, 2.127, 8.787> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.723, 2.127, 9.027> <3.750, 2.127, 9.033> <3.772, 2.105, 9.038> <3.772, 2.077, 9.038> <3.748, 2.127, 8.920> <3.775, 2.127, 8.926> <3.803, 2.105, 8.904> <3.803, 2.077, 8.904> <3.681, 2.127, 8.812> <3.687, 2.127, 8.785> <3.719, 2.105, 8.770> <3.719, 2.077, 8.770> <3.574, 2.127, 8.787> <3.580, 2.127, 8.760> <3.585, 2.105, 8.739> <3.585, 2.077, 8.739> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.772, 2.077, 9.038> <3.772, 2.050, 9.038> <3.750, 2.027, 9.033> <3.723, 2.027, 9.027> <3.803, 2.077, 8.904> <3.803, 2.050, 8.904> <3.775, 2.027, 8.926> <3.748, 2.027, 8.920> <3.719, 2.077, 8.770> <3.719, 2.050, 8.770> <3.687, 2.027, 8.785> <3.681, 2.027, 8.812> <3.585, 2.077, 8.739> <3.585, 2.050, 8.739> <3.580, 2.027, 8.760> <3.574, 2.027, 8.787> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.723, 2.027, 9.027> <3.697, 2.027, 9.021> <3.675, 2.050, 9.016> <3.675, 2.077, 9.016> <3.748, 2.027, 8.920> <3.721, 2.027, 8.913> <3.693, 2.050, 8.935> <3.693, 2.077, 8.935> <3.681, 2.027, 8.812> <3.675, 2.027, 8.839> <3.643, 2.050, 8.855> <3.643, 2.077, 8.855> <3.574, 2.027, 8.787> <3.567, 2.027, 8.814> <3.562, 2.050, 8.836> <3.562, 2.077, 8.836> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.675, 2.077, 9.016> <3.656, 2.077, 9.096> <3.576, 2.077, 9.147> <3.495, 2.077, 9.129> <3.675, 2.050, 9.016> <3.656, 2.050, 9.096> <3.576, 2.050, 9.147> <3.495, 2.050, 9.129> <3.697, 2.027, 9.021> <3.672, 2.027, 9.128> <3.597, 2.027, 9.175> <3.490, 2.027, 9.150> <3.723, 2.027, 9.027> <3.699, 2.027, 9.135> <3.591, 2.027, 9.202> <3.484, 2.027, 9.177> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.495, 2.077, 9.129> <3.414, 2.077, 9.110> <3.364, 2.077, 9.029> <3.382, 2.077, 8.948> <3.495, 2.050, 9.129> <3.414, 2.050, 9.110> <3.364, 2.050, 9.029> <3.382, 2.050, 8.948> <3.490, 2.027, 9.150> <3.382, 2.027, 9.126> <3.336, 2.027, 9.051> <3.361, 2.027, 8.943> <3.484, 2.027, 9.177> <3.376, 2.027, 9.152> <3.309, 2.027, 9.045> <3.334, 2.027, 8.937> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.723, 2.127, 9.027> <3.699, 2.127, 9.135> <3.591, 2.127, 9.202> <3.484, 2.127, 9.177> <3.697, 2.127, 9.021> <3.672, 2.127, 9.128> <3.597, 2.127, 9.175> <3.490, 2.127, 9.150> <3.675, 2.105, 9.016> <3.656, 2.105, 9.096> <3.576, 2.105, 9.147> <3.495, 2.105, 9.129> <3.675, 2.077, 9.016> <3.656, 2.077, 9.096> <3.576, 2.077, 9.147> <3.495, 2.077, 9.129> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.484, 2.127, 9.177> <3.376, 2.127, 9.152> <3.309, 2.127, 9.045> <3.334, 2.127, 8.937> <3.490, 2.127, 9.150> <3.382, 2.127, 9.126> <3.336, 2.127, 9.051> <3.361, 2.127, 8.943> <3.495, 2.105, 9.129> <3.414, 2.105, 9.110> <3.364, 2.105, 9.029> <3.382, 2.105, 8.948> <3.495, 2.077, 9.129> <3.414, 2.077, 9.110> <3.364, 2.077, 9.029> <3.382, 2.077, 8.948> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.772, 2.077, 9.038> <3.741, 2.077, 9.173> <3.607, 2.077, 9.257> <3.472, 2.077, 9.226> <3.772, 2.105, 9.038> <3.741, 2.105, 9.173> <3.607, 2.105, 9.257> <3.472, 2.105, 9.226> <3.750, 2.127, 9.033> <3.726, 2.127, 9.141> <3.585, 2.127, 9.229> <3.478, 2.127, 9.204> <3.723, 2.127, 9.027> <3.699, 2.127, 9.135> <3.591, 2.127, 9.202> <3.484, 2.127, 9.177> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.472, 2.077, 9.226> <3.338, 2.077, 9.195> <3.254, 2.077, 9.060> <3.285, 2.077, 8.926> <3.472, 2.105, 9.226> <3.338, 2.105, 9.195> <3.254, 2.105, 9.060> <3.285, 2.105, 8.926> <3.478, 2.127, 9.204> <3.370, 2.127, 9.179> <3.282, 2.127, 9.039> <3.307, 2.127, 8.931> <3.484, 2.127, 9.177> <3.376, 2.127, 9.152> <3.309, 2.127, 9.045> <3.334, 2.127, 8.937> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.723, 2.027, 9.027> <3.699, 2.027, 9.135> <3.591, 2.027, 9.202> <3.484, 2.027, 9.177> <3.750, 2.027, 9.033> <3.726, 2.027, 9.141> <3.585, 2.027, 9.229> <3.478, 2.027, 9.204> <3.772, 2.050, 9.038> <3.741, 2.050, 9.173> <3.607, 2.050, 9.257> <3.472, 2.050, 9.226> <3.772, 2.077, 9.038> <3.741, 2.077, 9.173> <3.607, 2.077, 9.257> <3.472, 2.077, 9.226> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.484, 2.027, 9.177> <3.376, 2.027, 9.152> <3.309, 2.027, 9.045> <3.334, 2.027, 8.937> <3.478, 2.027, 9.204> <3.370, 2.027, 9.179> <3.282, 2.027, 9.039> <3.307, 2.027, 8.931> <3.472, 2.050, 9.226> <3.338, 2.050, 9.195> <3.254, 2.050, 9.060> <3.285, 2.050, 8.926> <3.472, 2.077, 9.226> <3.338, 2.077, 9.195> <3.254, 2.077, 9.060> <3.285, 2.077, 8.926> }
    texture { cross_metal }
  }
  //patch_smoke
  union{
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.394, 3.003, 0.946> <6.222, 3.003, 0.319> <5.072, 3.003, -0.646> <4.573, 3.003, -0.229> <6.317, 2.600, 1.157> <6.145, 2.600, 0.530> <5.071, 2.602, -0.349> <4.572, 2.602, 0.068> <6.063, 2.303, 1.693> <5.929, 2.303, 1.204> <4.912, 2.303, 0.374> <4.523, 2.303, 0.699> <5.921, 2.003, 2.013> <5.787, 2.003, 1.524> <4.891, 2.003, 0.772> <4.501, 2.003, 1.097> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.573, 3.003, -0.229> <3.416, 3.003, 0.735> <3.251, 3.003, 3.057> <2.385, 3.003, 4.289> <4.572, 2.602, 0.068> <3.415, 2.602, 1.032> <3.310, 2.670, 3.086> <2.444, 2.670, 4.318> <4.523, 2.303, 0.699> <3.621, 2.303, 1.451> <3.347, 2.303, 3.560> <2.672, 2.303, 4.521> <4.501, 2.003, 1.097> <3.599, 2.003, 1.849> <3.470, 2.003, 3.659> <2.795, 2.003, 4.620> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <2.385, 3.003, 4.289> <2.121, 3.003, 4.665> <1.300, 3.003, 4.564> <0.976, 3.003, 4.890> <2.444, 2.670, 4.318> <2.180, 2.670, 4.694> <1.425, 2.650, 4.587> <1.101, 2.650, 4.913> <2.672, 2.303, 4.521> <2.466, 2.303, 4.814> <1.733, 2.303, 4.775> <1.481, 2.303, 5.029> <2.795, 2.003, 4.620> <2.589, 2.003, 4.913> <1.949, 2.003, 4.834> <1.697, 2.003, 5.088> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.976, 3.003, 4.890> <0.402, 3.003, 5.469> <-0.398, 3.003, 6.371> <-0.484, 3.003, 7.182> <1.101, 2.650, 4.913> <0.527, 2.650, 5.492> <-0.210, 2.610, 6.287> <-0.297, 2.610, 7.097> <1.481, 2.303, 5.029> <1.033, 2.303, 5.480> <0.313, 2.303, 6.335> <0.246, 2.303, 6.967> <1.697, 2.003, 5.088> <1.249, 2.003, 5.540> <0.625, 2.003, 6.243> <0.558, 2.003, 6.875> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-0.484, 3.003, 7.182> <-0.537, 3.003, 7.674> <0.394, 3.003, 7.975> <0.601, 3.003, 8.424> <-0.297, 2.610, 7.097> <-0.349, 2.610, 7.589> <0.547, 2.632, 7.842> <0.754, 2.632, 8.292> <0.246, 2.303, 6.967> <0.205, 2.303, 7.351> <1.002, 2.303, 7.667> <1.163, 2.303, 8.017> <0.558, 2.003, 6.875> <0.518, 2.003, 7.259> <1.243, 2.003, 7.493> <1.404, 2.003, 7.843> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.601, 3.003, 8.424> <0.916, 3.003, 9.108> <0.686, 3.003, 10.319> <1.210, 3.003, 10.860> <0.754, 2.632, 8.292> <1.069, 2.632, 8.976> <0.778, 2.569, 10.105> <1.302, 2.569, 10.646> <1.163, 2.303, 8.017> <1.409, 2.303, 8.551> <1.270, 2.303, 9.656> <1.679, 2.303, 10.078> <1.404, 2.003, 7.843> <1.650, 2.003, 8.377> <1.470, 2.003, 9.321> <1.879, 2.003, 9.742> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.210, 3.003, 10.860> <1.800, 3.003, 11.467> <3.033, 3.003, 11.905> <3.873, 3.003, 11.796> <1.302, 2.569, 10.646> <1.892, 2.569, 11.254> <3.037, 2.561, 11.675> <3.877, 2.561, 11.566> <1.679, 2.303, 10.078> <2.138, 2.303, 10.551> <3.276, 2.303, 10.954> <3.931, 2.303, 10.869> <1.879, 2.003, 9.742> <2.339, 2.003, 10.216> <3.301, 2.003, 10.557> <3.955, 2.003, 10.472> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.873, 3.003, 11.796> <4.531, 3.003, 11.710> <4.946, 3.003, 10.661> <5.504, 3.003, 10.300> <3.877, 2.561, 11.566> <4.535, 2.561, 11.480> <4.929, 2.624, 10.456> <5.487, 2.624, 10.095> <3.931, 2.303, 10.869> <4.444, 2.303, 10.802> <4.875, 2.303, 9.885> <5.310, 2.303, 9.604> <3.955, 2.003, 10.472> <4.469, 2.003, 10.405> <4.792, 2.003, 9.587> <5.227, 2.003, 9.306> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.504, 3.003, 10.300> <6.106, 3.003, 9.911> <7.234, 3.003, 9.884> <7.689, 3.003, 9.329> <5.487, 2.624, 10.095> <6.089, 2.624, 9.706> <7.053, 2.617, 9.763> <7.508, 2.617, 9.209> <5.310, 2.303, 9.604> <5.780, 2.303, 9.301> <6.803, 2.303, 9.216> <7.158, 2.303, 8.783> <5.227, 2.003, 9.306> <5.697, 2.003, 9.003> <6.576, 2.003, 8.982> <6.931, 2.003, 8.549> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.689, 3.003, 9.329> <8.206, 3.003, 8.700> <8.748, 3.003, 7.476> <8.443, 3.003, 6.720> <7.508, 2.617, 9.209> <8.025, 2.617, 8.579> <8.570, 2.632, 7.438> <8.265, 2.632, 6.683> <7.158, 2.303, 8.783> <7.561, 2.303, 8.292> <8.034, 2.303, 7.165> <7.796, 2.303, 6.577> <6.931, 2.003, 8.549> <7.334, 2.003, 8.058> <7.757, 2.003, 7.104> <7.518, 2.003, 6.515> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.443, 3.003, 6.720> <8.151, 3.003, 5.999> <6.406, 3.003, 6.248> <6.146, 3.003, 5.514> <8.265, 2.632, 6.683> <7.973, 2.632, 5.962> <6.368, 2.680, 6.271> <6.108, 2.680, 5.538> <7.796, 2.303, 6.577> <7.568, 2.303, 6.014> <6.056, 2.303, 6.128> <5.853, 2.303, 5.557> <7.518, 2.003, 6.515> <7.291, 2.003, 5.952> <5.930, 2.003, 6.147> <5.728, 2.003, 5.575> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.146, 3.003, 5.514> <5.687, 3.003, 4.221> <6.756, 3.003, 2.270> <6.394, 3.003, 0.946> <6.108, 2.680, 5.538> <5.649, 2.680, 4.244> <6.680, 2.600, 2.481> <6.317, 2.600, 1.157> <5.853, 2.303, 5.557> <5.495, 2.303, 4.548> <6.345, 2.303, 2.725> <6.063, 2.303, 1.693> <5.728, 2.003, 5.575> <5.370, 2.003, 4.566> <6.204, 2.003, 3.045> <5.921, 2.003, 2.013> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.394, 3.003, 0.946> <6.498, 3.548, 0.659> <6.474, 4.398, 0.504> <6.495, 5.018, 0.426> <6.756, 3.003, 2.270> <6.860, 3.548, 1.983> <6.824, 4.398, 1.945> <6.846, 5.018, 1.867> <5.687, 3.003, 4.221> <5.758, 3.604, 4.176> <5.560, 4.412, 3.987> <5.551, 5.018, 3.969> <6.146, 3.003, 5.514> <6.217, 3.604, 5.470> <6.094, 4.412, 5.370> <6.085, 5.018, 5.353> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.495, 5.018, 0.426> <6.516, 5.614, 0.352> <6.496, 6.421, 0.412> <6.531, 7.020, 0.444> <6.846, 5.018, 1.867> <6.866, 5.614, 1.793> <6.916, 6.421, 1.844> <6.951, 7.020, 1.876> <5.551, 5.018, 3.969> <5.541, 5.619, 3.952> <5.526, 6.419, 4.023> <5.531, 7.020, 4.013> <6.085, 5.018, 5.353> <6.076, 5.619, 5.336> <6.079, 6.419, 5.410> <6.084, 7.020, 5.399> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.531, 7.020, 0.444> <6.567, 7.624, 0.476> <6.670, 8.421, 0.582> <6.729, 9.022, 0.642> <6.951, 7.020, 1.876> <6.986, 7.624, 1.909> <7.060, 8.421, 1.931> <7.119, 9.022, 1.990> <5.531, 7.020, 4.013> <5.537, 7.622, 4.002> <5.680, 8.421, 3.981> <5.691, 9.022, 3.945> <6.084, 7.020, 5.399> <6.090, 7.622, 5.389> <6.110, 8.421, 5.317> <6.121, 9.022, 5.282> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.573, 3.003, -0.229> <4.574, 3.536, -0.625> <4.554, 4.361, -1.057> <4.507, 5.018, -1.139> <5.072, 3.003, -0.646> <5.073, 3.536, -1.041> <5.110, 4.361, -1.573> <5.064, 5.018, -1.655> <6.222, 3.003, 0.319> <6.326, 3.548, 0.032> <6.295, 4.398, -0.234> <6.316, 5.018, -0.311> <6.394, 3.003, 0.946> <6.498, 3.548, 0.659> <6.474, 4.398, 0.504> <6.495, 5.018, 0.426> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.507, 5.018, -1.139> <4.464, 5.628, -1.216> <4.323, 6.405, -0.748> <4.289, 7.020, -0.734> <5.064, 5.018, -1.655> <5.021, 5.628, -1.732> <4.904, 6.405, -1.237> <4.871, 7.020, -1.222> <6.316, 5.018, -0.311> <6.337, 5.614, -0.386> <6.283, 6.421, -0.317> <6.318, 7.020, -0.285> <6.495, 5.018, 0.426> <6.516, 5.614, 0.352> <6.496, 6.421, 0.412> <6.531, 7.020, 0.444> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.289, 7.020, -0.734> <4.257, 7.627, -0.719> <4.290, 8.421, -0.952> <4.291, 9.022, -1.046> <4.871, 7.020, -1.222> <4.838, 7.627, -1.208> <4.993, 8.421, -1.498> <4.993, 9.022, -1.592> <6.318, 7.020, -0.285> <6.353, 7.624, -0.253> <6.423, 8.421, -0.272> <6.482, 9.022, -0.213> <6.531, 7.020, 0.444> <6.567, 7.624, 0.476> <6.670, 8.421, 0.582> <6.729, 9.022, 0.642> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <2.385, 3.003, 4.289> <2.278, 3.597, 4.238> <2.258, 4.414, 4.407> <2.253, 5.018, 4.357> <3.251, 3.003, 3.057> <3.144, 3.597, 3.005> <3.222, 4.414, 2.908> <3.217, 5.018, 2.858> <3.416, 3.003, 0.735> <3.417, 3.536, 0.340> <3.246, 4.361, 0.154> <3.200, 5.018, 0.072> <4.573, 3.003, -0.229> <4.574, 3.536, -0.625> <4.554, 4.361, -1.057> <4.507, 5.018, -1.139> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <2.253, 5.018, 4.357> <2.248, 5.629, 4.306> <2.397, 6.409, 3.957> <2.351, 7.020, 3.957> <3.217, 5.018, 2.858> <3.212, 5.629, 2.807> <3.286, 6.409, 2.721> <3.240, 7.020, 2.721> <3.200, 5.018, 0.072> <3.157, 5.628, -0.005> <3.157, 6.405, 0.232> <3.124, 7.020, 0.246> <4.507, 5.018, -1.139> <4.464, 5.628, -1.216> <4.323, 6.405, -0.748> <4.289, 7.020, -0.734> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <2.351, 7.020, 3.957> <2.304, 7.642, 3.957> <2.071, 8.421, 4.236> <1.951, 9.022, 4.355> <3.240, 7.020, 2.721> <3.193, 7.642, 2.721> <3.029, 8.421, 2.752> <2.909, 9.022, 2.872> <3.124, 7.020, 0.246> <3.091, 7.627, 0.260> <2.896, 8.421, 0.131> <2.897, 9.022, 0.037> <4.289, 7.020, -0.734> <4.257, 7.627, -0.719> <4.290, 8.421, -0.952> <4.291, 9.022, -1.046> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.976, 3.003, 4.890> <0.771, 3.580, 4.853> <0.729, 4.413, 4.906> <0.627, 5.018, 4.894> <1.300, 3.003, 4.564> <1.095, 3.580, 4.527> <1.091, 4.413, 4.540> <0.989, 5.018, 4.529> <2.121, 3.003, 4.665> <2.014, 3.597, 4.613> <1.981, 4.414, 4.839> <1.976, 5.018, 4.789> <2.385, 3.003, 4.289> <2.278, 3.597, 4.238> <2.258, 4.414, 4.407> <2.253, 5.018, 4.357> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.627, 5.018, 4.894> <0.526, 5.619, 4.883> <0.297, 6.413, 4.857> <0.299, 7.020, 4.814> <0.989, 5.018, 4.529> <0.888, 5.619, 4.517> <0.771, 6.413, 4.387> <0.773, 7.020, 4.344> <1.976, 5.018, 4.789> <1.970, 5.629, 4.738> <2.008, 6.409, 4.499> <1.962, 7.020, 4.499> <2.253, 5.018, 4.357> <2.248, 5.629, 4.306> <2.397, 6.409, 3.957> <2.351, 7.020, 3.957> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.299, 7.020, 4.814> <0.301, 7.631, 4.770> <0.538, 8.421, 4.670> <0.640, 9.022, 4.608> <0.773, 7.020, 4.344> <0.775, 7.631, 4.300> <0.814, 8.421, 4.380> <0.916, 9.022, 4.318> <1.962, 7.020, 4.499> <1.915, 7.642, 4.499> <1.854, 8.421, 4.573> <1.734, 9.022, 4.692> <2.351, 7.020, 3.957> <2.304, 7.642, 3.957> <2.071, 8.421, 4.236> <1.951, 9.022, 4.355> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-0.484, 3.003, 7.182> <-0.749, 3.556, 7.302> <-0.792, 4.401, 7.500> <-0.885, 5.018, 7.528> <-0.398, 3.003, 6.371> <-0.663, 3.556, 6.491> <-0.687, 4.401, 6.595> <-0.779, 5.018, 6.623> <0.402, 3.003, 5.469> <0.197, 3.580, 5.432> <0.088, 4.413, 5.553> <-0.014, 5.018, 5.542> <0.976, 3.003, 4.890> <0.771, 3.580, 4.853> <0.729, 4.413, 4.906> <0.627, 5.018, 4.894> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-0.885, 5.018, 7.528> <-0.974, 5.616, 7.556> <-1.073, 6.415, 7.384> <-1.086, 7.020, 7.367> <-0.779, 5.018, 6.623> <-0.869, 5.616, 6.651> <-1.053, 6.415, 6.513> <-1.066, 7.020, 6.496> <-0.014, 5.018, 5.542> <-0.115, 5.619, 5.530> <-0.321, 6.413, 5.471> <-0.320, 7.020, 5.427> <0.627, 5.018, 4.894> <0.526, 5.619, 4.883> <0.297, 6.413, 4.857> <0.299, 7.020, 4.814> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <-1.086, 7.020, 7.367> <-1.099, 7.621, 7.351> <-1.006, 8.421, 7.403> <-0.972, 9.022, 7.418> <-1.066, 7.020, 6.496> <-1.079, 7.621, 6.479> <-0.825, 8.421, 6.448> <-0.791, 9.022, 6.463> <-0.320, 7.020, 5.427> <-0.318, 7.631, 5.384> <-0.133, 8.421, 5.373> <-0.031, 9.022, 5.311> <0.299, 7.020, 4.814> <0.301, 7.631, 4.770> <0.538, 8.421, 4.670> <0.640, 9.022, 4.608> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.601, 3.003, 8.424> <0.370, 3.561, 8.623> <0.219, 4.386, 8.873> <0.158, 5.018, 8.919> <0.394, 3.003, 7.975> <0.163, 3.561, 8.174> <-0.041, 4.386, 8.421> <-0.102, 5.018, 8.467> <-0.537, 3.003, 7.674> <-0.801, 3.556, 7.794> <-0.853, 4.401, 8.018> <-0.945, 5.018, 8.046> <-0.484, 3.003, 7.182> <-0.749, 3.556, 7.302> <-0.792, 4.401, 7.500> <-0.885, 5.018, 7.528> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.158, 5.018, 8.919> <0.100, 5.618, 8.962> <0.260, 6.418, 8.726> <0.211, 7.020, 8.717> <-0.102, 5.018, 8.467> <-0.160, 5.618, 8.510> <0.032, 6.418, 8.213> <-0.017, 7.020, 8.203> <-0.945, 5.018, 8.046> <-1.035, 5.616, 8.074> <-1.085, 6.415, 7.945> <-1.099, 7.020, 7.929> <-0.885, 5.018, 7.528> <-0.974, 5.616, 7.556> <-1.073, 6.415, 7.384> <-1.086, 7.020, 7.367> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.211, 7.020, 8.717> <0.162, 7.630, 8.707> <-0.052, 8.421, 8.814> <-0.165, 9.022, 8.856> <-0.017, 7.020, 8.203> <-0.066, 7.630, 8.194> <-0.242, 8.421, 8.357> <-0.355, 9.022, 8.399> <-1.099, 7.020, 7.929> <-1.112, 7.621, 7.912> <-1.098, 8.421, 7.889> <-1.064, 9.022, 7.904> <-1.086, 7.020, 7.367> <-1.099, 7.621, 7.351> <-1.006, 8.421, 7.403> <-0.972, 9.022, 7.418> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.210, 3.003, 10.860> <1.096, 3.545, 11.127> <1.321, 4.413, 11.153> <1.241, 5.018, 11.227> <0.686, 3.003, 10.319> <0.571, 3.545, 10.586> <0.732, 4.413, 10.665> <0.652, 5.018, 10.739> <0.916, 3.003, 9.108> <0.685, 3.561, 9.307> <0.600, 4.386, 9.536> <0.539, 5.018, 9.582> <0.601, 3.003, 8.424> <0.370, 3.561, 8.623> <0.219, 4.386, 8.873> <0.158, 5.018, 8.919> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <1.241, 5.018, 11.227> <1.161, 5.633, 11.303> <0.768, 6.402, 11.324> <0.682, 7.020, 11.352> <0.652, 5.018, 10.739> <0.571, 5.633, 10.815> <0.198, 6.402, 10.757> <0.113, 7.020, 10.785> <0.539, 5.018, 9.582> <0.481, 5.618, 9.626> <0.585, 6.418, 9.460> <0.537, 7.020, 9.451> <0.158, 5.018, 8.919> <0.100, 5.618, 8.962> <0.260, 6.418, 8.726> <0.211, 7.020, 8.717> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.682, 7.020, 11.352> <0.600, 7.615, 11.379> <0.685, 8.421, 11.392> <0.687, 9.022, 11.409> <0.113, 7.020, 10.785> <0.030, 7.615, 10.813> <0.080, 8.421, 10.858> <0.081, 9.022, 10.876> <0.537, 7.020, 9.451> <0.488, 7.630, 9.441> <0.258, 8.421, 9.560> <0.145, 9.022, 9.602> <0.211, 7.020, 8.717> <0.162, 7.630, 8.707> <-0.052, 8.421, 8.814> <-0.165, 9.022, 8.856> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.873, 3.003, 11.796> <3.868, 3.543, 12.076> <3.906, 4.419, 11.931> <3.929, 5.018, 12.038> <3.033, 3.003, 11.905> <3.029, 3.543, 12.186> <3.066, 4.419, 11.990> <3.089, 5.018, 12.097> <1.800, 3.003, 11.467> <1.685, 3.545, 11.734> <1.970, 4.413, 11.690> <1.890, 5.018, 11.764> <1.210, 3.003, 10.860> <1.096, 3.545, 11.127> <1.321, 4.413, 11.153> <1.241, 5.018, 11.227> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <3.929, 5.018, 12.038> <3.952, 5.626, 12.147> <4.047, 6.404, 12.465> <4.025, 7.020, 12.512> <3.089, 5.018, 12.097> <3.112, 5.626, 12.205> <2.993, 6.404, 12.598> <2.972, 7.020, 12.644> <1.890, 5.018, 11.764> <1.809, 5.633, 11.839> <1.520, 6.402, 12.073> <1.434, 7.020, 12.101> <1.241, 5.018, 11.227> <1.161, 5.633, 11.303> <0.768, 6.402, 11.324> <0.682, 7.020, 11.352> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <4.025, 7.020, 12.512> <4.004, 7.625, 12.558> <3.860, 8.421, 12.392> <3.789, 9.022, 12.341> <2.972, 7.020, 12.644> <2.951, 7.625, 12.690> <2.901, 8.421, 12.548> <2.830, 9.022, 12.497> <1.434, 7.020, 12.101> <1.352, 7.615, 12.128> <1.414, 8.421, 12.035> <1.416, 9.022, 12.052> <0.682, 7.020, 11.352> <0.600, 7.615, 11.379> <0.685, 8.421, 11.392> <0.687, 9.022, 11.409> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.504, 3.003, 10.300> <5.529, 3.561, 10.603> <5.289, 4.390, 10.878> <5.362, 5.018, 10.939> <4.946, 3.003, 10.661> <4.971, 3.561, 10.963> <4.820, 4.390, 11.149> <4.893, 5.018, 11.209> <4.531, 3.003, 11.710> <4.526, 3.543, 11.991> <4.447, 4.419, 11.894> <4.469, 5.018, 12.000> <3.873, 3.003, 11.796> <3.868, 3.543, 12.076> <3.906, 4.419, 11.931> <3.929, 5.018, 12.038> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.362, 5.018, 10.939> <5.435, 5.643, 10.999> <5.939, 6.391, 10.739> <5.972, 7.020, 10.688> <4.893, 5.018, 11.209> <4.966, 5.643, 11.269> <5.300, 6.391, 11.221> <5.333, 7.020, 11.170> <4.469, 5.018, 12.000> <4.493, 5.626, 12.109> <4.841, 6.404, 12.366> <4.819, 7.020, 12.412> <3.929, 5.018, 12.038> <3.952, 5.626, 12.147> <4.047, 6.404, 12.465> <4.025, 7.020, 12.512> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <5.972, 7.020, 10.688> <6.003, 7.630, 10.638> <5.690, 8.421, 10.636> <5.569, 9.022, 10.614> <5.333, 7.020, 11.170> <5.364, 7.630, 11.120> <5.067, 8.421, 11.044> <4.947, 9.022, 11.022> <4.819, 7.020, 12.412> <4.798, 7.625, 12.458> <4.594, 8.421, 12.273> <4.523, 9.022, 12.221> <4.025, 7.020, 12.512> <4.004, 7.625, 12.558> <3.860, 8.421, 12.392> <3.789, 9.022, 12.341> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.689, 3.003, 9.329> <7.950, 3.558, 9.503> <8.324, 4.383, 9.443> <8.346, 5.018, 9.493> <7.234, 3.003, 9.884> <7.495, 3.558, 10.058> <7.670, 4.383, 10.193> <7.692, 5.018, 10.242> <6.106, 3.003, 9.911> <6.131, 3.561, 10.213> <6.151, 4.390, 10.381> <6.224, 5.018, 10.442> <5.504, 3.003, 10.300> <5.529, 3.561, 10.603> <5.289, 4.390, 10.878> <5.362, 5.018, 10.939> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.346, 5.018, 9.493> <8.368, 5.638, 9.541> <7.901, 6.403, 9.617> <7.832, 7.020, 9.642> <7.692, 5.018, 10.242> <7.714, 5.638, 10.290> <7.503, 6.403, 10.119> <7.434, 7.020, 10.144> <6.224, 5.018, 10.442> <6.297, 5.643, 10.502> <6.451, 6.391, 10.353> <6.483, 7.020, 10.302> <5.362, 5.018, 10.939> <5.435, 5.643, 10.999> <5.939, 6.391, 10.739> <5.972, 7.020, 10.688> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.832, 7.020, 9.642> <7.765, 7.617, 9.666> <7.878, 8.421, 9.650> <7.897, 9.022, 9.654> <7.434, 7.020, 10.144> <7.367, 7.617, 10.168> <7.409, 8.421, 10.243> <7.428, 9.022, 10.246> <6.483, 7.020, 10.302> <6.515, 7.630, 10.253> <6.322, 8.421, 10.223> <6.202, 9.022, 10.201> <5.972, 7.020, 10.688> <6.003, 7.630, 10.638> <5.690, 8.421, 10.636> <5.569, 9.022, 10.614> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.443, 3.003, 6.720> <8.712, 3.564, 6.776> <8.868, 4.400, 6.806> <8.963, 5.018, 6.816> <8.748, 3.003, 7.476> <9.017, 3.564, 7.532> <9.263, 4.400, 7.529> <9.358, 5.018, 7.539> <8.206, 3.003, 8.700> <8.467, 3.558, 8.874> <8.866, 4.383, 8.823> <8.889, 5.018, 8.872> <7.689, 3.003, 9.329> <7.950, 3.558, 9.503> <8.324, 4.383, 9.443> <8.346, 5.018, 9.493> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.963, 5.018, 6.816> <9.055, 5.612, 6.826> <9.105, 6.421, 6.808> <9.062, 7.020, 6.789> <9.358, 5.018, 7.539> <9.450, 5.612, 7.550> <9.460, 6.421, 7.670> <9.417, 7.020, 7.651> <8.889, 5.018, 8.872> <8.911, 5.638, 8.920> <8.480, 6.403, 8.887> <8.411, 7.020, 8.912> <8.346, 5.018, 9.493> <8.368, 5.638, 9.541> <7.901, 6.403, 9.617> <7.832, 7.020, 9.642> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <9.062, 7.020, 6.789> <9.018, 7.631, 6.771> <8.791, 8.421, 6.722> <8.674, 9.022, 6.693> <9.417, 7.020, 7.651> <9.373, 7.631, 7.632> <9.136, 8.421, 7.573> <9.020, 9.022, 7.544> <8.411, 7.020, 8.912> <8.344, 7.617, 8.936> <8.448, 8.421, 8.930> <8.467, 9.022, 8.934> <7.832, 7.020, 9.642> <7.765, 7.617, 9.666> <7.878, 8.421, 9.650> <7.897, 9.022, 9.654> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.146, 3.003, 5.514> <6.217, 3.604, 5.470> <6.094, 4.412, 5.370> <6.085, 5.018, 5.353> <6.406, 3.003, 6.248> <6.477, 3.604, 6.204> <6.443, 4.412, 6.274> <6.434, 5.018, 6.256> <8.151, 3.003, 5.999> <8.420, 3.564, 6.055> <8.403, 4.400, 5.956> <8.499, 5.018, 5.966> <8.443, 3.003, 6.720> <8.712, 3.564, 6.776> <8.868, 4.400, 6.806> <8.963, 5.018, 6.816> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.085, 5.018, 5.353> <6.076, 5.619, 5.336> <6.079, 6.419, 5.410> <6.084, 7.020, 5.399> <6.434, 5.018, 6.256> <6.425, 5.619, 6.239> <6.444, 6.419, 6.326> <6.450, 7.020, 6.315> <8.499, 5.018, 5.966> <8.590, 5.612, 5.976> <8.730, 6.421, 5.896> <8.686, 7.020, 5.878> <8.963, 5.018, 6.816> <9.055, 5.612, 6.826> <9.105, 6.421, 6.808> <9.062, 7.020, 6.789> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <6.084, 7.020, 5.399> <6.090, 7.622, 5.389> <6.110, 8.421, 5.317> <6.121, 9.022, 5.282> <6.450, 7.020, 6.315> <6.455, 7.622, 6.304> <6.378, 8.421, 6.150> <6.389, 9.022, 6.115> <8.686, 7.020, 5.878> <8.642, 7.631, 5.859> <8.461, 8.421, 5.911> <8.345, 9.022, 5.882> <9.062, 7.020, 6.789> <9.018, 7.631, 6.771> <8.791, 8.421, 6.722> <8.674, 9.022, 6.693> }
    texture { molten_smoke }
  }
  //patch_cover
  union{
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.164, 1.902, 0.000> <5.767, 1.902, 0.000> <2.571, 1.896, 0.000> <0.173, 1.902, 0.000> <8.164, 1.902, -0.030> <5.767, 1.902, -0.030> <2.571, 1.897, -0.030> <0.173, 1.902, -0.030> <8.194, 2.002, 0.000> <5.797, 2.032, 0.000> <2.571, 2.005, -0.030> <0.173, 2.002, -0.030> <8.164, 2.002, 0.000> <5.767, 2.032, 0.000> <2.571, 2.005, 0.000> <0.173, 2.002, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.173, 1.902, 0.000> <0.162, 1.902, 0.000> <0.143, 1.932, 0.000> <0.142, 1.921, 0.000> <0.173, 1.902, -0.030> <0.162, 1.902, -0.030> <0.143, 1.932, -0.030> <0.142, 1.921, -0.030> <0.173, 2.002, -0.030> <0.143, 2.002, -0.030> <0.078, 2.022, -0.030> <0.072, 1.992, -0.030> <0.173, 2.002, 0.000> <0.143, 2.002, 0.000> <0.077, 2.022, 0.000> <0.072, 1.992, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.142, 1.921, 0.000> <0.120, 1.647, 0.000> <0.100, 1.281, 0.000> <0.100, 1.007, 0.000> <0.142, 1.921, -0.030> <0.120, 1.648, -0.030> <0.100, 1.281, -0.030> <0.100, 1.007, -0.030> <0.072, 1.992, -0.030> <0.021, 1.700, -0.030> <-0.002, 1.303, -0.030> <0.000, 1.007, -0.030> <0.072, 1.992, 0.000> <0.021, 1.700, 0.000> <-0.002, 1.303, 0.000> <0.000, 1.007, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.100, 1.007, 0.000> <0.100, 0.730, 0.000> <0.118, 0.360, 0.000> <0.139, 0.084, 0.000> <0.100, 1.007, -0.030> <0.099, 0.730, -0.030> <0.118, 0.360, -0.030> <0.139, 0.084, -0.030> <0.000, 1.007, -0.030> <0.002, 0.704, -0.030> <0.035, 0.299, -0.030> <0.086, 0.000, -0.030> <0.000, 1.007, 0.000> <0.002, 0.704, 0.000> <0.035, 0.299, 0.000> <0.086, 0.000, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.139, 0.084, 0.000> <0.140, 0.072, 0.000> <0.159, 0.107, 0.000> <0.170, 0.107, 0.000> <0.139, 0.084, -0.030> <0.140, 0.072, -0.030> <0.159, 0.106, -0.030> <0.170, 0.106, -0.030> <0.086, 0.000, -0.030> <0.090, -0.025, -0.030> <0.145, 0.007, -0.030> <0.170, 0.007, -0.030> <0.086, 0.000, 0.000> <0.090, -0.025, 0.000> <0.145, 0.007, 0.000> <0.170, 0.007, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.170, 0.107, 0.000> <2.569, 0.114, 0.000> <5.767, 0.107, 0.000> <8.166, 0.107, 0.000> <0.170, 0.137, 3.600> <2.569, 0.144, 3.600> <5.767, 0.137, 3.600> <8.166, 0.137, 3.600> <0.170, 0.137, 8.400> <2.569, 0.144, 8.400> <5.767, 0.137, 8.400> <8.166, 0.137, 8.400> <0.170, 0.107, 12.000> <2.569, 0.114, 12.000> <5.767, 0.107, 12.000> <8.166, 0.107, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.170, 0.107, 0.000> <2.569, 0.114, 0.000> <5.767, 0.107, 0.000> <8.166, 0.107, 0.000> <0.170, 0.106, -0.030> <2.569, 0.113, -0.030> <5.767, 0.106, -0.030> <8.166, 0.106, -0.030> <0.170, 0.007, -0.030> <2.569, 0.009, -0.030> <5.798, -0.023, 0.000> <8.196, 0.007, 0.000> <0.170, 0.007, 0.000> <2.569, 0.009, 0.000> <5.768, -0.023, 0.000> <8.166, 0.007, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.164, 1.902, 12.000> <5.767, 1.902, 12.000> <2.571, 1.896, 12.000> <0.173, 1.902, 12.000> <8.164, 1.872, 8.400> <5.767, 1.872, 8.400> <2.571, 1.866, 8.400> <0.173, 1.872, 8.400> <8.164, 1.872, 3.600> <5.767, 1.872, 3.600> <2.571, 1.866, 3.600> <0.173, 1.872, 3.600> <8.164, 1.902, 0.000> <5.767, 1.902, 0.000> <2.571, 1.896, 0.000> <0.173, 1.902, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.173, 1.902, 12.000> <0.162, 1.902, 12.000> <0.143, 1.932, 12.000> <0.142, 1.921, 12.000> <0.173, 1.872, 8.400> <0.162, 1.872, 8.400> <0.164, 1.911, 8.400> <0.163, 1.900, 8.400> <0.173, 1.872, 3.600> <0.162, 1.872, 3.600> <0.164, 1.911, 3.600> <0.163, 1.900, 3.600> <0.173, 1.902, 0.000> <0.162, 1.902, 0.000> <0.143, 1.932, 0.000> <0.142, 1.921, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.142, 1.921, 12.000> <0.120, 1.647, 12.000> <0.100, 1.281, 12.000> <0.100, 1.007, 12.000> <0.163, 1.900, 8.400> <0.141, 1.626, 8.400> <0.130, 1.281, 8.400> <0.130, 1.007, 8.400> <0.163, 1.900, 3.600> <0.141, 1.626, 3.600> <0.130, 1.281, 3.600> <0.130, 1.007, 3.600> <0.142, 1.921, 0.000> <0.120, 1.647, 0.000> <0.100, 1.281, 0.000> <0.100, 1.007, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.100, 1.007, 12.000> <0.100, 0.730, 12.000> <0.118, 0.360, 12.000> <0.139, 0.084, 12.000> <0.130, 1.007, 8.400> <0.130, 0.730, 8.400> <0.134, 0.385, 8.400> <0.156, 0.109, 8.400> <0.130, 1.007, 3.600> <0.130, 0.730, 3.600> <0.134, 0.385, 3.600> <0.156, 0.109, 3.600> <0.100, 1.007, 0.000> <0.100, 0.730, 0.000> <0.118, 0.360, 0.000> <0.139, 0.084, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.139, 0.084, 12.000> <0.140, 0.072, 12.000> <0.159, 0.107, 12.000> <0.170, 0.107, 12.000> <0.156, 0.109, 8.400> <0.156, 0.098, 8.400> <0.159, 0.137, 8.400> <0.170, 0.137, 8.400> <0.156, 0.109, 3.600> <0.156, 0.098, 3.600> <0.159, 0.137, 3.600> <0.170, 0.137, 3.600> <0.139, 0.084, 0.000> <0.140, 0.072, 0.000> <0.159, 0.107, 0.000> <0.170, 0.107, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.170, 0.107, 12.000> <2.569, 0.114, 12.000> <5.767, 0.107, 12.000> <8.166, 0.107, 12.000> <0.170, 0.106, 12.030> <2.569, 0.113, 12.030> <5.767, 0.106, 12.030> <8.166, 0.106, 12.030> <0.170, 0.007, 12.030> <2.569, 0.009, 12.030> <5.798, -0.023, 12.000> <8.196, 0.007, 12.000> <0.170, 0.007, 12.000> <2.569, 0.009, 12.000> <5.768, -0.023, 12.000> <8.166, 0.007, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.164, 2.002, 12.000> <8.164, 2.002, 8.400> <8.164, 2.002, 3.600> <8.164, 2.002, 0.000> <5.767, 2.032, 12.000> <5.767, 2.032, 8.400> <5.767, 2.032, 3.600> <5.767, 2.032, 0.000> <2.571, 2.005, 12.000> <2.571, 2.035, 8.400> <2.571, 2.035, 3.600> <2.571, 2.005, 0.000> <0.173, 2.002, 12.000> <0.173, 2.032, 8.400> <0.173, 2.032, 3.600> <0.173, 2.002, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.164, 2.002, 12.000> <8.164, 2.002, 8.400> <8.164, 2.002, 3.600> <8.164, 2.002, 0.000> <8.194, 2.002, 12.000> <8.194, 2.002, 8.400> <8.194, 2.002, 3.600> <8.194, 2.002, 0.000> <8.164, 1.902, 12.030> <8.164, 1.872, 8.430> <8.164, 1.872, 3.570> <8.164, 1.902, -0.030> <8.164, 1.902, 12.000> <8.164, 1.872, 8.400> <8.164, 1.872, 3.600> <8.164, 1.902, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.166, 0.107, 12.000> <8.166, 0.137, 8.400> <8.166, 0.137, 3.600> <8.166, 0.107, 0.000> <8.166, 0.106, 12.030> <8.166, 0.136, 8.430> <8.166, 0.136, 3.570> <8.166, 0.106, -0.030> <8.196, 0.007, 12.000> <8.196, 0.007, 8.400> <8.196, 0.007, 3.600> <8.196, 0.007, 0.000> <8.166, 0.007, 12.000> <8.166, 0.007, 8.400> <8.166, 0.007, 3.600> <8.166, 0.007, 0.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.166, 0.007, 0.000> <5.768, -0.023, 0.000> <2.569, 0.009, 0.000> <0.170, 0.007, 0.000> <8.166, 0.007, 3.600> <5.768, -0.023, 3.600> <2.569, -0.021, 3.600> <0.170, -0.023, 3.600> <8.166, 0.007, 8.400> <5.768, -0.023, 8.400> <2.569, -0.021, 8.400> <0.170, -0.023, 8.400> <8.166, 0.007, 12.000> <5.768, -0.023, 12.000> <2.569, 0.009, 12.000> <0.170, 0.007, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.170, 0.007, 0.000> <0.145, 0.007, 0.000> <0.090, -0.025, 0.000> <0.086, 0.000, 0.000> <0.170, -0.023, 3.600> <0.145, -0.023, 3.600> <0.074, -0.050, 3.600> <0.069, -0.025, 3.600> <0.170, -0.023, 8.400> <0.145, -0.023, 8.400> <0.074, -0.050, 8.400> <0.069, -0.025, 8.400> <0.170, 0.007, 12.000> <0.145, 0.007, 12.000> <0.090, -0.025, 12.000> <0.086, 0.000, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.086, 0.000, 0.000> <0.035, 0.299, 0.000> <0.002, 0.704, 0.000> <0.000, 1.007, 0.000> <0.069, -0.025, 3.600> <0.019, 0.274, 3.600> <-0.028, 0.704, 3.600> <-0.030, 1.007, 3.600> <0.069, -0.025, 8.400> <0.019, 0.274, 8.400> <-0.028, 0.704, 8.400> <-0.030, 1.007, 8.400> <0.086, 0.000, 12.000> <0.035, 0.299, 12.000> <0.002, 0.704, 12.000> <0.000, 1.007, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.000, 1.007, 0.000> <-0.002, 1.303, 0.000> <0.021, 1.700, 0.000> <0.072, 1.992, 0.000> <-0.030, 1.007, 3.600> <-0.032, 1.303, 3.600> <0.000, 1.721, 3.600> <0.051, 2.013, 3.600> <-0.030, 1.007, 8.400> <-0.032, 1.303, 8.400> <0.000, 1.721, 8.400> <0.051, 2.013, 8.400> <0.000, 1.007, 12.000> <-0.002, 1.303, 12.000> <0.021, 1.700, 12.000> <0.072, 1.992, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.072, 1.992, 0.000> <0.077, 2.022, 0.000> <0.143, 2.002, 0.000> <0.173, 2.002, 0.000> <0.051, 2.013, 3.600> <0.056, 2.044, 3.600> <0.143, 2.032, 3.600> <0.173, 2.032, 3.600> <0.051, 2.013, 8.400> <0.056, 2.044, 8.400> <0.143, 2.032, 8.400> <0.173, 2.032, 8.400> <0.072, 1.992, 12.000> <0.077, 2.022, 12.000> <0.143, 2.002, 12.000> <0.173, 2.002, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <8.164, 2.002, 12.000> <5.767, 2.032, 12.000> <2.571, 2.005, 12.000> <0.173, 2.002, 12.000> <8.194, 2.002, 12.000> <5.797, 2.032, 12.000> <2.571, 2.005, 12.030> <0.173, 2.002, 12.030> <8.164, 1.902, 12.030> <5.767, 1.902, 12.030> <2.571, 1.897, 12.030> <0.173, 1.902, 12.030> <8.164, 1.902, 12.000> <5.767, 1.902, 12.000> <2.571, 1.896, 12.000> <0.173, 1.902, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.173, 2.002, 12.000> <0.143, 2.002, 12.000> <0.077, 2.022, 12.000> <0.072, 1.992, 12.000> <0.173, 2.002, 12.030> <0.143, 2.002, 12.030> <0.078, 2.022, 12.030> <0.072, 1.992, 12.030> <0.173, 1.902, 12.030> <0.162, 1.902, 12.030> <0.143, 1.932, 12.030> <0.142, 1.921, 12.030> <0.173, 1.902, 12.000> <0.162, 1.902, 12.000> <0.143, 1.932, 12.000> <0.142, 1.921, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.072, 1.992, 12.000> <0.021, 1.700, 12.000> <-0.002, 1.303, 12.000> <0.000, 1.007, 12.000> <0.072, 1.992, 12.030> <0.021, 1.700, 12.030> <-0.002, 1.303, 12.030> <0.000, 1.007, 12.030> <0.142, 1.921, 12.030> <0.120, 1.648, 12.030> <0.100, 1.281, 12.030> <0.100, 1.007, 12.030> <0.142, 1.921, 12.000> <0.120, 1.647, 12.000> <0.100, 1.281, 12.000> <0.100, 1.007, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.000, 1.007, 12.000> <0.002, 0.704, 12.000> <0.035, 0.299, 12.000> <0.086, 0.000, 12.000> <0.000, 1.007, 12.030> <0.002, 0.704, 12.030> <0.035, 0.299, 12.030> <0.086, 0.000, 12.030> <0.100, 1.007, 12.030> <0.099, 0.730, 12.030> <0.118, 0.360, 12.030> <0.139, 0.084, 12.030> <0.100, 1.007, 12.000> <0.100, 0.730, 12.000> <0.118, 0.360, 12.000> <0.139, 0.084, 12.000> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.086, 0.000, 12.000> <0.090, -0.025, 12.000> <0.145, 0.007, 12.000> <0.170, 0.007, 12.000> <0.086, 0.000, 12.030> <0.090, -0.025, 12.030> <0.145, 0.007, 12.030> <0.170, 0.007, 12.030> <0.139, 0.084, 12.030> <0.140, 0.072, 12.030> <0.159, 0.106, 12.030> <0.170, 0.106, 12.030> <0.139, 0.084, 12.000> <0.140, 0.072, 12.000> <0.159, 0.107, 12.000> <0.170, 0.107, 12.000> }
    texture { necronomicon_cover }
  }
  //patch_pages
  union{
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.889, 0.107, 0.300> <7.865, 0.374, 0.300> <7.811, 0.730, 0.300> <7.811, 0.999, 0.300> <7.889, 0.107, 3.720> <7.865, 0.374, 3.720> <7.811, 0.730, 3.720> <7.811, 0.999, 3.720> <7.889, 0.107, 8.280> <7.865, 0.374, 8.280> <7.811, 0.730, 8.280> <7.811, 0.999, 8.280> <7.889, 0.107, 11.700> <7.865, 0.374, 11.700> <7.811, 0.730, 11.700> <7.811, 0.999, 11.700> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.889, 0.107, 0.300> <7.865, 0.374, 0.300> <7.811, 0.730, 0.300> <7.811, 0.999, 0.300> <5.635, 0.107, 0.300> <5.612, 0.374, 0.300> <5.557, 0.729, 0.300> <5.557, 0.998, 0.300> <2.631, 0.107, 0.300> <2.608, 0.374, 0.300> <2.553, 0.729, 0.300> <2.553, 0.997, 0.300> <0.378, 0.107, 0.300> <0.354, 0.374, 0.300> <0.299, 0.728, 0.300> <0.299, 0.996, 0.300> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.378, 1.902, 0.300> <0.354, 1.630, 0.300> <0.299, 1.269, 0.300> <0.299, 0.996, 0.300> <2.631, 1.902, 0.300> <2.608, 1.630, 0.300> <2.553, 1.270, 0.300> <2.553, 0.997, 0.300> <5.635, 1.902, 0.300> <5.612, 1.631, 0.300> <5.557, 1.270, 0.300> <5.557, 0.998, 0.300> <7.889, 1.902, 0.300> <7.865, 1.631, 0.300> <7.811, 1.271, 0.300> <7.811, 0.999, 0.300> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.889, 0.107, 11.700> <7.865, 0.374, 11.700> <7.811, 0.730, 11.700> <7.811, 0.999, 11.700> <5.635, 0.107, 11.700> <5.612, 0.374, 11.700> <5.557, 0.729, 11.700> <5.557, 0.998, 11.700> <2.631, 0.107, 11.700> <2.608, 0.374, 11.700> <2.553, 0.729, 11.700> <2.553, 0.997, 11.700> <0.378, 0.107, 11.700> <0.354, 0.374, 11.700> <0.299, 0.728, 11.700> <0.299, 0.996, 11.700> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.811, 0.999, 11.700> <7.811, 1.271, 11.700> <7.865, 1.631, 11.700> <7.889, 1.902, 11.700> <5.557, 0.998, 11.700> <5.557, 1.270, 11.700> <5.612, 1.631, 11.700> <5.635, 1.902, 11.700> <2.553, 0.997, 11.700> <2.553, 1.270, 11.700> <2.608, 1.630, 11.700> <2.631, 1.902, 11.700> <0.299, 0.996, 11.700> <0.299, 1.269, 11.700> <0.354, 1.630, 11.700> <0.378, 1.902, 11.700> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.811, 0.999, 11.700> <7.811, 1.271, 11.700> <7.865, 1.631, 11.700> <7.889, 1.902, 11.700> <7.811, 0.999, 8.280> <7.811, 1.271, 8.280> <7.865, 1.631, 8.280> <7.889, 1.902, 8.280> <7.811, 0.999, 3.720> <7.811, 1.271, 3.720> <7.865, 1.631, 3.720> <7.889, 1.902, 3.720> <7.811, 0.999, 0.300> <7.811, 1.271, 0.300> <7.865, 1.631, 0.300> <7.889, 1.902, 0.300> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <7.889, 1.902, 11.700> <5.635, 1.902, 11.700> <2.631, 1.902, 11.700> <0.378, 1.902, 11.700> <7.889, 1.902, 8.280> <5.635, 1.902, 8.280> <2.631, 1.902, 8.280> <0.378, 1.902, 8.280> <7.889, 1.902, 3.720> <5.635, 1.902, 3.720> <2.631, 1.902, 3.720> <0.378, 1.902, 3.720> <7.889, 1.902, 0.300> <5.635, 1.902, 0.300> <2.631, 1.902, 0.300> <0.378, 1.902, 0.300> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.378, 1.902, 11.700> <0.354, 1.630, 11.700> <0.299, 1.269, 11.700> <0.299, 0.996, 11.700> <0.378, 1.902, 8.280> <0.354, 1.630, 8.280> <0.299, 1.269, 8.280> <0.299, 0.996, 8.280> <0.378, 1.902, 3.720> <0.354, 1.630, 3.720> <0.299, 1.269, 3.720> <0.299, 0.996, 3.720> <0.378, 1.902, 0.300> <0.354, 1.630, 0.300> <0.299, 1.269, 0.300> <0.299, 0.996, 0.300> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.299, 0.996, 11.700> <0.299, 0.728, 11.700> <0.354, 0.374, 11.700> <0.378, 0.107, 11.700> <0.299, 0.996, 8.280> <0.299, 0.728, 8.280> <0.354, 0.374, 8.280> <0.378, 0.107, 8.280> <0.299, 0.996, 3.720> <0.299, 0.728, 3.720> <0.354, 0.374, 3.720> <0.378, 0.107, 3.720> <0.299, 0.996, 0.300> <0.299, 0.728, 0.300> <0.354, 0.374, 0.300> <0.378, 0.107, 0.300> }
  	bicubic_patch { type 1 flatness 0 u_steps 3 v_steps 3 <0.378, 0.107, 11.700> <2.631, 0.107, 11.700> <5.635, 0.107, 11.700> <7.889, 0.107, 11.700> <0.378, 0.107, 8.280> <2.631, 0.107, 8.280> <5.635, 0.107, 8.280> <7.889, 0.107, 8.280> <0.378, 0.107, 3.720> <2.631, 0.107, 3.720> <5.635, 0.107, 3.720> <7.889, 0.107, 3.720> <0.378, 0.107, 0.300> <2.631, 0.107, 0.300> <5.635, 0.107, 0.300> <7.889, 0.107, 0.300> }
    texture { necronomicon_pages }
  }
}
